
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include <png.h>
#include "fail.h"
#include "pngwrite.h"

void pngwrite( image_t *image, char* filename )
{
   png_structp png_ptr;
   png_infop info_ptr;
   
   /* create file */
   FILE *fp = (FILE*)0;

   if( !strcmp( filename, "-" ) )
   {
      fp = stdout;
   }
   else
   {
      /* create file */
      fp = fopen(filename, "wb");
   }

   if (!fp)
      fail("[pngwrite] File %s could not be opened for writing", filename);
   
   
   /* initialize stuff */
   png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
   
   if (!png_ptr)
      fail("[pngwrite] png_create_write_struct failed");
   
   info_ptr = png_create_info_struct(png_ptr);
   if (!info_ptr)
      fail("[pngwrite] png_create_info_struct failed");
   
   if (setjmp(png_jmpbuf(png_ptr)))
      fail("[pngwrite] Error during init_io");
   
   png_init_io(png_ptr, fp);
   
   
   /* write header */
   if (setjmp(png_jmpbuf(png_ptr)))
      fail("[pngwrite] Error during writing header");
   
   png_set_IHDR(png_ptr, info_ptr, image->width, image->height,
	        1, PNG_COLOR_TYPE_GRAY, PNG_INTERLACE_NONE,
	        PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);
   
   png_write_info(png_ptr, info_ptr);
   
   
   /* write bytes */
   if (setjmp(png_jmpbuf(png_ptr)))
      fail("[pngwrite] Error during writing bytes");
   
   png_write_image(png_ptr, image->rowps);
   
   
   /* end write */
   if (setjmp(png_jmpbuf(png_ptr)))
      fail("[pngwrite] Error during end of write");
   
   png_write_end(png_ptr, NULL);
   
   fclose(fp);
}
