/*	test_Hex_Coding

PIRL CVS ID: test_Hex_Coding.java,v 1.4 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.Authentication;


public class test_Hex_Coding
{

public static void main
	(
	String[]	args
	)
{
String
	expected_string = "000111FF",
	obtained_string;
byte[]
	expected_bytes = {0x00, 0x01, 0x11, (byte)0xFF},
	obtained_bytes;
boolean
	passed;

obtained_string = Authentication.Encode_Hex (expected_bytes);
passed = expected_string.equals (obtained_string);
System.out.println ((passed ? "PASS" : "FAIL") + ": Encode_Hex");
if (! passed)
	System.out.println
	("====> expected: >|" + expected_string + "|<\n"
	+"====> obtained: >|" + obtained_string + "|<");

obtained_bytes = Authentication.Decode_Hex (expected_string);
passed = true;
if (obtained_bytes.length != expected_bytes.length)
	passed = false;
else
	{
	for (int
			index = 0;
			index < obtained_bytes.length;
			index++)
		{
		if (obtained_bytes[index] != expected_bytes[index])
			{
			passed = false;
			break;
			}
		}
	}
System.out.println ((passed ? "PASS" : "FAIL") + ": Decode_Hex");
if (! passed)
	{
	System.out.print ("====> expected:");
	for (int
		index = 0;
		index < expected_bytes.length;
		index++)
		System.out.print
			(" " + Integer.toHexString ((int)expected_bytes[index] & 0xFF)
				.toUpperCase ());
	System.out.println ();

	System.out.print ("====> obtained:");
	for (int
		index = 0;
		index < obtained_bytes.length;
		index++)
		System.out.print
			(" " + Integer.toHexString ((int)obtained_bytes[index] & 0xFF)
				.toUpperCase ());
	System.out.println ();
	}

System.exit (0);
}


}
