#ifndef RFSREADER_H
#define RFSREADER_H

#include "ECPReader.h"
#include <time.h>

class CRFSReader :
	public CECPReader
{
public:
	CRFSReader(CReader *Owner,CBaseCommunication *Communicator);
	virtual ~CRFSReader(void);
	
	virtual CJ_RESULT CtSetContrast(EContrast eContrast,uint32_t *Result);

protected:
	virtual void SetHWString(char *String);
	virtual void GetProductString(uint8_t *Product);
	virtual bool ATRFilter(bool IsWarm,uint8_t Slot=0);
	virtual bool HastModulestoreInfo();
	virtual RSCT_IFD_RESULT _IfdPower(uint32_t Mode, uint8_t *ATR, uint32_t *ATR_Length, uint32_t Timeout,uint8_t Slot=0);
	virtual RSCT_IFD_RESULT IfdSetProtocol(uint32_t *Protocol,uint8_t Slot=0);
	virtual RSCT_IFD_RESULT _IfdTransmit(const uint8_t *cmd, uint16_t cmd_len,uint8_t *response,uint16_t *response_len,uint8_t Slot=0);	
   virtual RSCT_IFD_RESULT IfdVendor(uint32_t IoCtrlCode,uint8_t *Input,uint32_t InputLength,uint8_t *Output,uint32_t *OutputLength);
	virtual CJ_RESULT BuildReaderInfo();
	virtual uint32_t GetReadersInputBufferSize();
	virtual CJ_RESULT CtSetSilentMode(bool boolMode,bool *pboolMode,uint32_t *Result);
	virtual CJ_RESULT CtGetSilentMode(bool *pboolMode,uint32_t *Result);
	virtual bool PinDirectSupported();
	virtual CJ_RESULT SpecialLess3_0_41();
	virtual void DoInterruptCallback(uint8_t *Data, uint32_t ulDataLen);

	virtual CJ_RESULT CtSetMFT(const uint8_t *const pData, uint32_t DataLen, uint32_t *Result);
	virtual CJ_RESULT CtGetMFT(cj_MFT_Info *const pData, uint32_t *const pNumElemnts);
#ifdef WITH_SECODER_INFO_OVERRIDE
	bool hasReaderChipTanLicense(void);
	virtual CJ_RESULT KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr);
#endif
protected:
	clock_t m_last_insertation_time;
	bool m_b_Is_absent;

};

#endif

