/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SimulationUIValues.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose: 
//   Init utility for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SimulationUIValues::Init()
{
    ivalue = 0;
    enabled = true;

    SimulationUIValues::SelectAll();
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose: 
//   Copy utility for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SimulationUIValues::Copy(const SimulationUIValues &obj)
{
    host = obj.host;
    sim = obj.sim;
    name = obj.name;
    ivalue = obj.ivalue;
    svalue = obj.svalue;
    enabled = obj.enabled;

    SimulationUIValues::SelectAll();
}

// Type map format string
const char *SimulationUIValues::TypeMapFormatString = SIMULATIONUIVALUES_TMFS;
const AttributeGroup::private_tmfs_t SimulationUIValues::TmfsStruct = {SIMULATIONUIVALUES_TMFS};


// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose: 
//   Default constructor for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationUIValues::SimulationUIValues() : 
    AttributeSubject(SimulationUIValues::TypeMapFormatString)
{
    SimulationUIValues::Init();
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose: 
//   Constructor for the derived classes of SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationUIValues::SimulationUIValues(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SimulationUIValues::Init();
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose: 
//   Copy constructor for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationUIValues::SimulationUIValues(const SimulationUIValues &obj) : 
    AttributeSubject(SimulationUIValues::TypeMapFormatString)
{
    SimulationUIValues::Copy(obj);
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose: 
//   Copy constructor for derived classes of the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationUIValues::SimulationUIValues(const SimulationUIValues &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SimulationUIValues::Copy(obj);
}

// ****************************************************************************
// Method: SimulationUIValues::~SimulationUIValues
//
// Purpose: 
//   Destructor for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationUIValues::~SimulationUIValues()
{
    // nothing here
}

// ****************************************************************************
// Method: SimulationUIValues::operator = 
//
// Purpose: 
//   Assignment operator for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationUIValues& 
SimulationUIValues::operator = (const SimulationUIValues &obj)
{
    if (this == &obj) return *this;

    SimulationUIValues::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SimulationUIValues::operator == 
//
// Purpose: 
//   Comparison operator == for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationUIValues::operator == (const SimulationUIValues &obj) const
{
    // Create the return value
    return ((host == obj.host) &&
            (sim == obj.sim) &&
            (name == obj.name) &&
            (ivalue == obj.ivalue) &&
            (svalue == obj.svalue) &&
            (enabled == obj.enabled));
}

// ****************************************************************************
// Method: SimulationUIValues::operator != 
//
// Purpose: 
//   Comparison operator != for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationUIValues::operator != (const SimulationUIValues &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SimulationUIValues::TypeName
//
// Purpose: 
//   Type name method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SimulationUIValues::TypeName() const
{
    return "SimulationUIValues";
}

// ****************************************************************************
// Method: SimulationUIValues::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationUIValues::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SimulationUIValues *tmp = (const SimulationUIValues *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SimulationUIValues::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SimulationUIValues::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SimulationUIValues(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SimulationUIValues::NewInstance
//
// Purpose: 
//   NewInstance method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SimulationUIValues::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SimulationUIValues(*this);
    else
        retval = new SimulationUIValues;

    return retval;
}

// ****************************************************************************
// Method: SimulationUIValues::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SimulationUIValues::SelectAll()
{
    Select(ID_host,    (void *)&host);
    Select(ID_sim,     (void *)&sim);
    Select(ID_name,    (void *)&name);
    Select(ID_ivalue,  (void *)&ivalue);
    Select(ID_svalue,  (void *)&svalue);
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationUIValues::SetHost(const std::string &host_)
{
    host = host_;
    Select(ID_host, (void *)&host);
}

void
SimulationUIValues::SetSim(const std::string &sim_)
{
    sim = sim_;
    Select(ID_sim, (void *)&sim);
}

void
SimulationUIValues::SetName(const std::string &name_)
{
    name = name_;
    Select(ID_name, (void *)&name);
}

void
SimulationUIValues::SetIvalue(int ivalue_)
{
    ivalue = ivalue_;
    Select(ID_ivalue, (void *)&ivalue);
}

void
SimulationUIValues::SetSvalue(const std::string &svalue_)
{
    svalue = svalue_;
    Select(ID_svalue, (void *)&svalue);
}

void
SimulationUIValues::SetEnabled(bool enabled_)
{
    enabled = enabled_;
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SimulationUIValues::GetHost() const
{
    return host;
}

std::string &
SimulationUIValues::GetHost()
{
    return host;
}

const std::string &
SimulationUIValues::GetSim() const
{
    return sim;
}

std::string &
SimulationUIValues::GetSim()
{
    return sim;
}

const std::string &
SimulationUIValues::GetName() const
{
    return name;
}

std::string &
SimulationUIValues::GetName()
{
    return name;
}

int
SimulationUIValues::GetIvalue() const
{
    return ivalue;
}

const std::string &
SimulationUIValues::GetSvalue() const
{
    return svalue;
}

std::string &
SimulationUIValues::GetSvalue()
{
    return svalue;
}

bool
SimulationUIValues::GetEnabled() const
{
    return enabled;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationUIValues::SelectHost()
{
    Select(ID_host, (void *)&host);
}

void
SimulationUIValues::SelectSim()
{
    Select(ID_sim, (void *)&sim);
}

void
SimulationUIValues::SelectName()
{
    Select(ID_name, (void *)&name);
}

void
SimulationUIValues::SelectSvalue()
{
    Select(ID_svalue, (void *)&svalue);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

