//----------------------------------------------------------------------------
//
// License:  See top level LICENSE.txt file.
//
// Author:  David Burken
//
// Description:
// Application to generate ossim/include/ossim/ossimVersion.h file.
// This should be ran after generation of ossim/include/ossim/ossimConfig.h
// file but before anything else.
//
// Returns 0 on success, 1 on error.  Currently does not set error msg.
//
// $Id$
//----------------------------------------------------------------------------

#include <ctime>
#include <fstream>
#include <string>
#include <iostream>

/**
 * @brief main application for getting version / date and generating the
 * ossimVersion.h file.
 * 
 * @param argv[1] Path to ossim/include/ossim/ossimVersion.h
 *
 * @param argv[2] Version number string like "1.7.11"
 */
int main(int argc, char* argv[])
{
   enum
   {
      OK=0,
      ERROR=1
   };
   
   if (argc != 3)
   {
      return ERROR;
   }

   std::ofstream os(argv[1]);
   if (!os)
   {
      return ERROR;
   }

   // Get the version.  This is now passed in from the make file.
   std::string versionString = "Version ";
   versionString += argv[2];
   std::string versionNumber = argv[2];
   std::string majorVersion;
   std::string minorVersion = "0";
   std::string releaseVersion = "0";
   std::string::size_type pos1 = std::string::npos;
   std::string::size_type pos2 = std::string::npos;
   std::string::size_type pos3 = std::string::npos;
   
   pos1 = versionNumber.find(".", 0);
   if(pos1 != std::string::npos)
   {
      majorVersion = std::string(versionNumber.begin(),
                                 versionNumber.begin()+pos1);
      pos2 = versionNumber.find(".", pos1+1);
      if(pos2 != std::string::npos)
      {
         minorVersion = std::string(versionNumber.begin()+pos1+1,
                                    versionNumber.begin()+pos2);
         releaseVersion = std::string(versionNumber.begin()+pos2+1,
                                      versionNumber.end());
      }
   }
   else
   {
      majorVersion = versionNumber;
   }
   // Get the build date in the format of (yyyymmdd).
   char s[11];
   s[10] = '\0';
   time_t t;
   time(&t);
   tm* lt = localtime(&t);
   strftime(s, 11, "(%Y%m%d)", lt);
   std::string date = s;

   // Write the header file.
   os << "// Auto generated by version-config - DO NOT EDIT\n"
      << "#ifndef ossimVersion_HEADER\n"
      << "#define ossimVersion_HEADER\n"
      << "\n"
      << "#include <ossim/ossimConfig.h>\n"
      << "\n"
      << "#ifndef OSSIM_VERSION\n"
      << "#  define OSSIM_VERSION " << "\"" << versionString << "\"\n"
      << "#  define OSSIM_VERSION_NUMBER " << "\"" << versionNumber << "\"\n"
      << "#  define OSSIM_MAJOR_VERSION_NUMBER " << majorVersion << "\n"
      << "#  define OSSIM_MINOR_VERSION_NUMBER " << minorVersion << "\n"
      << "#  define OSSIM_RELEASE_NUMBER " << releaseVersion << "\n"
      << "#endif\n"
      << "\n"
      << "// date format = (yyyymmdd)\n"
      << "#ifndef OSSIM_BUILD_DATE\n"
      << "#  define OSSIM_BUILD_DATE " << "\"" << date << "\"\n"
      << "#endif\n"
      << "\n"
      << "#endif /* End of #ifndef ossimVersion_HEADER */"
      << std::endl;
   
   os.close();
   
   std::cout << "wrote file: " << argv[1] << std::endl;

   return OK;
}
