var orsoncharts;if(!orsoncharts)orsoncharts={};orsoncharts.Utils={};orsoncharts.Utils.makeArrayOf=function(value,length){var arr=[],i=length;while(i--)arr[i]=value;return arr};orsoncharts.Utils.findChartRef=function(element){var id=element.getAttribute("jfreesvg:ref");var found=false;var current=element;while(!found){current=current.parentNode;if(current!=null){id=current.getAttribute("jfreesvg:ref");found=id!=null}else found=true}return id};
orsoncharts.Utils.findChartId=function(element){var id=null;var found=false;var current=element;while(!found){current=current.parentNode;if(current!=null){var ref=current.getAttribute("jfreesvg:ref");if(ref=="ORSON_CHART_TOP_LEVEL"){found=true;id=current.getAttribute("id")}}else found=true}return id};if(!orsoncharts)orsoncharts={};orsoncharts.KeyedValuesDataset=function(){if(!(this instanceof orsoncharts.KeyedValuesDataset))return new orsoncharts.KeyedValuesDataset;this.data=[];this.listeners=[]};orsoncharts.KeyedValuesDataset.prototype.itemCount=function(){return this.data.length};orsoncharts.KeyedValuesDataset.prototype.isEmpty=function(){return this.data.length===0};orsoncharts.KeyedValuesDataset.prototype.key=function(index){return this.data[index][0]};
orsoncharts.KeyedValuesDataset.prototype.keys=function(){return this.data.map(function(d){return d[0]})};orsoncharts.KeyedValuesDataset.prototype.indexOf=function(sectionKey){var arrayLength=this.data.length;for(var i=0;i<arrayLength;i++)if(this.data[i][0]===sectionKey)return i;return-1};orsoncharts.KeyedValuesDataset.prototype.valueByIndex=function(index){return this.data[index][1]};
orsoncharts.KeyedValuesDataset.prototype.valueByKey=function(sectionKey){var sectionIndex=this.indexOf(sectionKey);if(sectionIndex<0)return null;return this.valueByIndex(sectionIndex)};orsoncharts.KeyedValuesDataset.prototype.addListener=function(listenerMethod){this.listeners.push(listenerMethod)};orsoncharts.KeyedValuesDataset.prototype.removeListener=function(listenerMethod){var i=this.listeners.indexOf(listenerMethod);if(i>=0)this.listeners.splice(i,1)};
orsoncharts.KeyedValuesDataset.prototype.notifyListeners=function(){};orsoncharts.KeyedValuesDataset.prototype.add=function(sectionKey,value){this.data.push([sectionKey,value])};orsoncharts.KeyedValuesDataset.prototype.remove=function(sectionKey){if(!sectionKey)throw new Error("The 'sectionKey' must be defined.");var i=this.indexOf(sectionKey);if(i<0)throw new Error("The sectionKey '"+sectionKey.toString()+"' is not recognised.");this.data.splice(i,1)};
orsoncharts.KeyedValuesDataset.prototype.dataFromJSON=function(jsonStr){this.data=JSON.parse(jsonStr);this.notifyListeners()};orsoncharts.KeyedValuesDataset.prototype.removeByIndex=function(itemIndex){this.data.splice(itemIndex,1)};orsoncharts.KeyedValuesDataset.prototype.totalForDataset=function(dataset){var total=0;var itemCount=dataset.itemCount();for(var i=0;i<itemCount;i++){var v=dataset.valueByIndex(i);if(v)total=total+v}return total};
orsoncharts.KeyedValuesDataset.prototype.minForDataset=function(dataset){var min=null;var itemCount=dataset.itemCount();for(var i=0;i<itemCount;i++){var v=dataset.valueByIndex(i);if(v)if(min)min=Math.min(min,v);else min=v}return min};orsoncharts.KeyedValuesDataset.prototype.maxForDataset=function(dataset){var max=null;var itemCount=dataset.itemCount();for(var i=0;i<itemCount;i++){var v=dataset.valueByIndex(i);if(v)if(max)max=Math.max(max,v);else max=v}return max};
orsoncharts.KeyedValuesDataset.prototype.total=function(){return this.totalForDataset(this)};orsoncharts.KeyedValuesDataset.prototype.min=function(){return this.minForDataset(this)};orsoncharts.KeyedValuesDataset.prototype.max=function(){return this.maxForDataset(this)};if(!orsoncharts)orsoncharts={};orsoncharts.KeyedValues3DDataset=function(){if(!(this instanceof orsoncharts.KeyedValues3DDataset))return new orsoncharts.KeyedValues3DDataset;this.data={"columnKeys":[],"rowKeys":[],"series":[]};this.listeners=[]};orsoncharts.KeyedValues3DDataset.prototype.isEmpty=function(){return this.data["columnKeys"].length===0&&this.data["rowKeys"].length===0};orsoncharts.KeyedValues3DDataset.prototype.seriesCount=function(){return this.data.series.length};
orsoncharts.KeyedValues3DDataset.prototype.rowCount=function(){return this.data.rowKeys.length};orsoncharts.KeyedValues3DDataset.prototype.columnCount=function(){return this.data["columnKeys"].length};orsoncharts.KeyedValues3DDataset.prototype._fetchRow=function(seriesIndex,rowKey){var rows=this.data.series[seriesIndex].rows;for(var r=0;r<rows.length;r++)if(rows[r][0]===rowKey)return rows[r];return null};
orsoncharts.KeyedValues3DDataset.prototype.valueByIndex=function(seriesIndex,rowIndex,columnIndex){var rowKey=this.rowKey(rowIndex);var row=this._fetchRow(seriesIndex,rowKey);if(row===null)return null;else return row[1][columnIndex]};orsoncharts.KeyedValues3DDataset.prototype.seriesIndex=function(seriesKey){var seriesCount=this.seriesCount();for(var s=0;s<seriesCount;s++)if(this.data.series[s].seriesKey===seriesKey)return s;return-1};orsoncharts.KeyedValues3DDataset.prototype.seriesKey=function(seriesIndex){return this.data.series[seriesIndex].seriesKey};
orsoncharts.KeyedValues3DDataset.prototype.rowKey=function(rowIndex){return this.data.rowKeys[rowIndex]};orsoncharts.KeyedValues3DDataset.prototype.rowIndex=function(rowKey){var rowCount=this.data.rowKeys.length;for(var r=0;r<rowCount;r++)if(this.data.rowKeys[r]===rowKey)return r;return-1};orsoncharts.KeyedValues3DDataset.prototype.rowKeys=function(){return this.data.rowKeys.map(function(d){return d})};orsoncharts.KeyedValues3DDataset.prototype.columnKey=function(columnIndex){return this.data.columnKeys[columnIndex]};
orsoncharts.KeyedValues3DDataset.prototype.columnIndex=function(columnKey){var columnCount=this.data.columnKeys.length;for(var c=0;c<columnCount;c++)if(this.data.columnKeys[c]===columnKey)return c;return-1};orsoncharts.KeyedValues3DDataset.prototype.columnKeys=function(){return this.data.columnKeys.map(function(d){return d})};
orsoncharts.KeyedValues3DDataset.prototype.valueByKey=function(seriesKey,rowKey,columnKey){var seriesIndex=this.seriesIndex(seriesKey);var row=this._fetchRow(seriesIndex,rowKey);if(row===null)return null;else{var columnIndex=this.columnIndex(columnKey);return row[1][columnIndex]}};orsoncharts.KeyedValues3DDataset.prototype.addListener=function(listenerMethod){this.listeners.push(listenerMethod)};
orsoncharts.KeyedValues3DDataset.prototype.removeListener=function(listenerMethod){var i=this.listeners.indexOf(listenerMethod);if(i>=0)this.listeners.splice(i,1)};orsoncharts.KeyedValues3DDataset.prototype.notifyListeners=function(){};
orsoncharts.KeyedValues3DDataset.prototype.add=function(seriesKey,rowKey,columnKey,value){if(this.isEmpty()){this.data.rowKeys.push(rowKey);this.data.columnKeys.push(columnKey);this.data.series.push({"seriesKey":seriesKey,"rows":[[rowKey,[value]]]})}else{var seriesIndex=this.seriesIndex(seriesKey);if(seriesIndex<0){this.data.series.push({"seriesKey":seriesKey,"rows":[]});seriesIndex=this.data.series.length-1}var columnIndex=this.columnIndex(columnKey);if(columnIndex<0){this.data.columnKeys.push(columnKey);
for(var s=0;s<this.data.series.length;s++){var rows=this.data.series[s].rows;for(var r=0;r<rows.length;r++)rows[r][1].push(null)}columnIndex=this.columnCount()-1}var rowIndex=this.rowIndex(rowKey);if(rowIndex<0){this.data.rowKeys.push(rowKey);var rowData=orsoncharts.Utils.makeArrayOf(null,this.columnCount());rowData[columnIndex]=value;this.data.series[seriesIndex].rows.push([rowKey,rowData])}else{var row=this._fetchRow(seriesIndex,rowKey);if(row!==null)row[1][columnIndex]=value;else{var rowData=orsoncharts.Utils.makeArrayOf(null,
this.columnCount());rowData[columnIndex]=value;this.data.series[seriesIndex].rows.push([rowKey,rowData])}}}};orsoncharts.KeyedValues3DDataset.prototype.dataFromJSON=function(jsonStr){this.data=JSON.parse(jsonStr);if(!this.data.hasOwnProperty("rowKeys"))this.data.rowKeys=[];if(!this.data.hasOwnProperty("columnKeys"))this.data.columnKeys=[];if(!this.data.hasOwnProperty("series"))this.data.series=[];this.notifyListeners()};orsoncharts=orsoncharts?orsoncharts:{};orsoncharts.XYZDataset=function(){this.data={"series":[],"selections":[]};this.listeners=[]};orsoncharts.XYZDataset.prototype.seriesCount=function(){return this.data.series.length};orsoncharts.XYZDataset.prototype.seriesKeys=function(){return this.data.series.map(function(d){return d[0]})};orsoncharts.XYZDataset.prototype.seriesKey=function(seriesIndex){return this.data.series[seriesIndex][0]};
orsoncharts.XYZDataset.prototype.seriesIndex=function(seriesKey){if(!(typeof seriesKey==="string"))throw new Error("The 'seriesKey' must be a string.");var seriesArray=this.data.series;var seriesCount=this.data.series.length;for(var s=0;s<seriesCount;s++)if(seriesArray[s][0]===seriesKey)return s;return-1};orsoncharts.XYZDataset.prototype.itemCount=function(seriesIndex){return this.data.series[seriesIndex][1].length};orsoncharts.XYZDataset.prototype.x=function(seriesIndex,itemIndex){return this.data.series[seriesIndex][1][itemIndex][0]};
orsoncharts.XYZDataset.prototype.y=function(seriesIndex,itemIndex){return this.data.series[seriesIndex][1][itemIndex][1]};orsoncharts.XYZDataset.prototype.z=function(seriesIndex,itemIndex){return this.data.series[seriesIndex][1][itemIndex][2]};orsoncharts.XYZDataset.prototype.item=function(seriesIndex,itemIndex){return this.data.series[seriesIndex][1][itemIndex]};
orsoncharts.XYZDataset.prototype.add=function(seriesKey,x,y,z){if(!(typeof seriesKey==="string"))throw new Error("The 'seriesKey' must be a string.");var s=this.seriesIndex(seriesKey);if(s<0)this.addSeries(seriesKey);var series=this.data.series;series[series.length-1][1].push([x,y,z])};
orsoncharts.XYZDataset.prototype.addSeries=function(seriesKey){if(!(typeof seriesKey==="string"))throw new Error("The 'seriesKey' must be a string.");var s=this.seriesIndex(seriesKey);if(s>=0)throw new Error("There is already a series with the key '"+seriesKey);this.data["series"].push([seriesKey,[]])};
orsoncharts.XYZDataset.prototype.removeSeries=function(seriesKey){if(!(typeof seriesKey==="string"))throw new Error("The 'seriesKey' must be a string.");var s=this.seriesIndex(seriesKey);if(s>=0)this.data["series"].splice(s,1)};orsoncharts.XYZDataset.prototype.addListener=function(listenerMethod){this.listeners.push(listenerMethod)};orsoncharts.XYZDataset.prototype.removeListener=function(listenerMethod){var i=this.listeners.indexOf(listenerMethod);if(i>=0)this.listeners.splice(i,1)};if(!orsoncharts)orsoncharts={};orsoncharts.KeyedValueLabels=function(){if(!(this instanceof orsoncharts.KeyedValueLabels))return new orsoncharts.KeyedValueLabels;this.format="{K} = {V}";this.valueDP=2;this.percentDP=2};
orsoncharts.KeyedValueLabels.prototype.itemLabel=function(keyedValues,itemIndex){var labelStr=new String(this.format);var keyStr=keyedValues.key(itemIndex);var value=keyedValues.valueByIndex(itemIndex);var valueStr=value.toFixed(this.valueDP);var total=keyedValues.total();var percentStr=(value/total*100).toFixed(this.percentDP);labelStr=labelStr.replace(/{K}/g,keyStr);labelStr=labelStr.replace(/{V}/g,valueStr);labelStr=labelStr.replace(/{P}/g,percentStr);return labelStr};if(!orsoncharts)orsoncharts={};orsoncharts.KeyedValue3DLabels=function(){if(!(this instanceof orsoncharts.KeyedValue3DLabels))return new orsoncharts.KeyedValue3DLabels;this.format="{S}, {R}, {C} = {V}";this.valueDP=2};
orsoncharts.KeyedValue3DLabels.prototype.itemLabel=function(keyedValues3D,seriesIndex,rowIndex,columnIndex){var labelStr=new String(this.format);var seriesKeyStr=keyedValues3D.seriesKey(seriesIndex);var rowKeyStr=keyedValues3D.rowKey(rowIndex);var columnKeyStr=keyedValues3D.columnKey(columnIndex);var value=keyedValues3D.valueByIndex(seriesIndex,rowIndex,columnIndex);var valueStr=value.toFixed(this.valueDP);labelStr=labelStr.replace(/{S}/g,seriesKeyStr);labelStr=labelStr.replace(/{R}/g,rowKeyStr);
labelStr=labelStr.replace(/{C}/g,columnKeyStr);labelStr=labelStr.replace(/{V}/g,valueStr);return labelStr};if(!orsoncharts)orsoncharts={};orsoncharts.XYZLabels=function(){if(!(this instanceof orsoncharts.XYZLabels))return new orsoncharts.XYZLabels;this.format="{X}, {Y}, {Z} / {S}";this.xDP=2;this.yDP=2;this.zDP=2};
orsoncharts.XYZLabels.prototype.itemLabel=function(dataset,seriesKey,itemIndex){var labelStr=new String(this.format);var seriesKeyStr=seriesKey;var seriesIndex=dataset.seriesIndex(seriesKey);var item=dataset.item(seriesIndex,itemIndex);var xStr=item[0].toFixed(this.xDP);var yStr=item[1].toFixed(this.yDP);var zStr=item[2].toFixed(this.zDP);labelStr=labelStr.replace(/{X}/g,xStr);labelStr=labelStr.replace(/{Y}/g,yStr);labelStr=labelStr.replace(/{Z}/g,zStr);labelStr=labelStr.replace(/{S}/g,seriesKeyStr);
return labelStr};
