//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

function shouldThrow(func, message) {
    var error = null;
    try {
        func();
    } catch (e) {
        error = e;
    }
    if (!error)
        throw new Error("not thrown.");
    if (String(error) !== message)
        throw new Error("bad error: " + String(error));
}

/*
wasm/linear-memory.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, imports, buffer) {
    "use asm";

    var fround = global.Math.fround;
    var int8Array = new global.Int8Array(buffer);
    var uint8Array = new global.Uint8Array(buffer);
    var int16Array = new global.Int16Array(buffer);
    var uint16Array = new global.Uint16Array(buffer);
    var int32Array = new global.Int32Array(buffer);
    var float32Array = new global.Float32Array(buffer);
    var float64Array = new global.Float64Array(buffer);

    function getInt8(i) {
        i = i | 0;
        return int8Array[i] | 0;
    }

    function getUint8(i) {
        i = i | 0;
        return uint8Array[i] | 0;
    }

    function getInt16(i) {
        i = i | 0;
        return int16Array[i >> 1] | 0;
    }

    function getUint16(i) {
        i = i | 0;
        return uint16Array[i >> 1] | 0;
    }

    function getInt32(i) {
        i = i | 0;
        return int32Array[i >> 2] | 0;
    }

    function getFloat32(i) {
        i = i | 0;
        return fround(float32Array[i >> 2]);
    }

    function getFloat64(i) {
        i = i | 0;
        return +float64Array[i >> 3];
    }

    function setInt8(i, x) {
        i = i | 0;
        x = x | 0;
        int8Array[i] = x;
    }

    function setUint8(i, x) {
        i = i | 0;
        x = x | 0;
        uint8Array[i] = x;
    }

    function setInt16(i, x) {
        i = i | 0;
        x = x | 0;
        int16Array[i >> 1] = x;
    }

    function setUint16(i, x) {
        i = i | 0;
        x = x | 0;
        uint16Array[i >> 1] = x;
    }

    function setInt32(i, x) {
        i = i | 0;
        x = x | 0;
        int32Array[i >> 2] = x;
    }

    function setFloat32(i, x) {
        i = i | 0;
        x = fround(x);
        float32Array[i >> 2] = x;
    }

    function setFloat64(i, x) {
        i = i | 0;
        x = +x;
        float64Array[i >> 3] = x;
    }

    function setInt8Expression(i, x) {
        i = i | 0;
        x = x | 0;
        return (int8Array[i] = x) | 0;
    }

    function setUint8Expression(i, x) {
        i = i | 0;
        x = x | 0;
        return (uint8Array[i] = x) | 0;
    }

    function setInt16Expression(i, x) {
        i = i | 0;
        x = x | 0;
        return (int16Array[i >> 1] = x) | 0;
    }

    function setUint16Expression(i, x) {
        i = i | 0;
        x = x | 0;
        return (uint16Array[i >> 1] = x) | 0;
    }

    function setInt32Expression(i, x) {
        i = i | 0;
        x = x | 0;
        return (int32Array[i >> 2] = x) | 0;
    }

    function setFloat32Expression(i, x) {
        i = i | 0;
        x = fround(x);
        return float32Array[i >> 2] = x;
    }

    function setFloat64Expression(i, x) {
        i = i | 0;
        x = +x;
        return float64Array[i >> 3] = x;
    }

    return {
        getInt8: getInt8,
        getUint8: getUint8,
        getInt16: getInt16,
        getUint16: getUint16,
        getInt32: getInt32,
        getFloat32: getFloat32,
        getFloat64: getFloat64,

        setInt8: setInt8,
        setUint8: setUint8,
        setInt16: setInt16,
        setUint16: setUint16,
        setInt32: setInt32,
        setFloat32: setFloat32,
        setFloat64: setFloat64,

        setInt8Expression: setInt8Expression,
        setUint8Expression: setUint8Expression,
        setInt16Expression: setInt16Expression,
        setUint16Expression: setUint16Expression,
        setInt32Expression: setInt32Expression,
        setFloat32Expression: setFloat32Expression,
        setFloat64Expression: setFloat64Expression,
    };
}
*/

var buffer = new ArrayBuffer(16);
var module = loadWebAssembly("wasm/linear-memory.wasm", { }, buffer);

var int32Array = new Int32Array(buffer);

// Basic gets and sets.
module.setInt8(0, 1);
shouldBe(module.getInt8(0), 1);
module.setUint8(0, 2);
shouldBe(module.getUint8(0), 2);
module.setInt16(0, 3);
shouldBe(module.getInt16(0), 3);
module.setUint16(0, 4);
shouldBe(module.getUint16(0), 4);
module.setInt32(0, 5);
shouldBe(module.getInt32(0), 5);
module.setFloat32(0, 6.7);
shouldBe(module.getFloat32(0), 6.699999809265137);
module.setFloat64(0, 8.9);
shouldBe(module.getFloat64(0), 8.9);

int32Array[0] = 0x00FFFF00;
shouldBe(module.getUint8(0), 0);
shouldBe(module.getUint8(1), 255);
shouldBe(module.getUint8(2), 255);
shouldBe(module.getUint8(3), 0);

// Type punning.
module.setInt8(0, -1);
shouldBe(module.getInt8(0), -1);
shouldBe(module.getUint8(0), 255);

module.setInt8(1, -1);
shouldBe(module.getInt8(1), -1);
shouldBe(module.getUint8(1), 255);
shouldBe(module.getInt16(0), -1);
shouldBe(module.getUint16(0), 65535);

// Out-of-bound accesses.
module.getInt8(15);
shouldThrow(() => {
    module.getInt8(16);
}, "Error: Out-of-bounds access.");
shouldThrow(() => {
    module.getInt8(-1);
}, "Error: Out-of-bounds access.");

// Unaligned accesses
int32Array[0] = 0;
int32Array[1] = 0x01234567;
int32Array[2] = 0;
shouldBe(module.getInt32(3), 0);
shouldBe(module.getInt32(4), 0x01234567);
shouldBe(module.getInt32(5), 0x01234567);
shouldBe(module.getInt32(6), 0x01234567);
shouldBe(module.getInt32(7), 0x01234567);
shouldBe(module.getInt32(8), 0);

int32Array[0] = 0;
int32Array[1] = 0;
int32Array[2] = 0;
module.setInt32(3, 1);
shouldBe(int32Array[0] == 1 && int32Array[1] == 0 && int32Array[2] == 0, true);
module.setInt32(4, 2);
shouldBe(int32Array[0] == 1 && int32Array[1] == 2 && int32Array[2] == 0, true);
module.setInt32(5, 3);
shouldBe(int32Array[0] == 1 && int32Array[1] == 3 && int32Array[2] == 0, true);
module.setInt32(6, 4);
shouldBe(int32Array[0] == 1 && int32Array[1] == 4 && int32Array[2] == 0, true);
module.setInt32(7, 5);
shouldBe(int32Array[0] == 1 && int32Array[1] == 5 && int32Array[2] == 0, true);
module.setInt32(8, 6);
shouldBe(int32Array[0] == 1 && int32Array[1] == 5 && int32Array[2] == 6, true);

// Store expressions.
shouldBe(module.setInt8Expression(0, 1), 1);
shouldBe(module.getInt8(0), 1);
shouldBe(module.setUint8Expression(0, -1), -1);
shouldBe(module.getUint8(0), 255);
shouldBe(module.setInt16Expression(0, 2), 2);
shouldBe(module.getInt16(0), 2);
shouldBe(module.setUint16Expression(0, -1), -1);
shouldBe(module.getUint16(0), 65535);
shouldBe(module.setInt32Expression(0, 3), 3);
shouldBe(module.getInt32(0), 3);
shouldBe(module.setFloat32Expression(0, 4.2), 4.199999809265137);
shouldBe(module.getFloat32(0), 4.199999809265137);
shouldBe(module.setFloat64Expression(0, 4.2), 4.2);
shouldBe(module.getFloat64(0), 4.2);
