/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTONSYSTEMACCESS_H_
#define OPENDRIM_ACCOUNTONSYSTEMACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_AccountOnSystem.h"
#include "assocOpenDRIM_AccountOnSystem.h"

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AccountOnSystem>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AccountOnSystem& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountOnSystem& newInstance, const OpenDRIM_AccountOnSystem& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountOnSystem& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountOnSystem& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_AccountOnSystem>& OpenDRIM_AccountOnSystem_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_AccountOnSystem>& OpenDRIM_AccountOnSystem_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountOnSystem_populate(OpenDRIM_AccountOnSystem& instance, string& errorMessage);

#endif /*OPENDRIM_ACCOUNTONSYSTEMACCESS_H_*/
