// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectExplore_HeaderFile
#define _IFSelect_SelectExplore_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_SelectExplore.hxx>

#include <Standard_Integer.hxx>
#include <IFSelect_SelectDeduct.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Standard_Transient.hxx>
class Interface_EntityIterator;
class Interface_Graph;
class Standard_Transient;
class TCollection_AsciiString;


//! A SelectExplore determines from an input list of Entities,
//! a list obtained by a way of exploration. This implies the
//! possibility of recursive exploration : the output list is
//! itself reused as input, etc...
//! Examples : Shared Entities, can be considered at one level
//! (immediate shared) or more, or max level
//!
//! Then, for each input entity, if it is not rejected, it can be
//! either taken itself, or explored : it then produces a list.
//! According to a level, either the produced lists or taken
//! entities give the result (level one), or lists are themselves
//! considered and for each item, is it taken or explored.
//!
//! Remark that rejection is just a safety : normally, an input
//! entity is, either taken itself, or explored
//! A maximum level can be specified. Else, the process continues
//! until all entities have been either taken or rejected
class IFSelect_SelectExplore : public IFSelect_SelectDeduct
{

public:

  
  //! Returns the required exploring level
  Standard_EXPORT   Standard_Integer Level()  const;
  
  //! Returns the list of selected entities. Works by calling the
  //! method Explore on each input entity : it can be rejected,
  //! taken for output, or to explore. If the maximum level has not
  //! yet been attained, or if no max level is specified, entities
  //! to be explored are themselves used as if they were input
  Standard_EXPORT   Interface_EntityIterator RootResult (const Interface_Graph& G)  const;
  
  //! Analyses and, if required, Explores an entity, as follows :
  //! The explored list starts as empty, it has to be filled by this
  //! method.
  //! If it returns False, <ent> is rejected for result (this is to
  //! be used only as safety)
  //! If it returns True and <explored> remains empty, <ent> is
  //! taken itself for result, not explored
  //! If it returns True and <explored> is not empty, the content
  //! of this list is considered :
  //! If maximum level is attained, it is taken for result
  //! Else (or no max), each of its entity will be itself explored
  Standard_EXPORT virtual   Standard_Boolean Explore (const Standard_Integer level, const Handle(Standard_Transient)& ent, const Interface_Graph& G, Interface_EntityIterator& explored)  const = 0;
  
  //! Returns a text saying "(Recursive)" or "(Level nn)" plus
  //! specific criterium returned by ExploreLabel (see below)
  Standard_EXPORT   TCollection_AsciiString Label()  const;
  
  //! Returns a text defining the way of exploration
  Standard_EXPORT virtual   TCollection_AsciiString ExploreLabel()  const = 0;




  DEFINE_STANDARD_RTTI(IFSelect_SelectExplore)

protected:

  
  //! Initializes a SelectExplore : the level must be specified on
  //! starting. 0 means all levels, 1 means level one only, etc...
  Standard_EXPORT IFSelect_SelectExplore(const Standard_Integer level);



private: 


  Standard_Integer thelevel;


};







#endif // _IFSelect_SelectExplore_HeaderFile
