/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class MGetMethod
extends XMLResponseMethodBase
implements DepthSupport {
    public static final int BY_NAME = 0;
    public static final int ALL = 1;
    public static final int NAMES = 2;
    protected int depth = Integer.MAX_VALUE;
    protected String prefix = null;

    public MGetMethod() {
    }

    public MGetMethod(String path) {
        super(path);
    }

    public MGetMethod(String path, int depth) {
        this(path);
        this.setDepth(depth);
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Depth")) {
            int depth = -1;
            if (headerValue.equals("0")) {
                depth = 0;
            }
            if (headerValue.equals("1")) {
                depth = 1;
            } else if (headerValue.equalsIgnoreCase("infinity")) {
                depth = Integer.MAX_VALUE;
            }
            this.setDepth(depth);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void setDepth(int depth) {
        this.checkNotUsed();
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void recycle() {
        super.recycle();
        this.prefix = null;
    }

    public String getName() {
        return "MGET";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
        switch (this.depth) {
            case 0: {
                super.setRequestHeader("Depth", "0");
                break;
            }
            case 1: {
                super.setRequestHeader("Depth", "1");
                break;
            }
            case 0x7FFFFFFF: {
                super.setRequestHeader("Depth", "infinity");
            }
        }
    }

    protected String generateRequestBody() {
        return "";
    }

    public Enumeration getAllResponseURLs() {
        this.checkUsed();
        return this.getResponseURLs().elements();
    }

    public Enumeration getResponseProperties(String urlPath, Vector properties) {
        this.checkUsed();
        XMLResponseMethodBase.Response response = (XMLResponseMethodBase.Response)this.getResponseHashtable().get(urlPath);
        if (response != null) {
            return response.getRDFProperties(properties);
        }
        return new Vector().elements();
    }
}

