/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import org.apache.turbine.util.Log;
import org.chefproject.core.User;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.PortalService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UserDirectoryService;

public class DefaultId {
    public static final String COLLECTION_USER = "/user/";
    public static final String COLLECTION_GROUP = "/group/";
    public static final String COLLECTION_NONE = "/none/";

    public static String getCollection() {
        return DefaultId.getCollection(PortalService.getCurrentSiteId());
    }

    public static String getCollection(String site) {
        String rv = COLLECTION_NONE;
        if (SiteService.isUserSite(site)) {
            rv = COLLECTION_USER + SiteService.getSiteUserId(site) + "/";
        } else if (!SiteService.isSpecialSite(site)) {
            rv = COLLECTION_GROUP + site + "/";
        }
        return rv;
    }

    public static String getDisplayName() {
        return DefaultId.getDisplayName(PortalService.getCurrentSiteId());
    }

    public static String getDisplayName(String site) {
        String rv = null;
        if (SiteService.isUserSite(site)) {
            rv = SiteService.getSiteUserId(site);
            try {
                User u = UserDirectoryService.getUser(rv);
                rv = u.getDisplayName();
            }
            catch (IdUnusedException e) {
                Log.warn("chef", "DefaultId.getDisplayName() user not found: " + rv);
            }
        } else if (!SiteService.isSpecialSite(site)) {
            rv = site;
        }
        return rv;
    }

    static {
        COLLECTION_USER = COLLECTION_USER;
        COLLECTION_GROUP = COLLECTION_GROUP;
        COLLECTION_NONE = COLLECTION_NONE;
    }
}

