/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericCalendarService;
import org.chefproject.util.CalendarEventVector;
import org.chefproject.util.TimeRange;

public class CalendarService {
    protected static GenericCalendarService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericCalendarService)((Object)TurbineServices.getInstance().getService(GenericCalendarService.SERVICE_NAME))) == null) {
            Log.warn("chef", "CalendarService.find: missing service: " + GenericCalendarService.SERVICE_NAME);
        }
    }

    public static GenericCalendarService getInstance() {
        CalendarService.find();
        return M_service;
    }

    public static List getCalendars() {
        CalendarService.find();
        return M_service.getCalendars();
    }

    public static boolean allowAddCalendar(String ref) {
        CalendarService.find();
        return M_service.allowAddCalendar(ref);
    }

    public static CalendarEdit addCalendar(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        CalendarService.find();
        return M_service.addCalendar(ref);
    }

    public static boolean allowGetCalendar(String ref) {
        CalendarService.find();
        return M_service.allowGetCalendar(ref);
    }

    public static Calendar getCalendar(String ref) throws IdUnusedException, PermissionException {
        CalendarService.find();
        return M_service.getCalendar(ref);
    }

    public static boolean allowUpdateCalendar(String ref) {
        CalendarService.find();
        return M_service.allowUpdateCalendar(ref);
    }

    public static CalendarEdit editCalendar(String ref) throws IdUnusedException, PermissionException, InUseException {
        CalendarService.find();
        return M_service.editCalendar(ref);
    }

    public static void commitCalendar(CalendarEdit edit) {
        CalendarService.find();
        M_service.commitCalendar(edit);
    }

    public static void cancelCalendar(CalendarEdit edit) {
        CalendarService.find();
        M_service.cancelCalendar(edit);
    }

    public static void removeCalendar(CalendarEdit edit) throws PermissionException {
        CalendarService.find();
        M_service.removeCalendar(edit);
    }

    public static boolean allowRemoveCalendar(String ref) {
        CalendarService.find();
        return M_service.allowRemoveCalendar(ref);
    }

    public static String calendarReference(String context, String id) {
        CalendarService.find();
        return M_service.calendarReference(context, id);
    }

    public static String eventReference(String context, String calendarId, String id) {
        CalendarService.find();
        return M_service.eventReference(context, calendarId, id);
    }

    public static CalendarEventVector getEvents(List references, TimeRange range) {
        CalendarService.find();
        return M_service.getEvents(references, range);
    }
}

