/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.turbine.services.BaseInitable;
import org.apache.turbine.services.Initable;
import org.apache.turbine.services.InitableBroker;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.util.TurbineException;

public abstract class BaseInitableBroker
implements InitableBroker {
    protected Hashtable initables = new Hashtable();
    protected Stack stack = new Stack();

    public void initClass(String className, Object data) throws InitializationException {
        Stack stack = this.stack;
        synchronized (stack) {
            block7: {
                int pos = this.stack.search(className);
                if (pos != -1) {
                    StringBuffer msg = new StringBuffer().append(className).append(" couldn't be initialized because of circular depency chain:\n");
                    int i = pos;
                    while (i > 0) {
                        msg.append((String)this.stack.elementAt(this.stack.size() - i - 1) + "->");
                        --i;
                    }
                    msg.append(className).append('\n');
                    throw new InitializationException(msg.toString());
                }
                try {
                    this.stack.push(className);
                    Initable instance = this.getInitableInstance(className);
                    if (instance.getInit()) break block7;
                    instance.init(data);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.stack.pop();
                    throw throwable;
                }
            }
            Object var7_8 = null;
            this.stack.pop();
        }
    }

    public void shutdownClass(String className) {
        try {
            Initable initable = this.getInitableInstance(className);
            if (initable.getInit()) {
                initable.shutdown();
                ((BaseInitable)initable).setInit(false);
            }
        }
        catch (InstantiationException e) {
            this.error(new TurbineException("Shutdown of a nonexistent class " + className + " was requested", e));
        }
    }

    public Initable getInitable(String className) throws InstantiationException {
        try {
            Initable initable = this.getInitableInstance(className);
            if (!initable.getInit()) {
                Class<?> clazz = initable.getClass();
                synchronized (clazz) {
                    if (!initable.getInit()) {
                        initable.init();
                    }
                    if (!initable.getInit()) {
                        throw new InitializationException("init() failed to initialize class " + className);
                    }
                }
            }
            return initable;
        }
        catch (InitializationException e) {
            throw new InstantiationException("Class " + className + " failed to initialize", e);
        }
    }

    protected Initable getInitableInstance(String className) throws InstantiationException {
        Initable initable = (Initable)this.initables.get(className);
        if (initable == null) {
            try {
                initable = (Initable)Class.forName(className).newInstance();
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (OutOfMemoryError t) {
                throw t;
            }
            catch (Throwable t) {
                String msg = null;
                msg = t instanceof NoClassDefFoundError ? "A class referenced by " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassNotFoundException ? "Class " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassCastException ? "Class " + className + " doesn't implement Initable." : "Failed to instantiate " + className));
                throw new InstantiationException(msg, t);
            }
            initable.setInitableBroker(this);
            this.initables.put(className, initable);
        }
        return initable;
    }

    public void notice(String msg) {
        System.err.println("[" + new Date().toString() + "] " + msg);
    }

    public void error(Throwable t) {
        t.printStackTrace(System.err);
    }

    protected BaseInitableBroker() {
    }
}

