/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_MAIN_WIDGET_HPP_INCLUDED
#define yf_MAIN_WIDGET_HPP_INCLUDED

#include <QWidget>

#include <yf/defs.hpp>

class QLabel;
class QPushButton;
class QLCDNumber;
class QAction;

class KeyboardWidget;
class RichBoxWidget;
class UserProfile;
class Fortune;
class ExerciseResult;

class MainWidget: public QWidget
{
	Q_OBJECT

 public:
	MainWidget(const UserProfile& config, QWidget* parent = NULL);

 signals:
	void typedSymbol();
	void errorOnSymbol();
	void startExercise();
	void terminateExercise();

 public slots:
	void displayWaitMessage(int);
	void startTyping(const QString& text, const QString& author);
	void endTyping();
	void tooManyMistakes();
	void maxMistakeCount(int maxCount);
	void mistakeCount(int mistakesCount);
	void exerciseFinished(const ExerciseResult& exerciseResult);
	void writeGuiSettings();

 private slots:
	void timerInterrupt();
	void onNextSymbol();
	void showStats();

 private:
	const UserProfile& profile;

	KeyboardWidget* keyboardWidget;
	RichBoxWidget* richBoxWidget;
	QPushButton* startButton;
	QPushButton* stopButton;
	QPushButton* statsButton;
	QPushButton* endButton;
	QLCDNumber* mistakesLCD;
	QLCDNumber* maxMistakesLCD;
	QLCDNumber* speedLCD;
	QLCDNumber* timeLCD;

	QTimer* timer;
	size_t millisecs;
	size_t symbolsWritten;

	void keyPressEvent(QKeyEvent* event);
	void closeEvent(QCloseEvent* event);

	void setTimeLabel(uint32 millisecs);
	void setSpeedLabel();
	void setDefaultState();

	void readGuiSettings();
};

#endif // yf_MAIN_WIDGET_HPP_INCLUDED

