/* $Id: BVector_data.hpp 428967 2014-03-10 16:26:03Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BVector_data.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: BVector_data_.hpp


#ifndef OBJECTS_SEQTABLE_BVECTOR_DATA_HPP
#define OBJECTS_SEQTABLE_BVECTOR_DATA_HPP


// generated includes
#include <objects/seqtable/BVector_data_.hpp>

#include <util/bitset/ncbi_bitset.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CBVector_data : public CBVector_data_Base
{
    typedef CBVector_data_Base Tparent;
public:
    // constructor
    CBVector_data(void);
    // destructor
    ~CBVector_data(void);

    // Overload base setters to reset extra data fields
    void Reset(void);

    void SetSize(const TSize& size);

    // set data from bvector object
    // the ownership of the bvector object is taken,
    // and the bvector should not be changed outside
    void SetBitVector(const bm::bvector<>* bv);

    // return bvector object, create it if necessary from serialized data
    const bm::bvector<>& GetBitVector(void) const {
        if ( !m_BitVector ) {
            x_CreateBitVector();
        }
        return *m_BitVector;
    }

    // remove cached bvector object
    void ResetBitVector(void);

protected:
    void x_CreateBitVector(void) const;

    mutable AutoPtr<const bm::bvector<> > m_BitVector;

private:
    // Prohibit copy constructor and assignment operator
    CBVector_data(const CBVector_data& value);
    CBVector_data& operator=(const CBVector_data& value);

};

/////////////////// CBVector_data inline methods

// constructor
inline
CBVector_data::CBVector_data(void)
{
}


/////////////////// end of CBVector_data inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_BVECTOR_DATA_HPP
/* Original file checksum: lines: 86, chars: 2474, CRC32: d5fe6c20 */
