/* Preferences.c generated by valac 0.28.1, the Vala compiler
 * generated from Preferences.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>


#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
typedef struct _PreferencesPrivate PreferencesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _Preferences {
	GObject parent_instance;
	PreferencesPrivate * priv;
};

struct _PreferencesClass {
	GObjectClass parent_class;
};

struct _PreferencesPrivate {
	gboolean _useSystemMonospaceFont;
	gchar* _font;
	gchar* _fontColor;
	gchar* _backgroundColor;
	gchar* _highlightColor;
	gboolean _recordLaunch;
	gboolean _enableTimeout;
	gint _timeout;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer preferences_parent_class = NULL;
extern gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT;
gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT = TRUE;
extern gchar* preferences_DEFAULT_FONT;
gchar* preferences_DEFAULT_FONT = NULL;
extern gchar* preferences_DEFAULT_FONT_COLOR;
gchar* preferences_DEFAULT_FONT_COLOR = NULL;
extern gchar* preferences_DEFAULT_BACKGROUND_COLOR;
gchar* preferences_DEFAULT_BACKGROUND_COLOR = NULL;
extern gchar* preferences_DEFAULT_HIGHLIGHT_COLOR;
gchar* preferences_DEFAULT_HIGHLIGHT_COLOR = NULL;
extern gboolean preferences_DEFAULT_RECORD_LAUNCH;
gboolean preferences_DEFAULT_RECORD_LAUNCH = TRUE;

GType preferences_get_type (void) G_GNUC_CONST;
#define PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES, PreferencesPrivate))
enum  {
	PREFERENCES_DUMMY_PROPERTY,
	PREFERENCES_USE_SYSTEM_MONOSPACE_FONT,
	PREFERENCES_FONT,
	PREFERENCES_FONT_COLOR,
	PREFERENCES_BACKGROUND_COLOR,
	PREFERENCES_HIGHLIGHT_COLOR,
	PREFERENCES_RECORD_LAUNCH,
	PREFERENCES_ENABLE_TIMEOUT,
	PREFERENCES_TIMEOUT
};
Preferences* preferences_new (gboolean useSystemMonospaceFont, const gchar* font, const gchar* fontColor, const gchar* backgroundColor, const gchar* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const gchar* font, const gchar* fontColor, const gchar* backgroundColor, const gchar* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
gchar* preferences_getSystemDefaultMonospaceFont (void);
void preferences_getGdkColor (const gchar* color, GdkColor* result);
void preferences_toString (Preferences* self);
gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
const gchar* preferences_get_font (Preferences* self);
const gchar* preferences_get_fontColor (Preferences* self);
const gchar* preferences_get_backgroundColor (Preferences* self);
const gchar* preferences_get_highlightColor (Preferences* self);
gboolean preferences_get_recordLaunch (Preferences* self);
GType profile_get_type (void) G_GNUC_CONST;
void preferences_saveToProfile (Preferences* self, Profile* profile);
gboolean preferences_get_enableTimeout (Preferences* self);
gint preferences_get_timeout (Preferences* self);
Preferences* preferences_loadFromProfile (Profile* profile);
gboolean mo_utils_getKeyBoolean (Profile* profile, const gchar* group, const gchar* key, gboolean default_val);
gchar* mo_utils_getKeyString (Profile* profile, const gchar* group, const gchar* key);
gint mo_utils_getKeyInteger (Profile* profile, const gchar* group, const gchar* key, gint default_val);
static void preferences_set_useSystemMonospaceFont (Preferences* self, gboolean value);
static void preferences_set_font (Preferences* self, const gchar* value);
static void preferences_set_fontColor (Preferences* self, const gchar* value);
static void preferences_set_backgroundColor (Preferences* self, const gchar* value);
static void preferences_set_highlightColor (Preferences* self, const gchar* value);
static void preferences_set_recordLaunch (Preferences* self, gboolean value);
static void preferences_set_enableTimeout (Preferences* self, gboolean value);
static void preferences_set_timeout (Preferences* self, gint value);
static GObject * preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void preferences_finalize (GObject* obj);
static void _vala_preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const gchar* font, const gchar* fontColor, const gchar* backgroundColor, const gchar* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout) {
	Preferences * self = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	_tmp0_ = useSystemMonospaceFont;
	_tmp1_ = font;
	_tmp2_ = recordLaunch;
	_tmp3_ = fontColor;
	_tmp4_ = backgroundColor;
	_tmp5_ = highlightColor;
	_tmp6_ = enableTimeout;
	_tmp7_ = timeout;
	self = (Preferences*) g_object_new (object_type, "useSystemMonospaceFont", _tmp0_, "font", _tmp1_, "recordLaunch", _tmp2_, "fontColor", _tmp3_, "backgroundColor", _tmp4_, "highlightColor", _tmp5_, "enableTimeout", _tmp6_, "timeout", _tmp7_, NULL);
	return self;
}


Preferences* preferences_new (gboolean useSystemMonospaceFont, const gchar* font, const gchar* fontColor, const gchar* backgroundColor, const gchar* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout) {
	return preferences_construct (TYPE_PREFERENCES, useSystemMonospaceFont, font, fontColor, backgroundColor, highlightColor, recordLaunch, enableTimeout, timeout);
}


gchar* preferences_getSystemDefaultMonospaceFont (void) {
	gchar* result = NULL;
	GSettings* settings = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* value = NULL;
	GSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "monospace-font-name");
	value = _tmp2_;
	_tmp3_ = value;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = _ ("Unable to retrieve system font setting");
		g_warning ("Preferences.vala:65: %s", _tmp4_);
		_tmp5_ = preferences_DEFAULT_FONT;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (value);
		value = _tmp6_;
	}
	result = value;
	_g_object_unref0 (settings);
	return result;
}


void preferences_getGdkColor (const gchar* color, GdkColor* result) {
	GdkColor c = {0};
	const gchar* _tmp0_ = NULL;
	GdkColor _tmp1_ = {0};
	g_return_if_fail (color != NULL);
	_tmp0_ = color;
	gdk_color_parse (_tmp0_, &_tmp1_);
	c = _tmp1_;
	*result = c;
	return;
}


void preferences_toString (Preferences* self) {
	FILE* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	FILE* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	FILE* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	FILE* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	FILE* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "useSystemMonospaceFont: ");
	_tmp1_ = self->priv->_useSystemMonospaceFont;
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "true\n");
	} else {
		FILE* _tmp3_ = NULL;
		_tmp3_ = stdout;
		fprintf (_tmp3_, "false\n");
	}
	_tmp4_ = stdout;
	_tmp5_ = self->priv->_font;
	fprintf (_tmp4_, "font: %s\n", _tmp5_);
	_tmp6_ = stdout;
	_tmp7_ = self->priv->_fontColor;
	fprintf (_tmp6_, "fontColor: %s\n", _tmp7_);
	_tmp8_ = stdout;
	_tmp9_ = self->priv->_backgroundColor;
	fprintf (_tmp8_, "backgroundColor: %s\n", _tmp9_);
	_tmp10_ = stdout;
	_tmp11_ = self->priv->_highlightColor;
	fprintf (_tmp10_, "highlightColor: %s\n", _tmp11_);
	_tmp12_ = stdout;
	fprintf (_tmp12_, "recordLaunch: ");
	_tmp13_ = self->priv->_recordLaunch;
	if (_tmp13_) {
		FILE* _tmp14_ = NULL;
		_tmp14_ = stdout;
		fprintf (_tmp14_, "true\n");
	} else {
		FILE* _tmp15_ = NULL;
		_tmp15_ = stdout;
		fprintf (_tmp15_, "false\n");
	}
}


void preferences_saveToProfile (Preferences* self, Profile* profile) {
	Profile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Profile* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	Profile* _tmp6_ = NULL;
	GKeyFile* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	Profile* _tmp9_ = NULL;
	GKeyFile* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	Profile* _tmp12_ = NULL;
	GKeyFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	Profile* _tmp15_ = NULL;
	GKeyFile* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	Profile* _tmp18_ = NULL;
	GKeyFile* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	Profile* _tmp21_ = NULL;
	GKeyFile* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	_tmp0_ = profile;
	_tmp1_ = _tmp0_->keyFile;
	_tmp2_ = self->priv->_useSystemMonospaceFont;
	g_key_file_set_boolean (_tmp1_, "preferences", "use_system_monospace_font", _tmp2_);
	_tmp3_ = profile;
	_tmp4_ = _tmp3_->keyFile;
	_tmp5_ = self->priv->_font;
	g_key_file_set_string (_tmp4_, "preferences", "font", _tmp5_);
	_tmp6_ = profile;
	_tmp7_ = _tmp6_->keyFile;
	_tmp8_ = self->priv->_fontColor;
	g_key_file_set_string (_tmp7_, "preferences", "font_color", _tmp8_);
	_tmp9_ = profile;
	_tmp10_ = _tmp9_->keyFile;
	_tmp11_ = self->priv->_backgroundColor;
	g_key_file_set_string (_tmp10_, "preferences", "background_color", _tmp11_);
	_tmp12_ = profile;
	_tmp13_ = _tmp12_->keyFile;
	_tmp14_ = self->priv->_highlightColor;
	g_key_file_set_string (_tmp13_, "preferences", "highlight_color", _tmp14_);
	_tmp15_ = profile;
	_tmp16_ = _tmp15_->keyFile;
	_tmp17_ = self->priv->_recordLaunch;
	g_key_file_set_boolean (_tmp16_, "preferences", "record_launch", _tmp17_);
	_tmp18_ = profile;
	_tmp19_ = _tmp18_->keyFile;
	_tmp20_ = self->priv->_enableTimeout;
	g_key_file_set_boolean (_tmp19_, "preferences", "enable_timeout", _tmp20_);
	_tmp21_ = profile;
	_tmp22_ = _tmp21_->keyFile;
	_tmp23_ = self->priv->_timeout;
	g_key_file_set_integer (_tmp22_, "preferences", "timeout", _tmp23_);
}


Preferences* preferences_loadFromProfile (Profile* profile) {
	Preferences* result = NULL;
	gboolean useSystemMonospaceFont = FALSE;
	gchar* font = NULL;
	gchar* fontColor = NULL;
	gchar* backgroundColor = NULL;
	gchar* highlightColor = NULL;
	gboolean recordLaunch = FALSE;
	gboolean enableTimeout = FALSE;
	gint timeout = 0;
	Profile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Profile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Profile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Profile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	Profile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	Profile* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	Profile* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	Profile* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	Preferences* _tmp21_ = NULL;
	g_return_val_if_fail (profile != NULL, NULL);
	font = NULL;
	fontColor = NULL;
	backgroundColor = NULL;
	highlightColor = NULL;
	_tmp0_ = profile;
	_tmp1_ = preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT;
	_tmp2_ = mo_utils_getKeyBoolean (_tmp0_, "preferences", "use_system_monospace_font", _tmp1_);
	useSystemMonospaceFont = _tmp2_;
	_tmp3_ = profile;
	_tmp4_ = mo_utils_getKeyString (_tmp3_, "preferences", "font");
	_g_free0 (font);
	font = _tmp4_;
	_tmp5_ = profile;
	_tmp6_ = mo_utils_getKeyString (_tmp5_, "preferences", "font_color");
	_g_free0 (fontColor);
	fontColor = _tmp6_;
	_tmp7_ = profile;
	_tmp8_ = mo_utils_getKeyString (_tmp7_, "preferences", "background_color");
	_g_free0 (backgroundColor);
	backgroundColor = _tmp8_;
	_tmp9_ = profile;
	_tmp10_ = mo_utils_getKeyString (_tmp9_, "preferences", "highlight_color");
	_g_free0 (highlightColor);
	highlightColor = _tmp10_;
	_tmp11_ = profile;
	_tmp12_ = mo_utils_getKeyBoolean (_tmp11_, "preferences", "record_launch", TRUE);
	recordLaunch = _tmp12_;
	_tmp13_ = profile;
	_tmp14_ = mo_utils_getKeyBoolean (_tmp13_, "preferences", "enable_timeout", FALSE);
	enableTimeout = _tmp14_;
	_tmp15_ = profile;
	_tmp16_ = mo_utils_getKeyInteger (_tmp15_, "preferences", "timeout", 30);
	timeout = _tmp16_;
	_tmp17_ = font;
	_tmp18_ = fontColor;
	_tmp19_ = backgroundColor;
	_tmp20_ = highlightColor;
	_tmp21_ = preferences_new (useSystemMonospaceFont, _tmp17_, _tmp18_, _tmp19_, _tmp20_, recordLaunch, enableTimeout, timeout);
	result = _tmp21_;
	_g_free0 (highlightColor);
	_g_free0 (backgroundColor);
	_g_free0 (fontColor);
	_g_free0 (font);
	return result;
}


gboolean preferences_get_useSystemMonospaceFont (Preferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_useSystemMonospaceFont;
	result = _tmp0_;
	return result;
}


static void preferences_set_useSystemMonospaceFont (Preferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_useSystemMonospaceFont = _tmp0_;
	g_object_notify ((GObject *) self, "useSystemMonospaceFont");
}


const gchar* preferences_get_font (Preferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font;
	result = _tmp0_;
	return result;
}


static void preferences_set_font (Preferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_font);
	self->priv->_font = _tmp1_;
	g_object_notify ((GObject *) self, "font");
}


const gchar* preferences_get_fontColor (Preferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fontColor;
	result = _tmp0_;
	return result;
}


static void preferences_set_fontColor (Preferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_fontColor);
	self->priv->_fontColor = _tmp1_;
	g_object_notify ((GObject *) self, "fontColor");
}


const gchar* preferences_get_backgroundColor (Preferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backgroundColor;
	result = _tmp0_;
	return result;
}


static void preferences_set_backgroundColor (Preferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_backgroundColor);
	self->priv->_backgroundColor = _tmp1_;
	g_object_notify ((GObject *) self, "backgroundColor");
}


const gchar* preferences_get_highlightColor (Preferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_highlightColor;
	result = _tmp0_;
	return result;
}


static void preferences_set_highlightColor (Preferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_highlightColor);
	self->priv->_highlightColor = _tmp1_;
	g_object_notify ((GObject *) self, "highlightColor");
}


gboolean preferences_get_recordLaunch (Preferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_recordLaunch;
	result = _tmp0_;
	return result;
}


static void preferences_set_recordLaunch (Preferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_recordLaunch = _tmp0_;
	g_object_notify ((GObject *) self, "recordLaunch");
}


gboolean preferences_get_enableTimeout (Preferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enableTimeout;
	result = _tmp0_;
	return result;
}


static void preferences_set_enableTimeout (Preferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_enableTimeout = _tmp0_;
	g_object_notify ((GObject *) self, "enableTimeout");
}


gint preferences_get_timeout (Preferences* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_timeout;
	result = _tmp0_;
	return result;
}


static void preferences_set_timeout (Preferences* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_timeout = _tmp0_;
	g_object_notify ((GObject *) self, "timeout");
}


static GObject * preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Preferences * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp6_ = NULL;
	parent_class = G_OBJECT_CLASS (preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES, Preferences);
	_tmp0_ = self->priv->_font;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = preferences_DEFAULT_FONT;
		preferences_set_font (self, _tmp1_);
	}
	_tmp2_ = self->priv->_fontColor;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = preferences_DEFAULT_FONT_COLOR;
		preferences_set_fontColor (self, _tmp3_);
	}
	_tmp4_ = self->priv->_backgroundColor;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = preferences_DEFAULT_BACKGROUND_COLOR;
		preferences_set_backgroundColor (self, _tmp5_);
	}
	_tmp6_ = self->priv->_highlightColor;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = preferences_DEFAULT_HIGHLIGHT_COLOR;
		preferences_set_highlightColor (self, _tmp7_);
	}
	return obj;
}


static void preferences_class_init (PreferencesClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_USE_SYSTEM_MONOSPACE_FONT, g_param_spec_boolean ("useSystemMonospaceFont", "useSystemMonospaceFont", "useSystemMonospaceFont", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT, g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT_COLOR, g_param_spec_string ("fontColor", "fontColor", "fontColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_BACKGROUND_COLOR, g_param_spec_string ("backgroundColor", "backgroundColor", "backgroundColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_HIGHLIGHT_COLOR, g_param_spec_string ("highlightColor", "highlightColor", "highlightColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_LAUNCH, g_param_spec_boolean ("recordLaunch", "recordLaunch", "recordLaunch", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_ENABLE_TIMEOUT, g_param_spec_boolean ("enableTimeout", "enableTimeout", "enableTimeout", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_TIMEOUT, g_param_spec_int ("timeout", "timeout", "timeout", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("Monospace 10");
	preferences_DEFAULT_FONT = _tmp0_;
	_tmp1_ = g_strdup ("black");
	preferences_DEFAULT_FONT_COLOR = _tmp1_;
	_tmp2_ = g_strdup ("white");
	preferences_DEFAULT_BACKGROUND_COLOR = _tmp2_;
	_tmp3_ = g_strdup ("#2020ff");
	preferences_DEFAULT_HIGHLIGHT_COLOR = _tmp3_;
}


static void preferences_instance_init (Preferences * self) {
	self->priv = PREFERENCES_GET_PRIVATE (self);
}


static void preferences_finalize (GObject* obj) {
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES, Preferences);
	_g_free0 (self->priv->_font);
	_g_free0 (self->priv->_fontColor);
	_g_free0 (self->priv->_backgroundColor);
	_g_free0 (self->priv->_highlightColor);
	G_OBJECT_CLASS (preferences_parent_class)->finalize (obj);
}


GType preferences_get_type (void) {
	static volatile gsize preferences_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preferences), 0, (GInstanceInitFunc) preferences_instance_init, NULL };
		GType preferences_type_id;
		preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "Preferences", &g_define_type_info, 0);
		g_once_init_leave (&preferences_type_id__volatile, preferences_type_id);
	}
	return preferences_type_id__volatile;
}


static void _vala_preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREFERENCES, Preferences);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT:
		g_value_set_boolean (value, preferences_get_useSystemMonospaceFont (self));
		break;
		case PREFERENCES_FONT:
		g_value_set_string (value, preferences_get_font (self));
		break;
		case PREFERENCES_FONT_COLOR:
		g_value_set_string (value, preferences_get_fontColor (self));
		break;
		case PREFERENCES_BACKGROUND_COLOR:
		g_value_set_string (value, preferences_get_backgroundColor (self));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR:
		g_value_set_string (value, preferences_get_highlightColor (self));
		break;
		case PREFERENCES_RECORD_LAUNCH:
		g_value_set_boolean (value, preferences_get_recordLaunch (self));
		break;
		case PREFERENCES_ENABLE_TIMEOUT:
		g_value_set_boolean (value, preferences_get_enableTimeout (self));
		break;
		case PREFERENCES_TIMEOUT:
		g_value_set_int (value, preferences_get_timeout (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREFERENCES, Preferences);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT:
		preferences_set_useSystemMonospaceFont (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_FONT:
		preferences_set_font (self, g_value_get_string (value));
		break;
		case PREFERENCES_FONT_COLOR:
		preferences_set_fontColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_BACKGROUND_COLOR:
		preferences_set_backgroundColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR:
		preferences_set_highlightColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_RECORD_LAUNCH:
		preferences_set_recordLaunch (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_ENABLE_TIMEOUT:
		preferences_set_enableTimeout (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_TIMEOUT:
		preferences_set_timeout (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



