/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQLineSelection_H
#define MvQLineSelection_H

#include <QBrush>
#include <QGraphicsItem>
#include <QPen>

#include "MvQPlotItem.h"

class MgQLayoutItem;

using namespace std;

class MvQLineSelection : public MvQPlotItem
{

Q_OBJECT

public:
	MvQLineSelection(MgQPlotScene*,MvQPlotView*,QGraphicsItem *parent=0);
	~MvQLineSelection();

	void paint(QPainter *, const QStyleOptionGraphicsItem*, QWidget*);
	QRectF boundingRect() const;

	void setLine(double,double,double,double);
	void clearLine();

	void setActivated(bool); 

	void mousePressEventFromView(QMouseEvent*);
	void mouseMoveEventFromView(QMouseEvent*);	
	void mouseReleaseEventFromView(QMouseEvent*);
	void reset();
	void changeDirection();

signals:
	void lineIsDefined(double,double,double,double);
	void lineIsUndefined();
	
protected:	
	enum CurrentAction {NoAction, DefineAction, ResizeAction, MoveAction};

	void updateHandles();	
	void checkEndPoint(QPointF&);
	void checkMoveDelta(QPointF&);
	bool checkPointInLineArea(QPointF &);
	void checkHandleSize() const;

	QPen		pen_;
	QBrush  	brush_;
	QLineF		line_;
	QPointF 	lineOrigin_;
	QList<QPointF> 	scenePoint_;
	QList<QPointF> 	coordPoint_;
	CurrentAction 	currentAction_;
	MgQLayoutItem*  zoomLayout_;
	QPointF 	dragPos_;
	
	bool 		showHandles_;
	QPen		selectionPen_;
	mutable QList<QRectF> 	handle_;
	mutable float 		handleSize_;
	mutable float 		physicalHandleSize_;
	int 		resizeId_;
	int 		handleHover_;

	mutable float 		arrowSize_;
	QBrush  	arrowBrush_;
	QPen  		arrowPen_;
};	


#endif
