/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MenuLine_H
#include "MenuLine.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif


#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif

#include <Xm/PushB.h>

#include <mars.h>

MenuLine::MenuLine(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UIMenuLine_c>(owner,param)
{
}

MenuLine::~MenuLine()
{
}

class MenuMaker : public ParameterScanner {

	const Parameter& param_;
	Widget    menu_;

	void next(const Parameter&, const char* first,const char* second);

public:
	MenuMaker(const Parameter& param,Widget menu) : param_(param), menu_(menu) {}
};

void MenuMaker::next(const Parameter&, const char* first,const char* second)
{
	Widget w = XmCreatePushButton(menu_,(char*)(second?second:first),0,0);
	XMLabel(w).set(param_.beautifiedName(first));
	XtManageChild(w);
}

void MenuLine::init(Widget w)
{
	XRequestPanelLine<UIMenuLine_c>::init(w);

	MenuMaker m(param_,menu_);
	param_.scan(m);
}

void MenuLine::refresh(const vector<string>& values)
{
	if(values.size()>0)
	{
		Widget w = XtNameToWidget(menu_,values[0].c_str());
		XtVaSetValues(option_,XmNmenuHistory,w,0);
	}
}

void MenuLine::activateCB(Widget,XtPointer data)
{
	XmRowColumnCallbackStruct *cb =(XmRowColumnCallbackStruct *) data;
	owner_.set(param_.name(),XtName(cb->widget));
}

static LineMaker<MenuLine> maker1("menu");
static LineMaker<MenuLine> maker2("option_menu");
