/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef GRL_MEDIA_SCANNER_SOURCE_H
#define GRL_MEDIA_SCANNER_SOURCE_H

// Grilo
#include <grilo.h>

#define GRL_MEDIA_SCANNER_PLUGIN_ID                 "grl-mediascanner"
#define GRL_MEDIA_SCANNER_CONFIG_INDEX_PATH         "index-path"
#define GRL_MEDIA_SCANNER_CONFIG_SEARCH_METHOD      "search-method"
#define GRL_MEDIA_SCANNER_CONFIG_SEARCH_SUBSTRING   "substring"
#define GRL_MEDIA_SCANNER_CONFIG_SEARCH_FULL_TEXT   "fulltext"

#define GRL_TYPE_MEDIA_SCANNER_SOURCE \
    (grl_media_scanner_source_get_type())

#define GRL_MEDIA_SCANNER_SOURCE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GRL_TYPE_MEDIA_SCANNER_SOURCE, \
                                       GrlMediaScannerSource))
#define GRL_IS_MEDIA_SCANNER_SOURCE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GRL_TYPE_MEDIA_SCANNER_SOURCE))
#define GRL_MEDIA_SCANNER_SOURCE_CLASS(cls) \
    (G_TYPE_CHECK_CLASS_CAST((cls), GRL_TYPE_MEDIA_SCANNER_SOURCE, \
                                    GrlMediaScannerSourceClass))
#define GRL_IS_MEDIA_SCANNER_SOURCE_CLASS(cls) \
    (G_TYPE_CHECK_CLASS_TYPE((cls), GRL_TYPE_MEDIA_SCANNER_SOURCE))
#define GRL_MEDIA_SCANNER_SOURCE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GRL_TYPE_MEDIA_SCANNER_SOURCE, \
                                      GrlMediaScannerSourceClass))

G_BEGIN_DECLS

typedef enum {
    GRL_MEDIA_SCANNER_SEARCH_SUBSTRING,
    GRL_MEDIA_SCANNER_SEARCH_FULL_TEXT
}  GrlMediaScannerSearchMethod;

typedef struct _GrlMediaScannerSource          GrlMediaScannerSource;
typedef struct _GrlMediaScannerSourceClass     GrlMediaScannerSourceClass;
typedef struct _GrlMediaScannerSourcePrivate   GrlMediaScannerSourcePrivate;

struct _GrlMediaScannerSource {
    GrlSource parent;
    GrlMediaScannerSourcePrivate *priv;
};

struct _GrlMediaScannerSourceClass {
    GrlSourceClass parent_class;
};

GType grl_media_scanner_source_get_type(void) G_GNUC_CONST;

GrlMediaScannerSource *grl_media_scanner_source_new(void);

void grl_media_scanner_source_set_index_path(GrlMediaScannerSource *source,
                                         const char *path);
const char *grl_media_scanner_source_get_index_path
                                            (GrlMediaScannerSource *source);

void grl_media_scanner_source_set_search_method(GrlMediaScannerSource *source,
                                            GrlMediaScannerSearchMethod method);
GrlMediaScannerSearchMethod grl_media_scanner_source_get_search_method
                                            (GrlMediaScannerSource *source);

G_END_DECLS

#endif // GRL_MEDIA_SCANNER_SOURCE_H
