/* mate-rr-config.h
 *
 * Copyright 2007, 2008, Red Hat, Inc.
 * 
 * This file is part of the Mate Library.
 * 
 * The Mate Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Mate Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with the Mate Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 * 
 * Author: Soren Sandmann <sandmann@redhat.com>
 */
#ifndef MATE_RR_CONFIG_H
#define MATE_RR_CONFIG_H

#ifndef MATE_DESKTOP_USE_UNSTABLE_API
#error   mate-rr-config.h is unstable API. You must define MATE_DESKTOP_USE_UNSTABLE_API before including mate-rr-config.h
#endif

#include <libmateui/mate-rr.h>
#include <glib.h>

typedef struct MateOutputInfo MateOutputInfo;
typedef struct MateRRConfig MateRRConfig;

/* FIXME:
 *
 * This structure is a Frankenstein monster where all of the fields
 * are generated by the system, but some of them can be changed by
 * the client.
 */

struct MateOutputInfo
{
    char *		name;

    gboolean		on; /* whether there is a CRTC assigned to this output (i.e. a signal is being sent to it) */
    int			width;
    int			height;
    int			rate;
    int			x;
    int			y;
    MateRRRotation	rotation;

    gboolean		connected; /* whether the output is physically connected to a monitor */
    char		vendor[4];
    guint		product;
    guint		serial;
    double		aspect;
    int			pref_width;
    int			pref_height;
    char *		display_name;
    gboolean            primary;

    gpointer		user_data;
};

struct MateRRConfig
{
    /* "clone" means that at least two outputs are at (0, 0) offset and they
     * have the same width/height.  Those outputs are of course connected and on
     * (i.e. they have a CRTC assigned).
     */
    gboolean		clone;
    
    MateOutputInfo **	outputs;
};

MateRRConfig  *mate_rr_config_new_current  (MateRRScreen  *screen);
MateRRConfig  *mate_rr_config_new_stored   (MateRRScreen  *screen,
					      GError        **error);
void            mate_rr_config_free         (MateRRConfig  *configuration);
gboolean        mate_rr_config_match        (MateRRConfig  *config1,
					      MateRRConfig  *config2);
gboolean        mate_rr_config_equal	     (MateRRConfig  *config1,
					      MateRRConfig  *config2);
gboolean        mate_rr_config_save         (MateRRConfig  *configuration,
					      GError        **error);
void            mate_rr_config_sanitize     (MateRRConfig  *configuration);

#ifndef MATE_DISABLE_DEPRECATED
gboolean	mate_rr_config_apply        (MateRRConfig  *configuration,
					      MateRRScreen  *screen,
					      GError        **error);
#endif

gboolean	mate_rr_config_apply_with_time (MateRRConfig  *configuration,
						 MateRRScreen  *screen,
						 guint32         timestamp,
						 GError        **error);

#ifndef MATE_DISABLE_DEPRECATED
gboolean        mate_rr_config_apply_stored (MateRRScreen  *screen,
					      GError        **error);
#endif

#ifndef MATE_DISABLE_DEPRECATED
gboolean        mate_rr_config_apply_from_filename (MateRRScreen  *screen,
						     const char     *filename,
						     GError        **error);
#endif

gboolean        mate_rr_config_apply_from_filename_with_time (MateRRScreen  *screen,
							       const char     *filename,
							       guint32         timestamp,
							       GError        **error);

gboolean        mate_rr_config_applicable   (MateRRConfig  *configuration,
					      MateRRScreen  *screen,
					      GError        **error);

char *mate_rr_config_get_backup_filename (void);
char *mate_rr_config_get_intended_filename (void);

/* A utility function that isn't really in the spirit of this file, but I don't
 * don't know a better place for it.
 */
MateRRMode **mate_rr_create_clone_modes (MateRRScreen *screen);

#endif
