/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.toolbars;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class ToolBarButtonBorder
implements Border {
    private boolean pressed;
    private static Image borderImage = new ImageIcon(ToolBarButtonBorder.class.getResource("toolbarbuttonborder.png")).getImage();
    private static Image pressedBorderImage = new ImageIcon(ToolBarButtonBorder.class.getResource("toolbarbuttonborder_pressed.png")).getImage();
    static int borderWidth = borderImage.getWidth(null);
    static int borderHeight = borderImage.getHeight(null);
    private boolean paintTopLeft = true;
    private Insets insets = new Insets(2, 2, 2, 2);

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int w, int h) {
        Image img = this.pressed ? pressedBorderImage : borderImage;
        graphics.drawImage(img, x + w - 5, y, x + w, y + 5, borderWidth - 5, 0, borderWidth, 5, null);
        graphics.drawImage(img, x + w - 5, y + 5, x + w, y + h - 5, borderWidth - 5, 5, borderWidth, borderHeight - 5, null);
        graphics.drawImage(img, x + w - 5, y + h - 5, x + w, y + h, borderWidth - 5, borderHeight - 5, borderWidth, borderHeight, null);
        graphics.drawImage(img, x + 5, y + h - 5, x + w - 5, y + h, 5, borderHeight - 5, borderWidth - 5, borderHeight, null);
        graphics.drawImage(img, x, y + h - 5, x + 5, y + h, 0, borderHeight - 5, 5, borderHeight, null);
        graphics.drawImage(img, x + 5, y, x + w - 5, y + 5, 5, 0, borderHeight - 5, 5, null);
        graphics.drawImage(img, x, y + 5, x + 5, y + h - 5, 0, 5, 5, borderHeight - 5, null);
        graphics.drawImage(img, x, y, x + 5, y + 5, 0, 0, 5, 5, null);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)component;
            Insets i = btn.getMargin();
            i.top += this.insets.top;
            i.left += this.insets.left;
            i.right += this.insets.right;
            i.bottom += this.insets.bottom;
            return i;
        }
        return this.insets;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }
}

