/* ----- encode/857xfreeze3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_857xfreeze3_checksums[] = {
  "bc89dd0c9bcace09ff3a4df7c6b657a8eea2467796bba9fbe9d0de4d1ee28703",
  "be3badaab03db87e3efd3597607b22d613e0e05242d021e616ed641ced8160fa",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_857xfreeze3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_857xfreeze3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_857xfreeze3_ITEMBYTES

static void *storage_encode_857xfreeze3_s;
static unsigned char *test_encode_857xfreeze3_s;
static void *storage_encode_857xfreeze3_x;
static unsigned char *test_encode_857xfreeze3_x;
static void *storage_encode_857xfreeze3_s2;
static unsigned char *test_encode_857xfreeze3_s2;
static void *storage_encode_857xfreeze3_x2;
static unsigned char *test_encode_857xfreeze3_x2;

#define precomputed_encode_857xfreeze3_NUM 4

static const unsigned char precomputed_encode_857xfreeze3_s[precomputed_encode_857xfreeze3_NUM][crypto_encode_STRBYTES] = {
  {254,2,254,0,255,1,255,255,0,0,1,255,255,1,255,0,0,255,255,255,2,255,1,0,255,0,0,1,255,2,255,255,254,0,0,255,1,0,255,1,0,1,2,254,0,0,0,0,2,0,255,0,254,255,255,1,2,255,255,1,1,2,0,0,2,255,0,255,255,255,254,255,255,1,254,255,255,1,0,2,1,0,0,1,0,2,1,255,1,255,255,2,255,1,1,254,1,1,2,1,255,2,255,1,0,0,1,1,1,0,0,0,255,255,2,0,254,1,0,1,1,0,255,254,0,1,0,0,1,0,0,0,0,254,1,255,2,0,0,0,1,1,0,1,0,255,2,0,255,0,0,255,1,255,254,0,1,1,254,0,1,2,1,2,0,255,1,0,254,2,255,1,0,2,255,2,255,0,254,255,1,1,0,255,1,255,255,1,2,1,255,0,0,254,0,0,0,0,0,1,254,0,0,1,254,1,254,0,0,0,255,0,2,2,0,0,0,0,0,0,0,0,0,255,0,1,2,0,1,255,255,1,1,0,0,2,0,255,255,0,254,2,255,2,0,1,0,0,255,1,1,2,255,1,0,1,255,254,1,2,2,1,255,254,255,1,0,1,254,254,0,0,0,0,255,0,255,254,0,1,0,1,255,1,0,255,255,0,2,1,1,1,0,1,254,1,0,255,0,2,1,0,0,255,1,0,1,255,0,1,255,1,0,255,254,1,255,0,255,255,0,1,1,255,254,1,255,254,255,255,0,255,1,2,0,0,255,255,255,254,1,1,1,255,1,254,0,0,0,255,1,1,1,1,254,254,255,0,0,254,254,0,254,255,0,2,254,0,0,255,0,254,255,1,255,1,255,254,0,0,255,0,255,1,1,254,254,0,1,255,1,254,0,0,254,255,254,0,1,0,1,1,254,255,255,0,0,2,0,0,1,0,1,0,0,0,255,255,0,255,1,1,0,254,0,1,1,0,0,254,255,0,254,255,255,254,2,1,0,255,1,2,254,0,0,1,0,255,255,1,1,1,2,1,0,1,0,254,255,255,254,254,1,2,0,255,1,0,0,2,1,255,255,0,255,2,2,255,1,0,254,255,0,1,254,1,1,255,1,255,255,255,2,0,2,255,1,1,0,1,255,255,0,254,0,254,0,0,0,1,0,255,1,255,2,255,254,2,1,0,255,255,254,1,255,0,0,1,0,1,255,1,1,0,0,0,255,2,255,0,0,0,0,255,255,0,2,254,0,0,254,255,1,2,255,0,254,1,255,1,1,0,0,2,0,0,1,255,255,255,0,0,0,255,0,255,0,255,1,2,0,2,2,1,0,1,0,255,0,0,254,1,1,0,255,0,1,254,0,0,1,254,254,1,1,0,255,254,255,1,0,1,0,254,255,255,1,255,1,255,255,0,255,0,0,255,2,255,1,0,1,2,254,0,0,0,0,255,1,1,1,0,0,2,0,0,1,0,254,0,255,0,0,0,255,0,255,0,0,1,0,254,1,1,0,0,255,0,0,254,0,255,0,255,255,0,255,1,0,0,1,255,0,255,1,255,0,255,255,2,0,2,0,255,0,0,0,1,1,1,255,255,0,0,2,1,0,0,0,255,254,0,1,0,1,2,1,0,0,254,0,0,0,0,0,255,1,1,1,254,1,0,254,255,0,0,255,255,0,1,0,1,254,0,1,0,1,0,2,255,255,0,0,0,0,1,2,1,254,0,255,1,1,255,1,0,2,0,2,254,0,2,1,0,254,254,1,1,255,0,255,1,0,0,0,0,255,255,1,0,255,1,0,0,2,255,2,0,0,255,0,255,1,1,255,1,0,255,0,1,0,0,255,254,0,254,0,1,0,255,1,0,254,0,2,254,1,0,1,1,0,0,1,1,0,255,255,0,255,0,254,1,1,1,255,255,1,1,1,2,0,1,255,0,255,255,0},
  {1,2,255,0,255,0,2,1,254,255,0,0,0,0,0,0,255,1,0,0,0,0,255,1,255,255,0,1,1,1,255,255,0,2,0,255,2,0,1,1,255,254,0,255,255,255,2,0,255,254,2,0,0,0,255,1,0,255,254,0,0,1,1,254,1,255,254,1,254,0,255,255,2,0,0,255,254,255,254,0,1,0,2,0,0,255,2,1,1,2,1,2,1,255,0,255,0,255,1,0,254,255,1,0,1,0,255,2,0,0,1,1,0,1,255,254,0,1,0,254,1,1,0,1,0,0,0,1,2,2,0,0,1,255,1,1,0,255,255,255,1,1,255,0,1,1,1,0,1,1,255,1,0,255,1,254,255,1,255,0,2,0,1,2,0,1,1,0,255,0,0,1,255,1,2,255,0,0,0,0,1,255,255,255,0,254,254,0,255,1,2,2,255,255,2,1,255,0,0,0,255,255,0,0,0,254,255,0,255,254,0,255,0,0,1,254,1,254,255,0,0,0,255,0,2,255,2,255,255,0,2,1,255,0,254,254,2,1,254,255,255,0,255,1,1,1,0,255,1,0,0,255,255,1,0,0,0,1,0,1,255,255,255,255,1,0,2,1,255,255,1,0,254,1,1,0,0,1,0,254,0,1,255,255,0,0,1,2,255,255,0,1,254,255,0,255,255,1,255,254,255,0,1,0,2,254,255,0,254,0,1,0,255,0,0,0,255,1,2,254,0,255,255,0,1,255,0,255,1,1,0,255,255,2,0,2,1,255,2,0,0,2,1,0,0,1,255,255,1,1,1,255,0,255,2,0,0,255,0,255,1,0,2,0,0,0,1,1,1,2,1,255,255,1,254,0,255,254,0,1,0,0,2,2,1,0,254,0,0,0,1,255,255,1,0,2,0,0,0,0,0,0,255,255,1,2,255,0,0,2,0,254,254,0,1,1,0,255,1,0,1,1,0,0,255,255,0,255,0,2,0,255,1,255,254,255,1,1,255,1,255,1,0,255,0,0,0,255,0,0,0,0,0,0,0,1,2,1,0,255,1,255,255,1,1,255,0,255,0,254,0,255,1,1,0,0,2,0,0,1,0,1,255,1,0,255,254,1,254,255,1,1,1,0,255,1,2,254,1,0,255,255,0,254,255,0,0,255,2,1,0,1,1,1,255,2,1,1,2,255,1,1,2,1,255,1,0,254,0,255,1,2,255,255,0,1,0,255,0,0,1,0,254,2,1,255,0,0,255,0,254,1,2,0,1,0,255,254,0,1,254,1,255,0,0,254,255,1,254,1,0,255,254,255,254,2,255,255,255,0,254,0,254,2,1,0,2,1,0,2,0,0,0,1,0,1,1,1,2,0,255,1,255,1,255,2,2,254,0,1,1,255,254,255,1,1,0,255,1,1,254,255,1,0,0,255,1,0,1,0,255,1,0,255,255,1,0,1,1,2,2,1,2,255,0,0,255,1,1,1,1,254,0,0,2,2,1,1,0,0,0,255,0,0,2,0,0,0,0,255,0,254,254,0,255,1,1,0,255,255,0,255,2,255,0,1,0,255,1,0,1,0,0,1,255,1,1,255,0,1,0,1,1,0,1,2,1,255,1,255,1,0,1,254,254,0,255,255,0,1,254,2,1,0,1,255,0,0,1,255,2,255,254,1,0,255,255,255,255,255,1,1,0,254,1,1,0,1,2,255,0,2,255,0,1,1,1,255,0,0,255,0,1,254,1,0,255,1,1,1,0,0,1,0,255,0,0,255,254,254,254,1,1,1,0,0,0,1,0,1,254,254,0,255,1,255,2,255,1,1,255,1,1,0,0,0,255,255,254,2,0,0,0,2,255,255,255,2,0,0,0,0,1,255,1,1,254,1,0,2,1,0,255,255,255,1,0,0,0,1,1,255,255,255,1,0,255,1,255,0,1,255,2,254,0,0,0},
  {1,255,0,0,0,1,0,255,0,0,255,1,255,0,2,0,254,1,255,254,0,255,1,255,255,0,0,1,1,255,1,1,0,0,255,1,0,1,1,0,0,1,0,0,0,255,255,255,255,0,1,0,1,1,0,255,1,255,0,0,1,0,1,255,1,0,1,1,1,0,1,0,0,0,255,254,1,2,0,0,255,0,1,1,1,0,0,1,255,255,255,1,0,0,1,1,0,0,254,254,1,0,255,1,1,0,1,2,254,0,2,254,254,1,255,0,1,0,0,1,0,0,0,1,1,0,255,255,255,0,2,1,255,0,255,0,255,254,0,1,255,0,1,0,1,0,0,0,2,2,1,0,0,1,1,255,1,1,0,0,2,0,255,0,1,0,0,255,2,255,0,1,0,0,254,0,0,0,2,0,0,0,0,0,0,0,1,0,1,1,1,1,0,255,0,1,1,254,255,255,0,255,0,0,0,1,1,1,255,0,255,254,0,254,2,1,0,0,2,0,0,255,0,0,1,0,1,0,1,0,0,254,255,1,0,1,255,0,0,0,255,1,255,0,0,0,254,255,1,0,254,254,1,1,255,0,0,2,1,255,254,0,1,254,255,0,2,254,255,2,255,1,0,255,254,0,255,1,1,1,255,1,255,0,1,255,1,0,2,254,255,255,0,1,255,0,255,1,0,255,2,255,2,0,1,1,254,0,0,1,1,1,254,1,0,0,255,255,2,255,0,0,0,0,2,255,0,0,0,255,0,0,1,255,255,0,2,255,0,0,0,1,0,1,0,0,255,1,1,255,0,0,2,255,2,2,254,1,255,1,0,254,1,2,0,255,0,255,0,255,255,0,0,254,0,0,1,1,255,254,255,1,1,0,0,1,0,0,1,1,254,0,0,0,255,1,1,1,1,254,1,254,255,254,1,0,255,1,1,2,0,255,0,255,0,0,0,0,1,1,0,255,254,255,0,254,0,255,1,254,1,1,1,255,0,1,0,255,254,0,255,1,1,255,0,254,2,255,0,0,255,255,255,1,254,0,0,255,0,0,1,0,0,0,254,255,254,0,0,0,0,1,0,0,1,1,2,1,1,1,1,255,1,255,0,255,0,1,0,0,254,255,1,255,254,0,255,0,2,0,1,0,2,0,0,1,0,0,1,255,1,0,0,255,0,255,0,0,2,1,0,1,0,255,1,2,0,1,255,1,254,255,0,255,1,255,254,254,0,0,0,255,254,0,255,0,0,255,1,1,1,0,0,2,255,255,0,255,1,255,0,0,0,2,255,254,0,0,255,1,254,0,0,255,255,0,0,0,0,0,1,255,0,255,0,1,1,0,1,255,255,254,0,254,254,2,255,0,1,255,255,255,1,0,2,255,255,1,254,255,0,255,255,0,1,255,2,1,0,1,0,1,0,255,0,0,1,255,0,0,1,254,255,0,254,254,0,0,255,255,255,0,255,1,0,1,0,0,1,0,2,0,1,1,1,255,255,0,1,254,255,0,0,2,2,255,1,254,255,1,254,0,1,1,2,1,0,255,0,0,0,0,0,255,0,1,1,1,1,0,1,0,0,255,255,1,1,255,0,254,0,0,255,254,1,1,0,254,2,2,1,255,255,255,254,1,254,2,255,0,1,255,255,2,254,2,0,0,1,0,1,0,255,255,255,0,1,0,0,255,254,254,0,255,1,1,1,2,255,0,255,1,0,255,0,0,0,2,2,255,255,255,0,2,2,1,1,0,2,0,254,0,255,0,1,255,255,255,255,1,254,0,1,254,1,255,1,0,254,255,1,2,1,2,255,255,0,1,1,255,1,2,2,255,254,2,0,255,1,0,2,254,255,0,1,0,254,0,1,2,255,1,2,1,0,0,0,0,0,255,255,2,255,1,254,1,2,255,1,254,0,1,2,255,254,1,1,1,0,0,1,254,254,1,2,1,1},
  {2,0,255,1,1,0,255,255,0,2,0,254,1,255,255,2,1,2,254,254,255,1,254,0,0,255,255,255,255,255,1,255,1,254,1,0,0,1,2,0,0,0,0,255,0,254,0,1,0,0,1,255,0,255,0,0,0,1,2,255,0,0,255,255,0,255,1,1,1,0,1,1,255,254,0,2,255,1,0,255,2,2,255,1,1,1,1,255,1,0,2,1,254,1,255,2,1,1,254,2,255,2,255,0,1,0,255,1,2,0,1,0,255,255,1,1,255,2,1,255,0,1,255,0,1,254,254,255,254,254,0,2,0,0,0,0,1,1,0,0,255,2,0,0,1,0,2,2,1,0,1,0,0,1,0,1,254,1,1,255,255,254,255,2,0,2,0,0,1,255,0,255,255,0,255,255,255,2,0,0,254,0,255,254,255,2,254,0,255,255,1,255,255,1,0,255,1,2,1,254,0,0,0,255,255,0,0,255,255,0,255,1,1,2,2,1,1,0,2,1,1,0,0,255,254,255,0,0,0,0,0,255,0,0,0,0,255,0,0,254,0,0,255,255,2,0,254,1,0,0,0,254,1,255,0,0,1,0,255,255,255,254,254,0,0,0,1,0,255,1,0,0,255,1,0,255,255,0,255,0,0,1,1,0,1,0,0,0,254,2,0,0,1,255,1,2,0,1,0,1,254,0,1,255,2,0,1,254,255,1,0,255,1,0,254,1,254,255,255,1,255,255,0,255,0,0,0,254,0,255,255,0,0,0,255,1,1,1,2,2,0,0,0,2,1,255,0,255,254,1,2,0,0,1,1,1,255,255,1,0,255,255,2,1,1,1,255,254,254,1,0,1,255,0,0,1,1,1,1,255,0,2,255,1,255,255,0,1,255,255,0,255,255,0,255,2,1,0,254,2,1,0,255,0,1,0,1,0,255,2,254,1,0,0,255,255,1,255,255,1,255,255,255,255,0,255,255,255,255,1,0,0,0,0,2,1,0,255,255,0,1,255,1,254,255,1,0,0,255,0,255,0,0,1,0,1,255,0,2,1,255,255,254,1,0,254,0,2,1,0,255,255,1,0,1,1,1,0,0,254,255,0,254,255,254,0,1,255,255,0,255,1,0,2,1,255,0,1,255,0,255,2,1,2,255,0,0,255,255,0,0,0,255,0,255,255,0,0,255,0,0,0,255,0,255,255,0,0,0,1,0,1,255,255,0,0,1,255,255,0,1,0,255,255,0,255,2,0,1,255,1,0,1,255,1,1,254,1,255,2,254,1,255,1,1,0,0,1,255,255,2,1,1,0,1,0,0,0,1,2,0,1,1,2,255,0,1,0,255,255,1,2,1,0,1,0,254,0,1,0,254,2,2,255,0,0,0,1,0,0,0,0,2,1,255,255,1,1,255,254,1,1,255,0,255,1,255,0,255,1,255,0,2,0,254,0,255,0,2,0,2,0,1,1,0,254,0,1,0,0,255,254,1,254,0,255,255,0,255,2,0,1,255,0,255,254,0,255,0,2,255,0,0,1,255,1,255,1,0,0,0,255,0,255,0,254,0,254,255,1,254,255,0,2,2,255,2,255,255,0,1,255,1,255,1,255,1,0,0,2,0,254,1,1,0,1,254,255,1,0,254,1,1,0,0,254,0,0,255,1,0,0,255,255,1,254,0,0,255,1,0,1,0,255,0,0,254,0,1,0,1,1,0,254,0,255,255,1,254,254,0,1,255,255,2,1,1,1,1,255,255,0,1,255,254,0,0,1,1,1,2,1,255,1,0,1,0,1,0,0,1,255,0,0,254,0,2,1,255,1,255,0,1,0,254,255,255,0,0,0,1,2,2,255,1,2,255,2,0,1,2,255,0,1,0,255,0,1,1,1,255,255,2,2,0,0,2,1,0,1,0,0,1,0,0,2,1,254,1,1,0,0,255,0,255,0,0},
} ;

static const int16_t precomputed_encode_857xfreeze3_x[precomputed_encode_857xfreeze3_NUM][crypto_encode_ITEMS] = {
  {24271,-23740,20041,16275,-7546,4321,7415,-7735,-25305,-21240,-1769,25847,17213,-22712,-13876,4623,-9732,17243,-15688,12998,-18370,14519,-11216,27591,-13537,-28503,-18663,14611,-7279,-25846,8762,19448,17191,16809,27597,1037,-25640,30522,-8404,-12092,7065,-1667,-20641,19105,8346,32604,-30927,-7557,-25063,20898,21608,19674,31207,22631,32117,-20891,-30349,27944,21299,-19487,-26687,-31435,-9624,-28098,-28453,9536,27990,-11935,-7462,9629,24358,22634,-9136,-27056,17113,-2164,4664,4384,21795,-28348,1303,31482,11460,14203,-24525,-17980,3397,19772,-31226,-10801,21098,-25942,12860,-22409,-21194,31777,-7019,-29573,-25702,-15254,-5176,-20989,16694,-1208,-9963,4341,-12431,7672,-28928,-15816,1167,24744,1511,6482,-27715,-9114,30454,-28241,9117,-1061,14380,31659,-14035,28327,-3288,-2159,29265,-15246,-14684,2322,6648,24039,-14052,17887,-21167,20267,-20809,23772,-7686,-1146,-14048,12847,-18846,-18119,3990,-15970,-20212,10314,10478,28905,16806,338,-785,24245,23089,21660,-6698,148,22432,22443,-2495,-17794,15430,-29413,11550,17030,-10880,-4893,18580,-17446,-7423,15343,-14658,-19156,2951,-29233,24617,-18231,20194,-9772,913,10273,-32181,12041,-18200,26978,11633,16192,-21802,-1064,-11215,-7620,6147,29788,-18504,-5712,-27264,-32235,-13272,-29093,27031,11601,-8019,13447,17173,-16067,26005,-4653,633,-17145,3833,-11232,-31951,-29500,32442,29298,597,-114,-22899,21600,-21843,28500,16005,10241,12708,-1244,-19861,-2139,-6803,14810,-7921,7972,-22019,-8706,28002,-18052,-14793,12020,16406,-303,19795,-17509,6902,-20350,-31212,-16529,-21600,-23427,-6499,-10484,5989,-20830,31541,12820,-22572,-28730,4928,30589,-25994,-27343,-32584,1147,-7861,26263,26126,12763,23469,7948,30442,30766,-28221,18831,18384,-4695,-14680,16737,29774,26461,-30006,-32498,-21624,1684,13061,4456,19809,-1948,-3331,-2598,-26668,-12734,-29462,-30356,-22605,7270,20431,-1628,-10821,-9136,-14181,-21310,1366,-16767,18570,-5068,16312,-14316,-6788,-10843,27117,-6359,30227,9997,18960,-3967,26080,-2114,14768,-4941,-3523,-4639,-27327,-10640,-22274,16169,22396,-13244,485,18103,31907,-2623,-32100,18764,-28013,-26419,1704,-25719,-3091,1862,14570,27550,-8339,-23897,-4934,16121,1978,24706,-1086,4212,-22716,-14884,-9503,-1205,-18728,-779,23824,16801,27608,10779,-23478,17887,17056,-11706,31090,28331,-6492,-22696,32017,19491,-27027,1964,31131,20701,-12574,-21938,-7624,-17828,24230,25795,20481,25113,28214,7191,-3760,-32198,-3827,28999,32587,-5025,-31754,10577,11779,20053,-17379,-27549,28465,6005,23566,-16101,-24893,2886,2914,10807,24898,1979,9923,-25404,-5292,-27088,-15348,-7536,-23882,-24369,-28796,26691,24975,-3744,11072,-1702,-5814,26273,-31034,1420,-11970,32137,28170,-12674,-3932,-3273,-7410,17260,1559,972,28456,28247,-7009,32443,-31627,-22301,-3672,-14782,-4136,-24160,25597,-25890,19446,-29903,21948,-14356,-9127,-7817,13282,-6245,-19123,-4979,-22314,-19145,14583,18796,21911,17837,28957,17128,-6821,-29020,27930,-6544,-12413,-21036,24642,-30499,10327,18884,15068,-25566,16625,-19912,-31489,-3421,3310,-8580,31765,1790,-20115,11707,19954,-13724,-8093,2786,-22724,3872,8105,3386,-22006,7407,-25297,31451,15190,-31175,-17304,-25121,4718,-5797,3696,27607,19377,17626,-10752,14856,5091,-30329,-11391,6011,-17396,-4378,-21877,-4375,19660,-30619,-24071,-5877,18695,2024,32602,-31502,-10756,-7974,-20346,-3311,2766,-15707,-4465,8017,-18983,-27363,-25872,-4323,-136,-27886,-6457,17679,31911,4716,19797,20036,-4492,-24855,-20068,26392,-24513,17724,24814,-2659,-28685,-22822,24815,10734,17041,2467,21794,6790,-28847,27393,-3543,-26998,-1215,-8883,7636,13139,26249,4652,4029,-10542,2655,-4945,-11478,23864,11892,23285,12076,-18745,-2859,-27715,-18340,-9401,14709,-7895,-2745,6221,-11319,-6237,17338,-2957,-12320,7845,16457,-18663,10129,27097,2580,31812,1687,31735,29569,-10208,11185,5040,-2491,29635,10481,-24188,7872,7528,18729,24001,-15559,-16042,-29477,5873,-6905,-14941,1550,31737,16907,-26232,4680,11993,-17365,5222,-23837,15786,-4532,-20590,29200,14613,31434,11724,13671,25754,-24722,-31748,12133,1149,-26445,-30949,-1293,-10674,-32048,-14604,18889,27192,23246,-14562,-20292,-28791,-6541,-5082,27440,-18486,-28959,7036,31581,20770,-14108,11476,-18870,27840,-979,5517,24237,26098,1017,17114,24912,-3280,23999,-6141,18788,-12065,-25041,-16083,8260,29348,18894,29891,-10001,-6481,21816,29714,16742,-24577,-14415,-18418,6918,32441,-31986,7077,2538,-8105,-16913,-4634,28190,-6631,10935,-15228,-20080,-3224,12648,-25788,17193,13913,23386,-17880,5284,192,-24809,-28474,9820,-11427,-26553,31951,-5703,31392,-23478,7596,23385,-9934,-13958,-27194,7033,29053,-12656,29091,27946,25745,-26193,22278,31523,-856,10764,-25838,-14604,-17357,25360,-429,-566,-2670,-22571,27498,-27562,30086,3881,27270,-26409,-8217,25917,-25922,-18190,12820,25585,-9315,21566,-14333,-27749,11207,-1133,28851,-22663,13233,-27268,17980,-31074,-21883,4129,-12504,17161,16993,-28367,-18296,8102,29463,-11842,-32345,-27879,19017,645,22137,-5596,-6061,373,19086,31196,-29798,2337,24540,-23320,30968,-17572,25653,18768,731,-26991,24239,-7223,9142,23114,-17009,-30972,28526,32628,-8825,13338,25455,17975,23413,25776,23920,26061,-21260,-22674,31514,9250,30393,20626,-23163,-16615,31396,2632,1533,-2585,-17966,21705,-7191,-13409,-6812,13050,-14647,-2131,-32463,31256,-8304,29332,-5447,7402,13219,22919,395,8671,-21539,3382,-24154,-19800,-10682,-15241,-8007,-685,-13105,-19434},
  {-32045,-26341,3914,-19077,9362,-6492,-18712,-23936,24376,8258,-25491,-31770,27546,-14004,-6267,32622,5999,10468,-2649,27639,-19539,12843,7604,-30269,-3967,2858,7518,12220,-27893,12796,-15340,-7534,-8787,-30217,-19197,-6559,-24370,-4617,-23720,-16514,-235,18223,3726,1742,30947,14069,-23080,18225,-8920,17608,-27685,-4947,32424,-3843,-4984,-9377,22377,5222,26146,-11067,24771,4435,-2528,19588,-31337,-12178,19357,-19484,19867,-18006,8312,-14338,-21655,-11274,-8271,13340,23890,25082,19561,10632,-6560,-20241,-18073,-1725,-672,21905,-19477,-30656,-10754,-19168,-25064,-32026,-3227,10895,-126,13655,27096,-13507,-13337,9702,18481,11651,-28778,23880,13909,-11742,-6574,-24184,-14454,-20544,-2048,15307,8106,6820,617,30910,-5892,2812,-12603,23818,10171,-1031,-30177,-26015,-10272,31653,-7662,10495,-26527,-32317,-15135,-3747,-22472,26255,-19967,-8552,-30135,15863,26033,25787,14227,13027,30458,-2919,8491,4786,-18161,-32013,-22028,8566,14975,12373,17976,-5821,3562,17377,-784,-12962,25541,21279,-30070,27063,-31649,-32044,-21108,14629,-14252,11634,12377,-24333,3363,-27344,-8920,-3185,-27493,12791,-17199,-15519,20784,-3075,-21617,25295,9266,10205,-27405,26182,30631,25905,7160,16243,-22489,-21745,20432,16796,-24901,7816,18080,17997,10485,-21456,26039,-3595,-1377,32400,-9321,32656,5048,19560,-11815,23500,-21246,-2827,30867,21552,-10805,23107,-27392,23002,17360,-13050,21453,3618,-12943,16482,-21034,5207,-20941,17807,-3520,2064,-29875,3559,22784,8394,25903,25396,-22543,9103,28468,-3262,10784,-15684,12728,-32462,-28271,7600,8643,9239,-776,-12288,-8184,23153,11060,-1544,11346,12354,30090,-4310,20829,3160,-10393,32378,665,13382,-25496,19389,-19705,2320,3668,-10960,-5822,-2997,19516,13447,-27818,31665,-11343,-16871,10581,26767,-23925,-3512,10067,-3151,6633,13713,1618,-29617,-9073,-15784,-8493,-9110,31660,1058,6756,158,-7696,-3953,-1213,19405,19991,-17922,-26873,20130,-31531,30910,-880,19116,24817,-9438,-12890,-1275,19826,-14424,-6057,12690,14567,-20867,-20248,31579,1488,27515,-14368,-16749,9622,-1573,-8775,29309,13984,-31475,6504,-8755,-14635,-18307,-24942,-23074,-27167,-8020,-30385,5874,-126,-23830,-14393,-6741,-15666,5812,4379,29138,-30566,-23375,-21461,19262,11664,9494,-24310,29793,11253,11102,-8883,13706,-10250,-14718,-24427,-14895,23607,-13578,-16025,2893,-17393,-21757,3688,8867,-10348,6070,27745,99,5579,20971,26676,-19514,-4968,27852,-27058,-30346,-29468,30033,20782,32145,26259,-23727,6178,1097,8339,-22817,618,-23425,-17733,22974,1170,7137,16245,31980,8639,-14923,-18626,-27931,18224,-2841,32214,-22057,30609,30715,23416,9885,4300,-6113,-9678,18200,9163,13506,15157,12865,13980,26718,25904,-11926,-12513,17981,25911,-29608,4257,14924,10786,-12073,19210,27908,-29705,9385,-9325,-25703,14087,-3683,21819,-8560,-6291,25938,-13002,14948,24747,-7530,28305,2901,17961,-4116,-8562,-21365,-32086,-13610,27156,17330,15478,17006,16766,-2990,-24521,-5665,17862,31574,-32586,31924,28098,7082,-21065,-25211,7539,-5127,-24310,27147,7440,9259,-31350,7585,12149,-560,-15528,-16243,30826,-5480,25309,14141,-24407,15010,-4613,27363,-8395,-27491,-31948,27220,13618,-11847,14993,19991,27144,20065,2894,22203,-4917,20927,-17653,-176,-25497,-13409,-17444,-284,13490,-21646,-17777,-8180,-22297,-8809,-17078,5683,-26179,-1271,25823,-15887,-12288,24886,-19284,-15817,-19601,-18553,30518,-2914,-408,-6680,-25401,21734,16662,14118,4360,10866,27610,-16783,-19622,-16339,5610,-28341,-6001,32658,27073,11728,-19834,11118,-20186,-23109,19058,25639,2001,12595,21613,4045,28790,7530,31251,22309,-5680,-7070,26500,-13232,7248,19994,24631,26012,16657,-24145,2354,17915,29606,-219,18016,2988,30325,-27415,2824,-18474,-32284,15067,4977,-25996,-30216,28155,8844,-32582,567,-26978,-18347,5749,-28792,25188,27308,-19130,29711,-6191,16088,-20107,-20092,31579,-13029,-176,-12791,24314,21217,-4783,-26147,7216,-6990,28187,-9341,10672,20236,24152,-7739,17904,30978,95,2401,468,15769,-19278,2324,7204,11610,-94,29096,-21914,-19059,5116,-1601,-26410,-18211,8539,-23377,23171,30045,-19248,-13984,-1001,-11039,5794,-25622,18493,-22284,-32301,-23608,-16780,-4586,-3233,-7668,18558,-4197,-14611,-14523,30195,-27802,8205,-23487,9876,23172,-15856,19113,26086,30826,-21357,-8824,-9749,-2912,8574,185,27839,6111,-6538,-29032,17165,-14598,-5621,-8577,14621,6880,7062,-9389,-13569,29472,-18035,26435,-11141,10558,31022,-19332,-18071,-18339,8626,-10454,-26697,-12410,-27709,-1340,14186,-10031,30422,15274,7146,12478,27043,26062,-10455,-16183,10349,8637,-10148,31939,-27340,-6989,-10227,10885,19406,-12348,-7626,-23273,4904,-23437,-6688,31000,-12872,-5223,28475,11207,-9385,-16144,30230,-14837,-8384,21153,19441,7702,-27503,-26703,-16478,-32128,11969,-6714,-17980,23579,-1158,12784,-24863,5857,22451,-306,-23586,13907,23469,6445,18883,-15593,26634,-2341,1153,-30596,-3077,13902,-8601,-2324,31743,-3190,-15099,14658,12680,29365,32473,28138,-29444,15583,6511,30468,-23037,-24576,-8585,23301,-25091,18625,31828,16704,-13633,-29594,18365,-26248,19718,-23474,-18056,25838,-4658,-11864,6801,21888,-32730,26747,17375,19525,-23698,28302,-23550,3951,-22138,24083,-9037,1757,-24184,1362,22644,6999,5004,-23291,5945,-19439,-16268,32638,8860,32532,-19897,-11168,20133,9812,18611,29381,-1829,27966,9141,3555,-10148,-5093,29765,-14905,15425,-14870,-135,12206,11371,512,3276,6148,-14437,-16549,20662,-14532,2115,-10845},
  {-12728,-1135,32430,-30621,-30327,13738,4530,9377,30753,31437,-6805,-27113,32465,-20040,-26716,18456,27490,-8069,137,19924,23649,13172,-13547,24176,-1357,11790,8391,-23909,2155,11042,-24434,-19175,-29976,-13152,12770,-18599,-17544,5392,-2912,-17274,-7041,-22025,-24948,11730,-9675,5630,-8065,5372,17339,30306,-9521,-18681,-32129,-17849,-5928,30041,13465,15263,9324,-10389,-26315,-25449,9160,32720,-3977,18441,11482,1927,-12722,32652,-32393,32487,-4893,2202,-10936,28354,-32552,-28300,20118,-28824,9413,7185,13384,364,-15818,-30534,1275,12832,-3670,3182,22040,10036,-9816,7965,-8729,676,-21570,12000,27181,29947,14806,4866,24134,-16991,4426,32733,13894,-26968,16456,-8625,-16615,17272,20728,-21089,-4792,-81,-17810,-15270,13662,5368,28980,-13023,2043,-740,-28430,-10323,-583,-4318,-6748,14424,-25561,12181,-16135,23871,18950,15525,2684,21403,-7272,-13712,15533,-13827,-4322,1197,-18965,-5259,10743,-30696,-16387,-26722,9760,17088,3264,-6728,-27269,22730,2572,3451,-17409,-30822,-23869,-22035,2291,-13659,-18518,-27243,-11304,8576,-31270,11426,-16764,-12878,12633,-27453,28735,-12357,-16485,5829,-21472,4011,9312,11970,-6033,-17925,9165,-16398,-6437,-9396,-23396,11998,-26063,8179,-24474,1553,14118,-30677,9358,21601,-9052,21017,2022,27464,2583,-16851,18390,-26855,-8843,-25355,17030,-14154,10943,22426,21045,21241,-25246,-31421,2730,22884,-28000,31584,960,-7741,27972,-4128,12865,-6921,-27509,17187,14617,-27753,19740,27286,-10216,-31475,5148,-18905,11303,-23727,20007,-24681,-14869,-32654,20864,-14181,4854,6255,18859,3617,-27215,29430,19714,28369,-15074,14203,31952,-23802,-20562,-29884,6784,-12496,18238,-1200,6874,24187,-4588,-9447,-18424,31936,31457,-20692,-5470,14386,-13473,4055,19534,3618,2597,4999,-30533,9598,-3082,-18626,24305,32166,-13793,-2449,-5264,-28014,-18568,32470,15845,18050,31341,-21440,29744,1602,26801,-12650,-8103,17240,-30394,-9901,-21754,-24369,-29024,14368,18373,7680,-9042,-19913,-28259,-7769,17791,-21872,26016,-6321,-3313,15128,-19156,5120,10902,31716,25884,-6600,-23062,7142,5700,-5154,-13452,20795,-22656,-13617,-287,15743,-9301,5502,-19537,20663,-8493,7788,26634,-27080,6369,-9887,-16092,-26832,-1117,9955,-28286,-8431,-27267,-16329,-26593,-2413,-16402,-30409,22339,-11183,1256,-7133,27780,32761,3301,-17875,-7467,30200,6900,-4651,21090,1385,12413,22653,-17037,30952,9675,-22263,-4589,-9047,29432,26473,-1456,6601,-9422,12213,-22368,7477,19668,-27996,-28775,-21653,24061,-19374,14979,-17694,13700,10564,8143,-20294,-17783,23095,7408,24913,23576,30247,3778,-5217,-13981,-26588,-9290,-16966,-25494,-1906,-2670,15185,-21660,27345,10917,-8436,13612,-18671,-14931,17249,27667,12485,-12672,28030,21690,-11983,-338,21313,-8426,-7967,-25166,22616,-3885,-3809,7539,12764,24916,-16059,12509,-30434,-29054,-5467,-16671,26998,-21937,-3844,32157,-28365,20198,10865,18314,-5723,20623,28932,-6186,18746,11550,15432,-3179,-3573,25242,31650,20050,-16222,19618,-21294,17085,-1257,15420,-749,-3723,1914,-14702,-21458,-18109,-6317,-23456,-11957,14914,24251,-26450,13889,-11022,25289,-11175,-29294,-24021,-20127,23596,10919,-29210,30035,32620,2181,-2002,30660,-28456,-9591,-32483,-2382,-25123,8166,25527,-30107,26139,-17781,2362,26195,-25937,25863,28335,7127,-22986,12881,-18435,-14673,-31768,-1565,-2853,11134,-13575,16106,-6266,-27043,-11235,2743,5591,12592,27673,3731,-12072,19799,-12983,22559,31402,23902,18249,11529,-23175,7523,23566,19446,-5323,-21528,14322,13931,-16970,-30827,15058,-17361,-24597,-27037,-4177,-4876,8892,30221,9574,8525,-18882,-30102,-2808,-30700,28370,23761,-11925,-5352,27122,-4418,17572,-14388,12162,26882,28829,-6723,-20466,-6717,-4017,-12549,-56,-6550,-21807,23759,-28158,-21791,-28451,-13908,-8570,4373,1145,18784,14796,20284,25393,-17254,8408,14607,-17519,4700,-6694,15137,10852,19563,-32458,11006,23921,-24308,22990,29819,23169,31037,10685,11805,14158,28430,-17452,-16874,2058,11905,29022,10093,3735,-316,-8985,14580,11443,23768,18651,-25944,16057,16939,4466,-16188,31711,24448,4350,-23892,9293,-10369,-16096,-17694,22538,-31985,-16143,-20312,-16440,2115,8974,-30783,-28381,16134,-7775,10054,-11102,9464,9515,21555,4342,30883,-7153,28287,-24372,-22144,-22657,25640,9508,17353,21857,-9590,29710,-10923,-15056,-28850,-19684,2248,1509,4715,-11997,21945,7188,-23634,2823,23150,-3555,-10862,-6803,10480,-25298,-13929,3460,16077,5385,-13630,8876,-8186,-362,-1573,-18009,25879,-4971,31641,-5263,18688,-20129,-15128,32442,22675,-20071,-30562,15871,18947,-14680,8372,32626,1147,24820,-18346,27605,2016,-4433,-12004,2567,-19345,32281,-16693,6192,22218,-18389,-21423,4240,-16503,23939,-2836,10205,-19443,15754,23328,-2616,-13717,25513,19423,29487,-9769,-25052,-11108,-5105,-17908,1250,20163,25103,10153,-9963,6296,10767,4410,-6264,-28318,-32365,-15508,23333,-5584,12411,-27706,-20608,-11810,-24023,-2421,-26611,-22344,22732,-2460,-10837,2925,10492,-562,31022,-4378,26432,-7145,27250,-6150,-20741,25918,-25151,28823,-15689,29532,30805,-5848,-3119,-17371,-10772,-32329,590,4322,-31512,-3725,823,-10540,-1679,-28432,-31609,22742,22246,-30334,-30222,-15388,-449,12828,-29959,18163,-3451,-18633,-24497,5925,23032,-11859,5788,-19072,9944,-7892,-31693,-12665,27168,-14385,-20172,-2505,2592,-15322,6128,-26335,19565,8146,23593,943,-30211,-1936,-24041,30217,-21339,-7163,-29824,30734,32566,-6002,-22826,2311,7380,9660,-536,30619,25279,-30302,-30019,-11756,-11183},
  {-23893,-19197,-817,-19517,-6815,3093,28739,3695,10629,-29797,-2010,30076,-5075,19679,10784,-27157,7507,-28810,16633,25219,-5065,11116,25096,15462,-5535,22874,20438,11819,12761,6260,-29432,29342,-12158,23059,13150,-31524,6258,-12653,-26146,30648,939,-27426,27918,-9451,24489,18142,-18894,-31673,-24240,-25038,-27812,11930,5004,31136,363,-7527,9660,-16595,-26905,-5065,2241,-12150,-9523,20900,28179,6149,-3140,12511,-31232,-6753,8062,-12608,18425,29509,-13383,-26551,11165,5848,11349,-2797,-22468,-16903,32222,-5483,-4052,-7829,1918,-15382,-16064,-25797,-24277,-20273,28165,-5459,23951,-21601,-11282,-2399,19648,-20692,-6223,-21886,17759,-18234,-26759,13077,7868,-305,-21439,3165,-17684,31539,-5461,25076,6445,-491,13505,-30850,15646,2102,-25932,-758,-15304,-22485,-14144,20044,32266,4556,23896,29080,21246,-17926,-3567,-32382,-11691,23022,-22739,-20930,-15438,-19440,26255,-17368,18960,7719,-1712,-10464,-26386,-22672,-26261,7674,15466,11439,-10068,-2873,14154,7291,30307,-25376,-22547,-1849,2198,32365,2366,-21322,7800,-28057,12483,22959,-15473,14417,966,7262,-5701,12576,-13174,11432,31745,-31153,7683,-32508,20794,15759,18440,25516,27800,-23338,22525,6165,-646,-2473,-30929,-5671,15605,-2231,-25365,-7816,-17858,-22768,-3014,22201,-16149,18189,8085,-12679,31724,23094,-15645,3317,-706,13272,4349,-815,-29966,-25159,-23089,5941,-19478,8082,-20578,-19235,3952,23313,20259,7166,17335,32123,981,31599,63,11487,-14145,28232,29454,11838,32124,19374,22667,8904,-25245,27607,-29184,-17109,-15259,28442,-28684,18000,22597,-13400,-7098,23037,-20670,26281,-21410,16040,16497,-24075,-30887,-18276,27482,2879,-12190,24517,27469,7986,-5607,11619,-509,25575,23147,4264,22587,10353,-13903,-30563,29784,26213,10367,18813,-10171,18573,19992,-25622,-30497,-9420,15112,2745,-9507,20454,29164,-23236,10239,-18090,-1043,26654,-30647,-28198,27267,15952,5553,-32597,26917,-31779,-22676,29504,-23341,-30816,-27677,24424,-3097,-527,31467,-7939,10318,-27759,28120,5176,29029,14174,28025,3130,16565,-5668,-22866,-9796,6438,21171,28500,22504,-16458,11738,-11722,-23523,-26958,-6582,-9982,6733,1888,-13736,-32593,-30301,-31224,18150,19509,-32374,-917,12797,1101,5696,25357,-18506,-22924,25359,-29751,13771,9775,-7046,28316,13280,15658,9243,16874,8177,-31513,8755,15031,16264,5627,26764,20389,-15416,-6309,-22406,23333,32412,1773,-24038,4759,-24854,-18467,21317,4488,-29788,-15523,-5264,1058,14096,29577,6832,9986,-8521,9381,31463,23966,-14826,11426,-19594,13198,6363,31696,-28909,-29207,32610,-1621,-12399,-13727,22779,14821,8040,-517,-32110,22057,7432,5352,20334,1112,7658,-20765,-3847,9356,-14312,-1951,7178,19517,-7858,28587,6581,7313,-16324,-3310,-6593,-24582,-11739,11643,17856,-19876,-11471,-7167,32741,308,-19884,-14435,-13948,-4202,24187,28043,6235,-2238,-372,31502,-5922,-1819,26529,-11937,16114,18657,15181,-3205,-21897,-22954,2896,6149,-12580,23578,-19970,18897,17044,-9432,-17176,12454,17760,4940,77,-19226,15645,-18953,-27884,16264,-22524,24381,19762,737,1902,31423,12782,28303,-13176,-32531,15596,28484,16722,9107,-22850,-22311,-26545,-25481,-5890,2859,16252,-14194,17598,-2650,-20164,-30368,-26353,17837,14568,22257,-8365,-13954,-6798,20739,-11346,-1087,-28329,21464,9680,6693,23724,-10207,10962,11874,1353,12635,-4695,10283,19682,-19251,-22863,-24828,-31259,13746,-24632,5123,27473,20979,-29385,-21893,4445,-3793,8718,-9431,26205,-2413,-3229,-32127,-10144,-20638,-5358,-23522,-10504,-20228,-21525,3964,23795,-15293,-8045,17488,7960,1361,-26329,21103,2449,11060,8551,-29582,-25803,16842,-2075,21923,13226,-19735,2497,-10292,17880,10264,17454,-8124,-10299,-23183,-32500,28788,-13247,-31844,-30958,32099,-32478,-21263,1101,30938,-15226,7033,-22480,6838,3237,-6734,32541,16513,23769,8170,-297,26179,-26860,-23071,21056,6654,-1911,54,-8684,-27156,-27468,6807,-19185,-20965,-13301,23570,-8224,-3806,-24380,-12952,20548,-27704,-11768,25157,32100,-8350,-14477,17795,8868,-8539,11698,21326,12984,-22315,-27732,32515,525,7265,-16167,-29893,16599,-18673,11808,-16238,-14030,-12465,17287,-7779,-728,-22722,921,24437,28132,-3821,26725,-924,31778,3473,-27099,-16003,-28156,-9255,-24440,5234,-8022,30485,24193,-15066,30833,10542,-18034,28910,24009,-16794,-17663,14438,-20855,-2068,-28535,-27960,-12612,-32328,29618,24942,4199,26358,30628,10710,21616,-10693,-1352,30472,-1387,5172,-18241,-25348,-11383,-22927,15407,11639,30891,-6641,590,13357,14348,-13622,-4984,-32405,-19005,-7869,-25648,23469,26110,16255,-31409,-1659,-11711,31174,10844,-31061,-16431,30454,-380,1753,2085,-4440,18226,2739,-22122,31850,9571,-19497,6609,4820,-16207,3490,28231,16680,13389,-13441,-11282,15606,5407,5619,13070,-18579,25302,30877,31332,-20318,-18207,-6401,-13247,-21204,17944,-798,-8071,-151,-32093,22144,26827,31239,-227,-10411,11564,-26503,-20153,-10517,13045,850,3962,3557,21027,-28139,596,21109,-21141,2178,-6860,-28097,2239,-21625,4468,5111,-19244,13254,-26654,-31104,-1736,-13701,-23616,1501,10286,-11370,-8853,32083,-2919,-26200,3007,16805,5689,25484,-4179,-30797,7140,19633,-10954,-2788,-13479,22302,12336,-15173,-20494,-28177,16787,12523,-24427,-10462,-23716,32121,-22478,-22507,-10351,15990,-11699,-25170,3482,12456,-27188,-30584,-9821,19031,14471,-22555,-20824,-13134,10917,-29653,259,-1293,-24977,3369,-13134,-14504,-32499,13599,-27313,11986,17794,-27641,-21875,-27093,-3585,12401,-26337,1217,-10212,10545},
} ;

static void test_encode_857xfreeze3_impl(long long impl)
{
  unsigned char *s = test_encode_857xfreeze3_s;
  unsigned char *x = test_encode_857xfreeze3_x;
  unsigned char *s2 = test_encode_857xfreeze3_s2;
  unsigned char *x2 = test_encode_857xfreeze3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_857xfreeze3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_857xfreeze3(impl);
    printf("encode_857xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857xfreeze3_implementation(impl),ntruprime_dispatch_encode_857xfreeze3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_857xfreeze3;
    printf("encode_857xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_857xfreeze3_implementation(),ntruprime_encode_857xfreeze3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_857xfreeze3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_857xfreeze3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_857xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_857xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_857xfreeze3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_857xfreeze3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_857xfreeze3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857xfreeze3")) return;
  storage_encode_857xfreeze3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_857xfreeze3_s = aligned(storage_encode_857xfreeze3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_857xfreeze3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_857xfreeze3_x = aligned(storage_encode_857xfreeze3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_857xfreeze3_s2 = callocplus(maxalloc);
  test_encode_857xfreeze3_s2 = aligned(storage_encode_857xfreeze3_s2,crypto_encode_STRBYTES);
  storage_encode_857xfreeze3_x2 = callocplus(maxalloc);
  test_encode_857xfreeze3_x2 = aligned(storage_encode_857xfreeze3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_857xfreeze3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_857xfreeze3();++impl)
      forked(test_encode_857xfreeze3_impl,impl);
    ++test_encode_857xfreeze3_s;
    ++test_encode_857xfreeze3_x;
    ++test_encode_857xfreeze3_s2;
    ++test_encode_857xfreeze3_x2;
  }
  free(storage_encode_857xfreeze3_x2);
  free(storage_encode_857xfreeze3_s2);
  free(storage_encode_857xfreeze3_x);
  free(storage_encode_857xfreeze3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

