/* ----- decode/857xint16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_857xint16_checksums[] = {
  "f1975f4d5aa9b69374c1b286295468accd26c0ea75cf76cceafcdd4142155810",
  "5e1d78e028b3f6eaa1be2526e5f3165ebd75ab25ad76cd4df3bd2376e70ab631",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_857xint16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_857xint16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_857xint16_ITEMBYTES

static void *storage_decode_857xint16_x;
static unsigned char *test_decode_857xint16_x;
static void *storage_decode_857xint16_s;
static unsigned char *test_decode_857xint16_s;
static void *storage_decode_857xint16_x2;
static unsigned char *test_decode_857xint16_x2;
static void *storage_decode_857xint16_s2;
static unsigned char *test_decode_857xint16_s2;

#define precomputed_decode_857xint16_NUM 4

static const uint16_t precomputed_decode_857xint16_x[precomputed_decode_857xint16_NUM][crypto_decode_ITEMS] = {
  {49650,16705,43988,1219,27760,35738,22685,33148,59491,62739,53439,979,58063,30414,53634,50308,38330,24025,4026,39179,1862,14044,5281,29087,50037,45369,17751,5506,21961,41675,24462,15257,34344,25291,25554,22708,30764,17276,64460,481,23532,10881,28375,58395,53198,63506,62373,16938,34592,47975,48557,59586,64983,53796,32906,14871,34997,57564,62799,55962,31999,57032,55118,20589,44437,20828,55414,42440,8892,26983,36091,35577,30982,51988,45187,54760,54041,61981,59550,26766,45517,48774,19374,22005,56573,14014,63526,52955,13346,47199,14971,34836,33976,26090,11170,33664,16016,49000,39130,11659,59089,28868,14607,42029,34084,52213,19532,50477,46638,23956,56488,52748,30026,44994,16941,45965,46353,63187,33653,6465,16305,55589,63643,49134,42922,9924,26273,30294,46690,42034,34418,64662,47310,62065,41101,33320,54729,30200,36305,51616,28929,30164,39743,49968,21186,25040,8505,55855,49274,3865,53205,47642,18671,47606,58320,51031,5277,8765,6051,7088,26978,33063,56305,52331,45056,780,24515,13686,37800,32823,21559,10085,15315,20504,52743,19322,29129,18604,41952,36455,37473,31079,3402,53420,44525,48348,56444,16421,34352,37039,18776,25157,13825,43218,63718,25658,5665,8571,19884,26641,12637,42540,18761,27491,47203,2988,46246,2532,46254,46684,38109,8545,11985,18258,64970,37684,50775,219,34112,12960,37621,12226,30528,50045,33981,30785,46863,15003,23100,38999,17478,30457,2457,28892,1830,63664,11561,62430,2947,40700,31350,43310,4145,50673,63829,23420,15333,56884,58911,64371,3207,7601,64370,25633,31905,31671,6732,1640,9197,56862,1697,30851,22272,8498,51706,56226,7439,8810,22204,65158,9097,17887,60665,40912,4800,303,58787,61950,51514,24659,48818,14012,21,13873,9349,53986,62268,34690,64487,64648,18542,46712,59794,63606,1681,5973,46773,37875,33720,11920,16203,29459,99,16269,57226,17789,28067,921,29877,52917,10032,11378,47352,56308,45702,11141,31735,22616,17607,57273,44832,11118,16505,3524,54779,26798,5264,23134,19206,18111,10049,17008,12004,6945,12450,8248,2112,28253,16037,58894,19981,50800,41492,60113,9995,9768,36334,23516,29451,10650,58178,58863,43376,39186,26921,29691,46844,19597,57205,29308,16627,37885,65177,27079,14265,5804,53710,15620,29827,60483,1840,24086,30045,35932,46280,39395,6393,40209,10454,43792,15757,23913,13404,33318,17025,2461,59393,17640,29731,57778,11149,50876,64564,49239,53967,45932,4166,6505,49813,22355,9506,6929,62558,41504,44391,31514,59221,48442,10117,61632,40212,60422,17052,44950,47378,17635,46688,35078,31286,23164,48721,32007,15136,942,21768,28299,50124,65135,3205,53435,28806,342,3946,30774,59937,8198,960,13633,20977,36438,24667,18132,56406,44949,20331,12259,39878,51648,64213,37218,53381,14160,10222,29652,23906,6911,29264,24373,42110,37575,62331,42221,28967,46111,31071,57809,13823,8949,23632,5848,59181,29584,30320,52201,58089,19975,53978,11607,18106,31549,19421,13979,27659,3883,45848,18870,60062,13642,1081,31045,11384,17340,48706,23538,3304,50464,51541,14397,60299,15235,25685,17006,54682,10606,29618,41967,43240,40601,65118,39465,23116,16060,23851,57482,6727,20110,5531,35158,14403,60420,58947,60311,38008,9240,14487,32250,7808,14696,27776,65233,11035,55667,14842,50695,40723,48745,64898,32305,56300,25234,27843,28314,59539,41918,27730,11124,51143,62188,51138,10991,53763,21490,17237,57947,9345,25876,33399,60398,43697,39152,40321,60107,27356,61738,40815,13533,24788,61124,57072,37470,42129,51203,1398,62304,3093,23498,10093,34272,55818,36693,20937,16072,23759,21343,38490,4784,46117,51509,32034,4505,60423,61056,51545,13023,30120,11933,1068,27795,10485,9731,44716,8561,12211,23702,56887,22794,36866,4811,12870,14061,13090,44319,12383,43100,45201,58003,13542,416,6557,16086,65371,40736,42244,52144,7476,37942,23438,52268,1263,30703,39012,27864,53203,50194,25621,10614,33369,45545,64439,45833,64229,3093,52737,25637,14000,20136,8592,47873,62838,20215,34989,57809,5034,43293,45422,26091,56189,22312,54327,58892,17085,12184,26426,8786,59362,22811,44430,26388,12958,34959,32094,35272,7310,38982,31459,40067,44865,25877,6057,39741,17529,3322,63958,56162,63504,21108,29731,44350,41669,27091,55558,22465,29026,36808,8378,34759,38971,31632,34381,2746,28032,43974,38241,8647,61752,41500,40967,26240,55395,40413,55116,55539,26417,57177,48434,17721,5488,13508,31838,4124,31776,22915,48606,39775,54032,6046,28901,23738,45382,16460,2739,47084,50222,58300,23147,55688,24398,2664,38367,40969,17665,29410,17706,42005,12624,50588,12735,63299,9466,60097,20475,64165,36602,1595,52010,62994,2786,19527,15174,19523,16156,22406,7480,12517,7804,37967,13625,54207,12061,57457,34417,55963,6345,25092,9897,49153,31808,30818,38074,2574,37931,14953,61743,32951,42338,1763,39129,14820,64748,13707,14666,39223,50594,2713,54495,40388,2730,28111,12839,48449,41091,25898,7523,29159,1962,50652,20975,44723,8828,22129,5902,23313,38880,41656,44752,16426,24219,6704,24559,27293,64901,14386,21519,53408,8795,9854,43738,30651,54269,18842,61050,41997,7839,49553,216,59180,13453,52867,60181,63244,52629,21732,55252,64743,6920,23317,64680,63015,23862,39132,15740,37272,1317,19950,1961,39922,7413},
  {7371,39169,41408,38144,24868,56418,3906,11662,50751,4668,22821,28163,19358,22328,13029,21747,1507,47114,38096,42953,36982,39288,28302,59197,15920,50708,46483,39496,54199,11341,21503,40523,27487,65198,23655,55186,27593,58448,49898,58876,41957,60799,23490,52717,52761,42085,26109,37081,50851,43194,33261,30217,55826,30545,6159,5948,31111,27031,35680,59622,47843,16865,337,33941,64585,2252,54854,26590,44509,47371,50511,45923,54295,42893,37999,28402,9688,6069,14797,20042,14617,16869,51271,48170,52005,62715,65316,668,5612,5939,44679,7001,1758,50497,42518,56098,49820,33483,38301,47529,49768,28860,21028,36256,59886,62274,32533,20706,31830,57800,33220,10801,8917,61211,16346,29486,7783,43891,1745,62125,33374,7675,30734,2669,3468,33438,13333,54522,8721,50435,59842,48953,12181,47217,30600,36327,24120,721,30086,30655,37388,62056,38516,30208,6836,61093,55407,46604,35657,9249,59854,21390,3288,59984,60060,7272,36705,3187,7372,51055,32244,2316,60246,29126,17757,133,4754,10562,19587,6260,12400,6489,54726,14921,44377,5722,32225,60628,21009,16038,47925,30774,57488,55155,22748,10032,8307,7036,50102,20303,65464,46598,61177,15113,40568,14690,26880,25687,59466,55157,9262,17307,60623,31886,62666,28515,32778,48702,5857,11490,54455,58531,63712,56093,676,18811,57716,23718,19800,2099,58704,11224,17009,19629,62775,2490,55979,43423,64039,5173,59255,639,10906,36490,52395,53349,5215,23624,55938,4373,52394,49991,15673,9207,42536,16105,40770,24657,50250,36903,47294,62661,59171,17880,16273,24555,58534,12338,31761,10405,10088,19777,52005,10108,40933,11999,31710,54715,6692,20783,53331,1830,3490,38478,52003,42448,61733,56020,21052,60375,49098,34583,17702,63522,27825,51893,65273,2205,41165,36636,46754,9684,63629,52929,18621,57997,4235,4484,7019,62025,18296,13880,58,64835,36890,32963,62240,64508,6623,27779,47049,20362,45112,63849,51078,46481,9994,64236,60395,51366,6352,50697,48743,50520,57819,25598,58164,53952,42402,17577,61813,40808,45011,51423,63951,20907,3523,41437,30885,1558,60148,56262,56014,39649,40271,53736,29927,13818,9007,23230,805,12691,14187,35259,13357,1639,64108,4666,18058,47766,62384,44754,41194,46042,22298,15362,22719,42852,36941,42471,11386,14363,48837,51873,57741,61641,377,61804,18762,39516,22452,43514,21160,22260,29129,61570,62911,3499,51413,28526,3105,30063,24501,9002,50614,36304,18860,35513,19324,42565,3715,36290,38488,31988,15449,10013,43077,22466,41630,26801,26697,12597,54585,5538,59510,27862,11556,10903,13933,30299,39141,49553,32728,11738,64697,11848,40633,6663,59123,7812,21916,36053,1307,41650,37258,13928,50915,22314,61362,55589,1064,35423,24862,58400,48845,19442,25958,6280,11109,34164,3827,36280,28922,46344,43024,31085,7284,12881,55818,1222,31774,60570,57135,45631,19176,60991,37237,6345,5927,16305,36644,2514,13483,50625,12717,5554,51925,10567,7788,60150,51578,22175,49865,10329,57042,34502,49723,37049,32797,13703,46705,31395,50039,34730,37656,38863,21205,22777,19513,37921,43272,43692,60627,53768,36822,28733,41951,8029,64,38168,57120,50303,59020,18860,49972,33105,56197,36537,21090,16235,62478,9830,57326,30610,12704,56781,3188,13882,39953,47893,26855,54123,20158,43665,6477,9529,7061,10468,55970,7277,6577,42124,39401,11059,22045,40158,45816,58218,25727,33761,1828,51423,44132,13160,6650,22069,40946,54690,6133,53396,29968,55069,425,52739,50558,47508,48210,13769,43511,47372,19873,37445,43622,10279,55800,16765,48441,33424,56801,13474,43772,60418,8348,64413,57718,53131,42738,29976,39552,9624,45041,31457,55515,41304,22464,60680,4860,32098,10893,55628,56347,54462,9186,42221,35976,22046,57630,34033,28048,23729,44953,42119,41640,7027,42958,9866,41339,51024,39030,61320,8550,48760,33825,48209,42356,16480,45734,47230,61481,23329,37093,39405,20463,58153,65283,13583,20786,43648,62540,13564,45807,41285,60994,29122,9936,46406,57890,38672,21129,6763,26243,3878,21550,40005,61408,3556,15979,25247,49202,44099,34903,9408,1456,24903,37811,59013,13472,1358,43699,56449,28750,32087,54662,42109,34377,924,53966,60027,3629,53229,57991,13880,8346,26079,40359,46202,27039,28817,156,20366,58925,47098,48307,33204,51599,50076,48752,37532,44372,57713,17334,34049,15840,54442,19646,53864,55142,50658,37871,9200,58968,32379,58015,14416,35197,5972,54532,49333,37242,59933,13045,13456,64590,57492,2811,4146,41358,39838,25876,3382,5512,6829,60070,36056,29371,64120,50087,50002,51285,25082,22019,65035,61962,15894,61898,27912,3391,33358,36377,38768,52926,62167,48495,18092,19127,1004,39323,60899,6889,12379,62688,1883,6723,35896,54431,6821,53423,11851,18468,65091,46068,32245,1336,22077,10688,23863,62049,29039,44608,23311,175,36445,44825,15809,15985,51598,41487,32045,27745,32734,56245,33031,12089,13882,28804,49339,45519,45195,14292,52635,51282,60904,64129,55061,21034,14673,53797,63740,30964,43719,32913,14567,62001,64697,49402,15516,24234,43373,56471,41528,18154,60096,11961,61485,21907,33123,55846,26774,12721,32799,757,63918,25707,16221,30357,32164,52259,53914,35086,59056,8912,15321,37586,58411,11169,32429,28665,54419,45276,45167,12129,28818,9900,40954,39135,18147,17862},
  {40968,19742,25439,42073,61096,46376,12009,40785,61946,57314,6274,8291,9162,36813,32406,49746,34673,30501,17689,21665,6593,42061,25387,33939,46164,6592,18422,38637,62322,30512,50647,60043,46844,49448,10043,10963,30201,28733,57115,48425,19253,7748,45367,7756,40806,46652,40126,56625,11758,2105,5219,15579,9052,3495,6355,21953,55912,1,49556,65402,17240,18356,49008,13766,20540,53815,15694,31851,32799,27157,39022,50352,125,3252,16106,24202,20484,6734,20752,25607,15701,47107,10607,41927,21161,28144,60938,47632,41936,16145,6823,53316,36203,14087,51820,24565,53655,54118,21636,56522,11371,2216,41463,32059,14517,52133,6701,22112,8120,59157,54408,769,59397,2904,24521,57962,29985,21070,39126,18560,54680,45235,63156,46846,41787,31380,61009,53685,53965,30059,9530,26207,21633,42622,54876,28886,28723,46546,47975,42715,39007,19261,52807,63911,39372,45380,34953,5676,10572,37047,61058,28444,14342,18863,59711,27060,61425,43972,59220,44857,64111,8922,26855,42458,27867,49379,55686,18381,15852,572,40431,35654,36529,44763,9846,561,12572,51424,22266,1099,38221,52501,27888,13193,31343,8368,21824,53602,30523,43719,33168,14806,33063,10494,22609,52496,23687,2645,8600,28206,38476,61827,20688,60892,24801,13443,30337,28784,28706,21728,25983,52893,60975,8463,39426,27582,43364,32275,16369,50428,3244,43173,46009,38255,62977,14129,36549,64972,7760,1052,16865,45489,46816,41155,50100,49748,58248,19895,65233,34376,43056,54252,30744,44176,21977,1950,6025,24870,381,34770,18331,34006,43711,26910,2319,50682,27774,56715,16678,36262,24544,10437,20768,57157,48987,26352,54752,55441,24309,21012,21634,47409,21647,5444,62154,42596,10811,13340,25311,48425,16333,52612,56282,3635,11366,18584,21915,53958,3167,14128,46043,41154,27471,64225,15832,41991,43174,15608,24496,57271,59675,30930,30171,41713,59099,55439,4978,22149,6076,43468,63863,11493,65411,10029,45686,7665,34568,14556,45685,50691,7720,50048,60680,7443,64222,5469,2884,42215,47317,56203,39921,20937,14373,38760,6932,47628,47866,9551,36764,37440,43776,11705,9427,16938,3855,38317,6620,2437,50987,51887,28300,8365,47422,58292,12207,54091,15554,39415,55774,11148,33665,28239,44112,15171,50020,16398,749,8415,25654,36458,43088,50318,30513,56177,56359,13113,4067,57977,63003,59829,35746,7460,17139,10132,61348,50135,36973,63797,33196,35528,14548,4162,11701,16180,27502,625,13110,50493,53163,37224,24254,302,62865,34760,60268,40861,50143,45084,895,10186,14773,19610,50372,21260,63109,31262,55655,3666,27606,40887,33014,19700,19361,24180,51994,48945,46482,4770,31255,27942,40712,43829,53822,58655,14353,29719,55386,22938,46678,17838,36539,38400,43807,51685,35064,57918,27842,6383,20149,51622,39775,42643,59134,34879,20070,48817,35112,49708,43871,57590,53344,36393,26353,6914,39179,51885,36684,60937,27742,25437,16756,48785,18229,27061,25230,51003,54381,18229,46506,20953,26111,24767,32672,13834,25555,47535,24589,33113,51091,12277,50308,16258,45462,4349,18348,20276,63323,39014,14107,54332,19058,65293,38272,20101,8957,60649,18943,45620,30271,1079,58650,43522,56137,32134,12818,23152,4865,47122,23851,10373,26330,23690,47539,18283,4874,25878,50760,29684,10973,50532,34795,51546,38655,25918,6940,17010,15277,44804,17961,46613,18003,26770,13617,9738,55315,62136,40364,29598,47499,62409,39280,20608,45816,16783,42714,44537,20987,30925,28402,27263,53155,50487,1078,14222,35987,37040,28940,9646,16998,37348,65141,36549,9407,9182,17717,29532,29967,24427,28636,40437,50839,30961,60357,15097,2305,51694,8995,30091,29655,51269,14726,60096,31722,27913,54723,33851,8352,59197,50828,64091,46103,3382,25521,58635,1361,6051,39215,328,59554,10534,45520,46172,40230,39042,45973,320,41869,60778,14183,61946,11652,58599,7402,48310,3885,2339,47110,19260,14634,62742,25367,52170,5083,38395,40560,54646,47511,45808,59486,57279,5435,61061,64831,38365,17685,22348,48225,13504,24595,18619,53518,47807,30774,33226,36287,24047,36860,13281,34258,22817,42790,54762,60650,53670,43552,51676,28636,33707,54763,43617,38533,54507,42286,242,3674,15148,43204,34787,5632,17823,18807,11981,41617,40168,22280,56454,25304,30633,27443,31457,33456,17092,55390,46057,40055,32187,27087,34416,8414,7728,11668,8353,4187,54567,5918,54500,15069,29446,25424,1438,60211,1012,40817,13171,63961,16658,35056,47177,13211,22312,65532,1478,10051,16642,4399,14698,8318,55138,55632,21914,36913,36535,36814,50829,44443,25553,24434,56646,13213,3726,7103,35716,5869,11283,9493,30203,41953,43622,19887,3690,16046,14231,65138,62984,54655,55577,38992,25298,58874,38400,41880,31191,49634,42438,1052,16372,54283,43477,10913,21683,34608,49044,7895,61495,27296,11720,41760,7903,42305,54159,55229,36300,21231,63380,18737,65117,38424,591,10390,27960,49879,29945,18443,2437,41671,47404,5464,37485,29112,30337,18025,27173,18772,64303,53979,58674,54517,59328,13964,2864,16204,25157,61689,29411,14990,9059,55354,60615,64002,17789,5283,18579,29666,22171,53299,46531,829,12263,9348,8338,36978,46007,50574,58144,57448,54610,54731,55967,52114,38726,8591,46079,16545,55532,55855,45988,58333,29555,31703,63707,8386,51478,24110,21390,33657,30842,13972},
  {995,17760,6952,54314,19428,17266,63692,11086,58101,49608,58121,43107,53940,51222,56370,61387,43713,56713,4379,12078,6925,18397,13137,47886,41322,9119,16783,45983,20611,8626,19021,50072,61891,41719,21134,24851,35162,28085,57028,49859,3732,40957,59938,11919,18387,58896,14729,45261,62934,7308,24191,16326,78,64261,50914,22185,31029,39913,51772,40025,7113,192,20590,8115,64200,64262,34890,26741,30051,49426,57585,10353,59193,8132,9226,58611,45587,8687,7139,30333,10694,47698,13910,25971,27317,19600,56974,22975,40354,58028,44649,23339,61838,28529,18704,44192,14659,14998,8952,13195,50943,11456,14272,3973,22997,35300,16322,58673,6342,48420,14358,29376,53349,44436,41431,50475,2926,2971,10745,42285,33547,15644,47543,30184,35580,26565,758,44400,53129,60194,63052,189,32238,39851,52382,264,20790,55652,13967,38363,43758,39612,37048,3338,37649,43774,9127,64142,26658,55134,27295,64246,17827,63514,23376,26694,40744,26807,44240,39873,53980,55705,29378,47520,2205,38678,37897,43886,24876,170,33636,42009,31263,21653,63968,55803,10265,37090,9270,60303,22905,43211,36416,29068,48317,45603,10660,25948,59046,33547,4408,21184,42221,57784,51237,11759,53468,2026,53392,50548,56326,38309,5543,10514,53694,9218,231,15410,26688,22816,34748,41841,64518,50586,18585,13926,22191,41374,33033,39846,29819,9807,7281,54160,14634,3729,7465,29451,23414,19979,17384,44203,65208,43332,7095,59373,34693,54740,15019,18275,23157,11443,23786,56050,33774,57144,60854,21139,25048,10396,18815,32058,19162,2276,14405,43160,52544,60578,18653,22431,15658,57706,31073,6664,975,23213,37055,45145,19898,4207,47059,1922,38488,24812,13735,22809,13202,47682,1372,5373,55410,22129,44974,30511,51328,58529,63177,20255,34818,1643,9689,20059,12140,50611,18383,43698,39578,44463,40237,60771,36480,29583,10133,57846,25913,15777,3774,50475,63170,61287,23535,5172,23634,8977,11530,21606,59458,48577,17675,57020,51489,1882,16166,30539,57446,30620,57722,17323,45322,60,12733,27575,12331,11032,29425,29567,56567,14365,45633,31161,25500,11217,16881,65318,42393,39073,54168,16191,24644,57162,3105,50031,26407,34860,52918,25512,49419,3074,62600,60001,48738,40753,24286,28911,44193,1103,47821,63110,27262,16870,36609,18335,43751,28281,11862,26066,42723,22984,45631,19498,21280,57357,27120,57239,9783,38729,47919,13769,18245,1121,27062,10267,50240,9819,432,43805,22588,11838,11810,10444,61224,16817,23958,17464,54597,17002,53770,6334,5989,17030,24040,32116,43562,3854,34806,8536,34894,59079,34616,62798,49446,58959,27556,23257,54250,17422,25076,43157,24917,6828,29768,56019,37237,63747,4397,41653,48550,29997,42480,21131,32505,36615,24363,9427,65020,7880,45244,36629,23739,54029,13483,11108,26560,1204,46117,135,32839,43915,58760,22224,34875,33026,19982,16250,51852,54627,33751,44036,30850,24710,23398,46887,58163,19467,36765,47064,55663,58738,37523,58604,59338,34721,11079,17491,63107,49567,3440,60225,16036,11532,29370,56526,14675,48927,58897,18256,11184,24762,29231,8732,5107,65032,34354,38135,48884,16996,54052,35117,4710,60111,58194,26137,42347,5518,53186,32706,22968,22135,58084,26269,9305,54015,33004,18237,41463,15865,46544,18848,5835,41334,7525,55816,3179,25427,64008,6789,27174,65112,35154,17816,15647,16660,110,31505,48679,32983,24465,40376,16590,5921,40753,62661,19957,30502,19211,48041,60786,51868,21151,31693,30450,37865,43503,46920,39027,29527,24891,22603,23148,47206,52966,53762,37461,35004,53067,7474,36699,21481,57404,28746,26674,49405,30668,58093,18390,42492,29221,33118,8970,52918,35366,50825,6547,37310,27427,10053,64150,49675,6851,22067,54319,54571,20172,54907,42369,16773,54804,23816,55507,64540,12664,47936,37334,17025,2531,30174,18917,39073,34928,13826,1271,37952,6018,40285,18714,5593,16503,58487,52577,18925,47806,36007,20559,45036,27218,12083,22366,7439,28524,10966,41429,17993,2779,51018,22141,54939,58298,38787,10017,63110,55422,61406,27777,64974,36596,16848,32221,42549,48445,17622,45047,14880,37844,55518,10363,28202,9620,16902,30163,5132,3731,23370,45009,52698,27138,63444,6517,14701,10855,57252,13759,58396,7699,36410,18286,3609,57477,55412,17350,38419,9328,54397,44165,60213,43643,36671,50345,7965,18614,54266,55961,61897,19044,13290,1915,61160,32761,58351,55375,40522,44604,24636,48197,13920,61445,24888,33545,2652,28618,44677,65113,11541,48459,43639,50064,49249,30026,59353,29403,45226,52691,6780,5506,30995,47337,28547,53737,21791,1040,10014,5172,65095,27861,55916,65031,63697,48801,33417,27697,10750,18584,34386,34349,58634,63253,33844,26178,31518,38044,7834,56939,46,39524,27516,50638,38803,62373,13165,60942,60181,40526,49668,58070,10129,41122,58665,52230,45382,64863,49466,36683,19256,61113,30629,2816,7635,28478,9749,38849,33352,40518,6995,52552,43584,46970,15432,14617,59107,3445,26569,22169,40484,39664,64922,13599,58974,52701,5006,6920,57320,1683,12316,48733,48726,46906,53358,59128,59549,24886,13822,15039,21035,48761,46284,10181,24199,38547,30839,36719,11029,55048,33372,20058,38326,61915,39994,57845,9900,22727,19852,36175,61634,19820,43610,17712,13810,13147,46878,41131,52179,1307,37675,49854,56403,441,51728,18723},
} ;

static const unsigned char precomputed_decode_857xint16_s[precomputed_decode_857xint16_NUM][crypto_decode_STRBYTES] = {
  {242,193,65,65,212,171,195,4,112,108,154,139,157,88,124,129,99,232,19,245,191,208,211,3,207,226,206,118,130,209,132,196,186,149,217,93,186,15,11,153,70,7,220,54,161,20,159,113,117,195,57,177,87,69,130,21,201,85,203,162,142,95,153,59,40,134,203,98,210,99,180,88,44,120,124,67,204,251,225,1,236,91,129,42,215,110,27,228,206,207,18,248,165,243,42,66,32,135,103,187,173,189,194,232,215,253,36,210,138,128,23,58,181,136,220,224,79,245,154,218,255,124,200,222,78,215,109,80,149,173,92,81,118,216,200,165,188,34,103,105,251,140,249,138,6,121,20,203,131,176,232,213,25,211,29,242,158,232,142,104,205,177,134,190,174,75,245,85,253,220,190,54,38,248,219,206,34,52,95,184,123,58,20,136,184,132,234,101,162,43,128,131,144,62,104,191,218,152,139,45,209,230,196,112,15,57,45,164,36,133,245,203,76,76,45,197,46,182,148,93,168,220,12,206,74,117,194,175,45,66,141,179,17,181,211,246,117,131,65,25,177,63,37,217,155,248,238,191,170,167,196,38,161,102,86,118,98,182,50,164,114,134,150,252,206,184,113,242,141,160,40,130,201,213,248,117,209,141,160,201,1,113,212,117,63,155,48,195,194,82,208,97,57,33,47,218,122,192,25,15,213,207,26,186,239,72,246,185,208,227,87,199,157,20,61,34,163,23,176,27,98,105,39,129,241,219,107,204,0,176,12,3,195,95,118,53,168,147,55,128,55,84,101,39,211,59,24,80,7,206,122,75,201,113,172,72,224,163,103,142,97,146,103,121,74,13,172,208,237,173,220,188,124,220,37,64,48,134,175,144,88,73,69,98,1,54,210,168,230,248,58,100,33,22,123,33,172,77,17,104,93,49,44,166,73,73,99,107,99,184,172,11,166,180,228,9,174,180,92,182,221,148,97,33,209,46,82,71,202,253,52,147,87,198,219,0,64,133,160,50,245,146,194,47,64,119,125,195,189,132,65,120,15,183,155,58,60,90,87,152,70,68,249,118,153,9,220,112,38,7,176,248,41,45,222,243,131,11,252,158,118,122,46,169,49,16,241,197,85,249,124,91,229,59,52,222,31,230,115,251,135,12,177,29,114,251,33,100,161,124,183,123,76,26,104,6,237,35,30,222,161,6,131,120,0,87,50,33,250,201,162,219,15,29,106,34,188,86,134,254,137,35,223,69,249,236,208,159,192,18,47,1,163,229,254,241,58,201,83,96,178,190,188,54,21,0,49,54,133,36,226,210,60,243,130,135,231,251,136,252,110,72,120,182,146,233,118,248,145,6,85,23,181,182,243,147,184,131,144,46,75,63,19,115,99,0,141,63,138,223,125,69,163,109,153,3,181,116,181,206,48,39,114,44,248,184,244,219,134,178,133,43,247,123,88,88,199,68,185,223,32,175,110,43,121,64,196,13,251,213,174,104,144,20,94,90,6,75,191,70,65,39,112,66,228,46,33,27,162,48,56,32,64,8,93,110,165,62,14,230,13,78,112,198,20,162,209,234,11,39,40,38,238,141,220,91,11,115,154,41,66,227,239,229,112,169,18,153,41,105,251,115,252,182,141,76,117,223,124,114,243,64,253,147,153,254,199,105,185,55,172,22,206,209,4,61,131,116,67,236,48,7,22,94,93,117,92,140,200,180,227,153,249,24,17,157,214,40,16,171,141,61,105,93,92,52,38,130,129,66,157,9,1,232,232,68,35,116,178,225,141,43,188,198,52,252,87,192,207,210,108,179,70,16,105,25,149,194,83,87,34,37,17,27,94,244,32,162,103,173,26,123,85,231,58,189,133,39,192,240,20,157,6,236,156,66,150,175,18,185,227,68,96,182,6,137,54,122,124,90,81,190,7,125,32,59,174,3,8,85,139,110,204,195,111,254,133,12,187,208,134,112,86,1,106,15,54,120,33,234,6,32,192,3,65,53,241,81,86,142,91,96,212,70,86,220,149,175,107,79,227,47,198,155,192,201,213,250,98,145,133,208,80,55,238,39,212,115,98,93,255,26,80,114,53,95,126,164,199,146,123,243,237,164,39,113,31,180,95,121,209,225,255,53,245,34,80,92,216,22,45,231,144,115,112,118,233,203,233,226,7,78,218,210,87,45,186,70,61,123,221,75,155,54,11,108,43,15,24,179,182,73,158,234,74,53,57,4,69,121,120,44,188,67,66,190,242,91,232,12,32,197,85,201,61,56,139,235,131,59,85,100,110,66,154,213,110,41,178,115,239,163,232,168,153,158,94,254,41,154,76,90,188,62,43,93,138,224,71,26,142,78,155,21,86,137,67,56,4,236,67,230,151,235,120,148,24,36,151,56,250,125,128,30,104,57,128,108,209,254,27,43,115,217,250,57,7,198,19,159,105,190,130,253,49,126,236,219,146,98,195,108,154,110,147,232,190,163,82,108,116,43,199,199,236,242,194,199,239,42,3,210,242,83,85,67,91,226,129,36,20,101,119,130,238,235,177,170,240,152,129,157,203,234,220,106,42,241,111,159,221,52,212,96,196,238,240,222,94,146,145,164,3,200,118,5,96,243,21,12,202,91,109,39,224,133,10,218,85,143,201,81,200,62,207,92,95,83,90,150,176,18,37,180,53,201,34,125,153,17,7,236,128,238,89,201,223,50,168,117,157,46,44,4,147,108,245,40,3,38,172,174,113,33,179,47,150,92,55,222,10,89,2,144,203,18,70,50,237,54,34,51,31,173,95,48,92,168,145,176,147,226,230,52,160,1,157,25,214,62,91,255,32,159,4,165,176,203,52,29,54,148,142,91,44,204,239,4,239,119,100,152,216,108,211,207,18,196,21,100,118,41,89,130,233,177,183,251,9,179,229,250,21,12,1,206,37,100,176,54,168,78,144,33,1,187,118,245,247,78,173,136,209,225,170,19,29,169,110,177,235,101,125,219,40,87,55,212,12,230,189,66,152,47,58,103,82,34,226,231,27,89,142,173,20,103,158,50,143,136,94,125,200,137,142,28,70,152,227,122,131,156,65,175,21,101,169,23,61,155,121,68,250,12,214,249,98,219,16,248,116,82,35,116,62,173,197,162,211,105,6,217,193,87,98,113,200,143,186,32,199,135,59,152,144,123,77,134,186,10,128,109,198,171,97,149,199,33,56,241,28,162,7,160,128,102,99,216,221,157,76,215,243,216,49,103,89,223,50,189,57,69,112,21,196,52,94,124,28,16,32,124,131,89,222,189,95,155,16,211,158,23,229,112,186,92,70,177,76,64,179,10,236,183,46,196,188,227,107,90,136,217,78,95,104,10,223,149,9,160,1,69,226,114,42,69,21,164,80,49,156,197,191,49,67,247,250,36,193,234,251,79,165,250,250,142,59,6,42,203,18,246,226,10,71,76,70,59,67,76,28,63,134,87,56,29,229,48,124,30,79,148,57,53,191,211,29,47,113,224,113,134,155,218,201,24,4,98,169,38,1,192,64,124,98,120,186,148,14,10,43,148,105,58,47,241,183,128,98,165,227,6,217,152,228,57,236,252,139,53,74,57,55,153,162,197,153,10,223,212,196,157,170,10,207,109,39,50,65,189,131,160,42,101,99,29,231,113,170,7,220,197,239,81,179,174,124,34,113,86,14,23,17,91,224,151,184,162,208,174,42,64,155,94,48,26,239,95,157,106,133,253,50,56,15,84,160,208,91,34,126,38,218,170,187,119,253,211,154,73,122,238,13,164,159,30,145,193,216,0,44,231,141,52,131,206,21,235,12,247,149,205,228,84,212,215,231,252,8,27,21,91,168,252,39,246,54,93,220,152,124,61,152,145,37,5,238,77,169,7,242,155,245,28},
  {203,28,1,153,192,161,0,149,36,97,98,220,66,15,142,45,63,198,60,18,37,89,3,110,158,75,56,87,229,50,243,84,227,5,10,184,208,148,201,167,118,144,120,153,142,110,61,231,48,62,20,198,147,181,72,154,183,211,77,44,255,83,75,158,95,107,174,254,103,92,146,215,201,107,80,228,234,194,252,229,229,163,127,237,194,91,237,205,25,206,101,164,253,101,217,144,163,198,186,168,237,129,9,118,18,218,81,119,15,24,60,23,135,121,151,105,96,139,230,232,227,186,225,65,81,1,149,132,73,252,204,8,70,214,222,103,221,173,11,185,79,197,99,179,23,212,141,167,111,148,242,110,216,37,181,23,205,57,74,78,25,57,229,65,71,200,42,188,37,203,251,244,36,255,156,2,236,21,51,23,135,174,89,27,222,6,65,197,22,166,34,219,156,194,203,130,157,149,169,185,104,194,188,112,36,82,160,141,238,233,66,243,21,127,226,80,86,124,200,225,196,129,49,42,213,34,27,239,218,63,46,115,103,30,115,171,209,6,173,242,94,130,251,29,14,120,109,10,140,13,158,130,21,52,250,212,17,34,3,197,194,233,57,191,149,47,113,184,136,119,231,141,56,94,209,2,134,117,191,119,12,146,104,242,116,150,0,118,180,26,165,238,111,216,12,182,73,139,33,36,206,233,142,83,216,12,80,234,156,234,104,28,97,143,115,12,204,28,111,199,244,125,12,9,86,235,198,113,93,69,133,0,146,18,66,41,131,76,116,24,112,48,89,25,198,213,73,58,89,173,90,22,225,125,212,236,17,82,166,62,53,187,54,120,144,224,115,215,220,88,48,39,115,32,124,27,182,195,79,79,184,255,6,182,249,238,9,59,120,158,98,57,0,105,87,100,74,232,117,215,46,36,155,67,207,236,142,124,202,244,99,111,10,128,62,190,225,22,226,44,183,212,163,228,224,248,29,219,164,2,123,73,116,225,166,92,88,77,51,8,80,229,216,43,113,66,173,76,55,245,186,9,171,218,159,169,39,250,53,20,119,231,127,2,154,42,138,142,171,204,101,208,95,20,72,92,130,218,21,17,170,204,71,195,57,61,247,35,40,166,233,62,66,159,81,96,74,196,39,144,190,184,197,244,35,231,216,69,145,63,235,95,166,228,50,48,17,124,165,40,104,39,65,77,37,203,124,39,229,159,223,46,222,123,187,213,36,26,47,81,83,208,38,7,162,13,78,150,35,203,208,165,37,241,212,218,60,82,215,235,202,191,23,135,38,69,34,248,177,108,181,202,249,254,157,8,205,160,28,143,162,182,212,37,141,248,193,206,189,72,141,226,139,16,132,17,107,27,73,242,120,71,56,54,58,0,67,253,26,144,195,128,32,243,252,251,223,25,131,108,201,183,138,79,56,176,105,249,134,199,145,181,10,39,236,250,235,235,166,200,208,24,9,198,103,190,88,197,219,225,254,99,52,227,192,210,162,165,169,68,117,241,104,159,211,175,223,200,207,249,171,81,195,13,221,161,165,120,22,6,244,234,198,219,206,218,225,154,79,157,232,209,231,116,250,53,47,35,190,90,37,3,147,49,107,55,187,137,45,52,103,6,108,250,58,18,138,70,150,186,176,243,210,174,234,160,218,179,26,87,2,60,191,88,100,167,77,144,231,165,122,44,27,56,197,190,161,202,141,225,201,240,121,1,108,241,74,73,92,154,180,87,250,169,168,82,244,86,201,113,130,240,191,245,171,13,213,200,110,111,33,12,111,117,181,95,42,35,182,197,208,141,172,73,185,138,124,75,69,166,131,14,194,141,88,150,244,124,89,60,29,39,69,168,194,87,158,162,177,104,73,104,53,49,57,213,162,21,118,232,214,108,36,45,151,42,109,54,91,118,229,152,145,193,216,127,218,45,185,252,72,46,185,158,7,26,243,230,132,30,156,85,213,140,27,5,178,162,138,145,104,54,227,198,42,87,178,239,37,217,40,4,95,138,30,97,32,228,205,190,242,75,102,101,136,24,101,43,116,133,243,14,184,141,250,112,8,181,16,168,109,121,116,28,81,50,10,218,198,4,30,124,154,236,47,223,63,178,232,74,63,238,117,145,201,24,39,23,177,63,36,143,210,9,171,52,193,197,173,49,178,21,213,202,71,41,108,30,246,234,122,201,159,86,201,194,89,40,210,222,198,134,59,194,185,144,29,128,135,53,113,182,163,122,119,195,170,135,24,147,207,151,213,82,249,88,57,76,33,148,8,169,172,170,211,236,8,210,214,143,61,112,223,163,93,31,64,0,24,149,32,223,127,196,140,230,172,73,52,195,81,129,133,219,185,142,98,82,107,63,14,244,102,38,238,223,146,119,160,49,205,221,116,12,58,54,17,156,21,187,231,104,107,211,190,78,145,170,77,25,57,37,149,27,228,40,162,218,109,28,177,25,140,164,233,153,51,43,29,86,222,156,248,178,106,227,127,100,225,131,36,7,223,200,100,172,104,51,250,25,53,86,242,159,162,213,245,23,148,208,16,117,29,215,169,1,3,206,126,197,148,185,82,188,201,53,247,169,12,185,161,77,69,146,102,170,39,40,248,217,125,65,57,189,144,130,225,221,162,52,252,170,2,236,156,32,157,251,118,225,139,207,242,166,24,117,128,154,152,37,241,175,225,122,219,216,88,161,192,87,8,237,252,18,98,125,141,42,76,217,27,220,190,212,226,35,237,164,136,140,30,86,30,225,241,132,144,109,177,92,153,175,135,164,168,162,115,27,206,167,138,38,123,161,80,199,118,152,136,239,102,33,120,190,33,132,81,188,116,165,96,64,166,178,126,184,41,240,33,91,229,144,237,153,239,79,41,227,3,255,15,53,50,81,128,170,76,244,252,52,239,178,69,161,66,238,194,113,208,38,70,181,34,226,16,151,137,82,107,26,131,102,38,15,46,84,69,156,224,239,228,13,107,62,159,98,50,192,67,172,87,136,192,36,176,5,71,97,179,147,133,230,160,52,78,5,179,170,129,220,78,112,87,125,134,213,125,164,73,134,156,3,206,210,123,234,45,14,237,207,135,226,56,54,154,32,223,101,167,157,122,180,159,105,145,112,156,0,142,79,45,230,250,183,179,188,180,129,143,201,156,195,112,190,156,146,84,173,113,225,182,67,1,133,224,61,170,212,190,76,104,210,102,215,226,197,239,147,240,35,88,230,123,126,159,226,80,56,125,137,84,23,4,213,181,192,122,145,29,234,245,50,144,52,78,252,148,224,251,10,50,16,142,161,158,155,20,101,54,13,136,21,173,26,166,234,216,140,187,114,120,250,167,195,82,195,85,200,250,97,3,86,11,254,10,242,22,62,202,241,8,109,63,13,78,130,25,142,112,151,190,206,215,242,111,189,172,70,183,74,236,3,155,153,227,237,233,26,91,48,224,244,91,7,67,26,56,140,159,212,165,26,175,208,75,46,36,72,67,254,244,179,245,125,56,5,61,86,192,41,55,93,97,242,111,113,64,174,15,91,175,0,93,142,25,175,193,61,113,62,142,201,15,162,45,125,97,108,222,127,181,219,7,129,57,47,58,54,132,112,187,192,207,177,139,176,212,55,155,205,82,200,232,237,129,250,21,215,42,82,81,57,37,210,252,248,244,120,199,170,145,128,231,56,49,242,185,252,250,192,156,60,170,94,109,169,151,220,56,162,234,70,192,234,185,46,45,240,147,85,99,129,38,218,150,104,177,49,31,128,245,2,174,249,107,100,93,63,149,118,164,125,35,204,154,210,14,137,176,230,208,34,217,59,210,146,43,228,161,43,173,126,249,111,147,212,220,176,111,176,97,47,146,112,172,38,250,159,223,152,227,70,198,69},
  {8,160,30,77,95,99,89,164,168,238,40,181,233,46,81,159,250,241,226,223,130,24,99,32,202,35,205,143,150,126,82,194,113,135,37,119,25,69,161,84,193,25,77,164,43,99,147,132,84,180,192,25,246,71,237,150,114,243,48,119,215,197,139,234,252,182,40,193,59,39,211,42,249,117,61,112,27,223,41,189,53,75,68,30,55,177,76,30,102,159,60,182,190,156,49,221,238,45,57,8,99,20,219,60,92,35,167,13,211,24,193,85,104,218,1,0,148,193,122,255,88,67,180,71,112,191,198,53,60,80,55,210,78,61,107,124,31,128,21,106,110,152,176,196,125,0,180,12,234,62,138,94,4,80,78,26,16,81,7,100,85,61,3,184,111,41,199,163,169,82,240,109,10,238,16,186,208,163,17,63,167,26,68,208,107,141,7,55,108,202,245,95,151,209,102,211,132,84,202,220,107,44,168,8,247,161,59,125,181,56,165,203,45,26,96,86,184,31,21,231,136,212,1,3,5,232,88,11,201,95,106,226,33,117,78,82,214,152,128,72,152,213,179,176,180,246,254,182,59,163,148,122,81,238,181,209,205,210,107,117,58,37,95,102,129,84,126,166,92,214,214,112,51,112,210,181,103,187,219,166,95,152,61,75,71,206,167,249,204,153,68,177,137,136,44,22,76,41,183,144,130,238,28,111,6,56,175,73,63,233,180,105,241,239,196,171,84,231,57,175,111,250,218,34,231,104,218,165,219,108,227,192,134,217,205,71,236,61,60,2,239,157,70,139,177,142,219,174,118,38,49,2,28,49,224,200,250,86,75,4,77,149,21,205,240,108,137,51,111,122,176,32,64,85,98,209,59,119,199,170,144,129,214,57,39,129,254,40,81,88,16,205,135,92,85,10,152,33,46,110,76,150,131,241,208,80,220,237,225,96,131,52,129,118,112,112,34,112,224,84,127,101,157,206,47,238,15,33,2,154,190,107,100,169,19,126,241,63,252,196,172,12,165,168,185,179,111,149,1,246,49,55,197,142,204,253,80,30,28,4,225,65,177,177,224,182,195,160,180,195,84,194,136,227,183,77,209,254,72,134,48,168,236,211,24,120,144,172,217,85,158,7,137,23,38,97,125,1,210,135,155,71,214,132,191,170,30,105,15,9,250,197,126,108,139,221,38,65,166,141,224,95,197,40,32,81,69,223,91,191,240,102,224,213,145,216,245,94,20,82,130,84,49,185,143,84,68,21,202,242,100,166,59,42,28,52,223,98,41,189,205,63,132,205,218,219,51,14,102,44,152,72,155,85,198,210,95,12,48,55,219,179,194,160,79,107,225,250,216,61,7,164,166,168,248,60,176,95,183,223,27,233,210,120,219,117,241,162,219,230,143,216,114,19,133,86,188,23,204,169,119,249,229,44,131,255,45,39,118,178,241,29,8,135,220,56,117,178,3,198,40,30,128,195,8,237,19,29,222,250,93,21,68,11,231,164,213,184,139,219,241,155,201,81,37,56,104,151,20,27,12,186,250,186,79,37,156,143,64,146,0,171,185,45,211,36,42,66,15,15,173,149,220,25,133,9,43,199,175,202,140,110,173,32,62,185,180,227,175,47,75,211,194,60,247,153,222,217,140,43,129,131,79,110,80,172,67,59,100,195,14,64,237,2,223,32,54,100,106,142,80,168,142,196,49,119,113,219,39,220,57,51,227,15,121,226,27,246,181,233,162,139,36,29,243,66,148,39,164,239,215,195,109,144,53,249,172,129,200,138,212,56,66,16,181,45,52,63,110,107,113,2,54,51,61,197,171,207,104,145,190,94,46,1,145,245,200,135,108,235,157,159,223,195,28,176,127,3,202,39,181,57,154,76,196,196,12,83,133,246,30,122,103,217,82,14,214,107,183,159,246,128,244,76,161,75,116,94,26,203,49,191,146,181,162,18,23,122,38,109,8,159,53,171,62,210,31,229,17,56,23,116,90,216,154,89,86,182,174,69,187,142,0,150,31,171,229,201,248,136,62,226,194,108,239,24,181,78,166,201,95,155,147,166,254,230,63,136,102,78,177,190,40,137,44,194,95,171,246,224,96,208,41,142,241,102,2,27,11,153,173,202,76,143,9,238,94,108,93,99,116,65,145,190,53,71,181,105,142,98,59,199,109,212,53,71,170,181,217,81,255,101,191,96,160,127,10,54,211,99,175,185,13,96,89,129,147,199,245,47,132,196,130,63,150,177,253,16,172,71,52,79,91,247,102,152,27,55,60,212,114,74,13,255,128,149,133,78,253,34,233,236,255,73,52,178,63,118,55,4,26,229,2,170,73,219,134,125,18,50,112,90,1,19,18,184,43,93,133,40,218,102,138,92,179,185,107,71,10,19,22,101,72,198,244,115,221,42,100,197,235,135,90,201,255,150,62,101,28,27,114,66,173,59,4,175,41,70,21,182,83,70,146,104,49,53,10,38,19,216,184,242,172,157,158,115,139,185,201,243,112,153,128,80,248,178,143,65,218,166,249,173,251,81,205,120,242,110,127,106,163,207,55,197,54,4,142,55,147,140,176,144,12,113,174,37,102,66,228,145,117,254,197,142,191,36,222,35,53,69,92,115,15,117,107,95,220,111,245,157,151,198,241,120,197,235,249,58,1,9,238,201,35,35,139,117,215,115,69,200,134,57,192,234,234,123,9,109,195,213,59,132,160,32,61,231,140,198,91,250,23,180,54,13,177,99,11,229,81,5,163,23,47,153,72,1,162,232,38,41,208,177,92,180,38,157,130,152,149,179,64,1,141,163,106,237,103,55,250,241,132,45,231,228,234,28,182,188,45,15,35,9,6,184,60,75,42,57,22,245,23,99,202,203,219,19,251,149,112,158,118,213,151,185,240,178,94,232,191,223,59,21,133,238,63,253,221,149,21,69,76,87,97,188,192,52,19,96,187,72,14,209,191,186,54,120,202,129,191,141,239,93,252,143,225,51,210,133,33,89,38,167,234,213,234,236,166,209,32,170,220,201,220,111,171,131,235,213,97,170,133,150,235,212,46,165,242,0,90,14,44,59,196,168,227,135,0,22,159,69,119,73,205,46,145,162,232,156,8,87,134,220,216,98,169,119,51,107,225,122,176,130,196,66,94,216,233,179,119,156,187,125,207,105,112,134,222,32,48,30,148,45,161,32,91,16,39,213,30,23,228,212,221,58,6,115,80,99,158,5,51,235,244,3,113,159,115,51,217,249,18,65,240,136,73,184,155,51,40,87,252,255,198,5,67,39,2,65,47,17,106,57,126,32,98,215,80,217,154,85,49,144,183,142,206,143,141,198,155,173,209,99,114,95,70,221,157,51,142,14,191,27,132,139,237,22,19,44,21,37,251,117,225,163,102,170,175,77,106,14,174,62,151,55,114,254,8,246,127,213,25,217,80,152,210,98,250,229,0,150,152,163,215,121,226,193,198,165,28,4,244,63,11,212,213,169,161,42,179,84,48,135,148,191,215,30,55,240,160,106,200,45,32,163,223,30,65,165,143,211,189,215,204,141,239,82,148,247,49,73,93,254,24,150,79,2,150,40,56,109,215,194,249,116,11,72,133,9,199,162,44,185,88,21,109,146,184,113,129,118,105,70,37,106,84,73,47,251,219,210,50,229,245,212,192,231,140,54,48,11,76,63,69,98,249,240,227,114,142,58,99,35,58,216,199,236,2,250,125,69,163,20,147,72,226,115,155,86,51,208,195,181,61,3,231,47,132,36,146,32,114,144,183,179,142,197,32,227,104,224,82,213,203,213,159,218,146,203,70,151,143,33,255,179,161,64,236,216,47,218,164,179,221,227,115,115,215,123,219,248,194,32,22,201,46,94,142,83,121,131,122,120,148,54},
  {227,3,96,69,40,27,42,212,228,75,114,67,204,248,78,43,245,226,200,193,9,227,99,168,180,210,22,200,50,220,203,239,193,170,137,221,27,17,46,47,13,27,221,71,81,51,14,187,106,161,159,35,143,65,159,179,131,80,178,33,77,74,152,195,195,241,247,162,142,82,19,97,90,137,181,109,196,222,195,194,148,14,253,159,34,234,143,46,211,71,16,230,137,57,205,176,214,245,140,28,127,94,198,63,78,0,5,251,226,198,169,86,53,121,233,155,60,202,89,156,201,27,192,0,110,80,179,31,200,250,6,251,74,136,117,104,99,117,18,193,241,224,113,40,57,231,196,31,10,36,243,228,19,178,239,33,227,27,125,118,198,41,82,186,86,54,115,101,181,106,144,76,142,222,191,89,162,157,172,226,105,174,43,91,142,241,113,111,16,73,160,172,67,57,150,58,248,34,139,51,255,198,192,44,192,55,133,15,213,89,228,137,194,63,49,229,198,24,36,189,22,56,192,114,101,208,148,173,215,161,43,197,110,11,155,11,249,41,45,165,11,131,28,61,183,185,232,117,252,138,197,103,246,2,112,173,137,207,34,235,76,246,189,0,238,125,171,155,158,204,8,1,54,81,100,217,143,54,219,149,238,170,188,154,184,144,10,13,17,147,254,170,167,35,142,250,34,104,94,215,159,106,246,250,163,69,26,248,80,91,70,104,40,159,183,104,208,172,193,155,220,210,153,217,194,114,160,185,157,8,22,151,9,148,110,171,44,97,170,0,100,131,25,164,31,122,149,84,224,249,251,217,25,40,226,144,54,36,143,235,121,89,203,168,64,142,140,113,189,188,35,178,164,41,92,101,166,230,11,131,56,17,192,82,237,164,184,225,37,200,239,45,220,208,234,7,144,208,116,197,6,220,165,149,167,21,18,41,190,209,2,36,231,0,50,60,64,104,32,89,188,135,113,163,6,252,154,197,153,72,102,54,175,86,158,161,9,129,166,155,123,116,79,38,113,28,144,211,42,57,145,14,41,29,11,115,118,91,11,78,232,67,171,172,184,254,68,169,183,27,237,231,133,135,212,213,171,58,99,71,117,90,179,44,234,92,242,218,238,131,56,223,182,237,147,82,216,97,156,40,127,73,58,125,218,74,228,8,69,56,152,168,64,205,162,236,221,72,159,87,42,61,106,225,97,121,8,26,207,3,173,90,191,144,89,176,186,77,111,16,211,183,130,7,88,150,236,96,167,53,25,89,146,51,66,186,92,5,253,20,114,216,113,86,174,175,47,119,128,200,161,228,201,246,31,79,2,136,107,6,217,37,91,78,108,47,179,197,207,71,178,170,154,154,175,173,45,157,99,237,128,142,143,115,149,39,246,225,57,101,161,61,190,14,43,197,194,246,103,239,239,91,52,20,82,92,17,35,10,45,102,84,66,232,193,189,11,69,188,222,33,201,90,7,38,63,75,119,102,224,156,119,122,225,171,67,10,177,60,0,189,49,183,107,43,48,24,43,241,114,127,115,247,220,29,56,65,178,185,121,156,99,209,43,241,65,38,255,153,165,161,152,152,211,63,63,68,96,74,223,33,12,111,195,39,103,44,136,182,206,168,99,11,193,2,12,136,244,97,234,98,190,49,159,222,94,239,112,161,172,79,4,205,186,134,246,126,106,230,65,1,143,159,71,231,170,121,110,86,46,210,101,227,166,200,89,63,178,42,76,32,83,13,224,240,105,151,223,55,38,73,151,47,187,201,53,69,71,97,4,182,105,27,40,64,196,91,38,176,1,29,171,60,88,62,46,34,46,204,40,40,239,177,65,150,93,56,68,69,213,106,66,10,210,190,24,101,23,134,66,232,93,116,125,42,170,14,15,246,135,88,33,78,136,199,230,56,135,78,245,38,193,79,230,164,107,217,90,234,211,14,68,244,97,149,168,85,97,172,26,72,116,211,218,117,145,3,249,45,17,181,162,166,189,45,117,240,165,139,82,249,126,7,143,43,95,211,36,252,253,200,30,188,176,21,143,187,92,13,211,171,52,100,43,192,103,180,4,37,180,135,0,71,128,139,171,136,229,208,86,59,136,2,129,14,78,122,63,140,202,99,213,215,131,4,172,130,120,134,96,102,91,39,183,51,227,11,76,157,143,216,183,111,217,114,229,147,146,236,228,202,231,161,135,71,43,83,68,131,246,159,193,112,13,65,235,164,62,12,45,186,114,206,220,83,57,31,191,17,230,80,71,176,43,186,96,47,114,28,34,243,19,8,254,50,134,247,148,244,190,100,66,36,211,45,137,102,18,207,234,82,227,25,102,107,165,142,21,194,207,194,127,184,89,119,86,228,226,157,102,89,36,255,210,236,128,61,71,247,161,249,61,208,181,160,73,203,22,118,161,101,29,8,218,107,12,83,99,8,250,133,26,38,106,88,254,82,137,152,69,31,61,20,65,110,0,17,123,39,190,215,128,145,95,184,157,206,64,33,23,49,159,197,244,245,77,38,119,11,75,169,187,114,237,156,202,159,82,205,123,242,118,233,147,239,169,72,183,115,152,87,115,59,97,75,88,108,90,102,184,230,206,2,210,85,146,188,136,75,207,50,29,91,143,233,83,60,224,74,112,50,104,253,192,204,119,237,226,214,71,252,165,37,114,94,129,10,35,182,206,38,138,137,198,147,25,190,145,35,107,69,39,150,250,11,194,195,26,51,86,47,212,43,213,204,78,123,214,129,165,133,65,20,214,8,93,211,216,28,252,120,49,64,187,214,145,129,66,227,9,222,117,229,73,161,152,112,136,2,54,247,4,64,148,130,23,93,157,26,73,217,21,119,64,119,228,97,205,237,73,190,186,167,140,79,80,236,175,82,106,51,47,94,87,15,29,108,111,214,42,213,161,73,70,219,10,74,199,125,86,155,214,186,227,131,151,33,39,134,246,126,216,222,239,129,108,206,253,244,142,208,65,221,125,53,166,61,189,214,68,247,175,32,58,212,147,222,216,123,40,42,110,148,37,6,66,211,117,12,20,147,14,74,91,209,175,218,205,2,106,212,247,117,25,109,57,103,42,164,223,191,53,28,228,19,30,58,142,110,71,25,14,133,224,116,216,198,67,19,150,112,36,125,212,133,172,53,235,123,170,63,143,169,196,29,31,182,72,250,211,153,218,201,241,100,74,234,51,123,7,232,238,249,127,239,227,79,216,74,158,60,174,60,96,69,188,96,54,5,240,56,97,9,131,92,10,202,111,133,174,89,254,21,45,75,189,119,170,144,195,97,192,74,117,217,231,219,114,170,176,211,205,124,26,130,21,19,121,233,184,131,111,233,209,31,85,16,4,30,39,52,20,71,254,213,108,108,218,7,254,209,248,161,190,137,130,49,108,254,41,152,72,82,134,45,134,10,229,21,247,52,132,66,102,30,123,156,148,154,30,107,222,46,0,100,154,124,107,206,197,147,151,165,243,109,51,14,238,21,235,78,158,4,194,214,226,145,39,162,160,41,229,6,204,70,177,95,253,58,193,75,143,56,75,185,238,165,119,0,11,211,29,62,111,21,38,193,151,72,130,70,158,83,27,72,205,64,170,122,183,72,60,25,57,227,230,117,13,201,103,153,86,36,158,240,154,154,253,31,53,94,230,221,205,142,19,8,27,232,223,147,6,28,48,93,190,86,190,58,183,110,208,248,230,157,232,54,97,254,53,191,58,43,82,121,190,204,180,197,39,135,94,147,150,119,120,111,143,21,43,8,215,92,130,90,78,182,149,219,241,58,156,245,225,172,38,199,88,140,77,79,141,194,240,108,77,90,170,48,69,242,53,91,51,30,183,171,160,211,203,27,5,43,147,190,194,83,220,185,1,16,202,35,73},
} ;

static void test_decode_857xint16_impl(long long impl)
{
  unsigned char *x = test_decode_857xint16_x;
  unsigned char *s = test_decode_857xint16_s;
  unsigned char *x2 = test_decode_857xint16_x2;
  unsigned char *s2 = test_decode_857xint16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_857xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_857xint16(impl);
    printf("decode_857xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857xint16_implementation(impl),ntruprime_dispatch_decode_857xint16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_857xint16;
    printf("decode_857xint16 selected implementation %s compiler %s\n",ntruprime_decode_857xint16_implementation(),ntruprime_decode_857xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_857xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_857xint16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_857xint16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_857xint16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_857xint16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_857xint16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_857xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857xint16")) return;
  storage_decode_857xint16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_857xint16_x = aligned(storage_decode_857xint16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_857xint16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_857xint16_s = aligned(storage_decode_857xint16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_857xint16_x2 = callocplus(maxalloc);
  test_decode_857xint16_x2 = aligned(storage_decode_857xint16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_857xint16_s2 = callocplus(maxalloc);
  test_decode_857xint16_s2 = aligned(storage_decode_857xint16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_857xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_857xint16();++impl)
      forked(test_decode_857xint16_impl,impl);
    ++test_decode_857xint16_x;
    ++test_decode_857xint16_s;
    ++test_decode_857xint16_x2;
    ++test_decode_857xint16_s2;
  }
  free(storage_decode_857xint16_s2);
  free(storage_decode_857xint16_x2);
  free(storage_decode_857xint16_s);
  free(storage_decode_857xint16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

