/* ----- decode/1013x3, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1013x3_checksums[] = {
  "bc9fe48234596542962f8de47a4ef3ac45a2dc7d7a6e5a7e74ec9de0ca296c38",
  "e7e3dae8e40abaf6707c25588855e328d51070ee697ec212aa4f1a4883f8f5de",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1013x3_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1013x3_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1013x3_ITEMBYTES

static void *storage_decode_1013x3_x;
static unsigned char *test_decode_1013x3_x;
static void *storage_decode_1013x3_s;
static unsigned char *test_decode_1013x3_s;
static void *storage_decode_1013x3_x2;
static unsigned char *test_decode_1013x3_x2;
static void *storage_decode_1013x3_s2;
static unsigned char *test_decode_1013x3_s2;

#define precomputed_decode_1013x3_NUM 4

static const unsigned char precomputed_decode_1013x3_x[precomputed_decode_1013x3_NUM][crypto_decode_ITEMS] = {
  {0,2,-1,2,2,1,2,1,0,2,1,2,-1,-1,-1,0,-1,-1,0,-1,2,0,1,-1,2,2,-1,2,-1,2,1,2,2,2,0,1,2,1,-1,1,-1,2,0,0,1,1,2,2,2,2,0,-1,1,-1,2,0,-1,0,0,1,0,0,2,0,-1,0,0,0,0,2,1,-1,0,1,1,2,1,2,2,2,2,-1,0,1,-1,1,-1,0,-1,-1,1,-1,-1,1,0,1,-1,-1,0,-1,2,0,-1,0,0,1,1,1,2,0,1,0,1,0,-1,2,2,1,2,1,2,2,0,1,-1,1,-1,2,0,0,2,-1,-1,2,2,0,0,0,2,1,-1,1,2,2,2,-1,-1,0,0,0,2,-1,1,0,1,1,0,-1,2,0,-1,2,0,-1,1,0,0,0,-1,-1,2,0,2,1,2,-1,0,1,0,0,-1,0,0,1,0,0,-1,0,1,-1,0,0,-1,0,1,2,-1,1,-1,2,2,2,2,0,2,2,-1,-1,2,1,2,1,0,1,2,-1,2,0,0,0,1,2,2,0,0,2,-1,-1,2,1,-1,2,0,1,1,2,-1,0,-1,2,2,0,1,2,-1,-1,1,-1,-1,2,0,0,1,0,0,0,1,0,-1,-1,2,2,-1,0,0,0,1,2,2,2,0,0,-1,2,0,1,2,-1,1,0,1,0,0,1,-1,1,1,1,0,1,0,2,-1,2,2,1,1,1,2,1,2,1,-1,0,0,0,-1,2,2,0,1,1,-1,2,2,-1,0,0,1,0,-1,-1,-1,2,0,2,0,0,2,0,1,1,-1,-1,-1,1,1,-1,0,2,1,2,2,0,2,-1,0,0,-1,0,1,-1,-1,-1,2,2,-1,-1,1,-1,1,-1,0,-1,2,1,2,-1,0,0,1,1,-1,2,0,1,0,0,-1,0,-1,0,2,1,1,2,2,2,1,-1,0,0,0,2,-1,-1,1,-1,2,0,2,0,2,-1,-1,1,2,1,2,-1,1,1,-1,0,2,2,2,-1,-1,1,0,1,0,0,0,2,2,2,0,-1,-1,2,1,2,1,2,-1,0,-1,-1,0,-1,0,-1,-1,-1,2,1,2,0,1,2,1,0,-1,2,-1,1,0,1,1,-1,-1,-1,1,0,2,2,0,1,1,0,0,0,1,2,2,0,1,-1,2,2,-1,1,0,1,1,-1,1,0,1,-1,-1,1,0,0,2,0,1,0,2,0,0,-1,1,0,2,-1,0,2,0,0,-1,2,2,1,2,2,1,2,0,2,-1,0,0,-1,-1,2,-1,-1,2,2,0,-1,1,1,1,0,-1,1,0,2,-1,1,0,0,0,1,0,2,2,2,-1,0,2,1,1,0,2,-1,0,0,2,2,0,1,-1,0,2,1,1,1,0,-1,0,0,2,1,-1,1,2,1,0,2,-1,0,1,2,1,1,1,2,-1,-1,-1,0,-1,-1,-1,2,1,1,2,-1,0,2,-1,2,2,0,2,1,2,2,1,-1,2,-1,2,0,-1,2,2,0,1,-1,1,-1,-1,0,2,-1,1,0,1,0,-1,0,2,1,-1,2,2,2,-1,2,2,-1,-1,2,-1,-1,-1,-1,2,0,1,1,2,-1,1,2,-1,2,1,1,0,1,1,-1,1,-1,1,0,2,1,-1,-1,-1,0,-1,-1,2,0,2,-1,1,-1,-1,1,-1,2,1,-1,-1,1,2,1,1,-1,0,1,1,2,1,2,-1,-1,-1,1,2,1,1,-1,0,-1,2,1,-1,0,2,-1,-1,2,1,0,0,0,-1,0,0,1,0,0,1,0,1,1,1,0,-1,1,0,-1,2,-1,1,2,1,-1,2,2,0,-1,2,0,-1,-1,2,2,0,0,0,0,2,2,2,1,-1,2,2,2,2,2,0,1,1,-1,0,-1,1,2,0,-1,1,1,1,0,2,0,2,2,0,2,1,0,0,1,0,2,0,1,0,-1,2,1,2,2,0,2,-1,0,0,-1,0,2,-1,0,-1,0,0,1,-1,1,0,2,1,2,2,1,-1,-1,-1,2,-1,0,0,2,0,1,0,-1,-1,2,1,2,1,-1,2,1,1,0,-1,0,2,2,-1,0,-1,1,0,0,-1,-1,0,2,0,0,-1,-1,-1,0,-1,0,2,-1,0,2,0,0,2,0,2,1,0,1,2,-1,0,2,2,-1,1,0,-1,0,0,-1,0,1,2,1,2,2,2,1,-1,-1,-1,1,0,-1,2,-1,2,0,-1,0,2,0,1,0,2,1,1,-1,0,-1,0,1,0,0,2,0,-1,2,2,0,1,0,2,2,2,2,2,1,2,-1,-1,-1,1,2,1,0,1,2,0,-1,-1,-1,0,2,0,2,2,-1,-1,0,0,2,-1,0,0,1,2,2,2,1,0,0,2,0,0,0,-1,2,0,2,1,2,-1,0,1,1,0,-1,0,0,2,-1,0,0,1,-1,1,-1,2,1,0,1,2,2,0},
  {0,-1,2,2,0,-1,0,0,-1,-1,1,0,2,1,1,1,2,0,-1,-1,1,0,0,2,-1,2,-1,0,2,-1,-1,-1,-1,1,0,-1,0,1,0,1,2,-1,-1,-1,0,2,-1,-1,2,0,1,0,1,0,1,0,-1,2,-1,-1,0,1,-1,2,0,2,1,0,1,1,0,-1,-1,1,-1,0,2,0,2,2,2,0,1,1,-1,1,-1,2,1,0,-1,0,2,1,2,2,2,-1,-1,0,0,0,2,2,2,2,1,0,0,0,2,0,-1,0,0,-1,0,-1,0,1,1,1,0,-1,0,0,-1,0,0,2,1,-1,2,2,0,1,0,-1,-1,0,2,2,1,-1,1,0,-1,2,2,0,-1,0,0,1,1,0,2,-1,0,0,2,0,1,2,-1,1,1,2,2,-1,-1,-1,0,2,-1,2,0,-1,2,0,-1,0,-1,2,0,0,-1,1,0,-1,2,1,-1,0,2,-1,1,2,1,2,-1,-1,-1,1,-1,1,-1,0,-1,0,-1,0,-1,-1,2,-1,0,1,-1,0,-1,-1,0,-1,-1,0,0,0,0,1,1,2,1,1,0,0,2,0,0,2,-1,1,2,2,-1,1,2,0,0,-1,-1,0,1,-1,-1,-1,1,1,0,-1,0,2,2,1,-1,-1,-1,2,2,2,-1,1,1,0,0,1,0,0,1,2,1,2,2,-1,1,-1,-1,-1,2,-1,0,0,2,-1,-1,2,1,1,0,2,1,0,-1,1,2,0,2,2,1,1,2,0,-1,1,0,2,0,-1,-1,0,1,0,2,0,1,-1,2,-1,2,2,0,0,2,-1,2,-1,-1,0,2,-1,2,-1,-1,-1,0,-1,2,1,2,2,2,0,1,-1,2,1,1,-1,-1,-1,-1,2,1,2,1,-1,0,1,0,2,1,1,1,-1,-1,0,1,1,-1,0,-1,1,-1,2,2,2,2,-1,1,0,1,0,1,2,1,-1,1,1,-1,2,-1,2,2,2,1,2,0,2,-1,1,1,1,-1,2,0,-1,0,1,1,0,-1,2,1,0,2,0,0,0,-1,-1,2,-1,2,0,0,1,-1,0,0,2,0,2,1,2,0,0,-1,0,0,1,1,2,2,-1,2,0,2,-1,0,-1,0,-1,1,1,-1,-1,1,2,-1,1,0,-1,1,1,-1,2,1,-1,-1,2,2,2,1,-1,2,1,2,1,1,2,2,1,1,-1,1,-1,2,-1,1,0,-1,0,0,0,-1,0,2,0,0,1,0,-1,-1,1,2,-1,0,1,-1,1,2,2,2,2,0,2,2,0,-1,-1,0,1,-1,-1,-1,-1,0,0,2,2,0,1,1,1,1,1,-1,0,0,-1,1,0,2,-1,1,1,2,1,1,1,0,-1,-1,1,1,-1,1,-1,1,-1,1,0,-1,-1,0,2,0,2,0,2,1,1,2,0,-1,2,2,1,-1,0,0,-1,-1,2,2,2,0,2,2,0,2,2,-1,2,-1,-1,2,1,1,1,2,1,1,0,1,0,2,0,0,0,-1,2,1,1,2,2,0,1,0,2,0,-1,-1,1,1,-1,-1,0,0,-1,-1,-1,-1,0,1,0,2,2,-1,0,-1,2,1,2,2,1,0,0,2,2,2,1,-1,0,-1,-1,1,0,1,-1,-1,0,1,2,1,-1,2,2,0,2,-1,1,1,-1,-1,2,2,-1,0,1,0,0,1,2,1,-1,2,1,1,-1,-1,1,2,1,0,2,2,1,-1,1,2,2,2,0,-1,2,2,2,0,0,2,1,0,0,2,1,1,1,1,1,-1,1,1,0,2,-1,-1,2,-1,1,2,0,1,2,2,2,2,-1,0,-1,-1,0,1,2,-1,0,0,0,1,0,1,1,-1,-1,0,-1,0,0,-1,0,1,0,-1,0,-1,2,0,0,0,1,-1,-1,2,2,-1,0,0,0,0,-1,1,1,0,2,2,-1,2,-1,2,-1,1,2,1,0,1,1,0,1,-1,-1,1,1,2,1,-1,0,0,1,1,2,2,-1,-1,1,1,2,1,2,-1,2,0,-1,2,-1,2,0,2,2,0,-1,0,1,1,0,1,-1,2,1,0,1,1,0,-1,1,0,1,0,0,-1,1,-1,2,1,2,0,-1,1,2,-1,0,2,-1,2,1,2,-1,2,2,2,2,0,2,1,0,-1,1,1,0,-1,2,-1,-1,1,0,1,-1,-1,1,0,-1,1,0,0,1,-1,-1,1,-1,-1,-1,-1,1,0,2,-1,0,0,-1,1,1,0,2,2,2,-1,2,-1,2,-1,-1,0,1,2,0,1,2,2,-1,0,2,0,-1,2,-1,2,1,0,1,2,2,2,2,0,2,0,1,0,0,-1,2,0,2,0,1,-1,-1,0,-1,-1,1,0,-1,2,-1,2,2,-1,1,2,0,1,-1,-1,0,0,0,-1,0,-1,2,0,0,-1,0,-1,1,-1,-1,2,1,-1,1,-1,1,2,-1,-1,0,-1,1,-1,2,2},
  {-1,1,2,-1,-1,-1,2,0,0,-1,-1,0,1,-1,1,-1,0,-1,-1,2,1,-1,2,0,0,2,0,0,-1,2,1,1,-1,0,0,2,0,2,2,1,1,1,0,2,0,1,2,-1,0,2,2,1,2,0,2,1,0,-1,0,-1,-1,0,1,2,2,2,1,0,1,1,2,-1,1,2,2,2,-1,-1,2,1,2,1,-1,1,-1,0,1,0,0,2,0,2,2,2,0,0,-1,2,2,-1,-1,-1,2,-1,0,2,1,1,-1,-1,1,-1,-1,1,1,0,2,-1,2,1,-1,1,0,-1,1,2,0,0,2,2,2,0,2,0,2,-1,1,1,1,1,-1,1,0,1,0,0,1,-1,1,1,2,2,1,-1,-1,2,2,-1,-1,-1,1,1,1,-1,0,-1,1,2,2,-1,-1,-1,2,0,0,0,1,-1,2,0,-1,1,-1,0,1,1,-1,-1,0,-1,1,-1,0,0,2,0,-1,-1,2,-1,0,-1,0,-1,-1,2,0,-1,-1,0,-1,1,1,-1,0,2,1,1,0,-1,2,1,-1,2,0,-1,2,0,1,-1,0,-1,1,2,2,2,1,2,-1,0,-1,-1,1,-1,2,2,1,0,1,-1,1,2,2,2,1,1,2,-1,0,-1,1,-1,2,2,0,2,0,-1,-1,1,0,1,2,1,0,1,2,2,-1,2,0,0,0,1,2,2,0,2,0,-1,2,2,2,0,0,2,2,0,2,-1,2,2,0,-1,0,2,2,0,1,1,-1,0,-1,1,1,2,1,0,1,-1,1,2,2,0,2,-1,0,0,-1,0,1,-1,-1,-1,-1,0,-1,2,-1,2,0,0,1,2,1,1,1,1,2,0,1,-1,-1,1,0,0,-1,1,-1,1,2,2,-1,2,0,0,-1,1,0,0,-1,2,-1,-1,0,0,1,-1,2,1,0,2,2,2,2,1,1,0,1,-1,0,-1,1,2,-1,2,2,0,1,2,-1,0,-1,2,-1,2,0,0,2,0,-1,1,-1,2,-1,1,-1,2,-1,2,2,0,-1,1,-1,1,-1,2,-1,-1,-1,0,0,2,-1,-1,0,0,-1,2,1,1,1,1,2,-1,1,1,0,1,1,2,2,-1,2,1,0,2,2,-1,2,0,-1,2,2,1,0,-1,1,0,2,2,-1,2,0,-1,0,-1,-1,2,1,0,0,0,-1,-1,2,-1,1,1,0,0,1,-1,-1,1,1,-1,1,-1,1,2,1,0,2,2,2,2,-1,-1,2,2,1,-1,1,2,1,-1,2,1,-1,1,2,0,0,1,-1,1,-1,-1,1,-1,2,2,-1,2,2,0,0,-1,-1,0,1,-1,2,2,1,-1,0,2,0,1,0,1,0,-1,2,2,-1,1,0,1,1,2,0,0,-1,1,0,2,2,0,2,2,0,1,-1,-1,2,-1,0,0,-1,1,2,2,-1,2,-1,2,-1,0,2,-1,1,-1,-1,0,2,0,2,0,2,-1,-1,-1,-1,1,-1,1,-1,-1,1,0,1,1,0,0,-1,-1,1,2,2,1,1,-1,2,0,1,0,-1,1,1,-1,0,1,2,1,0,0,-1,0,0,1,1,2,0,-1,0,2,0,-1,0,0,-1,-1,-1,1,2,-1,-1,1,2,0,1,2,-1,2,1,2,2,2,2,2,-1,0,2,1,1,1,-1,-1,1,2,-1,0,2,-1,-1,-1,-1,1,-1,1,2,1,2,0,0,1,0,0,0,0,2,1,2,2,2,2,0,0,-1,1,1,-1,2,-1,0,1,0,2,2,-1,0,-1,2,1,1,2,-1,1,2,-1,2,2,-1,2,-1,-1,-1,1,2,0,-1,1,-1,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,2,-1,0,2,1,2,-1,0,-1,2,1,-1,2,0,-1,2,2,1,-1,0,2,0,-1,1,-1,0,1,-1,2,2,1,-1,-1,2,1,0,0,2,0,1,1,-1,2,0,0,2,1,1,1,2,0,2,2,-1,-1,0,2,2,0,1,2,1,2,0,2,2,2,0,2,0,1,1,0,2,-1,1,2,1,1,-1,2,0,-1,2,0,0,-1,2,0,1,2,2,-1,-1,2,2,2,-1,2,1,0,1,1,1,-1,1,2,2,1,0,2,-1,1,1,-1,-1,2,2,2,0,2,0,-1,2,-1,0,-1,0,1,0,0,2,0,1,1,-1,1,1,-1,0,0,2,1,2,-1,-1,0,2,0,-1,1,0,-1,0,2,0,2,0,-1,1,2,1,-1,2,2,0,-1,2,-1,2,0,2,2,-1,2,-1,2,-1,-1,-1,-1,1,2,1,0,0,2,2,1,0,0,2,-1,2,-1,-1,2,2,1,-1,2,2,2,-1,-1,2,0,1,2,2,2,1,-1,0,-1,0,2,2,-1,-1,1,0,0,1,0,0,1,0,-1,2,2,2,1,-1,1,2,2,-1,2,2,-1,-1,1,-1,1,2,0,2,-1},
  {2,1,0,2,-1,2,1,0,2,2,0,1,1,0,-1,2,1,-1,-1,0,0,2,2,1,1,-1,-1,0,1,0,-1,1,-1,-1,-1,1,0,-1,1,-1,0,-1,-1,-1,1,-1,-1,2,0,2,2,2,0,0,1,0,2,2,1,2,1,0,0,1,1,0,2,1,0,-1,2,0,2,0,2,-1,-1,-1,2,2,1,-1,1,-1,-1,2,1,-1,2,-1,2,2,1,0,1,0,0,2,-1,-1,-1,0,0,2,1,0,-1,1,0,2,0,2,2,2,1,0,2,2,2,-1,2,1,1,1,-1,0,2,-1,2,1,-1,2,0,-1,-1,0,-1,-1,2,1,1,2,-1,0,0,-1,1,2,2,2,-1,1,0,2,0,0,0,-1,-1,2,-1,0,-1,0,0,0,-1,-1,2,1,-1,-1,2,-1,-1,0,1,1,0,2,2,2,0,2,2,-1,2,-1,1,-1,0,0,0,2,-1,1,0,2,2,-1,2,2,-1,0,-1,0,2,2,0,-1,-1,2,1,-1,-1,1,-1,2,1,1,-1,-1,2,2,0,2,-1,2,1,0,0,0,0,2,0,-1,2,0,2,2,-1,1,-1,0,-1,2,1,2,0,2,1,1,1,2,2,2,1,2,2,0,1,0,2,1,0,1,-1,1,0,0,2,2,0,0,-1,1,1,-1,-1,-1,-1,2,0,0,-1,0,-1,0,-1,-1,-1,1,-1,0,2,0,-1,0,0,0,1,-1,-1,1,0,2,2,2,1,-1,1,2,-1,-1,0,0,0,-1,1,1,0,0,1,2,-1,-1,0,2,1,0,1,1,1,0,0,1,0,-1,1,1,-1,-1,0,-1,-1,-1,2,1,1,-1,1,1,0,-1,2,1,1,-1,0,1,-1,1,-1,1,0,1,2,-1,1,-1,0,-1,-1,0,0,-1,1,-1,-1,2,1,-1,2,-1,0,-1,-1,1,1,2,1,-1,2,2,0,2,2,1,0,1,2,-1,-1,2,2,-1,1,1,-1,0,2,1,1,0,-1,1,1,2,1,-1,2,-1,2,1,1,2,2,0,0,-1,-1,0,2,0,0,0,1,2,1,0,0,0,2,-1,2,-1,-1,2,-1,0,1,-1,2,2,0,2,0,-1,2,-1,-1,0,2,1,0,-1,-1,0,2,2,1,2,1,1,2,2,2,1,1,0,1,2,1,-1,0,-1,2,0,1,0,1,0,1,2,1,0,1,2,-1,1,1,1,2,-1,1,2,0,0,2,-1,0,2,-1,2,2,2,0,2,2,-1,-1,1,2,1,1,1,-1,-1,0,-1,-1,-1,-1,1,-1,0,1,2,2,1,-1,2,1,2,2,2,-1,2,2,0,0,0,0,0,-1,1,1,0,2,0,0,1,-1,-1,1,1,-1,2,0,0,2,-1,-1,1,2,2,1,2,-1,2,1,-1,2,1,2,0,2,1,1,1,1,-1,0,2,-1,2,-1,2,-1,1,1,0,-1,0,0,-1,2,2,1,2,-1,1,1,-1,1,1,1,2,2,0,2,0,-1,-1,0,0,2,-1,-1,2,-1,-1,-1,-1,-1,2,2,0,0,1,1,0,1,0,-1,2,2,1,1,2,2,0,-1,2,2,-1,2,2,2,1,0,1,0,0,1,-1,0,1,-1,0,1,2,2,-1,0,2,-1,1,2,-1,0,2,1,1,1,1,1,0,0,1,-1,2,1,2,-1,1,2,1,2,1,0,0,-1,0,1,1,2,2,1,1,1,2,-1,1,-1,2,1,1,-1,1,-1,2,0,2,1,1,0,1,0,1,-1,-1,-1,-1,-1,0,0,0,-1,0,-1,2,-1,1,-1,1,0,1,2,0,2,2,2,0,2,1,0,1,0,1,0,-1,-1,-1,1,-1,-1,2,0,0,-1,0,-1,-1,-1,-1,1,2,-1,2,-1,-1,2,0,2,1,0,-1,-1,2,0,1,0,2,-1,1,2,2,2,0,2,2,2,2,0,-1,1,1,1,-1,-1,1,0,2,-1,1,-1,2,2,1,2,-1,-1,2,0,0,0,0,0,-1,2,-1,-1,1,-1,2,0,-1,0,0,2,1,-1,1,2,0,-1,1,-1,-1,2,0,0,-1,1,2,-1,2,-1,0,0,-1,-1,1,2,1,1,1,0,0,2,1,2,0,1,1,0,-1,-1,-1,1,0,0,0,1,1,1,1,-1,-1,0,-1,1,2,2,0,2,0,1,2,1,-1,1,1,1,1,-1,-1,0,-1,2,-1,0,0,0,1,0,1,1,1,1,1,-1,1,2,0,-1,-1,2,2,2,-1,1,-1,-1,2,2,0,2,1,1,2,0,0,-1,-1,0,0,2,-1,1,1,2,2,-1,-1,0,-1,0,1,1,2,2,1,0,-1,1,0,0,-1,1,1,1,2,1,-1,-1,1,2,1,0,-1,1,2,2,0,1,2,-1,-1,1,2,1,0,0,1,-1,2,2,-1,0,0,0,2,2,1,0,1,2,0,-1,2,1},
} ;

static const unsigned char precomputed_decode_1013x3_s[precomputed_decode_1013x3_NUM][crypto_decode_STRBYTES] = {
  {205,187,237,64,16,39,207,236,159,139,92,250,31,114,148,117,84,45,233,254,147,72,32,152,16,71,169,103,198,187,159,200,53,124,181,248,67,53,166,113,28,86,112,59,89,148,69,82,228,200,127,15,187,57,87,126,13,203,233,196,231,32,92,86,6,79,229,95,156,99,150,168,217,188,186,75,197,167,60,101,192,93,167,128,210,126,83,36,240,32,18,59,165,156,69,180,254,82,13,114,55,184,163,244,131,89,253,193,238,4,17,176,231,198,152,2,246,105,229,39,143,41,38,88,103,23,54,93,188,239,77,193,240,161,134,141,149,253,180,54,245,73,171,81,139,219,228,234,64,192,58,205,183,47,115,124,34,52,102,180,252,60,12,112,58,206,154,34,182,64,112,35,200,130,43,233,14,184,18,75,195,86,148,101,106,24,227,242,113,240,85,191,252,159,18,30,106,247,109,217,25,251,77,209,68,137,237,11,76,157,193,46,107,244,132,5,93,64,52,93,183,57,61,70,145,251,11,24,115,116,182,18,89,199,103,255,59,224,230,1,221,67,77,249,91,87,220,78,26,53,37,178,249,161},
  {241,81,96,171,7,214,76,3,24,153,3,13,103,102,12,201,109,26,72,247,167,200,70,251,67,245,111,117,20,145,26,69,45,159,65,47,198,71,105,83,231,232,3,205,113,196,133,177,52,238,128,72,68,48,73,16,84,233,90,215,248,120,65,2,26,189,192,143,150,229,62,2,83,195,218,134,247,122,216,65,118,50,95,51,52,3,177,127,178,2,236,146,173,66,74,200,63,102,46,202,252,222,168,28,105,108,87,48,151,212,237,69,233,115,19,161,224,24,202,194,47,187,190,34,99,84,116,25,56,137,255,125,144,0,245,169,74,97,163,171,129,34,98,208,221,122,188,20,252,125,207,176,186,102,87,172,159,29,40,20,64,246,196,190,245,75,96,66,46,223,40,60,89,46,43,184,189,248,199,95,91,171,138,54,140,231,63,65,78,101,10,81,100,196,149,240,84,161,61,51,110,154,160,75,233,131,238,28,115,31,105,178,105,152,133,236,225,52,59,255,109,104,12,38,24,150,32,128,77,161,253,204,144,231,211,49,155,255,157,197,157,16,24,243,120,66,69,92,132,176,136,67,200,119},
  {56,112,65,34,193,114,93,172,212,189,218,57,189,183,17,228,111,58,254,176,139,100,221,95,60,48,173,32,104,179,24,94,127,55,170,152,37,250,194,3,42,225,3,87,114,72,10,33,117,48,17,28,132,210,26,203,113,18,254,78,32,111,226,175,19,242,29,152,155,207,149,223,241,215,55,31,125,74,232,38,126,83,36,64,204,229,170,39,88,136,207,133,197,80,178,253,107,18,206,231,196,92,135,140,204,135,200,64,13,197,170,163,233,179,61,199,27,246,28,193,86,48,90,130,34,110,255,240,226,178,120,137,32,207,23,36,47,157,25,143,233,133,125,159,48,133,207,76,35,116,55,128,8,166,5,190,114,134,146,91,148,30,29,5,56,120,206,254,79,171,224,52,128,184,151,85,251,95,40,147,61,177,142,243,12,120,200,127,253,255,85,211,78,44,199,75,135,36,47,108,157,114,173,222,67,159,123,127,167,141,43,199,197,249,240,179,169,248,54,10,127,199,68,214,41,74,237,208,97,116,135,203,199,220,51,3,184,245,214,12,47,63,156,191,68,15,150,101,252,226,243,32,222,128},
  {219,108,159,198,66,189,66,134,128,33,1,194,253,101,239,150,182,113,55,240,34,44,243,102,13,212,134,221,111,63,171,52,203,65,176,78,225,143,93,193,68,5,11,67,218,223,51,82,141,61,79,244,193,130,172,240,205,86,29,247,72,236,173,254,126,182,137,245,133,2,92,68,128,116,84,130,253,226,80,161,229,208,166,150,161,16,176,162,177,146,136,57,18,20,194,50,129,46,223,155,195,163,180,134,46,179,126,65,87,110,53,195,36,223,49,180,65,239,250,107,46,113,102,110,142,58,94,211,252,61,184,10,1,72,190,236,207,87,133,118,9,202,53,248,206,178,183,42,205,140,70,241,142,162,126,7,53,12,192,151,102,188,126,60,191,89,146,228,211,56,173,106,201,142,187,69,250,234,200,138,220,154,9,64,69,140,152,247,183,153,1,194,69,0,206,112,27,156,141,127,255,161,130,141,188,195,85,49,200,81,139,135,112,225,76,129,171,181,167,1,86,170,16,126,231,162,10,49,149,169,138,7,63,194,183,94,80,163,15,145,190,97,161,46,184,225,231,224,150,60,213,155,199,38},
} ;

static void test_decode_1013x3_impl(long long impl)
{
  unsigned char *x = test_decode_1013x3_x;
  unsigned char *s = test_decode_1013x3_s;
  unsigned char *x2 = test_decode_1013x3_x2;
  unsigned char *s2 = test_decode_1013x3_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1013x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1013x3(impl);
    printf("decode_1013x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013x3_implementation(impl),ntruprime_dispatch_decode_1013x3_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1013x3;
    printf("decode_1013x3 selected implementation %s compiler %s\n",ntruprime_decode_1013x3_implementation(),ntruprime_decode_1013x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1013x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1013x3_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1013x3_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1013x3_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1013x3_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1013x3_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1013x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013x3")) return;
  storage_decode_1013x3_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1013x3_x = aligned(storage_decode_1013x3_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1013x3_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1013x3_s = aligned(storage_decode_1013x3_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1013x3_x2 = callocplus(maxalloc);
  test_decode_1013x3_x2 = aligned(storage_decode_1013x3_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1013x3_s2 = callocplus(maxalloc);
  test_decode_1013x3_s2 = aligned(storage_decode_1013x3_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1013x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1013x3();++impl)
      forked(test_decode_1013x3_impl,impl);
    ++test_decode_1013x3_x;
    ++test_decode_1013x3_s;
    ++test_decode_1013x3_x2;
    ++test_decode_1013x3_s2;
  }
  free(storage_decode_1013x3_s2);
  free(storage_decode_1013x3_x2);
  free(storage_decode_1013x3_s);
  free(storage_decode_1013x3_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

