/* ----- core/multsntrup1277, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_multsntrup1277_checksums[] = {
  "058a17a603ab239e229ecee9714be97af3029708f9c0cd163abec692e829d154",
  "6a784e7b89a244f38d8683537c375958c9c75a4796a2de4d1daa3d00aad2668e",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_multsntrup1277_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_multsntrup1277_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_multsntrup1277_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_multsntrup1277_CONSTBYTES

static void *storage_core_multsntrup1277_h;
static unsigned char *test_core_multsntrup1277_h;
static void *storage_core_multsntrup1277_n;
static unsigned char *test_core_multsntrup1277_n;
static void *storage_core_multsntrup1277_k;
static unsigned char *test_core_multsntrup1277_k;
static void *storage_core_multsntrup1277_c;
static unsigned char *test_core_multsntrup1277_c;
static void *storage_core_multsntrup1277_h2;
static unsigned char *test_core_multsntrup1277_h2;
static void *storage_core_multsntrup1277_n2;
static unsigned char *test_core_multsntrup1277_n2;
static void *storage_core_multsntrup1277_k2;
static unsigned char *test_core_multsntrup1277_k2;
static void *storage_core_multsntrup1277_c2;
static unsigned char *test_core_multsntrup1277_c2;

#define precomputed_core_multsntrup1277_NUM 4

static const unsigned char precomputed_core_multsntrup1277_h[precomputed_core_multsntrup1277_NUM][crypto_core_OUTPUTBYTES] = {
  {131,13,63,252,160,10,64,246,99,2,56,6,27,1,255,255,121,11,169,240,172,13,212,11,62,250,52,241,201,12,46,4,155,5,11,247,61,13,208,9,60,1,182,11,103,5,111,9,81,241,219,241,183,243,88,250,220,243,16,0,177,249,35,8,175,0,121,7,186,243,189,242,211,250,32,11,191,254,208,13,84,244,98,252,183,9,227,243,107,251,145,250,76,245,180,1,17,8,24,244,130,4,158,12,202,7,64,7,49,252,190,247,230,8,66,241,254,248,120,14,29,243,176,1,88,243,144,246,224,8,214,1,170,244,166,242,183,9,55,14,46,2,211,247,31,12,206,6,13,250,211,241,180,3,197,9,237,11,183,12,247,10,123,249,3,247,59,242,70,255,72,255,7,245,70,13,246,2,29,8,21,251,178,11,13,244,124,244,241,4,247,14,12,246,21,1,179,5,157,244,59,7,128,8,244,8,40,245,123,10,147,7,183,12,106,248,65,251,229,14,55,1,246,5,139,8,166,244,188,255,235,8,220,13,25,3,2,251,91,8,137,11,91,10,44,4,56,254,193,253,194,5,146,249,59,7,172,250,109,242,144,12,245,255,130,5,169,247,166,252,158,3,38,0,58,5,153,8,127,252,207,242,158,10,217,3,57,245,32,5,51,8,14,249,60,14,102,242,44,10,52,248,91,12,183,7,202,247,242,1,14,2,241,4,114,255,249,241,192,241,27,2,214,5,67,251,139,241,204,2,160,242,113,250,93,248,158,246,216,251,154,255,137,254,81,255,38,5,105,251,236,12,206,254,252,0,34,244,208,248,225,8,147,6,160,240,111,2,88,255,107,7,47,243,183,247,15,252,81,5,146,6,38,4,204,9,141,254,174,249,147,6,193,246,239,250,135,12,64,2,88,3,190,254,131,252,185,9,20,1,219,240,112,246,4,15,183,12,103,251,61,3,129,255,107,10,151,4,147,244,157,251,214,2,163,253,125,255,142,248,175,246,71,12,77,248,237,5,200,4,1,244,227,255,121,251,71,242,100,250,104,7,67,253,197,246,41,14,2,4,2,249,72,15,113,13,8,15,126,11,11,12,58,6,195,8,119,248,227,4,153,250,102,247,26,252,167,254,57,1,243,243,171,242,134,10,253,7,28,10,138,245,38,250,197,1,9,253,59,13,234,243,88,10,85,5,57,247,110,4,121,1,237,4,205,255,247,248,219,0,168,11,233,3,108,3,107,247,164,245,185,11,224,4,189,255,205,8,50,253,186,2,73,8,227,246,169,9,182,10,76,249,8,8,30,5,95,15,168,242,58,15,173,13,51,244,68,10,139,255,45,244,145,3,71,241,52,10,36,14,47,10,29,253,17,253,238,242,48,245,248,3,128,242,65,241,196,251,58,15,225,5,218,251,27,243,134,3,134,3,7,250,109,10,24,8,138,255,139,4,37,13,97,250,233,8,138,249,21,3,113,243,25,0,70,252,188,11,232,244,78,252,19,8,193,244,16,14,79,14,85,2,150,247,129,243,88,253,46,8,218,251,228,244,104,5,57,1,84,252,143,0,230,246,22,252,40,10,12,251,159,10,196,241,224,0,240,9,192,10,69,5,195,1,228,251,151,2,130,248,73,1,19,255,133,243,74,253,233,254,237,10,190,5,15,252,49,251,234,0,214,3,188,11,37,7,10,251,110,246,183,9,63,6,91,5,97,254,139,8,155,252,213,253,164,243,127,2,86,0,235,241,183,248,5,1,238,13,245,253,166,0,245,240,137,2,31,5,251,243,44,12,210,246,145,255,104,14,84,11,151,1,69,1,29,255,154,10,128,3,40,250,151,250,114,253,184,252,116,247,77,12,87,248,245,12,162,247,213,248,111,254,172,240,152,245,66,249,245,1,73,253,186,5,150,244,19,9,9,6,133,249,192,247,10,253,113,251,175,251,125,2,116,12,0,14,206,12,102,8,12,253,152,248,163,241,167,7,73,9,13,254,43,2,164,242,56,0,8,247,86,3,153,6,78,13,48,15,98,11,53,12,198,11,186,250,163,252,136,13,62,0,34,3,13,241,146,10,69,8,245,6,149,243,214,240,68,241,231,10,162,249,173,242,159,250,248,251,16,243,84,13,150,242,128,9,77,14,194,3,168,3,160,249,14,15,231,243,247,9,141,14,72,241,144,243,251,0,104,249,148,2,227,3,152,244,223,253,49,254,33,245,100,249,176,255,219,13,107,253,201,9,246,7,11,245,144,248,182,251,39,249,124,245,45,244,89,11,106,5,238,9,129,12,58,10,247,240,85,249,56,1,203,255,30,252,128,244,203,255,166,7,160,244,64,245,77,3,77,253,232,243,30,15,57,12,97,247,72,3,238,8,219,8,227,250,117,6,79,248,70,11,5,6,236,247,221,9,75,255,240,7,229,5,110,255,225,243,143,14,222,253,171,13,128,251,85,5,163,255,217,0,250,243,227,5,59,3,84,246,215,251,235,247,34,244,144,10,188,11,236,244,69,249,136,252,145,4,178,4,160,250,108,14,60,249,102,6,240,249,8,0,234,240,90,248,12,8,70,249,223,253,162,1,198,1,1,0,250,249,22,8,222,4,18,8,94,254,129,2,254,6,5,246,125,8,101,243,181,8,118,10,233,248,107,245,197,246,247,247,19,8,205,14,12,248,70,6,235,243,21,252,51,6,139,248,68,251,184,247,138,244,152,251,180,242,113,3,4,3,247,253,190,2,71,9,79,255,157,14,181,241,10,244,60,11,84,242,95,6,13,11,116,242,33,3,76,11,52,15,251,244,199,241,198,9,249,244,149,4,97,10,59,1,178,14,164,13,161,253,28,1,212,250,213,241,85,248,87,0,101,14,52,255,202,255,213,8,83,255,162,9,42,255,109,10,223,4,54,6,135,255,84,4,34,249,99,3,227,255,129,242,121,244,217,13,64,251,74,14,198,10,52,247,185,253,129,255,191,11,103,243,237,251,56,9,87,244,20,11,67,246,47,255,201,241,170,242,19,242,163,246,204,246,54,250,37,13,232,241,93,244,225,6,173,5,212,240,51,253,83,6,179,3,100,12,92,10,65,255,220,9,86,2,176,7,88,7,173,253,96,14,137,244,67,0,116,8,219,255,167,250,8,8,207,1,83,14,130,251,79,8,123,249,244,5,245,12,137,254,248,11,28,253,10,7,31,242,118,3,32,10,1,1,135,6,179,5,127,6,105,254,24,244,54,12,8,251,94,252,97,7,201,4,247,241,160,241,110,255,101,255,244,251,44,1,221,0,181,245,70,6,221,245,234,245,66,254,117,11,23,243,118,251,130,8,79,13,166,255,212,10,206,244,209,14,61,250,168,252,35,10,91,244,173,6,133,8,152,6,81,241,31,247,153,12,250,243,226,243,13,15,181,2,243,6,112,248,194,13,108,246,89,250,239,11,205,246,68,251,164,250,205,240,177,248,80,248,186,14,125,244,147,255,244,8,163,3,244,244,63,252,189,8,231,253,111,12,255,253,0,15,20,250,134,4,182,9,211,3,110,0,118,14,252,0,143,243,77,251,241,11,171,9,50,13,42,246,185,248,245,14,130,4,75,0,102,245,15,252,48,14,175,244,162,14,164,249,116,253,48,5,81,2,173,14,147,12,206,13,179,246,106,241,220,8,253,3,107,0,184,3,134,9,81,10,16,6,21,249,128,4,135,11,249,255,154,255,191,253,133,12,156,13,56,243,6,8,31,246,13,4,107,241,167,249,85,14,217,8,147,249,130,13,112,253,123,5,204,12,188,245,185,241,17,3,52,8,166,247,18,252,146,249,193,240,37,253,127,2,179,12,224,240,49,8,8,3,26,8,122,1,84,11,2,255,89,15,201,253,1,2,30,4,134,254,64,14,204,7,182,247,94,255,192,247,134,253,144,251,106,0,252,253,133,2,180,250,157,255,204,246,247,246,55,12,224,248,190,245,209,10,114,7,180,253,155,245,216,1,174,13,21,255,128,12,159,4,71,241,160,241,123,12,202,3,2,14,5,5,124,9,238,10,138,13,177,245,177,244,63,1,176,241,211,254,189,254,91,253,139,2,79,12,100,2,33,254,66,11,222,0,59,6,168,2,134,1,139,249,94,13,217,244,206,1,58,7,99,11,248,254,197,2,248,245,125,248,17,13,137,255,123,0,143,243,81,0,251,247,10,8,94,0,252,12,82,250,172,244,117,10,122,254,19,245,241,242,76,1,66,242,179,251,163,12,54,254,75,251,136,10,76,3,198,13,68,244,232,248,56,245,67,4,147,7,232,0,165,0,224,245,44,12,101,253,236,251,104,3,9,246,225,13,77,244,100,0,223,7,159,244,21,11,40,15,155,4,139,249,160,252,48,8,185,241,186,247,170,250,78,253,214,5,99,254,195,245,95,7,191,2,224,255,194,254,250,8,123,241,248,7,44,255,21,12,163,245,48,252,15,244,188,242,193,240,46,249,27,11,76,2,20,254,90,5,150,253,183,255,237,6,51,1,11,245,149,14,238,242,73,254,138,6,126,241,201,244,209,241,91,254,188,248,0,241,126,245,33,241,12,243,6,12,236,1,62,243,212,255,112,1,174,245,60,13,144,10,75,243,116,6,132,1,48,6,61,11,114,253,137,4,96,9,144,12,184,4,185,10,195,0,206,3,107,13,255,245,200,5,132,9,223,249,88,6,107,249,130,11,179,7,21,253,195,244,127,0,215,14,38,14,190,14,248,9,251,246,179,5,146,0,208,248,36,254,147,13,245,6,66,243,100,13,71,246,186,251,168,9,98,241,44,244,205,243,93,12,63,241,67,15,48,4,46,251,126,4,239,251,17,5,54,243,96,241,247,254,108,13,161,253,99,8,48,4,122,249,36,1,245,247,23,243,143,3,43,0,185,254,94,15,173,243,222,252,85,3,231,248,121,250,226,0,189,5,123,14,118,10,106,1,84,253,94,11,244,253,15,13,9,15,33,2,216,4,143,10,225,252,101,2,40,4,12,255,11,13,19,8,15,4,225,11,46,10,44,242,28,5,69,245,140,1,195,250,131,8,157,241,224,10,56,3,214,247,219,6,116,250,112,6,228,7,61,12,116,250,153,241,205,254,10,244,221,13,4,247,141,252,246,2,39,242,11,249,48,248,155,14,159,251,92,248,81,8,162,7,178,4,228,247,12,4,166,254,253,253,136,11,92,241,128,4,108,253,8,12,242,14,169,246,178,8,2,251,223,252,73,253,108,245,165,6,194,255,160,247,37,248,250,253,245,247,225,10,54,246,251,254,111,246,105,253,83,13,151,10,203,245,44,4,119,250,241,5,142,246,101,252,153,8,181,3,209,244,104,254,80,251,71,2,128,241,146,245,71,254,135,242,26,247,242,254,64,241,202,5,174,5,189,14,197,248,173,243,234,1,244,9,204,244,125,251,99,15,92,10,86,254,135,245,74,7,0,254,40,253,0,242,177,246,124,14,76,255,146,6,174,248,165,246,80,253,212,249,200,10,254,246,148,7,248,255,217,241,44,243,81,2,181,1,69,255,252,249,252,6,204,249,170,3,89,14,209,3,218,242,116,2,32,248,244,7,205,240,118,255,236,252,104,1,73,244,144,255,0,11,240,241,153,247,72,12,48,2,43,249,147,254,251,5,131,255,244,246,42,7,172,246,11,246,38,254,96,15,132,9,102,0,210,249,220,240,117,241,94,8,13,2,29,252,129,4,208,0,198,12,28,2,107,253,89,8},
  {139,10,118,254,31,14,234,244,255,245,48,247,80,249,92,252,196,252,97,246,195,243,74,5,207,11,182,252,142,2,197,252,27,7,21,249,117,254,15,254,177,247,163,5,137,12,41,246,200,7,173,246,21,252,183,10,52,250,236,9,202,254,187,252,46,248,172,251,223,14,125,8,44,11,143,252,50,247,81,245,88,247,98,254,236,241,193,248,200,243,126,249,130,0,13,15,98,248,151,255,164,255,162,252,0,241,120,250,97,251,136,11,95,15,50,15,110,253,122,10,142,13,181,252,236,246,161,251,21,4,182,249,76,242,126,9,19,5,242,3,187,248,221,1,111,4,128,2,101,255,18,250,190,3,173,2,194,10,38,241,167,0,234,241,98,241,225,2,35,3,11,1,181,10,255,13,110,1,255,249,200,13,67,246,31,245,106,11,12,255,172,244,44,244,33,7,226,7,202,12,187,1,220,9,254,244,218,12,50,244,176,255,220,251,75,255,153,243,27,9,154,247,239,0,250,7,144,6,136,4,214,240,45,8,163,14,7,241,244,7,166,250,3,241,167,3,86,8,221,250,72,11,78,249,238,6,150,12,15,253,213,251,197,13,224,13,42,242,170,11,7,253,28,2,162,248,157,1,8,249,242,12,1,245,135,13,1,11,11,7,74,253,228,241,164,254,48,4,81,14,65,3,94,5,234,249,68,243,144,12,192,246,216,2,140,242,46,249,6,11,139,12,192,247,47,251,46,251,2,5,175,4,150,2,2,11,28,2,224,0,45,242,184,247,228,240,79,7,242,0,215,243,4,15,81,3,104,9,52,2,69,11,148,13,162,0,214,245,70,13,161,245,6,251,254,2,150,246,77,7,62,14,77,7,170,251,193,241,40,255,212,242,244,9,107,4,193,246,98,253,205,254,56,0,167,247,164,6,138,244,45,244,15,8,130,253,250,2,163,11,251,12,123,7,224,250,129,2,109,254,191,5,191,5,215,240,161,251,14,255,190,244,24,242,200,240,71,249,28,15,91,14,143,14,38,10,237,250,210,245,251,3,58,245,65,243,65,247,116,253,42,250,110,243,233,0,85,6,177,1,93,250,217,242,120,0,156,254,222,3,215,252,38,11,121,248,214,249,49,7,66,14,129,14,82,8,18,248,243,245,164,11,189,14,233,246,165,240,154,4,177,254,96,242,118,8,86,1,75,249,85,12,182,1,77,247,96,14,48,243,32,243,184,11,239,250,42,13,67,255,38,7,81,253,97,244,49,3,77,9,17,241,39,13,46,248,241,250,53,255,227,2,1,244,122,2,208,249,194,11,69,249,178,6,152,254,121,11,231,243,187,242,81,9,185,7,32,249,163,250,135,7,209,6,136,244,116,1,247,251,177,245,200,4,218,11,207,7,94,243,121,254,11,11,67,243,127,10,85,13,106,7,37,248,51,12,126,3,214,10,30,10,222,9,50,8,2,254,50,15,70,2,136,7,139,9,174,6,138,7,21,6,29,11,225,10,206,253,216,8,109,247,64,9,64,249,241,6,135,10,157,245,195,250,18,254,169,4,68,8,41,241,130,2,200,242,211,7,251,2,44,11,150,6,212,10,218,242,211,243,58,246,154,7,139,0,83,243,106,241,44,253,253,13,64,9,151,250,170,11,217,5,217,245,227,4,245,1,215,5,163,9,183,13,241,0,170,247,96,1,235,241,41,244,91,252,13,2,138,4,123,244,151,10,65,13,249,254,104,249,76,251,3,241,157,242,145,11,239,250,237,249,164,241,42,5,92,253,91,3,237,246,97,253,195,255,185,244,29,10,157,243,102,248,129,242,99,255,102,9,89,14,141,241,42,246,250,252,101,250,48,245,242,254,26,11,40,1,215,252,120,252,97,241,167,2,210,3,125,254,181,7,16,246,52,0,171,251,180,1,46,249,115,245,145,4,249,254,15,1,34,251,141,4,74,10,194,0,176,243,70,14,28,255,57,248,30,249,244,247,85,244,114,243,209,6,251,13,155,11,208,247,97,241,42,9,177,8,25,11,125,249,81,8,85,252,105,8,238,0,37,250,68,1,0,2,84,1,109,245,241,13,211,14,19,12,151,245,135,5,160,252,163,0,151,246,221,11,246,10,32,244,213,246,210,246,239,254,126,251,234,7,106,253,89,250,228,249,127,247,240,247,112,14,81,11,47,247,29,252,122,244,150,252,22,13,142,244,248,247,209,251,127,245,140,243,60,12,215,13,57,248,78,249,139,11,15,248,12,255,14,253,45,252,157,7,233,244,158,4,92,249,221,242,180,253,123,0,44,247,82,1,193,247,142,250,206,240,115,251,165,1,137,4,58,8,231,12,126,7,100,5,180,14,97,254,132,241,121,252,219,255,27,243,106,242,154,246,89,10,135,13,209,249,254,244,146,250,222,245,35,15,50,11,22,10,18,250,96,2,31,245,61,4,183,13,82,6,203,252,12,253,247,248,220,244,28,252,246,7,82,243,38,0,70,5,95,247,229,13,53,249,116,5,185,0,59,254,241,240,211,2,62,2,178,254,125,8,207,1,211,241,174,245,145,254,75,2,116,245,4,245,25,2,65,4,18,14,98,252,24,14,118,252,205,0,29,4,15,253,130,250,79,5,238,250,155,243,174,10,149,253,21,244,1,243,95,3,139,3,244,255,9,250,95,12,148,255,89,255,196,255,16,0,110,9,9,255,4,0,145,246,203,241,63,13,91,0,208,254,162,240,8,250,219,251,78,244,4,243,143,8,39,11,161,4,83,253,135,242,225,246,60,9,252,255,141,251,68,246,12,15,119,248,128,253,12,7,237,1,1,7,240,7,98,243,182,249,117,244,17,14,85,8,89,252,241,9,78,8,180,2,0,249,9,12,108,245,221,244,13,255,47,252,112,251,194,5,106,9,50,15,24,254,82,3,5,7,241,241,5,248,183,2,164,4,139,246,186,4,216,10,177,249,250,10,248,240,42,243,221,0,60,243,2,250,217,247,235,254,54,10,118,4,43,3,244,240,0,255,15,249,81,12,197,9,10,249,116,10,245,242,24,2,232,241,29,7,80,251,179,241,160,248,163,245,224,12,218,9,129,13,59,2,156,12,31,4,105,9,112,248,122,10,143,251,57,255,145,245,141,252,234,255,74,252,87,8,201,241,90,13,193,250,98,0,190,248,209,4,76,247,215,9,178,13,118,253,147,253,148,14,184,3,241,5,81,255,41,253,207,14,184,7,231,12,193,241,224,250,221,243,250,243,61,14,206,10,97,247,26,6,19,254,241,3,207,243,73,14,189,240,80,13,168,2,250,244,163,12,176,248,250,251,102,255,209,245,39,252,245,255,53,10,128,246,40,253,38,249,239,13,45,252,127,249,93,245,215,13,71,15,72,2,24,255,169,255,17,6,202,243,44,7,53,250,99,7,250,11,200,10,72,248,201,1,3,14,32,244,215,12,29,2,189,254,213,250,14,248,226,3,116,246,191,245,88,4,149,12,242,251,170,253,36,244,92,244,249,3,226,247,169,1,16,10,219,255,186,252,164,255,166,1,16,7,230,5,208,3,1,243,116,241,23,251,153,246,199,11,6,252,147,244,114,249,32,250,153,1,91,7,88,250,12,5,252,241,240,13,73,0,1,245,18,253,143,4,136,9,231,251,172,248,127,4,250,245,185,2,23,15,104,255,85,11,69,7,25,13,154,254,189,13,221,246,69,3,234,249,51,241,237,2,211,247,234,8,211,12,253,255,232,248,102,245,6,244,161,240,65,255,98,6,27,13,240,242,133,241,164,253,103,1,225,245,107,241,149,250,180,243,186,242,96,245,9,255,231,7,64,246,17,8,203,14,166,246,8,14,52,2,157,243,108,8,176,244,246,254,12,254,113,5,40,2,120,255,43,12,182,243,221,253,163,252,189,248,178,254,29,242,236,251,45,3,201,1,57,245,74,5,232,240,11,247,189,249,38,251,18,2,43,6,155,244,143,247,128,11,212,11,192,2,76,244,205,242,63,255,232,4,40,250,8,246,195,243,182,6,23,4,157,243,150,254,255,241,81,15,217,252,166,13,245,248,173,245,165,253,12,246,152,243,101,10,249,0,62,252,208,243,142,247,248,10,75,14,201,8,181,254,128,245,102,248,46,5,230,3,131,241,210,252,230,12,162,14,130,13,217,255,241,242,48,243,24,252,250,12,72,251,203,240,194,11,209,251,66,7,211,7,58,250,72,1,103,14,15,251,67,7,192,4,131,13,200,8,212,8,129,1,108,244,171,254,165,12,156,4,169,1,248,246,208,9,66,243,228,4,34,11,231,249,141,1,226,251,240,3,239,242,232,242,16,12,134,254,126,14,66,12,55,253,22,15,125,12,188,240,56,245,133,246,29,13,145,7,249,252,189,7,156,245,230,11,212,249,117,13,230,249,14,1,93,248,44,5,111,254,2,13,98,1,24,0,182,1,216,10,174,4,78,14,169,8,183,12,163,253,149,5,196,10,115,243,94,246,1,2,86,246,240,244,208,250,73,253,223,241,160,8,57,250,85,15,204,245,218,249,161,250,245,0,98,9,3,250,244,251,88,6,117,246,145,248,24,1,124,252,83,8,206,252,188,1,147,8,31,254,47,247,223,5,214,248,17,4,41,6,167,250,58,251,123,13,14,243,72,254,172,5,107,246,237,255,72,5,118,10,200,249,197,255,254,249,250,7,67,1,223,241,140,246,69,255,53,241,33,242,135,252,23,252,96,245,219,11,20,253,221,250,183,240,12,13,81,249,172,248,254,7,251,244,13,14,174,249,245,255,143,2,116,242,46,7,65,8,46,14,122,248,16,244,150,12,113,10,91,241,212,7,65,15,4,241,46,3,79,13,159,1,158,251,194,6,132,0,252,245,247,250,253,0,117,7,197,248,10,15,191,14,137,248,15,10,10,253,131,248,0,249,233,13,252,5,32,11,17,249,210,244,30,3,17,244,42,243,156,3,102,12,5,249,232,255,74,15,163,6,81,7,132,246,81,253,203,244,13,9,74,12,211,6,235,7,111,13,67,12,248,242,233,244,33,254,8,3,37,3,148,0,130,254,229,254,190,4,56,4,46,248,4,15,205,255,82,2,202,241,34,3,171,14,161,8,67,8,161,251,225,247,220,9,243,9,253,252,110,253,219,11,167,248,70,8,233,242,233,0,46,246,140,5,16,14,3,6,220,251,114,255,182,250,221,250,73,9,221,1,197,0,3,250,78,8,75,12,195,251,222,241,163,11,222,240,140,2,182,248,45,248,103,254,108,249,66,14,208,248,80,2,37,11,23,245,70,243,100,241,115,3,229,10,96,8,148,254,199,4,140,8,228,252,63,10,253,12,25,248,202,12,111,7,74,248,133,244,10,254,169,254,71,241,5,241,39,247,105,253,155,6,17,252,187,250,101,248,160,252,224,255,205,243,130,12,73,14,165,253,134,13,136,241,192,13,144,7,32,1,65,9,113,11,18,254,171,1,239,249,16,252,14,5,140,4,84,2,234,245,5,247,9,254,149,5,0,9,215,251,144,253,109,0,221,3,40,4,141,3,53,243,75,6,153,10,244,249,98,248,26,246,37,7,27,245,230,251,202,245,222,7,99,246,30,250,136,242,115,7,79,3,54,242,137,248,150,14,96,248,2,11,71,241,243,14,192,5,160,250,204,2,179,245,184,247,72,252,116,249,28,246,42,5,89,248,84,14,228,5,2,11,247,241,176,247,23,12,133,0,79,11,150,9},
  {63,1,87,3,152,247,160,6,168,240,121,14,13,12,127,241,25,251,144,241,240,240,182,241,41,7,14,247,134,252,60,1,19,11,171,5,47,242,251,9,17,11,139,1,172,5,69,5,205,7,169,245,174,14,153,250,66,2,55,251,106,8,62,11,181,251,120,14,190,247,171,10,67,0,73,245,0,13,221,13,170,3,252,247,220,3,126,246,145,249,29,0,147,250,16,251,169,243,154,5,193,14,14,3,252,12,20,11,87,0,101,253,192,251,139,0,74,13,82,1,195,251,55,14,175,255,246,6,146,245,44,249,254,14,99,255,5,252,13,242,214,14,156,6,175,9,157,13,116,241,145,245,45,247,150,14,107,250,5,10,184,242,112,245,77,245,39,242,191,1,142,5,167,248,83,250,208,243,42,245,113,6,92,241,30,11,153,9,228,254,234,250,164,13,234,254,20,252,220,255,254,7,208,250,170,9,165,7,7,14,103,245,163,3,204,240,18,13,117,245,240,240,15,5,48,254,67,8,74,242,207,250,150,244,171,245,16,244,130,7,246,246,204,10,129,7,9,13,223,249,7,241,84,244,222,254,166,251,115,0,234,12,52,247,164,247,68,246,95,3,79,252,123,241,226,7,0,244,229,240,143,250,83,4,197,7,156,248,243,240,251,243,113,10,217,10,5,2,126,3,10,10,76,249,43,14,200,7,1,15,143,255,123,2,74,15,166,5,49,7,34,252,201,12,255,251,98,12,1,252,72,248,247,3,75,2,0,0,50,251,15,251,48,5,5,255,211,5,75,2,137,245,212,241,86,255,186,255,135,253,155,250,28,0,116,3,239,8,236,9,73,253,9,11,155,241,26,243,140,252,97,243,70,1,171,2,114,0,73,13,225,243,86,2,4,252,153,2,16,245,118,248,254,10,21,254,242,13,52,5,240,244,61,245,20,255,178,0,221,7,213,251,157,5,77,251,181,13,218,245,102,254,230,255,44,9,104,13,34,251,202,0,82,6,102,3,143,1,146,251,32,251,85,243,89,244,99,255,131,249,115,245,11,11,90,242,224,245,233,253,90,241,62,3,163,255,216,9,126,14,50,248,147,241,220,242,147,254,253,247,217,1,213,243,242,241,168,2,76,15,25,10,238,10,254,253,218,3,21,241,226,243,180,243,205,248,151,6,122,248,127,11,177,6,204,249,202,240,215,7,93,12,34,7,166,246,183,247,11,3,239,14,125,247,116,11,121,255,244,242,233,8,35,244,37,12,31,246,94,253,201,1,30,252,54,2,181,248,187,255,95,241,237,246,137,246,0,253,250,3,161,14,29,247,97,241,239,254,17,255,53,14,28,244,183,7,113,248,96,11,180,8,66,4,158,7,67,8,136,243,64,247,141,244,133,249,213,241,48,245,237,240,185,5,24,1,201,14,137,9,228,249,179,250,20,10,145,13,183,254,16,252,124,10,126,11,251,7,136,243,238,2,10,254,73,254,56,1,92,250,73,245,233,4,166,1,209,11,184,14,117,247,89,245,197,251,41,12,51,248,172,3,88,5,6,241,2,252,83,2,11,2,30,241,158,8,234,8,106,243,79,246,207,249,203,245,255,246,202,10,20,248,25,243,206,14,53,1,159,243,112,10,232,14,108,12,33,0,182,249,2,1,156,3,124,244,122,241,40,245,121,245,45,244,83,2,106,0,75,11,75,7,250,250,132,255,4,248,87,4,208,8,162,246,235,243,20,9,30,13,225,240,202,1,139,245,182,246,218,11,151,0,86,12,56,7,60,241,241,242,164,247,250,253,86,243,227,251,236,243,90,249,232,3,5,243,7,252,25,255,41,246,209,2,184,8,137,255,152,241,172,10,163,4,49,241,28,9,151,6,192,243,232,14,117,250,215,250,8,255,67,245,226,251,107,8,213,4,235,13,26,255,213,248,71,14,32,252,232,4,64,247,6,253,83,0,255,7,97,1,208,2,87,254,235,248,88,10,62,8,169,255,215,6,67,241,25,251,172,252,85,255,222,10,43,0,153,250,126,11,34,3,174,240,231,254,105,6,7,244,252,242,108,246,37,244,178,14,200,252,131,12,57,15,148,8,254,13,13,246,171,9,104,7,83,244,114,6,190,242,94,13,59,2,118,13,195,254,23,2,249,240,101,5,52,252,129,1,62,9,105,247,112,251,121,252,47,255,82,13,95,255,225,247,9,251,23,248,138,13,20,6,28,2,76,245,25,3,101,248,133,244,204,6,201,14,22,246,176,246,236,7,80,247,21,244,69,5,214,3,151,254,74,248,2,0,138,3,134,5,99,2,67,241,118,241,78,242,228,9,154,255,90,5,175,4,179,241,23,255,244,244,57,15,201,240,157,241,175,255,84,0,133,12,81,8,114,242,165,4,68,249,149,249,25,241,112,243,210,254,182,247,204,250,166,4,56,251,138,14,69,12,246,10,49,1,45,2,95,255,159,241,199,9,52,254,139,10,2,4,174,10,242,4,171,5,147,10,5,254,97,244,215,245,183,247,130,10,215,240,47,255,40,242,47,2,210,7,118,14,169,0,73,251,65,6,204,241,162,244,107,243,93,8,55,244,239,6,9,253,27,254,154,9,246,245,90,252,113,8,126,250,231,243,75,10,112,7,236,250,67,243,159,12,182,11,158,3,240,5,147,255,209,254,239,246,237,7,207,252,44,244,221,243,90,250,244,244,232,2,25,242,25,7,109,250,191,255,212,5,88,253,197,8,134,12,213,14,243,252,171,255,105,0,211,247,150,241,19,3,151,5,248,252,231,249,7,5,45,8,125,14,150,6,152,243,115,253,174,242,112,244,139,6,194,241,228,2,82,2,229,11,121,3,37,242,3,250,230,254,255,245,89,253,250,0,40,11,209,249,45,15,201,13,166,10,92,253,208,255,35,245,62,249,108,9,254,242,96,253,73,241,232,8,137,14,234,14,92,249,110,0,9,243,7,11,250,8,161,240,246,251,44,255,130,7,144,8,60,242,114,3,174,1,140,248,217,11,140,2,133,251,61,247,17,15,102,254,35,249,123,254,92,250,65,4,126,243,185,248,136,2,250,11,245,244,94,6,42,13,5,251,233,5,228,2,185,7,209,4,217,246,79,11,160,0,244,1,235,254,182,12,240,14,246,251,122,249,151,12,31,252,174,243,128,6,48,250,136,255,142,3,124,247,246,7,7,5,253,250,137,5,238,8,59,251,254,241,42,241,178,250,179,252,182,253,129,2,36,249,206,253,151,3,84,15,156,247,120,247,96,5,18,2,206,9,227,14,67,246,153,5,65,15,18,15,18,11,8,3,230,2,25,244,7,246,25,249,63,11,172,246,189,247,138,242,238,14,44,248,177,9,19,252,87,5,37,241,6,14,142,255,191,8,14,254,161,6,28,245,220,254,141,251,228,1,145,7,231,2,113,247,87,244,108,5,12,3,56,251,155,13,46,10,88,5,83,251,210,242,119,5,33,245,29,9,199,255,201,2,27,8,8,248,202,253,127,249,32,1,154,255,143,245,176,13,248,4,15,246,249,14,198,4,27,249,142,8,49,250,90,2,164,240,239,244,190,250,215,12,234,255,46,7,223,249,248,12,38,245,27,247,107,6,23,248,151,247,53,15,166,9,121,14,103,247,142,4,190,13,43,253,199,7,229,3,181,247,24,4,79,251,161,241,210,249,89,241,87,11,72,2,183,251,73,250,45,255,86,247,227,251,112,249,183,246,77,246,60,247,185,6,167,241,153,241,129,248,84,15,116,249,195,240,36,8,112,7,209,11,136,0,15,2,149,8,158,240,238,2,23,2,217,243,219,7,66,0,145,251,33,6,90,7,176,14,113,244,212,1,194,240,52,14,20,4,120,6,145,0,55,12,211,0,227,11,49,251,213,241,139,2,146,6,248,243,60,1,196,244,211,3,132,251,64,6,172,252,51,9,194,9,99,242,134,247,126,0,71,246,196,247,30,250,246,241,156,241,100,250,253,247,69,15,105,5,247,255,212,9,50,249,118,0,74,5,147,246,57,4,170,2,99,7,112,13,240,7,75,253,125,251,104,14,231,2,146,2,126,250,245,0,50,252,172,13,87,14,133,9,152,255,210,253,13,241,135,5,121,243,116,255,212,0,120,252,241,11,53,15,46,10,165,255,78,245,140,8,92,12,74,5,87,7,63,8,75,5,113,4,245,4,4,11,19,4,220,254,83,245,224,248,201,242,221,250,52,253,229,2,38,243,124,12,218,241,149,13,168,240,16,11,102,10,198,3,194,6,174,245,218,241,39,252,194,7,218,250,251,12,220,12,40,245,97,242,34,252,187,7,13,255,96,254,252,13,51,6,215,0,33,4,26,4,216,243,108,10,175,14,51,6,159,2,180,253,15,4,53,8,11,11,22,11,180,13,152,6,93,0,228,10,246,4,147,253,155,9,142,253,193,241,52,250,213,245,181,242,191,0,44,254,36,255,102,243,90,4,182,242,214,247,190,245,87,1,177,248,148,5,86,8,100,249,217,10,156,5,45,250,210,255,31,249,40,253,227,252,227,247,183,6,68,11,189,251,225,249,3,252,65,12,239,244,249,241,34,0,150,255,239,251,57,254,210,12,10,6,128,0,153,245,105,13,105,254,69,242,57,246,53,7,27,8,26,250,72,0,2,8,58,255,156,255,163,254,62,250,49,244,234,250,141,250,125,6,6,14,248,8,46,254,103,250,214,246,94,243,235,6,146,247,250,245,190,2,198,3,51,241,24,247,253,9,202,249,120,11,55,11,221,253,18,1,53,8,163,255,166,5,185,247,183,2,247,2,178,2,132,8,89,13,33,3,105,4,67,2,233,8,216,11,29,242,203,7,40,9,217,0,85,5,110,243,194,5,102,1,37,6,150,244,229,246,44,255,204,7,199,7,23,1,70,247,156,9,184,8,195,3,227,3,111,251,150,243,49,3,34,0,182,14,81,246,234,2,28,11,86,13,235,241,108,13,144,243,66,242,45,250,186,255,126,1,196,2,235,246,142,243,44,255,125,7,229,254,137,244,46,247,92,252,116,4,145,251,0,6,63,253,84,3,181,3,100,11,142,241,31,241,223,255,114,2,96,250,199,254,234,244,185,3,4,248,32,15,133,3,70,254,34,252,222,4,113,251,4,7,120,249,138,4,179,8,183,1,216,1,213,1,81,255,27,249,69,8,205,244,135,9,215,12,30,11,207,248,40,245,130,13,245,249,193,14,150,9,215,240,246,253,224,246,237,1,57,5,134,252,174,248,157,247,218,247,141,4,98,246,174,242,130,4,113,248,189,8,168,2,77,10,166,248,55,12,180,2,47,242,20,250,207,8,254,243,242,244,208,9,238,2,78,7,123,2,35,8,44,8,131,247,102,255,197,9,126,10,190,254,85,8,172,8,155,248,120,252,1,0,199,241,37,249,98,254,115,250,38,249,32,241,69,255,255,9,39,244,198,245,195,248,58,8,133,7,106,245,186,253,234,247,12,251,107,245,128,249,225,14,46,241,180,254,171,2,18,253,40,251,19,253,111,10,127,249,74,14,200,244,242,246,22,247,189,249,163,250,143,244,50,12,212,251,254,250,151,242,146,246,251,10,57,5,97,6,121,9,187,12,26,252,98,243,99,244,127,244,43,248,210,10,84,9,192,240,88,253,4,249,118,248,84,1,63,254,247,9,31,246,247,14,19,10,172,247,63,1,117,6,204,9,69,2,107,0,197,255,82,14,245,14,55,12,220,246},
  {84,241,21,244,243,3,137,255,93,255,70,249,155,245,61,244,71,7,14,15,171,242,129,1,104,3,19,10,143,0,100,245,113,244,236,8,134,247,91,4,42,8,244,2,191,255,137,254,128,249,143,241,133,241,185,253,11,1,194,0,250,242,221,253,179,254,56,2,86,10,105,244,254,249,38,0,0,14,23,245,64,245,149,13,128,247,40,3,165,247,207,3,116,252,217,4,165,13,100,7,11,245,175,241,203,8,46,251,52,11,145,7,101,245,110,0,200,6,19,14,229,12,78,247,77,252,79,15,49,11,65,250,73,241,146,7,3,241,199,247,1,12,79,246,221,249,51,244,210,252,182,0,253,244,233,10,23,252,155,3,184,248,169,240,169,1,31,8,220,252,51,6,222,242,64,247,165,253,180,254,191,2,156,4,110,13,99,244,253,8,31,0,247,244,203,13,164,5,213,7,80,15,38,246,231,4,116,6,189,253,60,246,150,0,211,6,113,253,247,10,18,243,142,5,65,9,40,251,152,2,184,4,32,250,249,246,26,13,5,1,124,12,222,254,148,253,49,6,53,14,194,10,205,11,107,255,115,6,72,0,235,244,23,253,11,245,28,11,183,240,46,242,228,254,109,254,66,255,71,251,207,12,237,1,56,9,153,0,35,247,1,5,71,14,90,247,22,251,208,250,117,10,82,249,161,252,33,243,20,14,74,9,109,7,141,5,84,11,24,14,88,1,160,252,27,15,144,12,4,241,34,6,19,11,87,250,193,9,10,3,57,255,226,4,64,246,19,248,36,8,220,8,170,8,65,7,117,10,213,245,37,0,164,245,19,250,108,241,169,8,147,255,226,2,252,7,92,249,132,11,133,252,138,246,154,7,21,7,137,245,60,11,135,242,132,253,211,243,165,6,223,2,210,12,123,255,127,245,177,2,52,244,136,9,192,245,118,244,158,3,55,0,221,11,125,245,32,4,202,10,182,244,44,2,173,255,229,254,99,11,42,5,254,14,76,251,171,251,18,10,99,241,64,245,35,15,153,244,7,14,148,13,242,243,119,8,152,246,186,251,253,4,120,6,128,252,224,4,69,11,223,242,106,0,209,244,221,250,182,245,30,251,66,251,236,241,167,248,139,245,24,254,100,250,54,8,229,14,222,250,68,246,80,244,84,3,89,253,140,255,64,244,248,241,128,250,53,11,55,3,37,247,236,249,199,13,93,249,76,246,153,250,45,250,70,15,146,252,70,8,142,0,68,242,170,255,152,252,69,2,70,250,199,240,142,241,73,14,136,10,204,242,234,244,179,13,168,7,207,250,103,8,117,243,195,254,13,251,127,6,111,4,93,247,101,10,19,253,29,253,172,252,41,246,24,15,38,5,80,5,150,247,103,253,111,242,42,251,178,6,238,245,130,1,96,243,217,8,128,10,56,252,158,242,153,9,199,6,241,250,121,9,28,0,235,247,246,252,28,245,97,6,207,14,47,244,150,10,135,12,246,8,117,6,4,10,235,4,125,5,188,9,108,2,138,255,159,10,207,4,229,253,36,255,108,244,59,3,38,246,196,252,101,9,214,249,122,11,190,13,44,241,87,10,245,247,102,254,26,251,245,254,226,249,161,5,222,6,43,254,122,14,53,2,68,6,202,253,168,246,17,248,13,11,252,0,177,2,222,9,109,10,97,2,76,13,163,7,127,4,180,252,181,5,74,6,140,8,178,252,253,252,20,243,255,241,223,10,225,250,228,0,20,249,59,0,223,250,139,249,244,10,227,4,22,2,8,249,220,12,139,5,220,0,248,5,133,241,77,15,124,250,149,253,198,247,168,7,40,6,165,5,142,251,76,9,84,1,61,10,233,0,185,12,123,246,177,14,143,241,25,0,38,1,167,240,200,1,75,4,250,242,61,255,243,10,245,10,126,5,15,250,240,7,222,7,101,253,193,9,68,9,192,241,247,1,232,246,182,4,84,243,85,3,116,241,162,12,98,7,108,253,40,7,107,0,69,5,54,4,186,14,89,13,185,11,44,6,252,6,84,1,167,0,245,9,104,244,27,5,167,240,94,243,34,249,230,241,132,242,187,8,34,14,120,243,215,247,27,9,207,250,140,3,196,243,204,254,32,252,90,254,88,253,169,12,65,8,65,10,121,9,235,240,165,247,79,7,254,245,74,246,206,251,2,251,100,251,154,242,128,3,177,247,244,6,75,1,113,0,45,9,38,13,87,2,217,4,208,240,175,241,220,248,126,4,2,251,49,6,186,3,65,8,236,244,161,246,47,6,184,9,181,5,121,246,206,242,1,12,178,246,174,253,50,2,76,15,207,1,70,1,106,247,182,240,169,248,25,250,226,2,45,254,156,245,175,255,122,3,183,245,110,253,121,243,214,7,125,241,32,9,0,7,144,255,9,244,161,14,127,9,225,249,98,253,219,5,104,8,178,5,209,9,225,249,103,253,31,11,212,246,23,5,114,253,221,245,241,240,153,6,227,243,24,250,144,4,24,241,181,240,43,249,156,10,13,7,143,6,164,3,124,5,187,248,228,1,181,4,98,3,182,254,163,12,78,247,64,0,236,255,219,4,37,250,118,7,235,8,231,246,67,9,154,251,177,7,195,14,66,244,55,251,0,253,199,242,208,11,0,253,53,244,94,241,42,10,81,250,187,10,159,0,160,243,160,246,106,5,189,8,58,10,36,248,41,245,26,14,106,3,139,4,188,249,106,0,178,8,239,254,67,15,206,248,198,14,107,13,19,4,242,244,217,8,16,249,210,247,192,11,174,245,213,244,152,8,47,1,79,247,224,243,67,254,129,248,12,243,60,1,78,251,135,10,196,7,113,10,84,8,68,248,46,9,62,241,147,10,94,255,92,0,140,252,18,8,201,250,92,12,211,254,106,7,182,5,198,5,200,244,31,244,95,244,9,5,209,4,184,2,168,244,128,245,58,13,204,10,251,247,79,253,93,254,59,4,117,242,12,2,86,251,28,7,114,246,206,245,72,1,195,9,103,249,30,3,175,243,212,5,228,243,76,241,133,3,202,242,228,0,22,246,44,8,24,0,214,0,81,11,219,254,52,1,198,9,246,9,117,10,75,9,24,8,1,244,168,12,153,243,150,9,218,245,89,243,80,251,79,241,202,241,69,254,148,251,188,245,206,10,114,8,74,3,242,13,30,254,183,1,141,255,159,14,249,9,113,245,36,0,158,255,112,253,215,0,236,6,129,6,49,254,98,3,230,240,42,245,188,253,247,254,171,252,159,1,222,11,28,15,93,4,154,245,98,2,65,253,207,9,4,255,241,0,209,7,244,3,87,15,213,246,199,245,151,255,133,5,220,243,138,253,174,247,146,4,231,252,214,247,63,3,248,6,96,252,137,247,243,12,27,253,180,248,62,242,80,13,189,249,215,13,77,252,199,8,104,4,245,7,45,13,201,243,49,10,241,255,80,249,40,5,133,9,198,246,114,253,7,6,204,240,223,248,239,252,148,245,183,7,33,11,231,1,72,11,223,6,149,242,88,249,184,253,119,14,57,253,247,8,49,13,119,251,248,7,195,250,165,251,81,0,10,253,250,12,208,244,199,7,19,13,10,12,219,3,43,249,10,255,61,251,249,3,130,254,9,7,232,6,47,8,205,240,167,2,98,8,60,3,37,252,169,251,218,12,145,243,94,255,89,6,100,13,2,15,247,246,128,12,220,253,183,241,81,13,8,249,45,253,53,9,237,246,224,241,196,10,11,250,38,11,100,247,160,252,20,242,225,4,3,2,94,9,137,243,62,14,39,15,157,252,162,11,89,247,241,252,172,254,233,3,193,250,77,246,90,13,172,8,129,250,54,15,89,242,130,251,198,13,47,247,234,248,254,7,31,245,221,248,58,255,229,13,152,246,200,3,206,250,194,6,58,251,94,253,134,254,53,9,188,245,15,7,95,13,20,245,207,13,179,2,52,252,194,10,178,7,202,0,242,243,2,9,236,255,88,7,185,249,19,252,160,4,219,12,217,240,117,255,70,249,2,255,152,245,233,7,149,7,116,255,34,10,11,251,74,246,144,8,41,10,207,247,187,245,70,252,38,246,109,2,38,9,76,7,65,2,40,252,109,8,219,240,17,9,203,2,2,248,224,253,243,255,220,244,118,6,62,12,7,249,114,7,163,244,53,241,213,243,53,244,166,252,41,247,64,12,233,244,106,250,35,10,20,254,249,10,69,243,217,253,168,13,59,251,203,242,246,13,206,244,73,246,173,241,39,248,114,254,98,251,116,246,137,0,228,248,39,15,214,248,210,244,241,3,62,253,159,246,231,247,93,4,174,2,41,1,195,2,125,0,131,3,74,13,89,0,114,246,238,241,227,255,253,5,150,9,113,245,7,249,197,9,49,252,215,254,233,243,239,255,20,248,235,242,83,7,164,9,179,253,206,9,187,249,251,4,41,5,140,3,168,252,7,242,75,241,238,244,79,249,46,255,244,8,87,8,235,11,118,252,156,244,105,242,161,12,220,1,108,249,138,252,84,252,96,8,116,247,164,248,70,254,102,10,188,11,43,4,214,246,223,240,65,253,48,244,154,8,130,1,182,242,217,247,167,10,253,243,82,12,44,14,69,5,62,245,194,241,157,9,125,241,153,5,3,254,174,13,3,8,87,252,57,243,255,3,152,249,63,0,229,247,239,251,176,4,128,6,159,249,52,243,249,9,217,7,12,10,58,254,0,15,89,252,190,7,244,247,223,254,209,7,84,4,169,14,253,249,210,5,118,245,227,4,70,5,61,15,71,246,27,244,219,3,218,1,152,252,123,11,71,249,10,244,144,245,161,7,236,245,170,0,108,10,54,242,130,11,105,244,92,243,11,244,49,3,26,7,236,244,27,12,45,2,227,243,122,13,37,3,99,253,153,241,82,254,99,13,223,10,71,8,42,249,10,255,160,4,17,247,175,9,49,9,128,251,2,254,246,12,72,249,94,15,158,7,199,246,158,243,190,251,170,14,220,14,230,2,83,249,146,252,28,242,46,253,88,10,86,1,41,252,110,12,111,255,229,246,217,9,199,250,111,255,15,255,70,254,8,245,52,6,131,248,109,13,193,0,9,248,87,3,59,255,189,13,187,246,79,1,1,11,253,6,183,5,185,4,127,5,37,250,101,1,253,240,213,244,38,15,23,242,67,7,22,13,77,3,167,12,38,244,229,243,82,12,209,3,86,252,1,253,16,242,151,252,240,8,76,253,196,254,96,248,19,4,247,247,216,9,63,3,200,247,56,249,154,2,140,4,91,242,233,240,24,11,143,9,123,242,232,251,248,244,91,15,62,11,246,244,254,251,136,255,112,255,55,11,15,14,184,0,246,12,114,254,196,254,87,9,81,7,51,13,147,7,231,249,13,3,27,9,186,247,159,252,111,12,3,255,241,1,123,246,226,14,217,0,245,253,61,253,162,251,240,244,97,2,82,247,237,251,245,12,227,10,21,243,110,246,50,248,54,6,47,6,149,7,204,2,178,12,104,255,219,248,134,11,15,252,8,247,228,10,25,11,112,245,167,245,24,248,34,14,46,250,219,14,174,1,151,9,1,242,20,7,205,240,104,248,24,5,160,1,55,3,77,7,3,0,201,3,192,255,104,248,11,13,138,0,25,254,169,5,123,13,213,6,127,252,5,254,231,13,66,6,30,241,112,249,99,1,114,9,11,1,105,12,34,3,134,255,199,9,191,245,114,12,2,7,192,251,51,249,201,247,164,0,204,251},
} ;

static const unsigned char precomputed_core_multsntrup1277_n[precomputed_core_multsntrup1277_NUM][crypto_core_INPUTBYTES] = {
  {37,61,180,212,67,200,103,2,65,64,127,104,35,107,140,158,75,150,162,228,205,131,94,17,98,126,104,229,131,95,252,104,22,43,144,152,234,142,187,168,156,179,187,192,169,45,163,167,108,22,50,19,35,85,191,6,191,54,121,142,241,106,122,7,183,160,189,109,243,132,2,246,127,52,97,49,38,69,86,17,241,34,142,206,11,65,175,150,33,62,239,127,149,136,16,19,18,181,47,243,8,83,118,41,176,140,65,110,58,170,149,163,5,114,3,4,41,171,155,189,182,240,48,119,58,104,91,49,53,252,201,176,207,2,212,15,224,250,241,149,147,95,168,131,137,212,242,65,177,21,94,139,137,12,107,102,32,99,71,142,215,150,248,178,12,247,115,148,104,200,21,242,201,114,172,148,238,17,51,127,228,19,168,141,81,45,53,235,71,19,38,139,90,168,161,21,87,116,184,62,176,46,56,135,120,68,85,93,181,168,77,65,136,43,176,168,199,113,246,248,84,164,2,232,95,230,89,227,31,137,52,176,67,216,182,205,249,92,127,14,72,192,236,109,112,12,241,246,152,68,83,98,178,117,63,33,88,12,175,185,189,68,192,93,17,169,26,223,83,21,121,145,242,140,216,72,210,161,105,152,159,78,143,64,92,18,106,55,204,89,66,169,239,179,222,65,25,162,225,155,235,93,25,6,148,200,38,212,95,239,3,8,56,128,137,156,24,125,20,218,102,67,215,174,246,122,31,222,181,123,17,38,90,68,55,223,125,220,111,26,198,251,68,13,46,161,228,186,113,238,2,201,28,248,92,194,107,75,46,6,86,188,192,246,116,18,27,191,239,162,21,143,155,168,252,80,115,70,138,137,22,129,190,134,248,161,165,233,238,141,102,59,205,249,115,248,25,213,36,201,47,83,163,154,128,128,170,239,220,110,50,107,196,71,136,133,96,25,33,80,72,16,200,228,36,87,240,185,189,8,144,29,188,140,43,8,86,212,91,180,147,149,79,197,207,46,13,232,236,134,138,156,60,8,85,171,136,248,202,175,135,82,254,225,29,177,185,17,203,237,212,194,180,105,96,68,253,47,189,76,115,235,81,144,178,254,106,173,108,156,104,181,223,138,55,79,86,97,238,234,192,156,254,5,161,96,220,209,79,36,169,104,103,249,67,96,76,86,178,147,68,89,60,58,45,87,10,4,45,182,152,247,184,39,70,227,140,87,99,171,162,33,24,211,207,188,95,151,23,6,238,43,24,149,244,12,148,145,208,90,45,44,253,29,48,230,10,118,74,229,198,113,70,200,224,123,116,138,54,91,181,220,180,165,86,131,255,243,157,124,84,82,150,247,81,249,0,88,130,71,152,219,113,57,12,57,46,2,210,197,4,119,209,125,172,250,210,21,5,105,245,17,113,39,88,238,196,169,109,234,60,180,253,87,121,129,91,210,176,83,223,120,92,217,119,49,220,210,110,59,124,181,234,244,84,102,80,19,213,135,11,6,129,217,153,77,154,136,66,101,117,215,166,133,239,48,29,89,61,141,221,212,237,148,113,206,169,9,13,169,126,88,170,230,195,170,150,68,242,45,189,18,253,49,169,123,186,3,194,116,200,81,53,225,216,41,113,244,213,8,241,95,231,252,204,107,96,146,225,200,10,108,160,138,154,97,110,9,131,127,231,81,43,183,33,29,104,132,59,15,190,60,208,206,38,104,58,50,213,196,20,223,105,190,172,85,178,51,216,109,219,150,107,141,30,35,203,159,76,68,94,165,82,26,252,17,32,219,169,40,87,145,199,103,100,149,209,118,15,148,236,196,72,242,49,225,150,73,10,226,202,114,79,192,249,0,140,223,255,51,219,113,91,89,112,13,252,27,201,66,227,195,60,85,44,134,116,177,218,104,204,184,177,26,153,122,229,183,166,23,138,166,223,132,80,165,250,99,174,184,122,46,201,174,2,247,182,201,39,181,223,3,255,37,86,221,150,102,150,6,162,1,54,222,227,252,242,205,222,224,36,141,36,35,216,243,123,103,157,208,208,200,139,89,175,180,229,37,193,211,13,87,254,18,177,204,86,0,118,228,107,4,3,139,151,85,78,203,245,47,159,28,69,74,158,239,129,178,232,45,118,0,86,63,205,23,196,220,109,148,147,108,173,139,73,26,52,12,60,161,229,135,77,198,193,193,174,172,253,222,247,109,138,200,102,57,245,111,64,192,70,196,104,104,139,116,172,152,158,231,2,154,42,44,112,226,125,108,152,100,188,32,33,156,21,71,195,141,146,142,88,154,170,106,99,189,77,111,47,66,153,220,122,174,26,20,118,206,68,235,218,247,182,55,230,174,153,205,223,211,15,22,252,94,46,16,166,68,137,68,241,169,10,11,180,165,219,112,215,83,20,140,239,132,122,194,187,165,227,74,135,220,205,120,238,239,210,182,232,66,88,180,191,123,142,136,146,114,183,140,23,77,222,247,23,192,168,145,237,65,78,245,248,52,2,208,169,234,35,233,26,192,46,3,201,68,242,55,121,195,150,210,51,242,250,110,3,121,172,204,63,145,148,110,126,115,218,205,147,202,190,235,47,248,120,98,55,25,55,24,223,158,107,79,110,20,81,36,241,65,100,39,145,237,121,34,12,9,87,147,7,43,214,74,237,169,124,82,16,136,42,226,138,181,107,112,243,100,213,74,13,172,86,103,24,149,18,12,182,180,209,21,202,191,175,96,117,160,117,178,6,95,30,5,148,74,244,2,202,238,210,53,228,76,75,139,192,80,222,36,116,81,89,132,66,140,98,199,218,202,20,60,58,216,249,130,11,70,91,241,137,27,171,103,29,149,250,252,82,28,128,255,30,31,156,249,68,103,233,46,155,130,75,205,90,101,112,20,158,76,104,33,88,206,165,125,230,227,30,187,44,103,162,239,104,12,181,91,187,248,51,127,196,86,137,203,109,68,113,228,212,50,222,147,108,237,95,111,226,42,227,101,169,182,163,197,153,53,150,211,54,68,160,33,135,36,7,202,236,213,73,51,90,137,20,189,144,178,244,99,167,26,197,35,160,21,23,216,246,67,135,97,202,90,157,119,47,195,96,85,236,103,88,163,167,74,96,127,23,193,118,201,196,21,149,42,210,181,2,87,16,122,137,2,82,63,222,17,125,150,62,216,139,138,41,108,148,230,174,210,10,137,142,27,99,188,128,5,141,123,68,245,87,225,251,21,198,163,159,220,6,99,246,105,247,151,200,84,82,15,143,203,89,38,153,79,67,84,131,189,192,81,182,68,162,48,114,230,135,240,64,91,100,102,130,222,214,27,250,18,205,125,249,219,252,45,49,159,234,60,82,39,72,96,188,223,13,202,160,28,204,196,57,240,149,160,153,180,55,183,247,197,230,254,135,157,46,5,248,185,33,36,92,100,163,176,243,97,117,169,41,16,15,214,226,54,129,22,40,35,91,226,104,174,81,51,120,104,118,225,79,145,208,237,72,210,221,159,231,9,29,213,97,244,115,33,195,216,201,135,23,66,249,85,61,31,35,248,47,57,150,168,93,197,233,119,239,12,184,63,186,97,224,198,125,224,178,69,99,122,253,0,55,179,181,141,132,18,226,39,164,197,243,98,207,63,47,103,220,206,183,83,109,4,254,48,123,236,185,67,102,249,136,170,198,239,95,145,106,185,113,26,153,78,97,183,11,41,246,118,93,124,240,243,204,170,18,126,176,21,37,200,81,248,197,240,240,99,129,200,200,83,95,110,94,37,238,16,170,160,123,196,124,180,254,30,45,152,34,197,41,102,29,244,225,22,160,221,1,240,102,65,198,30,159,145,154,27,122,58,42,95,161,139,7,212,238,0,179,179,251,129,172,248,67,34,178,204,115,6,203,15,238,233,28,75,102,153,231,75,175,68,89,154,60,178,20,175,48,118,232,149,214,98,188,113,103,193,200,187,233,232,247,18,210,52,47,137,229,195,91,226,90,193,179,200,229,242,234,159,33,14,183,138,7,130,95,210,10,164,113,76,250,150,231,138,57,85,17,213,92,18,104,140,241,232,150,172,49,80,49,10,113,203,61,108,36,108,143,149,54,124,83,159,123,247,160,158,251,75,243,36,156,86,104,35,151,236,18,110,92,221,64,3,164,99,14,56,115,106,29,18,136,45,47,80,4,152,130,5,207,108,149,166,27,221,38,3,250,182,0,224,88,36,190,241,115,228,190,24,104,120,2,55,82,239,72,27,83,130,217,179,9,35,75,61,68,74,85,229,85,138,164,57,21,173,229,37,201,26,207,177,122,197,47,135,64,100,236,130,175,29,78,14,170,48,200,151,205,90,91,187,166,111,59,142,3,61,9,250,47,115,240,58,134,207,167,25,209,222,86,252,137,172,189,110,17,143,178,86,72,28,15,225,55,43,52,144,132,202,182,54,199,12,220,156,249,2,107,86,150,17,222,76,153,71,51,203,148,64,158,251,201,254,97,76,236,45,158,153,149,77,18,157,90,224,83,209,79,193,118,165,100,54,231,143,201,124,246,203,92,213,199,59,166,206,89,60,121,188,106,162,170,145,144,74,67,245,91,155,80,186,165,41,206,31,79,75,188,11,76,127,37,168,145,104,111,1,87,93,163,236,157,10,132,187,253,47,118,102,172,151,214,139,222,60,91,139,29,13,22,103,71,159,179,7,154,129,167,101,30,116,124,30,52,108,83,144,249,239,109,57,142,213,13,178,179,224,18,59,116,252,221,192,186,123,254,27,15,122,254,195,201,255,52,76,162,129,252,155,232,124,228,105,159,243,129,132,84,34,180,63,254,149,30,86,188,175,244,187,147,81,35,189,76,60,64,122,147,185,252,68,193,114,191,85,114,105,95,104,87,167,253,176,49,32,209,184,23,223,235,72,89,206,202,226,103,190,103,0,37,238,197,106,151,124,33,121,170,118,61,247,93,185,190,115,144,178,229,78,152,124,1,108,247,227,17,163,88,60,134,111,163,81,74,86,212,202,126,250,186,141,50,64,82,60,205,180,238,87,191,222,182,123,214,84,120,232,165,244,46,10,244,137,127,66,71,10,219,18,129,76,97,14,116,246,13,14,111,182,17,223,71,204,158,62,69,160,188,175,160,91,87,162,39,212,233,138,127,241,110,146,199,141,224,132,185,80,178,220,211,141,173,75,38,195,69,140,130,54,126,35,255,251,216,224,73,60,135,166,43,192,93,0,8,64,54,219,116,237,231,195,248,199,212,223,242,97,101,174,250,188,55,162,211,237,178,130,152,64,34,31,127,73,126,28,162,2,65,82,216,223,161,189,89,86,220,31,45,224,249,218,21,88,15,199,248,25,80,90,166,160,104,192,88,12,101,240,237,124,65,255,250,152,22,61,14,105,122,61,64,128,141,40,158,134,98,78,203,91,111,53,40,179,147,153,117,251,80,121,236,69,23,89,23,16,58,44,144,23,182,195,33,188,217,40,137,220,107,17,116,167,145,206,35,29,251,132,38,112,106,123,141,21,79,48,255,50,65,242,172,27,143,138,93,213,59,238,243,171,208,103,48,110,14,54,161,192,236,134,43,121,89,21,168,244,239,206,220,187,212,56,23,142,152,8,174,241,162,58,115,80,55,91,253,142,166,253,171,206,66,19,84,193,231,239,8,19,138,3,184,45,237,119,122,162,170,128,79,132,50,85,80,116,243,138,193,20,64,2,17,218,6,207,35,65,222,132,122,130,72,15,148,180,86,237,96,37,173,172,67,44,165,247},
  {187,23,17,92,213,173,37,184,147,89,90,126,142,58,90,249,108,205,12,48,89,132,139,189,181,169,119,73,191,238,88,209,65,179,224,196,143,250,193,49,240,71,62,25,21,118,43,14,164,129,94,108,86,138,46,22,202,152,221,198,32,158,159,211,123,145,31,130,98,246,19,207,126,237,52,163,127,24,56,227,152,238,230,66,226,12,233,124,197,119,240,165,226,110,190,51,59,238,2,19,189,244,43,157,34,145,180,89,146,123,73,49,9,101,129,251,123,70,180,204,60,8,108,165,136,45,150,128,93,33,245,109,219,211,22,188,191,16,106,190,112,48,161,91,123,112,166,70,35,90,113,201,150,156,111,21,242,185,142,90,185,56,138,125,233,244,46,170,164,138,197,120,123,18,25,118,31,230,113,70,235,181,209,130,249,132,105,54,118,128,113,12,157,217,26,13,164,50,57,212,86,76,216,213,159,180,189,116,159,147,190,247,51,85,88,123,7,185,6,31,214,68,128,228,149,137,89,10,41,240,153,157,4,143,106,249,119,112,55,64,40,237,184,143,238,150,181,49,239,40,204,122,217,185,154,49,69,152,92,149,17,90,209,31,43,169,169,6,32,40,195,33,147,55,225,246,250,100,81,82,184,255,30,253,32,58,83,87,1,18,22,236,205,49,207,133,161,172,232,103,56,109,118,158,77,130,245,74,204,248,86,180,65,194,109,67,252,252,251,81,240,82,252,31,154,22,57,219,90,255,187,254,193,153,203,102,116,18,209,176,74,36,185,32,51,30,96,147,133,110,94,67,123,203,110,5,121,121,80,29,89,208,200,63,187,247,118,249,129,64,121,92,154,7,96,204,124,126,33,124,238,125,124,24,93,68,19,232,251,5,202,55,130,68,65,95,215,32,16,7,61,62,127,3,65,44,101,160,221,116,237,23,140,70,16,140,145,199,122,16,145,104,220,133,139,55,14,192,224,242,93,247,126,142,150,106,29,93,232,254,113,238,42,175,196,31,235,30,162,247,33,135,253,109,252,176,43,9,114,55,77,225,68,148,161,223,255,100,94,48,83,244,222,168,38,148,206,187,102,43,88,9,20,248,186,204,19,130,21,126,167,140,19,72,237,15,210,8,223,186,190,242,202,48,139,204,39,166,50,188,238,145,23,252,186,196,162,199,157,254,141,60,32,61,80,159,215,25,14,12,4,16,103,101,65,252,220,212,39,130,84,157,178,203,126,181,194,83,229,250,181,63,125,185,71,58,228,185,118,97,190,214,82,203,172,128,87,162,165,87,126,145,60,10,241,4,19,207,217,83,169,44,52,134,29,231,240,99,177,249,255,106,150,113,254,252,169,91,66,153,124,133,224,100,155,38,148,248,189,86,191,250,19,205,187,126,181,210,122,26,147,95,12,86,213,129,68,95,232,105,92,36,100,160,99,188,125,225,213,137,253,227,226,169,141,102,8,119,219,222,176,130,91,198,35,54,204,228,34,214,147,251,152,34,250,121,110,111,62,64,144,234,86,163,251,143,123,90,68,72,135,255,234,147,92,152,199,79,137,88,136,172,118,39,222,91,109,129,119,204,239,69,59,36,216,21,103,24,138,5,73,8,189,200,87,107,178,148,214,223,83,28,44,45,67,107,100,218,133,48,56,108,158,188,192,187,243,233,30,240,239,188,42,10,48,168,228,106,236,37,64,103,244,22,173,8,83,188,195,116,119,119,209,139,84,41,128,43,221,37,202,216,190,86,68,92,217,125,242,239,231,148,152,109,125,98,32,143,120,140,93,225,195,214,99,224,35,1,164,76,33,173,162,19,140,194,81,38,36,235,58,109,158,126,255,90,49,248,150,101,47,146,239,240,236,143,79,229,94,247,232,138,41,150,136,26,103,156,230,104,40,86,149,117,5,25,43,232,120,186,59,204,18,142,91,85,235,93,232,160,15,45,44,186,114,246,185,176,145,180,146,88,172,20,36,77,207,131,106,77,23,51,104,74,31,100,100,116,32,23,222,47,66,249,32,30,17,219,147,4,189,157,23,101,16,212,243,83,253,183,94,114,188,148,254,97,13,80,224,178,119,218,183,169,254,44,98,224,199,134,103,26,4,227,10,191,67,82,157,10,18,196,237,42,224,58,235,95,167,185,152,162,189,2,80,235,121,66,234,31,173,67,142,58,88,132,31,14,224,109,39,26,36,62,230,150,2,109,188,53,83,5,162,129,66,238,200,81,82,59,185,190,171,102,45,141,52,78,66,50,50,35,71,203,115,129,185,229,140,146,96,164,210,248,238,84,148,215,15,115,114,14,56,34,212,28,74,118,113,198,118,92,234,134,163,115,190,83,142,71,124,7,60,196,59,204,2,82,233,100,232,62,101,169,110,192,110,79,26,80,60,67,99,208,24,135,135,157,131,7,243,167,147,64,211,197,156,202,203,64,254,49,145,138,46,111,248,202,26,76,234,11,52,12,103,178,64,140,240,135,3,178,134,196,240,97,15,250,31,176,141,188,133,186,198,48,13,74,174,204,237,51,157,64,189,75,155,215,164,82,212,253,166,155,205,132,243,74,23,15,60,252,149,61,110,157,201,10,158,20,162,198,179,135,5,15,188,253,45,77,115,88,234,233,146,223,146,49,203,88,30,140,27,38,21,97,217,169,123,159,10,85,57,80,208,108,11,225,106,15,159,192,174,22,34,167,63,192,235,133,240,69,226,105,228,241,66,123,145,143,119,90,191,9,206,125,162,246,112,77,85,17,139,147,116,70,131,25,218,101,241,98,148,152,57,184,43,71,126,91,232,30,19,227,62,184,144,102,247,203,85,187,58,194,206,13,198,138,151,93,99,64,149,114,113,219,102,11,190,186,229,159,84,136,139,206,228,236,147,58,173,228,202,199,233,180,82,233,244,26,94,217,167,245,24,21,140,151,12,33,149,41,132,230,133,79,217,173,117,38,134,88,64,58,165,215,57,171,86,91,142,188,96,43,93,136,234,197,13,25,163,119,56,191,150,199,73,95,213,16,241,188,211,100,155,242,227,5,83,19,77,18,19,164,6,192,51,91,128,152,167,35,113,76,240,2,195,151,211,65,115,59,149,183,169,102,197,62,112,110,238,187,100,1,124,197,187,119,47,123,234,187,93,53,57,46,83,140,194,231,55,121,206,125,171,79,158,232,114,177,246,249,6,103,224,173,46,226,255,159,30,16,99,185,67,50,181,127,138,30,14,61,135,187,242,113,139,132,43,69,180,198,16,172,102,164,214,118,92,247,232,208,194,193,126,138,68,135,197,141,118,93,254,32,8,237,42,44,234,144,139,72,117,220,64,197,233,74,170,168,85,179,160,250,160,130,80,83,131,51,126,107,164,246,221,85,182,184,151,224,243,34,217,148,245,38,255,127,232,10,45,154,103,167,84,88,39,60,120,116,230,207,252,152,227,253,164,245,110,228,53,158,110,250,3,40,212,207,38,30,124,174,172,20,93,201,16,197,8,103,52,49,229,88,165,130,92,180,242,229,103,5,161,74,228,218,215,144,0,251,188,45,84,198,65,170,249,207,6,169,222,50,67,5,226,112,183,63,72,135,136,56,202,36,235,120,164,96,157,195,219,229,25,212,176,115,66,128,43,221,92,64,170,15,140,148,75,154,142,229,144,106,104,183,123,9,29,191,68,121,122,114,235,177,161,193,34,165,154,48,35,231,186,135,240,200,207,76,1,0,117,210,59,165,142,1,92,240,201,158,190,226,186,50,118,52,57,24,164,17,120,254,185,239,247,104,55,221,72,238,168,41,37,27,102,209,107,69,119,172,145,209,75,1,232,113,223,92,203,198,25,128,231,112,233,8,183,70,167,101,132,145,250,152,140,151,199,25,69,248,174,45,73,221,240,71,224,19,112,69,113,250,239,11,84,103,81,154,147,160,189,213,233,90,100,126,56,143,9,117,118,222,118,68,83,120,4,175,151,108,229,104,185,174,178,70,104,189,165,195,123,82,239,245,134,113,250,198,54,83,204,132,202,70,167,77,168,163,95,152,94,72,140,252,217,244,225,246,172,212,20,100,240,7,226,177,45,152,26,3,234,225,215,172,206,100,217,56,39,168,6,97,82,200,36,231,145,210,78,3,30,117,45,237,173,78,138,243,63,145,162,105,81,43,75,165,36,68,125,54,60,118,228,126,109,16,246,246,158,162,73,112,15,109,30,126,199,174,92,210,46,42,187,168,244,224,238,238,208,151,44,61,253,106,22,214,110,32,96,179,236,205,78,35,193,230,239,253,41,31,148,193,87,136,223,169,104,95,164,130,110,45,161,252,85,90,175,222,167,25,119,99,92,47,44,5,109,238,91,113,49,169,84,45,194,67,215,221,84,128,48,11,118,150,149,102,240,40,241,254,126,94,251,57,237,59,106,46,18,216,213,1,131,127,150,69,163,65,185,43,104,133,149,15,74,252,218,194,178,135,221,161,211,234,185,197,65,11,203,85,1,171,198,25,135,14,205,113,97,90,222,254,100,194,236,230,208,76,128,217,157,105,216,5,219,220,245,24,139,53,126,221,80,136,73,165,47,7,58,198,246,110,248,37,249,134,7,239,189,244,170,77,52,130,250,28,43,193,98,56,75,239,214,144,95,178,37,191,141,192,2,156,66,129,90,240,229,138,134,77,193,203,75,137,169,142,150,233,50,55,162,155,91,44,140,124,18,91,170,99,233,218,26,177,1,146,171,228,28,131,210,51,231,63,82,238,214,7,255,74,27,74,187,126,175,88,34,150,51,52,17,32,178,158,9,170,163,224,114,195,188,216,106,23,212,144,17,37,180,42,138,91,62,14,217,219,8,114,183,223,147,70,225,13,255,74,212,169,246,181,171,129,60,1,70,38,33,107,126,122,25,171,6,106,181,124,190,151,191,24,20,213,23,108,30,112,14,196,61,51,177,168,173,146,97,11,82,245,127,168,91,74,97,183,54,251,102,219,110,33,60,92,200,77,49,216,115,149,195,159,96,37,237,106,172,180,192,120,53,169,116,171,164,92,238,75,245,231,99,64,187,213,219,127,207,44,152,247,133,142,226,48,71,94,50,136,169,70,206,220,75,123,222,102,198,81,46,37,132,166,50,193,2,200,79,71,178,28,115,9,208,216,123,243,213,119,29,42,80,172,56,87,253,231,73,4,27,248,97,229,186,83,190,170,76,211,210,159,240,247,32,130,225,36,21,191,87,44,86,243,74,203,187,183,205,157,18,158,255,73,205,6,126,89,14,203,253,51,233,35,43,69,66,69,253,183,115,204,246,140,57,11,192,82,143,179,50,63,162,242,156,28,142,104,99,41,155,204,6,241,178,211,78,151,128,22,176,219,75,182,41,234,97,155,193,22,121,185,150,112,146,241,3,85,66,134,6,170,3,29,108,218,83,55,39,111,215,209,51,89,200,124,191,40,180,69,42,227,227,182,100,229,45,59,61,216,104,209,109,221,230,104,129,88,10,109,87,223,209,111,64,100,35,101,14,170,202,140,239,10,43,233,223,188,255,250,73,15,114,214,97,181,195,233,5,241,190,122,135,15,61,18,147,254,61,33,219,56,219,113,199,252,23,116,171,247,235,146,42,96,227,203,41,117,185,144,165,99,178,28,171,13,224,157,46,134,135,128,97,163,207,249,150,106,8,248,32,165,176,15,153,78,24,212,254,212,187,147,8,88,23,101,182,17,6,190,185,220,193,236,230,119,123,153,121,189,104,139,111,65,181,236,123,20},
  {176,4,63,113,14,156,172,11,87,39,58,145,58,142,177,182,71,80,189,171,116,184,138,157,140,169,76,82,212,34,116,239,194,241,143,181,62,56,166,232,7,82,189,82,115,66,8,2,194,225,224,45,247,34,250,217,58,67,182,187,14,5,139,79,33,5,181,183,223,148,119,80,26,173,155,44,50,137,229,171,144,177,195,30,49,96,72,132,205,224,119,131,175,24,197,237,4,102,6,1,98,193,201,240,60,146,225,183,235,118,55,112,51,113,137,81,229,184,133,38,50,174,65,170,55,198,91,158,178,251,14,196,89,177,194,38,225,212,154,5,242,136,17,99,116,187,198,20,192,201,221,188,158,255,127,177,37,8,238,222,84,87,103,45,229,42,247,10,249,8,179,218,229,159,8,1,88,129,88,201,42,67,115,243,151,237,50,36,165,206,249,35,98,131,101,65,217,61,34,194,139,127,239,119,178,166,226,28,188,230,221,149,238,122,107,42,144,177,109,166,126,136,252,106,22,2,195,250,223,18,224,91,36,110,201,194,175,140,162,144,9,29,104,245,195,227,185,254,106,42,218,242,2,146,9,175,30,140,143,32,116,114,86,99,75,61,10,213,81,159,237,66,172,246,48,92,217,78,96,176,16,121,10,162,61,245,183,198,82,129,166,50,25,7,35,6,16,232,16,239,89,114,239,114,69,222,247,155,116,52,203,71,184,148,161,136,14,20,190,211,126,130,61,153,251,213,19,183,11,140,221,25,47,149,10,189,49,131,75,39,109,231,164,245,199,15,48,100,194,126,69,26,235,107,235,248,125,157,75,215,162,182,157,181,219,193,191,154,254,96,89,115,20,93,168,128,216,124,156,198,143,11,199,235,4,24,105,135,143,60,225,211,255,49,199,11,64,122,167,125,3,80,77,65,149,53,158,177,196,193,28,71,155,185,83,51,120,138,22,132,99,213,250,2,169,190,21,69,178,218,226,246,188,197,212,130,48,179,93,47,15,68,113,81,216,223,219,10,196,20,163,131,5,21,57,105,42,145,16,253,207,184,90,122,115,148,15,44,167,78,237,51,218,100,67,122,54,205,141,156,179,103,206,197,231,47,236,90,234,170,156,3,68,88,168,240,88,44,209,20,113,12,185,189,41,31,27,237,64,124,28,210,6,121,143,73,148,41,211,174,230,34,203,27,94,76,106,104,123,239,146,49,191,17,218,32,23,21,228,45,2,169,224,180,52,251,144,208,153,154,93,98,158,221,137,42,180,235,218,203,71,70,25,183,7,58,169,200,43,225,132,192,23,53,74,139,230,233,12,111,130,12,151,242,89,105,172,47,40,203,91,25,230,118,8,204,116,228,218,55,215,78,227,163,236,126,92,32,212,105,178,103,233,59,130,143,4,230,153,65,51,48,212,219,173,122,241,35,238,32,55,59,131,32,181,92,10,90,130,12,255,169,88,147,33,37,173,170,93,236,238,14,244,163,211,64,12,244,93,9,59,11,29,93,113,79,101,78,244,235,236,28,231,7,44,37,119,1,191,75,23,72,46,229,18,127,174,154,201,249,49,208,69,198,132,249,191,37,218,106,28,251,214,156,2,141,153,140,237,107,126,87,131,244,113,186,163,83,43,202,197,32,122,107,95,30,9,244,171,113,86,119,166,154,75,229,14,46,123,175,208,213,166,33,108,8,10,108,17,221,70,104,75,254,191,250,116,165,96,147,196,82,197,171,156,198,48,180,72,228,4,180,70,152,105,150,153,223,221,3,254,207,144,35,243,245,52,79,100,182,182,138,46,192,32,33,25,147,50,9,254,34,65,75,227,70,208,19,53,144,99,232,175,74,234,49,37,134,232,43,239,45,160,175,29,95,235,97,202,81,22,134,162,134,244,222,138,120,167,194,175,128,57,152,152,142,37,100,57,28,102,200,138,83,46,49,2,161,54,67,107,145,135,223,82,101,168,39,110,14,50,0,66,238,253,147,74,102,31,216,182,75,48,148,94,223,97,95,21,190,45,234,52,168,189,67,130,64,158,42,170,250,116,33,154,48,214,222,60,66,86,47,143,35,42,248,13,119,156,177,230,127,13,40,191,85,158,128,62,49,153,130,73,29,128,30,64,106,227,62,253,13,172,184,21,52,56,18,55,241,64,196,249,248,246,180,181,3,224,114,234,213,65,254,69,108,4,69,162,201,197,20,172,136,86,10,219,99,18,216,186,28,188,30,97,23,128,168,193,181,238,209,164,5,195,55,221,199,74,173,124,75,230,13,146,84,38,103,101,95,89,145,20,132,233,58,236,30,81,30,48,75,86,63,200,111,69,26,220,33,73,105,164,182,180,28,194,234,228,131,41,104,26,67,205,96,99,225,253,91,196,225,253,44,98,110,252,159,107,180,202,45,156,152,108,72,183,127,129,107,54,217,94,113,103,26,74,249,69,243,77,51,39,182,175,124,26,43,182,146,60,17,183,60,82,100,25,107,40,93,53,245,85,6,9,246,126,161,106,223,68,12,202,88,208,90,0,106,53,80,134,198,199,83,209,22,206,168,204,219,99,243,187,245,79,81,92,246,34,146,18,252,144,196,149,77,131,175,40,113,179,188,216,6,128,38,216,176,214,91,173,100,160,109,73,22,18,26,12,61,247,216,117,26,217,148,175,194,70,103,44,227,159,84,118,211,214,236,202,242,155,59,222,214,250,205,59,198,151,81,74,174,40,5,26,85,15,37,209,218,2,95,3,1,151,106,55,237,224,3,216,241,95,46,24,5,72,105,104,175,198,227,169,196,166,147,196,1,146,154,129,53,109,243,189,124,248,142,16,197,226,200,113,247,184,224,170,185,241,34,149,199,100,138,128,90,151,44,67,66,3,168,154,171,214,43,60,139,106,54,135,87,34,121,2,177,35,110,20,18,163,91,46,208,120,138,183,79,108,160,237,170,241,213,236,102,133,129,240,55,21,255,141,83,235,85,227,151,78,134,10,205,95,167,164,22,35,214,211,133,196,106,118,158,167,206,72,123,22,205,226,120,64,2,188,121,113,8,185,15,160,12,101,80,210,90,205,239,149,23,180,113,171,212,137,210,211,246,87,227,221,62,116,212,105,188,90,27,34,196,194,67,214,187,172,178,212,136,164,128,36,15,33,120,14,76,254,76,250,110,185,37,44,11,203,108,242,156,132,105,251,17,72,211,236,241,162,66,201,252,172,23,92,26,5,220,89,160,142,7,81,121,188,35,19,17,248,209,75,130,231,114,164,64,108,154,212,171,69,70,76,1,241,235,234,166,6,68,207,56,211,73,4,140,135,176,75,110,140,132,77,221,238,68,98,81,125,21,76,75,9,207,154,112,30,119,91,77,125,214,72,50,119,67,167,8,128,166,217,236,190,33,235,152,107,205,162,138,40,28,7,53,63,232,29,209,77,215,97,228,132,119,68,129,117,112,247,218,26,21,204,226,237,171,50,91,60,222,119,235,174,172,220,96,175,10,228,122,204,202,175,19,64,41,157,55,132,115,34,133,57,84,10,123,229,102,227,78,157,13,234,211,119,114,194,107,79,248,86,224,32,233,102,153,224,161,76,205,235,234,183,9,88,158,192,229,246,115,235,142,248,162,103,238,10,162,88,220,71,185,193,138,1,37,154,174,149,247,192,54,100,177,27,44,33,72,123,120,75,111,202,137,222,250,12,254,233,156,241,66,160,255,130,75,145,87,207,105,151,133,34,199,241,157,176,82,204,155,80,184,178,81,92,78,121,245,90,193,10,152,199,163,63,10,233,234,119,22,159,64,124,82,221,154,46,235,186,192,182,219,58,117,135,23,187,55,57,227,208,218,123,240,190,80,59,221,203,203,18,135,87,3,129,3,37,207,112,3,198,17,44,104,254,200,7,67,233,208,166,74,85,213,182,76,228,1,168,52,151,93,153,169,69,89,63,144,248,132,176,59,243,90,135,66,8,217,115,13,83,227,27,37,79,148,165,227,176,167,111,200,68,64,133,234,216,1,188,244,30,219,248,236,227,245,126,122,42,3,70,75,113,89,133,241,27,82,222,199,224,76,170,87,140,93,215,198,74,88,134,76,177,29,206,116,119,93,7,204,61,218,114,89,12,43,14,251,196,130,223,196,242,234,100,12,132,160,141,139,179,115,148,84,40,29,201,114,138,58,225,76,167,106,113,141,119,75,103,151,253,199,146,182,159,160,16,241,229,232,147,53,157,243,106,69,213,166,26,241,98,112,77,194,48,241,75,57,232,15,20,201,179,22,184,86,107,247,163,42,79,248,215,255,60,40,27,118,158,19,217,203,122,96,131,5,111,103,243,242,205,255,46,221,179,192,114,65,53,123,83,177,148,196,215,150,238,239,147,50,250,234,43,144,236,47,204,188,8,247,247,61,154,122,180,176,89,239,28,63,80,179,13,187,233,66,121,182,179,81,150,34,142,110,134,131,51,40,73,48,176,156,239,73,165,164,248,123,204,223,129,36,49,242,237,189,236,130,1,4,190,2,252,14,10,89,54,160,221,249,250,242,117,248,70,5,55,104,13,70,211,230,65,251,250,42,212,195,84,200,38,113,55,100,222,55,103,165,183,229,208,190,160,131,222,134,145,248,125,133,43,157,233,59,243,51,92,97,67,52,34,142,114,211,172,205,82,155,236,67,141,64,94,9,107,127,42,72,57,38,143,238,182,245,185,134,136,102,0,240,71,58,7,31,4,78,224,13,74,15,213,20,77,57,149,226,50,234,238,0,187,138,156,59,125,81,137,62,171,83,35,99,202,247,42,130,24,17,161,111,138,214,253,178,9,5,40,56,87,105,151,42,243,68,78,199,223,51,207,6,254,200,227,105,247,243,253,5,26,180,185,186,202,33,162,60,175,95,252,12,33,31,173,171,63,181,14,117,25,82,205,75,115,130,243,197,46,252,242,133,66,73,154,62,235,154,235,6,210,208,69,46,47,15,20,83,185,122,124,74,109,137,55,172,2,218,117,202,233,208,217,21,75,113,30,98,124,250,65,15,176,151,109,151,124,47,8,9,26,200,29,29,228,36,93,96,224,71,159,101,215,158,98,63,16,157,63,158,145,179,206,131,66,98,213,10,253,60,87,191,29,205,16,224,178,85,239,26,98,217,201,199,84,205,208,210,11,179,218,197,87,15,45,251,58,121,202,198,197,124,207,52,133,127,37,99,72,126,157,181,36,18,63,202,168,27,33,84,226,160,139,148,215,122,19,104,207,213,236,185,183,77,34,233,5,164,184,105,232,106,155,117,100,190,240,96,163,90,95,35,4,182,32,229,196,235,136,227,85,120,137,210,149,130,176,64,124,42,142,174,237,60,157,79,122,114,107,227,214,13,56,34,3,165,179,56,75,234,244,17,215,226,238,85,140,220,24,117,200,96,46,64,22,224,81,228,252,104,161,54,137,17,214,10,175,189,226,169,31,27,79,232,171,25,11,104,91,116,253,12,92,163,101,255,190,233,112,86,74,205,240,67,90,14,157,210,129,77,4,110,81,41,145,0,34,237,235,144,199,197,69,27,14,222,175,124,225,38,140,162,196,103,106,18,81,5,30,86,142,94,12,1,15,166,14,9,110,13,90,156,162,186,72,135,77,99,161,171,235,203,70,41,76,5,238,14,242,140,220,221,176,71,10,134,88,79,86,98,135,166,64,87,91,216,213,55,83,218,215,171,48,158,243,55,3,220,196,182,107,240,159,40,139,230,3,21,192,134,28,36,241,64,211,190,96,180},
  {252,222,140,28,28,230,30,239,156,156,207,37,214,242,193,183,72,12,220,173,138,32,222,176,107,167,19,33,181,152,93,84,187,158,117,192,78,113,143,109,95,122,197,13,98,69,186,95,156,190,191,50,131,244,105,66,7,217,209,67,231,182,129,159,255,92,26,114,67,90,167,131,76,139,170,203,19,54,213,109,71,86,153,169,160,142,61,202,179,139,20,141,11,164,204,46,205,127,152,9,236,18,180,26,147,246,200,209,17,132,142,47,235,151,47,160,211,70,10,237,188,149,96,101,131,54,212,240,248,109,138,255,224,97,217,15,252,192,207,195,144,215,7,7,94,12,182,8,107,11,200,190,246,157,249,184,197,252,154,113,139,46,59,108,194,227,186,74,48,8,51,124,254,182,81,203,84,128,204,146,172,254,83,255,213,107,217,214,105,177,24,47,230,92,190,109,144,122,255,19,26,232,218,57,124,136,227,69,191,8,112,146,61,212,193,115,107,157,54,122,71,36,94,164,174,190,86,174,8,234,150,181,213,18,101,17,131,214,27,106,201,238,64,75,172,93,215,231,200,203,148,22,92,254,252,194,216,63,169,229,70,59,90,254,29,144,224,90,105,26,23,95,91,210,3,168,27,101,133,41,211,69,115,215,31,224,116,190,101,31,58,49,236,212,185,132,90,165,106,189,214,30,90,126,80,142,159,122,232,209,244,29,163,125,73,100,139,108,4,214,85,141,18,95,137,53,79,243,174,63,121,23,192,252,153,156,35,34,82,3,81,248,21,66,40,19,240,73,110,16,54,182,36,164,212,107,157,33,182,39,63,224,196,134,12,239,253,218,126,137,202,164,243,241,212,128,129,13,58,255,134,16,64,220,199,176,161,205,232,32,31,249,158,212,157,113,166,56,33,19,212,111,173,23,141,116,91,130,101,16,165,45,138,22,99,119,122,73,47,202,156,8,225,136,189,166,249,254,249,98,56,187,209,35,74,85,101,87,19,229,149,250,66,114,102,71,100,13,84,76,216,88,135,190,220,70,218,65,86,156,161,156,193,9,131,142,157,188,188,109,201,47,218,30,58,71,188,88,118,171,221,236,251,99,189,196,119,13,207,213,206,119,160,94,139,59,253,237,164,61,208,130,34,180,84,117,25,230,180,54,152,153,127,15,204,85,30,55,59,82,128,29,242,50,12,189,182,167,246,183,175,5,57,14,111,225,247,175,117,193,82,55,134,165,38,197,113,81,197,10,162,61,199,59,174,212,217,160,113,116,49,73,223,15,80,219,10,239,56,239,133,172,156,188,186,5,145,102,175,83,99,239,17,3,10,17,152,151,229,53,175,105,21,241,126,39,87,122,48,152,83,204,252,251,24,3,50,147,251,90,62,43,245,79,71,210,210,121,170,122,8,71,48,131,201,148,12,227,39,144,212,129,128,63,168,234,223,234,203,139,25,35,97,73,1,89,39,242,121,140,99,53,216,93,15,141,116,74,229,141,203,48,242,228,159,14,123,46,82,78,166,227,183,174,48,200,124,42,22,159,157,114,115,63,6,48,134,84,157,209,187,143,141,43,221,96,13,61,173,218,227,239,10,46,19,248,150,4,108,10,5,215,39,177,81,202,49,121,162,143,78,73,96,32,81,128,206,126,108,130,243,251,135,159,124,200,226,232,151,149,96,156,25,149,235,79,244,53,209,38,2,55,100,245,102,124,188,232,179,242,114,130,82,59,240,121,154,158,236,30,188,163,88,175,45,133,64,130,111,211,110,130,28,122,41,102,214,140,173,1,224,93,30,93,141,17,185,75,175,42,13,149,159,26,27,106,50,146,161,195,133,107,255,127,102,73,103,135,81,147,106,169,150,208,193,238,30,7,254,175,135,192,24,218,24,67,25,26,8,35,164,156,182,193,255,111,146,184,204,119,105,139,14,70,76,159,199,237,71,105,160,75,32,91,179,140,228,230,142,192,18,187,222,252,233,235,26,229,186,211,179,147,76,72,57,168,183,205,33,135,75,182,16,146,169,152,222,130,220,70,38,7,213,142,96,115,187,90,214,7,85,180,137,101,100,212,203,125,2,106,146,155,4,236,46,244,144,86,107,111,78,98,194,213,63,86,83,255,207,180,174,206,235,173,11,93,116,111,128,130,243,122,42,50,68,143,40,249,231,7,99,165,180,18,14,12,128,132,30,190,52,167,152,193,36,227,63,18,33,8,0,122,140,129,193,192,159,229,94,37,251,172,220,82,234,192,79,5,83,244,127,131,150,11,223,232,38,95,4,158,172,4,178,254,201,56,34,123,128,117,89,58,216,94,91,168,191,139,244,123,19,65,246,91,244,66,79,195,145,115,226,124,167,84,17,130,46,142,189,167,251,236,84,127,13,161,190,211,122,209,187,71,134,151,3,225,246,2,159,6,166,229,17,182,16,214,38,176,52,135,10,230,0,145,6,23,196,58,161,170,80,210,253,44,91,127,7,248,139,163,165,69,208,30,232,107,158,86,54,10,49,92,89,175,226,56,92,23,50,0,72,223,207,238,185,75,33,127,122,106,27,220,215,225,43,225,168,209,184,136,246,255,211,253,148,116,83,89,14,200,219,238,25,197,48,159,5,174,78,206,82,13,32,133,171,23,81,149,125,160,59,147,176,86,41,25,45,133,149,44,41,89,114,156,98,19,11,244,222,93,166,139,223,99,190,121,156,239,143,125,201,31,192,108,163,231,110,240,35,100,152,155,148,92,54,187,9,193,196,222,9,154,6,30,44,57,179,116,70,112,210,233,225,48,110,127,185,179,198,160,58,95,182,39,39,221,11,85,153,26,53,192,143,19,219,163,200,220,11,71,121,166,58,76,64,225,145,142,147,103,115,35,46,58,73,228,7,98,54,203,53,40,29,103,18,7,185,213,104,188,44,156,156,9,191,224,151,8,21,168,82,217,64,5,73,107,208,34,72,241,184,194,87,7,93,33,198,48,88,88,134,190,190,152,237,154,232,156,184,150,37,78,97,189,155,139,80,227,201,130,222,235,251,239,117,217,35,59,250,81,252,203,122,103,45,97,194,157,183,132,255,191,238,184,67,53,190,198,202,211,176,73,117,212,166,222,222,56,142,159,194,177,245,79,90,99,205,91,146,191,123,53,246,66,53,155,46,36,251,54,222,174,30,5,182,225,232,131,156,36,209,135,44,21,82,178,142,209,151,45,145,127,130,134,26,128,12,108,235,142,66,236,92,153,31,175,42,55,89,130,194,159,161,110,151,165,255,100,118,67,56,194,100,11,55,224,36,64,64,83,220,145,49,50,127,37,107,134,238,180,20,98,175,157,35,24,206,0,149,194,133,140,237,85,206,35,88,254,238,69,39,42,217,64,214,215,7,86,215,112,16,10,113,18,76,50,64,174,141,210,231,222,48,248,114,36,46,146,20,57,78,170,209,182,129,76,245,46,68,101,152,223,158,60,186,211,86,122,41,236,166,150,74,8,252,6,253,2,56,117,38,178,223,67,69,248,89,23,100,165,110,58,155,108,251,164,100,177,220,68,248,189,29,11,223,95,6,138,242,32,18,83,0,13,162,99,146,1,87,221,221,204,211,101,88,156,130,59,121,43,107,128,74,81,106,16,159,149,233,115,53,83,212,255,215,89,64,59,55,186,152,247,187,163,35,169,143,175,174,239,59,179,153,3,233,220,195,206,93,250,149,50,10,141,158,187,68,1,189,89,60,221,66,150,214,246,172,126,173,44,150,253,53,233,206,188,208,226,59,94,26,188,37,74,13,94,142,81,2,112,228,95,242,115,86,111,228,142,27,178,30,189,177,243,160,249,169,4,184,7,45,134,177,26,10,234,175,135,20,81,40,221,76,3,237,194,31,183,168,68,154,69,123,231,160,206,199,169,29,114,81,93,72,181,126,71,135,247,163,39,44,113,72,51,46,118,57,84,47,94,119,123,181,81,44,207,96,90,197,29,213,124,159,69,72,21,229,252,247,202,242,50,76,1,102,154,249,134,58,19,107,55,94,42,149,63,96,215,234,225,115,60,112,208,25,231,84,61,116,21,182,175,30,241,219,213,91,122,48,13,192,214,123,244,79,88,24,254,158,24,189,173,105,213,228,164,100,112,10,9,249,198,67,14,169,152,160,178,207,254,166,192,20,126,40,140,57,212,189,241,51,27,19,122,170,20,255,110,40,97,171,23,87,103,102,57,73,164,188,224,141,56,99,211,23,57,49,226,131,169,141,172,32,219,238,198,148,28,127,53,45,33,32,96,236,172,203,71,155,146,136,254,189,200,223,59,170,152,155,68,144,168,56,153,199,176,129,187,241,177,148,194,91,100,128,202,208,89,47,38,78,175,20,218,187,214,100,165,109,153,53,174,26,142,172,67,248,121,175,207,138,2,45,74,57,111,200,102,90,149,102,199,92,72,186,79,62,120,58,185,13,62,67,65,89,8,230,63,137,37,157,5,68,221,29,175,131,15,71,203,188,168,41,196,16,71,139,9,223,118,24,125,191,138,223,219,141,105,250,60,131,56,109,55,151,32,238,97,138,61,151,66,19,182,90,241,104,219,121,56,202,84,42,107,0,13,123,170,100,179,229,21,82,34,47,120,72,198,160,223,189,147,7,139,81,98,253,202,54,255,64,13,109,101,234,109,189,253,81,100,226,173,196,128,206,151,229,190,66,53,144,138,37,161,125,254,212,32,138,125,253,24,170,202,83,241,239,51,44,209,182,138,175,87,148,59,240,107,13,61,152,172,11,31,188,220,198,170,1,224,102,146,96,240,215,186,97,178,158,37,132,99,174,153,186,178,124,209,112,229,109,14,220,200,245,0,163,110,171,54,71,183,10,174,183,203,96,30,77,112,66,12,73,26,3,73,249,183,15,129,203,117,176,61,93,94,129,83,174,218,63,143,207,15,197,204,152,72,213,93,216,161,210,116,228,177,153,225,242,254,200,67,32,9,195,102,12,157,150,104,33,104,103,109,80,100,89,231,33,196,116,125,164,209,104,22,204,63,77,105,99,204,48,134,133,169,102,144,96,177,47,189,181,225,126,103,68,247,218,162,59,245,248,179,18,101,78,192,119,244,157,117,46,133,108,31,10,195,191,247,117,71,122,130,234,121,117,251,92,222,51,43,192,163,242,254,194,131,103,203,106,252,191,46,91,12,57,246,107,203,79,80,232,6,244,54,219,37,245,22,254,137,42,31,23,242,78,130,211,179,86,188,73,0,61,144,55,160,13,201,67,220,212,6,251,146,96,172,189,232,31,176,197,222,96,134,212,0,64,19,16,79,93,208,19,185,33,131,171,150,221,50,46,121,116,125,19,233,145,33,168,215,161,95,23,79,176,76,76,226,153,8,126,245,166,29,148,113,64,168,52,220,64,221,149,185,71,34,32,40,147,111,182,123,244,28,120,188,244,139,188,75,144,203,186,4,249,82,27,57,40,69,179,217,199,165,147,137,223,149,21,65,143,12,76,88,190,61,202,26,231,163,217,146,184,126,167,69,12,116,27,74,13,96,116,19,252,253,226,90,93,96,111,248,110,86,22,135,203,149,226,209,242,56,189,186,17,72,149,162,104,249,250,38,235,118,74,182,47,96,226,144,250,7,148,179,225,33,157,112,37,129,64,212,10,75,61,255,166,74,60,72,213,59,237,153,199,51,139,26,158,195,103,218,243,36,172,185,100,228,16,249,75,233,54,33,170,125,128,126,232,113,87,73,196,182,53,21,48,209,60,170,202,219},
} ;

static const unsigned char precomputed_core_multsntrup1277_k[precomputed_core_multsntrup1277_NUM][crypto_core_KEYBYTES] = {
  {-1,1,1,0,-1,0,0,-1,1,0,0,-1,1,-1,0,1,1,0,-1,1,-1,1,0,1,0,0,0,0,1,0,0,0,0,-1,1,1,0,-1,-1,0,0,1,0,1,0,1,1,0,1,-1,0,0,0,-1,0,-1,-1,1,0,0,1,0,1,-1,-1,0,-1,-1,1,-1,-1,0,0,0,0,0,0,1,-1,-1,0,0,0,1,-1,-1,0,0,1,0,1,0,0,1,0,-1,0,1,-1,0,0,-1,1,0,1,-1,0,1,1,0,-1,0,1,0,1,0,1,0,-1,1,0,0,-1,0,1,0,0,0,0,1,1,0,-1,1,0,0,0,0,1,0,0,0,0,0,-1,1,1,1,-1,1,1,0,1,-1,0,0,1,0,1,0,-1,1,-1,-1,-1,0,1,0,0,1,-1,-1,0,-1,-1,0,1,0,0,-1,1,-1,-1,0,0,1,0,0,-1,0,0,0,-1,1,1,-1,1,1,0,1,1,0,-1,1,0,1,-1,0,0,1,-1,1,1,0,-1,-1,1,0,0,1,1,0,0,-1,0,0,1,0,-1,1,-1,0,0,1,0,-1,0,0,-1,1,0,1,1,0,0,0,-1,1,-1,0,1,0,0,0,0,1,0,0,0,0,0,-1,-1,0,0,0,-1,1,0,-1,-1,-1,0,0,1,0,0,0,-1,0,1,0,1,-1,1,-1,0,0,-1,0,-1,0,1,-1,0,0,0,0,1,-1,0,0,0,-1,-1,0,0,0,-1,1,1,0,-1,-1,0,-1,0,1,-1,0,1,-1,0,0,1,-1,0,1,0,0,0,0,-1,0,1,1,0,1,0,1,0,1,1,0,0,1,0,0,-1,0,1,0,1,-1,-1,0,0,0,0,1,0,-1,0,0,1,1,0,1,-1,-1,0,1,-1,1,0,-1,1,0,0,0,0,0,1,0,-1,0,1,0,0,0,0,0,0,0,0,-1,-1,0,-1,1,0,-1,0,1,0,1,0,1,-1,1,-1,0,-1,0,0,0,1,0,0,1,0,-1,-1,0,1,-1,0,1,0,0,0,-1,0,-1,0,0,0,-1,0,0,0,0,0,0,0,0,0,-1,1,1,1,1,0,0,0,0,1,1,-1,-1,1,-1,0,0,0,1,-1,0,1,1,0,0,0,-1,-1,0,-1,0,0,-1,1,1,1,1,0,0,-1,0,0,0,-1,1,1,-1,1,1,0,1,0,0,-1,-1,0,-1,0,1,-1,1,0,1,-1,1,-1,0,0,0,1,0,0,1,-1,0,-1,0,0,0,-1,0,-1,0,-1,0,1,0,1,1,-1,-1,0,-1,1,-1,-1,-1,0,-1,1,-1,-1,0,-1,0,1,0,0,1,0,1,0,0,-1,-1,0,0,0,1,0,1,1,1,-1,0,-1,-1,1,1,0,1,0,0,1,0,1,1,-1,0,1,-1,1,0,0,0,1,0,-1,0,-1,0,-1,0,-1,0,0,1,0,0,0,0,-1,1,1,1,1,0,1,0,0,0,-1,-1,0,-1,0,0,0,1,0,-1,1,0,-1,0,-1,-1,1,0,1,0,0,1,-1,1,-1,-1,0,0,0,0,0,0,0,1,1,0,0,1,-1,1,0,1,0,-1,0,-1,-1,0,0,1,1,0,-1,1,-1,0,-1,1,1,0,0,0,-1,0,-1,-1,1,0,-1,1,0,1,0,-1,-1,-1,0,-1,1,1,1,0,1,-1,0,0,0,0,-1,0,0,1,1,0,0,1,0,-1,-1,1,1,1,0,-1,0,1,0,0,1,-1,0,0,1,-1,0,0,-1,0,0,0,0,1,-1,0,0,0,1,0,1,0,-1,0,0,0,-1,0,-1,1,0,-1,1,0,1,-1,0,1,-1,0,1,0,1,1,0,0,0,0,-1,0,-1,1,0,0,-1,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,0,-1,0,-1,-1,1,0,0,-1,0,0,-1,0,-1,-1,1,1,0,1,1,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,1,1,-1,0,0,-1,-1,0,1,0,0,0,1,0,0,-1,0,0,0,-1,-1,0,1,1,0,-1,-1,1,-1,0,1,-1,0,-1,1,0,1,0,0,1,0,1,-1,0,-1,-1,0,1,0,0,1,0,0,-1,0,0,0,0,-1,1,0,0,0,1,1,0,0,0,1,-1,-1,0,0,0,0,0,0,-1,0,0,1,1,0,0,0,1,0,0,0,1,0,1,0,-1,0,0,0,0,0,0,-1,-1,0,-1,0,0,0,0,-1,0,0,-1,0,0,0,0,0,-1,0,1,1,1,-1,0,-1,1,1,1,0,1,-1,-1,0,1,1,1,0,1,0,0,-1,0,0,0,1,1,0,0,0,0,0,-1,0,0,1,0,-1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,-1,0,0,-1,-1,0,0,1,0,-1,-1,0,0,0,0,0,-1,1,1,-1,0,1,1,-1,-1,0,0,1,1,0,-1,-1,-1,0,0,-1,-1,-1,-1,1,-1,-1,0,0,0,0,0,-1,-1,-1,0,-1,0,0,-1,0,0,0,1,0,0,-1,0,-1,0,0,0,1,1,-1,0,0,-1,1,-1,0,1,-1,-1,-1,1,0,0,-1,-1,0,-1,-1,0,0,-1,0,0,-1,1,0,-1,1,1,0,1,0,-1,1,0,0,0,-1,0,0,-1,-1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,-1,-1,0,1,1,0,0,1,0,1,1,-1,1,0,1,-1,-1,-1,0,1,0,1,-1,1,1,0,0,1,0,1,1,-1,-1,1,1,-1,-1,1,1,0,0,1,0,0,0,-1,-1,0,1,0,0,1,-1,-1,1,0,1,0,-1,1,-1,0,0,0,1,0,-1,0,0,0,1,0,0,-1,1,-1,1,-1,0,-1,0,-1,0,1,0,1,0,1,0,0,0,0,0,1,-1,0,1,0,1,0,0,-1,-1,-1,0,-1,0,-1,-1,0,1,-1,-1,1,0,0,-1,0,0,1,0,0,-1,-1,0,0,0,0,-1,0,-1,-1,1,0,0,0,0,0,1,0,0},
  {0,0,0,0,0,0,0,0,-1,0,0,0,0,0,-1,0,1,-1,0,0,1,0,-1,0,0,-1,0,0,0,1,1,1,-1,-1,0,1,0,1,0,1,-1,0,0,0,-1,0,0,0,1,0,1,0,0,0,-1,0,1,-1,1,-1,0,0,0,0,0,0,0,0,-1,1,-1,0,0,0,-1,0,0,-1,0,-1,0,1,1,-1,-1,-1,-1,1,-1,1,-1,1,0,0,0,-1,0,0,0,0,0,0,0,0,1,0,1,-1,1,1,-1,-1,1,0,0,0,-1,-1,1,-1,1,-1,1,0,1,-1,1,0,-1,-1,1,0,-1,-1,0,-1,-1,0,1,-1,0,0,-1,1,-1,0,0,-1,0,1,0,1,0,0,0,-1,-1,1,0,0,-1,0,-1,0,0,0,0,1,1,0,-1,-1,0,0,-1,-1,0,-1,-1,-1,1,1,1,-1,1,0,0,1,0,-1,0,-1,0,0,0,1,1,-1,-1,-1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,1,-1,0,0,1,0,0,-1,-1,-1,0,-1,0,1,-1,1,-1,-1,-1,0,1,-1,-1,1,1,-1,1,0,0,0,1,-1,1,0,-1,1,1,0,-1,0,-1,0,0,1,0,1,0,0,-1,0,0,-1,-1,1,0,0,-1,0,0,1,-1,0,0,1,1,1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,-1,1,-1,1,-1,1,1,-1,1,0,0,0,0,0,-1,0,0,0,0,0,0,0,-1,1,1,1,1,-1,1,0,0,0,0,-1,1,0,1,1,0,0,1,0,-1,0,-1,0,1,-1,1,0,1,0,1,0,-1,1,0,0,1,0,0,1,-1,0,0,0,0,1,-1,-1,0,0,-1,0,-1,0,-1,1,-1,0,0,0,0,0,1,0,1,1,0,1,-1,-1,0,1,0,0,0,0,0,0,1,0,0,0,0,-1,1,0,1,0,1,-1,0,0,0,1,0,1,1,0,1,-1,0,0,0,-1,1,-1,-1,0,-1,1,1,0,0,1,0,0,1,-1,0,0,-1,-1,0,0,1,1,-1,-1,0,-1,-1,0,1,0,1,-1,0,-1,0,0,0,-1,1,1,-1,0,-1,-1,1,0,0,1,-1,-1,0,1,1,1,0,-1,-1,0,0,1,1,1,1,0,-1,-1,0,0,0,0,0,-1,0,0,1,0,1,-1,1,-1,0,0,-1,-1,0,-1,0,-1,0,1,1,0,0,0,0,0,-1,-1,0,0,0,1,0,0,1,0,0,0,0,1,-1,0,0,-1,0,-1,0,1,1,0,0,-1,-1,1,-1,0,1,-1,0,-1,0,1,-1,1,-1,0,0,1,0,-1,1,0,0,0,-1,-1,0,0,1,0,1,0,-1,0,0,0,0,0,0,0,0,0,0,-1,1,-1,0,-1,0,1,0,-1,0,-1,-1,0,0,1,-1,0,0,0,-1,0,1,-1,-1,1,0,0,-1,0,-1,1,0,-1,-1,1,0,-1,-1,0,-1,1,0,0,0,0,0,0,-1,1,0,1,-1,-1,1,1,0,0,0,0,0,-1,-1,0,0,-1,0,1,0,0,-1,-1,0,0,1,0,1,-1,-1,0,0,0,1,-1,-1,0,1,-1,-1,-1,0,1,-1,0,-1,1,1,1,0,0,0,1,0,0,0,-1,1,0,-1,1,0,1,0,0,1,1,1,0,0,-1,1,0,-1,1,-1,1,-1,0,1,1,1,0,0,0,0,0,1,0,0,1,1,1,-1,1,1,1,-1,0,0,-1,-1,0,0,0,0,-1,1,0,0,-1,0,-1,1,1,-1,-1,0,1,0,0,0,-1,1,-1,0,0,0,0,-1,0,0,0,-1,0,0,1,0,-1,1,1,-1,0,0,-1,0,1,1,0,1,0,1,0,1,1,-1,0,0,-1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,-1,0,0,-1,1,-1,0,1,0,-1,-1,0,0,-1,1,1,0,1,0,0,0,0,0,0,0,0,0,-1,1,-1,0,-1,-1,-1,1,0,0,0,1,0,0,0,0,1,0,0,0,-1,1,0,0,0,-1,-1,0,1,1,-1,-1,0,-1,-1,0,-1,0,1,0,1,0,1,1,-1,0,0,0,-1,0,-1,-1,1,1,0,-1,0,1,0,0,-1,0,0,-1,1,0,-1,1,0,0,0,0,1,0,1,-1,1,0,1,0,0,-1,1,-1,-1,0,1,0,0,0,0,1,-1,0,1,0,-1,0,-1,0,0,0,0,-1,0,0,1,-1,-1,-1,0,-1,0,1,-1,1,-1,0,-1,0,1,0,0,1,0,-1,0,-1,0,-1,1,1,-1,0,0,1,-1,1,0,0,0,-1,-1,0,-1,0,0,1,0,0,0,0,-1,0,-1,1,0,0,0,-1,0,0,1,0,0,-1,-1,0,1,0,-1,0,1,1,0,-1,0,1,0,1,1,0,1,0,-1,0,-1,0,1,0,1,0,1,1,0,0,0,1,1,0,0,1,0,0,0,0,0,-1,0,1,0,0,-1,1,0,0,0,0,0,-1,-1,0,0,0,1,1,-1,1,0,0,0,-1,0,0,0,0,0,0,0,0,1,-1,-1,-1,1,0,1,1,-1,-1,0,0,0,0,0,-1,0,1,0,-1,0,1,1,0,-1,0,1,1,0,-1,0,0,0,1,0,-1,1,-1,-1,-1,0,1,0,0,-1,-1,-1,1,0,-1,1,1,1,1,1,1,1,-1,-1,0,0,-1,0,1,1,0,1,1,-1,0,0,0,0,0,1,-1,1,0,0,-1,-1,-1,0,-1,1,0,-1,1,-1,0,1,0,1,1,0,-1,0,1,-1,0,-1,1,0,-1,0,1,0,0,1,0,-1,0,-1,-1,0,0,1,1,1,1,1,-1,1,0,1,-1,0,0,0,0,0,0,-1,0,0,0,1,1,0,-1,0,1,0,0,0,1,1,1,-1,0,-1,0,-1,0,0,0,0,1,1,1,0,0,1,0,0,0,0,1,0,0,-1,0,-1,-1,0,-1,1,0,0,0,0,0,1,-1,0,0,1,0,0,1,0,1,1,-1,1,-1,0,0,1,-1,0},
  {0,-1,0,-1,-1,0,0,1,1,-1,-1,0,-1,0,1,1,0,0,0,0,1,1,1,1,0,0,-1,-1,0,0,0,0,0,0,0,1,1,0,1,0,-1,-1,0,0,-1,-1,0,1,0,1,1,-1,1,0,0,0,1,0,1,1,1,0,1,0,-1,0,-1,0,0,0,-1,0,0,0,1,0,0,0,-1,1,0,0,1,0,0,-1,1,1,-1,-1,-1,0,1,0,1,0,0,0,1,-1,-1,0,0,0,1,-1,0,0,0,-1,0,-1,0,-1,1,-1,0,-1,0,1,0,0,-1,-1,-1,1,0,1,0,-1,-1,-1,1,0,0,0,0,1,0,0,0,-1,0,1,0,0,-1,-1,0,-1,0,0,1,0,1,1,0,-1,0,0,1,1,-1,0,0,1,1,0,0,0,0,0,-1,-1,1,0,1,-1,1,1,1,0,0,0,0,0,0,1,0,-1,0,0,1,-1,1,-1,0,0,0,0,-1,1,1,0,0,0,0,-1,0,1,1,1,0,-1,-1,1,0,1,0,-1,0,0,0,0,1,1,0,1,-1,0,-1,-1,0,1,0,0,0,0,-1,0,0,0,0,1,1,1,0,0,-1,1,1,0,0,-1,1,0,-1,-1,-1,1,1,1,-1,1,0,0,0,0,0,0,0,0,-1,0,0,1,-1,0,0,0,-1,0,1,0,0,-1,1,0,1,0,0,-1,0,0,0,0,0,1,1,0,-1,1,0,-1,-1,-1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,-1,-1,0,0,1,-1,-1,-1,1,-1,-1,-1,1,-1,0,-1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1,0,0,1,0,0,0,0,1,0,0,1,1,0,1,0,-1,-1,0,0,0,1,-1,0,0,0,-1,1,-1,-1,1,-1,0,0,0,0,-1,0,0,-1,1,-1,1,0,0,1,0,-1,-1,0,-1,-1,-1,-1,-1,0,0,1,0,0,0,0,-1,1,0,0,1,0,1,0,0,1,0,-1,1,-1,1,0,0,0,1,-1,0,-1,0,0,0,0,1,0,0,0,1,-1,1,0,-1,1,0,0,0,1,1,0,0,0,0,-1,1,0,1,0,1,0,0,0,-1,-1,-1,0,1,1,0,0,1,-1,0,-1,0,-1,-1,1,1,0,1,1,0,1,1,0,1,0,0,0,1,0,0,0,-1,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,1,-1,-1,1,-1,0,-1,-1,0,1,0,-1,0,1,0,0,0,0,0,-1,0,0,0,0,0,1,1,0,-1,0,0,0,1,1,-1,1,0,1,0,-1,0,-1,0,0,-1,0,0,-1,1,0,0,1,0,1,-1,0,1,1,0,0,0,-1,-1,0,0,0,0,0,1,-1,0,-1,1,-1,0,-1,-1,0,0,0,0,-1,1,0,1,1,0,1,0,0,0,1,-1,1,1,0,0,-1,0,0,-1,1,0,1,0,0,-1,0,0,-1,0,0,0,-1,1,1,1,1,-1,0,1,0,1,0,-1,-1,0,0,1,1,-1,-1,0,0,1,-1,0,-1,1,0,0,0,1,0,-1,1,0,-1,0,0,1,0,0,0,-1,-1,-1,0,1,1,0,-1,1,0,0,1,0,-1,0,-1,0,0,-1,0,-1,-1,0,1,-1,-1,0,0,0,-1,0,0,1,0,0,0,0,0,1,-1,1,0,0,-1,-1,0,-1,1,-1,-1,1,0,-1,0,1,0,1,1,-1,0,0,0,0,-1,-1,1,1,1,1,0,-1,1,0,0,1,0,0,1,0,0,1,1,-1,-1,-1,1,0,-1,1,1,1,0,0,0,-1,0,0,0,0,-1,0,1,0,0,0,1,0,0,0,0,1,-1,0,0,0,1,0,-1,-1,0,1,1,0,1,0,1,0,-1,0,-1,0,-1,1,0,0,0,0,0,-1,1,0,0,0,0,0,-1,0,-1,0,0,0,-1,1,1,-1,-1,-1,0,0,-1,0,-1,-1,-1,-1,0,1,-1,0,0,-1,1,1,1,-1,0,0,0,-1,1,0,0,-1,0,-1,1,-1,1,0,-1,0,1,1,0,0,1,1,0,0,1,-1,1,1,0,1,-1,1,0,1,0,0,0,-1,0,0,0,-1,0,-1,1,0,0,0,-1,0,0,-1,1,0,0,-1,0,-1,-1,1,0,1,0,0,0,0,0,-1,0,-1,0,1,0,-1,0,0,0,0,-1,0,1,0,-1,0,0,0,0,-1,-1,0,0,1,-1,-1,0,0,-1,-1,0,0,-1,0,0,0,0,0,-1,-1,-1,-1,1,-1,1,0,0,0,0,-1,0,0,0,0,0,0,-1,0,1,0,0,-1,1,1,0,1,0,-1,0,-1,-1,-1,-1,0,0,0,1,1,-1,0,-1,0,0,-1,0,1,1,1,0,1,0,0,-1,0,0,0,0,-1,1,0,0,1,1,1,0,-1,-1,1,-1,-1,-1,-1,0,0,-1,-1,-1,1,0,-1,0,0,0,0,0,-1,0,0,0,1,0,-1,0,0,1,0,1,0,0,0,1,1,1,-1,0,0,0,0,0,0,0,-1,1,1,-1,1,1,-1,-1,0,1,-1,0,1,1,-1,0,-1,0,0,0,1,1,-1,-1,1,-1,-1,-1,0,0,1,1,-1,0,1,0,0,0,0,-1,-1,-1,-1,0,-1,0,0,0,0,-1,-1,1,0,0,0,0,-1,1,0,-1,0,-1,-1,-1,0,-1,0,1,-1,0,0,1,-1,-1,0,-1,1,-1,0,-1,1,-1,1,-1,0,-1,-1,0,0,1,-1,1,-1,1,0,1,0,1,0,1,-1,0,-1,-1,0,0,0,-1,-1,-1,0,-1,0,0,0,-1,-1,0,0,0,-1,0,0,1,1,-1,0,0,0,-1,-1,0,-1,1,-1,0,1,0,1,1,0,-1,0,-1,0,0,1,0,0,0,0,0,1,1,0,0,-1,1,-1,1,0,0,0,1,0,-1,-1,0,0,0,0,0,1,0,1,0,-1,1,0,0,0,-1,-1,-1,1,0,0,-1,0,-1,-1,1,1,0,0,1,1,-1,0,0,1,1},
  {1,0,0,0,0,0,-1,0,1,0,1,1,-1,0,-1,0,0,-1,0,0,1,0,1,1,0,0,-1,0,1,-1,1,-1,0,1,0,1,-1,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,-1,0,1,0,0,1,0,1,0,0,1,0,-1,-1,0,1,1,-1,-1,1,1,1,-1,1,0,1,1,0,0,1,1,1,1,-1,-1,1,0,-1,1,0,0,1,0,1,0,-1,0,0,0,0,-1,1,0,0,0,1,-1,0,1,0,-1,-1,0,0,0,0,0,1,0,1,-1,0,0,0,-1,1,0,1,0,0,0,0,1,-1,1,0,1,0,0,0,-1,0,1,1,0,0,1,0,1,1,0,1,1,0,0,1,-1,1,1,-1,-1,1,0,-1,1,0,1,1,0,-1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,-1,0,1,0,1,0,0,1,1,1,0,-1,0,-1,-1,0,1,0,0,-1,1,0,-1,1,1,-1,0,-1,0,0,0,0,0,0,0,1,-1,0,0,0,1,0,0,0,-1,-1,0,0,1,1,-1,1,1,0,-1,0,0,0,0,1,1,1,1,-1,1,-1,0,0,1,1,-1,0,0,1,0,1,-1,0,1,-1,1,1,0,0,-1,1,0,0,1,0,0,-1,1,-1,0,0,-1,1,0,0,-1,-1,-1,0,0,-1,-1,-1,1,0,-1,1,0,0,0,0,-1,0,1,-1,0,0,0,1,1,1,0,-1,0,0,1,-1,1,-1,1,0,0,-1,0,-1,0,0,-1,0,0,0,-1,1,0,1,-1,-1,0,1,1,0,1,1,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,1,0,-1,0,-1,0,0,-1,-1,1,0,1,0,-1,0,0,-1,-1,0,0,0,0,0,0,0,1,0,1,0,1,0,-1,-1,0,0,0,-1,0,0,-1,0,0,1,-1,1,-1,-1,1,0,0,0,1,-1,0,-1,0,-1,0,1,1,0,-1,-1,1,-1,0,0,0,-1,-1,0,0,0,0,1,0,-1,-1,-1,1,-1,0,0,0,-1,0,0,0,0,-1,0,1,1,0,1,-1,0,0,0,-1,0,0,0,0,0,1,0,0,-1,-1,0,0,1,0,-1,0,-1,1,-1,-1,-1,-1,0,-1,1,0,-1,0,0,0,1,-1,0,0,1,0,0,0,1,1,0,0,1,0,-1,0,0,-1,0,-1,1,1,1,-1,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,1,0,0,-1,0,1,0,1,1,0,0,1,0,1,0,0,0,0,-1,1,-1,0,-1,1,0,-1,0,0,0,1,-1,0,0,-1,0,0,0,1,1,-1,0,0,1,1,0,0,0,0,-1,0,1,-1,-1,-1,0,0,0,0,0,0,0,0,-1,0,1,-1,0,0,0,1,0,1,0,0,-1,-1,0,0,0,0,0,0,-1,1,0,-1,0,0,0,0,-1,-1,-1,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,-1,-1,-1,-1,0,0,0,0,-1,0,0,-1,1,-1,0,1,0,1,1,0,0,1,0,0,-1,1,-1,0,0,1,0,-1,1,-1,0,0,1,1,-1,0,-1,0,-1,-1,0,0,1,0,1,-1,0,1,0,0,1,-1,0,0,0,0,1,0,0,0,0,1,0,1,-1,0,-1,1,1,0,-1,-1,-1,1,0,1,-1,0,0,1,-1,0,1,-1,-1,0,0,0,0,0,0,0,1,1,-1,1,0,0,1,1,1,-1,0,0,1,1,0,0,0,1,1,1,1,-1,-1,1,0,-1,0,0,0,0,0,0,0,-1,0,0,0,-1,-1,0,-1,0,0,1,0,-1,-1,-1,0,-1,-1,0,1,-1,0,1,1,0,-1,1,1,1,-1,0,0,-1,0,1,0,-1,1,0,0,0,0,0,-1,1,0,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,-1,-1,1,-1,-1,0,0,0,-1,0,0,-1,1,0,-1,1,0,0,0,1,0,0,0,-1,0,1,-1,-1,1,0,-1,1,-1,1,0,0,0,0,0,0,0,1,0,1,1,0,0,-1,1,0,1,1,1,0,1,0,0,0,1,1,-1,1,1,-1,1,0,1,0,-1,0,0,0,1,0,1,0,-1,1,-1,0,0,-1,0,1,0,1,1,1,-1,1,-1,1,0,1,-1,-1,0,1,-1,1,0,0,-1,1,0,-1,1,0,-1,0,0,0,0,0,-1,0,-1,0,0,0,-1,-1,-1,-1,0,1,0,-1,0,0,0,0,1,0,0,0,0,0,0,1,1,-1,-1,1,-1,-1,1,1,-1,0,0,1,1,0,0,0,1,0,0,1,0,1,0,0,1,0,1,0,0,1,0,0,1,0,0,1,1,1,0,-1,0,-1,0,0,1,-1,0,1,-1,1,1,0,-1,0,1,0,-1,-1,1,0,1,0,0,-1,1,1,1,-1,-1,0,0,0,0,0,0,-1,0,0,1,0,1,0,-1,-1,1,0,-1,-1,1,0,1,0,0,-1,0,0,0,0,1,0,0,0,0,-1,1,0,1,1,-1,0,-1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,-1,1,-1,0,0,-1,1,-1,0,1,0,0,0,1,0,0,-1,1,-1,-1,1,-1,1,1,0,1,1,-1,0,1,1,1,1,0,-1,-1,0,1,0,0,-1,0,0,0,1,-1,0,-1,-1,-1,0,1,-1,0,-1,-1,1,1,-1,0,1,1,1,0,-1,0,1,0,0,0,0,1,0,0,-1,0,1,0,1,0,-1,1,-1,0,-1,-1,1,1,0,1,1,0,-1,0,0,0,1,0,1,0,0,1,1,0,1,0,0,-1,-1,-1,1,-1,1,0,-1,0,-1,0,1,0,1,1,0,0,1,0,1,1,1,1,1,1,-1,0,1,-1,1,-1,0,0,1,-1,0,1,-1,0,0,-1,0,0,0,0,0,-1,0,1,0,0,1,0,0,0,0,0,1,-1,0,0,1,0,1,0,0},
} ;

static const unsigned char precomputed_core_multsntrup1277_c[precomputed_core_multsntrup1277_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_multsntrup1277_impl(long long impl)
{
  unsigned char *h = test_core_multsntrup1277_h;
  unsigned char *n = test_core_multsntrup1277_n;
  unsigned char *k = test_core_multsntrup1277_k;
  unsigned char *c = test_core_multsntrup1277_c;
  unsigned char *h2 = test_core_multsntrup1277_h2;
  unsigned char *n2 = test_core_multsntrup1277_n2;
  unsigned char *k2 = test_core_multsntrup1277_k2;
  unsigned char *c2 = test_core_multsntrup1277_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_multsntrup1277_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_multsntrup1277(impl);
    printf("core_multsntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup1277_implementation(impl),ntruprime_dispatch_core_multsntrup1277_compiler(impl));
  } else {
    crypto_core = ntruprime_core_multsntrup1277;
    printf("core_multsntrup1277 selected implementation %s compiler %s\n",ntruprime_core_multsntrup1277_implementation(),ntruprime_core_multsntrup1277_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_multsntrup1277_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_multsntrup1277_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_multsntrup1277_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_multsntrup1277_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_multsntrup1277_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_multsntrup1277_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_multsntrup1277_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_multsntrup1277_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_multsntrup1277_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_multsntrup1277_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_multsntrup1277(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup1277")) return;
  storage_core_multsntrup1277_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_multsntrup1277_h = aligned(storage_core_multsntrup1277_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_multsntrup1277_n = callocplus(crypto_core_INPUTBYTES);
  test_core_multsntrup1277_n = aligned(storage_core_multsntrup1277_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_multsntrup1277_k = callocplus(crypto_core_KEYBYTES);
  test_core_multsntrup1277_k = aligned(storage_core_multsntrup1277_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_multsntrup1277_c = callocplus(crypto_core_CONSTBYTES);
  test_core_multsntrup1277_c = aligned(storage_core_multsntrup1277_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_multsntrup1277_h2 = callocplus(maxalloc);
  test_core_multsntrup1277_h2 = aligned(storage_core_multsntrup1277_h2,crypto_core_OUTPUTBYTES);
  storage_core_multsntrup1277_n2 = callocplus(maxalloc);
  test_core_multsntrup1277_n2 = aligned(storage_core_multsntrup1277_n2,crypto_core_INPUTBYTES);
  storage_core_multsntrup1277_k2 = callocplus(maxalloc);
  test_core_multsntrup1277_k2 = aligned(storage_core_multsntrup1277_k2,crypto_core_KEYBYTES);
  storage_core_multsntrup1277_c2 = callocplus(maxalloc);
  test_core_multsntrup1277_c2 = aligned(storage_core_multsntrup1277_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_multsntrup1277 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup1277();++impl)
      forked(test_core_multsntrup1277_impl,impl);
    ++test_core_multsntrup1277_h;
    ++test_core_multsntrup1277_n;
    ++test_core_multsntrup1277_k;
    ++test_core_multsntrup1277_c;
    ++test_core_multsntrup1277_h2;
    ++test_core_multsntrup1277_n2;
    ++test_core_multsntrup1277_k2;
    ++test_core_multsntrup1277_c2;
  }
  free(storage_core_multsntrup1277_c2);
  free(storage_core_multsntrup1277_k2);
  free(storage_core_multsntrup1277_n2);
  free(storage_core_multsntrup1277_h2);
  free(storage_core_multsntrup1277_c);
  free(storage_core_multsntrup1277_k);
  free(storage_core_multsntrup1277_n);
  free(storage_core_multsntrup1277_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

