/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.Runtime;
import alt.jiapi.file.ClassFile;
import alt.jiapi.file.ConstantPool;
import alt.jiapi.file.Field;
import alt.jiapi.file.Interface;
import alt.jiapi.file.Method;
import alt.jiapi.reflect.ClassBuilder;
import alt.jiapi.reflect.FieldExistsException;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.MethodExistsException;
import alt.jiapi.reflect.Signature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class JiapiClass {
    private static final JiapiField[] fieldArrayTemplate = new JiapiField[0];
    private static final JiapiMethod[] methodArrayTemplate = new JiapiMethod[0];
    private static Category log = Runtime.getLogCategory(JiapiClass.class);
    private Loader loader;
    private ClassBuilder builder;
    private ClassFile clazz;
    private List jiapiMethods;
    private List jiapiFields;

    public static void main(String[] args) throws Exception {
        Loader l = new Loader();
        JiapiClass jc = l.loadClass(args[0]);
        System.out.println(jc);
    }

    public static JiapiClass createClass(String name) {
        ClassFile cf = new ClassFile(name);
        return new JiapiClass(cf);
    }

    public static JiapiClass parseClass(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ClassFile cf = ClassFile.parse(bais);
        return new JiapiClass(cf);
    }

    private JiapiClass() {
    }

    JiapiClass(ClassFile classFile) {
        this.clazz = classFile;
        this.builder = new ClassBuilder(classFile);
        this.loader = new Loader();
        this.jiapiMethods = new LinkedList();
        this.jiapiFields = new LinkedList();
        List methods = this.clazz.getMethods();
        for (Method m : methods) {
            JiapiMethod jm = new JiapiMethod(m);
            jm.setDeclaringClass(this);
            this.jiapiMethods.add(jm);
        }
        List fields = this.clazz.getFields();
        for (Field f : fields) {
            JiapiField jf = new JiapiField(f);
            jf.setDeclaringClass(this);
            this.jiapiFields.add(jf);
        }
    }

    public void dump(OutputStream out) throws IOException {
        out.write(this.getByteCode());
    }

    public Loader getLoader() {
        return this.loader;
    }

    public String getName() {
        return this.clazz.getClassName();
    }

    public String getPackageName() {
        String cName = this.getName();
        int idx = cName.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return cName.substring(0, idx);
    }

    public byte[] getByteCode() {
        JiapiMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            methods[i].update();
        }
        return this.clazz.toBytes();
    }

    public JiapiMethod[] getMethods() throws ClassNotFoundException {
        ArrayList al = new ArrayList();
        JiapiClass jc = this;
        do {
            al.addAll(jc.jiapiMethods);
        } while ((jc = jc.getSuperclass()) != null);
        return al.toArray(methodArrayTemplate);
    }

    public JiapiMethod[] getDeclaredMethods() {
        ArrayList al = new ArrayList();
        al.addAll(this.jiapiMethods);
        return al.toArray(methodArrayTemplate);
    }

    public JiapiMethod getDeclaredMethod(String name, String[] parameterTypeNames) throws NoSuchMethodException {
        Signature otherSignature = new Signature("void", parameterTypeNames);
        for (JiapiMethod jm : this.jiapiMethods) {
            if (!jm.getName().equals(name) || !jm.getSignature().equals(otherSignature)) continue;
            return jm;
        }
        throw new NoSuchMethodException(name + otherSignature.toString());
    }

    public JiapiMethod getDeclaredMethod(String name, JiapiClass[] parameterTypes) throws NoSuchMethodException {
        String[] parameterTypeNames = null;
        if (parameterTypes != null) {
            parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypeNames[i] = parameterTypes[i].getName();
            }
        }
        return this.getDeclaredMethod(name, parameterTypeNames);
    }

    public JiapiMethod getMethod(String name, String[] parameterTypeNames) throws NoSuchMethodException, ClassNotFoundException {
        JiapiClass jc = this;
        JiapiMethod method = null;
        while (true) {
            try {
                method = jc.getDeclaredMethod(name, parameterTypeNames);
                return method;
            }
            catch (NoSuchMethodException nsme) {
                if ((jc = jc.getSuperclass()) != null) continue;
                throw new NoSuchMethodException(name);
            }
            break;
        }
    }

    public JiapiMethod getMethod(String name, JiapiClass[] parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        JiapiClass jc = this;
        JiapiMethod method = null;
        while (true) {
            try {
                method = jc.getDeclaredMethod(name, parameterTypes);
                return method;
            }
            catch (NoSuchMethodException nsme) {
                if ((jc = jc.getSuperclass()) != null) continue;
                throw new NoSuchMethodException(name);
            }
            break;
        }
    }

    public JiapiField[] getFields() throws ClassNotFoundException {
        ArrayList al = new ArrayList();
        JiapiClass jc = this;
        do {
            al.addAll(jc.jiapiFields);
        } while ((jc = jc.getSuperclass()) != null);
        return al.toArray(fieldArrayTemplate);
    }

    public JiapiField[] getDeclaredFields() {
        ArrayList al = new ArrayList();
        al.addAll(this.jiapiFields);
        return al.toArray(fieldArrayTemplate);
    }

    public JiapiField getDeclaredField(String name) throws NoSuchFieldException {
        for (JiapiField f : this.jiapiFields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        throw new NoSuchFieldException(name);
    }

    public JiapiField getField(String name) throws NoSuchFieldException, ClassNotFoundException {
        JiapiClass jc = this;
        JiapiField field = null;
        while (true) {
            try {
                field = jc.getDeclaredField(name);
                return field;
            }
            catch (NoSuchFieldException nsfe) {
                if ((jc = jc.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(name);
            }
            break;
        }
    }

    public JiapiClass getSuperclass() throws ClassNotFoundException {
        String scName = this.clazz.getSuperclassName();
        JiapiClass superClass = null;
        if (scName != null) {
            try {
                superClass = this.loader.loadClass(scName);
            }
            catch (IOException ioe) {
                log.error((Object)"", (Throwable)ioe);
            }
        }
        return superClass;
    }

    public int getModifiers() {
        return this.clazz.getAccessFlags();
    }

    public JiapiField addField(String name) throws FieldExistsException {
        return this.addField(1, "java.lang.Object", name);
    }

    public JiapiField addField(int modifiers, String type, String name) throws FieldExistsException {
        JiapiField jf = this.builder.addField((short)modifiers, type, name);
        jf.setDeclaringClass(this);
        this.jiapiFields.add(jf);
        return jf;
    }

    public String[] getInterfaceNames() {
        ConstantPool cp = this.clazz.getConstantPool();
        List l = this.clazz.getInterfaces();
        String[] iNames = new String[l.size()];
        for (int i = 0; i < iNames.length; ++i) {
            Interface iFace = (Interface)l.get(i);
            iNames[i] = iFace.getName();
        }
        return iNames;
    }

    public JiapiClass[] getInterfaceTypes() throws ClassNotFoundException {
        String[] iNames = this.getInterfaceNames();
        JiapiClass[] interfaces = new JiapiClass[iNames.length];
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                interfaces[i] = this.getLoader().loadClass(iNames[i]);
                continue;
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(iNames[i]);
            }
        }
        return interfaces;
    }

    public void addInterface(String interfaceType) {
        this.clazz.addInterface(interfaceType);
    }

    public void addInterface(JiapiClass interfaceType) throws IllegalArgumentException {
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + interfaceType.getName());
        }
        this.addInterface(interfaceType.getName());
    }

    public JiapiMethod addMethod(JiapiMethod m) throws MethodExistsException {
        return this.addMethod(m.getModifiers(), m.getName(), m.getSignature());
    }

    public JiapiMethod addMethod(int modifiers, String methodName, Signature signature) throws MethodExistsException {
        JiapiMethod jm = null;
        for (JiapiMethod method : this.jiapiMethods) {
            if (!method.getName().equals(methodName) || !method.getSignature().getDescriptor().equals(signature.getDescriptor())) continue;
            throw new MethodExistsException(method);
        }
        try {
            jm = this.builder.addMethod((short)modifiers, methodName, signature);
        }
        catch (MethodExistsException mee) {
            jm = mee.getMethod();
            jm.setDeclaringClass(this);
            throw mee;
        }
        jm.setDeclaringClass(this);
        this.jiapiMethods.add(jm);
        return jm;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.getModifiers() & 0xFFDF));
        sb.append(" JiapiClass ");
        sb.append(this.getName());
        String[] interfaces = this.getInterfaceNames();
        if (interfaces.length > 0) {
            sb.append(" implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                sb.append(interfaces[i]);
                if (i >= interfaces.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("\nFields:");
        JiapiField[] fields = this.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            sb.append("\n  ");
            sb.append(fields[i].toString());
        }
        sb.append("\nMethods:");
        JiapiMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            sb.append("\n  ");
            sb.append(methods[i].toString());
        }
        return sb.toString();
    }

    void setLoader(Loader l) {
        this.loader = l;
    }

    public ConstantPool getConstantPool() {
        return this.clazz.getConstantPool();
    }
}

