/* Generated by GOB (v2.0.20)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 2 "loqui-core-gtk.gob"

/*
 * Loqui -- Chat/IM client for Gtk2 <http://launchpad.net/loqui/>
 * Copyright (C) 2002-2003 Yoichi Imai <sunnyone41@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#line 28 "loqui-core-gtk.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 20

#define selfp (self->_priv)

#include "loqui-core-gtk.h"

#include "loqui-core-gtk-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 46 "loqui-core-gtk.gob"

#include <loqui_protocol_irc.h>
#include <loqui_protocol_ipmsg.h>

#include <glib/gi18n.h>
#include <libloqui/loqui-utils.h>
#include "main.h"

#include <string.h>
#include <stdlib.h>

#include <loqui.h>

#define ACCEL_MAP_FILE "accelmaprc"
#define STYLERC_FILE "stylerc"
#define GENERAL_PREF_FILENAME "loquirc"

#include "loqui_stock.h"
#include "prefs_general_upgrader.h"
#include "loqui-notifier-gtk.h"


#line 70 "loqui-core-gtk.c"
/* self casting macros */
#define SELF(x) LOQUI_CORE_GTK(x)
#define SELF_CONST(x) LOQUI_CORE_GTK_CONST(x)
#define IS_SELF(x) LOQUI_IS_CORE_GTK(x)
#define TYPE_SELF LOQUI_TYPE_CORE_GTK
#define SELF_CLASS(x) LOQUI_CORE_GTK_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_CORE_GTK_GET_CLASS(x)

/* self typedefs */
typedef LoquiCoreGtk Self;
typedef LoquiCoreGtkClass SelfClass;

/* here are local prototypes */
static void loqui_core_gtk_class_init (LoquiCoreGtkClass * c) G_GNUC_UNUSED;
#line 85 "loqui-core-gtk.gob"
static void loqui_core_gtk_init (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 88 "loqui-core-gtk.c"
#line 101 "loqui-core-gtk.gob"
static gchar * ___3_loqui_core_gtk_get_version_info (LoquiCore * self_core) G_GNUC_UNUSED;
#line 91 "loqui-core-gtk.c"
#line 136 "loqui-core-gtk.gob"
static gchar * loqui_core_gtk_get_stylerc_path (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 94 "loqui-core-gtk.c"
#line 140 "loqui-core-gtk.gob"
static gchar * loqui_core_gtk_get_general_pref_path (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 97 "loqui-core-gtk.c"
#line 145 "loqui-core-gtk.gob"
static void loqui_core_gtk_make_program_dir (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 100 "loqui-core-gtk.c"
#line 182 "loqui-core-gtk.gob"
static void loqui_core_gtk_load_accelmap (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 103 "loqui-core-gtk.c"
#line 193 "loqui-core-gtk.gob"
static void loqui_core_gtk_save_accelmap (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 106 "loqui-core-gtk.c"
#line 217 "loqui-core-gtk.gob"
static gboolean loqui_core_gtk_check_should_upgrade (LoquiCoreGtk * self) G_GNUC_UNUSED;
#line 109 "loqui-core-gtk.c"

/* pointer to the class of our parent */
static LoquiCoreClass *parent_class = NULL;

/* Short form macros */
#define self_new loqui_core_gtk_new
#define self_load_stylerc loqui_core_gtk_load_stylerc
#define self_save_stylerc loqui_core_gtk_save_stylerc
#define self_get_stylerc_path loqui_core_gtk_get_stylerc_path
#define self_get_general_pref_path loqui_core_gtk_get_general_pref_path
#define self_make_program_dir loqui_core_gtk_make_program_dir
#define self_initialize_with_args loqui_core_gtk_initialize_with_args
#define self_load_accelmap loqui_core_gtk_load_accelmap
#define self_save_accelmap loqui_core_gtk_save_accelmap
#define self_load_general_pref loqui_core_gtk_load_general_pref
#define self_save_general_pref loqui_core_gtk_save_general_pref
#define self_check_should_upgrade loqui_core_gtk_check_should_upgrade
#define self_run loqui_core_gtk_run
#define self_get_app loqui_core_gtk_get_app
GType
loqui_core_gtk_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiCoreGtkClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_core_gtk_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiCoreGtk),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_core_gtk_init,
			NULL
		};

		type = g_type_register_static (LOQUI_TYPE_CORE, "LoquiCoreGtk", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiCoreGtk *)g_object_new(loqui_core_gtk_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiCoreGtk * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiCoreGtk *
GET_NEW_VARG (const char *first, ...)
{
	LoquiCoreGtk *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiCoreGtk *)g_object_new_valist (loqui_core_gtk_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::dispose"
	LoquiCoreGtk *self G_GNUC_UNUSED = LOQUI_CORE_GTK (obj_self);
#line 72 "loqui-core-gtk.gob"
	if(self->style_pref) { g_object_unref ((gpointer) self->style_pref); self->style_pref = NULL; }
#line 179 "loqui-core-gtk.c"
#line 74 "loqui-core-gtk.gob"
	if(self->protocol_manager) { g_object_unref ((gpointer) self->protocol_manager); self->protocol_manager = NULL; }
#line 182 "loqui-core-gtk.c"
#line 76 "loqui-core-gtk.gob"
	if(self->account_manager) { g_object_unref ((gpointer) self->account_manager); self->account_manager = NULL; }
#line 185 "loqui-core-gtk.c"
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
}
#undef __GOB_FUNCTION__

static void 
loqui_core_gtk_class_init (LoquiCoreGtkClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	LoquiCoreClass *loqui_core_class = (LoquiCoreClass *)c;

	parent_class = g_type_class_ref (LOQUI_TYPE_CORE);

#line 101 "loqui-core-gtk.gob"
	loqui_core_class->get_version_info = ___3_loqui_core_gtk_get_version_info;
#line 202 "loqui-core-gtk.c"
	g_object_class->dispose = ___dispose;
}
#undef __GOB_FUNCTION__
#line 85 "loqui-core-gtk.gob"
static void 
loqui_core_gtk_init (LoquiCoreGtk * self G_GNUC_UNUSED)
{
#line 210 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::init"
#line 71 "loqui-core-gtk.gob"
	self->style_pref =  loqui_pref_new() ;
#line 214 "loqui-core-gtk.c"
 {
#line 85 "loqui-core-gtk.gob"

		self->protocol_manager = loqui_protocol_manager_new();

		loqui_protocol_manager_register(self->protocol_manager, loqui_protocol_irc_get());
		loqui_protocol_manager_register(self->protocol_manager, loqui_protocol_ipmsg_get());
		/* loqui_protocol_manager_register(self->protocol_manager, loqui_protocol_msn_get()); */

		self->account_manager = loqui_account_manager_new(self->protocol_manager);
		loqui_core_set_notifier(LOQUI_CORE(self), LOQUI_NOTIFIER(loqui_notifier_gtk_new()));
	
#line 227 "loqui-core-gtk.c"
 }
}
#undef __GOB_FUNCTION__


#line 80 "loqui-core-gtk.gob"
LoquiCoreGtk * 
loqui_core_gtk_new (void)
{
#line 237 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::new"
{
#line 80 "loqui-core-gtk.gob"
	
		LoquiCoreGtk *ret = GET_NEW;
		return ret;
	}}
#line 245 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__


#line 101 "loqui-core-gtk.gob"
static gchar * 
___3_loqui_core_gtk_get_version_info (LoquiCore * self_core G_GNUC_UNUSED)
#line 252 "loqui-core-gtk.c"
#define PARENT_HANDLER(___self_core) \
	((LOQUI_CORE_CLASS(parent_class)->get_version_info)? \
		(* LOQUI_CORE_CLASS(parent_class)->get_version_info)(___self_core): \
		((gchar * )0))
{
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::get_version_info"
#line 101 "loqui-core-gtk.gob"
	g_return_val_if_fail (self_core != NULL, (gchar * )0);
#line 101 "loqui-core-gtk.gob"
	g_return_val_if_fail (LOQUI_IS_CORE (self_core), (gchar * )0);
#line 263 "loqui-core-gtk.c"
{
#line 101 "loqui-core-gtk.gob"
	
		/* Self *self; */
		gchar *str, *libinfo;

		libinfo = PARENT_HANDLER(self_core);
		str = g_strdup_printf("Loqui version %s (%s; GTK+ %d.%d.%d)",
				      VERSION, libinfo, gtk_major_version, gtk_minor_version, gtk_micro_version);
		g_free(libinfo);

		return str;
	}}
#line 277 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 113 "loqui-core-gtk.gob"
void 
loqui_core_gtk_load_stylerc (LoquiCoreGtk * self)
{
#line 285 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::load_stylerc"
#line 113 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 113 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 291 "loqui-core-gtk.c"
{
#line 113 "loqui-core-gtk.gob"
	
		gchar *path;

		path = self_get_stylerc_path(self);
		if (!loqui_pref_load_from_file(self->style_pref, path, G_KEY_FILE_NONE, NULL)) {
			g_warning(_("Failed to load %s"), path);
			g_free(path);
			return;
		}
		g_free(path);
	}}
#line 305 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 124 "loqui-core-gtk.gob"
void 
loqui_core_gtk_save_stylerc (LoquiCoreGtk * self)
{
#line 312 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::save_stylerc"
#line 124 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 124 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 318 "loqui-core-gtk.c"
{
#line 124 "loqui-core-gtk.gob"
	
		gchar *path;

		path = self_get_stylerc_path(self);
		if (!loqui_pref_save_to_file(self->style_pref, path, NULL)) {
			g_warning(_("Failed to save %s"), path);
			g_free(path);
			return;
		}
		g_free(path);
	}}
#line 332 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 136 "loqui-core-gtk.gob"
static gchar * 
loqui_core_gtk_get_stylerc_path (LoquiCoreGtk * self)
{
#line 339 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::get_stylerc_path"
#line 136 "loqui-core-gtk.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 136 "loqui-core-gtk.gob"
	g_return_val_if_fail (LOQUI_IS_CORE_GTK (self), (gchar * )0);
#line 345 "loqui-core-gtk.c"
{
#line 136 "loqui-core-gtk.gob"
	
		return g_build_filename(loqui_core_get_user_dir(LOQUI_CORE(self)),
					STYLERC_FILE, NULL);
	}}
#line 352 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 140 "loqui-core-gtk.gob"
static gchar * 
loqui_core_gtk_get_general_pref_path (LoquiCoreGtk * self)
{
#line 359 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::get_general_pref_path"
#line 140 "loqui-core-gtk.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 140 "loqui-core-gtk.gob"
	g_return_val_if_fail (LOQUI_IS_CORE_GTK (self), (gchar * )0);
#line 365 "loqui-core-gtk.c"
{
#line 140 "loqui-core-gtk.gob"
	
		return g_build_filename(loqui_core_get_user_dir(LOQUI_CORE(self)),
					GENERAL_PREF_FILENAME, NULL);
	}}
#line 372 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 145 "loqui-core-gtk.gob"
static void 
loqui_core_gtk_make_program_dir (LoquiCoreGtk * self)
{
#line 379 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::make_program_dir"
#line 145 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 145 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 385 "loqui-core-gtk.c"
{
#line 145 "loqui-core-gtk.gob"
	
		const gchar *dirname;
		gchar *log_dirname;

		dirname = loqui_core_get_user_dir(LOQUI_CORE(self));
		if(!g_file_test(dirname, G_FILE_TEST_EXISTS)) {
			loqui_utils_mkdir_and_chmod(dirname);
		}

		if(!g_file_test(dirname, G_FILE_TEST_IS_DIR)) {
			g_error(_("Invalid \"%s\""), dirname);
		}

		log_dirname = g_build_filename(dirname, LOG_DIR, NULL);
		if(!g_file_test(log_dirname, G_FILE_TEST_EXISTS))
			loqui_utils_mkdir_and_chmod(log_dirname);

		g_free(log_dirname);
	}}
#line 407 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 165 "loqui-core-gtk.gob"
void 
loqui_core_gtk_initialize_with_args (LoquiCoreGtk * self, int * argc, char ** argv[])
{
#line 414 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::initialize_with_args"
#line 165 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 165 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 420 "loqui-core-gtk.c"
{
#line 165 "loqui-core-gtk.gob"
	
		gchar *path;

		loqui_core_initialize(LOQUI_CORE(self));
		self_make_program_dir(self);

		gdk_threads_init();

		gtk_init(argc, argv);

		loqui_stock_init();

		path = g_build_filename(loqui_core_get_user_dir(loqui_get_core()), "gtkrc-2.0", NULL);
		gtk_rc_parse(path);
		g_free(path);
	}}
#line 439 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 182 "loqui-core-gtk.gob"
static void 
loqui_core_gtk_load_accelmap (LoquiCoreGtk * self)
{
#line 446 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::load_accelmap"
#line 182 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 182 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 452 "loqui-core-gtk.c"
{
#line 182 "loqui-core-gtk.gob"
	
		gchar *path;

		path = g_build_filename(loqui_core_get_user_dir(loqui_get_core()), ACCEL_MAP_FILE, NULL);

		gtk_accel_map_add_filter(SHORTCUT_CHANNEL_ENTRY_ACCEL_MAP_PREFIX "*");
		gtk_accel_map_load(path);

		g_free(path);
	}}
#line 465 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 193 "loqui-core-gtk.gob"
static void 
loqui_core_gtk_save_accelmap (LoquiCoreGtk * self)
{
#line 472 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::save_accelmap"
#line 193 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 193 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 478 "loqui-core-gtk.c"
{
#line 193 "loqui-core-gtk.gob"
	
		gchar *path;

		path = g_build_filename(loqui_core_get_user_dir(loqui_get_core()), ACCEL_MAP_FILE, NULL);
		gtk_accel_map_save(path);
		g_free(path);
	}}
#line 488 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 201 "loqui-core-gtk.gob"
void 
loqui_core_gtk_load_general_pref (LoquiCoreGtk * self)
{
#line 495 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::load_general_pref"
#line 201 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 201 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 501 "loqui-core-gtk.c"
{
#line 201 "loqui-core-gtk.gob"
	
		gchar *path;

		path = self_get_general_pref_path(self);
		loqui_pref_load_from_file(loqui_core_get_general_pref(LOQUI_CORE(self)), path, 0, NULL);
		g_free(path);
	}}
#line 511 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 209 "loqui-core-gtk.gob"
void 
loqui_core_gtk_save_general_pref (LoquiCoreGtk * self)
{
#line 518 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::save_general_pref"
#line 209 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 209 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 524 "loqui-core-gtk.c"
{
#line 209 "loqui-core-gtk.gob"
	
		gchar *path;

		path = self_get_general_pref_path(self);
		loqui_pref_save_to_file(loqui_core_get_general_pref(LOQUI_CORE(self)), path, NULL);
		g_free(path);
	}}
#line 534 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 217 "loqui-core-gtk.gob"
static gboolean 
loqui_core_gtk_check_should_upgrade (LoquiCoreGtk * self)
{
#line 541 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::check_should_upgrade"
#line 217 "loqui-core-gtk.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 217 "loqui-core-gtk.gob"
	g_return_val_if_fail (LOQUI_IS_CORE_GTK (self), (gboolean )0);
#line 547 "loqui-core-gtk.c"
{
#line 217 "loqui-core-gtk.gob"
	
		gchar *old_path;
		gchar *new_path;
		gboolean b;

		old_path = g_build_filename(loqui_core_get_user_dir(LOQUI_CORE(self)), "loquirc.xml", NULL);
		new_path = g_build_filename(loqui_core_get_user_dir(LOQUI_CORE(self)), "loquirc", NULL);

		b = g_file_test(old_path, G_FILE_TEST_EXISTS) && !g_file_test(new_path, G_FILE_TEST_EXISTS);
		g_free(old_path);
		g_free(new_path);

		return b;
	}}
#line 564 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 232 "loqui-core-gtk.gob"
void 
loqui_core_gtk_run (LoquiCoreGtk * self)
{
#line 571 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::run"
#line 232 "loqui-core-gtk.gob"
	g_return_if_fail (self != NULL);
#line 232 "loqui-core-gtk.gob"
	g_return_if_fail (LOQUI_IS_CORE_GTK (self));
#line 577 "loqui-core-gtk.c"
{
#line 232 "loqui-core-gtk.gob"
	
		if (self_check_should_upgrade(self)) {
			prefs_general_upgrader_upgrade();
		}
		self_load_general_pref(self);
		loqui_pref_set_boolean(loqui_get_general_pref(), "Dummy", "DummyBoolean", TRUE);

		self->app = LOQUI_APP(loqui_app_new(self->account_manager));
		self_load_stylerc(self);

		loqui_app_info_load_from_prefs_general(self->app->appinfo);
		loqui_app_info_update_string_idle(self->app->appinfo);

		self_load_accelmap(self);

		loqui_account_manager_load_accounts(self->account_manager);
		if(loqui_pref_get_with_default_boolean(loqui_get_general_pref(),
						       LOQUI_GENERAL_PREF_GTK_GROUP_GENERAL, "ConnectStartup",
						       LOQUI_GENERAL_PREF_GTK_DEFAULT_GENERAL_CONNECT_STARTUP, NULL))
			loqui_account_manager_connect_all_default(self->account_manager);

		gdk_threads_enter();

		if (loqui_account_manager_get_account_list(self->account_manager) == NULL) {
			account_list_dialog_open_for_connect(GTK_WINDOW(self->app), loqui_app_get_account_manager(self->app));
		}

		gtk_main();
		gdk_threads_leave();

		self_save_stylerc(self);
		self_save_accelmap(self);

		self_save_general_pref(self);
	}}
#line 615 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__

#line 268 "loqui-core-gtk.gob"
LoquiApp * 
loqui_core_gtk_get_app (LoquiCoreGtk * self)
{
#line 622 "loqui-core-gtk.c"
#define __GOB_FUNCTION__ "Loqui:Core:Gtk::get_app"
#line 268 "loqui-core-gtk.gob"
	g_return_val_if_fail (self != NULL, (LoquiApp * )0);
#line 268 "loqui-core-gtk.gob"
	g_return_val_if_fail (LOQUI_IS_CORE_GTK (self), (LoquiApp * )0);
#line 628 "loqui-core-gtk.c"
{
#line 269 "loqui-core-gtk.gob"
	
		return self->app;
	}}
#line 634 "loqui-core-gtk.c"
#undef __GOB_FUNCTION__
