package tests::OutputFormatsXMLTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::OutputFormats::XML;
use Lire::Config::OutputFormatSpec;
use Lire::PluginManager;
use Lire::Utils qw/tempdir/;
use File::Basename qw/dirname/;
use File::Path qw/rmtree/;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'testdir'} = dirname( __FILE__ ) ;
    $self->{'output_cfg'} =
      new Lire::Config::OutputFormatSpec( 'name' => 'output' )->instance();
    $self->{'tmpdir'} = tempdir( $self->name() . '_XXXXXX' );
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    rmtree( $self->{'tmpdir'} )
      unless $self->{'keep_tmpdir'};
}

sub create_plugin {
    return new Lire::OutputFormats::XML();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_xml_init";
}

sub test_format_report {
    my $self = $_[0];

    $self->test_registration_file();
    my $xml = Lire::PluginManager->get_plugin( 'output_format', 'xml' );

    my $report = "$self->{'tmpdir'}/report.xml";
    $xml->format_report( "$self->{'testdir'}/data/test-sqlite.xml", $report);
    $self->assert_num_equals( -s "$self->{'testdir'}/data/test-sqlite.xml",
                              -s $report );
}

sub test_mime_report {
   my $self = $_[0];

   $self->test_registration_file();
   my $xml = Lire::PluginManager->get_plugin( 'output_format', 'xml' );

   my $entity = $xml->mime_report( "$self->{'testdir'}/data/test-sqlite.xml" );
   $self->assert_isa( 'MIME::Entity', $entity );
   $self->assert_str_equals( 'text/xml', $entity->head()->mime_type() );
   $self->assert_str_equals( "quoted-printable\n",
                             $entity->head()->get( 'content-transfer-encoding' ) );
   $self->assert_str_equals( 'utf-8',
                             $entity->head()->mime_attr( 'content-type.charset' ) );
}

1;
