package tests::ConfigDlfConverterSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigScalarSpecTest/;

use Lire::PluginManager;

sub set_up {
    my $self = $_[0];

    $self->set_up_plugin_mgr();
    my $mgr = Lire::PluginManager->instance();
    $mgr->register_plugin( myconverter->new( 'converter1' ) );
    $mgr->register_plugin( myconverter->new( 'converter2' ) );
    $mgr->register_plugin( myconverter->new( 'converter3' ) );
    $mgr->register_plugin( myconverter->new( 'another_conv' ) );

    $self->SUPER::set_up();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub type {
    return "Lire::Config::DlfConverterSpec";
}

sub normalize_test_data {
    return (
            'converter1' => "converter1",
            'Converter1' => undef,
           );
}

sub valid_test_data {
    return qw/converter1 converter2 converter3/;
}

sub invalid_test_data {
    return qw/converter4/;
}

sub test_add {
    my $self = $_[0];

    $self->assert_dies( qr/Lire::Config::DlfConverterSpec cannot contain any components/,
                        sub { $self->{'spec'}->add() } );
}

sub test_options {
    my $self = $_[0];

    my @options = sort { $a->name() cmp $b->name() }
      $self->{'spec'}->options();

    $self->assert_num_equals( 4, scalar( @options ));
    $self->assert( UNIVERSAL::isa( $options[0], 'Lire::Config::OptionSpec' ),
                   'expected Lire::Config::OptionSpec instance: $option' );
    $self->assert_str_equals( 'another_conv', $options[0]->name() );
    $self->assert_str_equals( 'Another_conv', $options[0]->summary() );
    $self->assert_str_equals( '<para>Another_conv</para>',
                              $options[0]->description() );
}

package myconverter;

use base qw/Lire::DlfConverter/;

sub new {
    my ( $class, $name ) = @_;

    return bless \$name, $class;
}

sub name {
    return ${$_[0]};
}

sub title {
    return ucfirst ${$_[0]};
}

sub description {
    return '<para>' . ucfirst ${$_[0]} . '</para>';

}

1;
