package tests::ConfigChartSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigTypeSpecBase/;

use Lire::Config::ChartSpec;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub type {
    return 'Lire::Config::ChartSpec';
}

sub test_new {
    my $self = $_[0];

    $self->SUPER::test_new();

    my $spec = new Lire::Config::ChartSpec( 'name' => 'section' );
    $self->assert_str_equals( 'name', $spec->label_component() );

    my $components = [ $spec->components() ];
    $self->assert_num_equals( 6, scalar @$components );
    $self->assert_isa( 'Lire::Config::StringSpec', $components->[0] );
    $self->assert_str_equals( 'name', $components->[0]->name() );
    $self->assert_num_equals( 0, $components->[0]->required() );
    $self->assert_not_null( $components->[0]->summary() );
    $self->assert_not_null( $components->[0]->text_description() );

    $self->assert_isa( 'Lire::Config::StringSpec', $components->[1] );
    $self->assert_str_equals( 'title', $components->[1]->name() );
    $self->assert_num_equals( 0, $components->[1]->required() );
    $self->assert_not_null( $components->[1]->summary() );
    $self->assert_not_null( $components->[1]->text_description() );

    $self->assert_isa( 'Lire::Config::ChartTypeSpec', $components->[2] );
    $self->assert_str_equals( 'type', $components->[2]->name() );
    $self->assert_not_null( $components->[2]->summary() );
    $self->assert_not_null( $components->[2]->text_description() );

    $self->assert_isa( 'Lire::Config::ReferenceSpec', $components->[3] );
    $self->assert_str_equals( 'case_var', $components->[3]->name() );
    $self->assert_str_equals( 'categorical_variables',
                              $components->[3]->index() );
    $self->assert_not_null( $components->[3]->summary() );
    $self->assert_not_null( $components->[3]->text_description() );

    $self->assert_isa( 'Lire::Config::StringSpec', $components->[1] );
    $self->assert_str_equals( 'xlabel', $components->[4]->name() );
    $self->assert_num_equals( 0, $components->[4]->required() );
    $self->assert_not_null( $components->[4]->summary() );
    $self->assert_not_null( $components->[4]->text_description() );

    $self->assert_isa( 'Lire::Config::StringSpec', $components->[1] );
    $self->assert_str_equals( 'ylabel', $components->[5]->name() );
    $self->assert_num_equals( 0, $components->[5]->required() );
    $self->assert_not_null( $components->[5]->summary() );
    $self->assert_not_null( $components->[5]->text_description() );
}

sub test_instance {
    my $self = $_[0];

    $self->assert_isa( 'Lire::Report::ChartConfig',
                       $self->{'spec'}->instance() );
}

1;

