#    Copyright (C) 2013 Ahmet Öztürk (aoz_2@yahoo.com)
#
#    This file is part of Lifeograph.
#
#    Lifeograph is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Lifeograph is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.


include( ${CMAKE_SOURCE_DIR}/cmake/definitions.cmake )

find_program( XDG-MIME_EXE xdg-mime )
find_program( XDG-DESKTOP-MENU_EXE xdg-desktop-menu )
find_program( XDG-ICON_RES_EXE xdg-icon-resource )

execute_process( COMMAND ${XDG-MIME_EXE} install --novendor ${CMAKE_SOURCE_DIR}/lifeograph.xml )
execute_process( COMMAND ${XDG-ICON_RES_EXE} install --context mimetypes
                 --size 16 ${CMAKE_SOURCE_DIR}/icons/diary-16.png application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} install --context mimetypes
                 --size 32 ${CMAKE_SOURCE_DIR}/icons/diary-32.png application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} install --context mimetypes
                 --size 48 ${CMAKE_SOURCE_DIR}/icons/diary-48.png application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} install --context mimetypes
                 --size 64 ${CMAKE_SOURCE_DIR}/icons/diary-64.png application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} install --context mimetypes
                 --size 128 ${CMAKE_SOURCE_DIR}/icons/diary-128.png application-x-lifeographdiary )
execute_process( COMMAND ${XDG-DESKTOP-MENU_EXE} install --novendor ${desktop_file} )
execute_process( COMMAND ${XDG-MIME_EXE} default ${desktop_file} application/x-lifeographdiary )

