/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Emphasis;
import org.dbdoclet.trafo.tag.docbook.SimPara;

public class StrikeEditor extends Editor {

    @Override
	public EditorInstruction edit(EditorInstruction values) throws EditorException {

	setValues(super.edit(values));
	DocBookTagFactory dbfactory = values.getTagFactory();

	traverse(true);
	Emphasis emphasis = dbfactory.createEmphasis();
	emphasis.setRole("strikethrough");

	setCurrent(emphasis);

	if (emphasis.isValidParent(getParent()) == false) {

	    SimPara candidate = dbfactory.createSimPara();
	    candidate.setParentNode(getParent());

	    if (candidate.validate()) {

		getParent().appendChild(candidate);
		candidate.appendChild(getCurrent());
	    }

	} else {

	    getCurrent().setParentNode(getParent());
	    getParent().appendChild(getCurrent());
	}

	return finalizeValues();
    }
}
