/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS avx_256_single kernel generator.
 */
#include "gmxpre.h"

#include "config.h"

#include <math.h>

#include "../nb_kernel.h"
#include "gromacs/legacyheaders/types/simple.h"
#include "gromacs/math/vec.h"
#include "gromacs/legacyheaders/nrnb.h"

#include "gromacs/simd/math_x86_avx_256_single.h"
#include "kernelutil_x86_avx_256_single.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSw_VdwNone_GeomW4W4_VF_avx_256_single
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecEwSw_VdwNone_GeomW4W4_VF_avx_256_single
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D,E,F,G,H refer to j loop unrolling done with AVX, e.g. for the eight different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrE,jnrF,jnrG,jnrH;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              jnrlistE,jnrlistF,jnrlistG,jnrlistH;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              j_coord_offsetE,j_coord_offsetF,j_coord_offsetG,j_coord_offsetH;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD,*fjptrE,*fjptrF,*fjptrG,*fjptrH;
    real             scratch[4*DIM];
    __m256           tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    real *           vdwioffsetptr1;
    __m256           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    real *           vdwioffsetptr2;
    __m256           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    real *           vdwioffsetptr3;
    __m256           ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx1A,vdwjidx1B,vdwjidx1C,vdwjidx1D,vdwjidx1E,vdwjidx1F,vdwjidx1G,vdwjidx1H;
    __m256           jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B,vdwjidx2C,vdwjidx2D,vdwjidx2E,vdwjidx2F,vdwjidx2G,vdwjidx2H;
    __m256           jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B,vdwjidx3C,vdwjidx3D,vdwjidx3E,vdwjidx3F,vdwjidx3G,vdwjidx3H;
    __m256           jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    __m256           dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m256           dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m256           dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    __m256           dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m256           dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m256           dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    __m256           dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    __m256           dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    __m256           dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    __m256           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m256i          ewitab;
    __m128i          ewitab_lo,ewitab_hi;
    __m256           ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    __m256           beta,beta2,beta3,zeta2,pmecorrF,pmecorrV,rinv3;
    real             *ewtab;
    __m256           rswitch,swV3,swV4,swV5,swF2,swF3,swF4,d,d2,sw,dsw;
    real             rswitch_scalar,d_scalar;
    __m256           dummy_mask,cutoff_mask;
    __m256           signbit = _mm256_castsi256_ps( _mm256_set1_epi32(0x80000000) );
    __m256           one     = _mm256_set1_ps(1.0);
    __m256           two     = _mm256_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm256_set1_ps(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = _mm256_set1_ps(fr->ic->sh_ewald);
    beta             = _mm256_set1_ps(fr->ic->ewaldcoeff_q);
    beta2            = _mm256_mul_ps(beta,beta);
    beta3            = _mm256_mul_ps(beta,beta2);

    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm256_set1_ps(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm256_set1_ps(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+1]));
    iq2              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+2]));
    iq3              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+3]));

    jq1              = _mm256_set1_ps(charge[inr+1]);
    jq2              = _mm256_set1_ps(charge[inr+2]);
    jq3              = _mm256_set1_ps(charge[inr+3]);
    qq11             = _mm256_mul_ps(iq1,jq1);
    qq12             = _mm256_mul_ps(iq1,jq2);
    qq13             = _mm256_mul_ps(iq1,jq3);
    qq21             = _mm256_mul_ps(iq2,jq1);
    qq22             = _mm256_mul_ps(iq2,jq2);
    qq23             = _mm256_mul_ps(iq2,jq3);
    qq31             = _mm256_mul_ps(iq3,jq1);
    qq32             = _mm256_mul_ps(iq3,jq2);
    qq33             = _mm256_mul_ps(iq3,jq3);

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm256_set1_ps(rcutoff_scalar);
    rcutoff2         = _mm256_mul_ps(rcutoff,rcutoff);

    rswitch_scalar   = fr->rcoulomb_switch;
    rswitch          = _mm256_set1_ps(rswitch_scalar);
    /* Setup switch parameters */
    d_scalar         = rcutoff_scalar-rswitch_scalar;
    d                = _mm256_set1_ps(d_scalar);
    swV3             = _mm256_set1_ps(-10.0/(d_scalar*d_scalar*d_scalar));
    swV4             = _mm256_set1_ps( 15.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swV5             = _mm256_set1_ps( -6.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));
    swF2             = _mm256_set1_ps(-30.0/(d_scalar*d_scalar*d_scalar));
    swF3             = _mm256_set1_ps( 60.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swF4             = _mm256_set1_ps(-30.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = jnrE = jnrF = jnrG = jnrH = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;
    j_coord_offsetE = 0;
    j_coord_offsetF = 0;
    j_coord_offsetG = 0;
    j_coord_offsetH = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm256_load_shift_and_3rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset+DIM,
                                                    &ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix1             = _mm256_setzero_ps();
        fiy1             = _mm256_setzero_ps();
        fiz1             = _mm256_setzero_ps();
        fix2             = _mm256_setzero_ps();
        fiy2             = _mm256_setzero_ps();
        fiz2             = _mm256_setzero_ps();
        fix3             = _mm256_setzero_ps();
        fiy3             = _mm256_setzero_ps();
        fiz3             = _mm256_setzero_ps();

        /* Reset potential sums */
        velecsum         = _mm256_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+7]>=0; jidx+=8)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            jnrE             = jjnr[jidx+4];
            jnrF             = jjnr[jidx+5];
            jnrG             = jjnr[jidx+6];
            jnrH             = jjnr[jidx+7];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_3rvec_8ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                                 x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                                 x+j_coord_offsetE+DIM,x+j_coord_offsetF+DIM,
                                                 x+j_coord_offsetG+DIM,x+j_coord_offsetH+DIM,
                                                 &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm256_sub_ps(ix1,jx1);
            dy11             = _mm256_sub_ps(iy1,jy1);
            dz11             = _mm256_sub_ps(iz1,jz1);
            dx12             = _mm256_sub_ps(ix1,jx2);
            dy12             = _mm256_sub_ps(iy1,jy2);
            dz12             = _mm256_sub_ps(iz1,jz2);
            dx13             = _mm256_sub_ps(ix1,jx3);
            dy13             = _mm256_sub_ps(iy1,jy3);
            dz13             = _mm256_sub_ps(iz1,jz3);
            dx21             = _mm256_sub_ps(ix2,jx1);
            dy21             = _mm256_sub_ps(iy2,jy1);
            dz21             = _mm256_sub_ps(iz2,jz1);
            dx22             = _mm256_sub_ps(ix2,jx2);
            dy22             = _mm256_sub_ps(iy2,jy2);
            dz22             = _mm256_sub_ps(iz2,jz2);
            dx23             = _mm256_sub_ps(ix2,jx3);
            dy23             = _mm256_sub_ps(iy2,jy3);
            dz23             = _mm256_sub_ps(iz2,jz3);
            dx31             = _mm256_sub_ps(ix3,jx1);
            dy31             = _mm256_sub_ps(iy3,jy1);
            dz31             = _mm256_sub_ps(iz3,jz1);
            dx32             = _mm256_sub_ps(ix3,jx2);
            dy32             = _mm256_sub_ps(iy3,jy2);
            dz32             = _mm256_sub_ps(iz3,jz2);
            dx33             = _mm256_sub_ps(ix3,jx3);
            dy33             = _mm256_sub_ps(iy3,jy3);
            dz33             = _mm256_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm256_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm256_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm256_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm256_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm256_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm256_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm256_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm256_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm256_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = gmx_mm256_invsqrt_ps(rsq11);
            rinv12           = gmx_mm256_invsqrt_ps(rsq12);
            rinv13           = gmx_mm256_invsqrt_ps(rsq13);
            rinv21           = gmx_mm256_invsqrt_ps(rsq21);
            rinv22           = gmx_mm256_invsqrt_ps(rsq22);
            rinv23           = gmx_mm256_invsqrt_ps(rsq23);
            rinv31           = gmx_mm256_invsqrt_ps(rsq31);
            rinv32           = gmx_mm256_invsqrt_ps(rsq32);
            rinv33           = gmx_mm256_invsqrt_ps(rsq33);

            rinvsq11         = _mm256_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm256_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm256_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm256_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm256_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm256_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm256_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm256_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm256_mul_ps(rinv33,rinv33);

            fjx1             = _mm256_setzero_ps();
            fjy1             = _mm256_setzero_ps();
            fjz1             = _mm256_setzero_ps();
            fjx2             = _mm256_setzero_ps();
            fjy2             = _mm256_setzero_ps();
            fjz2             = _mm256_setzero_ps();
            fjx3             = _mm256_setzero_ps();
            fjy3             = _mm256_setzero_ps();
            fjz3             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm256_mul_ps(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq11);
            rinv3            = _mm256_mul_ps(rinvsq11,rinv11);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq11,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv11,pmecorrV);
            velec            = _mm256_mul_ps(qq11,velec);
            
            d                = _mm256_sub_ps(r11,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv11,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq11,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx11);
            ty               = _mm256_mul_ps(fscal,dy11);
            tz               = _mm256_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm256_mul_ps(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq12);
            rinv3            = _mm256_mul_ps(rinvsq12,rinv12);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq12,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv12,pmecorrV);
            velec            = _mm256_mul_ps(qq12,velec);
            
            d                = _mm256_sub_ps(r12,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv12,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq12,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx12);
            ty               = _mm256_mul_ps(fscal,dy12);
            tz               = _mm256_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm256_mul_ps(rsq13,rinv13);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq13);
            rinv3            = _mm256_mul_ps(rinvsq13,rinv13);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq13,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv13,pmecorrV);
            velec            = _mm256_mul_ps(qq13,velec);
            
            d                = _mm256_sub_ps(r13,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv13,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq13,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx13);
            ty               = _mm256_mul_ps(fscal,dy13);
            tz               = _mm256_mul_ps(fscal,dz13);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm256_mul_ps(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq21);
            rinv3            = _mm256_mul_ps(rinvsq21,rinv21);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq21,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv21,pmecorrV);
            velec            = _mm256_mul_ps(qq21,velec);
            
            d                = _mm256_sub_ps(r21,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv21,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq21,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx21);
            ty               = _mm256_mul_ps(fscal,dy21);
            tz               = _mm256_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm256_mul_ps(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq22);
            rinv3            = _mm256_mul_ps(rinvsq22,rinv22);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq22,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv22,pmecorrV);
            velec            = _mm256_mul_ps(qq22,velec);
            
            d                = _mm256_sub_ps(r22,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv22,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq22,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx22);
            ty               = _mm256_mul_ps(fscal,dy22);
            tz               = _mm256_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm256_mul_ps(rsq23,rinv23);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq23);
            rinv3            = _mm256_mul_ps(rinvsq23,rinv23);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq23,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv23,pmecorrV);
            velec            = _mm256_mul_ps(qq23,velec);
            
            d                = _mm256_sub_ps(r23,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv23,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq23,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx23);
            ty               = _mm256_mul_ps(fscal,dy23);
            tz               = _mm256_mul_ps(fscal,dz23);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm256_mul_ps(rsq31,rinv31);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq31);
            rinv3            = _mm256_mul_ps(rinvsq31,rinv31);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq31,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv31,pmecorrV);
            velec            = _mm256_mul_ps(qq31,velec);
            
            d                = _mm256_sub_ps(r31,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv31,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq31,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx31);
            ty               = _mm256_mul_ps(fscal,dy31);
            tz               = _mm256_mul_ps(fscal,dz31);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm256_mul_ps(rsq32,rinv32);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq32);
            rinv3            = _mm256_mul_ps(rinvsq32,rinv32);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq32,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv32,pmecorrV);
            velec            = _mm256_mul_ps(qq32,velec);
            
            d                = _mm256_sub_ps(r32,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv32,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq32,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx32);
            ty               = _mm256_mul_ps(fscal,dy32);
            tz               = _mm256_mul_ps(fscal,dz32);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm256_mul_ps(rsq33,rinv33);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq33);
            rinv3            = _mm256_mul_ps(rinvsq33,rinv33);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq33,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv33,pmecorrV);
            velec            = _mm256_mul_ps(qq33,velec);
            
            d                = _mm256_sub_ps(r33,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv33,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq33,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx33);
            ty               = _mm256_mul_ps(fscal,dy33);
            tz               = _mm256_mul_ps(fscal,dz33);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;
            fjptrE             = f+j_coord_offsetE;
            fjptrF             = f+j_coord_offsetF;
            fjptrG             = f+j_coord_offsetG;
            fjptrH             = f+j_coord_offsetH;

            gmx_mm256_decrement_3rvec_8ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                      fjptrE+DIM,fjptrF+DIM,fjptrG+DIM,fjptrH+DIM,
                                                      fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 972 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            jnrlistE         = jjnr[jidx+4];
            jnrlistF         = jjnr[jidx+5];
            jnrlistG         = jjnr[jidx+6];
            jnrlistH         = jjnr[jidx+7];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm256_set_m128(gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx+4)),_mm_setzero_si128())),
                                            gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128())));
                                            
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            jnrE       = (jnrlistE>=0) ? jnrlistE : 0;
            jnrF       = (jnrlistF>=0) ? jnrlistF : 0;
            jnrG       = (jnrlistG>=0) ? jnrlistG : 0;
            jnrH       = (jnrlistH>=0) ? jnrlistH : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_3rvec_8ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                                 x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                                 x+j_coord_offsetE+DIM,x+j_coord_offsetF+DIM,
                                                 x+j_coord_offsetG+DIM,x+j_coord_offsetH+DIM,
                                                 &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm256_sub_ps(ix1,jx1);
            dy11             = _mm256_sub_ps(iy1,jy1);
            dz11             = _mm256_sub_ps(iz1,jz1);
            dx12             = _mm256_sub_ps(ix1,jx2);
            dy12             = _mm256_sub_ps(iy1,jy2);
            dz12             = _mm256_sub_ps(iz1,jz2);
            dx13             = _mm256_sub_ps(ix1,jx3);
            dy13             = _mm256_sub_ps(iy1,jy3);
            dz13             = _mm256_sub_ps(iz1,jz3);
            dx21             = _mm256_sub_ps(ix2,jx1);
            dy21             = _mm256_sub_ps(iy2,jy1);
            dz21             = _mm256_sub_ps(iz2,jz1);
            dx22             = _mm256_sub_ps(ix2,jx2);
            dy22             = _mm256_sub_ps(iy2,jy2);
            dz22             = _mm256_sub_ps(iz2,jz2);
            dx23             = _mm256_sub_ps(ix2,jx3);
            dy23             = _mm256_sub_ps(iy2,jy3);
            dz23             = _mm256_sub_ps(iz2,jz3);
            dx31             = _mm256_sub_ps(ix3,jx1);
            dy31             = _mm256_sub_ps(iy3,jy1);
            dz31             = _mm256_sub_ps(iz3,jz1);
            dx32             = _mm256_sub_ps(ix3,jx2);
            dy32             = _mm256_sub_ps(iy3,jy2);
            dz32             = _mm256_sub_ps(iz3,jz2);
            dx33             = _mm256_sub_ps(ix3,jx3);
            dy33             = _mm256_sub_ps(iy3,jy3);
            dz33             = _mm256_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm256_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm256_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm256_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm256_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm256_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm256_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm256_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm256_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm256_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = gmx_mm256_invsqrt_ps(rsq11);
            rinv12           = gmx_mm256_invsqrt_ps(rsq12);
            rinv13           = gmx_mm256_invsqrt_ps(rsq13);
            rinv21           = gmx_mm256_invsqrt_ps(rsq21);
            rinv22           = gmx_mm256_invsqrt_ps(rsq22);
            rinv23           = gmx_mm256_invsqrt_ps(rsq23);
            rinv31           = gmx_mm256_invsqrt_ps(rsq31);
            rinv32           = gmx_mm256_invsqrt_ps(rsq32);
            rinv33           = gmx_mm256_invsqrt_ps(rsq33);

            rinvsq11         = _mm256_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm256_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm256_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm256_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm256_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm256_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm256_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm256_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm256_mul_ps(rinv33,rinv33);

            fjx1             = _mm256_setzero_ps();
            fjy1             = _mm256_setzero_ps();
            fjz1             = _mm256_setzero_ps();
            fjx2             = _mm256_setzero_ps();
            fjy2             = _mm256_setzero_ps();
            fjz2             = _mm256_setzero_ps();
            fjx3             = _mm256_setzero_ps();
            fjy3             = _mm256_setzero_ps();
            fjz3             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm256_mul_ps(rsq11,rinv11);
            r11              = _mm256_andnot_ps(dummy_mask,r11);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq11);
            rinv3            = _mm256_mul_ps(rinvsq11,rinv11);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq11,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv11,pmecorrV);
            velec            = _mm256_mul_ps(qq11,velec);
            
            d                = _mm256_sub_ps(r11,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv11,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq11,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx11);
            ty               = _mm256_mul_ps(fscal,dy11);
            tz               = _mm256_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm256_mul_ps(rsq12,rinv12);
            r12              = _mm256_andnot_ps(dummy_mask,r12);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq12);
            rinv3            = _mm256_mul_ps(rinvsq12,rinv12);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq12,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv12,pmecorrV);
            velec            = _mm256_mul_ps(qq12,velec);
            
            d                = _mm256_sub_ps(r12,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv12,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq12,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx12);
            ty               = _mm256_mul_ps(fscal,dy12);
            tz               = _mm256_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm256_mul_ps(rsq13,rinv13);
            r13              = _mm256_andnot_ps(dummy_mask,r13);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq13);
            rinv3            = _mm256_mul_ps(rinvsq13,rinv13);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq13,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv13,pmecorrV);
            velec            = _mm256_mul_ps(qq13,velec);
            
            d                = _mm256_sub_ps(r13,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv13,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq13,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx13);
            ty               = _mm256_mul_ps(fscal,dy13);
            tz               = _mm256_mul_ps(fscal,dz13);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm256_mul_ps(rsq21,rinv21);
            r21              = _mm256_andnot_ps(dummy_mask,r21);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq21);
            rinv3            = _mm256_mul_ps(rinvsq21,rinv21);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq21,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv21,pmecorrV);
            velec            = _mm256_mul_ps(qq21,velec);
            
            d                = _mm256_sub_ps(r21,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv21,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq21,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx21);
            ty               = _mm256_mul_ps(fscal,dy21);
            tz               = _mm256_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm256_mul_ps(rsq22,rinv22);
            r22              = _mm256_andnot_ps(dummy_mask,r22);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq22);
            rinv3            = _mm256_mul_ps(rinvsq22,rinv22);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq22,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv22,pmecorrV);
            velec            = _mm256_mul_ps(qq22,velec);
            
            d                = _mm256_sub_ps(r22,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv22,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq22,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx22);
            ty               = _mm256_mul_ps(fscal,dy22);
            tz               = _mm256_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm256_mul_ps(rsq23,rinv23);
            r23              = _mm256_andnot_ps(dummy_mask,r23);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq23);
            rinv3            = _mm256_mul_ps(rinvsq23,rinv23);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq23,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv23,pmecorrV);
            velec            = _mm256_mul_ps(qq23,velec);
            
            d                = _mm256_sub_ps(r23,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv23,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq23,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx23);
            ty               = _mm256_mul_ps(fscal,dy23);
            tz               = _mm256_mul_ps(fscal,dz23);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm256_mul_ps(rsq31,rinv31);
            r31              = _mm256_andnot_ps(dummy_mask,r31);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq31);
            rinv3            = _mm256_mul_ps(rinvsq31,rinv31);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq31,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv31,pmecorrV);
            velec            = _mm256_mul_ps(qq31,velec);
            
            d                = _mm256_sub_ps(r31,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv31,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq31,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx31);
            ty               = _mm256_mul_ps(fscal,dy31);
            tz               = _mm256_mul_ps(fscal,dz31);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm256_mul_ps(rsq32,rinv32);
            r32              = _mm256_andnot_ps(dummy_mask,r32);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq32);
            rinv3            = _mm256_mul_ps(rinvsq32,rinv32);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq32,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv32,pmecorrV);
            velec            = _mm256_mul_ps(qq32,velec);
            
            d                = _mm256_sub_ps(r32,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv32,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq32,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx32);
            ty               = _mm256_mul_ps(fscal,dy32);
            tz               = _mm256_mul_ps(fscal,dz32);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm256_mul_ps(rsq33,rinv33);
            r33              = _mm256_andnot_ps(dummy_mask,r33);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq33);
            rinv3            = _mm256_mul_ps(rinvsq33,rinv33);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq33,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv33,pmecorrV);
            velec            = _mm256_mul_ps(qq33,velec);
            
            d                = _mm256_sub_ps(r33,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv33,_mm256_mul_ps(velec,dsw)) );
            velec            = _mm256_mul_ps(velec,sw);
            cutoff_mask      = _mm256_cmp_ps(rsq33,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_ps(velec,cutoff_mask);
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx33);
            ty               = _mm256_mul_ps(fscal,dy33);
            tz               = _mm256_mul_ps(fscal,dz33);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;
            fjptrE             = (jnrlistE>=0) ? f+j_coord_offsetE : scratch;
            fjptrF             = (jnrlistF>=0) ? f+j_coord_offsetF : scratch;
            fjptrG             = (jnrlistG>=0) ? f+j_coord_offsetG : scratch;
            fjptrH             = (jnrlistH>=0) ? f+j_coord_offsetH : scratch;

            gmx_mm256_decrement_3rvec_8ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                      fjptrE+DIM,fjptrF+DIM,fjptrG+DIM,fjptrH+DIM,
                                                      fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 981 flops */
        }

        /* End of innermost loop */

        gmx_mm256_update_iforce_3atom_swizzle_ps(fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                                 f+i_coord_offset+DIM,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm256_update_1pot_ps(velecsum,kernel_data->energygrp_elec+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 19 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W4W4_VF,outeriter*19 + inneriter*981);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSw_VdwNone_GeomW4W4_F_avx_256_single
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecEwSw_VdwNone_GeomW4W4_F_avx_256_single
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D,E,F,G,H refer to j loop unrolling done with AVX, e.g. for the eight different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrE,jnrF,jnrG,jnrH;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              jnrlistE,jnrlistF,jnrlistG,jnrlistH;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              j_coord_offsetE,j_coord_offsetF,j_coord_offsetG,j_coord_offsetH;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD,*fjptrE,*fjptrF,*fjptrG,*fjptrH;
    real             scratch[4*DIM];
    __m256           tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    real *           vdwioffsetptr1;
    __m256           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    real *           vdwioffsetptr2;
    __m256           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    real *           vdwioffsetptr3;
    __m256           ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx1A,vdwjidx1B,vdwjidx1C,vdwjidx1D,vdwjidx1E,vdwjidx1F,vdwjidx1G,vdwjidx1H;
    __m256           jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B,vdwjidx2C,vdwjidx2D,vdwjidx2E,vdwjidx2F,vdwjidx2G,vdwjidx2H;
    __m256           jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B,vdwjidx3C,vdwjidx3D,vdwjidx3E,vdwjidx3F,vdwjidx3G,vdwjidx3H;
    __m256           jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    __m256           dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m256           dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m256           dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    __m256           dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m256           dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m256           dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    __m256           dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    __m256           dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    __m256           dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    __m256           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m256i          ewitab;
    __m128i          ewitab_lo,ewitab_hi;
    __m256           ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    __m256           beta,beta2,beta3,zeta2,pmecorrF,pmecorrV,rinv3;
    real             *ewtab;
    __m256           rswitch,swV3,swV4,swV5,swF2,swF3,swF4,d,d2,sw,dsw;
    real             rswitch_scalar,d_scalar;
    __m256           dummy_mask,cutoff_mask;
    __m256           signbit = _mm256_castsi256_ps( _mm256_set1_epi32(0x80000000) );
    __m256           one     = _mm256_set1_ps(1.0);
    __m256           two     = _mm256_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm256_set1_ps(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = _mm256_set1_ps(fr->ic->sh_ewald);
    beta             = _mm256_set1_ps(fr->ic->ewaldcoeff_q);
    beta2            = _mm256_mul_ps(beta,beta);
    beta3            = _mm256_mul_ps(beta,beta2);

    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm256_set1_ps(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm256_set1_ps(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+1]));
    iq2              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+2]));
    iq3              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+3]));

    jq1              = _mm256_set1_ps(charge[inr+1]);
    jq2              = _mm256_set1_ps(charge[inr+2]);
    jq3              = _mm256_set1_ps(charge[inr+3]);
    qq11             = _mm256_mul_ps(iq1,jq1);
    qq12             = _mm256_mul_ps(iq1,jq2);
    qq13             = _mm256_mul_ps(iq1,jq3);
    qq21             = _mm256_mul_ps(iq2,jq1);
    qq22             = _mm256_mul_ps(iq2,jq2);
    qq23             = _mm256_mul_ps(iq2,jq3);
    qq31             = _mm256_mul_ps(iq3,jq1);
    qq32             = _mm256_mul_ps(iq3,jq2);
    qq33             = _mm256_mul_ps(iq3,jq3);

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm256_set1_ps(rcutoff_scalar);
    rcutoff2         = _mm256_mul_ps(rcutoff,rcutoff);

    rswitch_scalar   = fr->rcoulomb_switch;
    rswitch          = _mm256_set1_ps(rswitch_scalar);
    /* Setup switch parameters */
    d_scalar         = rcutoff_scalar-rswitch_scalar;
    d                = _mm256_set1_ps(d_scalar);
    swV3             = _mm256_set1_ps(-10.0/(d_scalar*d_scalar*d_scalar));
    swV4             = _mm256_set1_ps( 15.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swV5             = _mm256_set1_ps( -6.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));
    swF2             = _mm256_set1_ps(-30.0/(d_scalar*d_scalar*d_scalar));
    swF3             = _mm256_set1_ps( 60.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swF4             = _mm256_set1_ps(-30.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = jnrE = jnrF = jnrG = jnrH = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;
    j_coord_offsetE = 0;
    j_coord_offsetF = 0;
    j_coord_offsetG = 0;
    j_coord_offsetH = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm256_load_shift_and_3rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset+DIM,
                                                    &ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix1             = _mm256_setzero_ps();
        fiy1             = _mm256_setzero_ps();
        fiz1             = _mm256_setzero_ps();
        fix2             = _mm256_setzero_ps();
        fiy2             = _mm256_setzero_ps();
        fiz2             = _mm256_setzero_ps();
        fix3             = _mm256_setzero_ps();
        fiy3             = _mm256_setzero_ps();
        fiz3             = _mm256_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+7]>=0; jidx+=8)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            jnrE             = jjnr[jidx+4];
            jnrF             = jjnr[jidx+5];
            jnrG             = jjnr[jidx+6];
            jnrH             = jjnr[jidx+7];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_3rvec_8ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                                 x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                                 x+j_coord_offsetE+DIM,x+j_coord_offsetF+DIM,
                                                 x+j_coord_offsetG+DIM,x+j_coord_offsetH+DIM,
                                                 &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm256_sub_ps(ix1,jx1);
            dy11             = _mm256_sub_ps(iy1,jy1);
            dz11             = _mm256_sub_ps(iz1,jz1);
            dx12             = _mm256_sub_ps(ix1,jx2);
            dy12             = _mm256_sub_ps(iy1,jy2);
            dz12             = _mm256_sub_ps(iz1,jz2);
            dx13             = _mm256_sub_ps(ix1,jx3);
            dy13             = _mm256_sub_ps(iy1,jy3);
            dz13             = _mm256_sub_ps(iz1,jz3);
            dx21             = _mm256_sub_ps(ix2,jx1);
            dy21             = _mm256_sub_ps(iy2,jy1);
            dz21             = _mm256_sub_ps(iz2,jz1);
            dx22             = _mm256_sub_ps(ix2,jx2);
            dy22             = _mm256_sub_ps(iy2,jy2);
            dz22             = _mm256_sub_ps(iz2,jz2);
            dx23             = _mm256_sub_ps(ix2,jx3);
            dy23             = _mm256_sub_ps(iy2,jy3);
            dz23             = _mm256_sub_ps(iz2,jz3);
            dx31             = _mm256_sub_ps(ix3,jx1);
            dy31             = _mm256_sub_ps(iy3,jy1);
            dz31             = _mm256_sub_ps(iz3,jz1);
            dx32             = _mm256_sub_ps(ix3,jx2);
            dy32             = _mm256_sub_ps(iy3,jy2);
            dz32             = _mm256_sub_ps(iz3,jz2);
            dx33             = _mm256_sub_ps(ix3,jx3);
            dy33             = _mm256_sub_ps(iy3,jy3);
            dz33             = _mm256_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm256_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm256_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm256_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm256_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm256_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm256_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm256_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm256_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm256_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = gmx_mm256_invsqrt_ps(rsq11);
            rinv12           = gmx_mm256_invsqrt_ps(rsq12);
            rinv13           = gmx_mm256_invsqrt_ps(rsq13);
            rinv21           = gmx_mm256_invsqrt_ps(rsq21);
            rinv22           = gmx_mm256_invsqrt_ps(rsq22);
            rinv23           = gmx_mm256_invsqrt_ps(rsq23);
            rinv31           = gmx_mm256_invsqrt_ps(rsq31);
            rinv32           = gmx_mm256_invsqrt_ps(rsq32);
            rinv33           = gmx_mm256_invsqrt_ps(rsq33);

            rinvsq11         = _mm256_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm256_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm256_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm256_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm256_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm256_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm256_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm256_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm256_mul_ps(rinv33,rinv33);

            fjx1             = _mm256_setzero_ps();
            fjy1             = _mm256_setzero_ps();
            fjz1             = _mm256_setzero_ps();
            fjx2             = _mm256_setzero_ps();
            fjy2             = _mm256_setzero_ps();
            fjz2             = _mm256_setzero_ps();
            fjx3             = _mm256_setzero_ps();
            fjy3             = _mm256_setzero_ps();
            fjz3             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm256_mul_ps(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq11);
            rinv3            = _mm256_mul_ps(rinvsq11,rinv11);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq11,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv11,pmecorrV);
            velec            = _mm256_mul_ps(qq11,velec);
            
            d                = _mm256_sub_ps(r11,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv11,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq11,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx11);
            ty               = _mm256_mul_ps(fscal,dy11);
            tz               = _mm256_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm256_mul_ps(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq12);
            rinv3            = _mm256_mul_ps(rinvsq12,rinv12);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq12,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv12,pmecorrV);
            velec            = _mm256_mul_ps(qq12,velec);
            
            d                = _mm256_sub_ps(r12,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv12,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq12,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx12);
            ty               = _mm256_mul_ps(fscal,dy12);
            tz               = _mm256_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm256_mul_ps(rsq13,rinv13);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq13);
            rinv3            = _mm256_mul_ps(rinvsq13,rinv13);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq13,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv13,pmecorrV);
            velec            = _mm256_mul_ps(qq13,velec);
            
            d                = _mm256_sub_ps(r13,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv13,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq13,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx13);
            ty               = _mm256_mul_ps(fscal,dy13);
            tz               = _mm256_mul_ps(fscal,dz13);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm256_mul_ps(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq21);
            rinv3            = _mm256_mul_ps(rinvsq21,rinv21);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq21,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv21,pmecorrV);
            velec            = _mm256_mul_ps(qq21,velec);
            
            d                = _mm256_sub_ps(r21,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv21,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq21,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx21);
            ty               = _mm256_mul_ps(fscal,dy21);
            tz               = _mm256_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm256_mul_ps(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq22);
            rinv3            = _mm256_mul_ps(rinvsq22,rinv22);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq22,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv22,pmecorrV);
            velec            = _mm256_mul_ps(qq22,velec);
            
            d                = _mm256_sub_ps(r22,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv22,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq22,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx22);
            ty               = _mm256_mul_ps(fscal,dy22);
            tz               = _mm256_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm256_mul_ps(rsq23,rinv23);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq23);
            rinv3            = _mm256_mul_ps(rinvsq23,rinv23);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq23,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv23,pmecorrV);
            velec            = _mm256_mul_ps(qq23,velec);
            
            d                = _mm256_sub_ps(r23,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv23,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq23,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx23);
            ty               = _mm256_mul_ps(fscal,dy23);
            tz               = _mm256_mul_ps(fscal,dz23);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm256_mul_ps(rsq31,rinv31);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq31);
            rinv3            = _mm256_mul_ps(rinvsq31,rinv31);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq31,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv31,pmecorrV);
            velec            = _mm256_mul_ps(qq31,velec);
            
            d                = _mm256_sub_ps(r31,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv31,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq31,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx31);
            ty               = _mm256_mul_ps(fscal,dy31);
            tz               = _mm256_mul_ps(fscal,dz31);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm256_mul_ps(rsq32,rinv32);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq32);
            rinv3            = _mm256_mul_ps(rinvsq32,rinv32);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq32,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv32,pmecorrV);
            velec            = _mm256_mul_ps(qq32,velec);
            
            d                = _mm256_sub_ps(r32,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv32,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq32,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx32);
            ty               = _mm256_mul_ps(fscal,dy32);
            tz               = _mm256_mul_ps(fscal,dz32);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm256_mul_ps(rsq33,rinv33);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq33);
            rinv3            = _mm256_mul_ps(rinvsq33,rinv33);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq33,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv33,pmecorrV);
            velec            = _mm256_mul_ps(qq33,velec);
            
            d                = _mm256_sub_ps(r33,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv33,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq33,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx33);
            ty               = _mm256_mul_ps(fscal,dy33);
            tz               = _mm256_mul_ps(fscal,dz33);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;
            fjptrE             = f+j_coord_offsetE;
            fjptrF             = f+j_coord_offsetF;
            fjptrG             = f+j_coord_offsetG;
            fjptrH             = f+j_coord_offsetH;

            gmx_mm256_decrement_3rvec_8ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                      fjptrE+DIM,fjptrF+DIM,fjptrG+DIM,fjptrH+DIM,
                                                      fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 945 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            jnrlistE         = jjnr[jidx+4];
            jnrlistF         = jjnr[jidx+5];
            jnrlistG         = jjnr[jidx+6];
            jnrlistH         = jjnr[jidx+7];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm256_set_m128(gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx+4)),_mm_setzero_si128())),
                                            gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128())));
                                            
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            jnrE       = (jnrlistE>=0) ? jnrlistE : 0;
            jnrF       = (jnrlistF>=0) ? jnrlistF : 0;
            jnrG       = (jnrlistG>=0) ? jnrlistG : 0;
            jnrH       = (jnrlistH>=0) ? jnrlistH : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_3rvec_8ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                                 x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                                 x+j_coord_offsetE+DIM,x+j_coord_offsetF+DIM,
                                                 x+j_coord_offsetG+DIM,x+j_coord_offsetH+DIM,
                                                 &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm256_sub_ps(ix1,jx1);
            dy11             = _mm256_sub_ps(iy1,jy1);
            dz11             = _mm256_sub_ps(iz1,jz1);
            dx12             = _mm256_sub_ps(ix1,jx2);
            dy12             = _mm256_sub_ps(iy1,jy2);
            dz12             = _mm256_sub_ps(iz1,jz2);
            dx13             = _mm256_sub_ps(ix1,jx3);
            dy13             = _mm256_sub_ps(iy1,jy3);
            dz13             = _mm256_sub_ps(iz1,jz3);
            dx21             = _mm256_sub_ps(ix2,jx1);
            dy21             = _mm256_sub_ps(iy2,jy1);
            dz21             = _mm256_sub_ps(iz2,jz1);
            dx22             = _mm256_sub_ps(ix2,jx2);
            dy22             = _mm256_sub_ps(iy2,jy2);
            dz22             = _mm256_sub_ps(iz2,jz2);
            dx23             = _mm256_sub_ps(ix2,jx3);
            dy23             = _mm256_sub_ps(iy2,jy3);
            dz23             = _mm256_sub_ps(iz2,jz3);
            dx31             = _mm256_sub_ps(ix3,jx1);
            dy31             = _mm256_sub_ps(iy3,jy1);
            dz31             = _mm256_sub_ps(iz3,jz1);
            dx32             = _mm256_sub_ps(ix3,jx2);
            dy32             = _mm256_sub_ps(iy3,jy2);
            dz32             = _mm256_sub_ps(iz3,jz2);
            dx33             = _mm256_sub_ps(ix3,jx3);
            dy33             = _mm256_sub_ps(iy3,jy3);
            dz33             = _mm256_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm256_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm256_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm256_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm256_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm256_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm256_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm256_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm256_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm256_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = gmx_mm256_invsqrt_ps(rsq11);
            rinv12           = gmx_mm256_invsqrt_ps(rsq12);
            rinv13           = gmx_mm256_invsqrt_ps(rsq13);
            rinv21           = gmx_mm256_invsqrt_ps(rsq21);
            rinv22           = gmx_mm256_invsqrt_ps(rsq22);
            rinv23           = gmx_mm256_invsqrt_ps(rsq23);
            rinv31           = gmx_mm256_invsqrt_ps(rsq31);
            rinv32           = gmx_mm256_invsqrt_ps(rsq32);
            rinv33           = gmx_mm256_invsqrt_ps(rsq33);

            rinvsq11         = _mm256_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm256_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm256_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm256_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm256_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm256_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm256_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm256_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm256_mul_ps(rinv33,rinv33);

            fjx1             = _mm256_setzero_ps();
            fjy1             = _mm256_setzero_ps();
            fjz1             = _mm256_setzero_ps();
            fjx2             = _mm256_setzero_ps();
            fjy2             = _mm256_setzero_ps();
            fjz2             = _mm256_setzero_ps();
            fjx3             = _mm256_setzero_ps();
            fjy3             = _mm256_setzero_ps();
            fjz3             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm256_mul_ps(rsq11,rinv11);
            r11              = _mm256_andnot_ps(dummy_mask,r11);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq11);
            rinv3            = _mm256_mul_ps(rinvsq11,rinv11);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq11,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv11,pmecorrV);
            velec            = _mm256_mul_ps(qq11,velec);
            
            d                = _mm256_sub_ps(r11,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv11,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq11,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx11);
            ty               = _mm256_mul_ps(fscal,dy11);
            tz               = _mm256_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm256_mul_ps(rsq12,rinv12);
            r12              = _mm256_andnot_ps(dummy_mask,r12);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq12);
            rinv3            = _mm256_mul_ps(rinvsq12,rinv12);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq12,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv12,pmecorrV);
            velec            = _mm256_mul_ps(qq12,velec);
            
            d                = _mm256_sub_ps(r12,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv12,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq12,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx12);
            ty               = _mm256_mul_ps(fscal,dy12);
            tz               = _mm256_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm256_mul_ps(rsq13,rinv13);
            r13              = _mm256_andnot_ps(dummy_mask,r13);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq13);
            rinv3            = _mm256_mul_ps(rinvsq13,rinv13);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq13,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv13,pmecorrV);
            velec            = _mm256_mul_ps(qq13,velec);
            
            d                = _mm256_sub_ps(r13,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv13,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq13,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx13);
            ty               = _mm256_mul_ps(fscal,dy13);
            tz               = _mm256_mul_ps(fscal,dz13);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm256_mul_ps(rsq21,rinv21);
            r21              = _mm256_andnot_ps(dummy_mask,r21);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq21);
            rinv3            = _mm256_mul_ps(rinvsq21,rinv21);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq21,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv21,pmecorrV);
            velec            = _mm256_mul_ps(qq21,velec);
            
            d                = _mm256_sub_ps(r21,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv21,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq21,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx21);
            ty               = _mm256_mul_ps(fscal,dy21);
            tz               = _mm256_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm256_mul_ps(rsq22,rinv22);
            r22              = _mm256_andnot_ps(dummy_mask,r22);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq22);
            rinv3            = _mm256_mul_ps(rinvsq22,rinv22);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq22,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv22,pmecorrV);
            velec            = _mm256_mul_ps(qq22,velec);
            
            d                = _mm256_sub_ps(r22,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv22,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq22,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx22);
            ty               = _mm256_mul_ps(fscal,dy22);
            tz               = _mm256_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm256_mul_ps(rsq23,rinv23);
            r23              = _mm256_andnot_ps(dummy_mask,r23);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq23);
            rinv3            = _mm256_mul_ps(rinvsq23,rinv23);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq23,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv23,pmecorrV);
            velec            = _mm256_mul_ps(qq23,velec);
            
            d                = _mm256_sub_ps(r23,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv23,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq23,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx23);
            ty               = _mm256_mul_ps(fscal,dy23);
            tz               = _mm256_mul_ps(fscal,dz23);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm256_mul_ps(rsq31,rinv31);
            r31              = _mm256_andnot_ps(dummy_mask,r31);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq31);
            rinv3            = _mm256_mul_ps(rinvsq31,rinv31);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq31,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv31,pmecorrV);
            velec            = _mm256_mul_ps(qq31,velec);
            
            d                = _mm256_sub_ps(r31,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv31,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq31,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx31);
            ty               = _mm256_mul_ps(fscal,dy31);
            tz               = _mm256_mul_ps(fscal,dz31);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx1             = _mm256_add_ps(fjx1,tx);
            fjy1             = _mm256_add_ps(fjy1,ty);
            fjz1             = _mm256_add_ps(fjz1,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm256_mul_ps(rsq32,rinv32);
            r32              = _mm256_andnot_ps(dummy_mask,r32);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq32);
            rinv3            = _mm256_mul_ps(rinvsq32,rinv32);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq32,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv32,pmecorrV);
            velec            = _mm256_mul_ps(qq32,velec);
            
            d                = _mm256_sub_ps(r32,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv32,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq32,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx32);
            ty               = _mm256_mul_ps(fscal,dy32);
            tz               = _mm256_mul_ps(fscal,dz32);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx2             = _mm256_add_ps(fjx2,tx);
            fjy2             = _mm256_add_ps(fjy2,ty);
            fjz2             = _mm256_add_ps(fjz2,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm256_mul_ps(rsq33,rinv33);
            r33              = _mm256_andnot_ps(dummy_mask,r33);

            /* EWALD ELECTROSTATICS */
            
            /* Analytical PME correction */
            zeta2            = _mm256_mul_ps(beta2,rsq33);
            rinv3            = _mm256_mul_ps(rinvsq33,rinv33);
            pmecorrF         = gmx_mm256_pmecorrF_ps(zeta2);
            felec            = _mm256_add_ps( _mm256_mul_ps(pmecorrF,beta3), rinv3);
            felec            = _mm256_mul_ps(qq33,felec);
            pmecorrV         = gmx_mm256_pmecorrV_ps(zeta2);
            pmecorrV         = _mm256_mul_ps(pmecorrV,beta);
            velec            = _mm256_sub_ps(rinv33,pmecorrV);
            velec            = _mm256_mul_ps(qq33,velec);
            
            d                = _mm256_sub_ps(r33,rswitch);
            d                = _mm256_max_ps(d,_mm256_setzero_ps());
            d2               = _mm256_mul_ps(d,d);
            sw               = _mm256_add_ps(one,_mm256_mul_ps(d2,_mm256_mul_ps(d,_mm256_add_ps(swV3,_mm256_mul_ps(d,_mm256_add_ps(swV4,_mm256_mul_ps(d,swV5)))))));

            dsw              = _mm256_mul_ps(d2,_mm256_add_ps(swF2,_mm256_mul_ps(d,_mm256_add_ps(swF3,_mm256_mul_ps(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_ps( _mm256_mul_ps(felec,sw) , _mm256_mul_ps(rinv33,_mm256_mul_ps(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_ps(rsq33,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_ps(fscal,cutoff_mask);

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx33);
            ty               = _mm256_mul_ps(fscal,dy33);
            tz               = _mm256_mul_ps(fscal,dz33);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx3             = _mm256_add_ps(fjx3,tx);
            fjy3             = _mm256_add_ps(fjy3,ty);
            fjz3             = _mm256_add_ps(fjz3,tz);

            }

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;
            fjptrE             = (jnrlistE>=0) ? f+j_coord_offsetE : scratch;
            fjptrF             = (jnrlistF>=0) ? f+j_coord_offsetF : scratch;
            fjptrG             = (jnrlistG>=0) ? f+j_coord_offsetG : scratch;
            fjptrH             = (jnrlistH>=0) ? f+j_coord_offsetH : scratch;

            gmx_mm256_decrement_3rvec_8ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                      fjptrE+DIM,fjptrF+DIM,fjptrG+DIM,fjptrH+DIM,
                                                      fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 954 flops */
        }

        /* End of innermost loop */

        gmx_mm256_update_iforce_3atom_swizzle_ps(fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                                 f+i_coord_offset+DIM,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W4W4_F,outeriter*18 + inneriter*954);
}
