/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS avx_256_single kernel generator.
 */
#include "gmxpre.h"

#include "config.h"

#include <math.h>

#include "../nb_kernel.h"
#include "gromacs/legacyheaders/types/simple.h"
#include "gromacs/math/vec.h"
#include "gromacs/legacyheaders/nrnb.h"

#include "gromacs/simd/math_x86_avx_256_single.h"
#include "kernelutil_x86_avx_256_single.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecCoul_VdwCSTab_GeomW4P1_VF_avx_256_single
 * Electrostatics interaction: Coulomb
 * VdW interaction:            CubicSplineTable
 * Geometry:                   Water4-Particle
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecCoul_VdwCSTab_GeomW4P1_VF_avx_256_single
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D,E,F,G,H refer to j loop unrolling done with AVX, e.g. for the eight different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrE,jnrF,jnrG,jnrH;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              jnrlistE,jnrlistF,jnrlistG,jnrlistH;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              j_coord_offsetE,j_coord_offsetF,j_coord_offsetG,j_coord_offsetH;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD,*fjptrE,*fjptrF,*fjptrG,*fjptrH;
    real             scratch[4*DIM];
    __m256           tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    real *           vdwioffsetptr0;
    __m256           ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    real *           vdwioffsetptr1;
    __m256           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    real *           vdwioffsetptr2;
    __m256           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    real *           vdwioffsetptr3;
    __m256           ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx0A,vdwjidx0B,vdwjidx0C,vdwjidx0D,vdwjidx0E,vdwjidx0F,vdwjidx0G,vdwjidx0H;
    __m256           jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m256           dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m256           dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m256           dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m256           dx30,dy30,dz30,rsq30,rinv30,rinvsq30,r30,qq30,c6_30,c12_30;
    __m256           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m256           rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m256           one_sixth   = _mm256_set1_ps(1.0/6.0);
    __m256           one_twelfth = _mm256_set1_ps(1.0/12.0);
    __m256i          vfitab;
    __m128i          vfitab_lo,vfitab_hi;
    __m128i          ifour       = _mm_set1_epi32(4);
    __m256           rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF;
    real             *vftab;
    __m256           dummy_mask,cutoff_mask;
    __m256           signbit = _mm256_castsi256_ps( _mm256_set1_epi32(0x80000000) );
    __m256           one     = _mm256_set1_ps(1.0);
    __m256           two     = _mm256_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm256_set1_ps(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    vftab            = kernel_data->table_vdw->data;
    vftabscale       = _mm256_set1_ps(kernel_data->table_vdw->scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+1]));
    iq2              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+2]));
    iq3              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+3]));
    vdwioffsetptr0   = vdwparam+2*nvdwtype*vdwtype[inr+0];

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = jnrE = jnrF = jnrG = jnrH = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;
    j_coord_offsetE = 0;
    j_coord_offsetF = 0;
    j_coord_offsetG = 0;
    j_coord_offsetH = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm256_load_shift_and_4rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset,
                                                    &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix0             = _mm256_setzero_ps();
        fiy0             = _mm256_setzero_ps();
        fiz0             = _mm256_setzero_ps();
        fix1             = _mm256_setzero_ps();
        fiy1             = _mm256_setzero_ps();
        fiz1             = _mm256_setzero_ps();
        fix2             = _mm256_setzero_ps();
        fiy2             = _mm256_setzero_ps();
        fiz2             = _mm256_setzero_ps();
        fix3             = _mm256_setzero_ps();
        fiy3             = _mm256_setzero_ps();
        fiz3             = _mm256_setzero_ps();

        /* Reset potential sums */
        velecsum         = _mm256_setzero_ps();
        vvdwsum          = _mm256_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+7]>=0; jidx+=8)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            jnrE             = jjnr[jidx+4];
            jnrF             = jjnr[jidx+5];
            jnrG             = jjnr[jidx+6];
            jnrH             = jjnr[jidx+7];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_8ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 x+j_coord_offsetE,x+j_coord_offsetF,
                                                 x+j_coord_offsetG,x+j_coord_offsetH,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_ps(ix0,jx0);
            dy00             = _mm256_sub_ps(iy0,jy0);
            dz00             = _mm256_sub_ps(iz0,jz0);
            dx10             = _mm256_sub_ps(ix1,jx0);
            dy10             = _mm256_sub_ps(iy1,jy0);
            dz10             = _mm256_sub_ps(iz1,jz0);
            dx20             = _mm256_sub_ps(ix2,jx0);
            dy20             = _mm256_sub_ps(iy2,jy0);
            dz20             = _mm256_sub_ps(iz2,jz0);
            dx30             = _mm256_sub_ps(ix3,jx0);
            dy30             = _mm256_sub_ps(iy3,jy0);
            dz30             = _mm256_sub_ps(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_ps(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_ps(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_ps(dx20,dy20,dz20);
            rsq30            = gmx_mm256_calc_rsq_ps(dx30,dy30,dz30);

            rinv00           = gmx_mm256_invsqrt_ps(rsq00);
            rinv10           = gmx_mm256_invsqrt_ps(rsq10);
            rinv20           = gmx_mm256_invsqrt_ps(rsq20);
            rinv30           = gmx_mm256_invsqrt_ps(rsq30);

            rinvsq10         = _mm256_mul_ps(rinv10,rinv10);
            rinvsq20         = _mm256_mul_ps(rinv20,rinv20);
            rinvsq30         = _mm256_mul_ps(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_8real_swizzle_ps(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0,
                                                                 charge+jnrE+0,charge+jnrF+0,
                                                                 charge+jnrG+0,charge+jnrH+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];
            vdwjidx0E        = 2*vdwtype[jnrE+0];
            vdwjidx0F        = 2*vdwtype[jnrF+0];
            vdwjidx0G        = 2*vdwtype[jnrG+0];
            vdwjidx0H        = 2*vdwtype[jnrH+0];

            fjx0             = _mm256_setzero_ps();
            fjy0             = _mm256_setzero_ps();
            fjz0             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm256_mul_ps(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm256_load_8pair_swizzle_ps(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            vdwioffsetptr0+vdwjidx0E,
                                            vdwioffsetptr0+vdwjidx0F,
                                            vdwioffsetptr0+vdwjidx0G,
                                            vdwioffsetptr0+vdwjidx0H,
                                            &c6_00,&c12_00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm256_mul_ps(r00,vftabscale);
            vfitab           = _mm256_cvttps_epi32(rt);
            vfeps            = _mm256_sub_ps(rt,_mm256_round_ps(rt, _MM_FROUND_FLOOR));
            /*         AVX1 does not support 256-bit integer operations, so now we go to 128-bit mode... */
            vfitab_lo        = _mm256_extractf128_si256(vfitab,0x0);
            vfitab_hi        = _mm256_extractf128_si256(vfitab,0x1);
            vfitab_lo        = _mm_slli_epi32(vfitab_lo,3);
            vfitab_hi        = _mm_slli_epi32(vfitab_hi,3);

            /* CUBIC SPLINE TABLE DISPERSION */
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            VV               = _mm256_add_ps(Y,_mm256_mul_ps(vfeps,Fp));
            vvdw6            = _mm256_mul_ps(c6_00,VV);
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw6            = _mm256_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab_lo        = _mm_add_epi32(vfitab_lo,ifour);
            vfitab_hi        = _mm_add_epi32(vfitab_hi,ifour);
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            VV               = _mm256_add_ps(Y,_mm256_mul_ps(vfeps,Fp));
            vvdw12           = _mm256_mul_ps(c12_00,VV);
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw12           = _mm256_mul_ps(c12_00,FF);
            vvdw             = _mm256_add_ps(vvdw12,vvdw6);
            fvdw             = _mm256_xor_ps(signbit,_mm256_mul_ps(_mm256_add_ps(fvdw6,fvdw12),_mm256_mul_ps(vftabscale,rinv00)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            vvdwsum          = _mm256_add_ps(vvdwsum,vvdw);

            fscal            = fvdw;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx00);
            ty               = _mm256_mul_ps(fscal,dy00);
            tz               = _mm256_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_ps(fix0,tx);
            fiy0             = _mm256_add_ps(fiy0,ty);
            fiz0             = _mm256_add_ps(fiz0,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_ps(iq1,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq10,rinv10);
            felec            = _mm256_mul_ps(velec,rinvsq10);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx10);
            ty               = _mm256_mul_ps(fscal,dy10);
            tz               = _mm256_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_ps(iq2,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq20,rinv20);
            felec            = _mm256_mul_ps(velec,rinvsq20);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx20);
            ty               = _mm256_mul_ps(fscal,dy20);
            tz               = _mm256_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm256_mul_ps(iq3,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq30,rinv30);
            felec            = _mm256_mul_ps(velec,rinvsq30);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx30);
            ty               = _mm256_mul_ps(fscal,dy30);
            tz               = _mm256_mul_ps(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;
            fjptrE             = f+j_coord_offsetE;
            fjptrF             = f+j_coord_offsetF;
            fjptrG             = f+j_coord_offsetG;
            fjptrH             = f+j_coord_offsetH;

            gmx_mm256_decrement_1rvec_8ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,fjptrE,fjptrF,fjptrG,fjptrH,fjx0,fjy0,fjz0);

            /* Inner loop uses 140 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            jnrlistE         = jjnr[jidx+4];
            jnrlistF         = jjnr[jidx+5];
            jnrlistG         = jjnr[jidx+6];
            jnrlistH         = jjnr[jidx+7];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm256_set_m128(gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx+4)),_mm_setzero_si128())),
                                            gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128())));
                                            
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            jnrE       = (jnrlistE>=0) ? jnrlistE : 0;
            jnrF       = (jnrlistF>=0) ? jnrlistF : 0;
            jnrG       = (jnrlistG>=0) ? jnrlistG : 0;
            jnrH       = (jnrlistH>=0) ? jnrlistH : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_8ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 x+j_coord_offsetE,x+j_coord_offsetF,
                                                 x+j_coord_offsetG,x+j_coord_offsetH,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_ps(ix0,jx0);
            dy00             = _mm256_sub_ps(iy0,jy0);
            dz00             = _mm256_sub_ps(iz0,jz0);
            dx10             = _mm256_sub_ps(ix1,jx0);
            dy10             = _mm256_sub_ps(iy1,jy0);
            dz10             = _mm256_sub_ps(iz1,jz0);
            dx20             = _mm256_sub_ps(ix2,jx0);
            dy20             = _mm256_sub_ps(iy2,jy0);
            dz20             = _mm256_sub_ps(iz2,jz0);
            dx30             = _mm256_sub_ps(ix3,jx0);
            dy30             = _mm256_sub_ps(iy3,jy0);
            dz30             = _mm256_sub_ps(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_ps(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_ps(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_ps(dx20,dy20,dz20);
            rsq30            = gmx_mm256_calc_rsq_ps(dx30,dy30,dz30);

            rinv00           = gmx_mm256_invsqrt_ps(rsq00);
            rinv10           = gmx_mm256_invsqrt_ps(rsq10);
            rinv20           = gmx_mm256_invsqrt_ps(rsq20);
            rinv30           = gmx_mm256_invsqrt_ps(rsq30);

            rinvsq10         = _mm256_mul_ps(rinv10,rinv10);
            rinvsq20         = _mm256_mul_ps(rinv20,rinv20);
            rinvsq30         = _mm256_mul_ps(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_8real_swizzle_ps(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0,
                                                                 charge+jnrE+0,charge+jnrF+0,
                                                                 charge+jnrG+0,charge+jnrH+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];
            vdwjidx0E        = 2*vdwtype[jnrE+0];
            vdwjidx0F        = 2*vdwtype[jnrF+0];
            vdwjidx0G        = 2*vdwtype[jnrG+0];
            vdwjidx0H        = 2*vdwtype[jnrH+0];

            fjx0             = _mm256_setzero_ps();
            fjy0             = _mm256_setzero_ps();
            fjz0             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm256_mul_ps(rsq00,rinv00);
            r00              = _mm256_andnot_ps(dummy_mask,r00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm256_load_8pair_swizzle_ps(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            vdwioffsetptr0+vdwjidx0E,
                                            vdwioffsetptr0+vdwjidx0F,
                                            vdwioffsetptr0+vdwjidx0G,
                                            vdwioffsetptr0+vdwjidx0H,
                                            &c6_00,&c12_00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm256_mul_ps(r00,vftabscale);
            vfitab           = _mm256_cvttps_epi32(rt);
            vfeps            = _mm256_sub_ps(rt,_mm256_round_ps(rt, _MM_FROUND_FLOOR));
            /*         AVX1 does not support 256-bit integer operations, so now we go to 128-bit mode... */
            vfitab_lo        = _mm256_extractf128_si256(vfitab,0x0);
            vfitab_hi        = _mm256_extractf128_si256(vfitab,0x1);
            vfitab_lo        = _mm_slli_epi32(vfitab_lo,3);
            vfitab_hi        = _mm_slli_epi32(vfitab_hi,3);

            /* CUBIC SPLINE TABLE DISPERSION */
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            VV               = _mm256_add_ps(Y,_mm256_mul_ps(vfeps,Fp));
            vvdw6            = _mm256_mul_ps(c6_00,VV);
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw6            = _mm256_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab_lo        = _mm_add_epi32(vfitab_lo,ifour);
            vfitab_hi        = _mm_add_epi32(vfitab_hi,ifour);
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            VV               = _mm256_add_ps(Y,_mm256_mul_ps(vfeps,Fp));
            vvdw12           = _mm256_mul_ps(c12_00,VV);
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw12           = _mm256_mul_ps(c12_00,FF);
            vvdw             = _mm256_add_ps(vvdw12,vvdw6);
            fvdw             = _mm256_xor_ps(signbit,_mm256_mul_ps(_mm256_add_ps(fvdw6,fvdw12),_mm256_mul_ps(vftabscale,rinv00)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            vvdw             = _mm256_andnot_ps(dummy_mask,vvdw);
            vvdwsum          = _mm256_add_ps(vvdwsum,vvdw);

            fscal            = fvdw;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx00);
            ty               = _mm256_mul_ps(fscal,dy00);
            tz               = _mm256_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_ps(fix0,tx);
            fiy0             = _mm256_add_ps(fiy0,ty);
            fiz0             = _mm256_add_ps(fiz0,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_ps(iq1,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq10,rinv10);
            felec            = _mm256_mul_ps(velec,rinvsq10);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx10);
            ty               = _mm256_mul_ps(fscal,dy10);
            tz               = _mm256_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_ps(iq2,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq20,rinv20);
            felec            = _mm256_mul_ps(velec,rinvsq20);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx20);
            ty               = _mm256_mul_ps(fscal,dy20);
            tz               = _mm256_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm256_mul_ps(iq3,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq30,rinv30);
            felec            = _mm256_mul_ps(velec,rinvsq30);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_andnot_ps(dummy_mask,velec);
            velecsum         = _mm256_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx30);
            ty               = _mm256_mul_ps(fscal,dy30);
            tz               = _mm256_mul_ps(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;
            fjptrE             = (jnrlistE>=0) ? f+j_coord_offsetE : scratch;
            fjptrF             = (jnrlistF>=0) ? f+j_coord_offsetF : scratch;
            fjptrG             = (jnrlistG>=0) ? f+j_coord_offsetG : scratch;
            fjptrH             = (jnrlistH>=0) ? f+j_coord_offsetH : scratch;

            gmx_mm256_decrement_1rvec_8ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,fjptrE,fjptrF,fjptrG,fjptrH,fjx0,fjy0,fjz0);

            /* Inner loop uses 141 flops */
        }

        /* End of innermost loop */

        gmx_mm256_update_iforce_4atom_swizzle_ps(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                                 f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm256_update_1pot_ps(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_mm256_update_1pot_ps(vvdwsum,kernel_data->energygrp_vdw+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 26 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W4_VF,outeriter*26 + inneriter*141);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecCoul_VdwCSTab_GeomW4P1_F_avx_256_single
 * Electrostatics interaction: Coulomb
 * VdW interaction:            CubicSplineTable
 * Geometry:                   Water4-Particle
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecCoul_VdwCSTab_GeomW4P1_F_avx_256_single
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D,E,F,G,H refer to j loop unrolling done with AVX, e.g. for the eight different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrE,jnrF,jnrG,jnrH;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              jnrlistE,jnrlistF,jnrlistG,jnrlistH;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              j_coord_offsetE,j_coord_offsetF,j_coord_offsetG,j_coord_offsetH;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD,*fjptrE,*fjptrF,*fjptrG,*fjptrH;
    real             scratch[4*DIM];
    __m256           tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    real *           vdwioffsetptr0;
    __m256           ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    real *           vdwioffsetptr1;
    __m256           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    real *           vdwioffsetptr2;
    __m256           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    real *           vdwioffsetptr3;
    __m256           ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx0A,vdwjidx0B,vdwjidx0C,vdwjidx0D,vdwjidx0E,vdwjidx0F,vdwjidx0G,vdwjidx0H;
    __m256           jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m256           dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m256           dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m256           dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m256           dx30,dy30,dz30,rsq30,rinv30,rinvsq30,r30,qq30,c6_30,c12_30;
    __m256           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m256           rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m256           one_sixth   = _mm256_set1_ps(1.0/6.0);
    __m256           one_twelfth = _mm256_set1_ps(1.0/12.0);
    __m256i          vfitab;
    __m128i          vfitab_lo,vfitab_hi;
    __m128i          ifour       = _mm_set1_epi32(4);
    __m256           rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF;
    real             *vftab;
    __m256           dummy_mask,cutoff_mask;
    __m256           signbit = _mm256_castsi256_ps( _mm256_set1_epi32(0x80000000) );
    __m256           one     = _mm256_set1_ps(1.0);
    __m256           two     = _mm256_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm256_set1_ps(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    vftab            = kernel_data->table_vdw->data;
    vftabscale       = _mm256_set1_ps(kernel_data->table_vdw->scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+1]));
    iq2              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+2]));
    iq3              = _mm256_mul_ps(facel,_mm256_set1_ps(charge[inr+3]));
    vdwioffsetptr0   = vdwparam+2*nvdwtype*vdwtype[inr+0];

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = jnrE = jnrF = jnrG = jnrH = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;
    j_coord_offsetE = 0;
    j_coord_offsetF = 0;
    j_coord_offsetG = 0;
    j_coord_offsetH = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm256_load_shift_and_4rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset,
                                                    &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix0             = _mm256_setzero_ps();
        fiy0             = _mm256_setzero_ps();
        fiz0             = _mm256_setzero_ps();
        fix1             = _mm256_setzero_ps();
        fiy1             = _mm256_setzero_ps();
        fiz1             = _mm256_setzero_ps();
        fix2             = _mm256_setzero_ps();
        fiy2             = _mm256_setzero_ps();
        fiz2             = _mm256_setzero_ps();
        fix3             = _mm256_setzero_ps();
        fiy3             = _mm256_setzero_ps();
        fiz3             = _mm256_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+7]>=0; jidx+=8)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            jnrE             = jjnr[jidx+4];
            jnrF             = jjnr[jidx+5];
            jnrG             = jjnr[jidx+6];
            jnrH             = jjnr[jidx+7];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_8ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 x+j_coord_offsetE,x+j_coord_offsetF,
                                                 x+j_coord_offsetG,x+j_coord_offsetH,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_ps(ix0,jx0);
            dy00             = _mm256_sub_ps(iy0,jy0);
            dz00             = _mm256_sub_ps(iz0,jz0);
            dx10             = _mm256_sub_ps(ix1,jx0);
            dy10             = _mm256_sub_ps(iy1,jy0);
            dz10             = _mm256_sub_ps(iz1,jz0);
            dx20             = _mm256_sub_ps(ix2,jx0);
            dy20             = _mm256_sub_ps(iy2,jy0);
            dz20             = _mm256_sub_ps(iz2,jz0);
            dx30             = _mm256_sub_ps(ix3,jx0);
            dy30             = _mm256_sub_ps(iy3,jy0);
            dz30             = _mm256_sub_ps(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_ps(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_ps(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_ps(dx20,dy20,dz20);
            rsq30            = gmx_mm256_calc_rsq_ps(dx30,dy30,dz30);

            rinv00           = gmx_mm256_invsqrt_ps(rsq00);
            rinv10           = gmx_mm256_invsqrt_ps(rsq10);
            rinv20           = gmx_mm256_invsqrt_ps(rsq20);
            rinv30           = gmx_mm256_invsqrt_ps(rsq30);

            rinvsq10         = _mm256_mul_ps(rinv10,rinv10);
            rinvsq20         = _mm256_mul_ps(rinv20,rinv20);
            rinvsq30         = _mm256_mul_ps(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_8real_swizzle_ps(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0,
                                                                 charge+jnrE+0,charge+jnrF+0,
                                                                 charge+jnrG+0,charge+jnrH+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];
            vdwjidx0E        = 2*vdwtype[jnrE+0];
            vdwjidx0F        = 2*vdwtype[jnrF+0];
            vdwjidx0G        = 2*vdwtype[jnrG+0];
            vdwjidx0H        = 2*vdwtype[jnrH+0];

            fjx0             = _mm256_setzero_ps();
            fjy0             = _mm256_setzero_ps();
            fjz0             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm256_mul_ps(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm256_load_8pair_swizzle_ps(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            vdwioffsetptr0+vdwjidx0E,
                                            vdwioffsetptr0+vdwjidx0F,
                                            vdwioffsetptr0+vdwjidx0G,
                                            vdwioffsetptr0+vdwjidx0H,
                                            &c6_00,&c12_00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm256_mul_ps(r00,vftabscale);
            vfitab           = _mm256_cvttps_epi32(rt);
            vfeps            = _mm256_sub_ps(rt,_mm256_round_ps(rt, _MM_FROUND_FLOOR));
            /*         AVX1 does not support 256-bit integer operations, so now we go to 128-bit mode... */
            vfitab_lo        = _mm256_extractf128_si256(vfitab,0x0);
            vfitab_hi        = _mm256_extractf128_si256(vfitab,0x1);
            vfitab_lo        = _mm_slli_epi32(vfitab_lo,3);
            vfitab_hi        = _mm_slli_epi32(vfitab_hi,3);

            /* CUBIC SPLINE TABLE DISPERSION */
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw6            = _mm256_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab_lo        = _mm_add_epi32(vfitab_lo,ifour);
            vfitab_hi        = _mm_add_epi32(vfitab_hi,ifour);
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw12           = _mm256_mul_ps(c12_00,FF);
            fvdw             = _mm256_xor_ps(signbit,_mm256_mul_ps(_mm256_add_ps(fvdw6,fvdw12),_mm256_mul_ps(vftabscale,rinv00)));

            fscal            = fvdw;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx00);
            ty               = _mm256_mul_ps(fscal,dy00);
            tz               = _mm256_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_ps(fix0,tx);
            fiy0             = _mm256_add_ps(fiy0,ty);
            fiz0             = _mm256_add_ps(fiz0,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_ps(iq1,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq10,rinv10);
            felec            = _mm256_mul_ps(velec,rinvsq10);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx10);
            ty               = _mm256_mul_ps(fscal,dy10);
            tz               = _mm256_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_ps(iq2,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq20,rinv20);
            felec            = _mm256_mul_ps(velec,rinvsq20);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx20);
            ty               = _mm256_mul_ps(fscal,dy20);
            tz               = _mm256_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm256_mul_ps(iq3,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq30,rinv30);
            felec            = _mm256_mul_ps(velec,rinvsq30);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx30);
            ty               = _mm256_mul_ps(fscal,dy30);
            tz               = _mm256_mul_ps(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;
            fjptrE             = f+j_coord_offsetE;
            fjptrF             = f+j_coord_offsetF;
            fjptrG             = f+j_coord_offsetG;
            fjptrH             = f+j_coord_offsetH;

            gmx_mm256_decrement_1rvec_8ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,fjptrE,fjptrF,fjptrG,fjptrH,fjx0,fjy0,fjz0);

            /* Inner loop uses 129 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            jnrlistE         = jjnr[jidx+4];
            jnrlistF         = jjnr[jidx+5];
            jnrlistG         = jjnr[jidx+6];
            jnrlistH         = jjnr[jidx+7];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm256_set_m128(gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx+4)),_mm_setzero_si128())),
                                            gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128())));
                                            
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            jnrE       = (jnrlistE>=0) ? jnrlistE : 0;
            jnrF       = (jnrlistF>=0) ? jnrlistF : 0;
            jnrG       = (jnrlistG>=0) ? jnrlistG : 0;
            jnrH       = (jnrlistH>=0) ? jnrlistH : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;
            j_coord_offsetE  = DIM*jnrE;
            j_coord_offsetF  = DIM*jnrF;
            j_coord_offsetG  = DIM*jnrG;
            j_coord_offsetH  = DIM*jnrH;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_8ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 x+j_coord_offsetE,x+j_coord_offsetF,
                                                 x+j_coord_offsetG,x+j_coord_offsetH,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_ps(ix0,jx0);
            dy00             = _mm256_sub_ps(iy0,jy0);
            dz00             = _mm256_sub_ps(iz0,jz0);
            dx10             = _mm256_sub_ps(ix1,jx0);
            dy10             = _mm256_sub_ps(iy1,jy0);
            dz10             = _mm256_sub_ps(iz1,jz0);
            dx20             = _mm256_sub_ps(ix2,jx0);
            dy20             = _mm256_sub_ps(iy2,jy0);
            dz20             = _mm256_sub_ps(iz2,jz0);
            dx30             = _mm256_sub_ps(ix3,jx0);
            dy30             = _mm256_sub_ps(iy3,jy0);
            dz30             = _mm256_sub_ps(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_ps(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_ps(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_ps(dx20,dy20,dz20);
            rsq30            = gmx_mm256_calc_rsq_ps(dx30,dy30,dz30);

            rinv00           = gmx_mm256_invsqrt_ps(rsq00);
            rinv10           = gmx_mm256_invsqrt_ps(rsq10);
            rinv20           = gmx_mm256_invsqrt_ps(rsq20);
            rinv30           = gmx_mm256_invsqrt_ps(rsq30);

            rinvsq10         = _mm256_mul_ps(rinv10,rinv10);
            rinvsq20         = _mm256_mul_ps(rinv20,rinv20);
            rinvsq30         = _mm256_mul_ps(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_8real_swizzle_ps(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0,
                                                                 charge+jnrE+0,charge+jnrF+0,
                                                                 charge+jnrG+0,charge+jnrH+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];
            vdwjidx0E        = 2*vdwtype[jnrE+0];
            vdwjidx0F        = 2*vdwtype[jnrF+0];
            vdwjidx0G        = 2*vdwtype[jnrG+0];
            vdwjidx0H        = 2*vdwtype[jnrH+0];

            fjx0             = _mm256_setzero_ps();
            fjy0             = _mm256_setzero_ps();
            fjz0             = _mm256_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm256_mul_ps(rsq00,rinv00);
            r00              = _mm256_andnot_ps(dummy_mask,r00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm256_load_8pair_swizzle_ps(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            vdwioffsetptr0+vdwjidx0E,
                                            vdwioffsetptr0+vdwjidx0F,
                                            vdwioffsetptr0+vdwjidx0G,
                                            vdwioffsetptr0+vdwjidx0H,
                                            &c6_00,&c12_00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm256_mul_ps(r00,vftabscale);
            vfitab           = _mm256_cvttps_epi32(rt);
            vfeps            = _mm256_sub_ps(rt,_mm256_round_ps(rt, _MM_FROUND_FLOOR));
            /*         AVX1 does not support 256-bit integer operations, so now we go to 128-bit mode... */
            vfitab_lo        = _mm256_extractf128_si256(vfitab,0x0);
            vfitab_hi        = _mm256_extractf128_si256(vfitab,0x1);
            vfitab_lo        = _mm_slli_epi32(vfitab_lo,3);
            vfitab_hi        = _mm_slli_epi32(vfitab_hi,3);

            /* CUBIC SPLINE TABLE DISPERSION */
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw6            = _mm256_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab_lo        = _mm_add_epi32(vfitab_lo,ifour);
            vfitab_hi        = _mm_add_epi32(vfitab_hi,ifour);
            Y                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,0)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,0)));
            F                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,1)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,1)));
            G                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,2)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,2)));
            H                = gmx_mm256_set_m128(_mm_load_ps(vftab + _mm_extract_epi32(vfitab_hi,3)),
                                                  _mm_load_ps(vftab + _mm_extract_epi32(vfitab_lo,3)));
            GMX_MM256_HALFTRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm256_mul_ps(vfeps,H);
            Fp               = _mm256_add_ps(F,_mm256_mul_ps(vfeps,_mm256_add_ps(G,Heps)));
            FF               = _mm256_add_ps(Fp,_mm256_mul_ps(vfeps,_mm256_add_ps(G,_mm256_add_ps(Heps,Heps))));
            fvdw12           = _mm256_mul_ps(c12_00,FF);
            fvdw             = _mm256_xor_ps(signbit,_mm256_mul_ps(_mm256_add_ps(fvdw6,fvdw12),_mm256_mul_ps(vftabscale,rinv00)));

            fscal            = fvdw;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx00);
            ty               = _mm256_mul_ps(fscal,dy00);
            tz               = _mm256_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_ps(fix0,tx);
            fiy0             = _mm256_add_ps(fiy0,ty);
            fiz0             = _mm256_add_ps(fiz0,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_ps(iq1,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq10,rinv10);
            felec            = _mm256_mul_ps(velec,rinvsq10);

            fscal            = felec;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx10);
            ty               = _mm256_mul_ps(fscal,dy10);
            tz               = _mm256_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_ps(fix1,tx);
            fiy1             = _mm256_add_ps(fiy1,ty);
            fiz1             = _mm256_add_ps(fiz1,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_ps(iq2,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq20,rinv20);
            felec            = _mm256_mul_ps(velec,rinvsq20);

            fscal            = felec;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx20);
            ty               = _mm256_mul_ps(fscal,dy20);
            tz               = _mm256_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_ps(fix2,tx);
            fiy2             = _mm256_add_ps(fiy2,ty);
            fiz2             = _mm256_add_ps(fiz2,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm256_mul_ps(iq3,jq0);

            /* COULOMB ELECTROSTATICS */
            velec            = _mm256_mul_ps(qq30,rinv30);
            felec            = _mm256_mul_ps(velec,rinvsq30);

            fscal            = felec;

            fscal            = _mm256_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_ps(fscal,dx30);
            ty               = _mm256_mul_ps(fscal,dy30);
            tz               = _mm256_mul_ps(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm256_add_ps(fix3,tx);
            fiy3             = _mm256_add_ps(fiy3,ty);
            fiz3             = _mm256_add_ps(fiz3,tz);

            fjx0             = _mm256_add_ps(fjx0,tx);
            fjy0             = _mm256_add_ps(fjy0,ty);
            fjz0             = _mm256_add_ps(fjz0,tz);

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;
            fjptrE             = (jnrlistE>=0) ? f+j_coord_offsetE : scratch;
            fjptrF             = (jnrlistF>=0) ? f+j_coord_offsetF : scratch;
            fjptrG             = (jnrlistG>=0) ? f+j_coord_offsetG : scratch;
            fjptrH             = (jnrlistH>=0) ? f+j_coord_offsetH : scratch;

            gmx_mm256_decrement_1rvec_8ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,fjptrE,fjptrF,fjptrG,fjptrH,fjx0,fjy0,fjz0);

            /* Inner loop uses 130 flops */
        }

        /* End of innermost loop */

        gmx_mm256_update_iforce_4atom_swizzle_ps(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                                 f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 24 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W4_F,outeriter*24 + inneriter*130);
}
