/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.pcc.defines.BatteryStatus;
import com.dsi.ant.plugins.antplus.pcc.defines.DeviceType;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestAccessResult;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusLegacyCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.MultiDeviceSearch;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.internal.pluginsipc.AntPluginDeviceDbProvider;
import com.dsi.ant.plugins.utility.log.LogAnt;
import com.dsi.ant.plugins.utility.parcel.ParcelPacker;
import com.dsi.ant.plugins.utility.parcel.ParcelUnpacker;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AntPlusBikeSpdCadCommonPcc
extends AntPlusLegacyCommonPcc {
    private static final String TAG = AntPlusBikeSpdCadCommonPcc.class.getSimpleName();
    boolean isInstanceCadencePcc;
    private Boolean mIsSpeedAndCadenceCombinedSensor = null;
    private IBatteryStatusReceiver mBatteryStatusReceiver;

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 10800;
    }

    protected AntPlusBikeSpdCadCommonPcc(boolean isInstanceCadencePcc) {
        this.isInstanceCadencePcc = isInstanceCadencePcc;
    }

    protected static <T extends AntPlusBikeSpdCadCommonPcc> PccReleaseHandle<T> requestAccessBSC_helper(boolean isCadence, Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, T potentialRetObj) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 1);
        b.putBoolean("b_ForceManualSelect", skipPreferredSearch);
        b.putInt("int_ProximityBin", searchProximityThreshold);
        b.putBoolean("bool_IsCadencePcc", isCadence);
        return AntPlusBikeSpdCadCommonPcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new RequestAccessResultHandlerUIBikeSC(userActivity), resultReceiver, stateReceiver);
    }

    protected static <T extends AntPlusBikeSpdCadCommonPcc> PccReleaseHandle<T> requestAccessBSC_helper(boolean isCadence, Context bindToContext, int antDeviceNumber, int searchProximityThreshold, boolean isSpdCadCombinedSensor, AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, T potentialRetObj) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 3);
        b.putInt("int_AntDeviceID", antDeviceNumber);
        b.putInt("int_ProximityBin", searchProximityThreshold);
        b.putBoolean("bool_IsSpdCadCombinedSensor", isSpdCadCombinedSensor);
        b.putBoolean("bool_IsCadencePcc", isCadence);
        return AntPlusBikeSpdCadCommonPcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new RequestAccessResultHandlerAsyncSearchBikeSC(potentialRetObj), resultReceiver, stateReceiver);
    }

    protected static <T extends AntPlusBikeSpdCadCommonPcc> BikeSpdCadAsyncScanController<T> requestAccessBSC_Helper_AsyncScanController(boolean isCadence, Context bindingContext, int searchProximityThreshold, T retPccObject, IBikeSpdCadAsyncScanResultReceiver scanResultReceiver) {
        BikeSpdCadAsyncScanController<T> controller = new BikeSpdCadAsyncScanController<T>(scanResultReceiver, retPccObject);
        Bundle b = new Bundle();
        b.putBoolean("bool_IsCadencePcc", isCadence);
        AntPlusBikeSpdCadCommonPcc.requestAsyncScan_Helper_SubMain(bindingContext, searchProximityThreshold, b, retPccObject, controller);
        return controller;
    }

    protected void setIsSpeedAndCadence(boolean isSpeedAndCadence) {
        if (this.mIsSpeedAndCadenceCombinedSensor != null) {
            throw new IllegalStateException("Can't reinitialize isSpeedAndCadence");
        }
        this.mIsSpeedAndCadenceCombinedSensor = isSpeedAndCadence;
    }

    public boolean isSpeedAndCadenceCombinedSensor() {
        return this.mIsSpeedAndCadenceCombinedSensor;
    }

    @Override
    protected Message createCmdMsg(int cmdCode, Bundle msgData) {
        if (msgData == null) {
            msgData = new Bundle();
        }
        msgData.putBoolean("bool_IsCadencePcc", this.isInstanceCadencePcc);
        return super.createCmdMsg(cmdCode, msgData);
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 207: {
                if (this.mBatteryStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal batteryVoltage = (BigDecimal)b.getSerializable("decimal_batteryVoltage");
                BatteryStatus batteryStatus = BatteryStatus.getValueFromInt(b.getInt("int_batteryStatus"));
                this.mBatteryStatusReceiver.onNewBatteryStatus(estTimestamp, eventFlags, batteryVoltage, batteryStatus);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public boolean subscribeBatteryStatusEvent(IBatteryStatusReceiver batteryStatusReceiver) {
        if (this.reportedServiceVersion < 20208) {
            LogAnt.w(TAG, "subscribeBatteryStatusEvent requires ANT+ Plugins Service >20208, installed: " + this.reportedServiceVersion);
            return false;
        }
        this.mBatteryStatusReceiver = batteryStatusReceiver;
        if (batteryStatusReceiver != null) {
            return this.subscribeToEvent(207);
        }
        this.unsubscribeFromEvent(207);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestAccessResultHandlerUIBikeSC<T extends AntPlusBikeSpdCadCommonPcc>
    extends AntPluginPcc.RequestAccessResultHandler_UI<T> {
        public RequestAccessResultHandlerUIBikeSC(Activity foregroundActivity) {
            super(foregroundActivity);
        }

        @Override
        public boolean handleRequestAccessResult(Message msg) {
            if (msg.what == 0) {
                ((AntPlusBikeSpdCadCommonPcc)this.retPccObject).setIsSpeedAndCadence(msg.getData().getBoolean("bool_IsSpdCadCombinedSensor"));
            }
            return super.handleRequestAccessResult(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestAccessResultHandlerAsyncSearchBikeSC<T extends AntPlusBikeSpdCadCommonPcc>
    extends AntPluginPcc.RequestAccessResultHandler_AsyncSearchByDevNumber<T> {
        AntPlusBikeSpdCadCommonPcc pccObj;

        public RequestAccessResultHandlerAsyncSearchBikeSC(AntPlusBikeSpdCadCommonPcc pccRetObj) {
            this.pccObj = pccRetObj;
        }

        @Override
        public boolean handleRequestAccessResult(Message msg) {
            if (msg.what == 0) {
                this.pccObj.setIsSpeedAndCadence(msg.getData().getBoolean("bool_IsSpdCadCombinedSensor"));
            }
            return super.handleRequestAccessResult(msg);
        }
    }

    public static class MultiDeviceSearchSpdCadResult
    extends MultiDeviceSearch.MultiDeviceSearchResult {
        private static final int IPC_VERSION = 1;
        protected final AntPluginDeviceDbProvider.DeviceDbDeviceInfo mCadenceInfo;
        public static final Parcelable.Creator<MultiDeviceSearchSpdCadResult> CREATOR = new Parcelable.Creator<MultiDeviceSearchSpdCadResult>(){

            public MultiDeviceSearchSpdCadResult[] newArray(int size) {
                return new MultiDeviceSearchSpdCadResult[size];
            }

            public MultiDeviceSearchSpdCadResult createFromParcel(Parcel source) {
                return new MultiDeviceSearchSpdCadResult(source);
            }
        };

        public MultiDeviceSearchSpdCadResult(int resultID, AntPluginDeviceDbProvider.DeviceDbDeviceInfo spdInfo, AntPluginDeviceDbProvider.DeviceDbDeviceInfo cadInfo, boolean alreadyConnected) {
            super(resultID, DeviceType.BIKE_SPDCAD, spdInfo, alreadyConnected);
            this.mCadenceInfo = cadInfo;
        }

        public boolean isPreferredDevice() {
            return this.isPreferredForSpeed() | this.isPreferredForCadence();
        }

        public boolean isPreferredForSpeed() {
            return this.mInfo.isPreferredDevice;
        }

        public boolean isPreferredForCadence() {
            return this.mCadenceInfo.isPreferredDevice;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            ParcelPacker packer = new ParcelPacker(dest);
            dest.writeInt(1);
            ParcelPacker innerpacker = new ParcelPacker(dest);
            dest.writeParcelable((Parcelable)this.mCadenceInfo, flags);
            innerpacker.finish();
            packer.finish();
        }

        protected MultiDeviceSearchSpdCadResult(Parcel source) {
            super(source);
            ParcelUnpacker unpacker = new ParcelUnpacker(source);
            int sourceIpcVersion = source.readInt();
            ParcelUnpacker innerunpack = new ParcelUnpacker(source);
            this.mCadenceInfo = (AntPluginDeviceDbProvider.DeviceDbDeviceInfo)source.readParcelable(AntPluginDeviceDbProvider.DeviceDbDeviceInfo.class.getClassLoader());
            innerunpack.finish();
            if (sourceIpcVersion > 1) {
                LogAnt.i(TAG, "Decoding " + MultiDeviceSearchSpdCadResult.class.getSimpleName() + " version " + sourceIpcVersion + " using version " + 1 + " decoder");
            }
            unpacker.finish();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BikeSpdCadAsyncScanController<T extends AntPlusBikeSpdCadCommonPcc>
    extends AsyncScanController<T> {
        IBikeSpdCadAsyncScanResultReceiver bikeResultReceiver;

        BikeSpdCadAsyncScanController(IBikeSpdCadAsyncScanResultReceiver bikeResultReceiver, T pccObject) {
            super(pccObject);
            this.bikeResultReceiver = bikeResultReceiver;
        }

        @Override
        protected void sendFailureToReceiver(RequestAccessResult requestAccessResult) {
            this.bikeResultReceiver.onSearchStopped(requestAccessResult);
        }

        @Override
        protected void sendResultToReceiver(Bundle result) {
            AsyncScanController.AsyncScanResultDeviceInfo newResult = (AsyncScanController.AsyncScanResultDeviceInfo)result.getParcelable("parcelable_AsyncScanResultDeviceInfo");
            boolean isSpdAndCadComboSensor = result.getBoolean("bool_IsCombinedSensor");
            this.bikeResultReceiver.onSearchResult(new BikeSpdCadAsyncScanResultDeviceInfo(newResult, isSpdAndCadComboSensor));
        }

        @Override
        protected void handleReqAccSuccess(Message msg, T retPccObject, AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver) {
            if (msg.what == 0) {
                ((AntPlusBikeSpdCadCommonPcc)retPccObject).setIsSpeedAndCadence(msg.getData().getBoolean("bool_IsSpdCadCombinedSensor"));
            }
            super.handleReqAccSuccess(msg, retPccObject, resultReceiver);
        }
    }

    public static interface IBikeSpdCadAsyncScanResultReceiver {
        public void onSearchStopped(RequestAccessResult var1);

        public void onSearchResult(BikeSpdCadAsyncScanResultDeviceInfo var1);
    }

    public static class BikeSpdCadAsyncScanResultDeviceInfo {
        public static final String MSG_BIKESPDCAD_ASYNCSCANRESULTINFO_boolISCOMBINEDSENSOR = "bool_IsCombinedSensor";
        public final boolean isSpdAndCadComboSensor;
        public final AsyncScanController.AsyncScanResultDeviceInfo resultInfo;

        public BikeSpdCadAsyncScanResultDeviceInfo(AsyncScanController.AsyncScanResultDeviceInfo resultInfo, boolean isSpdAndCadComboSensor) {
            this.resultInfo = resultInfo;
            this.isSpdAndCadComboSensor = isSpdAndCadComboSensor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBatteryStatusReceiver {
        public void onNewBatteryStatus(long var1, EnumSet<EventFlag> var3, BigDecimal var4, BatteryStatus var5);
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_BIKECOMBOSPDCADPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_BIKECOMBOSPDCADPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.bikespdcad.CombinedBikeSpdCadService";
        public static final String MSG_BIKESPDCAD_REQ_PARAM_boolISCADENCEPCC = "bool_IsCadencePcc";
        public static final String MSG_BIKESPDCAD_REQACC_ASYNCSEARCHBYANTDEVID_PARAM_boolISSPDCADCOMBINEDSENSOR = "bool_IsSpdCadCombinedSensor";
        public static final String MSG_BIKESPDCAD_REQACC_RESULT_boolISSPDCADCOMBINEDSENSOR = "bool_IsSpdCadCombinedSensor";
        public static final int MSG_EVENT_BIKESPDCAD_whatBATTERYSTATUS = 207;
        public static final String MSG_EVENT_BIKESPDCAD_BATTERYSTATUS_PARAM_decimalBATTERYVOLTAGE = "decimal_batteryVoltage";
        public static final String MSG_EVENT_BIKESPDCAD_BATTERYSTATUS_PARAM_intBATTERYSTATUS = "int_batteryStatus";
    }
}

