// Code generated by protoc-gen-go. DO NOT EDIT.
// source: control.proto

/*
Package grpc_testing is a generated protocol buffer package.

It is generated from these files:
	control.proto
	messages.proto
	payloads.proto
	services.proto
	stats.proto

It has these top-level messages:
	PoissonParams
	UniformParams
	DeterministicParams
	ParetoParams
	ClosedLoopParams
	LoadParams
	SecurityParams
	ClientConfig
	ClientStatus
	Mark
	ClientArgs
	ServerConfig
	ServerArgs
	ServerStatus
	CoreRequest
	CoreResponse
	Void
	Scenario
	Scenarios
	Payload
	EchoStatus
	SimpleRequest
	SimpleResponse
	StreamingInputCallRequest
	StreamingInputCallResponse
	ResponseParameters
	StreamingOutputCallRequest
	StreamingOutputCallResponse
	ReconnectParams
	ReconnectInfo
	ByteBufferParams
	SimpleProtoParams
	ComplexProtoParams
	PayloadConfig
	ServerStats
	HistogramParams
	HistogramData
	ClientStats
*/
package grpc_testing

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ClientType int32

const (
	ClientType_SYNC_CLIENT  ClientType = 0
	ClientType_ASYNC_CLIENT ClientType = 1
)

var ClientType_name = map[int32]string{
	0: "SYNC_CLIENT",
	1: "ASYNC_CLIENT",
}
var ClientType_value = map[string]int32{
	"SYNC_CLIENT":  0,
	"ASYNC_CLIENT": 1,
}

func (x ClientType) String() string {
	return proto.EnumName(ClientType_name, int32(x))
}
func (ClientType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type ServerType int32

const (
	ServerType_SYNC_SERVER          ServerType = 0
	ServerType_ASYNC_SERVER         ServerType = 1
	ServerType_ASYNC_GENERIC_SERVER ServerType = 2
)

var ServerType_name = map[int32]string{
	0: "SYNC_SERVER",
	1: "ASYNC_SERVER",
	2: "ASYNC_GENERIC_SERVER",
}
var ServerType_value = map[string]int32{
	"SYNC_SERVER":          0,
	"ASYNC_SERVER":         1,
	"ASYNC_GENERIC_SERVER": 2,
}

func (x ServerType) String() string {
	return proto.EnumName(ServerType_name, int32(x))
}
func (ServerType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type RpcType int32

const (
	RpcType_UNARY     RpcType = 0
	RpcType_STREAMING RpcType = 1
)

var RpcType_name = map[int32]string{
	0: "UNARY",
	1: "STREAMING",
}
var RpcType_value = map[string]int32{
	"UNARY":     0,
	"STREAMING": 1,
}

func (x RpcType) String() string {
	return proto.EnumName(RpcType_name, int32(x))
}
func (RpcType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Parameters of poisson process distribution, which is a good representation
// of activity coming in from independent identical stationary sources.
type PoissonParams struct {
	// The rate of arrivals (a.k.a. lambda parameter of the exp distribution).
	OfferedLoad float64 `protobuf:"fixed64,1,opt,name=offered_load,json=offeredLoad" json:"offered_load,omitempty"`
}

func (m *PoissonParams) Reset()                    { *m = PoissonParams{} }
func (m *PoissonParams) String() string            { return proto.CompactTextString(m) }
func (*PoissonParams) ProtoMessage()               {}
func (*PoissonParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *PoissonParams) GetOfferedLoad() float64 {
	if m != nil {
		return m.OfferedLoad
	}
	return 0
}

type UniformParams struct {
	InterarrivalLo float64 `protobuf:"fixed64,1,opt,name=interarrival_lo,json=interarrivalLo" json:"interarrival_lo,omitempty"`
	InterarrivalHi float64 `protobuf:"fixed64,2,opt,name=interarrival_hi,json=interarrivalHi" json:"interarrival_hi,omitempty"`
}

func (m *UniformParams) Reset()                    { *m = UniformParams{} }
func (m *UniformParams) String() string            { return proto.CompactTextString(m) }
func (*UniformParams) ProtoMessage()               {}
func (*UniformParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *UniformParams) GetInterarrivalLo() float64 {
	if m != nil {
		return m.InterarrivalLo
	}
	return 0
}

func (m *UniformParams) GetInterarrivalHi() float64 {
	if m != nil {
		return m.InterarrivalHi
	}
	return 0
}

type DeterministicParams struct {
	OfferedLoad float64 `protobuf:"fixed64,1,opt,name=offered_load,json=offeredLoad" json:"offered_load,omitempty"`
}

func (m *DeterministicParams) Reset()                    { *m = DeterministicParams{} }
func (m *DeterministicParams) String() string            { return proto.CompactTextString(m) }
func (*DeterministicParams) ProtoMessage()               {}
func (*DeterministicParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *DeterministicParams) GetOfferedLoad() float64 {
	if m != nil {
		return m.OfferedLoad
	}
	return 0
}

type ParetoParams struct {
	InterarrivalBase float64 `protobuf:"fixed64,1,opt,name=interarrival_base,json=interarrivalBase" json:"interarrival_base,omitempty"`
	Alpha            float64 `protobuf:"fixed64,2,opt,name=alpha" json:"alpha,omitempty"`
}

func (m *ParetoParams) Reset()                    { *m = ParetoParams{} }
func (m *ParetoParams) String() string            { return proto.CompactTextString(m) }
func (*ParetoParams) ProtoMessage()               {}
func (*ParetoParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ParetoParams) GetInterarrivalBase() float64 {
	if m != nil {
		return m.InterarrivalBase
	}
	return 0
}

func (m *ParetoParams) GetAlpha() float64 {
	if m != nil {
		return m.Alpha
	}
	return 0
}

// Once an RPC finishes, immediately start a new one.
// No configuration parameters needed.
type ClosedLoopParams struct {
}

func (m *ClosedLoopParams) Reset()                    { *m = ClosedLoopParams{} }
func (m *ClosedLoopParams) String() string            { return proto.CompactTextString(m) }
func (*ClosedLoopParams) ProtoMessage()               {}
func (*ClosedLoopParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type LoadParams struct {
	// Types that are valid to be assigned to Load:
	//	*LoadParams_ClosedLoop
	//	*LoadParams_Poisson
	//	*LoadParams_Uniform
	//	*LoadParams_Determ
	//	*LoadParams_Pareto
	Load isLoadParams_Load `protobuf_oneof:"load"`
}

func (m *LoadParams) Reset()                    { *m = LoadParams{} }
func (m *LoadParams) String() string            { return proto.CompactTextString(m) }
func (*LoadParams) ProtoMessage()               {}
func (*LoadParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isLoadParams_Load interface {
	isLoadParams_Load()
}

type LoadParams_ClosedLoop struct {
	ClosedLoop *ClosedLoopParams `protobuf:"bytes,1,opt,name=closed_loop,json=closedLoop,oneof"`
}
type LoadParams_Poisson struct {
	Poisson *PoissonParams `protobuf:"bytes,2,opt,name=poisson,oneof"`
}
type LoadParams_Uniform struct {
	Uniform *UniformParams `protobuf:"bytes,3,opt,name=uniform,oneof"`
}
type LoadParams_Determ struct {
	Determ *DeterministicParams `protobuf:"bytes,4,opt,name=determ,oneof"`
}
type LoadParams_Pareto struct {
	Pareto *ParetoParams `protobuf:"bytes,5,opt,name=pareto,oneof"`
}

func (*LoadParams_ClosedLoop) isLoadParams_Load() {}
func (*LoadParams_Poisson) isLoadParams_Load()    {}
func (*LoadParams_Uniform) isLoadParams_Load()    {}
func (*LoadParams_Determ) isLoadParams_Load()     {}
func (*LoadParams_Pareto) isLoadParams_Load()     {}

func (m *LoadParams) GetLoad() isLoadParams_Load {
	if m != nil {
		return m.Load
	}
	return nil
}

func (m *LoadParams) GetClosedLoop() *ClosedLoopParams {
	if x, ok := m.GetLoad().(*LoadParams_ClosedLoop); ok {
		return x.ClosedLoop
	}
	return nil
}

func (m *LoadParams) GetPoisson() *PoissonParams {
	if x, ok := m.GetLoad().(*LoadParams_Poisson); ok {
		return x.Poisson
	}
	return nil
}

func (m *LoadParams) GetUniform() *UniformParams {
	if x, ok := m.GetLoad().(*LoadParams_Uniform); ok {
		return x.Uniform
	}
	return nil
}

func (m *LoadParams) GetDeterm() *DeterministicParams {
	if x, ok := m.GetLoad().(*LoadParams_Determ); ok {
		return x.Determ
	}
	return nil
}

func (m *LoadParams) GetPareto() *ParetoParams {
	if x, ok := m.GetLoad().(*LoadParams_Pareto); ok {
		return x.Pareto
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LoadParams) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LoadParams_OneofMarshaler, _LoadParams_OneofUnmarshaler, _LoadParams_OneofSizer, []interface{}{
		(*LoadParams_ClosedLoop)(nil),
		(*LoadParams_Poisson)(nil),
		(*LoadParams_Uniform)(nil),
		(*LoadParams_Determ)(nil),
		(*LoadParams_Pareto)(nil),
	}
}

func _LoadParams_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LoadParams)
	// load
	switch x := m.Load.(type) {
	case *LoadParams_ClosedLoop:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClosedLoop); err != nil {
			return err
		}
	case *LoadParams_Poisson:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Poisson); err != nil {
			return err
		}
	case *LoadParams_Uniform:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Uniform); err != nil {
			return err
		}
	case *LoadParams_Determ:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Determ); err != nil {
			return err
		}
	case *LoadParams_Pareto:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Pareto); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LoadParams.Load has unexpected type %T", x)
	}
	return nil
}

func _LoadParams_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LoadParams)
	switch tag {
	case 1: // load.closed_loop
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClosedLoopParams)
		err := b.DecodeMessage(msg)
		m.Load = &LoadParams_ClosedLoop{msg}
		return true, err
	case 2: // load.poisson
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PoissonParams)
		err := b.DecodeMessage(msg)
		m.Load = &LoadParams_Poisson{msg}
		return true, err
	case 3: // load.uniform
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UniformParams)
		err := b.DecodeMessage(msg)
		m.Load = &LoadParams_Uniform{msg}
		return true, err
	case 4: // load.determ
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeterministicParams)
		err := b.DecodeMessage(msg)
		m.Load = &LoadParams_Determ{msg}
		return true, err
	case 5: // load.pareto
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ParetoParams)
		err := b.DecodeMessage(msg)
		m.Load = &LoadParams_Pareto{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LoadParams_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LoadParams)
	// load
	switch x := m.Load.(type) {
	case *LoadParams_ClosedLoop:
		s := proto.Size(x.ClosedLoop)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LoadParams_Poisson:
		s := proto.Size(x.Poisson)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LoadParams_Uniform:
		s := proto.Size(x.Uniform)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LoadParams_Determ:
		s := proto.Size(x.Determ)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LoadParams_Pareto:
		s := proto.Size(x.Pareto)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// presence of SecurityParams implies use of TLS
type SecurityParams struct {
	UseTestCa          bool   `protobuf:"varint,1,opt,name=use_test_ca,json=useTestCa" json:"use_test_ca,omitempty"`
	ServerHostOverride string `protobuf:"bytes,2,opt,name=server_host_override,json=serverHostOverride" json:"server_host_override,omitempty"`
}

func (m *SecurityParams) Reset()                    { *m = SecurityParams{} }
func (m *SecurityParams) String() string            { return proto.CompactTextString(m) }
func (*SecurityParams) ProtoMessage()               {}
func (*SecurityParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *SecurityParams) GetUseTestCa() bool {
	if m != nil {
		return m.UseTestCa
	}
	return false
}

func (m *SecurityParams) GetServerHostOverride() string {
	if m != nil {
		return m.ServerHostOverride
	}
	return ""
}

type ClientConfig struct {
	// List of targets to connect to. At least one target needs to be specified.
	ServerTargets  []string        `protobuf:"bytes,1,rep,name=server_targets,json=serverTargets" json:"server_targets,omitempty"`
	ClientType     ClientType      `protobuf:"varint,2,opt,name=client_type,json=clientType,enum=grpc.testing.ClientType" json:"client_type,omitempty"`
	SecurityParams *SecurityParams `protobuf:"bytes,3,opt,name=security_params,json=securityParams" json:"security_params,omitempty"`
	// How many concurrent RPCs to start for each channel.
	// For synchronous client, use a separate thread for each outstanding RPC.
	OutstandingRpcsPerChannel int32 `protobuf:"varint,4,opt,name=outstanding_rpcs_per_channel,json=outstandingRpcsPerChannel" json:"outstanding_rpcs_per_channel,omitempty"`
	// Number of independent client channels to create.
	// i-th channel will connect to server_target[i % server_targets.size()]
	ClientChannels int32 `protobuf:"varint,5,opt,name=client_channels,json=clientChannels" json:"client_channels,omitempty"`
	// Only for async client. Number of threads to use to start/manage RPCs.
	AsyncClientThreads int32   `protobuf:"varint,7,opt,name=async_client_threads,json=asyncClientThreads" json:"async_client_threads,omitempty"`
	RpcType            RpcType `protobuf:"varint,8,opt,name=rpc_type,json=rpcType,enum=grpc.testing.RpcType" json:"rpc_type,omitempty"`
	// The requested load for the entire client (aggregated over all the threads).
	LoadParams      *LoadParams      `protobuf:"bytes,10,opt,name=load_params,json=loadParams" json:"load_params,omitempty"`
	PayloadConfig   *PayloadConfig   `protobuf:"bytes,11,opt,name=payload_config,json=payloadConfig" json:"payload_config,omitempty"`
	HistogramParams *HistogramParams `protobuf:"bytes,12,opt,name=histogram_params,json=histogramParams" json:"histogram_params,omitempty"`
	// Specify the cores we should run the client on, if desired
	CoreList  []int32 `protobuf:"varint,13,rep,packed,name=core_list,json=coreList" json:"core_list,omitempty"`
	CoreLimit int32   `protobuf:"varint,14,opt,name=core_limit,json=coreLimit" json:"core_limit,omitempty"`
}

func (m *ClientConfig) Reset()                    { *m = ClientConfig{} }
func (m *ClientConfig) String() string            { return proto.CompactTextString(m) }
func (*ClientConfig) ProtoMessage()               {}
func (*ClientConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ClientConfig) GetServerTargets() []string {
	if m != nil {
		return m.ServerTargets
	}
	return nil
}

func (m *ClientConfig) GetClientType() ClientType {
	if m != nil {
		return m.ClientType
	}
	return ClientType_SYNC_CLIENT
}

func (m *ClientConfig) GetSecurityParams() *SecurityParams {
	if m != nil {
		return m.SecurityParams
	}
	return nil
}

func (m *ClientConfig) GetOutstandingRpcsPerChannel() int32 {
	if m != nil {
		return m.OutstandingRpcsPerChannel
	}
	return 0
}

func (m *ClientConfig) GetClientChannels() int32 {
	if m != nil {
		return m.ClientChannels
	}
	return 0
}

func (m *ClientConfig) GetAsyncClientThreads() int32 {
	if m != nil {
		return m.AsyncClientThreads
	}
	return 0
}

func (m *ClientConfig) GetRpcType() RpcType {
	if m != nil {
		return m.RpcType
	}
	return RpcType_UNARY
}

func (m *ClientConfig) GetLoadParams() *LoadParams {
	if m != nil {
		return m.LoadParams
	}
	return nil
}

func (m *ClientConfig) GetPayloadConfig() *PayloadConfig {
	if m != nil {
		return m.PayloadConfig
	}
	return nil
}

func (m *ClientConfig) GetHistogramParams() *HistogramParams {
	if m != nil {
		return m.HistogramParams
	}
	return nil
}

func (m *ClientConfig) GetCoreList() []int32 {
	if m != nil {
		return m.CoreList
	}
	return nil
}

func (m *ClientConfig) GetCoreLimit() int32 {
	if m != nil {
		return m.CoreLimit
	}
	return 0
}

type ClientStatus struct {
	Stats *ClientStats `protobuf:"bytes,1,opt,name=stats" json:"stats,omitempty"`
}

func (m *ClientStatus) Reset()                    { *m = ClientStatus{} }
func (m *ClientStatus) String() string            { return proto.CompactTextString(m) }
func (*ClientStatus) ProtoMessage()               {}
func (*ClientStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ClientStatus) GetStats() *ClientStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// Request current stats
type Mark struct {
	// if true, the stats will be reset after taking their snapshot.
	Reset_ bool `protobuf:"varint,1,opt,name=reset" json:"reset,omitempty"`
}

func (m *Mark) Reset()                    { *m = Mark{} }
func (m *Mark) String() string            { return proto.CompactTextString(m) }
func (*Mark) ProtoMessage()               {}
func (*Mark) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Mark) GetReset_() bool {
	if m != nil {
		return m.Reset_
	}
	return false
}

type ClientArgs struct {
	// Types that are valid to be assigned to Argtype:
	//	*ClientArgs_Setup
	//	*ClientArgs_Mark
	Argtype isClientArgs_Argtype `protobuf_oneof:"argtype"`
}

func (m *ClientArgs) Reset()                    { *m = ClientArgs{} }
func (m *ClientArgs) String() string            { return proto.CompactTextString(m) }
func (*ClientArgs) ProtoMessage()               {}
func (*ClientArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type isClientArgs_Argtype interface {
	isClientArgs_Argtype()
}

type ClientArgs_Setup struct {
	Setup *ClientConfig `protobuf:"bytes,1,opt,name=setup,oneof"`
}
type ClientArgs_Mark struct {
	Mark *Mark `protobuf:"bytes,2,opt,name=mark,oneof"`
}

func (*ClientArgs_Setup) isClientArgs_Argtype() {}
func (*ClientArgs_Mark) isClientArgs_Argtype()  {}

func (m *ClientArgs) GetArgtype() isClientArgs_Argtype {
	if m != nil {
		return m.Argtype
	}
	return nil
}

func (m *ClientArgs) GetSetup() *ClientConfig {
	if x, ok := m.GetArgtype().(*ClientArgs_Setup); ok {
		return x.Setup
	}
	return nil
}

func (m *ClientArgs) GetMark() *Mark {
	if x, ok := m.GetArgtype().(*ClientArgs_Mark); ok {
		return x.Mark
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ClientArgs) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ClientArgs_OneofMarshaler, _ClientArgs_OneofUnmarshaler, _ClientArgs_OneofSizer, []interface{}{
		(*ClientArgs_Setup)(nil),
		(*ClientArgs_Mark)(nil),
	}
}

func _ClientArgs_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ClientArgs)
	// argtype
	switch x := m.Argtype.(type) {
	case *ClientArgs_Setup:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Setup); err != nil {
			return err
		}
	case *ClientArgs_Mark:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mark); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ClientArgs.Argtype has unexpected type %T", x)
	}
	return nil
}

func _ClientArgs_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ClientArgs)
	switch tag {
	case 1: // argtype.setup
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClientConfig)
		err := b.DecodeMessage(msg)
		m.Argtype = &ClientArgs_Setup{msg}
		return true, err
	case 2: // argtype.mark
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mark)
		err := b.DecodeMessage(msg)
		m.Argtype = &ClientArgs_Mark{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ClientArgs_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ClientArgs)
	// argtype
	switch x := m.Argtype.(type) {
	case *ClientArgs_Setup:
		s := proto.Size(x.Setup)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ClientArgs_Mark:
		s := proto.Size(x.Mark)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ServerConfig struct {
	ServerType     ServerType      `protobuf:"varint,1,opt,name=server_type,json=serverType,enum=grpc.testing.ServerType" json:"server_type,omitempty"`
	SecurityParams *SecurityParams `protobuf:"bytes,2,opt,name=security_params,json=securityParams" json:"security_params,omitempty"`
	// Port on which to listen. Zero means pick unused port.
	Port int32 `protobuf:"varint,4,opt,name=port" json:"port,omitempty"`
	// Only for async server. Number of threads used to serve the requests.
	AsyncServerThreads int32 `protobuf:"varint,7,opt,name=async_server_threads,json=asyncServerThreads" json:"async_server_threads,omitempty"`
	// Specify the number of cores to limit server to, if desired
	CoreLimit int32 `protobuf:"varint,8,opt,name=core_limit,json=coreLimit" json:"core_limit,omitempty"`
	// payload config, used in generic server
	PayloadConfig *PayloadConfig `protobuf:"bytes,9,opt,name=payload_config,json=payloadConfig" json:"payload_config,omitempty"`
	// Specify the cores we should run the server on, if desired
	CoreList []int32 `protobuf:"varint,10,rep,packed,name=core_list,json=coreList" json:"core_list,omitempty"`
}

func (m *ServerConfig) Reset()                    { *m = ServerConfig{} }
func (m *ServerConfig) String() string            { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()               {}
func (*ServerConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ServerConfig) GetServerType() ServerType {
	if m != nil {
		return m.ServerType
	}
	return ServerType_SYNC_SERVER
}

func (m *ServerConfig) GetSecurityParams() *SecurityParams {
	if m != nil {
		return m.SecurityParams
	}
	return nil
}

func (m *ServerConfig) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *ServerConfig) GetAsyncServerThreads() int32 {
	if m != nil {
		return m.AsyncServerThreads
	}
	return 0
}

func (m *ServerConfig) GetCoreLimit() int32 {
	if m != nil {
		return m.CoreLimit
	}
	return 0
}

func (m *ServerConfig) GetPayloadConfig() *PayloadConfig {
	if m != nil {
		return m.PayloadConfig
	}
	return nil
}

func (m *ServerConfig) GetCoreList() []int32 {
	if m != nil {
		return m.CoreList
	}
	return nil
}

type ServerArgs struct {
	// Types that are valid to be assigned to Argtype:
	//	*ServerArgs_Setup
	//	*ServerArgs_Mark
	Argtype isServerArgs_Argtype `protobuf_oneof:"argtype"`
}

func (m *ServerArgs) Reset()                    { *m = ServerArgs{} }
func (m *ServerArgs) String() string            { return proto.CompactTextString(m) }
func (*ServerArgs) ProtoMessage()               {}
func (*ServerArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

type isServerArgs_Argtype interface {
	isServerArgs_Argtype()
}

type ServerArgs_Setup struct {
	Setup *ServerConfig `protobuf:"bytes,1,opt,name=setup,oneof"`
}
type ServerArgs_Mark struct {
	Mark *Mark `protobuf:"bytes,2,opt,name=mark,oneof"`
}

func (*ServerArgs_Setup) isServerArgs_Argtype() {}
func (*ServerArgs_Mark) isServerArgs_Argtype()  {}

func (m *ServerArgs) GetArgtype() isServerArgs_Argtype {
	if m != nil {
		return m.Argtype
	}
	return nil
}

func (m *ServerArgs) GetSetup() *ServerConfig {
	if x, ok := m.GetArgtype().(*ServerArgs_Setup); ok {
		return x.Setup
	}
	return nil
}

func (m *ServerArgs) GetMark() *Mark {
	if x, ok := m.GetArgtype().(*ServerArgs_Mark); ok {
		return x.Mark
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ServerArgs) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ServerArgs_OneofMarshaler, _ServerArgs_OneofUnmarshaler, _ServerArgs_OneofSizer, []interface{}{
		(*ServerArgs_Setup)(nil),
		(*ServerArgs_Mark)(nil),
	}
}

func _ServerArgs_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ServerArgs)
	// argtype
	switch x := m.Argtype.(type) {
	case *ServerArgs_Setup:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Setup); err != nil {
			return err
		}
	case *ServerArgs_Mark:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mark); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ServerArgs.Argtype has unexpected type %T", x)
	}
	return nil
}

func _ServerArgs_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ServerArgs)
	switch tag {
	case 1: // argtype.setup
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ServerConfig)
		err := b.DecodeMessage(msg)
		m.Argtype = &ServerArgs_Setup{msg}
		return true, err
	case 2: // argtype.mark
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mark)
		err := b.DecodeMessage(msg)
		m.Argtype = &ServerArgs_Mark{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ServerArgs_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ServerArgs)
	// argtype
	switch x := m.Argtype.(type) {
	case *ServerArgs_Setup:
		s := proto.Size(x.Setup)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ServerArgs_Mark:
		s := proto.Size(x.Mark)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ServerStatus struct {
	Stats *ServerStats `protobuf:"bytes,1,opt,name=stats" json:"stats,omitempty"`
	// the port bound by the server
	Port int32 `protobuf:"varint,2,opt,name=port" json:"port,omitempty"`
	// Number of cores available to the server
	Cores int32 `protobuf:"varint,3,opt,name=cores" json:"cores,omitempty"`
}

func (m *ServerStatus) Reset()                    { *m = ServerStatus{} }
func (m *ServerStatus) String() string            { return proto.CompactTextString(m) }
func (*ServerStatus) ProtoMessage()               {}
func (*ServerStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ServerStatus) GetStats() *ServerStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *ServerStatus) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *ServerStatus) GetCores() int32 {
	if m != nil {
		return m.Cores
	}
	return 0
}

type CoreRequest struct {
}

func (m *CoreRequest) Reset()                    { *m = CoreRequest{} }
func (m *CoreRequest) String() string            { return proto.CompactTextString(m) }
func (*CoreRequest) ProtoMessage()               {}
func (*CoreRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type CoreResponse struct {
	// Number of cores available on the server
	Cores int32 `protobuf:"varint,1,opt,name=cores" json:"cores,omitempty"`
}

func (m *CoreResponse) Reset()                    { *m = CoreResponse{} }
func (m *CoreResponse) String() string            { return proto.CompactTextString(m) }
func (*CoreResponse) ProtoMessage()               {}
func (*CoreResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *CoreResponse) GetCores() int32 {
	if m != nil {
		return m.Cores
	}
	return 0
}

type Void struct {
}

func (m *Void) Reset()                    { *m = Void{} }
func (m *Void) String() string            { return proto.CompactTextString(m) }
func (*Void) ProtoMessage()               {}
func (*Void) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

// A single performance scenario: input to qps_json_driver
type Scenario struct {
	// Human readable name for this scenario
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Client configuration
	ClientConfig *ClientConfig `protobuf:"bytes,2,opt,name=client_config,json=clientConfig" json:"client_config,omitempty"`
	// Number of clients to start for the test
	NumClients int32 `protobuf:"varint,3,opt,name=num_clients,json=numClients" json:"num_clients,omitempty"`
	// Server configuration
	ServerConfig *ServerConfig `protobuf:"bytes,4,opt,name=server_config,json=serverConfig" json:"server_config,omitempty"`
	// Number of servers to start for the test
	NumServers int32 `protobuf:"varint,5,opt,name=num_servers,json=numServers" json:"num_servers,omitempty"`
	// Warmup period, in seconds
	WarmupSeconds int32 `protobuf:"varint,6,opt,name=warmup_seconds,json=warmupSeconds" json:"warmup_seconds,omitempty"`
	// Benchmark time, in seconds
	BenchmarkSeconds int32 `protobuf:"varint,7,opt,name=benchmark_seconds,json=benchmarkSeconds" json:"benchmark_seconds,omitempty"`
	// Number of workers to spawn locally (usually zero)
	SpawnLocalWorkerCount int32 `protobuf:"varint,8,opt,name=spawn_local_worker_count,json=spawnLocalWorkerCount" json:"spawn_local_worker_count,omitempty"`
}

func (m *Scenario) Reset()                    { *m = Scenario{} }
func (m *Scenario) String() string            { return proto.CompactTextString(m) }
func (*Scenario) ProtoMessage()               {}
func (*Scenario) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *Scenario) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Scenario) GetClientConfig() *ClientConfig {
	if m != nil {
		return m.ClientConfig
	}
	return nil
}

func (m *Scenario) GetNumClients() int32 {
	if m != nil {
		return m.NumClients
	}
	return 0
}

func (m *Scenario) GetServerConfig() *ServerConfig {
	if m != nil {
		return m.ServerConfig
	}
	return nil
}

func (m *Scenario) GetNumServers() int32 {
	if m != nil {
		return m.NumServers
	}
	return 0
}

func (m *Scenario) GetWarmupSeconds() int32 {
	if m != nil {
		return m.WarmupSeconds
	}
	return 0
}

func (m *Scenario) GetBenchmarkSeconds() int32 {
	if m != nil {
		return m.BenchmarkSeconds
	}
	return 0
}

func (m *Scenario) GetSpawnLocalWorkerCount() int32 {
	if m != nil {
		return m.SpawnLocalWorkerCount
	}
	return 0
}

// A set of scenarios to be run with qps_json_driver
type Scenarios struct {
	Scenarios []*Scenario `protobuf:"bytes,1,rep,name=scenarios" json:"scenarios,omitempty"`
}

func (m *Scenarios) Reset()                    { *m = Scenarios{} }
func (m *Scenarios) String() string            { return proto.CompactTextString(m) }
func (*Scenarios) ProtoMessage()               {}
func (*Scenarios) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *Scenarios) GetScenarios() []*Scenario {
	if m != nil {
		return m.Scenarios
	}
	return nil
}

func init() {
	proto.RegisterType((*PoissonParams)(nil), "grpc.testing.PoissonParams")
	proto.RegisterType((*UniformParams)(nil), "grpc.testing.UniformParams")
	proto.RegisterType((*DeterministicParams)(nil), "grpc.testing.DeterministicParams")
	proto.RegisterType((*ParetoParams)(nil), "grpc.testing.ParetoParams")
	proto.RegisterType((*ClosedLoopParams)(nil), "grpc.testing.ClosedLoopParams")
	proto.RegisterType((*LoadParams)(nil), "grpc.testing.LoadParams")
	proto.RegisterType((*SecurityParams)(nil), "grpc.testing.SecurityParams")
	proto.RegisterType((*ClientConfig)(nil), "grpc.testing.ClientConfig")
	proto.RegisterType((*ClientStatus)(nil), "grpc.testing.ClientStatus")
	proto.RegisterType((*Mark)(nil), "grpc.testing.Mark")
	proto.RegisterType((*ClientArgs)(nil), "grpc.testing.ClientArgs")
	proto.RegisterType((*ServerConfig)(nil), "grpc.testing.ServerConfig")
	proto.RegisterType((*ServerArgs)(nil), "grpc.testing.ServerArgs")
	proto.RegisterType((*ServerStatus)(nil), "grpc.testing.ServerStatus")
	proto.RegisterType((*CoreRequest)(nil), "grpc.testing.CoreRequest")
	proto.RegisterType((*CoreResponse)(nil), "grpc.testing.CoreResponse")
	proto.RegisterType((*Void)(nil), "grpc.testing.Void")
	proto.RegisterType((*Scenario)(nil), "grpc.testing.Scenario")
	proto.RegisterType((*Scenarios)(nil), "grpc.testing.Scenarios")
	proto.RegisterEnum("grpc.testing.ClientType", ClientType_name, ClientType_value)
	proto.RegisterEnum("grpc.testing.ServerType", ServerType_name, ServerType_value)
	proto.RegisterEnum("grpc.testing.RpcType", RpcType_name, RpcType_value)
}

func init() { proto.RegisterFile("control.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1179 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0x6f, 0x6f, 0xdb, 0xb6,
	0x13, 0xb6, 0x1d, 0xdb, 0xb1, 0x4e, 0xb6, 0xe3, 0x1f, 0x7f, 0xe9, 0xa0, 0xa6, 0x69, 0x97, 0x6a,
	0x1b, 0x16, 0x64, 0x40, 0x5a, 0x78, 0x05, 0xba, 0x62, 0x2f, 0x02, 0xc7, 0x33, 0xea, 0x00, 0x69,
	0x96, 0xd1, 0x69, 0x87, 0xbe, 0x12, 0x18, 0x99, 0xb1, 0x85, 0xc8, 0xa2, 0x46, 0x52, 0x09, 0xf2,
	0x15, 0xf6, 0x99, 0xf6, 0x39, 0xf6, 0x35, 0xf6, 0x15, 0x06, 0xfe, 0x91, 0x23, 0xb9, 0x06, 0x9a,
	0x6d, 0xef, 0xc4, 0xbb, 0xe7, 0xe1, 0x91, 0xf7, 0xdc, 0x1d, 0x05, 0x9d, 0x90, 0x25, 0x92, 0xb3,
	0xf8, 0x30, 0xe5, 0x4c, 0x32, 0xd4, 0x9e, 0xf1, 0x34, 0x3c, 0x94, 0x54, 0xc8, 0x28, 0x99, 0xed,
	0x74, 0x53, 0x72, 0x17, 0x33, 0x32, 0x15, 0xc6, 0xbb, 0xe3, 0x0a, 0x49, 0xa4, 0x5d, 0xf8, 0x7d,
	0xe8, 0x9c, 0xb3, 0x48, 0x08, 0x96, 0x9c, 0x13, 0x4e, 0x16, 0x02, 0x3d, 0x87, 0x36, 0xbb, 0xba,
	0xa2, 0x9c, 0x4e, 0x03, 0x45, 0xf2, 0xaa, 0x7b, 0xd5, 0xfd, 0x2a, 0x76, 0xad, 0xed, 0x94, 0x91,
	0xa9, 0x4f, 0xa0, 0xf3, 0x3e, 0x89, 0xae, 0x18, 0x5f, 0x58, 0xce, 0xb7, 0xb0, 0x15, 0x25, 0x92,
	0x72, 0xc2, 0x79, 0x74, 0x43, 0xe2, 0x20, 0x66, 0x96, 0xd6, 0x2d, 0x9a, 0x4f, 0xd9, 0x27, 0xc0,
	0x79, 0xe4, 0xd5, 0x3e, 0x05, 0x8e, 0x23, 0xff, 0x07, 0xf8, 0xff, 0x4f, 0x54, 0x52, 0xbe, 0x88,
	0x92, 0x48, 0xc8, 0x28, 0x7c, 0xf8, 0xe1, 0x7e, 0x81, 0xf6, 0x39, 0xe1, 0x54, 0x32, 0x4b, 0xf9,
	0x0e, 0xfe, 0x57, 0x0a, 0x79, 0x49, 0x04, 0xb5, 0xbc, 0x5e, 0xd1, 0x71, 0x4c, 0x04, 0x45, 0xdb,
	0xd0, 0x20, 0x71, 0x3a, 0x27, 0xf6, 0x54, 0x66, 0xe1, 0x23, 0xe8, 0x0d, 0x63, 0x26, 0x54, 0x00,
	0x96, 0x9a, 0x6d, 0xfd, 0x3f, 0x6a, 0x00, 0x2a, 0x9e, 0x8d, 0x32, 0x00, 0x37, 0xd4, 0x90, 0x20,
	0x66, 0x2c, 0xd5, 0xfb, 0xbb, 0xfd, 0x67, 0x87, 0x45, 0x1d, 0x0e, 0x57, 0xf7, 0x18, 0x57, 0x30,
	0x84, 0x4b, 0x1b, 0x7a, 0x0d, 0x9b, 0xa9, 0x51, 0x42, 0x47, 0x77, 0xfb, 0x4f, 0xca, 0xf4, 0x92,
	0x4c, 0xe3, 0x0a, 0xce, 0xd1, 0x8a, 0x98, 0x19, 0x39, 0xbc, 0x8d, 0x75, 0xc4, 0x92, 0x56, 0x8a,
	0x68, 0xd1, 0xe8, 0x47, 0x68, 0x4e, 0x75, 0x92, 0xbd, 0xba, 0xe6, 0x3d, 0x2f, 0xf3, 0xd6, 0x08,
	0x30, 0xae, 0x60, 0x4b, 0x41, 0xaf, 0xa0, 0x99, 0xea, 0x3c, 0x7b, 0x0d, 0x4d, 0xde, 0x59, 0x39,
	0x6d, 0x41, 0x03, 0xc5, 0x32, 0xd8, 0xe3, 0x26, 0xd4, 0x95, 0x70, 0xfe, 0x25, 0x74, 0x27, 0x34,
	0xcc, 0x78, 0x24, 0xef, 0x6c, 0x06, 0x9f, 0x81, 0x9b, 0x09, 0x1a, 0x28, 0x7e, 0x10, 0x12, 0x9d,
	0xc1, 0x16, 0x76, 0x32, 0x41, 0x2f, 0xa8, 0x90, 0x43, 0x82, 0x5e, 0xc2, 0xb6, 0xa0, 0xfc, 0x86,
	0xf2, 0x60, 0xce, 0x84, 0x0c, 0xd8, 0x0d, 0xe5, 0x3c, 0x9a, 0x52, 0x9d, 0x2b, 0x07, 0x23, 0xe3,
	0x1b, 0x33, 0x21, 0x7f, 0xb6, 0x1e, 0xff, 0xf7, 0x06, 0xb4, 0x87, 0x71, 0x44, 0x13, 0x39, 0x64,
	0xc9, 0x55, 0x34, 0x43, 0xdf, 0x40, 0xd7, 0x6e, 0x21, 0x09, 0x9f, 0x51, 0x29, 0xbc, 0xea, 0xde,
	0xc6, 0xbe, 0x83, 0x3b, 0xc6, 0x7a, 0x61, 0x8c, 0xe8, 0x8d, 0xd2, 0x52, 0xd1, 0x02, 0x79, 0x97,
	0x9a, 0x00, 0xdd, 0xbe, 0xb7, 0xaa, 0xa5, 0x02, 0x5c, 0xdc, 0xa5, 0x54, 0x69, 0x98, 0x7f, 0xa3,
	0x11, 0x6c, 0x09, 0x7b, 0xad, 0x20, 0xd5, 0xf7, 0xb2, 0x92, 0xec, 0x96, 0xe9, 0xe5, 0xbb, 0xe3,
	0xae, 0x28, 0xe7, 0xe2, 0x08, 0x76, 0x59, 0x26, 0x85, 0x24, 0xc9, 0x34, 0x4a, 0x66, 0x01, 0x4f,
	0x43, 0x11, 0xa4, 0x94, 0x07, 0xe1, 0x9c, 0x24, 0x09, 0x8d, 0xb5, 0x5c, 0x0d, 0xfc, 0xb8, 0x80,
	0xc1, 0x69, 0x28, 0xce, 0x29, 0x1f, 0x1a, 0x80, 0xea, 0x33, 0x7b, 0x05, 0x4b, 0x11, 0x5a, 0xa5,
	0x06, 0xee, 0x1a, 0xb3, 0xc5, 0x09, 0x95, 0x55, 0x22, 0xee, 0x92, 0x30, 0xc8, 0x6f, 0x3c, 0xe7,
	0x94, 0x4c, 0x85, 0xb7, 0xa9, 0xd1, 0x48, 0xfb, 0xec, 0x5d, 0x8d, 0x07, 0xbd, 0x84, 0x16, 0x4f,
	0x43, 0x93, 0x9a, 0x96, 0x4e, 0xcd, 0xa3, 0xf2, 0xdd, 0x70, 0x1a, 0xea, 0xbc, 0x6c, 0x72, 0xf3,
	0xa1, 0xf2, 0xa9, 0x34, 0xcf, 0x13, 0x02, 0x3a, 0x21, 0x2b, 0xf9, 0xbc, 0x6f, 0x25, 0x0c, 0xf1,
	0x7d, 0x5b, 0x1d, 0x43, 0x3e, 0xbc, 0x82, 0x50, 0x6b, 0xe8, 0xb9, 0x6b, 0x5b, 0xc3, 0x60, 0x8c,
	0xcc, 0xb8, 0x93, 0x16, 0x97, 0x68, 0x0c, 0xbd, 0x79, 0x24, 0x24, 0x9b, 0x71, 0xb2, 0xc8, 0xcf,
	0xd0, 0xd6, 0xbb, 0x3c, 0x2d, 0xef, 0x32, 0xce, 0x51, 0xf6, 0x20, 0x5b, 0xf3, 0xb2, 0x01, 0x3d,
	0x01, 0x27, 0x64, 0x9c, 0x06, 0x71, 0x24, 0xa4, 0xd7, 0xd9, 0xdb, 0xd8, 0x6f, 0xe0, 0x96, 0x32,
	0x9c, 0x46, 0x42, 0xa2, 0xa7, 0x00, 0xd6, 0xb9, 0x88, 0xa4, 0xd7, 0xd5, 0xf9, 0x73, 0x8c, 0x77,
	0x11, 0x49, 0xff, 0x28, 0xaf, 0xc5, 0x89, 0x24, 0x32, 0x13, 0xe8, 0x05, 0x34, 0xf4, 0x18, 0xb6,
	0xa3, 0xe2, 0xf1, 0xba, 0xf2, 0x52, 0x50, 0x81, 0x0d, 0xce, 0xdf, 0x85, 0xfa, 0x3b, 0xc2, 0xaf,
	0xd5, 0x88, 0xe2, 0x54, 0x50, 0x69, 0x3b, 0xc4, 0x2c, 0xfc, 0x0c, 0xc0, 0x70, 0x06, 0x7c, 0x26,
	0x50, 0x1f, 0x1a, 0x82, 0xca, 0x2c, 0x9f, 0x43, 0x3b, 0xeb, 0x36, 0x37, 0xd9, 0x19, 0x57, 0xb0,
	0x81, 0xa2, 0x7d, 0xa8, 0x2f, 0x08, 0xbf, 0xb6, 0xb3, 0x07, 0x95, 0x29, 0x2a, 0xf2, 0xb8, 0x82,
	0x35, 0xe2, 0xd8, 0x81, 0x4d, 0xc2, 0x67, 0xaa, 0x00, 0xfc, 0x3f, 0x6b, 0xd0, 0x9e, 0xe8, 0xe6,
	0xb1, 0xc9, 0x7e, 0x03, 0x6e, 0xde, 0x62, 0xaa, 0x40, 0xaa, 0xeb, 0x7a, 0xc7, 0x10, 0x4c, 0xef,
	0x88, 0xe5, 0xf7, 0xba, 0xde, 0xa9, 0xfd, 0x8b, 0xde, 0x41, 0x50, 0x4f, 0x19, 0x97, 0xb6, 0x47,
	0xf4, 0xf7, 0x7d, 0x95, 0xe7, 0x67, 0x5b, 0x53, 0xe5, 0xf6, 0x54, 0xb6, 0xca, 0xcb, 0x6a, 0xb6,
	0x56, 0xd4, 0x5c, 0x53, 0x97, 0xce, 0x3f, 0xae, 0xcb, 0x52, 0x35, 0x41, 0xb9, 0x9a, 0x94, 0x9e,
	0xe6, 0x40, 0x0f, 0xd0, 0xb3, 0x28, 0xc0, 0x7f, 0xd4, 0x33, 0xca, 0xe5, 0x7c, 0x50, 0x95, 0xde,
	0x43, 0xf3, 0x2a, 0x5d, 0x66, 0xbf, 0x56, 0xc8, 0xfe, 0x36, 0x34, 0xd4, 0xbd, 0xcc, 0x28, 0x6c,
	0x60, 0xb3, 0xf0, 0x3b, 0xe0, 0x0e, 0x19, 0xa7, 0x98, 0xfe, 0x96, 0x51, 0x21, 0xfd, 0xaf, 0xa1,
	0x6d, 0x96, 0x22, 0x65, 0x89, 0x79, 0x89, 0x0d, 0xa9, 0x5a, 0x24, 0x35, 0xa1, 0xfe, 0x81, 0x45,
	0x53, 0xff, 0xaf, 0x1a, 0xb4, 0x26, 0x21, 0x4d, 0x08, 0x8f, 0x98, 0x8a, 0x99, 0x90, 0x85, 0x29,
	0x36, 0x07, 0xeb, 0x6f, 0x74, 0x04, 0x9d, 0x7c, 0x00, 0x1a, 0x7d, 0x6a, 0x9f, 0xeb, 0x04, 0xdc,
	0x0e, 0x8b, 0x6f, 0xc5, 0x97, 0xe0, 0x26, 0xd9, 0xc2, 0x8e, 0xc5, 0xfc, 0xe8, 0x90, 0x64, 0x0b,
	0xc3, 0x51, 0x33, 0xda, 0x3e, 0x1b, 0x79, 0x84, 0xfa, 0xe7, 0xb4, 0xc1, 0x6d, 0x51, 0x6c, 0x15,
	0x1b, 0xc1, 0xd8, 0xf2, 0xf9, 0xac, 0x22, 0x18, 0x8e, 0x50, 0xcf, 0xd5, 0x2d, 0xe1, 0x8b, 0x2c,
	0x0d, 0x04, 0x0d, 0x59, 0x32, 0x15, 0x5e, 0x53, 0x63, 0x3a, 0xc6, 0x3a, 0x31, 0x46, 0xf5, 0x83,
	0x73, 0x49, 0x93, 0x70, 0xae, 0xb4, 0x5c, 0x22, 0x4d, 0x65, 0xf7, 0x96, 0x8e, 0x1c, 0xfc, 0x1a,
	0x3c, 0x91, 0x92, 0xdb, 0x24, 0x88, 0x59, 0x48, 0xe2, 0xe0, 0x96, 0xf1, 0x6b, 0x7d, 0x83, 0x2c,
	0xc9, 0xab, 0xfc, 0x91, 0xf6, 0x9f, 0x2a, 0xf7, 0xaf, 0xda, 0x3b, 0x54, 0x4e, 0x7f, 0x00, 0x4e,
	0x9e, 0x70, 0x81, 0x5e, 0x81, 0x23, 0xf2, 0x85, 0x7e, 0x43, 0xdd, 0xfe, 0x17, 0x2b, 0xf7, 0xb6,
	0x6e, 0x7c, 0x0f, 0x3c, 0x78, 0x91, 0xcf, 0x28, 0xdd, 0xee, 0x5b, 0xe0, 0x4e, 0x3e, 0x9e, 0x0d,
	0x83, 0xe1, 0xe9, 0xc9, 0xe8, 0xec, 0xa2, 0x57, 0x41, 0x3d, 0x68, 0x0f, 0x8a, 0x96, 0xea, 0xc1,
	0x49, 0xde, 0x04, 0x25, 0xc2, 0x64, 0x84, 0x3f, 0x8c, 0x70, 0x91, 0x60, 0x2d, 0x55, 0xe4, 0xc1,
	0xb6, 0xb1, 0xbc, 0x1d, 0x9d, 0x8d, 0xf0, 0xc9, 0xd2, 0x53, 0x3b, 0xf8, 0x0a, 0x36, 0xed, 0xbb,
	0x84, 0x1c, 0x68, 0xbc, 0x3f, 0x1b, 0xe0, 0x8f, 0xbd, 0x0a, 0xea, 0x80, 0x33, 0xb9, 0xc0, 0xa3,
	0xc1, 0xbb, 0x93, 0xb3, 0xb7, 0xbd, 0xea, 0x65, 0x53, 0xff, 0x12, 0x7f, 0xff, 0x77, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x75, 0x59, 0xf4, 0x03, 0x4e, 0x0b, 0x00, 0x00,
}
