-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_dialog.ads,v $
--  Description     : GUI top level window
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/07 17:44:02 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Gtk.Box;                use Gtk.Box;
with Gtk.Dialog;             use Gtk.Dialog;

package GUI_Dialog is

   type Object is tagged private;
   type Handle is access all Object'Class;

   procedure Initialize(
      This  : in out Object );

   procedure Finalize(
      This  : in out Object );

   procedure Add_Dialog(
      This  : in out Object'Class;
      Title : in String;
      SizeX : in Integer := 0;
      SizeY : in Integer := 0 );

   procedure Dialog_Contents(
      This : in out Object;
      Vbox : in Gtk_Box );

   procedure Add_Command(
      This : in out Object'Class;
      Text : in String;
      Cmd  : in Natural );

   procedure Command(
      This : in out Object;
      Cmd  : in Natural );

   Dlg_Cmd_Dismiss : constant Natural := 0;

private

   type Object is tagged record
         Dialog : Gtk_Dialog;
         Self   : Handle := null;
         Area   : Gtk_Box;       -- box where all command go into
         Vbox   : Gtk_Box;       -- boy where all dialog elements will be placed
      end record;

end GUI_Dialog;
