#!/bin/bash
#
# install gnade packages (normally in the chroot that just built it),
# and run examples using installed libraries.

# usage (as root, not yet in chroot):
# cd gnade-<version>/debian
# /etc/init.d/mysql stop
# schroot ./test_installed.sh

# This re-installs the latest version.

sudo dpkg --install ../../libgnadecommon${common_soversion}_1.6.2-${debversion}_i386.deb
sudo dpkg --install ../../libgnadeodbc${odbc_soversion}_1.6.2-${debversion}_i386.deb
sudo dpkg --install ../../libgnadesqlite3-${sqlite3_soversion}_1.6.2-${debversion}_i386.deb

sudo dpkg --install ../../libgnadecommon${common_aliversion}-dev_1.6.2-${debversion}_i386.deb
sudo dpkg --install ../../libgnadeodbc${odbc_aliversion}-dev_1.6.2-${debversion}_i386.deb
sudo dpkg --install ../../libgnadesqlite3-${sqlite3_aliversion}-dev_1.6.2-${debversion}_i386.deb

# tmp is owned by root; we need write permission
sudo chmod -R o+w tmp

rm -rf tmp/odbc-example-obj
rm -rf tmp/sqlite3-example-obj

if [ ! -d tmp/odbc-example-src ]; then mkdir tmp/odbc-example-src; fi
if [ ! -d tmp/sqlite3-example-src ]; then mkdir tmp/sqlite3-example-src; fi

gunzip -c /usr/share/doc/libgnadeodbc${odbc_aliversion}-dev/examples/demo.adb.gz > tmp/odbc-example-src/demo.adb
cp /usr/share/doc/libgnadesqlite3-${sqlite3_aliversion}-dev/examples/demo.adb tmp/sqlite3-example-src

gnatmake -p -Pgnade_odbc_example_installed
gnatmake -p -Pgnade_sqlite3_example_installed

if [ ! -f odbc-sqladmin-stamp ]; then
    /etc/init.d/mysql start;
    mysqladmin -uroot create gnade;
    echo "create user gnade identified by 'gnade'" | mysql -uroot;
    echo "grant all on gnade.* to gnade" | mysql -uroot;
    mysql -ugnade -pgnade < ../samples/sample_db/gnade.mysql.sql;
    odbcinst -i -d -f odbc_mysql_driver.ini;
    odbcinst -i -s -l -f odbc_mysql_source.ini;
    touch odbc-sqladmin-stamp
fi

tmp/odbc-example-obj/demo

# this creates 'demo.db' in current directory
cd tmp; sqlite3-example-obj/demo

# end of file
