# はじめに

*ghostwriter*にようこそ！  このクイック リファレンス ガイドではMarkdownの記述例を提示します。(MarkdownはJohn Gruber氏が作成したプレーンテキスト形式のマークアップ言語です。)  さらに詳しい情報やヘルプはJohn Gruber氏のウェブサイト <http://www.daringfireball.net> を訪れてください。  *ghostwriter*の公式ウェブサイトは <http://www.github.com/wereturtle/ghostwriter> です。

*ghostwriter*は標準でSundownプロセッサが組み込まれています。  しかしながらPandoc、MultiMarkdown、Discount、またはcmarkプロセッサを自動検出することも可能です。  後者3つのどれかまたはすべてを使用するには、単にそれらをインストールし、それらのインストール場所をシステムの`PATH`環境変数に加えるだけです。  *ghostwriter*は起動時にそれらのインストールを自動検出し、ライブHTMLプレビューやエクスポートの選択肢として使用できます。

# 見出し

    # 見出しレベル 1
    ## 見出しレベル 2 ##
    ###### 見出しレベル 6
    
    見出しレベル 1
    ===============
    ここは本文
    
    見出しレベル 2
    ---------------
    ここは別の本文

# 段落

    これは段落です。
    これは手動で改行した同じ段落内の別の行です。
    
    これは新しい段落です。

# インライン書式

*斜体* や **太字** にするには2つの方法があります。  1つめはテキストをアスタリスク(\*)で囲む方法で、2つめはアンダースコア(\_)で囲む方法です。

    これはアスタリスクを使って *斜体* にしています。
    これはアンダースコアを使って _斜体_ にしています。
    
    これはアスタリスクを使って **太字** にしています。
    これはアンダースコアを使って __太字__ にしています。

このように対にして組み合わせることで ***太字かつ斜体*** にすることもできます。:

    これはアスタリスクを使って ***太字かつ斜体*** にしています。
    これは両者を組み合わせて **_太字かつ斜体_** にしています。
    これは別の組み合わせで *__太字かつ斜体__* にしています。
    等々

# リンク

さまざまなウェブサイトにリンクすることができます:

    [ここ](http://url.com "タイトル")をクリックしてウェブサイトに行く。

参照リンクを使用することもできます:

    [これ][id]は次のように定義されたリンクを参照します。
    
    [id]: http://url.com "タイトル"

# 画像

このように画像を埋め込むことができます:

    ![代替テキスト](./image.jpg "タイトル")

参照リンクと同じ構文を使用することもできます:

    ![代替テキスト][id]は次のように定義された画像を参照します。
    
    [id]: ./image.jpg "タイトル"

# リスト

番号付きリストが使用できます:

    1. 項目 1
    2. 項目 2
    3. 項目 3

または順序なしリストが使用できます:

    * 項目 1
    + 項目 2
    - 項目 3

それらが混在した入れ子状態のリストを使用できます:

    1. 項目 1
        * サブ項目 1
        * サブ項目 2
    2. 項目 2
        - サブ項目 1
        - サブ項目 2
    3. 項目 3
        1. サブ項目 1

# コード ブロック

4つ以上のスペースまたはタブ文字でインデントすることで、コード ブロックを作成できます:

    これは普通の段落です。後ろにコード ブロックが続きます。
        
        for (int i = 0; i < 10; i++) {
            System.out.println("i = " + i);
        }
        
    上記は整形済みのコード ブロックとして表示されます。

PandocやGithubなどのいくつかのMarkdownコンバーターでは、ブロックをインデントする代わりに、このようにGithub-Flavored Markdownのバッククォートを使ってコード ブロックを区切ることができます:

    ```
    for (int i = 0; i < 10; i++) {
        System.out.println("i = " + i);
    }
    ```

上記も同様に整形済みのコード ブロックとして表示されます。

# コード範囲

段落の途中でコード部分を区切るために、`` `<html>` ``タグ、のようにバッククォートが使用できます。  1つ以上のバッククォートを使用することで、``` `` `エスケープされたバッククォート` `` ```のようにバッククォートをリテラル文字として使用できます。

# 引用

このように引用ブロックを区切るためにEメール形式のアングルブラケットが使用できます:

    > これは引用ブロックです。
    >
    >> これは入れ子状態の引用ブロックです。

# 区切り線

このように区切り線には3つ以上のダッシュ(\-)、アンダースコア(\_)、またはアスタリスク(\*)を使用します:

    ---
    
    ***
    ___

文字間にスペースを挟むこともできます:

    - - -

# Markdown 拡張

いくつかのMarkdownプロセッサは、オリジナルのJohn Gruber氏のMarkdown仕様を拡張するために、表や脚注などのための構文を追加しています。  下の例はPandoc、MultiMarkdown、その他のプロセッサが対応している脚注の例です:

    これは脚注が付けられている本文です。[^footnoteid]
    
    [^footnoteid]:  これは脚注です。

下の例はPandocの表です:

       列 1            列 2
    ----------     ----------
    Row Text 1     Row Text 2
    Row Text 1     Row Text 2
    
    表:  Pandocの表の例

下の例はSundownまたはMultiMarkdownの表です:

       列 1     |      列 2
    ----------  |  ----------
    Row Text 1  |  Row Text 2
    Row Text 1  |  Row Text 2

これらのMarkdownプロセッサはさらなる表の記述構文に対応しています。またこれら以外にも多くの拡張があります。これらのプロセッサのさらに詳しい情報は、以下のウェブサイトを訪問してください:

+ Sundown: <http://github.com/vmg/sundown/>
+ Pandoc: <http://johnmacfarlane.net/pandoc/>
+ MultiMarkdown: <http://fletcherpenney.net/multimarkdown/>
+ Discount: <http://www.pell.portland.or.us/~orc/Code/discount/>
+ cmark: <http://github.com/jgm/cmark/>

オリジナルのJohn Gruber氏のMarkdown仕様は <http://daringfireball.net/projects/markdown/> にあります。

# Ghostwriterのショートカット

*ghostwriter*はMarkdown編集のためのいくつかのショートカット キーに対応しています:

`Ctrl+B`
:   太字(重要)を適用します。

`Ctrl+I`
:   斜体(強調)を適用します。

`Ctrl+K`
:   取り消し線を適用します。

`Ctrl+/`
:   `Ctrl`と`/`キーを押すと、 カーソル位置にHTMLコメントタグを挿入するか、選択テキストをHTMLコメントにします。

`Tab`
:   テキストが選択されている時に`Tab`キーを押すと、選択行のテキストをインデントします。

`Shift+Tab`
:   テキストが選択されている時に`Shift`と`Tab`キーを押すと、選択行のテキストを逆インデントします。

`Shift+Enter`
:   Markdown形式の改行を挿入します。

`Ctrl+Enter`
:   通常の改行を挿入しますが、インデントを無視します。  つまりインデント行で入力中に`Ctrl+Enter`キーを押すと、新しい行にはインデントは追加されません。  `Ctrl`キーは`Shift`キーと併用して使用でき、その場合Markdown形式の改行とインデントの解除の両方が適用されます。

`Ctrl+.`
:   `Ctrl`と`.`キーを押すと現在行または選択行を引用ブロックにします。

`Ctrl+,`
:   `Ctrl`と`,`キーを押すと現在行または選択行の引用ブロックを解除します。

`Ctrl+8`
:   `Ctrl`と`8`キーを押すと現在行または選択行を`*`マーク付きの順序なしリストにします。  たとえば以下の行を選択しているときに:

        項目 1
        項目 2
        
    `Ctrl+8`キーを押すと選択行はこのように順序なしリストに変わります:

        * 項目 1
        * 項目 2

`Ctrl+Shift+-`
:   `Ctrl`と`Shift`と`-`キーを押すと現在行または選択行を`-`マーク付きの順序なしリストにします。  たとえば以下の行を選択しているときに:

        項目 1
        項目 2
        
    `Ctrl+Shift+-`キーを押すと選択行はこのように順序なしリストに変わります:

        - 項目 1
        - 項目 2

`Ctrl+Shift+=`
:   `Ctrl`と`Shift`と`=`キーを押すと現在行または選択行を`+`マーク付きの順序なしリストにします。  たとえば以下の行を選択しているときに:

        項目 1
        項目 2
        
    `Ctrl+Shift+=`キーを押すと選択行はこのように順序なしリストに変わります:

        + 項目 1
        + 項目 2

`Ctrl+1`
:   `Ctrl`と`1`(数字キー 1)キーを押すと現在行または選択行を`.`マーク付きの番号付きリストにします。  たとえば以下の行を選択しているときに:

        項目 1
        項目 2
        
    `Ctrl+1`キーを押すと選択行はこのように番号付きリストに変わります:

        1. 項目 1
        2. 項目 2

`Ctrl+0`
:   `Ctrl`と`0`キーを押すと現在行または選択行を`)`マーク付きの番号付きリストにします。 たとえば以下の行を選択しているときに:

        項目 1
        項目 2
        
    `Ctrl+0`キーを押すと選択行はこのように番号付きリストに変わります:

        1) 項目 1
        2) 項目 2

`Ctrl+T`
:   `Ctrl+T`キーを押すと現在行または選択行をGithub-Flavored Markdownのタスクリスト項目にします。  たとえば以下の行を選択しているときに:

        重要なタスク
        別の重要なタスク
        
    `Ctrl+T`キーを押すと選択行はこのようにタスクリストに変わります:

        - [ ] 重要なタスク
        - [ ] 別の重要なタスク

`Ctrl+D`
:   現在行がGithub-Flavored Markdownのタスクリスト項目である場合に、`Ctrl+D`キーでタスクの完了状態を切り替えます。タスクが完了した場合にはチェックボックスに`x`マークを挿入し、タスクが未完了の場合には`x`マークを削除します。例:

        - [ ] これは未完了のタスクです。
        - [x] `Ctrl+D`でこのタスクを完了にします！

`"`, `'`, `(`, `[`, `{`, `*`, `_`, `` ` ``, `<`
:   単一行内のテキストが選択されている時に上記の文字のいずれかを入力すると、選択テキストは入力した文字とそれに対応する終了文字とで囲まれます。  たとえば、`dog`という単語を選択している時に`(`文字を入力すると、括弧で囲まれて`(dog)`のようになります。  次の表は入力した文字とそれに対応する終了文字の表です:

      開始   |   終了
    --------|--------
    `"`     | `"`
    `'`     | `'`
    `(`     | `)`
    `[`     | `]`
    `{`     | `}`
    `*`     | `*`
    `_`     | `_`
    `` ` `` | `` ` ``
    `<`     | `>`
    
    入力時に記号の自動補間を有効にするには、メニューバーの"設定"メニューの"対応する記号の自動補間"を有効にします。  また"設定"メニューの"自動補間する記号の設定..."を選択して、記号ごとに補完の有効無効を設定することができます。

画像ファイルのドラッグ アンド ドロップ
:   "編集"メニューから"画像の挿入..."を選択する代わりに、任意の画像ファイルをファイルシステムから編集ウィンドウにドラッグ アンド ドロップすることができます。 アプリは現在のドキュメントから画像ファイルへの相対パスでインライン画像テキストを挿入します。あるいはドキュメントが保存されていない場合には絶対パスで挿入します。  例:

        ![](../../relative/path/to/your/file.png)

    ドキュメントが保存されていない場合は:

        ![](file:///full/path/to/your/file.png)

- - - -

Copyright (c) 2014-2017 [wereturtle](http://www.github.com/wereturtle)