/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <string.h>
/* For getuid */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>

#include "gettext.h"
#include "support.h"
#include "create_main_window.h"
#include "gadmin-openvpn.h"
#include "widgets.h"
#include "commands.h"
#include "functions.h"
#include "status_update.h"
#include "set_version.h"
#include "standard_conf.h"
#include "create_server_tab.h"
#include "create_server_settings.h"
#include "create_user_tab.h"
#include "create_user_settings.h"
#include "create_disc_tab.h"
#include "create_conn_tab.h"
#include "create_log_tab.h"
#include "create_conf_tab.h"
#include "populate_gadmin_openvpn.h"
#include "show_info.h"

int MAX_READ_POPEN = 16384;
int activated = 0;

int info_window_exit_main = 0;
char global_user_name[1024]="";


int main(int argc, char *argv[])
{
    int i = 0;
    gchar *info, *utf8;
    gchar *openvpn_server_conf, *openvpn_server_dir;
    gchar *openssl_conf;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);

    wid* widgets = g_malloc(sizeof(wid));

    /* Non root usage */
    if( ! getuid() == 0 )
    {
	/* For setting a different exit method in the info window */
	info_window_exit_main = 1;

        info = g_strdup_printf("You must be root to run: %s\nThis window will close in 10 seconds.\n", PACKAGE);
        show_info(info);
        g_free(info);

	/* Users can close the info window earlier then the timeout */
	for(i=0; i<10; i++)
	{
    	    while(gtk_events_pending())
                  gtk_main_iteration();

	    /* Set when close info window is clicked */
	    if( info_window_exit_main == 2 )
	      break;

    	    usleep(100000*10);
    	}

	g_free(widgets);
	return 0;
    }


    /* Create the main window */
    create_main_window(widgets);

    /* Set OpenVPN version */
    set_version(widgets);

    /* Create the server tab */
    create_server_tab(widgets);

    /* Create the server settings */
    create_server_settings(widgets);

    /* Create the user tab */
    create_user_tab(widgets);

    /* Create the user settings */
    create_user_settings(widgets);

    /* Create the log tab */
    create_log_tab(widgets);

    /* Create the connections tab */
    create_conn_tab(widgets);

    /* Create the disc tab */
    create_disc_tab(widgets);

    /* Create the conf tab */
    create_conf_tab(widgets);


    /* Create the gadmin-openvpn directory if it doesnt exist */
    openvpn_server_dir = g_strdup_printf("%s", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_server_dir) )
      make_dir_chmod(openvpn_server_dir, "600"); /* Only accessible by root */
    g_free(openvpn_server_dir);

    /* Create the openvpn server directory if it doesnt exist */
    openvpn_server_dir = g_strdup_printf("%s/server", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_server_dir) )
      make_dir_chmod(openvpn_server_dir, "600"); /* Only accessible by root */
    g_free(openvpn_server_dir);

    /* Create the openvpn server certs directory if it doesnt exist */
    openvpn_server_dir = g_strdup_printf("%s/server/certs", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_server_dir) )
      make_dir_chmod(openvpn_server_dir, "600"); /* Only accessible by root */
    g_free(openvpn_server_dir);

    /* Create the openvpn server directory for client configuration if it doesnt exist */
    openvpn_server_dir = g_strdup_printf("%s/server/client", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_server_dir) )
      make_dir_chmod(openvpn_server_dir, "600"); /* Only accessible by root */
    g_free(openvpn_server_dir);

    /* Create the openvpn server directory for client certs if it doesnt exist */
    openvpn_server_dir = g_strdup_printf("%s/server/client/certs", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_server_dir) )
      make_dir_chmod(openvpn_server_dir, "600"); /* Only accessible by root */
    g_free(openvpn_server_dir);


    /* Add default certificate settings if they are missing */
    openssl_conf = g_strdup_printf("%s/server/certs/gadmin-openvpn-openssl.conf", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openssl_conf) )
    {
        info = g_strdup_printf("localhost");
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[10]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

        info = g_strdup_printf("email@example.org");
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[11]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

        info = g_strdup_printf(_("Country"));
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[12]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

        info = g_strdup_printf(_("City"));
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[13]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

        info = g_strdup_printf(_("Organization name"));
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[14]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

        info = g_strdup_printf(_("Organization department"));
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[15]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

	/* Password entry is located at 16 */

        info = g_strdup_printf("EN");
        utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[17]), utf8);
        g_free(info);
        if( utf8!=NULL )
          g_free(utf8);

        gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[5]), 1024);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[6]), 999999);
    }
    g_free(openssl_conf);


    /* If theres no gadmin-openvpn-server.conf, add one */
    openvpn_server_conf = g_strdup_printf("%s/server/gadmin-openvpn-server.conf", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_server_conf) )
      add_standard_conf(widgets);
    else
      /* If the conf is bad, ask to add a new one */
    if( ! conf_ok(openvpn_server_conf) )
      create_standard_conf_question(widgets);
    else
      /* The conf is ok, populate the entire gui */
      populate_gadmin_openvpn(widgets);

    g_free(openvpn_server_conf);


    /* Window close button (x) */   
    g_signal_connect(GTK_OBJECT(widgets->main_window), "destroy",
	             GTK_SIGNAL_FUNC(gtk_main_quit), NULL);


    gtk_timeout_add(1000, (GtkFunction) status_update, widgets);

    gtk_main();

    g_free(widgets);


    return 0;
}
