/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2015 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_assembler.h>
#include "instructions_a_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_a_suite_init(void) {
    return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_a_suite_cleanup(void) {
    return FCML_TRUE;
}

void fcml_tf_instruction_AAA(void) {
    FCML_I32( "aaa", 0x37 );
    FCML_A32( "aaa", 0x37 );
}

void fcml_tf_instruction_AAD(void) {
    FCML_I32( "aad", 0xD5, 0x0A );
    FCML_A32( "aad", 0xD5, 0x0A );
    FCML_I64_FAILED( "aad", 0xD5, 0x0A );
    FCML_I32( "aad 0ch", 0xD5, 0x0C );
    FCML_A32( "aad $0x0c", 0xD5, 0x0C );
    FCML_I64_FAILED( "aad 0ch", 0xD5, 0x0C );
}

void fcml_tf_instruction_AAM(void) {
    FCML_I32( "aam", 0xD4, 0x0A );
    FCML_A32( "aam", 0xD4, 0x0A );
    FCML_I64_FAILED( "aam", 0xD4, 0x0A );
    FCML_I32( "aam 0ch", 0xD4, 0x0C );
    FCML_A32( "aam $0x0c", 0xD4, 0x0C );
    FCML_I64_FAILED( "aam 0ch", 0xD4, 0x0C );
    FCML_I64_FAILED( "aam $0x0c", 0xD4, 0x0C );
}

void fcml_tf_instruction_AAS(void) {
    FCML_I32( "aas", 0x3F );
    FCML_A32( "aas", 0x3F );
    FCML_I64_FAILED( "aas", 0x3F );
}

void fcml_tf_instruction_ADC(void) {
    FCML_I32_FAILED( "lock adc al,42h", 0xF0, 0x14, 0x42 );
    FCML_A3264_M( "adc $0x42,%al", 2, FCML_MI( 0x14, 0x42 ), FCML_MI( 0x80, 0xD0, 0x42 ) );
    FCML_I3264_M( "adc al,42h", 2, FCML_MI( 0x14, 0x42 ), FCML_MI( 0x80, 0xD0, 0x42 ) );
    FCML_I3264_M( "adc al,0ffh", 2, FCML_MI( 0x14, 0xFF ), FCML_MI( 0x80, 0xD0, 0xFF ) );
    FCML_I3264_M( "adc al,00h", 2, FCML_MI( 0x14, 0x00 ), FCML_MI( 0x80, 0xD0, 0x00 ) );

    FCML_I3264_M( "adc ax,8042h", 2, FCML_MI( 0x66, 0x15, 0x42, 0x80 ), FCML_MI( 0x66, 0x81, 0xd0, 0x42, 0x80 ) );
    FCML_A32_M( "adc $0x8042,%ax", 2, FCML_MI( 0x66, 0x81, 0xd0, 0x42, 0x80 ), FCML_MI( 0x66, 0x15, 0x42, 0x80 ) );
    FCML_I32_FAILED( "lock adc ax,8042h", 0xF0, 0x66, 0x15, 0x42, 0x80 );
    FCML_I3264_M( "adc eax,42806521h", 2, FCML_MI( 0x15, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x81, 0xd0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_D( "adc eax,42806521h", 0x40, 0x15, 0x21, 0x65, 0x80, 0x42 );
    FCML_A32_M( "adc $0x8042,%ax", 2, FCML_MI( 0x66, 0x81, 0xd0, 0x42, 0x80 ), FCML_MI( 0x66, 0x15, 0x42, 0x80 ) );
    FCML_I64_D( "adc ax,6521h", 0x66, 0x40, 0x15, 0x21, 0x65 );

    FCML_I64_M( "adc rax,0000000042806521h", 2, FCML_MI( 0x48, 0x15, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x48, 0x81, 0xd0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_A64_M( "adc $0x0000000042806521,%rax", 2, FCML_MI( 0x48, 0x15, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x48, 0x81, 0xd0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_D( "adc rax,0000000042806521h", 0x66, 0x48, 0x15, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "adc rax,0000000042806521h", 0x67, 0x66, 0x48, 0x15, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "adc rax,0ffffffffffffffffh", 0x67, 0x66, 0x48, 0x15, 0xff, 0xff, 0xff, 0xff );

    FCML_I32( "adc byte ptr [04030201h],0ffh", 0x80, 0x15, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_A32( "adcb $0xff,0x04030201", 0x80, 0x15, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "lock adc byte ptr [04030201h],0ffh", 0xF0, 0x80, 0x15, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_A32( "lock adcb $0xff,0x04030201", 0xF0, 0x80, 0x15, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "adc byte ptr [esi+04030201h],0ffh", 0x80, 0x96, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "adc byte ptr [ecx+eax+00000002h],03h", 0x80, 0x54, 0x01, 0x02, 0x03 );

    FCML_A32( "adcl $0x04030201,(%eax)", 0x81, 0x10, 0x01, 0x02, 0x03, 0x04 );
    FCML_I3264( "adc ebp,04030201h", 0x81, 0xD5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32_M( "adc $0x42806521,%eax", 2, FCML_MI( 0x81, 0xd0, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x15, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I32_A_FAILED( "lock adc ebp,04030201h", 0xF0, 0x81, 0xD5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I16( "adc bp,0201h", 0x81, 0xD5, 0x01, 0x02 );
    FCML_I3264( "adc bp,0201h", 0x66, 0x81, 0xD5, 0x01, 0x02 );
    FCML_I64_D( "adc bp,0201h", 0x67, 0x66, 0x40, 0x81, 0xD5, 0x01, 0x02 );

    FCML_I64( "adc rbp,0000000004030201h", 0x48, 0x81, 0xD5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "adcq $0x0000000004030201,(%rax)", 0x48, 0x81, 0x10, 0x01, 0x02, 0x03, 0x04 );

    FCML_A64_A_FAILED( "adc $0x0000000004030201,(%rax)", 0x48, 0x81, 0x10, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64_D_FAILED( "adc $0x0000000004030201,(%rax)", 0x48, 0x81, 0x10, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "adc $0x0000000004030201,%rbp", 0x48, 0x81, 0xD5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64_A_FAILED( "lock adc rbp,0000000004030201h", 0xF0, 0x48, 0x81, 0xD5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64_A_FAILED( "lock adc $0x0000000004030201,%rbp", 0xF0, 0x48, 0x81, 0xD5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64_M( "adc rbp,0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x81, 0xD5, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x48, 0x83, 0xd5, 0xff ) );
    FCML_I64_D( "adc rbp,0ffffffffffffffffh", 0x67, 0x48, 0x81, 0xD5, 0xff, 0xff, 0xff, 0xff );
    FCML_I64_D( "adc rbp,0ffffffffffffffffh", 0x66, 0x48, 0x81, 0xD5, 0xff, 0xff, 0xff, 0xff );

    FCML_I32_M( "lock adc dword ptr [esi],00000001h", 2, FCML_MI( 0xF0, 0x83, 0x16, 0x01 ), FCML_MI( 0xF0, 0x81, 0x16, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xacquire lock adc dword ptr [esi],00000001h", 2, FCML_MI( 0xF2, 0xF0, 0x83, 0x16, 0x01 ), FCML_MI( 0xF2, 0xF0, 0x81, 0x16, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_A32_M( "xacquire lock adcl $0x00000001,(%esi)", 2, FCML_MI( 0xF2, 0xF0, 0x83, 0x16, 0x01 ), FCML_MI( 0xF2, 0xF0, 0x81, 0x16, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xrelease lock adc dword ptr [esi],00000001h", 2, FCML_MI( 0xF3, 0xF0, 0x83, 0x16, 0x01 ), FCML_MI( 0xF3, 0xF0, 0x81, 0x16, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "lock adc dword ptr [esi],00000001h", 2, FCML_MI( 0xF0, 0x83, 0x16, 0x01 ), FCML_MI( 0xF0, 0x81, 0x16, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "adc word ptr [esi],0001h", 2, FCML_MI( 0x66, 0x83, 0x16, 0x01 ), FCML_MI( 0x66, 0x81, 0x16, 0x01, 0x00 ) );
    FCML_I64_M( "adc word ptr [rsi],0001h", 2, FCML_MI( 0x66, 0x83, 0x16, 0x01 ), FCML_MI( 0x66, 0x81, 0x16, 0x01, 0x00 ) );
    FCML_I32_M( "adc dword ptr [0201h],00000003h", 2, FCML_MI( 0x67, 0x83, 0x16, 0x01, 0x02, 0x03 ), FCML_MI( 0x67, 0x81, 0x16, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "adc word ptr [0201h],0ffffh", 2, FCML_MI( 0x66, 0x67, 0x83, 0x16, 0x01, 0x02, 0xFF ), FCML_MI( 0x66, 0x67, 0x81, 0x16, 0x01, 0x02, 0xff, 0xff ) );
    FCML_I32_M( "adc dword ptr [0201h],00000003h", 2, FCML_MI( 0x67, 0x83, 0x16, 0x01, 0x02, 0x03 ), FCML_MI( 0x67, 0x81, 0x16, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00 ) );
    FCML_I64_RIP_M( "adc dword ptr [0000800000401007h],00000003h", 2, FCML_MI( 0x83, 0x15, 0x00, 0x00, 0x00, 0x00, 0x03 ), FCML_MI( 0x81, 0x15, 0xfd, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00 ) );

    FCML_A64_M( "adcl $0x00000003,0x00000000(%rip)", 2, FCML_MI( 0x83, 0x15, 0x00, 0x00, 0x00, 0x00, 0x03 ), FCML_MI( 0x81, 0x15, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00 ) );
    FCML_A64_M( "adcl $0x00000003,0x00000005(%rip)", 2, FCML_MI( 0x83, 0x15, 0x05, 0x00, 0x00, 0x00, 0x03 ), FCML_MI( 0x81, 0x15, 0x05, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00 ) );

    FCML_I64_M_A( "adc dword ptr [rip+0], 0x3", 2, FCML_MI( 0x83, 0x15, 0x00, 0x00, 0x00, 0x00, 0x03 ), FCML_MI( 0x81, 0x15, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00 ) );

    FCML_I64_M( "adc qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0x48, 0x83, 0x97, 0x01, 0x02, 0x03, 0x4, 0x05 ), FCML_MI( 0x48, 0x81, 0x97, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_A64_M( "adcq $0x0000000000000005,0x0000000004030201(%rdi)", 2, FCML_MI( 0x48, 0x83, 0x97, 0x01, 0x02, 0x03, 0x4, 0x05 ), FCML_MI( 0x48, 0x81, 0x97, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "adc qword ptr [rdi+0000000004030201h],0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x83, 0x97, 0x01, 0x02, 0x03, 0x4, 0xff ), FCML_MI( 0x48, 0x81, 0x97, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32( "lock adc byte ptr [ebp+04030201h],ah", 0xF0, 0x10, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "adc byte ptr [rbp+0000000000000001h],ah", 0x10, 0x65, 0x01 );
    FCML_A64( "adc %ah,0x0000000000000001(%rbp)", 0x10, 0x65, 0x01 );
    FCML_I64( "adc byte ptr [rbp+0000000000000001h],spl", 0x40, 0x10, 0x65, 0x01 );
    FCML_I64( "adc byte ptr [rbp+0000000000000001h],r12l", 0x44, 0x10, 0x65, 0x01 );
    FCML_I64_D( "adc byte ptr [rbp+0000000000000001h],spl", 0x48, 0x10, 0x64, 0xa5, 0x01 );
    FCML_I64_D( "adc byte ptr [rbp+0000000000000001h],spl", 0x40, 0x10, 0x64, 0xa5, 0x01 );
    FCML_I64_D( "adc byte ptr [rbp+0000000000000001h],ah", 0x10, 0x64, 0xa5, 0x01 );

    FCML_I32( "lock adc dword ptr [ebp+04030201h],esp", 0xF0, 0x11, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32_A( "lock adc [ebp+04030201h],esp", 0xF0, 0x11, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "adc word ptr [di+0201h],sp", 0x66, 0x67, 0x11, 0xa5, 0x01, 0x02 );
    FCML_A32( "adc %sp,0x0201(%di)", 0x66, 0x67, 0x11, 0xa5, 0x01, 0x02 );
    FCML_I32( "adc dword ptr [di+0201h],esp", 0x67, 0x11, 0xa5, 0x01, 0x02 );
    FCML_I32_A( "adc [di+0201h],esp", 0x67, 0x11, 0xa5, 0x01, 0x02 );
    FCML_A32( "adc %eax,0x0201(%bp,%di)", 0x67, 0x11, 0x83, 0x01, 0x02 );
    FCML_I64( "adc qword ptr [r9+rcx*4+0000000000000001h],r12", 0x4D, 0x11, 0x64, 0x89, 0x01 );
    FCML_A64( "adc %r12,0x0000000000000001(%r9,%rcx,4)", 0x4D, 0x11, 0x64, 0x89, 0x01 );

    FCML_I32( "adc ah,byte ptr [ebp+04030201h]", 0x12, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32_FAILED( "lock adc ah,byte ptr [ebp+04030201h]", 0xF0, 0x12, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64_D( "adc spl,byte ptr [rbp+0000000004030201h]", 0x48, 0x12, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64_D( "adc spl,byte ptr [rbp+0000000000000001h]", 0x48, 0x12, 0x64, 0xa5, 0x01 );
    FCML_I64_D( "adc ah,byte ptr [rbp+0000000000000001h]", 0x12, 0x64, 0xa5, 0x01 );
    FCML_I64( "adc spl,byte ptr [rbp+0000000004030201h]", 0x40, 0x12, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "adc 0x0000000004030201(%rbp),%spl", 0x40, 0x12, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "adc spl,byte ptr [rbp+0000000000000001h]", 0x40, 0x12, 0x65, 0x01 );

    FCML_I32( "adc esp,dword ptr [ebp+04030201h]", 0x13, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32_FAILED( "lock adc esp,dword ptr [ebp+04030201h]", 0xF0, 0x13, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "adc sp,word ptr [di+0201h]", 0x66, 0x67, 0x13, 0xa5, 0x01, 0x02 );
    FCML_I32( "adc esp,dword ptr [di+0201h]", 0x67, 0x13, 0xa5, 0x01, 0x02 );
    FCML_A32( "adc 0x0201(%di),%esp", 0x67, 0x13, 0xa5, 0x01, 0x02 );
    FCML_I64( "adc r12,qword ptr [r9+rcx*4+0000000000000001h]", 0x4D, 0x13, 0x64, 0x89, 0x01 );
    FCML_A64( "adc 0x0000000000000001(%r9,%rcx,4),%r12", 0x4D, 0x13, 0x64, 0x89, 0x01 );
}

void fcml_tf_instruction_ADD(void) {

    FCML_A32_M( "add $0x42,%al", 2, FCML_MI( 0x04, 0x42 ), FCML_MI( 0x80, 0xc0, 0x42 ) );
    FCML_I32_D_FAILED( "lock add al,42h", 0xF0, 0x04, 0x42 );
    FCML_I32_A_FAILED( "lock add al,42h", 0xF0, 0x04, 0x42 );
    FCML_I32_M( "add al,0ffh", 2, FCML_MI( 0x04, 0xff ), FCML_MI( 0x80, 0xc0, 0xff ) );
    FCML_I64_M( "add al,42h", 2, FCML_MI( 0x04, 0x42 ), FCML_MI( 0x80, 0xc0, 0x42 ) );
    FCML_I64_M( "add al,00h", 2, FCML_MI( 0x04, 0x00 ), FCML_MI( 0x80, 0xc0, 0x00 ) );
    FCML_I64_M( "add al,0ffh", 2, FCML_MI( 0x04, 0xff ), FCML_MI( 0x80, 0xc0, 0xff ) );

    FCML_I32_M( "add ax,8042h", 2, FCML_MI( 0x66, 0x05, 0x42, 0x80 ), FCML_MI( 0x66, 0x81, 0xc0, 0x42, 0x80 ) );
    FCML_A32_M( "add $0x8042,%ax", 2, FCML_MI( 0x66, 0x05, 0x42, 0x80 ), FCML_MI( 0x66, 0x81, 0xc0, 0x42, 0x80 ) );
    FCML_I32_D_FAILED( "add ax,8042h", 0xF0, 0x66, 0x05, 0x42, 0x80 );
    FCML_I32_A_FAILED( "add ax,8042h", 0xF0, 0x66, 0x05, 0x42, 0x80 );
    FCML_I32_M( "add eax,42806521h", 2, FCML_MI( 0x05, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x81, 0xc0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_D( "add eax,42806521h", 0x40, 0x05, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_M( "add eax,42806521h", 2, FCML_MI( 0x05, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x81, 0xc0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_A64_M( "add $0x42806521,%eax", 2, FCML_MI( 0x05, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x81, 0xc0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_D( "add ax,6521h", 0x66, 0x40, 0x05, 0x21, 0x65 );
    FCML_I16_D( "add ax,6521h", 0x05, 0x21, 0x65 );
    FCML_I16_D( "add eax,00006521h", 0x66, 0x05, 0x21, 0x65, 0x00, 0x00 );
    FCML_I64_M( "add ax,6521h", 2, FCML_MI( 0x66, 0x05, 0x21, 0x65 ), FCML_MI( 0x66, 0x81, 0xc0, 0x21, 0x65 ) );

    FCML_I64_D( "add rax,0000000042806521h", 0x48, 0x05, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "add rax,0000000042806521h", 0x66, 0x48, 0x05, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "add rax,0000000042806521h", 0x67, 0x66, 0x48, 0x05, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "add rax,0ffffffffffffffffh", 0x66, 0x67, 0x48, 0x05, 0xff, 0xff, 0xff, 0xff );
    FCML_A64_D( "add $0xffffffffffffffff,%rax", 0x66, 0x67, 0x48, 0x05, 0xff, 0xff, 0xff, 0xff );
    FCML_I64_M( "add rax,0000000042806521h", 2, FCML_MI( 0x48, 0x05, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x48, 0x81, 0xc0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_M( "add rax,0ffffffffffffffffh", 3, FCML_MI( 0x48, 0x05, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x48, 0x81, 0xc0, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x48, 0x83, 0xc0, 0xff ) );

    FCML_I32( "lock add byte ptr [04030201h],0ffh", 0xF0, 0x80, 0x05, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_A32( "lock addb $0xff,0x04030201", 0xF0, 0x80, 0x05, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "xacquire lock add byte ptr [04030201h],0ffh", 0xF2, 0xF0, 0x80, 0x05, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "xrelease lock add byte ptr [04030201h],0ffh", 0xF3, 0xF0, 0x80, 0x05, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "add byte ptr [esi+04030201h],0ffh", 0x80, 0x86, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "add byte ptr [ecx+eax+00000002h],03h", 0x80, 0x44, 0x01, 0x02, 0x03 );
    FCML_I64( "add byte ptr [rcx+rax+0000000000000002h],03h", 0x80, 0x44, 0x01, 0x02, 0x03 );

    FCML_I32( "add ebp,04030201h", 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32( "addl $0x04030201,0x00000000(%ebp)", 0x81, 0x45, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32( "addw $0x0201,0x0000(%bp)", 0x66, 0x67, 0x81, 0x46, 0x00, 0x01, 0x02 );
    FCML_I32( "add ebp,04030201h", 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32( "add $0x04030201,%ebp", 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32_A_FAILED( "lock add ebp,04030201h", 0xF0, 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );

    FCML_I32_A_FAILED( "xacquire add ebp,04030201h", 0xF0, 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32_A_FAILED( "xrelease add ebp,04030201h", 0xF0, 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "add bp,0201h", 0x66, 0x81, 0xc5, 0x01, 0x02 );
    FCML_A32( "add $0x0201,%bp", 0x66, 0x81, 0xc5, 0x01, 0x02 );
    FCML_I64_D( "add bp,0201h", 0x67, 0x66, 0x40, 0x81, 0xc5, 0x01, 0x02 );
    FCML_I64( "add bp,0201h", 0x66, 0x67, 0x81, 0xc5, 0x01, 0x02 );

    FCML_I64_D( "add rbp,0000000004030201h", 0x48, 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64_D( "addq $0x0000000004030201,(%rax)", 0x48, 0x81, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "lock add qword ptr [rcx],0000000003020100h", 0xF0, 0x48, 0x81, 0x01, 0x00, 0x01, 0x02, 0x03 );
    FCML_I64( "xacquire lock add qword ptr [rcx],0000000003020100h", 0xF2, 0xF0, 0x48, 0x81, 0x01, 0x00, 0x01, 0x02, 0x03 );
    FCML_I64( "xrelease lock add qword ptr [rcx],0000000003020100h", 0xF3, 0xF0, 0x48, 0x81, 0x01, 0x00, 0x01, 0x02, 0x03 );
    FCML_I64_D( "add rbp,0ffffffffffffffffh", 0x48, 0x81, 0xc5, 0xff, 0xff, 0xff, 0xff );
    FCML_I64_D( "add rbp,0ffffffffffffffffh", 0x67, 0x48, 0x81, 0xc5, 0xff, 0xff, 0xff, 0xff );
    FCML_I64_D( "add rbp,0ffffffffffffffffh", 0x66, 0x48, 0x81, 0xc5, 0xff, 0xff, 0xff, 0xff );
    FCML_I64( "add rbp,0000000004030201h", 0x48, 0x81, 0xc5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64_M( "add rbp,0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x81, 0xc5, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x48, 0x83, 0xc5, 0xff ) );

    FCML_I32_M( "lock add dword ptr [esi],00000001h", 2, FCML_MI( 0xF0, 0x83, 0x06, 0x01 ), FCML_MI( 0xF0, 0x81, 0x06, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xacquire lock add dword ptr [esi],00000001h", 2, FCML_MI( 0xF2, 0xF0, 0x83, 0x06, 0x01 ), FCML_MI( 0xF2, 0xF0, 0x81, 0x06, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xrelease lock add dword ptr [esi],00000001h", 2, FCML_MI( 0xF3, 0xF0, 0x83, 0x06, 0x01 ), FCML_MI( 0xF3, 0xF0, 0x81, 0x06, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "add word ptr [esi],0001h", 2, FCML_MI( 0x66, 0x83, 0x06, 0x01 ), FCML_MI( 0x66, 0x81, 0x06, 0x01, 0x00 ) );
    FCML_A32_M( "addw $0x0001,(%esi)", 2, FCML_MI( 0x66, 0x83, 0x06, 0x01 ), FCML_MI( 0x66, 0x81, 0x06, 0x01, 0x00 ) );
    FCML_I32_M( "add dword ptr [0201h],00000003h", 2, FCML_MI( 0x67, 0x83, 0x06, 0x01, 0x02, 0x03 ), FCML_MI( 0x67, 0x81, 0x06, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00 ) );

    FCML_I64_M( "lock add qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF0, 0x48, 0x83, 0x87, 0x01, 0x02, 0x03, 0x4, 0x05 ), FCML_MI( 0xF0, 0x48, 0x81, 0x87, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "add qword ptr [rdi+0000000004030201h],0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x83, 0x87, 0x01, 0x02, 0x03, 0x4, 0xff ), FCML_MI( 0x48, 0x81, 0x87, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff ) );
    FCML_A64_M( "addq $0xffffffffffffffff,0x0000000004030201(%rdi)", 2, FCML_MI( 0x48, 0x83, 0x87, 0x01, 0x02, 0x03, 0x4, 0xff ), FCML_MI( 0x48, 0x81, 0x87, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32( "lock add byte ptr [ebp+04030201h],ah", 0xF0, 0x00, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xacquire lock add byte ptr [ebp+04030201h],ah", 0xF2, 0xF0, 0x00, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xrelease lock add byte ptr [ebp+04030201h],ah", 0xF3, 0xF0, 0x00, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "add byte ptr [rbp+0000000004030201h],spl", 0x40, 0x00, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "add byte ptr [rbp+0000000000000001h],spl", 0x40, 0x00, 0x65, 0x01 );
    FCML_A64( "add %spl,0x0000000000000001(%rbp)", 0x40, 0x00, 0x65, 0x01 );

    FCML_I32( "lock add dword ptr [ebp+04030201h],esp", 0xF0, 0x01, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xacquire lock add dword ptr [ebp+04030201h],esp", 0xF2, 0xF0, 0x01, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xrelease lock add dword ptr [ebp+04030201h],esp", 0xF3, 0xF0, 0x01, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "add word ptr [di+0201h],sp", 0x66, 0x67, 0x01, 0xa5, 0x01, 0x02 );
    FCML_I32( "add dword ptr [di+0201h],esp", 0x67, 0x01, 0xa5, 0x01, 0x02 );
    FCML_I64( "add qword ptr [r9+rcx*4+0000000000000001h],r12", 0x4D, 0x01, 0x64, 0x89, 0x01 );
    FCML_A64( "add %r12,0x0000000000000001(%r9,%rcx,4)", 0x4D, 0x01, 0x64, 0x89, 0x01 );

    FCML_I32( "add ah,byte ptr [ebp+04030201h]", 0x02, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "add spl,byte ptr [rbp+0000000004030201h]", 0x40, 0x02, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "add spl,byte ptr [rbp+0000000000000001h]", 0x40, 0x02, 0x65, 0x01 );
    FCML_A64( "add 0x0000000000000001(%rbp),%spl", 0x40, 0x02, 0x65, 0x01 );

    FCML_I32( "add esp,dword ptr [ebp+04030201h]", 0x03, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "add sp,word ptr [di+0201h]", 0x66, 0x67, 0x03, 0xa5, 0x01, 0x02 );
    FCML_I32( "add esp,dword ptr [di+0201h]", 0x67, 0x03, 0xa5, 0x01, 0x02 );
    FCML_I64( "add r12,qword ptr [r9+rcx*4+0000000000000001h]", 0x4D, 0x03, 0x64, 0x89, 0x01 );
    FCML_A64( "add 0x0000000000000001(%r9,%rcx,4),%r12", 0x4D, 0x03, 0x64, 0x89, 0x01 );
}

void fcml_tf_instruction_ADDPD_VADDPD(void) {

    FCML_I32( "addpd xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x58, 0x14, 0x01 );
    FCML_I64( "addpd xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x58, 0x14, 0x01 );
    FCML_A64( "addpd (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x58, 0x14, 0x01 );

    FCML_I64_M("vaddpd ymm10,ymm14,ymmword ptr [r9+r8]", 2, FCML_MI(0x62, 0x11, 0x8d, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc4, 0x01, 0x0d, 0x58, 0x14, 0x01));
    FCML_A64_M("vaddpd (%r9,%r8),%ymm14,%ymm10", 2, FCML_MI(0x62, 0x11, 0x8d, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc4, 0x01, 0x0d, 0x58, 0x14, 0x01));

    FCML_I64_M("vaddpd ymm10,ymm14,ymmword ptr [r9+rax]", 2, FCML_MI(0x62, 0x51, 0x8d, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc4, 0x41, 0x0d, 0x58, 0x14, 0x01));
    FCML_I64_M("vaddpd xmm2,xmm14,xmmword ptr [r9+rax]", 2, FCML_MI(0x62, 0xd1, 0x8d, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc4, 0xc1, 0x09, 0x58, 0x14, 0x01));
    FCML_A64_M("vaddpd (%r9,%rax),%xmm14,%xmm2", 2, FCML_MI(0x62, 0xd1, 0x8d, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc4, 0xc1, 0x09, 0x58, 0x14, 0x01));

    FCML_I32_D( "vaddpd xmm2,xmm2,xmmword ptr [ecx+eax]", 0xC4, 0xC1, 0x69, 0x58, 0x14, 0x01 );
    FCML_I32_D( "vaddpd xmm2,xmm2,xmmword ptr [ecx+eax]", 0xC4, 0xE1, 0x69, 0x58, 0x14, 0x01 );
    FCML_I32_D( "vaddpd ymm2,ymm2,ymmword ptr [ecx+eax]", 0xC4, 0xE1, 0x6D, 0x58, 0x14, 0x01 );
    FCML_I32_M("vaddpd xmm2,xmm2,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xe9, 0x58, 0x14, 0x01));
    FCML_I32_M("vaddpd ymm2,ymm2,ymmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xed, 0x58, 0x14, 0x01));
    FCML_A32_M("vaddpd (%ecx,%eax),%ymm2,%ymm2", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xed, 0x58, 0x14, 0x01));

    FCML_I32_M("vaddpd xmm2,xmm0,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xf9, 0x58, 0x14, 0x01));
    FCML_A32_M("vaddpd (%ecx,%eax),%xmm0,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xf9, 0x58, 0x14, 0x01));

    FCML_I64_M("vaddpd ymm10,ymm4,ymmword ptr [rcx+rax]", 2, FCML_MI(0x62, 0x71, 0xdd, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0x5d, 0x58, 0x14, 0x01));
    FCML_A64_M("vaddpd (%rcx,%rax),%ymm4,%ymm10", 2, FCML_MI(0x62, 0x71, 0xdd, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0x5d, 0x58, 0x14, 0x01));

    FCML_I32_M("vaddpd ymm2,ymm0,ymmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xfd, 0x58, 0x14, 0x01));
    FCML_A32_M("vaddpd (%ecx,%eax),%ymm0,%ymm2", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xfd, 0x58, 0x14, 0x01));

    /* AVX-512 */

    /* {k} */
    FCML_I64("vaddpd ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x29, 0x58, 0x14, 0x01);
    FCML_A64("vaddpd (%r9,%r8),%ymm14,%ymm10{%k1}", 0x62, 0x11, 0x8D, 0x29, 0x58, 0x14, 0x01);
    FCML_I64("vaddpd xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x09, 0x58, 0x14, 0x01);
    FCML_A64("vaddpd (%r9,%r8),%xmm14,%xmm10{%k1}", 0x62, 0x11, 0x8D, 0x09, 0x58, 0x14, 0x01);
    FCML_I64("vaddpd zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0xED, 0x49, 0x58, 0x0C, 0x01);
    FCML_A64("vaddpd (%r9,%r8),%zmm2,%zmm1{%k1}", 0x62, 0x91, 0xED, 0x49, 0x58, 0x0C, 0x01);
    FCML_I32("vaddpd xmm1{k1},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0xF5, 0x09, 0x58, 0x4D, 0x00);

    /* {k}{z} */
    FCML_I64("vaddpd ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0xA9, 0x58, 0x14, 0x01);
    FCML_A64("vaddpd (%r9,%r8),%ymm14,%ymm10{%k1}{z}", 0x62, 0x11, 0x8D, 0xA9, 0x58, 0x14, 0x01);
    FCML_I64("vaddpd xmm10{k1}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x89, 0x58, 0x14, 0x01);
    FCML_A64("vaddpd (%r9,%r8),%xmm14,%xmm10{%k1}{z}", 0x62, 0x11, 0x8D, 0x89, 0x58, 0x14, 0x01);
    FCML_I64("vaddpd zmm1{k1}{z},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0xED, 0xC9, 0x58, 0x0C, 0x01);
    FCML_A64("vaddpd (%r9,%r8),%zmm2,%zmm1{%k1}{z}", 0x62, 0x91, 0xED, 0xC9, 0x58, 0x0C, 0x01);
    FCML_I32("vaddpd xmm1{k1}{z},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0xF5, 0x89, 0x58, 0x4D, 0x00);

    /* {bcast} */
    FCML_I64("vaddpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xD5, 0x50, 0x58, 0x3E);
    FCML_A64("vaddpd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xD5, 0x50, 0x58, 0x3E);
    FCML_I64("vaddpd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xD5, 0x30, 0x58, 0x3E);
    FCML_A64("vaddpd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xD5, 0x30, 0x58, 0x3E);
    FCML_I64("vaddpd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xD5, 0x10, 0x58, 0x3E);
    FCML_A64("vaddpd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xD5, 0x10, 0x58, 0x3E);
    FCML_I32("vaddpd xmm1,xmm1,mmword ptr [esi]{1to2}", 0x62, 0xf1, 0xF5, 0x18, 0x58, 0x0e);

    /* {k}{z}{bcast} */
    FCML_I64("vaddpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xD5, 0xB7, 0x58, 0x3E);
    FCML_A64("vaddpd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xD5, 0xB7, 0x58, 0x3E);

    /* {rn} */
    FCML_I64("vaddpd zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0xD5, 0x97, 0x58, 0xFC);
    FCML_A64("vaddpd {rn-sae},%zmm4,%zmm21,%zmm31{%k7}{z}", 0x62, 0x61, 0xD5, 0x97, 0x58, 0xFC);
}

void fcml_tf_instruction_ADDPS_VADDPS(void) {
    FCML_I32( "addps xmm2,xmmword ptr [ecx+eax]", 0x0F, 0x58, 0x14, 0x01 );
    FCML_I64( "addps xmm2,xmmword ptr [rcx+rax]", 0x0F, 0x58, 0x14, 0x01 );
    FCML_A64( "addps (%rcx,%rax),%xmm2", 0x0F, 0x58, 0x14, 0x01 );
    FCML_I64_M( "vaddps ymm10,ymm14,ymmword ptr [r9+r8]", 2, FCML_MI( 0x62, 0x11, 0x0c, 0x28, 0x58, 0x14, 0x01 ), FCML_MI( 0xc4, 0x01, 0x0c, 0x58, 0x14, 0x01 ) );
    FCML_A64_M( "vaddps (%r9,%r8),%ymm14,%ymm10", 2, FCML_MI( 0x62, 0x11, 0x0c, 0x28, 0x58, 0x14, 0x01 ), FCML_MI( 0xc4, 0x01, 0x0c, 0x58, 0x14, 0x01 ) );
    FCML_I32_M( "vaddps ymm2,ymm0,ymmword ptr [ecx+eax]", 2, FCML_MI( 0x62, 0xf1, 0x7c, 0x28, 0x58, 0x14, 0x01 ), FCML_MI( 0xc5, 0xfc, 0x58, 0x14, 0x01 ) );

    /* AVX-512 */

    /* {k} */
    FCML_I64("vaddps ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x29, 0x58, 0x14, 0x01);
    FCML_A64("vaddps (%r9,%r8),%ymm14,%ymm10{%k1}", 0x62, 0x11, 0x0C, 0x29, 0x58, 0x14, 0x01);
    FCML_I64("vaddps xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x09, 0x58, 0x14, 0x01);
    FCML_A64("vaddps (%r9,%r8),%xmm14,%xmm10{%k1}", 0x62, 0x11, 0x0C, 0x09, 0x58, 0x14, 0x01);
    FCML_I64("vaddps zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0x49, 0x58, 0x0C, 0x01);
    FCML_A64("vaddps (%r9,%r8),%zmm2,%zmm1{%k1}", 0x62, 0x91, 0x6C, 0x49, 0x58, 0x0C, 0x01);

    /* TODO: Check if there is a way to avoid displaying zero displacement. */
    FCML_I32("vaddps xmm1{k1},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0x74, 0x09, 0x58, 0x4D, 0x00);

    /* {k}{z} */
    FCML_I64("vaddps ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0xA9, 0x58, 0x14, 0x01);
    FCML_A64("vaddps (%r9,%r8),%ymm14,%ymm10{%k1}{z}", 0x62, 0x11, 0x0C, 0xA9, 0x58, 0x14, 0x01);
    FCML_I64("vaddps xmm10{k1}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x89, 0x58, 0x14, 0x01);
    FCML_A64("vaddps (%r9,%r8),%xmm14,%xmm10{%k1}{z}", 0x62, 0x11, 0x0C, 0x89, 0x58, 0x14, 0x01);
    FCML_I64("vaddps zmm1{k1}{z},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0xC9, 0x58, 0x0C, 0x01);
    FCML_A64("vaddps (%r9,%r8),%zmm2,%zmm1{%k1}{z}", 0x62, 0x91, 0x6C, 0xC9, 0x58, 0x0C, 0x01);
    FCML_I32("vaddps xmm1{k1}{z},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0x74, 0x89, 0x58, 0x4D, 0x00);

    /* {bcast} */
    FCML_I64("vaddps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x54, 0x50, 0x58, 0x3E);
    FCML_A64("vaddps (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x54, 0x50, 0x58, 0x3E);
    FCML_I64("vaddps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0x30, 0x58, 0x3E);
    FCML_A64("vaddps (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x54, 0x30, 0x58, 0x3E);
    FCML_I64("vaddps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x54, 0x10, 0x58, 0x3E);
    FCML_A64("vaddps (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x54, 0x10, 0x58, 0x3E);
    FCML_I32("vaddps xmm1,xmm1,dword ptr [esi]{1to4}", 0x62, 0xf1, 0x74, 0x18, 0x58, 0x0e);

    /* {k}{z}{bcast} */
    FCML_I64("vaddps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0xB7, 0x58, 0x3E);
    FCML_A64("vaddps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x54, 0xB7, 0x58, 0x3E);

    /* {rn} */
    FCML_I64("vaddps zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x58, 0xFC);
    FCML_A64("vaddps {rn-sae},%zmm4,%zmm21,%zmm31{%k7}{z}", 0x62, 0x61, 0x54, 0x97, 0x58, 0xFC);
    FCML_I64("vaddps zmm31{k7}{z},zmm21,zmm4,{rd-sae}", 0x62, 0x61, 0x54, 0xB7, 0x58, 0xFC);
    FCML_A64("vaddps {rd-sae},%zmm4,%zmm21,%zmm31{%k7}{z}", 0x62, 0x61, 0x54, 0xB7, 0x58, 0xFC);
    FCML_I64("vaddps zmm31{k7}{z},zmm21,zmm4,{ru-sae}", 0x62, 0x61, 0x54, 0xD7, 0x58, 0xFC);
    FCML_A64("vaddps {ru-sae},%zmm4,%zmm21,%zmm31{%k7}{z}", 0x62, 0x61, 0x54, 0xD7, 0x58, 0xFC);
    FCML_I64("vaddps zmm31{k7}{z},zmm21,zmm4,{rz-sae}", 0x62, 0x61, 0x54, 0xF7, 0x58, 0xFC);
    FCML_A64("vaddps {rz-sae},%zmm4,%zmm21,%zmm31{%k7}{z}", 0x62, 0x61, 0x54, 0xF7, 0x58, 0xFC);

    FCML_I32_FAILED("vaddps xmm1{k7}{z},xmm1,xmm1,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x58, 0xFC);

    /* For tuple type FV and {er}, vector length has to be 512, not 128 nor 256. */
    FCML_I32_A_FAILED("vaddps xmm1{k7}{z},xmm1,xmm4,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x58, 0xFC);
    FCML_I64_A_FAILED("vaddps xmm1{k7}{z},xmm1,xmm4,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x58, 0xFC);

    /* Compressed disp8 */
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x08);
    FCML_A64("vaddps 0x0000000000000020(%rsp){1to4},%xmm0,%xmm1{%k4}{z}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x08);
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x74);
    FCML_A64("vaddps 0x00000000000001d0(%rsp){1to4},%xmm0,%xmm1{%k4}{z}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x74);
    FCML_I32("vaddps xmm1{k4}{z},xmm0,dword ptr [esp+00000020h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x08);

    /* Edge cases. */

    /* disp8 */
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+0fffffffffffffffch]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0xFF);
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+0fffffffffffffe10h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x84);
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+00000000000001f0h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x4C, 0x24, 0x7C);
    /* disp32. */
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+0000000000000200h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x8C, 0x24, 0x00, 0x02, 0x00, 0x00);
    FCML_I64("vaddps xmm1{k4}{z},xmm0,dword ptr [rsp+0000000000000021h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x58, 0x8C, 0x24, 0x21, 0x00, 0x00, 0x00);
}

void fcml_tf_instruction_ADDSD_VADDSD(void) {
    FCML_I32( "addsd xmm2,mmword ptr [ecx+eax]", 0xF2, 0x0F, 0x58, 0x14, 0x01 );
    FCML_I64( "addsd xmm2,mmword ptr [rcx+rax]", 0xF2, 0x0F, 0x58, 0x14, 0x01 );
    FCML_A64( "addsd (%rcx,%rax),%xmm2", 0xF2, 0x0F, 0x58, 0x14, 0x01 );
    FCML_I32_D( "vaddsd xmm2,xmm5,mmword ptr [ecx+eax]", 0xC4, 0xE1, 0x53, 0x58, 0x14, 0x01 );
    /* AVX-512 */
    FCML_I32_M("vaddsd xmm2,xmm4,mmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x58, 0x14, 0x01));
    FCML_A32_M("vaddsd (%ecx,%eax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x58, 0x14, 0x01));
    FCML_I64_M("vaddsd xmm2,xmm4,mmword ptr [rcx+rax]", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x58, 0x14, 0x01));
    FCML_A64_M("vaddsd (%rcx,%rax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x58, 0x14, 0x01));
    FCML_I32_A_FAILED("vaddsd ymm2,ymm4,mmword ptr [ecx+eax]", 0x62, 0xf1, 0xdf, 0x08, 0x58, 0x14, 0x01);
    /* {k1}{z} */
    FCML_I64("vaddsd xmm2{k1},xmm4,mmword ptr [rcx+rax]", 0x62, 0xf1, 0xdf, 0x09, 0x58, 0x14, 0x01);
    FCML_I64("vaddsd xmm2{k1}{z},xmm4,mmword ptr [rcx+rax]", 0x62, 0xf1, 0xdf, 0x89, 0x58, 0x14, 0x01);
    FCML_I64("vaddsd xmm31{k7}{z},xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0xD7, 0x97, 0x58, 0xFC);
    FCML_I64("vaddsd xmm31,xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0xD7, 0x10, 0x58, 0xFC);
    FCML_I64("vaddsd xmm31,xmm31,xmm31,{rn-sae}", 0x62, 0x01, 0x87, 0x10, 0x58, 0xFF);
    FCML_I32("vaddsd xmm1,xmm6,xmm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x18, 0x58, 0xCC);
    FCML_I32_A_FAILED("vaddsd ymm1,ymm6,ymm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x18, 0x58, 0xCC);
    FCML_I32_A_FAILED("vaddsd zmm1,zmm6,zmm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x18, 0x58, 0xCC);
    FCML_I64_A_FAILED("vaddsd ymm1,ymm6,ymm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x18, 0x58, 0xCC);
    FCML_I64_A_FAILED("vaddsd zmm1,zmm6,zmm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x18, 0x58, 0xCC);
}

void fcml_tf_instruction_ADDSS_VADDSS(void) {
    FCML_I32( "addss xmm2,dword ptr [ecx+eax]", 0xF3, 0x0F, 0x58, 0x14, 0x01 );
    FCML_I64( "addss xmm2,dword ptr [rcx+rax]", 0xF3, 0x0F, 0x58, 0x14, 0x01 );
    FCML_A64( "addss (%rcx,%rax),%xmm2", 0xF3, 0x0F, 0x58, 0x14, 0x01 );
    FCML_I32_D( "vaddss xmm2,xmm5,dword ptr [ecx+eax]", 0xC4, 0xE1, 0x52, 0x58, 0x14, 0x01 );
    FCML_I32_M("vaddss xmm2,xmm4,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x58, 0x14, 0x01));
    FCML_A32_M("vaddss (%ecx,%eax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x58, 0x14, 0x01));
    /* AVX-512 */
    FCML_I32_M("vaddss xmm2,xmm4,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x58, 0x14, 0x01));
    FCML_I64_M("vaddss xmm2,xmm4,dword ptr [rcx+rax]", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x58, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x58, 0x14, 0x01));
    /* {k1}{z} */
    FCML_I64("vaddss xmm2{k1},xmm4,dword ptr [rcx+rax]", 0x62, 0xf1, 0x5E, 0x09, 0x58, 0x14, 0x01);
    FCML_I64("vaddss xmm2{k1}{z},xmm4,dword ptr [rcx+rax]", 0x62, 0xf1, 0x5E, 0x89, 0x58, 0x14, 0x01);
    FCML_I64("vaddss xmm31{k7}{z},xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0x56, 0x97, 0x58, 0xFC);
}

void fcml_tf_instruction_ADDSUBPD_VADDSUBPD(void) {
    FCML_I32( "addsubpd xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I64( "addsubpd xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_A64( "addsubpd (%rcx,%rax),%xmm2", 0x66, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I64( "vaddsubpd ymm10,ymm14,ymmword ptr [r9+rax]", 0xC4, 0x41, 0x0D, 0xD0, 0x14, 0x01 );
    FCML_I64( "vaddsubpd ymm10,ymm14,ymmword ptr [r9+rax]", 0xC4, 0x41, 0x0D, 0xD0, 0x14, 0x01 );
    FCML_A64( "vaddsubpd (%r9,%rax),%ymm14,%ymm10", 0xC4, 0x41, 0x0D, 0xD0, 0x14, 0x01 );
    FCML_I32_D( "vaddsubpd xmm2,xmm7,xmmword ptr [ecx+eax]", 0xC4, 0xC1, 0x41, 0xD0, 0x14, 0x01 );
    FCML_I32_D( "vaddsubpd xmm2,xmm2,xmmword ptr [ecx+eax]", 0xC4, 0xC1, 0x69, 0xD0, 0x14, 0x01 );
    FCML_I32( "vaddsubpd xmm2,xmm7,xmmword ptr [ecx+eax]", 0xC5, 0xC1, 0xD0, 0x14, 0x01 );
    FCML_I32( "vaddsubpd xmm2,xmm2,xmmword ptr [ecx+eax]", 0xC5, 0xE9, 0xD0, 0x14, 0x01 );
}

void fcml_tf_instruction_ADDSUBPS_VADDSUBPS(void) {
    FCML_I32( "addsubps xmm2,xmmword ptr [ecx+eax]", 0xf2, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I32_A( "addsubps xmm2,[ecx+eax]", 0xf2, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I64( "addsubps xmm2,xmmword ptr [rcx+rax]", 0xf2, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_A64( "addsubps (%rcx,%rax),%xmm2", 0xf2, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I64( "vaddsubps ymm10,ymm14,ymmword ptr [r9+rax]", 0xC4, 0x41, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I64_A( "vaddsubps ymm10,ymm14,[r9+rax]", 0xC4, 0x41, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_A64( "vaddsubps (%r9,%rax),%ymm14,%ymm10", 0xC4, 0x41, 0x0F, 0xD0, 0x14, 0x01 );
    FCML_I64( "vaddsubps xmm2,xmm14,xmmword ptr [r9+rax]", 0xC4, 0xC1, 0x0B, 0xD0, 0x14, 0x01 );
    FCML_I32_D( "vaddsubps xmm2,xmm2,xmmword ptr [ecx+eax]", 0xC4, 0xC1, 0x6B, 0xD0, 0x14, 0x01 );
    FCML_I32( "vaddsubps xmm2,xmm2,xmmword ptr [ecx+eax]", 0xC5, 0xEB, 0xD0, 0x14, 0x01 );
    FCML_I32( "vaddsubps xmm2,xmm6,xmmword ptr [ecx+eax]", 0xC5, 0xCB, 0xD0, 0x14, 0x01 );
    FCML_A32( "vaddsubps (%ecx,%eax),%xmm6,%xmm2", 0xC5, 0xCB, 0xD0, 0x14, 0x01 );
}

void fcml_tf_instruction_AESDEC_VAESDEC(void) {
    FCML_I32( "aesdec xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x38, 0xDE, 0x14, 0x01 );
    FCML_I64( "aesdec xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x38, 0xDE, 0x14, 0x01 );
    FCML_I64_A( "aesdec xmm2,[rcx+rax]", 0x66, 0x0F, 0x38, 0xDE, 0x14, 0x01 );
    FCML_A64( "aesdec (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0xDE, 0x14, 0x01 );
    FCML_I32( "vaesdec xmm0,xmm3,xmmword ptr [eax]", 0xC4, 0xE2, 0x61, 0xDE, 0x00 );
    FCML_A32( "vaesdec (%eax),%xmm3,%xmm0", 0xC4, 0xE2, 0x61, 0xDE, 0x00 );
    FCML_I32( "vaesdec xmm0,xmm3,xmm0", 0xC4, 0xE2, 0x61, 0xDE, 0xC0 );
    FCML_I64( "vaesdec xmm0,xmm3,xmmword ptr [rax]", 0xC4, 0xE2, 0x61, 0xDE, 0x00 );
}

void fcml_tf_instruction_AESDECLAST_VAESDECLAST(void) {
    FCML_I32( "aesdeclast xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x38, 0xDF, 0x14, 0x01 );
    FCML_I64( "aesdeclast xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x38, 0xDF, 0x14, 0x01 );
    FCML_I64_A( "aesdeclast xmm2,[rcx+rax]", 0x66, 0x0F, 0x38, 0xDF, 0x14, 0x01 );
    FCML_A64( "aesdeclast (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0xDF, 0x14, 0x01 );
    FCML_I32( "vaesdeclast xmm0,xmm3,xmmword ptr [eax]", 0xC4, 0xE2, 0x61, 0xDF, 0x00 );
    FCML_I32( "vaesdeclast xmm0,xmm3,xmm0", 0xC4, 0xE2, 0x61, 0xDF, 0xC0 );
    FCML_I64( "vaesdeclast xmm0,xmm3,xmmword ptr [rax]", 0xC4, 0xE2, 0x61, 0xDF, 0x00 );
    FCML_A64( "vaesdeclast (%rax),%xmm3,%xmm0", 0xC4, 0xE2, 0x61, 0xDF, 0x00 );
}

void fcml_tf_instruction_AESENC_VAESENC(void) {
    FCML_I32( "aesenc xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x38, 0xDC, 0x14, 0x01 );
    FCML_I64( "aesenc xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x38, 0xDC, 0x14, 0x01 );
    FCML_I64_A( "aesenc xmm2,[rcx+rax]", 0x66, 0x0F, 0x38, 0xDC, 0x14, 0x01 );
    FCML_A64( "aesenc (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0xDC, 0x14, 0x01 );

    FCML_I32( "vaesenc xmm0,xmm3,xmmword ptr [eax]", 0xC4, 0xE2, 0x61, 0xDC, 0x00 );
    FCML_I32( "vaesenc xmm0,xmm3,xmm0", 0xC4, 0xE2, 0x61, 0xDC, 0xC0 );
    FCML_I64( "vaesenc xmm0,xmm3,xmmword ptr [rax]", 0xC4, 0xE2, 0x61, 0xDC, 0x00 );
    FCML_A64( "vaesenc (%rax),%xmm3,%xmm0", 0xC4, 0xE2, 0x61, 0xDC, 0x00 );
}

void fcml_tf_instruction_AESENCLAST(void) {
    FCML_I32( "aesenclast xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x38, 0xDD, 0x14, 0x01 );
    FCML_I64( "aesenclast xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x38, 0xDD, 0x14, 0x01 );
    FCML_I64_A( "aesenclast xmm2,[rcx+rax]", 0x66, 0x0F, 0x38, 0xDD, 0x14, 0x01 );
    FCML_A64( "aesenclast (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0xDD, 0x14, 0x01 );

    FCML_I32( "vaesenclast xmm0,xmm3,xmmword ptr [eax]", 0xC4, 0xE2, 0x61, 0xDD, 0x00 );
    FCML_I32( "vaesenclast xmm0,xmm3,xmm0", 0xC4, 0xE2, 0x61, 0xDD, 0xC0 );
    FCML_I64( "vaesenclast xmm0,xmm3,xmmword ptr [rax]", 0xC4, 0xE2, 0x61, 0xDD, 0x00 );
    FCML_A64( "vaesenclast (%rax),%xmm3,%xmm0", 0xC4, 0xE2, 0x61, 0xDD, 0x00 );
}

void fcml_tf_instruction_AESIMC_VAESIMC(void) {
    FCML_I32( "aesimc xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x38, 0xDB, 0x14, 0x01 );
    FCML_I64( "aesimc xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x38, 0xDB, 0x14, 0x01 );
    FCML_I64_A( "aesimc xmm2,[rcx+rax]", 0x66, 0x0F, 0x38, 0xDB, 0x14, 0x01 );
    FCML_A64( "aesimc (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0xDB, 0x14, 0x01 );
    FCML_I32( "vaesimc xmm0,xmmword ptr [eax]", 0xC4, 0xE2, 0x79, 0xDB, 0x00 );
    FCML_I32( "vaesimc xmm0,xmm0", 0xC4, 0xE2, 0x79, 0xDB, 0xC0 );
    FCML_I64( "vaesimc xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0xDB, 0x00 );
    FCML_A64( "vaesimc (%rax),%xmm0", 0xC4, 0xE2, 0x79, 0xDB, 0x00 );
}

void fcml_tf_instruction_AESKEYGENASSIST_VAESKEYGENASSIST(void) {
    FCML_I32( "aeskeygenassist xmm2,xmmword ptr [ecx+eax],0ffh", 0x66, 0x0F, 0x3a, 0xDF, 0x14, 0x01, 0xFF );
    FCML_I64( "aeskeygenassist xmm2,xmmword ptr [rcx+rax],0ffh", 0x66, 0x0F, 0x3a, 0xDF, 0x14, 0x01, 0xFF );
    FCML_A64( "aeskeygenassist $0xff,(%rcx,%rax),%xmm2", 0x66, 0x0F, 0x3a, 0xDF, 0x14, 0x01, 0xFF );
    FCML_I32( "vaeskeygenassist xmm0,xmmword ptr [eax],0ffh", 0xC4, 0xE3, 0x79, 0xDF, 0x00, 0xFF );
    FCML_I32( "vaeskeygenassist xmm0,xmm0,0ffh", 0xC4, 0xE3, 0x79, 0xDF, 0xC0, 0xFF );
    FCML_A32( "vaeskeygenassist $0xff,%xmm0,%xmm0", 0xC4, 0xE3, 0x79, 0xDF, 0xC0, 0xFF );
}

void fcml_tf_instruction_AND(void) {

    FCML_I32_M( "and al,42h", 2, FCML_MI( 0x24, 0x42 ), FCML_MI( 0x80, 0xE0, 0x42 ) );
    FCML_I32_A_FAILED( "lock and al,42h", 0xF0, 0x24, 0x42 );
    FCML_I32_D_FAILED( "lock and al,42h", 0xF0, 0x24, 0x42 );
    FCML_I32_M( "and al,0ffh", 2, FCML_MI( 0x24, 0xFF ), FCML_MI( 0x80, 0xE0, 0xFF ) );
    FCML_A32_M( "and $0xff,%al", 2, FCML_MI( 0x24, 0xFF ), FCML_MI( 0x80, 0xE0, 0xFF ) );
    FCML_I32_M( "and al,00h", 2, FCML_MI( 0x24, 0x00 ), FCML_MI( 0x80, 0xE0, 0x00 ) );
    FCML_I32_M( "and al,0ffh", 2, FCML_MI( 0x24, 0xFF ), FCML_MI( 0x80, 0xE0, 0xFF ) );

    FCML_I32_M( "and ax,8042h", 2, FCML_MI( 0x66, 0x25, 0x42, 0x80 ), FCML_MI( 0x66, 0x81, 0xE0, 0x42, 0x80 ) );
    FCML_I32_M( "and eax,42806521h", 2, FCML_MI( 0x25, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x81, 0xe0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_D( "and eax,42806521h", 0x40, 0x25, 0x21, 0x65, 0x80, 0x42 );
    FCML_A64_D( "and $0x42806521,%eax", 0x40, 0x25, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D_FAILED( "lock and eax,42806521h", 0xF0, 0x40, 0x25, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_A_FAILED( "lock and eax,42806521h", 0xF0, 0x40, 0x25, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "and ax,6521h", 0x66, 0x40, 0x25, 0x21, 0x65 );

    FCML_I64_M( "and rax,0000000042806521h", 2, FCML_MI( 0x48, 0x25, 0x21, 0x65, 0x80, 0x42 ), FCML_MI(0x48, 0x81, 0xe0, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_D( "and rax,0000000042806521h", 0x66, 0x48, 0x25, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "and rax,0000000042806521h", 0x67, 0x66, 0x48, 0x25, 0x21, 0x65, 0x80, 0x42 );
    FCML_I64_D( "and rax,0ffffffffffffffffh", 0x67, 0x66, 0x48, 0x25, 0xff, 0xff, 0xff, 0xff );

    FCML_I32( "and byte ptr [04030201h],0ffh", 0x80, 0x25, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "lock and byte ptr [04030201h],0ffh", 0xF0, 0x80, 0x25, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "xacquire lock and byte ptr [04030201h],0ffh", 0xF2, 0xF0, 0x80, 0x25, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "xrelease lock and byte ptr [04030201h],0ffh", 0xF3, 0xF0, 0x80, 0x25, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_A64( "xrelease lock andb $0xff,0x04030201(%rip)", 0xF3, 0xF0, 0x80, 0x25, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "and byte ptr [esi+04030201h],0ffh", 0x80, 0xA6, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "and byte ptr [ecx+eax+00000002h],03h", 0x80, 0x64, 0x01, 0x02, 0x03 );

    FCML_I32( "and ebp,04030201h", 0x81, 0xe5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32( "and $0x04030201,%ebp", 0x81, 0xe5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "and bp,0201h", 0x66, 0x81, 0xe5, 0x01, 0x02 );
    FCML_I64_D( "and bp,0201h", 0x67, 0x66, 0x40, 0x81, 0xe5, 0x01, 0x02 ); /* 32 bit mode doesn't not allow REX.*/

    FCML_I64( "and rbp,0000000004030201h", 0x48, 0x81, 0xe5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64_M( "and rbp,0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x81, 0xe5, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x48, 0x83, 0xe5, 0xff ) );
    FCML_I64_M( "and rbp,0ffffffffffffffffh", 2, FCML_MI( 0x67, 0x48, 0x81, 0xe5, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x67, 0x48, 0x83, 0xe5, 0xff ) );
    FCML_I64_D( "and rbp,0ffffffffffffffffh", 0x66, 0x48, 0x81, 0xe5, 0xff, 0xff, 0xff, 0xff );

    FCML_I32_M( "and dword ptr [esi],00000001h", 2, FCML_MI( 0x83, 0x26, 0x01 ), FCML_MI( 0x81, 0x26, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_A32_M( "andl $0x00000001,(%esi)", 2, FCML_MI( 0x83, 0x26, 0x01 ), FCML_MI( 0x81, 0x26, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "lock and dword ptr [esi],00000001h", 2, FCML_MI( 0xF0, 0x83, 0x26, 0x01 ), FCML_MI( 0xF0, 0x81, 0x26, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xacquire lock and dword ptr [esi],00000001h", 2, FCML_MI( 0xF2, 0xF0, 0x83, 0x26, 0x01 ), FCML_MI( 0xF2, 0xF0, 0x81, 0x26, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xrelease lock and dword ptr [esi],00000001h", 2, FCML_MI( 0xF3, 0xF0, 0x83, 0x26, 0x01 ), FCML_MI( 0xF3, 0xF0, 0x81, 0x26, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "and word ptr [esi],0001h", 2, FCML_MI( 0x66, 0x83, 0x26, 0x01 ), FCML_MI( 0x66, 0x81, 0x26, 0x01, 0x00 ) );
    FCML_I32_M( "and dword ptr [0201h],00000003h", 2, FCML_MI( 0x67, 0x83, 0x26, 0x01, 0x02, 0x03 ), FCML_MI( 0x67, 0x81, 0x26, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00 ) );
    FCML_A32_M( "andl $0x00000003,0x0201", 2, FCML_MI( 0x67, 0x83, 0x26, 0x01, 0x02, 0x03 ), FCML_MI( 0x67, 0x81, 0x26, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00 ) );

    FCML_I64_M( "and qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0x48, 0x83, 0xA7, 0x01, 0x02, 0x03, 0x4, 0x05 ), FCML_MI( 0x48, 0x81, 0xa7, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "and qword ptr [rdi+0000000004030201h],0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x83, 0xA7, 0x01, 0x02, 0x03, 0x4, 0xff ), FCML_MI( 0x48, 0x81, 0xa7, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32( "and byte ptr [ebp+04030201h],ah", 0x20, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "lock and byte ptr [ebp+04030201h],ah", 0xF0, 0x20, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xacquire lock and byte ptr [ebp+04030201h],ah", 0xF2, 0xF0, 0x20, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xrelease lock and byte ptr [ebp+04030201h],ah", 0xF3, 0xF0, 0x20, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64_D( "and byte ptr [rbp+0000000004030201h],spl", 0x48, 0x20, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64_D( "and byte ptr [rbp+0000000000000001h],spl", 0x48, 0x20, 0x64, 0xa5, 0x01 );
    FCML_I64( "and byte ptr [rbp+0000000000000001h],spl", 0x40, 0x20, 0x65, 0x01 );
    FCML_A64( "and %spl,0x0000000000000001(%rbp)", 0x40, 0x20, 0x65, 0x01 );

    FCML_I32( "and dword ptr [ebp+04030201h],esp", 0x21, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "and word ptr [di+0201h],sp", 0x66, 0x67, 0x21, 0xa5, 0x01, 0x02 );
    FCML_I32( "and dword ptr [di+0201h],esp", 0x67, 0x21, 0xa5, 0x01, 0x02 );
    FCML_I32_M( "and edi,edx", 2, FCML_MI( 0x21, 0xD7 ), FCML_MI(0x23, 0xfa) );
    FCML_I32_M( "and di,dx", 2, FCML_MI( 0x66, 0x21, 0xD7 ), FCML_MI( 0x66, 0x23, 0xfa ) );
    FCML_I32_M( "and edi,edx", 2, FCML_MI( 0x67, 0x21, 0xD7 ), FCML_MI( 0x67, 0x23, 0xfa ) );
    FCML_I32( "and dword ptr [030201a5h],eax",  0x21, 0x05, 0xa5, 0x01, 0x02, 0x03 );
    FCML_I32( "and dword ptr [01a5h],eax",  0x67, 0x21, 0x06, 0xa5, 0x01 );
    FCML_I32( "and dword ptr [ebp+00000001h],ecx",  0x21, 0x4d, 0x01 );
    FCML_I32_D( "and dword ptr [50030201h],ecx",  0x21, 0x0c, 0x25, 0x01, 0x02, 0x03, 0x50 );
    FCML_I32( "and dword ptr [50030201h],ecx",  0x21, 0x0d, 0x01, 0x02, 0x03, 0x50 );
    FCML_I64_D( "and qword ptr [rbp+0000000000000001h],rcx",  0x48, 0x21, 0x4c, 0x25, 0x01 );
    FCML_I64( "and qword ptr [rbp+0000000000000001h],rcx",  0x48, 0x21, 0x4d, 0x01 );
    FCML_I64_D( "and qword ptr [00008000034211ach],rax",  0x48, 0x21, 0x05, 0xa5, 0x01, 0x02, 0x03 );
    FCML_I64_RIP( "and qword ptr [00008000034211ach],rax",  0x48, 0x21, 0x05, 0xa5, 0x01, 0x02, 0x03 );
    FCML_I64( "and qword ptr [rcx+rsi*4],rax",  0x48, 0x21, 0x04, 0xB1 );
    FCML_I64( "and qword ptr [r9+rcx*4+0000000000000001h],r12", 0x4D, 0x21, 0x64, 0x89, 0x01 );
    FCML_A64( "and %r12,0x0000000000000001(%r9,%rcx,4)", 0x4D, 0x21, 0x64, 0x89, 0x01 );
    FCML_I32_D( "and dword ptr [ebp+00000001h],ebx",  0x21, 0x5C, 0xA5, 0x01 );
    FCML_I32( "and dword ptr [ebp+00000001h],ebx",  0x21, 0x5D, 0x01 );
    FCML_I32_D( "and dword ptr [ebp+04030201h],ebx",  0x21, 0x9C, 0xA5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "and dword ptr [ebp+04030201h],ebx",  0x21, 0x9D, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32( "and %ebx,0x04030201(%ebp)",  0x21, 0x9D, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32_D( "and dword ptr [04030201h],ebx",  0x21, 0x1C, 0xA5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "and dword ptr [04030201h],ebx",  0x21, 0x1D, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32_D( "and dword ptr [04030201h],edx",  0x21, 0x14, 0x25, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "and dword ptr [04030201h],edx",  0x21, 0x15, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32_D( "and dword ptr [eax],edx",  0x21, 0x14, 0x20 ); /* DUAL*/
    FCML_I32( "and dword ptr [eax],edx",  0x21, 0x10 ); /* DUAL*/
    FCML_I32_D( "and dword ptr [ecx],edx",  0x21, 0x14, 0x21  ); /* DUAL*/
    FCML_I32( "and dword ptr [ecx],edx",  0x21, 0x11  ); /* DUAL*/
    FCML_I32_D( "and dword ptr [edx],edx",  0x21, 0x14, 0x22 ); /* DUAL*/
    FCML_I32( "and dword ptr [edx],edx",  0x21, 0x12 ); /* DUAL*/
    FCML_I32_D( "and dword ptr [ebx],edx",  0x21, 0x14, 0x23 ); /* DUAL*/
    FCML_I32( "and dword ptr [ebx],edx",  0x21, 0x13 ); /* DUAL*/
    FCML_I32( "and dword ptr [esp],edx",  0x21, 0x14, 0x24 ); /* SIB ONLY*/
    FCML_I32_D( "and dword ptr [04030201h],edx",  0x21, 0x14, 0x25, 0x01, 0x02, 0x03, 0x04 ); /* DUAL*/
    FCML_I32( "and dword ptr [04030201h],edx",  0x21, 0x15, 0x01, 0x02, 0x03, 0x04 ); /* DUAL*/
    FCML_I32_D( "and dword ptr [esi],edx",  0x21, 0x14, 0x26 ); /* DUAL*/
    FCML_I32( "and dword ptr [esi],edx",  0x21, 0x16 ); /* DUAL*/
    FCML_I32( "lock and dword ptr [esi],edx",  0xF0, 0x21, 0x16 ); /* DUAL*/
}

void fcml_tf_instruction_ANDPD_VANDPD(void) {
    FCML_I32( "andpd xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x54, 0x14, 0x01 );
    FCML_I64( "andpd xmm2,xmmword ptr [rcx+rax]", 0x66, 0x0F, 0x54, 0x14, 0x01 );
    FCML_A64( "andpd (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x54, 0x14, 0x01 );
    FCML_I64_M("vandpd ymm10,ymm14,ymmword ptr [r9+rax]", 2, FCML_MI(0x62, 0x51, 0x8d, 0x28, 0x54, 0x14, 0x01), FCML_MI(0xc4, 0x41, 0x0d, 0x54, 0x14, 0x01));
    FCML_I32_M("vandpd xmm2,xmm7,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xc5, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc1, 0x54, 0x14, 0x01));
    FCML_I32_M("vandpd xmm2,xmm2,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xe9, 0x54, 0x14, 0x01));
    FCML_I32_M("vandpd xmm2,xmm6,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc9, 0x54, 0x14, 0x01));
    FCML_I32_M("vandpd xmm2,xmm6,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc9, 0x54, 0x14, 0x01));
    FCML_A32_M("vandpd (%ecx,%eax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc9, 0x54, 0x14, 0x01));
    /* AVX-512 */

    /* {k} */
    FCML_I64("vandpd ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x29, 0x54, 0x14, 0x01);
    FCML_I64("vandpd xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x09, 0x54, 0x14, 0x01);
    FCML_I64("vandpd zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0xED, 0x49, 0x54, 0x0C, 0x01);
    FCML_I32("vandpd xmm1{k1},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0xF5, 0x09, 0x54, 0x4D, 0x00);

    /* {k}{z} */
    FCML_I64("vandpd ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0xA9, 0x54, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vandpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xD5, 0x50, 0x54, 0x3E);
    FCML_I32("vandpd xmm1,xmm1,mmword ptr [esi]{1to2}", 0x62, 0xf1, 0xF5, 0x18, 0x54, 0x0e);

    /* {k}{z}{bcast} */
    FCML_I64("vandpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xD5, 0xB7, 0x54, 0x3E);

    /* {rn} not supported. */
    FCML_I64_A_FAILED("vandpd zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0xD5, 0x97, 0x54, 0xFC);
}

void fcml_tf_instruction_ANDPS_VANDPS(void) {
    FCML_I32( "andps xmm2,xmmword ptr [ecx+eax]", 0x0F, 0x54, 0x14, 0x01 );
    FCML_I64( "andps xmm2,xmmword ptr [rcx+rax]", 0x0F, 0x54, 0x14, 0x01 );
    FCML_A64( "andps (%rcx,%rax),%xmm2", 0x0F, 0x54, 0x14, 0x01 );
    FCML_I64_M("vandps ymm10,ymm14,ymmword ptr [r9+rax]", 2, FCML_MI(0x62, 0x51, 0x0c, 0x28, 0x54, 0x14, 0x01), FCML_MI(0xc4, 0x41, 0x0c, 0x54, 0x14, 0x01));
    FCML_I32_M("vandps xmm2,xmm7,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x44, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc0, 0x54, 0x14, 0x01));
    FCML_I32_M("vandps xmm2,xmm2,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xe8, 0x54, 0x14, 0x01));
    FCML_I32_M("vandps xmm2,xmm6,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc8, 0x54, 0x14, 0x01));
    FCML_A32_M("vandps (%ecx,%eax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x54, 0x14, 0x01), FCML_MI(0xc5, 0xc8, 0x54, 0x14, 0x01));

    /* AVX-512. */

    /* {k} */
    FCML_I64("vandps ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x29, 0x54, 0x14, 0x01);
    FCML_I64("vandps xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x09, 0x54, 0x14, 0x01);
    FCML_I64("vandps zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0x49, 0x54, 0x0C, 0x01);
    FCML_I32("vandps xmm1{k1},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0x74, 0x09, 0x54, 0x4D, 0x00);

    /* {k}{z} */
    FCML_I64("vandps ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0xA9, 0x54, 0x14, 0x01);
    FCML_I64("vandps xmm10{k1}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x89, 0x54, 0x14, 0x01);
    FCML_I64("vandps zmm1{k1}{z},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0xC9, 0x54, 0x0C, 0x01);
    FCML_I32("vandps xmm1{k1}{z},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0x74, 0x89, 0x54, 0x4D, 0x00);

    /* {bcast} */
    FCML_I64("vandps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x54, 0x50, 0x54, 0x3E);
    FCML_I64("vandps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0x30, 0x54, 0x3E);
    FCML_I64("vandps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x54, 0x10, 0x54, 0x3E);
    FCML_I32("vandps xmm1,xmm1,dword ptr [esi]{1to4}", 0x62, 0xf1, 0x74, 0x18, 0x54, 0x0e);

    /* {k}{z}{bcast} */
    FCML_I64("vandps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0xB7, 0x54, 0x3E);

    /* {rn} */
    FCML_I64_A_FAILED("vandps zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x54, 0xFC);

}

void fcml_tf_instruction_ANDNPD_VANDNPD(void) {
    FCML_I32( "andnpd xmm2,xmmword ptr [ecx+eax]", 0x66, 0x0F, 0x55, 0x14, 0x01 );
    FCML_A64( "andnpd (%rcx,%rax),%xmm2", 0x66, 0x0F, 0x55, 0x14, 0x01 );
    FCML_I64_M("vandnpd ymm10,ymm14,ymmword ptr [r9+rax]", 2, FCML_MI(0x62, 0x51, 0x8d, 0x28, 0x55, 0x14, 0x01), FCML_MI(0xc4, 0x41, 0x0d, 0x55, 0x14, 0x01));
    FCML_I32_M("vandnpd xmm2,xmm7,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xc5, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xc1, 0x55, 0x14, 0x01));
    FCML_I32_M("vandnpd xmm2,xmm2,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xe9, 0x55, 0x14, 0x01));
    FCML_I32_M("vandnpd xmm2,xmm6,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xc9, 0x55, 0x14, 0x01));
    /* AVX-512 */

    /* {k} */
    FCML_I64("vandnpd ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x29, 0x55, 0x14, 0x01);
    FCML_I64("vandnpd xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0x09, 0x55, 0x14, 0x01);
    FCML_I64("vandnpd zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0xED, 0x49, 0x55, 0x0C, 0x01);
    FCML_I32("vandnpd xmm1{k1},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0xF5, 0x09, 0x55, 0x4D, 0x00);

    /* {k}{z} */
    FCML_I64("vandnpd ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8D, 0xA9, 0x55, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vandnpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xD5, 0x50, 0x55, 0x3E);
    FCML_I32("vandnpd xmm1,xmm1,mmword ptr [esi]{1to2}", 0x62, 0xf1, 0xF5, 0x18, 0x55, 0x0e);

    /* {k}{z}{bcast} */
    FCML_I64("vandnpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xD5, 0xB7, 0x55, 0x3E);

    /* {rn} not supported. */
    FCML_I64_A_FAILED("vandnpd zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0xD5, 0x97, 0x55, 0xFC);
}

void fcml_tf_instruction_ANDNPS_VANDNPS(void) {
    FCML_I32( "andnps xmm2,xmmword ptr [ecx+eax]", 0x0F, 0x55, 0x14, 0x01 );
    FCML_I64( "andnps xmm2,xmmword ptr [rcx+rax]", 0x0F, 0x55, 0x14, 0x01 );
    FCML_I64_A( "andnps xmm2,[rcx+rax]", 0x0F, 0x55, 0x14, 0x01 );
    FCML_I64_M("vandnps ymm10,ymm14,ymmword ptr [r9+rax]", 2, FCML_MI(0x62, 0x51, 0x0c, 0x28, 0x55, 0x14, 0x01), FCML_MI(0xc4, 0x41, 0x0c, 0x55, 0x14, 0x01));
    FCML_A64_M("vandnps (%r9,%rax),%ymm14,%ymm10", 2, FCML_MI(0x62, 0x51, 0x0c, 0x28, 0x55, 0x14, 0x01), FCML_MI(0xc4, 0x41, 0x0c, 0x55, 0x14, 0x01));
    FCML_I32_M("vandnps xmm2,xmm7,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x44, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xc0, 0x55, 0x14, 0x01));
    FCML_I32_M("vandnps xmm2,xmm2,xmmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xe8, 0x55, 0x14, 0x01));
    FCML_A32_M("vandnps (%ecx,%eax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xc8, 0x55, 0x14, 0x01));

    FCML_I32_M_A("vandnps xmm2,xmm7,[ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x44, 0x08, 0x55, 0x14, 0x01), FCML_MI(0xc5, 0xc0, 0x55, 0x14, 0x01));
    /* AVX-512. */

    /* {k} */
    FCML_I64("vandnps ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x29, 0x55, 0x14, 0x01);
    FCML_I64("vandnps xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x09, 0x55, 0x14, 0x01);
    FCML_I64("vandnps zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0x49, 0x55, 0x0C, 0x01);
    FCML_I32("vandnps xmm1{k1},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0x74, 0x09, 0x55, 0x4D, 0x00);

    /* {k}{z} */
    FCML_I64("vandnps ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0xA9, 0x55, 0x14, 0x01);
    FCML_I64("vandnps xmm10{k1}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x89, 0x55, 0x14, 0x01);
    FCML_I64("vandnps zmm1{k1}{z},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0xC9, 0x55, 0x0C, 0x01);
    FCML_I32("vandnps xmm1{k1}{z},xmm1,xmmword ptr [ebp+00000000h]", 0x62, 0xF1, 0x74, 0x89, 0x55, 0x4D, 0x00);

    /* {bcast} */
    FCML_I64("vandnps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x54, 0x50, 0x55, 0x3E);
    FCML_I64("vandnps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0x30, 0x55, 0x3E);
    FCML_I64("vandnps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x54, 0x10, 0x55, 0x3E);
    FCML_I32("vandnps xmm1,xmm1,dword ptr [esi]{1to4}", 0x62, 0xf1, 0x74, 0x18, 0x55, 0x0e);

    /* {k}{z}{bcast} */
    FCML_I64("vandnps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0xB7, 0x55, 0x3E);

    /* {rn} */
    FCML_I64_A_FAILED("vandps zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x55, 0xFC);
}

void fcml_tf_instruction_ARPL(void) {
    FCML_I32( "arpl word ptr [ecx+eax],dx", 0x63, 0x14, 0x01 );
    FCML_I32_A( "arpl [ecx+eax],dx", 0x63, 0x14, 0x01 );
    FCML_A32( "arpl %dx,(%ecx,%eax)", 0x63, 0x14, 0x01 );
    FCML_I32_D( "arpl word ptr [ecx+eax],dx", 0x66, 0x63, 0x14, 0x01 );
    FCML_I32( "arpl word ptr [si],dx", 0x67, 0x63, 0x14 );
    FCML_A32( "arpl %dx,(%si)", 0x67, 0x63, 0x14 );
    FCML_I64_FAILED( "arpl edi", 0x63, 0xDF );
}

void fcml_tf_instruction_ANDN(void) {
    FCML_I32( "andn eax,edi,dword ptr [eax]", 0xC4, 0xE2, 0x40, 0xF2, 0x00 );
    FCML_I32_A( "andn eax,edi,[eax]", 0xC4, 0xE2, 0x40, 0xF2, 0x00 );
    FCML_A64( "andn (%rax),%edi,%eax", 0xC4, 0xE2, 0x40, 0xF2, 0x00 );
    FCML_I32( "andn eax,edi,eax", 0xC4, 0xE2, 0x40, 0xF2, 0xC0 );
    FCML_I64( "andn rax,rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC0, 0xF2, 0x00 );
    FCML_I64( "andn rax,rdi,rax", 0xC4, 0xE2, 0xC0, 0xF2, 0xC0 );
    FCML_A64( "andn %rax,%rdi,%rax", 0xC4, 0xE2, 0xC0, 0xF2, 0xC0 );
}

void fcml_tf_instruction_ADCX(void) {
    FCML_I32( "adcx eax,dword ptr [eax]", 0x66, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_A32( "adcx (%eax),%eax", 0x66, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_I64( "adcx eax,dword ptr [rax]", 0x66, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_I64( "adcx rax,qword ptr [rax]", 0x66, 0x48, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_A64( "adcx (%rax),%rax", 0x66, 0x48, 0x0F, 0x38, 0xF6, 0x00 );
}

void fcml_tf_instruction_ADOX(void) {
    FCML_I32( "adox eax,dword ptr [eax]", 0xF3, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_A64( "adox (%rax),%eax", 0xF3, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_I64( "adox eax,dword ptr [rax]", 0xF3, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_I64( "adox rax,qword ptr [rax]", 0xF3, 0x48, 0x0F, 0x38, 0xF6, 0x00 );
    FCML_A64( "adox (%rax),%rax", 0xF3, 0x48, 0x0F, 0x38, 0xF6, 0x00 );
}

fcml_stf_test_case fctl_ti_instructions_a[] = {
    { "fcml_tf_instruction_AAA", fcml_tf_instruction_AAA },
    { "fcml_tf_instruction_AAD", fcml_tf_instruction_AAD },
    { "fcml_tf_instruction_AAM", fcml_tf_instruction_AAM },
    { "fcml_tf_instruction_AAS", fcml_tf_instruction_AAS },
    { "fcml_tf_instruction_ADC", fcml_tf_instruction_ADC },
    { "fcml_tf_instruction_ADD", fcml_tf_instruction_ADD },
    { "fcml_tf_instruction_ADDPD_VADDPD", fcml_tf_instruction_ADDPD_VADDPD },
    { "fcml_tf_instruction_ADDPS_VADDPS", fcml_tf_instruction_ADDPS_VADDPS },
    { "fcml_tf_instruction_ADDSD_VADDSD", fcml_tf_instruction_ADDSD_VADDSD },
    { "fcml_tf_instruction_ADDSS_VADDSS", fcml_tf_instruction_ADDSS_VADDSS },
    { "fcml_tf_instruction_ADDSUBPD_VADDSUBPD", fcml_tf_instruction_ADDSUBPD_VADDSUBPD },
    { "fcml_tf_instruction_ADDSUBPS_VADDSUBPS", fcml_tf_instruction_ADDSUBPS_VADDSUBPS },
    { "fcml_tf_instruction_AESDEC_VAESDEC", fcml_tf_instruction_AESDEC_VAESDEC },
    { "fcml_tf_instruction_AESDECLAST_VAESDECLAST", fcml_tf_instruction_AESDECLAST_VAESDECLAST },
    { "fcml_tf_instruction_AESENC_VAESENC", fcml_tf_instruction_AESENC_VAESENC },
    { "fcml_tf_instruction_AESENCLAST", fcml_tf_instruction_AESENCLAST },
    { "fcml_tf_instruction_AESIMC_VAESIMC", fcml_tf_instruction_AESIMC_VAESIMC },
    { "fcml_tf_instruction_AESKEYGENASSIST_VAESKEYGENASSIST", fcml_tf_instruction_AESKEYGENASSIST_VAESKEYGENASSIST },
    { "fcml_tf_instruction_AND", fcml_tf_instruction_AND },
    { "fcml_tf_instruction_ANDPD_VANDPD", fcml_tf_instruction_ANDPD_VANDPD },
    { "fcml_tf_instruction_ANDPS_VANDPS", fcml_tf_instruction_ANDPS_VANDPS },
    { "fcml_tf_instruction_ANDNPD_VANDNPD", fcml_tf_instruction_ANDNPD_VANDNPD },
    { "fcml_tf_instruction_ANDNPS_VANDNPS", fcml_tf_instruction_ANDNPS_VANDNPS },
    { "fcml_tf_instruction_ARPL", fcml_tf_instruction_ARPL },
    { "fcml_tf_instruction_ANDN", fcml_tf_instruction_ANDN },
    { "fcml_tf_instruction_ADCX", fcml_tf_instruction_ADCX },
    { "fcml_tf_instruction_ADOX", fcml_tf_instruction_ADOX },
    FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_a = {
    "suite-fctl_ti_instructions_a", fcml_tf_instructions_a_suite_init, fcml_tf_instructions_a_suite_cleanup, fctl_ti_instructions_a
};

