# frozen_string_literal: true

describe Facts::Linux::Dmi::Board::SerialNumber do
  describe '#call_the_resolver' do
    subject(:fact) { Facts::Linux::Dmi::Board::SerialNumber.new }

    let(:serial_number) { 'None' }

    before do
      allow(Facter::Resolvers::Linux::DmiBios).to \
        receive(:resolve).with(:board_serial).and_return(serial_number)
    end

    it 'returns board serial number fact' do
      expect(fact.call_the_resolver).to be_an_instance_of(Array).and \
        contain_exactly(an_object_having_attributes(name: 'dmi.board.serial_number', value: serial_number),
                        an_object_having_attributes(name: 'boardserialnumber', value: serial_number, type: :legacy))
    end
  end
end
