# Generated by Django 3.2.19 on 2023-09-28 12:46

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0009_alter_token_comment'),
    ]

    operations = [
        migrations.CreateModel(
            name='Identity',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'issuer',
                    models.CharField(
                        help_text='identifier of auhoritative system for this identity',
                        max_length=512,
                    ),
                ),
                (
                    'subject',
                    models.CharField(
                        help_text='identifier of the user in the issuer system',
                        max_length=512,
                    ),
                ),
                (
                    'last_used',
                    models.DateTimeField(
                        auto_now=True,
                        help_text='last time this identity has been used',
                    ),
                ),
                (
                    'profile',
                    models.CharField(
                        blank=True,
                        help_text='URL to the user profile in the issuer system',
                        max_length=1024,
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='identities',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name='identity',
            constraint=models.UniqueConstraint(
                fields=('issuer', 'subject'),
                name='Each issuer must have unique subjects',
            ),
        ),
    ]
