/** Set the value of "WMO block number" from a variable of type int */
inline void set_block(int val)  { seti(WR_VAR(0, 1, 1), val); }
/** Get the "WMO block number" physical value stored in the message */
inline const wreport::Var* get_block() const
{ return find(WR_VAR(0, 1, 1)); }
/** Set the value of "WMO station number" from a variable of type int */
inline void set_station(int val)  { seti(WR_VAR(0, 1, 2), val); }
/** Get the "WMO station number" physical value stored in the message */
inline const wreport::Var* get_station() const
{ return find(WR_VAR(0, 1, 2)); }
/** Set the value of "Aircraft registration number or other identification" from a variable of type const char* */
inline void set_flight_reg_no(const char* val)  { setc(WR_VAR(0, 1, 8), val); }
/** Get the "Aircraft registration number or other identification" physical value stored in the message */
inline const wreport::Var* get_flight_reg_no() const
{ return find(WR_VAR(0, 1, 8)); }
/** Set the value of "Mobile station identifier" from a variable of type const char* */
inline void set_ident(const char* val)  { setc(WR_VAR(0, 1, 11), val); }
/** Get the "Mobile station identifier" physical value stored in the message */
inline const wreport::Var* get_ident() const
{ return find(WR_VAR(0, 1, 11)); }
/** Set the value of "Station or site name" from a variable of type const char* */
inline void set_st_name(const char* val)  { setc(WR_VAR(0, 1, 19), val); }
/** Get the "Station or site name" physical value stored in the message */
inline const wreport::Var* get_st_name() const
{ return find(WR_VAR(0, 1, 19)); }
/** Set the value of "ICAO location indicator" from a variable of type const char* */
inline void set_st_name_icao(const char* val)  { setc(WR_VAR(0, 1, 63), val); }
/** Get the "ICAO location indicator" physical value stored in the message */
inline const wreport::Var* get_st_name_icao() const
{ return find(WR_VAR(0, 1, 63)); }
/** Set the value of "Report mnemonic" from a variable of type const char* */
inline void set_rep_memo(const char* val)  { setc(WR_VAR(0, 1, 194), val); }
/** Get the "Report mnemonic" physical value stored in the message */
inline const wreport::Var* get_rep_memo() const
{ return find(WR_VAR(0, 1, 194)); }
/** Set the value of "Air quality observing station local code" from a variable of type int */
inline void set_poll_lcode(int val)  { seti(WR_VAR(0, 1, 212), val); }
/** Get the "Air quality observing station local code" physical value stored in the message */
inline const wreport::Var* get_poll_lcode() const
{ return find(WR_VAR(0, 1, 212)); }
/** Set the value of "Airbase air quality observing station code" from a variable of type int */
inline void set_poll_scode(int val)  { seti(WR_VAR(0, 1, 213), val); }
/** Get the "Airbase air quality observing station code" physical value stored in the message */
inline const wreport::Var* get_poll_scode() const
{ return find(WR_VAR(0, 1, 213)); }
/** Set the value of "GEMS air quality observing station code" from a variable of type int */
inline void set_poll_gemscode(int val)  { seti(WR_VAR(0, 1, 214), val); }
/** Get the "GEMS air quality observing station code" physical value stored in the message */
inline const wreport::Var* get_poll_gemscode() const
{ return find(WR_VAR(0, 1, 214)); }
/** Set the value of "Air quality observing station dominant emission source" from a variable of type int */
inline void set_poll_source(int val)  { seti(WR_VAR(0, 1, 215), val); }
/** Get the "Air quality observing station dominant emission source" physical value stored in the message */
inline const wreport::Var* get_poll_source() const
{ return find(WR_VAR(0, 1, 215)); }
/** Set the value of "Air quality observing station area type" from a variable of type int */
inline void set_poll_atype(int val)  { seti(WR_VAR(0, 1, 216), val); }
/** Get the "Air quality observing station area type" physical value stored in the message */
inline const wreport::Var* get_poll_atype() const
{ return find(WR_VAR(0, 1, 216)); }
/** Set the value of "Air quality observing station terrain type" from a variable of type int */
inline void set_poll_ttype(int val)  { seti(WR_VAR(0, 1, 217), val); }
/** Get the "Air quality observing station terrain type" physical value stored in the message */
inline const wreport::Var* get_poll_ttype() const
{ return find(WR_VAR(0, 1, 217)); }
/** Set the value of "Type of station" from a variable of type int */
inline void set_st_type(int val)  { seti(WR_VAR(0, 2, 1), val); }
/** Get the "Type of station" physical value stored in the message */
inline const wreport::Var* get_st_type() const
{ return find(WR_VAR(0, 2, 1)); }
/** Set the value of "Type of instrumentation for wind measurement" from a variable of type int */
inline void set_wind_inst(int val)  { seti(WR_VAR(0, 2, 2), val); }
/** Get the "Type of instrumentation for wind measurement" physical value stored in the message */
inline const wreport::Var* get_wind_inst() const
{ return find(WR_VAR(0, 2, 2)); }
/** Set the value of "Precision of temperature observation" from a variable of type double */
inline void set_temp_precision(double val)  { setd(WR_VAR(0, 2, 5), val); }
/** Get the "Precision of temperature observation" physical value stored in the message */
inline const wreport::Var* get_temp_precision() const
{ return find(WR_VAR(0, 2, 5)); }
/** Set the value of "Aircraft navigational system" from a variable of type int */
inline void set_navsys(int val)  { seti(WR_VAR(0, 2, 61), val); }
/** Get the "Aircraft navigational system" physical value stored in the message */
inline const wreport::Var* get_navsys() const
{ return find(WR_VAR(0, 2, 61)); }
/** Set the value of "Aircraft data relay system" from a variable of type int */
inline void set_data_relay(int val)  { seti(WR_VAR(0, 2, 62), val); }
/** Get the "Aircraft data relay system" physical value stored in the message */
inline const wreport::Var* get_data_relay() const
{ return find(WR_VAR(0, 2, 62)); }
/** Set the value of "Aircraft roll angle" from a variable of type double */
inline void set_flight_roll(double val)  { setd(WR_VAR(0, 2, 63), val); }
/** Get the "Aircraft roll angle" physical value stored in the message */
inline const wreport::Var* get_flight_roll() const
{ return find(WR_VAR(0, 2, 63)); }
/** Set the value of "Original specification of latitude/longitude" from a variable of type int */
inline void set_latlon_spec(int val)  { seti(WR_VAR(0, 2, 70), val); }
/** Get the "Original specification of latitude/longitude" physical value stored in the message */
inline const wreport::Var* get_latlon_spec() const
{ return find(WR_VAR(0, 2, 70)); }
/** Set the value of "Year of the observation" from a variable of type int */
inline void set_year(int val)  { seti(WR_VAR(0, 4, 1), val); }
/** Get the "Year of the observation" physical value stored in the message */
inline const wreport::Var* get_year() const
{ return find(WR_VAR(0, 4, 1)); }
/** Set the value of "Month of the observation" from a variable of type int */
inline void set_month(int val)  { seti(WR_VAR(0, 4, 2), val); }
/** Get the "Month of the observation" physical value stored in the message */
inline const wreport::Var* get_month() const
{ return find(WR_VAR(0, 4, 2)); }
/** Set the value of "Day of the observation" from a variable of type int */
inline void set_day(int val)  { seti(WR_VAR(0, 4, 3), val); }
/** Get the "Day of the observation" physical value stored in the message */
inline const wreport::Var* get_day() const
{ return find(WR_VAR(0, 4, 3)); }
/** Set the value of "Hour of the observation" from a variable of type int */
inline void set_hour(int val)  { seti(WR_VAR(0, 4, 4), val); }
/** Get the "Hour of the observation" physical value stored in the message */
inline const wreport::Var* get_hour() const
{ return find(WR_VAR(0, 4, 4)); }
/** Set the value of "Minute of the observation" from a variable of type int */
inline void set_minute(int val)  { seti(WR_VAR(0, 4, 5), val); }
/** Get the "Minute of the observation" physical value stored in the message */
inline const wreport::Var* get_minute() const
{ return find(WR_VAR(0, 4, 5)); }
/** Set the value of "Second of the observation" from a variable of type int */
inline void set_second(int val)  { seti(WR_VAR(0, 4, 6), val); }
/** Get the "Second of the observation" physical value stored in the message */
inline const wreport::Var* get_second() const
{ return find(WR_VAR(0, 4, 6)); }
/** Set the value of "Latitude of the station" from a variable of type double */
inline void set_latitude(double val)  { setd(WR_VAR(0, 5, 1), val); }
/** Get the "Latitude of the station" physical value stored in the message */
inline const wreport::Var* get_latitude() const
{ return find(WR_VAR(0, 5, 1)); }
/** Set the value of "Longiture of the station" from a variable of type double */
inline void set_longitude(double val)  { setd(WR_VAR(0, 6, 1), val); }
/** Get the "Longiture of the station" physical value stored in the message */
inline const wreport::Var* get_longitude() const
{ return find(WR_VAR(0, 6, 1)); }
/** Set the value of "Isobaric surface" from a variable of type double */
inline void set_isobaric_surface(double val)  { setd(WR_VAR(0, 7, 4), val); }
/** Get the "Isobaric surface" physical value stored in the message */
inline const wreport::Var* get_isobaric_surface() const
{ return find(WR_VAR(0, 7, 4)); }
/** Set the value of "Height of release of sonde above msl" from a variable of type double */
inline void set_height_release(double val)  { setd(WR_VAR(0, 7, 7), val); }
/** Get the "Height of release of sonde above msl" physical value stored in the message */
inline const wreport::Var* get_height_release() const
{ return find(WR_VAR(0, 7, 7)); }
/** Set the value of "Height of station" from a variable of type double */
inline void set_height_station(double val)  { setd(WR_VAR(0, 7, 30), val); }
/** Get the "Height of station" physical value stored in the message */
inline const wreport::Var* get_height_station() const
{ return find(WR_VAR(0, 7, 30)); }
/** Set the value of "Height of barometer above mean sea level" from a variable of type double */
inline void set_height_baro(double val)  { setd(WR_VAR(0, 7, 31), val); }
/** Get the "Height of barometer above mean sea level" physical value stored in the message */
inline const wreport::Var* get_height_baro() const
{ return find(WR_VAR(0, 7, 31)); }
/** Set the value of "Phase of aircraft flight" from a variable of type int */
inline void set_flight_phase(int val)  { seti(WR_VAR(0, 8, 4), val); }
/** Get the "Phase of aircraft flight" physical value stored in the message */
inline const wreport::Var* get_flight_phase() const
{ return find(WR_VAR(0, 8, 4)); }
/** Set the value of "Time significance" from a variable of type int */
inline void set_timesig(int val)  { seti(WR_VAR(0, 8, 21), val); }
/** Get the "Time significance" physical value stored in the message */
inline const wreport::Var* get_timesig() const
{ return find(WR_VAR(0, 8, 21)); }
/** Set the value of "Station elevation quality mark (for mobile stations)" from a variable of type int */
inline void set_station_height_quality(int val)  { seti(WR_VAR(0, 33, 24), val); }
/** Get the "Station elevation quality mark (for mobile stations)" physical value stored in the message */
inline const wreport::Var* get_station_height_quality() const
{ return find(WR_VAR(0, 33, 24)); }
/** Set the value of "Total cloud cover (N)" from a variable of type int */
inline void set_cloud_n(int val)  { seti(WR_VAR(0, 20, 10), val); }
/** Get the "Total cloud cover (N)" physical value stored in the message */
inline const wreport::Var* get_cloud_n() const
{ return find(WR_VAR(0, 20, 10)); }
/** Set the value of "Cloud amount (N4)" from a variable of type int */
inline void set_cloud_n4(int val)  { seti(WR_VAR(0, 20, 11), val); }
/** Get the "Cloud amount (N4)" physical value stored in the message */
inline const wreport::Var* get_cloud_n4() const
{ return find(WR_VAR(0, 20, 11)); }
/** Set the value of "Cloud amount (C4)" from a variable of type int */
inline void set_cloud_c4(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud amount (C4)" physical value stored in the message */
inline const wreport::Var* get_cloud_c4() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Height of base of cloud (H4)" from a variable of type double */
inline void set_cloud_h4(double val)  { setd(WR_VAR(0, 20, 13), val); }
/** Get the "Height of base of cloud (H4)" physical value stored in the message */
inline const wreport::Var* get_cloud_h4() const
{ return find(WR_VAR(0, 20, 13)); }
/** Set the value of "Cloud amount (N3)" from a variable of type int */
inline void set_cloud_n3(int val)  { seti(WR_VAR(0, 20, 11), val); }
/** Get the "Cloud amount (N3)" physical value stored in the message */
inline const wreport::Var* get_cloud_n3() const
{ return find(WR_VAR(0, 20, 11)); }
/** Set the value of "Cloud amount (C3)" from a variable of type int */
inline void set_cloud_c3(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud amount (C3)" physical value stored in the message */
inline const wreport::Var* get_cloud_c3() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Height of base of cloud (H3)" from a variable of type double */
inline void set_cloud_h3(double val)  { setd(WR_VAR(0, 20, 13), val); }
/** Get the "Height of base of cloud (H3)" physical value stored in the message */
inline const wreport::Var* get_cloud_h3() const
{ return find(WR_VAR(0, 20, 13)); }
/** Set the value of "Cloud amount (N2)" from a variable of type int */
inline void set_cloud_n2(int val)  { seti(WR_VAR(0, 20, 11), val); }
/** Get the "Cloud amount (N2)" physical value stored in the message */
inline const wreport::Var* get_cloud_n2() const
{ return find(WR_VAR(0, 20, 11)); }
/** Set the value of "Cloud amount (C2)" from a variable of type int */
inline void set_cloud_c2(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud amount (C2)" physical value stored in the message */
inline const wreport::Var* get_cloud_c2() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Height of base of cloud (H2)" from a variable of type double */
inline void set_cloud_h2(double val)  { setd(WR_VAR(0, 20, 13), val); }
/** Get the "Height of base of cloud (H2)" physical value stored in the message */
inline const wreport::Var* get_cloud_h2() const
{ return find(WR_VAR(0, 20, 13)); }
/** Set the value of "Cloud amount (N1)" from a variable of type int */
inline void set_cloud_n1(int val)  { seti(WR_VAR(0, 20, 11), val); }
/** Get the "Cloud amount (N1)" physical value stored in the message */
inline const wreport::Var* get_cloud_n1() const
{ return find(WR_VAR(0, 20, 11)); }
/** Set the value of "Cloud amount (C1)" from a variable of type int */
inline void set_cloud_c1(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud amount (C1)" physical value stored in the message */
inline const wreport::Var* get_cloud_c1() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Height of base of cloud (H1)" from a variable of type double */
inline void set_cloud_h1(double val)  { setd(WR_VAR(0, 20, 13), val); }
/** Get the "Height of base of cloud (H1)" physical value stored in the message */
inline const wreport::Var* get_cloud_h1() const
{ return find(WR_VAR(0, 20, 13)); }
/** Set the value of "Cloud type (CH)" from a variable of type int */
inline void set_cloud_ch(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud type (CH)" physical value stored in the message */
inline const wreport::Var* get_cloud_ch() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Cloud type (CM)" from a variable of type int */
inline void set_cloud_cm(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud type (CM)" physical value stored in the message */
inline const wreport::Var* get_cloud_cm() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Cloud type (CL)" from a variable of type int */
inline void set_cloud_cl(int val)  { seti(WR_VAR(0, 20, 12), val); }
/** Get the "Cloud type (CL)" physical value stored in the message */
inline const wreport::Var* get_cloud_cl() const
{ return find(WR_VAR(0, 20, 12)); }
/** Set the value of "Cloud amount (NH)" from a variable of type int */
inline void set_cloud_nh(int val)  { seti(WR_VAR(0, 20, 11), val); }
/** Get the "Cloud amount (NH)" physical value stored in the message */
inline const wreport::Var* get_cloud_nh() const
{ return find(WR_VAR(0, 20, 11)); }
/** Set the value of "Height of base of cloud (HH)" from a variable of type double */
inline void set_cloud_hh(double val)  { setd(WR_VAR(0, 20, 13), val); }
/** Get the "Height of base of cloud (HH)" physical value stored in the message */
inline const wreport::Var* get_cloud_hh() const
{ return find(WR_VAR(0, 20, 13)); }
/** Set the value of "Wind direction at 10 metres above ground" from a variable of type double */
inline void set_wind_dir(double val)  { setd(WR_VAR(0, 11, 1), val); }
/** Get the "Wind direction at 10 metres above ground" physical value stored in the message */
inline const wreport::Var* get_wind_dir() const
{ return find(WR_VAR(0, 11, 1)); }
/** Set the value of "Wind speed at 10 metres above ground" from a variable of type double */
inline void set_wind_speed(double val)  { setd(WR_VAR(0, 11, 2), val); }
/** Get the "Wind speed at 10 metres above ground" physical value stored in the message */
inline const wreport::Var* get_wind_speed() const
{ return find(WR_VAR(0, 11, 2)); }
/** Set the value of "Extreme counterclockwise wind direction of a variable wind at 10 metres above ground" from a variable of type double */
inline void set_ex_ccw_wind(double val)  { setd(WR_VAR(0, 11, 16), val); }
/** Get the "Extreme counterclockwise wind direction of a variable wind at 10 metres above ground" physical value stored in the message */
inline const wreport::Var* get_ex_ccw_wind() const
{ return find(WR_VAR(0, 11, 16)); }
/** Set the value of "Extreme clockwise wind direction of a variable wind at 10 metres above ground" from a variable of type double */
inline void set_ex_cw_wind(double val)  { setd(WR_VAR(0, 11, 17), val); }
/** Get the "Extreme clockwise wind direction of a variable wind at 10 metres above ground" physical value stored in the message */
inline const wreport::Var* get_ex_cw_wind() const
{ return find(WR_VAR(0, 11, 17)); }
/** Set the value of "Maximum wind gust speed at 10 metres above ground" from a variable of type double */
inline void set_wind_gust_max_speed(double val)  { setd(WR_VAR(0, 11, 41), val); }
/** Get the "Maximum wind gust speed at 10 metres above ground" physical value stored in the message */
inline const wreport::Var* get_wind_gust_max_speed() const
{ return find(WR_VAR(0, 11, 41)); }
/** Set the value of "Maximum wind gust direction at 10 metres above ground" from a variable of type double */
inline void set_wind_gust_max_dir(double val)  { setd(WR_VAR(0, 11, 43), val); }
/** Get the "Maximum wind gust direction at 10 metres above ground" physical value stored in the message */
inline const wreport::Var* get_wind_gust_max_dir() const
{ return find(WR_VAR(0, 11, 43)); }
/** Set the value of "Altimeter setting (QNH)" from a variable of type double */
inline void set_qnh(double val)  { setd(WR_VAR(0, 10, 52), val); }
/** Get the "Altimeter setting (QNH)" physical value stored in the message */
inline const wreport::Var* get_qnh() const
{ return find(WR_VAR(0, 10, 52)); }
/** Set the value of "Temperature at 2 metres above ground" from a variable of type double */
inline void set_temp_2m(double val)  { setd(WR_VAR(0, 12, 101), val); }
/** Get the "Temperature at 2 metres above ground" physical value stored in the message */
inline const wreport::Var* get_temp_2m() const
{ return find(WR_VAR(0, 12, 101)); }
/** Set the value of "Wet bulb temperature at 2 metres above ground" from a variable of type double */
inline void set_wet_temp_2m(double val)  { setd(WR_VAR(0, 12, 102), val); }
/** Get the "Wet bulb temperature at 2 metres above ground" physical value stored in the message */
inline const wreport::Var* get_wet_temp_2m() const
{ return find(WR_VAR(0, 12, 102)); }
/** Set the value of "Dew point at 2 metres above ground" from a variable of type double */
inline void set_dewpoint_2m(double val)  { setd(WR_VAR(0, 12, 103), val); }
/** Get the "Dew point at 2 metres above ground" physical value stored in the message */
inline const wreport::Var* get_dewpoint_2m() const
{ return find(WR_VAR(0, 12, 103)); }
/** Set the value of "Humidity at 2 metres above ground" from a variable of type double */
inline void set_humidity(double val)  { setd(WR_VAR(0, 13, 3), val); }
/** Get the "Humidity at 2 metres above ground" physical value stored in the message */
inline const wreport::Var* get_humidity() const
{ return find(WR_VAR(0, 13, 3)); }
/** Set the value of "Pressure reduced to mean sea level" from a variable of type double */
inline void set_press_msl(double val)  { setd(WR_VAR(0, 10, 51), val); }
/** Get the "Pressure reduced to mean sea level" physical value stored in the message */
inline const wreport::Var* get_press_msl() const
{ return find(WR_VAR(0, 10, 51)); }
/** Set the value of "Direction of motion of moving observing platform" from a variable of type int */
inline void set_st_dir(int val)  { seti(WR_VAR(0, 1, 12), val); }
/** Get the "Direction of motion of moving observing platform" physical value stored in the message */
inline const wreport::Var* get_st_dir() const
{ return find(WR_VAR(0, 1, 12)); }
/** Set the value of "Speed of motion of moving observing platform" from a variable of type int */
inline void set_st_speed(int val)  { seti(WR_VAR(0, 1, 13), val); }
/** Get the "Speed of motion of moving observing platform" physical value stored in the message */
inline const wreport::Var* get_st_speed() const
{ return find(WR_VAR(0, 1, 13)); }
/** Set the value of "Type of measuring equipment used" from a variable of type int */
inline void set_meas_equip_type(int val)  { seti(WR_VAR(0, 2, 3), val); }
/** Get the "Type of measuring equipment used" physical value stored in the message */
inline const wreport::Var* get_meas_equip_type() const
{ return find(WR_VAR(0, 2, 3)); }
/** Set the value of "Radiosonde type" from a variable of type int */
inline void set_sonde_type(int val)  { seti(WR_VAR(0, 2, 11), val); }
/** Get the "Radiosonde type" physical value stored in the message */
inline const wreport::Var* get_sonde_type() const
{ return find(WR_VAR(0, 2, 11)); }
/** Set the value of "Radiosonde computational method" from a variable of type int */
inline void set_sonde_method(int val)  { seti(WR_VAR(0, 2, 12), val); }
/** Get the "Radiosonde computational method" physical value stored in the message */
inline const wreport::Var* get_sonde_method() const
{ return find(WR_VAR(0, 2, 12)); }
/** Set the value of "Solar and infrared radiation correction" from a variable of type int */
inline void set_sonde_correction(int val)  { seti(WR_VAR(0, 2, 13), val); }
/** Get the "Solar and infrared radiation correction" physical value stored in the message */
inline const wreport::Var* get_sonde_correction() const
{ return find(WR_VAR(0, 2, 13)); }
/** Set the value of "Tracking technique/status of system used" from a variable of type int */
inline void set_sonde_tracking(int val)  { seti(WR_VAR(0, 2, 14), val); }
/** Get the "Tracking technique/status of system used" physical value stored in the message */
inline const wreport::Var* get_sonde_tracking() const
{ return find(WR_VAR(0, 2, 14)); }
/** Set the value of "Pressure at ground level" from a variable of type double */
inline void set_press(double val)  { setd(WR_VAR(0, 10, 4), val); }
/** Get the "Pressure at ground level" physical value stored in the message */
inline const wreport::Var* get_press() const
{ return find(WR_VAR(0, 10, 4)); }
/** Set the value of "Anemometer height" from a variable of type double */
inline void set_height_anem(double val)  { setd(WR_VAR(0, 10, 197), val); }
/** Get the "Anemometer height" physical value stored in the message */
inline const wreport::Var* get_height_anem() const
{ return find(WR_VAR(0, 10, 197)); }
/** Set the value of "Total show depth" from a variable of type double */
inline void set_tot_snow(double val)  { setd(WR_VAR(0, 13, 13), val); }
/** Get the "Total show depth" physical value stored in the message */
inline const wreport::Var* get_tot_snow() const
{ return find(WR_VAR(0, 13, 13)); }
/** Set the value of "Visibility" from a variable of type double */
inline void set_visibility(double val)  { setd(WR_VAR(0, 20, 1), val); }
/** Get the "Visibility" physical value stored in the message */
inline const wreport::Var* get_visibility() const
{ return find(WR_VAR(0, 20, 1)); }
/** Set the value of "Present weather" from a variable of type int */
inline void set_pres_wtr(int val)  { seti(WR_VAR(0, 20, 3), val); }
/** Get the "Present weather" physical value stored in the message */
inline const wreport::Var* get_pres_wtr() const
{ return find(WR_VAR(0, 20, 3)); }
/** Set the value of "General weather indicator (TAF/METAR)" from a variable of type int */
inline void set_metar_wtr(int val)  { seti(WR_VAR(0, 20, 9), val); }
/** Get the "General weather indicator (TAF/METAR)" physical value stored in the message */
inline const wreport::Var* get_metar_wtr() const
{ return find(WR_VAR(0, 20, 9)); }
/** Set the value of "State of ground (with or without snow)" from a variable of type double */
inline void set_state_ground(double val)  { setd(WR_VAR(0, 20, 62), val); }
/** Get the "State of ground (with or without snow)" physical value stored in the message */
inline const wreport::Var* get_state_ground() const
{ return find(WR_VAR(0, 20, 62)); }
/** Set the value of "Sea/water surface temperature" from a variable of type double */
inline void set_water_temp(double val)  { setd(WR_VAR(0, 22, 43), val); }
/** Get the "Sea/water surface temperature" physical value stored in the message */
inline const wreport::Var* get_water_temp() const
{ return find(WR_VAR(0, 22, 43)); }
/** Set the value of "Past weather (1 - 6h)" from a variable of type int */
inline void set_past_wtr1_6h(int val)  { seti(WR_VAR(0, 20, 4), val); }
/** Get the "Past weather (1 - 6h)" physical value stored in the message */
inline const wreport::Var* get_past_wtr1_6h() const
{ return find(WR_VAR(0, 20, 4)); }
/** Set the value of "Past weather (2 - 6h)" from a variable of type int */
inline void set_past_wtr2_6h(int val)  { seti(WR_VAR(0, 20, 5), val); }
/** Get the "Past weather (2 - 6h)" physical value stored in the message */
inline const wreport::Var* get_past_wtr2_6h() const
{ return find(WR_VAR(0, 20, 5)); }
/** Set the value of "Characteristic of pressure tendency" from a variable of type double */
inline void set_press_tend(double val)  { setd(WR_VAR(0, 10, 63), val); }
/** Get the "Characteristic of pressure tendency" physical value stored in the message */
inline const wreport::Var* get_press_tend() const
{ return find(WR_VAR(0, 10, 63)); }
/** Set the value of "Past weather (1 - 3h)" from a variable of type int */
inline void set_past_wtr1_3h(int val)  { seti(WR_VAR(0, 20, 4), val); }
/** Get the "Past weather (1 - 3h)" physical value stored in the message */
inline const wreport::Var* get_past_wtr1_3h() const
{ return find(WR_VAR(0, 20, 4)); }
/** Set the value of "Past weather (2 - 3h)" from a variable of type int */
inline void set_past_wtr2_3h(int val)  { seti(WR_VAR(0, 20, 5), val); }
/** Get the "Past weather (2 - 3h)" physical value stored in the message */
inline const wreport::Var* get_past_wtr2_3h() const
{ return find(WR_VAR(0, 20, 5)); }
/** Set the value of "24 hour pressure change at ground level" from a variable of type double */
inline void set_press_24h(double val)  { setd(WR_VAR(0, 10, 60), val); }
/** Get the "24 hour pressure change at ground level" physical value stored in the message */
inline const wreport::Var* get_press_24h() const
{ return find(WR_VAR(0, 10, 60)); }
/** Set the value of "3 hour pressure change at ground level" from a variable of type double */
inline void set_press_3h(double val)  { setd(WR_VAR(0, 10, 60), val); }
/** Get the "3 hour pressure change at ground level" physical value stored in the message */
inline const wreport::Var* get_press_3h() const
{ return find(WR_VAR(0, 10, 60)); }
/** Set the value of "Total precipitation in the last 24 hours" from a variable of type double */
inline void set_tot_prec24(double val)  { setd(WR_VAR(0, 13, 11), val); }
/** Get the "Total precipitation in the last 24 hours" physical value stored in the message */
inline const wreport::Var* get_tot_prec24() const
{ return find(WR_VAR(0, 13, 11)); }
/** Set the value of "Total precipitation in the last 12 hours" from a variable of type double */
inline void set_tot_prec12(double val)  { setd(WR_VAR(0, 13, 11), val); }
/** Get the "Total precipitation in the last 12 hours" physical value stored in the message */
inline const wreport::Var* get_tot_prec12() const
{ return find(WR_VAR(0, 13, 11)); }
/** Set the value of "Total precipitation in the last 6 hours" from a variable of type double */
inline void set_tot_prec6(double val)  { setd(WR_VAR(0, 13, 11), val); }
/** Get the "Total precipitation in the last 6 hours" physical value stored in the message */
inline const wreport::Var* get_tot_prec6() const
{ return find(WR_VAR(0, 13, 11)); }
/** Set the value of "Total precipitation in the last 3 hours" from a variable of type double */
inline void set_tot_prec3(double val)  { setd(WR_VAR(0, 13, 11), val); }
/** Get the "Total precipitation in the last 3 hours" physical value stored in the message */
inline const wreport::Var* get_tot_prec3() const
{ return find(WR_VAR(0, 13, 11)); }
/** Set the value of "Total precipitation in the last hour" from a variable of type double */
inline void set_tot_prec1(double val)  { setd(WR_VAR(0, 13, 11), val); }
/** Get the "Total precipitation in the last hour" physical value stored in the message */
inline const wreport::Var* get_tot_prec1() const
{ return find(WR_VAR(0, 13, 11)); }
