from __future__ import absolute_import, division, print_function
import sys

rdl_database = {
  "ARG" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD"  ) : [  111.3,    2.3],
      ( "CG",  "CD",  "NE"  ) : [  112.0,    2.2],
      ( "CD",  "NE",  "CZ"  ) : [  124.2,    1.5],
      ( "NE",  "CZ",  "NH1" ) : [  120.0,    1.9],
      ( "NE",  "CZ",  "NH2" ) : [  120.0,    1.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   60.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   60.0,   15.0, 3],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  180.0,   15.0, 3],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   90.0,   15.0, 2],
    },
    "ttp-170" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  111.6,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.5,    1.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.5,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.8,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -175.4,    9.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.4,   13.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   66.9,    8.9, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -171.0,   17.1, 1],
      # population : 1479
    },
    "mtp180" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  111.7,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  111.6,    1.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.8,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.5,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.0,   13.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   66.4,    9.1, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -171.6,   16.5, 1],
      # population : 2444
    },
    "pmm-80" : {
      ( "N",   "CA",  "CB"  ) : [  111.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  109.7,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  115.9,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.6],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  113.5,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  112.5,    1.3],
      ( "CD",  "NE",  "CZ"  ) : [  125.1,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  120.3,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.3,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   73.6,   12.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -76.0,   11.2, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -56.8,    8.1, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -81.3,    7.4, 1],
      # population : 19
    },
    "ttp-110" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.8,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.9,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  125.4,    1.4],
      ( "NE",  "CZ",  "NH1" ) : [  121.1,    1.3],
      ( "NE",  "CZ",  "NH2" ) : [  119.5,    1.2],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.7,    8.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.2,   13.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   64.6,   10.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -113.5,    9.9, 1],
      # population : 616
    },
    "pmt-80" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  115.7,    1.2],
      ( "CA",  "C",   "O"   ) : [  121.0,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.0],
      ( "CB",  "CG",  "CD"  ) : [  113.3,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  112.0,    1.7],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.6],
      ( "NH1", "CZ",  "NH2" ) : [  119.3,    0.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [   81.2,    9.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -68.1,    7.7, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -176.9,   11.2, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -84.1,    8.3, 1],
      # population : 26
    },
    "mpt180" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.0,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.5,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  113.0,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  110.7,    2.0],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.5],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.8,    0.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -84.6,    7.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   69.3,   13.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  173.6,    9.2, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  174.4,   16.9, 1],
      # population : 241
    },
    "mtt90" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.3,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  111.5,    2.0],
      ( "CG",  "CD",  "NE"  ) : [  111.0,    2.5],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.9,    1.1],
      ( "NE",  "CZ",  "NH2" ) : [  119.5,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.7,    7.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.9,   13.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  178.9,   10.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   90.6,   15.2, 1],
      # population : 2402
    },
    "ttt-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.0,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  110.9,    2.1],
      ( "CG",  "CD",  "NE"  ) : [  111.8,    2.5],
      ( "CD",  "NE",  "CZ"  ) : [  124.8,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.8,    9.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.9,   11.4, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -178.3,    9.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -89.6,   12.4, 1],
      # population : 1340
    },
    "mpp-170" : {
      ( "N",   "CA",  "CB"  ) : [  111.3,    1.0],
      ( "N",   "CA",  "C"   ) : [  110.0,    3.1],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.6],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  111.6,    1.3],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.7],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -78.9,   12.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   81.3,   17.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   65.3,    7.3, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -167.1,   17.2, 1],
      # population : 61
    },
    "mtm110" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.7,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.1,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.8],
      ( "CB",  "CG",  "CD"  ) : [  112.4,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  112.1,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  125.3,    1.5],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.5,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.2,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -176.9,    9.7, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -68.9,   10.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  112.8,   10.5, 1],
      # population : 765
    },
    "ptm160" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.7,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  111.6,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  124.7,    1.4],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    1.3],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.5,    8.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -179.1,   15.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -67.1,    9.9, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  165.3,   25.7, 1],
      # population : 496
    },
    "tpm-80" : {
      ( "N",   "CA",  "CB"  ) : [  109.9,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.9,    1.5],
      ( "CA",  "CB",  "CG"  ) : [  115.2,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    1.1],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    1.2],
      ( "CG",  "CD",  "NE"  ) : [  113.6,    2.2],
      ( "CD",  "NE",  "CZ"  ) : [  125.3,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  120.0,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.3,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.6,    5.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   78.0,    8.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -80.8,   10.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -79.6,    9.3, 1],
      # population : 19
    },
    "tpp80" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.8,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  113.0,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  112.6,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.8],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.8,   10.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   65.2,   10.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   59.8,    9.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   84.2,    9.2, 1],
      # population : 358
    },
    "tpt-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  111.1,    2.5],
      ( "CD",  "NE",  "CZ"  ) : [  124.8,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  179.3,    8.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   67.1,   10.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -179.6,    8.9, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -89.4,   12.1, 1],
      # population : 349
    },
    "ttt90" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  111.3,    2.1],
      ( "CG",  "CD",  "NE"  ) : [  111.6,    2.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.7,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.2,    9.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  176.1,   10.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  176.4,    9.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   86.8,   10.7, 1],
      # population : 1019
    },
    "ttt180" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  111.3,    2.2],
      ( "CG",  "CD",  "NE"  ) : [  110.6,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.3,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  120.0,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.2,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  176.5,   11.2, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  178.6,   11.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  179.2,   18.8, 1],
      # population : 2294
    },
    "ptt90" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.8,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  111.0,    2.0],
      ( "CG",  "CD",  "NE"  ) : [  111.9,    2.4],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    0.9],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.0,    7.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  178.8,   12.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  176.7,    8.7, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   87.7,    9.7, 1],
      # population : 797
    },
    "ptp-170" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  111.3,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  111.4,    1.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.6,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.8],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   67.3,    7.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -175.6,   12.3, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   68.2,    9.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -172.5,   16.1, 1],
      # population : 378
    },
    "mpt90" : {
      ( "N",   "CA",  "CB"  ) : [  111.3,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.6],
      ( "CB",  "CA",  "C"   ) : [  109.3,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.1,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    0.9],
      ( "NE",  "CZ",  "NH1" ) : [  121.1,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.4,    0.7],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -76.1,   13.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   84.7,   13.9, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  170.3,   10.0, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   93.4,   11.0, 1],
      # population : 48
    },
    "ppp80" : {
      ( "N",   "CA",  "CB"  ) : [  111.9,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  116.1,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.6],
      ( "CB",  "CA",  "C"   ) : [  111.0,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  113.9,    0.8],
      ( "CG",  "CD",  "NE"  ) : [  112.5,    1.1],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    0.3],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    0.7],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.6],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [   62.2,    5.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   86.6,    7.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   57.2,    3.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   79.7,    8.5, 1],
      # population : 10
    },
    "pmm150" : {
      ( "N",   "CA",  "CB"  ) : [  112.1,    1.0],
      ( "N",   "CA",  "C"   ) : [  109.0,    1.0],
      ( "CA",  "CB",  "CG"  ) : [  116.2,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.3,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.0],
      ( "CB",  "CG",  "CD"  ) : [  112.4,    1.2],
      ( "CG",  "CD",  "NE"  ) : [  111.6,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  125.3,    2.5],
      ( "NE",  "CZ",  "NH1" ) : [  121.1,    1.7],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.2,    1.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [   75.6,    3.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -75.4,    5.6, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -65.0,    6.3, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  152.1,   15.4, 1],
      # population : 12
    },
    "ttm110" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.6,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  125.3,    1.3],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.5,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -175.3,    9.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  178.6,    9.4, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -64.3,   10.9, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  112.8,    9.7, 1],
      # population : 707
    },
    "ptp90" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  111.8,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  112.2,    2.2],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.2,    9.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  178.8,   11.4, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   64.1,    8.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   88.0,   11.2, 1],
      # population : 219
    },
    "ptt-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.7,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.0,    2.0],
      ( "CG",  "CD",  "NE"  ) : [  111.7,    2.7],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    1.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   66.3,    7.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -175.1,   12.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -176.5,    9.2, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -87.1,   11.8, 1],
      # population : 701
    },
    "mtp85" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.3,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  112.3,    2.0],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.3,    8.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.8,   11.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   64.7,    9.7, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   87.7,   11.0, 1],
      # population : 1815
    },
    "mmm160" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.5,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.8,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.6,    1.3],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -61.8,    9.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -66.1,   13.6, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -64.2,   10.1, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  163.2,   24.1, 1],
      # population : 936
    },
    "ptp-110" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.2],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  111.8,    1.5],
      ( "CG",  "CD",  "NE"  ) : [  111.7,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  125.6,    1.4],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    1.4],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    1.6],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [   67.6,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -179.7,   11.9, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   64.7,    9.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -108.4,    9.9, 1],
      # population : 76
    },
    "pmt100" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    0.4],
      ( "N",   "CA",  "C"   ) : [  110.2,    1.4],
      ( "CA",  "CB",  "CG"  ) : [  115.8,    0.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.3],
      ( "CB",  "CA",  "C"   ) : [  110.8,    0.5],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    0.6],
      ( "CG",  "CD",  "NE"  ) : [  111.2,    0.9],
      ( "CD",  "NE",  "CZ"  ) : [  125.1,    0.1],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    0.3],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.3],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [   70.2,    3.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -90.5,    9.2, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -174.2,    5.0, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   97.8,    1.8, 1],
      # population : 4
    },
    "mmm-85" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.7,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.8,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  112.4,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -63.5,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -67.6,   10.9, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -60.8,    9.3, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -86.3,   10.0, 1],
      # population : 992
    },
    "mmt90" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.5,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  111.5,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.9,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.5,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -60.7,    8.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -68.4,   12.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  179.4,   10.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   90.0,   12.9, 1],
      # population : 556
    },
    "tmm-80" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.0],
      ( "N",   "CA",  "C"   ) : [  109.7,    1.7],
      ( "CA",  "CB",  "CG"  ) : [  115.3,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.1,    1.0],
      ( "CB",  "CG",  "CD"  ) : [  113.7,    2.3],
      ( "CG",  "CD",  "NE"  ) : [  112.6,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.9,    1.1],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.3,    9.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -86.4,    8.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -56.4,   10.7, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -82.1,    8.5, 1],
      # population : 71
    },
    "mmp80" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    0.9],
      ( "N",   "CA",  "C"   ) : [  111.4,    1.8],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.0],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  113.4,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  113.5,    2.2],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  120.0,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -62.5,    6.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -75.1,   12.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   74.4,   11.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   77.9,    6.7, 1],
      # population : 162
    },
    "mpp80" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  109.6,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  115.5,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.1],
      ( "CB",  "CA",  "C"   ) : [  109.2,    2.0],
      ( "CB",  "CG",  "CD"  ) : [  113.5,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  113.1,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -76.7,   12.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   81.7,   12.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   58.2,    7.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   84.4,   10.2, 1],
      # population : 52
    },
    "ppt170" : {
      ( "N",   "CA",  "CB"  ) : [  111.6,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  116.2,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.3,    1.0],
      ( "CB",  "CA",  "C"   ) : [  111.9,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.5],
      ( "CG",  "CD",  "NE"  ) : [  111.4,    1.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.2,    1.3],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    1.1],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   59.1,   10.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   87.2,   12.3, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  173.6,   12.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  173.2,   17.3, 1],
      # population : 57
    },
    "tmt170" : {
      ( "N",   "CA",  "CB"  ) : [  110.0,    1.2],
      ( "N",   "CA",  "C"   ) : [  108.5,    3.2],
      ( "CA",  "CB",  "CG"  ) : [  115.0,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  110.7,    1.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.5,    0.9],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.1],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.8],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -173.9,   12.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -91.3,   12.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -173.6,    9.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -171.0,   17.7, 1],
      # population : 102
    },
    "tpt170" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  110.9,    1.8],
      ( "CD",  "NE",  "CZ"  ) : [  124.5,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.8,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.8,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   66.3,   10.4, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  178.0,   11.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  171.3,   19.2, 1],
      # population : 814
    },
    "mtm180" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  113.3,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.6,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.4,    1.5],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.8,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.4,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.0,   12.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -67.4,    8.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  172.9,   15.2, 1],
      # population : 2345
    },
    "tpm170" : {
      ( "N",   "CA",  "CB"  ) : [  109.9,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.1,    1.5],
      ( "CA",  "CB",  "CG"  ) : [  115.7,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    2.2],
      ( "CG",  "CD",  "NE"  ) : [  111.9,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  124.7,    2.3],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  178.3,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   70.5,   10.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -85.5,   12.7, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  171.7,   18.9, 1],
      # population : 107
    },
    "tpt90" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  111.9,    2.2],
      ( "CD",  "NE",  "CZ"  ) : [  124.8,    0.9],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  178.9,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   65.7,    7.7, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  178.6,   10.0, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   86.3,   10.3, 1],
      # population : 644
    },
    "ptt180" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  111.1,    2.0],
      ( "CG",  "CD",  "NE"  ) : [  110.7,    2.0],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.9,    0.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.4,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.5,   10.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -179.8,   10.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  179.1,   17.5, 1],
      # population : 795
    },
    "ttp80" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.5],
      ( "CG",  "CD",  "NE"  ) : [  112.5,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.8],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.4,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.6,   13.6, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   63.0,   10.0, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   82.9,    9.6, 1],
      # population : 1860
    },
    "mmt-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.8,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  120.9,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -63.8,    6.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -69.0,    8.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -175.2,    7.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -91.0,   11.2, 1],
      # population : 1392
    },
    "mtp-110" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  113.3,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  111.7,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  125.2,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    1.1],
      ( "NE",  "CZ",  "NH2" ) : [  119.5,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.1,    8.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.1,   10.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   66.4,   11.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -109.6,    9.6, 1],
      # population : 471
    },
    "ttm-80" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  112.4,    2.0],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.3],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.1,    9.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.3,    9.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -64.8,   10.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -84.5,    9.8, 1],
      # population : 1462
    },
    "mpt-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.0],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    2.3],
      ( "CG",  "CD",  "NE"  ) : [  111.5,    2.5],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    1.1],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -78.8,   13.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   74.7,   16.2, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  177.7,    9.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -87.8,   13.2, 1],
      # population : 84
    },
    "ptm-80" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  111.9,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  112.3,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    1.4],
      ( "NE",  "CZ",  "NH1" ) : [  120.7,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.9,    1.5],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.4,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -178.4,   14.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -66.1,   10.3, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -84.5,   10.8, 1],
      # population : 212
    },
    "ttm170" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  111.5,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  111.3,    1.7],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.3,   10.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.0,   12.4, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -67.8,   10.0, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  171.2,   17.6, 1],
      # population : 1289
    },
    "ppp-140" : {
      ( "N",   "CA",  "CB"  ) : [  111.2,    1.3],
      ( "N",   "CA",  "C"   ) : [  113.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  115.2,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.5],
      ( "CB",  "CA",  "C"   ) : [  112.0,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.5],
      ( "CG",  "CD",  "NE"  ) : [  113.8,    2.3],
      ( "CD",  "NE",  "CZ"  ) : [  125.9,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  120.1,    1.4],
      ( "NH1", "CZ",  "NH2" ) : [  118.9,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   58.7,    3.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   91.6,    4.6, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   62.4,   10.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -143.4,   12.6, 1],
      # population : 4
    },
    "mmp-170" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  115.5,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.0],
      ( "CB",  "CA",  "C"   ) : [  109.4,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.8,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.5,    1.6],
      ( "CD",  "NE",  "CZ"  ) : [  124.8,    1.3],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    1.2],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -64.1,    7.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -65.6,   14.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   85.7,    9.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -167.0,   20.1, 1],
      # population : 118
    },
    "tmt90" : {
      ( "N",   "CA",  "CB"  ) : [  109.9,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.4,    1.5],
      ( "CA",  "CB",  "CG"  ) : [  115.2,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    2.3],
      ( "CG",  "CD",  "NE"  ) : [  111.4,    2.8],
      ( "CD",  "NE",  "CZ"  ) : [  125.1,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.9,    1.8],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.4],
      ( "NH1", "CZ",  "NH2" ) : [  119.4,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.4,    9.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -93.6,    8.9, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -177.9,   11.1, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   87.0,   12.2, 1],
      # population : 24
    },
    "ppt-90" : {
      ( "N",   "CA",  "CB"  ) : [  111.6,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.6,    3.1],
      ( "CA",  "CB",  "CG"  ) : [  115.8,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.2,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  113.0,    1.3],
      ( "CG",  "CD",  "NE"  ) : [  111.7,    2.0],
      ( "CD",  "NE",  "CZ"  ) : [  125.0,    0.7],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    1.3],
      ( "NE",  "CZ",  "NH2" ) : [  119.9,    1.2],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   61.7,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   90.2,   11.1, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  177.7,    5.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -92.2,   14.4, 1],
      # population : 15
    },
    "mmt180" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.4,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.0,    1.8],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.8,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -61.9,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -68.4,   12.9, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -177.0,   11.4, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -176.3,   17.5, 1],
      # population : 1176
    },
    "pmt170" : {
      ( "N",   "CA",  "CB"  ) : [  111.8,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  116.3,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.8,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    1.3],
      ( "CG",  "CD",  "NE"  ) : [  111.7,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.0],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.8],
      ( "NE",  "CZ",  "NH2" ) : [  120.0,    0.6],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   74.0,   11.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -79.0,   15.5, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -169.4,   10.0, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -169.5,   15.5, 1],
      # population : 40
    },
    "mtt-85" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  111.4,    2.0],
      ( "CG",  "CD",  "NE"  ) : [  111.4,    2.4],
      ( "CD",  "NE",  "CZ"  ) : [  124.8,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.0,    7.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -178.5,   10.7, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -176.2,    9.3, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -88.8,   11.7, 1],
      # population : 2772
    },
    "tmt-80" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.0],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.5,    1.9],
      ( "CG",  "CD",  "NE"  ) : [  111.3,    2.1],
      ( "CD",  "NE",  "CZ"  ) : [  124.7,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.4,   10.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -92.9,   11.4, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -177.8,   10.1, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -85.0,   11.5, 1],
      # population : 61
    },
    "mtm-85" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.6],
      ( "CG",  "CD",  "NE"  ) : [  112.7,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.9,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.8,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.5,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.3,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -171.7,    9.3, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -63.9,    9.5, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  -88.1,    8.9, 1],
      # population : 2772
    },
    "tmm160" : {
      ( "N",   "CA",  "CB"  ) : [  110.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.0,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.2,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    1.8],
      ( "CG",  "CD",  "NE"  ) : [  111.9,    1.9],
      ( "CD",  "NE",  "CZ"  ) : [  124.6,    1.2],
      ( "NE",  "CZ",  "NH1" ) : [  120.6,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -172.1,   11.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -90.1,   11.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [  -61.3,   11.6, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  163.8,   18.5, 1],
      # population : 90
    },
    "mtt180" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  112.9,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  111.5,    2.0],
      ( "CG",  "CD",  "NE"  ) : [  110.6,    1.8],
      ( "CD",  "NE",  "CZ"  ) : [  124.4,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  120.4,    0.9],
      ( "NE",  "CZ",  "NH2" ) : [  119.6,    0.9],
      ( "NH1", "CZ",  "NH2" ) : [  119.9,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.4,    7.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.9,   11.0, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -179.1,   10.7, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [  177.1,   17.9, 1],
      # population : 4505
    },
    "ppt90" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  115.3,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.7,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    2.4],
      ( "CG",  "CD",  "NE"  ) : [  113.0,    2.9],
      ( "CD",  "NE",  "CZ"  ) : [  125.4,    1.1],
      ( "NE",  "CZ",  "NH1" ) : [  121.0,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.7,    1.0],
      ( "NH1", "CZ",  "NH2" ) : [  119.3,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.5,    5.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   99.3,    8.2, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [ -179.9,    9.9, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [   87.2,   12.4, 1],
      # population : 18
    },
    "tpp-160" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    1.7],
      ( "CG",  "CD",  "NE"  ) : [  111.9,    1.8],
      ( "CD",  "NE",  "CZ"  ) : [  124.5,    1.4],
      ( "NE",  "CZ",  "NH1" ) : [  120.5,    1.0],
      ( "NE",  "CZ",  "NH2" ) : [  119.8,    1.1],
      ( "NH1", "CZ",  "NH2" ) : [  119.7,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  178.9,    9.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   65.6,   10.8, 1],
      ( "CB",  "CG",  "CD",  "NE"  ) : [   65.3,    9.8, 1],
      ( "CG",  "CD",  "NE",  "CZ"  ) : [ -167.6,   19.8, 1],
      # population : 482
    },
  },
  "ASN" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  112.6,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "ND2" ) : [  116.4,    1.5],
      ( "CB",  "CG",  "OD1" ) : [  120.8,    2.0],
      ( "OD1", "CG",  "ND2" ) : [  122.6,    1.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "OD1" ) : [   90.0,   20.0, 2],
    },
    "p0" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.3],
      ( "N",   "CA",  "C"   ) : [  112.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.1,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.0],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.7],
      ( "CB",  "CG",  "ND2" ) : [  116.4,    0.9],
      ( "CB",  "CG",  "OD1" ) : [  121.1,    1.0],
      ( "OD1", "CG",  "ND2" ) : [  122.5,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.8,    7.8, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [    6.7,   43.3, 1],
      # population : 7385
    },
    "m110" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.2],
      ( "N",   "CA",  "C"   ) : [  112.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  112.7,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.5,    1.8],
      ( "CB",  "CG",  "ND2" ) : [  116.6,    1.1],
      ( "CB",  "CG",  "OD1" ) : [  120.7,    1.2],
      ( "OD1", "CG",  "ND2" ) : [  122.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -63.6,    9.7, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [  114.6,   28.4, 1],
      # population : 3886
    },
    "m-40" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.1],
      ( "N",   "CA",  "C"   ) : [  112.2,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  112.5,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.7],
      ( "CB",  "CG",  "ND2" ) : [  116.5,    0.8],
      ( "CB",  "CG",  "OD1" ) : [  120.8,    0.9],
      ( "OD1", "CG",  "ND2" ) : [  122.7,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -69.8,    9.1, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [  -41.7,   26.3, 1],
      # population : 25697
    },
    "t0" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  112.7,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.3],
      ( "CB",  "CG",  "ND2" ) : [  116.5,    0.8],
      ( "CB",  "CG",  "OD1" ) : [  120.9,    0.9],
      ( "OD1", "CG",  "ND2" ) : [  122.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -171.5,   10.5, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [   -1.5,   54.7, 1],
      # population : 15308
    },
    "t160" : {
      ( "N",   "CA",  "CB"  ) : [  109.2,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.3,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.4],
      ( "CB",  "CG",  "ND2" ) : [  117.0,    2.1],
      ( "CB",  "CG",  "OD1" ) : [  120.5,    2.0],
      ( "OD1", "CG",  "ND2" ) : [  122.4,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -161.3,    7.6, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [  163.6,    8.8, 1],
      # population : 56
    },
  },
  "ASP" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  112.6,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "OD1" ) : [  118.4,    2.3],
      ( "CB",  "CG",  "OD2" ) : [  118.4,    2.3],
      ( "OD1", "CG",  "OD2" ) : [  122.9,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "OD1" ) : [   90.0,   20.0, 2],
    },
    "p0" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.3],
      ( "N",   "CA",  "C"   ) : [  112.2,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.6],
      ( "CB",  "CG",  "OD1" ) : [  119.7,    1.6],
      ( "CB",  "CG",  "OD2" ) : [  118.2,    1.8],
      ( "OD1", "CG",  "OD2" ) : [  122.1,    1.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   62.9,    7.5, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [   -2.1,   31.1, 1],
      # population : 11526
    },
    "m-30" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.7,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  112.9,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.3,    1.7],
      ( "CB",  "CG",  "OD1" ) : [  119.2,    1.4],
      ( "CB",  "CG",  "OD2" ) : [  118.2,    1.7],
      ( "OD1", "CG",  "OD2" ) : [  122.6,    1.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.8,    8.2, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [  -29.2,   22.4, 1],
      # population : 36384
    },
    "t70" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  112.4,    0.8],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.3],
      ( "CB",  "CG",  "OD1" ) : [  118.5,    1.1],
      ( "CB",  "CG",  "OD2" ) : [  118.7,    1.6],
      ( "OD1", "CG",  "OD2" ) : [  122.8,    1.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.2,    9.2, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [   74.2,   19.8, 1],
      # population : 5865
    },
    "t0" : {
      ( "N",   "CA",  "CB"  ) : [  109.7,    1.5],
      ( "N",   "CA",  "C"   ) : [  108.9,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.2],
      ( "CB",  "CG",  "OD1" ) : [  119.5,    1.4],
      ( "CB",  "CG",  "OD2" ) : [  118.1,    1.7],
      ( "OD1", "CG",  "OD2" ) : [  122.4,    1.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -171.5,   10.2, 1],
      ( "CA",  "CB",  "CG",  "OD1" ) : [   -1.7,   23.7, 1],
      # population : 16717
    },
  },
  "CYS" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "SG"  ) : [  114.4,    2.3],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "N",   "CA",  "CB",  "SG"  ) : [  180.0,   15.0, 3],
    },
    "p" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.8],
      ( "CA",  "CB",  "SG"  ) : [  114.6,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.5],
      ( "N",   "CA",  "CB",  "SG"  ) : [   64.6,    9.0, 1],
      # population : 2895
    },
    "m" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.4],
      ( "CA",  "CB",  "SG"  ) : [  113.5,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.5,    1.6],
      ( "N",   "CA",  "CB",  "SG"  ) : [  -65.4,    8.2, 1],
      # population : 9132
    },
    "t" : {
      ( "N",   "CA",  "CB"  ) : [  110.0,    1.4],
      ( "N",   "CA",  "C"   ) : [  109.7,    2.4],
      ( "CA",  "CB",  "SG"  ) : [  113.7,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.3],
      ( "N",   "CA",  "CB",  "SG"  ) : [ -177.6,    8.2, 1],
      # population : 4315
    },
  },
  "GLN" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    1.7],
      ( "CG",  "CD",  "NE2" ) : [  116.4,    1.5],
      ( "CG",  "CD",  "OE1" ) : [  120.8,    2.0],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    1.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  180.0,   15.0, 3],
      ( "CB",  "CG",  "CD",  "OE1" ) : [    0.0,   30.0, 2],
    },
    "mm110" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.0,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    1.4],
      ( "CG",  "CD",  "NE2" ) : [  116.6,    0.9],
      ( "CG",  "CD",  "OE1" ) : [  120.8,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.1,    8.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -62.6,   10.8, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [  109.3,   23.9, 1],
      # population : 1114
    },
    "tp40" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.0,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    1.2],
      ( "CG",  "CD",  "NE2" ) : [  116.6,    0.8],
      ( "CG",  "CD",  "OE1" ) : [  120.8,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.8,    8.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   66.4,    8.2, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   41.1,   24.3, 1],
      # population : 3545
    },
    "mp10" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.3,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  113.4,    1.3],
      ( "CG",  "CD",  "NE2" ) : [  116.3,    0.8],
      ( "CG",  "CD",  "OE1" ) : [  121.1,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.5,    9.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   81.8,   11.5, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   17.3,   37.5, 1],
      # population : 1187
    },
    "mt0" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    1.5],
      ( "CG",  "CD",  "NE2" ) : [  116.4,    0.8],
      ( "CG",  "CD",  "OE1" ) : [  120.8,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.7,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.6,    7.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.2,   11.2, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   -3.5,   62.4, 1],
      # population : 14026
    },
    "tt0" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.6,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    1.5],
      ( "CG",  "CD",  "NE2" ) : [  116.5,    0.8],
      ( "CG",  "CD",  "OE1" ) : [  120.8,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.7,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.3,    8.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.6,   10.8, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [    2.1,   60.6, 1],
      # population : 6749
    },
    "mp-120" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.4,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  113.7,    1.5],
      ( "CG",  "CD",  "NE2" ) : [  116.6,    0.6],
      ( "CG",  "CD",  "OE1" ) : [  120.6,    1.1],
      ( "OE1", "CD",  "NE2" ) : [  122.7,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -72.4,    9.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   69.4,   10.8, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [ -119.8,   12.2, 1],
      # population : 83
    },
    "tm-30" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  113.5,    1.4],
      ( "CG",  "CD",  "NE2" ) : [  116.5,    0.7],
      ( "CG",  "CD",  "OE1" ) : [  120.9,    0.8],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -172.0,   10.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -85.6,   11.1, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [  -29.4,   20.4, 1],
      # population : 539
    },
    "pp30" : {
      ( "N",   "CA",  "CB"  ) : [  111.5,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  115.9,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.3,    1.0],
      ( "CB",  "CA",  "C"   ) : [  111.4,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  113.6,    1.4],
      ( "CG",  "CD",  "NE2" ) : [  116.4,    0.9],
      ( "CG",  "CD",  "OE1" ) : [  120.9,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.0,    7.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   83.8,    8.5, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   29.9,   20.9, 1],
      # population : 177
    },
    "mm-40" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.8,    1.3],
      ( "CG",  "CD",  "NE2" ) : [  116.5,    0.9],
      ( "CG",  "CD",  "OE1" ) : [  120.9,    0.9],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -63.7,    8.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -66.1,   10.5, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [  -38.6,   24.8, 1],
      # population : 5810
    },
    "pm20" : {
      ( "N",   "CA",  "CB"  ) : [  111.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  112.4,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  115.7,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.3,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  113.9,    1.4],
      ( "CG",  "CD",  "NE2" ) : [  116.3,    0.9],
      ( "CG",  "CD",  "OE1" ) : [  121.2,    1.0],
      ( "OE1", "CD",  "NE2" ) : [  122.5,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   69.5,    9.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -84.4,    9.3, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   16.7,   32.8, 1],
      # population : 482
    },
    "tp-100" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.4,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  113.0,    1.3],
      ( "CG",  "CD",  "NE2" ) : [  116.5,    0.9],
      ( "CG",  "CD",  "OE1" ) : [  120.9,    0.8],
      ( "OE1", "CD",  "NE2" ) : [  122.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.0,    8.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   62.1,    8.9, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [ -104.7,   27.4, 1],
      # population : 521
    },
    "tm130" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.4],
      ( "N",   "CA",  "C"   ) : [  108.8,    3.4],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  114.4,    2.7],
      ( "CG",  "CD",  "NE2" ) : [  117.1,    1.3],
      ( "CG",  "CD",  "OE1" ) : [  120.5,    1.2],
      ( "OE1", "CD",  "NE2" ) : [  122.4,    0.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -171.7,    9.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -75.9,   10.4, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [  127.2,   16.1, 1],
      # population : 55
    },
    "pt0" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.5,    1.4],
      ( "CG",  "CD",  "NE2" ) : [  116.5,    0.9],
      ( "CG",  "CD",  "OE1" ) : [  120.8,    1.0],
      ( "OE1", "CD",  "NE2" ) : [  122.6,    0.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.9,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.5,   11.2, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   -2.7,   74.4, 1],
      # population : 1835
    },
  },
  "GLU" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    1.7],
      ( "CG",  "CD",  "OE1" ) : [  118.4,    2.3],
      ( "CG",  "CD",  "OE2" ) : [  118.4,    2.3],
      ( "OE1", "CD",  "OE2" ) : [  122.9,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  180.0,   15.0, 3],
      ( "CB",  "CG",  "CD",  "OE1" ) : [    0.0,   30.0, 1],
    },
    "pp20" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.8,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  115.5,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.6,    1.9],
      ( "CB",  "CG",  "CD"  ) : [  114.1,    1.3],
      ( "CG",  "CD",  "OE1" ) : [  119.0,    1.4],
      ( "CG",  "CD",  "OE2" ) : [  118.4,    1.4],
      ( "OE1", "CD",  "OE2" ) : [  122.6,    1.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   61.3,    8.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   85.7,    8.0, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   19.6,   17.4, 1],
      # population : 154
    },
    "tt0" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.6,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  113.1,    1.5],
      ( "CG",  "CD",  "OE1" ) : [  119.0,    1.3],
      ( "CG",  "CD",  "OE2" ) : [  118.0,    1.3],
      ( "OE1", "CD",  "OE2" ) : [  123.1,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.7,    8.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.9,   10.3, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [    1.1,   41.3, 1],
      # population : 13252
    },
    "mm-30" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.0,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  113.4,    1.3],
      ( "CG",  "CD",  "OE1" ) : [  119.2,    1.3],
      ( "CG",  "CD",  "OE2" ) : [  118.2,    1.3],
      ( "OE1", "CD",  "OE2" ) : [  122.6,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.0,    8.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -66.5,   10.5, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [  -31.7,   26.9, 1],
      # population : 8827
    },
    "tm-30" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.0,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  113.8,    1.5],
      ( "CG",  "CD",  "OE1" ) : [  119.0,    1.3],
      ( "CG",  "CD",  "OE2" ) : [  118.2,    1.2],
      ( "OE1", "CD",  "OE2" ) : [  122.8,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -170.3,    8.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -83.4,    9.3, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [  -28.7,   17.4, 1],
      # population : 834
    },
    "tp30" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  113.8,    1.4],
      ( "CG",  "CD",  "OE1" ) : [  119.3,    1.5],
      ( "CG",  "CD",  "OE2" ) : [  118.0,    1.4],
      ( "OE1", "CD",  "OE2" ) : [  122.7,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.2,    9.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   65.0,    9.2, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   25.7,   26.1, 1],
      # population : 4517
    },
    "mt-10" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.0,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  113.3,    1.5],
      ( "CG",  "CD",  "OE1" ) : [  119.1,    1.3],
      ( "CG",  "CD",  "OE2" ) : [  117.9,    1.3],
      ( "OE1", "CD",  "OE2" ) : [  123.0,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.0,    7.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.2,   11.4, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   -6.6,   37.3, 1],
      # population : 20435
    },
    "mp0" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  112.0,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.4,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.7,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  114.2,    1.4],
      ( "CG",  "CD",  "OE1" ) : [  119.8,    1.7],
      ( "CG",  "CD",  "OE2" ) : [  117.8,    1.5],
      ( "OE1", "CD",  "OE2" ) : [  122.5,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.9,    7.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   82.5,    9.4, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [    3.4,   27.6, 1],
      # population : 3570
    },
    "pm20" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.0],
      ( "N",   "CA",  "C"   ) : [  112.9,    1.8],
      ( "CA",  "CB",  "CG"  ) : [  115.5,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.2,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  114.4,    1.4],
      ( "CG",  "CD",  "OE1" ) : [  119.8,    1.7],
      ( "CG",  "CD",  "OE2" ) : [  117.7,    1.7],
      ( "OE1", "CD",  "OE2" ) : [  122.5,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [   69.1,    8.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -84.7,    8.5, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [   15.8,   21.6, 1],
      # population : 1442
    },
    "pt0" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    1.5],
      ( "CG",  "CD",  "OE1" ) : [  118.9,    1.4],
      ( "CG",  "CD",  "OE2" ) : [  118.2,    1.3],
      ( "OE1", "CD",  "OE2" ) : [  122.9,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.4,    8.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.3,   10.1, 1],
      ( "CB",  "CG",  "CD",  "OE1" ) : [    1.3,   50.9, 1],
      # population : 2737
    },
  },
  "HIS" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.8,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD2" ) : [  131.2,    1.3],
      ( "CB",  "CG",  "ND1" ) : [  122.7,    1.5],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    1.0],
      ( "CG",  "ND1", "CE1" ) : [  109.3,    1.7],
      ( "CE1", "NE2", "CD2" ) : [  109.0,    1.0],
      ( "ND1", "CG",  "CD2" ) : [  106.1,    1.0],
      ( "ND1", "CE1", "NE2" ) : [  108.4,    1.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "ND1" ) : [  180.0,   30.0, 2],
    },
    "t-170" : {
      ( "N",   "CA",  "CB"  ) : [  109.6,    1.5],
      ( "N",   "CA",  "C"   ) : [  109.2,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.2,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.3],
      ( "CB",  "CG",  "CD2" ) : [  131.4,    1.0],
      ( "CB",  "CG",  "ND1" ) : [  122.4,    1.0],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.4],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.6],
      ( "CE1", "NE2", "CD2" ) : [  108.8,    0.5],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.6,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -173.3,    9.7, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [ -167.1,   21.6, 1],
      # population : 1307
    },
    "p90" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.4],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.2,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.8,    1.6],
      ( "CB",  "CG",  "CD2" ) : [  131.0,    0.9],
      ( "CB",  "CG",  "ND1" ) : [  122.8,    0.9],
      ( "CG",  "CD2", "NE2" ) : [  107.3,    0.5],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.6],
      ( "CE1", "NE2", "CD2" ) : [  108.8,    0.6],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   62.5,    9.7, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [   86.6,   21.8, 1],
      # population : 1454
    },
    "m90" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.7,    2.0],
      ( "CB",  "CG",  "CD2" ) : [  130.9,    0.8],
      ( "CB",  "CG",  "ND1" ) : [  122.8,    0.8],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.5],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.6],
      ( "CE1", "NE2", "CD2" ) : [  108.9,    0.5],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.7,    9.8, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [   88.5,   17.4, 1],
      # population : 3820
    },
    "t-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.5],
      ( "N",   "CA",  "C"   ) : [  109.9,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.2],
      ( "CB",  "CG",  "CD2" ) : [  130.9,    0.8],
      ( "CB",  "CG",  "ND1" ) : [  122.8,    0.7],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.4],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.7],
      ( "CE1", "NE2", "CD2" ) : [  108.8,    0.5],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -173.5,   10.4, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [  -86.8,   18.4, 1],
      # population : 3460
    },
    "m170" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.7,    1.8],
      ( "CB",  "CG",  "CD2" ) : [  131.1,    1.0],
      ( "CB",  "CG",  "ND1" ) : [  122.6,    1.0],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.5],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.7],
      ( "CE1", "NE2", "CD2" ) : [  108.8,    0.5],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.0,    8.2, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [  171.0,   21.7, 1],
      # population : 2642
    },
    "m-70" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.7,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.4,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.9],
      ( "CB",  "CG",  "CD2" ) : [  131.1,    0.8],
      ( "CB",  "CG",  "ND1" ) : [  122.6,    0.8],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.5],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.6],
      ( "CE1", "NE2", "CD2" ) : [  108.9,    0.5],
      ( "ND1", "CG",  "CD2" ) : [  106.3,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -64.4,   10.0, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [  -75.2,   19.4, 1],
      # population : 9299
    },
    "t70" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.5],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.6,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.3],
      ( "CB",  "CG",  "CD2" ) : [  131.0,    0.8],
      ( "CB",  "CG",  "ND1" ) : [  122.7,    0.8],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.5],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.6],
      ( "CE1", "NE2", "CD2" ) : [  108.9,    0.5],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.4,   10.1, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [   73.9,   17.3, 1],
      # population : 4960
    },
    "p-80" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.3],
      ( "N",   "CA",  "C"   ) : [  112.0,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.5],
      ( "CB",  "CG",  "CD2" ) : [  131.0,    0.8],
      ( "CB",  "CG",  "ND1" ) : [  122.7,    0.8],
      ( "CG",  "CD2", "NE2" ) : [  107.2,    0.5],
      ( "CG",  "ND1", "CE1" ) : [  109.2,    0.6],
      ( "CE1", "NE2", "CD2" ) : [  108.8,    0.6],
      ( "ND1", "CG",  "CD2" ) : [  106.2,    0.5],
      ( "ND1", "CE1", "NE2" ) : [  108.5,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.8,    9.9, 1],
      ( "CA",  "CB",  "CG",  "ND1" ) : [  -80.9,   16.3, 1],
      # population : 2158
    },
  },
  "ILE" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  111.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG1" ) : [  110.4,    1.7],
      ( "CA",  "CB",  "CG2" ) : [  110.5,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  111.6,    2.0],
      ( "CB",  "CG1", "CD1" ) : [  113.8,    2.1],
      ( "CG1", "CB",  "CG2" ) : [  110.7,    3.0],
      ( "N",   "CA",  "CB",  "CG1" ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG1", "CD1" ) : [  180.0,   15.0, 3],
    },
    "pp" : {
      ( "N",   "CA",  "CB"  ) : [  112.3,    1.3],
      ( "N",   "CA",  "C"   ) : [  112.1,    2.5],
      ( "CA",  "CB",  "CG1" ) : [  112.5,    1.3],
      ( "CA",  "CB",  "CG2" ) : [  109.9,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.6],
      ( "CB",  "CG1", "CD1" ) : [  115.0,    1.7],
      ( "CG1", "CB",  "CG2" ) : [  110.1,    1.9],
      ( "N",   "CA",  "CB",  "CG1" ) : [   57.7,    7.7, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [   84.0,   12.8, 1],
      # population : 249
    },
    "pt" : {
      ( "N",   "CA",  "CB"  ) : [  112.3,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.7],
      ( "CA",  "CB",  "CG1" ) : [  111.3,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  110.2,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.7],
      ( "CB",  "CG1", "CD1" ) : [  113.6,    1.2],
      ( "CG1", "CB",  "CG2" ) : [  111.4,    1.5],
      ( "N",   "CA",  "CB",  "CG1" ) : [   62.1,    6.1, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [  170.3,    7.6, 1],
      # population : 8645
    },
    "mm" : {
      ( "N",   "CA",  "CB"  ) : [  111.3,    1.1],
      ( "N",   "CA",  "C"   ) : [  109.5,    2.5],
      ( "CA",  "CB",  "CG1" ) : [  110.9,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  110.8,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.6],
      ( "CB",  "CG1", "CD1" ) : [  114.8,    1.2],
      ( "CG1", "CB",  "CG2" ) : [  111.3,    1.5],
      ( "N",   "CA",  "CB",  "CG1" ) : [  -59.0,    7.1, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [  -61.1,    7.3, 1],
      # population : 11046
    },
    "tt" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.5],
      ( "CA",  "CB",  "CG1" ) : [  110.7,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  111.4,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.6,    1.5],
      ( "CB",  "CG1", "CD1" ) : [  113.5,    1.3],
      ( "CG1", "CB",  "CG2" ) : [  111.7,    1.6],
      ( "N",   "CA",  "CB",  "CG1" ) : [ -169.6,    7.8, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [  166.6,    6.9, 1],
      # population : 4078
    },
    "tp" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.3],
      ( "CA",  "CB",  "CG1" ) : [  111.1,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  111.4,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.5,    1.5],
      ( "CB",  "CG1", "CD1" ) : [  114.2,    1.1],
      ( "CG1", "CB",  "CG2" ) : [  110.8,    1.7],
      ( "N",   "CA",  "CB",  "CG1" ) : [ -167.3,    7.8, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [   65.8,    7.3, 1],
      # population : 1847
    },
    "mt" : {
      ( "N",   "CA",  "CB"  ) : [  111.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  109.4,    2.3],
      ( "CA",  "CB",  "CG1" ) : [  110.0,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  110.6,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.6],
      ( "CB",  "CG1", "CD1" ) : [  114.0,    1.2],
      ( "CG1", "CB",  "CG2" ) : [  110.8,    1.4],
      ( "N",   "CA",  "CB",  "CG1" ) : [  -63.0,    6.4, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [  169.2,    7.4, 1],
      # population : 43618
    },
    "mp" : {
      ( "N",   "CA",  "CB"  ) : [  111.9,    1.3],
      ( "N",   "CA",  "C"   ) : [  108.4,    2.3],
      ( "CA",  "CB",  "CG1" ) : [  111.2,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  110.5,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.6],
      ( "CB",  "CG1", "CD1" ) : [  114.6,    1.7],
      ( "CG1", "CB",  "CG2" ) : [  109.3,    1.9],
      ( "N",   "CA",  "CB",  "CG1" ) : [  -62.7,   11.7, 1],
      ( "CA",  "CB",  "CG1", "CD1" ) : [   88.7,   16.6, 1],
      # population : 614
    },
  },
  "LEU" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  116.3,    3.5],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD1" ) : [  110.7,    3.0],
      ( "CB",  "CG",  "CD2" ) : [  110.7,    3.0],
      ( "CD1", "CG",  "CD2" ) : [  110.8,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  180.0,   15.0, 3],
    },
    "pp" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  119.1,    2.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.5,    1.4],
      ( "CB",  "CG",  "CD1" ) : [  111.5,    1.9],
      ( "CB",  "CG",  "CD2" ) : [  109.8,    1.7],
      ( "CD1", "CG",  "CD2" ) : [  109.7,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [   61.4,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   83.1,    9.5, 1],
      # population : 512
    },
    "pt" : {
      ( "N",   "CA",  "CB"  ) : [  111.5,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  118.7,    2.2],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.4],
      ( "CB",  "CG",  "CD1" ) : [  109.8,    1.5],
      ( "CB",  "CG",  "CD2" ) : [  111.5,    1.8],
      ( "CD1", "CG",  "CD2" ) : [  110.5,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [   72.8,    8.4, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  165.0,   10.8, 1],
      # population : 370
    },
    "mm" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  117.8,    2.6],
      ( "CA",  "C",   "O"   ) : [  120.3,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.6],
      ( "CB",  "CG",  "CD1" ) : [  110.8,    1.6],
      ( "CB",  "CG",  "CD2" ) : [  111.9,    1.7],
      ( "CD1", "CG",  "CD2" ) : [  110.7,    1.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -82.7,   10.3, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -63.8,   10.1, 1],
      # population : 474
    },
    "tt" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.3],
      ( "N",   "CA",  "C"   ) : [  109.1,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  117.3,    2.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.0,    1.2],
      ( "CB",  "CG",  "CD1" ) : [  110.1,    1.5],
      ( "CB",  "CG",  "CD2" ) : [  111.6,    1.8],
      ( "CD1", "CG",  "CD2" ) : [  110.5,    1.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -172.5,    8.5, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  153.4,   10.5, 1],
      # population : 1543
    },
    "tp" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  116.5,    2.1],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD1" ) : [  111.1,    1.6],
      ( "CB",  "CG",  "CD2" ) : [  109.8,    1.5],
      ( "CD1", "CG",  "CD2" ) : [  110.7,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.3,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   62.6,    7.0, 1],
      # population : 34062
    },
    "mt" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  115.9,    2.2],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.4],
      ( "CB",  "CG",  "CD1" ) : [  109.9,    1.5],
      ( "CB",  "CG",  "CD2" ) : [  111.0,    1.5],
      ( "CD1", "CG",  "CD2" ) : [  110.8,    1.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.8,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  174.3,    8.1, 1],
      # population : 72793
    },
    "tm" : {
      ( "N",   "CA",  "CB"  ) : [  109.9,    1.2],
      ( "N",   "CA",  "C"   ) : [  108.5,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  120.4,    2.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.2],
      ( "CB",  "CG",  "CD1" ) : [  112.2,    1.9],
      ( "CB",  "CG",  "CD2" ) : [  111.6,    1.7],
      ( "CD1", "CG",  "CD2" ) : [  111.4,    1.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -171.7,    5.9, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -75.0,    6.6, 1],
      # population : 145
    },
    "mp" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.0],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  116.6,    2.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.7,    1.6],
      ( "CB",  "CG",  "CD1" ) : [  111.6,    2.0],
      ( "CB",  "CG",  "CD2" ) : [  109.9,    1.6],
      ( "CD1", "CG",  "CD2" ) : [  110.5,    1.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -77.3,   12.6, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   71.5,   15.8, 1],
      # population : 2658
    },
  },
  "LYS" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD"  ) : [  111.3,    2.3],
      ( "CG",  "CD",  "CE"  ) : [  111.3,    2.3],
      ( "CD",  "CE",  "NZ"  ) : [  111.9,    3.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  180.0,   15.0, 3],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  180.0,   15.0, 3],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  180.0,   15.0, 3],
    },
    "tmtp" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    0.9],
      ( "N",   "CA",  "C"   ) : [  110.3,    3.1],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.4],
      ( "CB",  "CA",  "C"   ) : [  110.4,    0.7],
      ( "CB",  "CG",  "CD"  ) : [  111.9,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  111.8,    1.2],
      ( "CD",  "CE",  "NZ"  ) : [  113.3,    3.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.6,    7.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -98.0,    8.6, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -178.4,   12.4, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   65.1,    6.7, 1],
      # population : 11
    },
    "tppt" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.6,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  113.1,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.4,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  111.2,    1.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.1,    7.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   63.5,    9.4, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   69.4,    9.2, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  177.4,    9.2, 1],
      # population : 262
    },
    "mtpt" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.3,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  110.8,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -69.2,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  174.2,   11.4, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   70.5,   11.9, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  175.2,   10.3, 1],
      # population : 1302
    },
    "mtpp" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.4,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  112.7,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  112.8,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.6,    7.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.0,   10.8, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   70.5,   10.6, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   67.7,   10.8, 1],
      # population : 382
    },
    "mtpm" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.7,    2.1],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  113.0,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  113.3,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -70.3,    7.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  174.9,   16.5, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   90.7,   14.3, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -70.0,   12.3, 1],
      # population : 20
    },
    "ttmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  112.5,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  112.7,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.0,    8.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.8,   10.2, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -71.1,   12.2, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -67.1,   11.0, 1],
      # population : 196
    },
    "mmpt" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.4],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  115.2,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.7],
      ( "CB",  "CG",  "CD"  ) : [  113.4,    1.8],
      ( "CG",  "CD",  "CE"  ) : [  112.0,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  111.6,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -60.4,    7.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -70.8,   19.9, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   93.5,   14.9, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  175.5,   10.8, 1],
      # population : 31
    },
    "tptt" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.6,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  111.0,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  111.1,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.9,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   69.1,    9.1, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  175.5,   10.2, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  177.3,   12.0, 1],
      # population : 1179
    },
    "pttm" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.1],
      ( "N",   "CA",  "C"   ) : [  112.0,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  110.7,    2.0],
      ( "CG",  "CD",  "CE"  ) : [  111.9,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  112.3,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.3,    7.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.6,    9.0, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -178.8,    9.9, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -67.1,   12.0, 1],
      # population : 262
    },
    "ptpt" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.9],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  112.3,    1.7],
      ( "CD",  "CE",  "NZ"  ) : [  111.4,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.7,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  179.1,   12.2, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   72.7,   10.5, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  174.6,   11.1, 1],
      # population : 149
    },
    "mtmp" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    0.9],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.8,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.6],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  111.7,    2.0],
      ( "CG",  "CD",  "CE"  ) : [  112.7,    0.8],
      ( "CD",  "CE",  "NZ"  ) : [  113.7,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.5,    5.8, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -175.7,    8.3, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -95.8,    7.4, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   73.6,   12.3, 1],
      # population : 9
    },
    "mmtp" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.5,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.0,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  111.9,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  112.7,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -61.5,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -68.7,   11.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  179.7,   12.1, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   67.9,   13.0, 1],
      # population : 455
    },
    "mtmt" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.1,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  111.0,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.9,    6.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -173.3,    9.9, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -73.7,   11.4, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -175.4,   10.6, 1],
      # population : 1288
    },
    "mmtt" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.9,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  111.1,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  111.1,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -61.7,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -67.2,    9.8, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -176.8,   10.2, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -178.2,   11.0, 1],
      # population : 3032
    },
    "ptmt" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  112.4,    1.9],
      ( "CD",  "CE",  "NZ"  ) : [  111.5,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [   66.6,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -175.8,   11.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -71.4,   11.9, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -175.9,   10.3, 1],
      # population : 180
    },
    "mtmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.3,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  112.8,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  112.7,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -63.9,    6.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.2,   10.1, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -70.4,   10.8, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -66.0,    9.5, 1],
      # population : 413
    },
    "mmtm" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.7,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.9,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  112.0,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  112.5,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -60.1,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -65.6,   10.9, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -173.1,   11.1, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -69.0,   13.2, 1],
      # population : 701
    },
    "pttt" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  110.8,    1.8],
      ( "CG",  "CD",  "CE"  ) : [  111.0,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  111.3,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.4,    7.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -178.1,    8.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -179.3,    9.7, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -179.7,    9.7, 1],
      # population : 1348
    },
    "pmtt" : {
      ( "N",   "CA",  "CB"  ) : [  112.1,    2.1],
      ( "N",   "CA",  "C"   ) : [  110.0,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  116.4,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.6],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    2.2],
      ( "CG",  "CD",  "CE"  ) : [  111.3,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  111.7,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [   73.1,    8.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -74.2,   10.5, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -168.1,   10.6, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -174.6,   10.7, 1],
      # population : 10
    },
    "tppp" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.0,    1.8],
      ( "CA",  "CB",  "CG"  ) : [  115.2,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    0.8],
      ( "CB",  "CG",  "CD"  ) : [  113.6,    1.9],
      ( "CG",  "CD",  "CE"  ) : [  113.5,    1.8],
      ( "CD",  "CE",  "NZ"  ) : [  113.1,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.9,   12.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   62.3,   10.2, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   65.5,    8.3, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   68.0,   11.0, 1],
      # population : 35
    },
    "pttp" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.9,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  110.9,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  111.7,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  112.4,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [   67.6,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -179.1,   10.4, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  178.3,   11.4, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   66.7,   12.4, 1],
      # population : 234
    },
    "pmmt" : {
      ( "N",   "CA",  "CB"  ) : [  112.7,    0.6],
      ( "N",   "CA",  "C"   ) : [  110.8,    0.1],
      ( "CA",  "CB",  "CG"  ) : [  117.2,    0.4],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.4,    0.3],
      ( "CB",  "CG",  "CD"  ) : [  112.5,    0.2],
      ( "CG",  "CD",  "CE"  ) : [  114.6,    0.7],
      ( "CD",  "CE",  "NZ"  ) : [  113.0,    1.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [   78.1,    1.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -73.9,    0.1, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -72.8,    0.7, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  179.2,    3.5, 1],
      # population : 2
    },
    "ptpp" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.9,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.2,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.2],
      ( "CG",  "CD",  "CE"  ) : [  112.7,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  112.5,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.3,    6.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  178.4,    8.2, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   72.0,   10.2, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   66.0,    8.5, 1],
      # population : 88
    },
    "mptt" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.6,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.5,    2.0],
      ( "CG",  "CD",  "CE"  ) : [  111.2,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  110.8,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -79.8,   13.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   73.1,   17.3, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  176.3,   12.7, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  175.2,   11.8, 1],
      # population : 127
    },
    "tmtt" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    0.8],
      ( "N",   "CA",  "C"   ) : [  110.1,    1.9],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.6],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.0],
      ( "CB",  "CG",  "CD"  ) : [  111.9,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  110.9,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  110.9,    1.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -172.6,    8.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -91.1,    9.8, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -176.9,   11.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -178.5,   10.3, 1],
      # population : 76
    },
    "mptp" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    0.9],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.5,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.3,    1.1],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  112.9,    2.0],
      ( "CG",  "CD",  "CE"  ) : [  112.5,    2.8],
      ( "CD",  "CE",  "NZ"  ) : [  113.5,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -75.0,   17.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   86.5,   17.2, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  171.6,    9.5, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   65.2,   12.4, 1],
      # population : 24
    },
    "mmmt" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.7,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.0],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  113.1,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.3,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  111.1,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -62.7,    7.6, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -64.2,   10.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -70.7,    9.5, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -176.8,    9.7, 1],
      # population : 543
    },
    "tmmt" : {
      ( "N",   "CA",  "CB"  ) : [  109.9,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  115.0,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.8,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  113.5,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  112.4,    2.9],
      ( "CD",  "CE",  "NZ"  ) : [  110.8,    2.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -179.2,   10.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -93.4,   11.5, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -70.4,    9.1, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -179.6,   10.5, 1],
      # population : 31
    },
    "pptt" : {
      ( "N",   "CA",  "CB"  ) : [  111.6,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.7,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  116.1,    1.2],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.7],
      ( "CB",  "CA",  "C"   ) : [  111.3,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  110.6,    1.9],
      ( "CD",  "CE",  "NZ"  ) : [  111.3,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.2,    7.5, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   89.9,    8.3, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  175.6,   11.9, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  179.1,    7.4, 1],
      # population : 25
    },
    "tttm" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  111.0,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  111.8,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  112.3,    1.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.4,    8.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  177.8,    9.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -176.3,   10.4, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -67.2,   12.0, 1],
      # population : 1121
    },
    "mppt" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    0.9],
      ( "N",   "CA",  "C"   ) : [  108.8,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  115.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  113.7,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  112.2,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  111.3,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -82.6,    8.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   73.5,   13.5, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   69.2,    7.6, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  177.4,    5.5, 1],
      # population : 30
    },
    "mmmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    1.1],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  113.2,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  113.2,    1.9],
      ( "CD",  "CE",  "NZ"  ) : [  112.6,    2.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -61.4,    7.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -61.8,   10.2, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -66.9,   10.8, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -64.7,   10.8, 1],
      # population : 84
    },
    "tmmm" : {
      ( "N",   "CA",  "CB"  ) : [  109.5,    1.3],
      ( "N",   "CA",  "C"   ) : [  109.0,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  116.2,    2.7],
      ( "CA",  "C",   "O"   ) : [  120.3,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.2,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  114.9,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  115.0,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  113.1,    1.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.6,   11.9, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -81.6,    7.5, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -62.9,    8.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -64.4,    4.9, 1],
      # population : 8
    },
    "tttt" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  111.1,    1.8],
      ( "CG",  "CD",  "CE"  ) : [  111.0,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  111.2,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -175.5,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  176.6,    8.8, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  179.7,    9.3, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -179.9,   10.2, 1],
      # population : 4861
    },
    "tptm" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.0],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  111.9,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  111.9,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  112.5,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.9,    7.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   67.1,    9.9, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -179.4,   11.6, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -66.2,   13.1, 1],
      # population : 186
    },
    "tptp" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.2,    1.3],
      ( "CD",  "CE",  "NZ"  ) : [  112.6,    1.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -179.9,    7.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   67.4,   10.1, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  173.7,   13.6, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   66.4,   12.7, 1],
      # population : 397
    },
    "mptm" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    0.8],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    0.8],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.6],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.0],
      ( "CB",  "CG",  "CD"  ) : [  112.6,    0.7],
      ( "CG",  "CD",  "CE"  ) : [  111.7,    0.6],
      ( "CD",  "CE",  "NZ"  ) : [  113.3,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -91.6,   10.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   61.3,   11.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -173.5,    8.3, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -61.0,   12.8, 1],
      # population : 12
    },
    "ttmt" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.2,    1.7],
      ( "CD",  "CE",  "NZ"  ) : [  111.0,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.6,    9.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.3,   10.5, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -73.5,   12.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [ -175.1,   11.3, 1],
      # population : 660
    },
    "tmtm" : {
      ( "N",   "CA",  "CB"  ) : [  109.7,    0.7],
      ( "N",   "CA",  "C"   ) : [  109.9,    1.7],
      ( "CA",  "CB",  "CG"  ) : [  115.7,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.7],
      ( "CB",  "CA",  "C"   ) : [  111.0,    0.8],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.3],
      ( "CG",  "CD",  "CE"  ) : [  112.1,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  112.8,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -172.2,   11.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -90.5,    5.6, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -172.6,   12.8, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -65.0,    8.0, 1],
      # population : 18
    },
    "tttp" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.1],
      ( "CB",  "CG",  "CD"  ) : [  111.1,    1.6],
      ( "CG",  "CD",  "CE"  ) : [  111.8,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  112.3,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.7,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  175.4,    9.8, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  173.9,   11.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   65.9,   12.6, 1],
      # population : 1184
    },
    "ttpt" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.2],
      ( "CB",  "CG",  "CD"  ) : [  112.1,    1.5],
      ( "CG",  "CD",  "CE"  ) : [  112.1,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  111.1,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.3,    8.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  174.6,   12.3, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   73.0,   11.8, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  175.1,   11.3, 1],
      # population : 858
    },
    "ttpp" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.6,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  112.2,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  112.7,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  112.8,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.4,    8.7, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  174.0,   14.7, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   71.7,   11.4, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   68.2,    9.3, 1],
      # population : 217
    },
    "mttm" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.4,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  111.2,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  111.7,    1.5],
      ( "CD",  "CE",  "NZ"  ) : [  112.2,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.9,    7.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.8,   10.0, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -176.7,   10.8, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -67.4,   12.6, 1],
      # population : 1793
    },
    "ttpm" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    0.8],
      ( "N",   "CA",  "C"   ) : [  110.1,    1.3],
      ( "CA",  "CB",  "CG"  ) : [  115.4,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.8,    0.3],
      ( "CB",  "CA",  "C"   ) : [  110.3,    0.4],
      ( "CB",  "CG",  "CD"  ) : [  111.6,    1.0],
      ( "CG",  "CD",  "CE"  ) : [  113.1,    0.2],
      ( "CD",  "CE",  "NZ"  ) : [  113.9,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.6,   10.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  175.0,    6.9, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [   86.6,   18.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -84.4,    4.2, 1],
      # population : 4
    },
    "mttp" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.5],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.2,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  111.7,    1.4],
      ( "CD",  "CE",  "NZ"  ) : [  112.2,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.9,    8.3, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -179.4,   10.4, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  176.4,   11.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   66.7,   13.4, 1],
      # population : 1364
    },
    "mttt" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.3,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  111.1,    1.8],
      ( "CG",  "CD",  "CE"  ) : [  111.0,    1.6],
      ( "CD",  "CE",  "NZ"  ) : [  111.1,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.7,    7.1, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -178.8,    9.0, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [ -179.1,    9.8, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  179.5,   10.3, 1],
      # population : 8346
    },
    "ttmp" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.8,    1.5],
      ( "CA",  "CB",  "CG"  ) : [  113.0,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.5],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.6],
      ( "CB",  "CG",  "CD"  ) : [  112.7,    1.7],
      ( "CG",  "CD",  "CE"  ) : [  112.9,    0.8],
      ( "CD",  "CE",  "NZ"  ) : [  114.1,    1.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -174.1,    3.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -179.5,    7.4, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -95.5,   17.0, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [   76.7,   24.6, 1],
      # population : 9
    },
    "ptmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.4,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    1.0],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.5],
      ( "CB",  "CG",  "CD"  ) : [  112.4,    1.4],
      ( "CG",  "CD",  "CE"  ) : [  113.0,    1.1],
      ( "CD",  "CE",  "NZ"  ) : [  113.0,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   66.6,    8.4, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [ -177.9,   10.1, 1],
      ( "CB",  "CG",  "CD",  "CE"  ) : [  -69.6,    9.3, 1],
      ( "CG",  "CD",  "CE",  "NZ"  ) : [  -66.1,    6.8, 1],
      # population : 78
    },
  },
  "MET" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "SD"  ) : [  112.7,    3.0],
      ( "CG",  "SD",  "CE"  ) : [  100.9,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  180.0,   15.0, 3],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  180.0,   15.0, 3],
    },
    "pmt" : {
      ( "N",   "CA",  "CB"  ) : [  111.6,    1.3],
      ( "N",   "CA",  "C"   ) : [  109.0,    1.6],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    0.8],
      ( "CA",  "C",   "O"   ) : [  121.0,    0.6],
      ( "CB",  "CA",  "C"   ) : [  111.1,    1.1],
      ( "CB",  "CG",  "SD"  ) : [  111.7,    2.3],
      ( "CG",  "SD",  "CE"  ) : [  100.2,    1.9],
      ( "N",   "CA",  "CB",  "CG"  ) : [   71.3,    3.4, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -74.7,    3.2, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [ -162.3,    4.9, 1],
      # population : 7
    },
    "ptm" : {
      ( "N",   "CA",  "CB"  ) : [  111.2,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.5],
      ( "CB",  "CG",  "SD"  ) : [  112.7,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  100.9,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.8,    8.2, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  179.5,   10.2, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  -72.1,   11.3, 1],
      # population : 373
    },
    "ttp" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.2],
      ( "CB",  "CG",  "SD"  ) : [  112.8,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  100.7,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.8,    8.5, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  179.1,   11.5, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [   71.7,   10.5, 1],
      # population : 1225
    },
    "ttt" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.3],
      ( "CB",  "CG",  "SD"  ) : [  110.6,    2.2],
      ( "CG",  "SD",  "CE"  ) : [  100.1,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -176.7,    8.8, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  176.8,    9.6, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  176.5,   15.7, 1],
      # population : 560
    },
    "ppp" : {
      ( "N",   "CA",  "CB"  ) : [  110.9,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.8,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  115.6,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.9],
      ( "CB",  "CA",  "C"   ) : [  111.1,    1.6],
      ( "CB",  "CG",  "SD"  ) : [  114.3,    2.4],
      ( "CG",  "SD",  "CE"  ) : [  100.4,    4.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   61.3,    9.4, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   79.0,   11.1, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [   70.7,    9.9, 1],
      # population : 48
    },
    "ttm" : {
      ( "N",   "CA",  "CB"  ) : [  110.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.2],
      ( "CB",  "CG",  "SD"  ) : [  112.8,    2.2],
      ( "CG",  "SD",  "CE"  ) : [  100.8,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -175.0,    9.4, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  179.6,    8.2, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  -71.8,   13.0, 1],
      # population : 1075
    },
    "pmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.2],
      ( "N",   "CA",  "C"   ) : [  112.1,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  115.5,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.2],
      ( "CB",  "CG",  "SD"  ) : [  115.3,    2.6],
      ( "CG",  "SD",  "CE"  ) : [  101.1,    1.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   72.6,    7.8, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -68.7,    6.5, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  -68.9,    8.3, 1],
      # population : 40
    },
    "ptt" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.6,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.5],
      ( "CB",  "CG",  "SD"  ) : [  111.0,    2.4],
      ( "CG",  "SD",  "CE"  ) : [   99.8,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [   65.4,    8.2, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [ -178.1,    9.1, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  179.5,   15.5, 1],
      # population : 255
    },
    "ptp" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.5],
      ( "CB",  "CG",  "SD"  ) : [  112.9,    2.2],
      ( "CG",  "SD",  "CE"  ) : [  100.8,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   64.5,    8.5, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [ -176.4,   11.4, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [   73.2,   11.5, 1],
      # population : 404
    },
    "tmt" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.0,    2.9],
      ( "CA",  "CB",  "CG"  ) : [  114.9,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.6],
      ( "CB",  "CA",  "C"   ) : [  110.7,    1.2],
      ( "CB",  "CG",  "SD"  ) : [  112.7,    1.8],
      ( "CG",  "SD",  "CE"  ) : [  100.4,    1.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -179.1,    6.8, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -85.9,    7.7, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  173.7,   24.1, 1],
      # population : 33
    },
    "pp-130" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.0],
      ( "N",   "CA",  "C"   ) : [  110.8,    1.8],
      ( "CA",  "CB",  "CG"  ) : [  115.5,    1.2],
      ( "CA",  "C",   "O"   ) : [  121.0,    0.6],
      ( "CB",  "CA",  "C"   ) : [  111.1,    0.9],
      ( "CB",  "CG",  "SD"  ) : [  113.8,    2.0],
      ( "CG",  "SD",  "CE"  ) : [  100.8,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.9,    7.2, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   82.0,    4.9, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [ -151.1,   27.9, 1],
      # population : 25
    },
    "mtm" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.6],
      ( "CB",  "CG",  "SD"  ) : [  112.9,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  100.8,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.4,    7.9, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [ -177.8,   10.7, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  -74.0,   10.9, 1],
      # population : 1805
    },
    "tmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  109.9,    2.1],
      ( "CA",  "CB",  "CG"  ) : [  115.0,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.0,    1.2],
      ( "CB",  "CG",  "SD"  ) : [  114.0,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  100.9,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.3,    7.5, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -81.7,    6.8, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  -72.1,   10.6, 1],
      # population : 272
    },
    "mmt" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.6],
      ( "CB",  "CG",  "SD"  ) : [  112.1,    2.0],
      ( "CG",  "SD",  "CE"  ) : [  100.3,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.0,    8.7, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -63.7,    9.4, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  172.2,   18.6, 1],
      # population : 595
    },
    "mpm" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.0],
      ( "N",   "CA",  "C"   ) : [  110.7,    1.8],
      ( "CA",  "CB",  "CG"  ) : [  116.1,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.7],
      ( "CB",  "CA",  "C"   ) : [  109.1,    1.3],
      ( "CB",  "CG",  "SD"  ) : [  115.9,    2.3],
      ( "CG",  "SD",  "CE"  ) : [  100.4,    1.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -77.2,    5.1, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   64.0,    5.5, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [ -101.8,    5.0, 1],
      # population : 13
    },
    "mmp" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  114.2,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.3,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.5],
      ( "CB",  "CG",  "SD"  ) : [  113.8,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  101.2,    2.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.2,    5.2, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -61.6,    6.4, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  102.2,    9.2, 1],
      # population : 504
    },
    "mmm" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.0,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.5],
      ( "CB",  "CG",  "SD"  ) : [  113.6,    2.0],
      ( "CG",  "SD",  "CE"  ) : [  100.9,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -65.6,    8.9, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  -61.0,    8.7, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  -69.2,   10.2, 1],
      # population : 3277
    },
    "mpt" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.3,    1.4],
      ( "CB",  "CG",  "SD"  ) : [  113.3,    1.8],
      ( "CG",  "SD",  "CE"  ) : [  100.2,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -69.6,   11.8, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   74.0,   11.1, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [  167.4,   18.9, 1],
      # population : 33
    },
    "mpp" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.6,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.6],
      ( "CB",  "CG",  "SD"  ) : [  114.2,    2.2],
      ( "CG",  "SD",  "CE"  ) : [  101.1,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -76.3,   14.3, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   73.3,   12.2, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [   73.7,   11.8, 1],
      # population : 73
    },
    "mtp" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.6],
      ( "CB",  "CG",  "SD"  ) : [  112.9,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  100.8,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.6,    7.1, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  177.1,    9.2, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [   70.5,   10.1, 1],
      # population : 2786
    },
    "mtt" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.6,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.4,    1.7],
      ( "CB",  "CG",  "SD"  ) : [  110.4,    2.2],
      ( "CG",  "SD",  "CE"  ) : [  100.1,    2.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.1,    7.8, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [  179.7,    8.7, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [ -176.8,   16.6, 1],
      # population : 1506
    },
    "tpt" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  114.1,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.7],
      ( "CB",  "CA",  "C"   ) : [  110.5,    1.1],
      ( "CB",  "CG",  "SD"  ) : [  112.5,    2.1],
      ( "CG",  "SD",  "CE"  ) : [  100.4,    2.1],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -173.5,    9.2, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   65.8,    7.8, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [ -156.4,   31.2, 1],
      # population : 390
    },
    "tpp" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.7,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  114.2,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.1],
      ( "CB",  "CG",  "SD"  ) : [  113.6,    2.0],
      ( "CG",  "SD",  "CE"  ) : [  100.7,    1.7],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -175.0,    9.4, 1],
      ( "CA",  "CB",  "CG",  "SD"  ) : [   63.6,    8.0, 1],
      ( "CB",  "CG",  "SD",  "CE"  ) : [   72.4,   12.0, 1],
      # population : 1101
    },
  },
  "PHE" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.8,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD1" ) : [  120.7,    1.7],
      ( "CB",  "CG",  "CD2" ) : [  120.7,    1.7],
      ( "CG",  "CD1", "CE1" ) : [  120.7,    1.7],
      ( "CG",  "CD2", "CE2" ) : [  120.7,    1.7],
      ( "CD1", "CG",  "CD2" ) : [  118.6,    1.5],
      ( "CD1", "CE1", "CZ"  ) : [  120.0,    1.8],
      ( "CE1", "CZ",  "CE2" ) : [  120.0,    1.8],
      ( "CZ",  "CE2", "CD2" ) : [  120.0,    1.8],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   90.0,   20.0, 2],
    },
    "p90" : {
      ( "N",   "CA",  "CB"  ) : [  111.4,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.9,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.4,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.5],
      ( "CB",  "CG",  "CD1" ) : [  120.7,    0.6],
      ( "CB",  "CG",  "CD2" ) : [  120.6,    0.6],
      ( "CG",  "CD1", "CE1" ) : [  120.9,    0.6],
      ( "CG",  "CD2", "CE2" ) : [  120.9,    0.6],
      ( "CD1", "CG",  "CD2" ) : [  118.6,    0.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.9,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  119.8,    0.6],
      ( "CZ",  "CE2", "CD2" ) : [  119.9,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.6,    9.6, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -89.7,    9.4, 1],
      # population : 6173
    },
    "m-10" : {
      ( "N",   "CA",  "CB"  ) : [  111.2,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  108.9,    1.8],
      ( "CB",  "CG",  "CD1" ) : [  121.5,    1.2],
      ( "CB",  "CG",  "CD2" ) : [  119.9,    1.2],
      ( "CG",  "CD1", "CE1" ) : [  120.8,    0.6],
      ( "CG",  "CD2", "CE2" ) : [  121.0,    0.6],
      ( "CD1", "CG",  "CD2" ) : [  118.5,    0.6],
      ( "CD1", "CE1", "CZ"  ) : [  119.9,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  119.8,    0.6],
      ( "CZ",  "CE2", "CD2" ) : [  119.9,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.1,    9.4, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -14.7,   19.8, 1],
      # population : 3795
    },
    "m-80" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.5,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.8,    2.0],
      ( "CB",  "CG",  "CD1" ) : [  120.6,    0.6],
      ( "CB",  "CG",  "CD2" ) : [  120.6,    0.6],
      ( "CG",  "CD1", "CE1" ) : [  120.8,    0.6],
      ( "CG",  "CD2", "CE2" ) : [  120.8,    0.6],
      ( "CD1", "CG",  "CD2" ) : [  118.8,    0.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.9,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  119.9,    0.6],
      ( "CZ",  "CE2", "CD2" ) : [  119.9,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.8,   10.1, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -80.6,   16.8, 1],
      # population : 26111
    },
    "t80" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.5],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  113.8,    1.1],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.3],
      ( "CB",  "CG",  "CD1" ) : [  120.6,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  120.5,    0.7],
      ( "CG",  "CD1", "CE1" ) : [  120.8,    0.6],
      ( "CG",  "CD2", "CE2" ) : [  120.8,    0.6],
      ( "CD1", "CG",  "CD2" ) : [  118.8,    0.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.9,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  119.9,    0.6],
      ( "CZ",  "CE2", "CD2" ) : [  119.9,    0.6],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.3,   10.0, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   75.8,   17.4, 1],
      # population : 18909
    },
  },
  "PRO" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  103.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  112.1,    2.5],
      ( "N",   "CD",  "CG"  ) : [  103.2,    1.5],
      ( "CA",  "N",   "CD"  ) : [  112.0,    1.4],
      ( "CA",  "CB",  "CG"  ) : [  104.5,    1.9],
      ( "CA",  "C",   "O"   ) : [  119.0,    3.0],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD"  ) : [  106.1,    3.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -30.0,   20.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   38.0,   20.0, 1],
      ( "CB",  "CG",  "CD",  "N"   ) : [  -30.0,   15.0, 1],
    },
    "Cg_exo" : {
      ( "N",   "CA",  "CB"  ) : [  103.3,    0.6],
      ( "N",   "CA",  "C"   ) : [  112.7,    2.4],
      ( "N",   "CD",  "CG"  ) : [  102.7,    0.9],
      ( "CA",  "N",   "CD"  ) : [  111.7,    0.8],
      ( "CA",  "CB",  "CG"  ) : [  104.2,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.2,    1.0],
      ( "CB",  "CA",  "C"   ) : [  110.8,    1.3],
      ( "CB",  "CG",  "CD"  ) : [  104.7,    2.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -24.6,    7.0, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [   35.6,    7.4, 1],
      ( "CB",  "CG",  "CD",  "N"   ) : [  -31.8,    6.6, 1],
      # population : 29437
    },
    "Cg_endo" : {
      ( "N",   "CA",  "CB"  ) : [  103.2,    0.7],
      ( "N",   "CA",  "C"   ) : [  112.9,    2.6],
      ( "N",   "CD",  "CG"  ) : [  103.1,    0.9],
      ( "CA",  "N",   "CD"  ) : [  111.8,    0.8],
      ( "CA",  "CB",  "CG"  ) : [  104.2,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.2,    1.1],
      ( "CB",  "CA",  "C"   ) : [  110.9,    1.4],
      ( "CB",  "CG",  "CD"  ) : [  105.3,    2.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [   26.9,    7.2, 1],
      ( "CA",  "CB",  "CG",  "CD"  ) : [  -34.5,    7.5, 1],
      ( "CB",  "CG",  "CD",  "N"   ) : [   28.1,    7.7, 1],
      # population : 28580
    },
  },
  "SER" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "OG"  ) : [  111.1,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "N",   "CA",  "CB",  "OG"  ) : [  180.0,   15.0, 3],
    },
    "p" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.6,    2.5],
      ( "CA",  "CB",  "OG"  ) : [  111.0,    1.3],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.9,    1.4],
      ( "N",   "CA",  "CB",  "OG"  ) : [   65.9,    8.6, 1],
      # population : 36176
    },
    "m" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.0],
      ( "N",   "CA",  "C"   ) : [  111.5,    2.4],
      ( "CA",  "CB",  "OG"  ) : [  110.5,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.5,    1.4],
      ( "N",   "CA",  "CB",  "OG"  ) : [  -64.0,    7.7, 1],
      # population : 21102
    },
    "t" : {
      ( "N",   "CA",  "CB"  ) : [  110.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.4],
      ( "CA",  "CB",  "OG"  ) : [  110.7,    1.4],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.4],
      ( "N",   "CA",  "CB",  "OG"  ) : [  178.7,    9.0, 1],
      # population : 17121
    },
  },
  "THR" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  111.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG2" ) : [  110.5,    1.7],
      ( "CA",  "CB",  "OG1" ) : [  109.6,    1.5],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  109.1,    2.2],
      ( "OG1", "CB",  "CG2" ) : [  109.3,    2.0],
      ( "N",   "CA",  "CB",  "OG1" ) : [  180.0,   15.0, 3],
    },
    "p" : {
      ( "N",   "CA",  "CB"  ) : [  111.8,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.8],
      ( "CA",  "CB",  "CG2" ) : [  111.0,    1.0],
      ( "CA",  "CB",  "OG1" ) : [  109.5,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  108.8,    1.7],
      ( "OG1", "CB",  "CG2" ) : [  109.2,    1.7],
      ( "N",   "CA",  "CB",  "OG1" ) : [   61.5,    7.6, 1],
      # population : 35387
    },
    "m" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.2],
      ( "N",   "CA",  "C"   ) : [  110.2,    2.3],
      ( "CA",  "CB",  "CG2" ) : [  111.1,    0.9],
      ( "CA",  "CB",  "OG1" ) : [  108.9,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.0,    1.5],
      ( "OG1", "CB",  "CG2" ) : [  108.8,    1.7],
      ( "N",   "CA",  "CB",  "OG1" ) : [  -60.1,    6.1, 1],
      # population : 32805
    },
    "t" : {
      ( "N",   "CA",  "CB"  ) : [  111.3,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.3],
      ( "CA",  "CB",  "CG2" ) : [  111.7,    1.1],
      ( "CA",  "CB",  "OG1" ) : [  109.5,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.0,    1.9],
      ( "OG1", "CB",  "CG2" ) : [  109.1,    1.8],
      ( "N",   "CA",  "CB",  "OG1" ) : [ -172.7,    7.4, 1],
      # population : 5121
    },
  },
  "TRP" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.6,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD1" ) : [  126.9,    1.5],
      ( "CB",  "CG",  "CD2" ) : [  126.8,    1.4],
      ( "CG",  "CD1", "NE1" ) : [  110.2,    1.3],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    1.0],
      ( "CD1", "CG",  "CD2" ) : [  106.3,    1.6],
      ( "CD1", "NE1", "CE2" ) : [  108.9,    1.8],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    1.0],
      ( "CD2", "CE3", "CZ3" ) : [  118.6,    1.3],
      ( "CE2", "CD2", "CG"  ) : [  107.2,    1.2],
      ( "CE2", "CD2", "CE3" ) : [  118.8,    1.0],
      ( "CE3", "CZ3", "CH2" ) : [  121.1,    1.3],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    1.3],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    1.3],
      ( "NE1", "CE2", "CD2" ) : [  107.4,    1.3],
      ( "NE1", "CE2", "CZ2" ) : [  130.1,    1.5],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   90.0,   20.0, 2],
    },
    "m-90" : {
      ( "N",   "CA",  "CB"  ) : [  110.7,    1.1],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.9],
      ( "CA",  "CB",  "CG"  ) : [  113.8,    2.5],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.4,    2.0],
      ( "CB",  "CG",  "CD1" ) : [  126.7,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  126.9,    0.8],
      ( "CG",  "CD1", "NE1" ) : [  110.1,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    0.4],
      ( "CD1", "CG",  "CD2" ) : [  106.3,    0.4],
      ( "CD1", "NE1", "CE2" ) : [  108.9,    0.5],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    0.3],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.5],
      ( "CE2", "CD2", "CG"  ) : [  107.2,    0.3],
      ( "CE2", "CD2", "CE3" ) : [  118.8,    0.4],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.5],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.4],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.4],
      ( "NE1", "CE2", "CD2" ) : [  107.4,    0.3],
      ( "NE1", "CE2", "CZ2" ) : [  130.1,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.8,   12.5, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -89.3,   13.9, 1],
      # population : 934
    },
    "m100" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    2.2],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.9],
      ( "CB",  "CG",  "CD1" ) : [  127.0,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  126.6,    0.7],
      ( "CG",  "CD1", "NE1" ) : [  110.1,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    0.4],
      ( "CD1", "CG",  "CD2" ) : [  106.3,    0.4],
      ( "CD1", "NE1", "CE2" ) : [  108.9,    0.5],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    0.4],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.4],
      ( "CE2", "CD2", "CG"  ) : [  107.2,    0.3],
      ( "CE2", "CD2", "CE3" ) : [  118.9,    0.4],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.5],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.4],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.4],
      ( "NE1", "CE2", "CD2" ) : [  107.4,    0.3],
      ( "NE1", "CE2", "CZ2" ) : [  130.2,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -67.4,   10.8, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   97.3,   17.0, 1],
      # population : 6204
    },
    "p90" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.3],
      ( "N",   "CA",  "C"   ) : [  111.2,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  115.0,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.7,    1.4],
      ( "CB",  "CG",  "CD1" ) : [  127.0,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  126.8,    0.8],
      ( "CG",  "CD1", "NE1" ) : [  110.2,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    0.3],
      ( "CD1", "CG",  "CD2" ) : [  106.2,    0.4],
      ( "CD1", "NE1", "CE2" ) : [  108.9,    0.6],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    0.4],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.3],
      ( "CE2", "CD2", "CG"  ) : [  107.3,    0.3],
      ( "CE2", "CD2", "CE3" ) : [  118.8,    0.4],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.4],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.4],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.5],
      ( "NE1", "CE2", "CD2" ) : [  107.4,    0.4],
      ( "NE1", "CE2", "CZ2" ) : [  130.1,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [   60.3,   10.0, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   87.8,   14.4, 1],
      # population : 952
    },
    "t60" : {
      ( "N",   "CA",  "CB"  ) : [  110.0,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.1,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  114.3,    2.1],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.3],
      ( "CB",  "CG",  "CD1" ) : [  127.1,    0.8],
      ( "CB",  "CG",  "CD2" ) : [  126.5,    0.8],
      ( "CG",  "CD1", "NE1" ) : [  110.1,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    0.4],
      ( "CD1", "CG",  "CD2" ) : [  106.3,    0.5],
      ( "CD1", "NE1", "CE2" ) : [  108.9,    0.5],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    0.4],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.4],
      ( "CE2", "CD2", "CG"  ) : [  107.3,    0.4],
      ( "CE2", "CD2", "CE3" ) : [  118.9,    0.4],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.4],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.5],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.5],
      ( "NE1", "CE2", "CD2" ) : [  107.5,    0.4],
      ( "NE1", "CE2", "CZ2" ) : [  130.1,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.7,    9.8, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   64.8,   33.0, 1],
      # population : 3316
    },
    "t-100" : {
      ( "N",   "CA",  "CB"  ) : [  110.3,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.5,    2.4],
      ( "CA",  "CB",  "CG"  ) : [  113.6,    2.3],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.3],
      ( "CB",  "CG",  "CD1" ) : [  126.9,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  126.7,    0.7],
      ( "CG",  "CD1", "NE1" ) : [  110.1,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    0.4],
      ( "CD1", "CG",  "CD2" ) : [  106.3,    0.4],
      ( "CD1", "NE1", "CE2" ) : [  108.9,    0.5],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    0.4],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.4],
      ( "CE2", "CD2", "CG"  ) : [  107.2,    0.3],
      ( "CE2", "CD2", "CE3" ) : [  118.8,    0.3],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.5],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.4],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.5],
      ( "NE1", "CE2", "CD2" ) : [  107.4,    0.3],
      ( "NE1", "CE2", "CZ2" ) : [  130.1,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -177.1,   11.6, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [ -102.6,   15.3, 1],
      # population : 2840
    },
    "m-10" : {
      ( "N",   "CA",  "CB"  ) : [  110.8,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  114.7,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.2,    1.7],
      ( "CB",  "CG",  "CD1" ) : [  127.5,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  126.1,    0.8],
      ( "CG",  "CD1", "NE1" ) : [  110.0,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.8,    0.4],
      ( "CD1", "CG",  "CD2" ) : [  106.3,    0.4],
      ( "CD1", "NE1", "CE2" ) : [  108.8,    0.4],
      ( "CD2", "CE2", "CZ2" ) : [  122.3,    0.4],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.4],
      ( "CE2", "CD2", "CG"  ) : [  107.3,    0.4],
      ( "CE2", "CD2", "CE3" ) : [  118.9,    0.4],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.4],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.5],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.5],
      ( "NE1", "CE2", "CD2" ) : [  107.5,    0.4],
      ( "NE1", "CE2", "CZ2" ) : [  130.2,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.2,    9.1, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   -7.5,   21.7, 1],
      # population : 2152
    },
    "p-90" : {
      ( "N",   "CA",  "CB"  ) : [  111.1,    1.2],
      ( "N",   "CA",  "C"   ) : [  112.2,    2.6],
      ( "CA",  "CB",  "CG"  ) : [  115.0,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.4,    1.4],
      ( "CB",  "CG",  "CD1" ) : [  126.9,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  126.9,    0.7],
      ( "CG",  "CD1", "NE1" ) : [  110.2,    0.5],
      ( "CG",  "CD2", "CE3" ) : [  133.9,    0.4],
      ( "CD1", "CG",  "CD2" ) : [  106.2,    0.4],
      ( "CD1", "NE1", "CE2" ) : [  109.0,    0.5],
      ( "CD2", "CE2", "CZ2" ) : [  122.4,    0.3],
      ( "CD2", "CE3", "CZ3" ) : [  118.7,    0.5],
      ( "CE2", "CD2", "CG"  ) : [  107.2,    0.3],
      ( "CE2", "CD2", "CE3" ) : [  118.8,    0.4],
      ( "CE3", "CZ3", "CH2" ) : [  121.0,    0.5],
      ( "CH2", "CZ2", "CE2" ) : [  117.5,    0.4],
      ( "CZ3", "CH2", "CZ2" ) : [  121.5,    0.5],
      ( "NE1", "CE2", "CD2" ) : [  107.4,    0.3],
      ( "NE1", "CE2", "CZ2" ) : [  130.1,    0.4],
      ( "N",   "CA",  "CB",  "CG"  ) : [   61.8,    9.9, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -89.3,   13.0, 1],
      # population : 1905
    },
  },
  "TYR" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  110.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.9,    1.8],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  110.1,    1.9],
      ( "CB",  "CG",  "CD1" ) : [  120.8,    1.5],
      ( "CB",  "CG",  "CD2" ) : [  120.8,    1.5],
      ( "CG",  "CD1", "CE1" ) : [  121.2,    1.5],
      ( "CG",  "CD2", "CE2" ) : [  121.2,    1.5],
      ( "CD1", "CG",  "CD2" ) : [  118.1,    1.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.6,    1.8],
      ( "CE1", "CZ",  "CE2" ) : [  120.3,    2.0],
      ( "CE1", "CZ",  "OH"  ) : [  119.9,    3.0],
      ( "CZ",  "CE2", "CD2" ) : [  119.6,    1.8],
      ( "OH",  "CZ",  "CE2" ) : [  119.9,    3.0],
      ( "N",   "CA",  "CB",  "CG"  ) : [  180.0,   15.0, 3],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   90.0,   20.0, 2],
    },
    "p90" : {
      ( "N",   "CA",  "CB"  ) : [  111.2,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.7],
      ( "CA",  "CB",  "CG"  ) : [  114.8,    1.9],
      ( "CA",  "C",   "O"   ) : [  120.7,    0.9],
      ( "CB",  "CA",  "C"   ) : [  110.6,    1.4],
      ( "CB",  "CG",  "CD1" ) : [  121.0,    0.6],
      ( "CB",  "CG",  "CD2" ) : [  120.9,    0.6],
      ( "CG",  "CD1", "CE1" ) : [  121.2,    0.6],
      ( "CG",  "CD2", "CE2" ) : [  121.2,    0.5],
      ( "CD1", "CG",  "CD2" ) : [  118.1,    0.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.5,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  120.5,    0.7],
      ( "CE1", "CZ",  "OH"  ) : [  119.8,    1.2],
      ( "CZ",  "CE2", "CD2" ) : [  119.6,    0.6],
      ( "OH",  "CZ",  "CE2" ) : [  119.7,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [   63.6,   10.5, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -89.7,   10.1, 1],
      # population : 5345
    },
    "m-10" : {
      ( "N",   "CA",  "CB"  ) : [  111.0,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.3],
      ( "CA",  "CB",  "CG"  ) : [  115.8,    1.6],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.8],
      ( "CB",  "CA",  "C"   ) : [  109.0,    1.7],
      ( "CB",  "CG",  "CD1" ) : [  121.6,    1.0],
      ( "CB",  "CG",  "CD2" ) : [  120.4,    0.9],
      ( "CG",  "CD1", "CE1" ) : [  121.1,    0.6],
      ( "CG",  "CD2", "CE2" ) : [  121.3,    0.6],
      ( "CD1", "CG",  "CD2" ) : [  118.0,    0.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.5,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  120.4,    0.6],
      ( "CE1", "CZ",  "OH"  ) : [  120.1,    1.3],
      ( "CZ",  "CE2", "CD2" ) : [  119.7,    0.6],
      ( "OH",  "CZ",  "CE2" ) : [  119.5,    1.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -68.1,    9.9, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -14.7,   20.2, 1],
      # population : 2573
    },
    "m-80" : {
      ( "N",   "CA",  "CB"  ) : [  110.6,    1.1],
      ( "N",   "CA",  "C"   ) : [  111.4,    2.8],
      ( "CA",  "CB",  "CG"  ) : [  113.2,    2.0],
      ( "CA",  "C",   "O"   ) : [  120.4,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.6,    1.9],
      ( "CB",  "CG",  "CD1" ) : [  120.9,    0.6],
      ( "CB",  "CG",  "CD2" ) : [  120.8,    0.6],
      ( "CG",  "CD1", "CE1" ) : [  121.1,    0.9],
      ( "CG",  "CD2", "CE2" ) : [  121.1,    0.9],
      ( "CD1", "CG",  "CD2" ) : [  118.2,    0.6],
      ( "CD1", "CE1", "CZ"  ) : [  119.5,    0.9],
      ( "CE1", "CZ",  "CE2" ) : [  120.5,    0.7],
      ( "CE1", "CZ",  "OH"  ) : [  119.7,    1.2],
      ( "CZ",  "CE2", "CD2" ) : [  119.5,    0.9],
      ( "OH",  "CZ",  "CE2" ) : [  119.8,    1.2],
      ( "N",   "CA",  "CB",  "CG"  ) : [  -66.8,   10.5, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [  -80.6,   16.8, 1],
      # population : 22199
    },
    "t80" : {
      ( "N",   "CA",  "CB"  ) : [  110.2,    1.4],
      ( "N",   "CA",  "C"   ) : [  110.4,    2.2],
      ( "CA",  "CB",  "CG"  ) : [  113.7,    2.1],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.3,    1.3],
      ( "CB",  "CG",  "CD1" ) : [  120.9,    0.7],
      ( "CB",  "CG",  "CD2" ) : [  120.8,    0.6],
      ( "CG",  "CD1", "CE1" ) : [  121.1,    0.5],
      ( "CG",  "CD2", "CE2" ) : [  121.1,    0.6],
      ( "CD1", "CG",  "CD2" ) : [  118.2,    0.5],
      ( "CD1", "CE1", "CZ"  ) : [  119.5,    0.6],
      ( "CE1", "CZ",  "CE2" ) : [  120.5,    0.6],
      ( "CE1", "CZ",  "OH"  ) : [  119.7,    1.3],
      ( "CZ",  "CE2", "CD2" ) : [  119.5,    0.6],
      ( "OH",  "CZ",  "CE2" ) : [  119.7,    1.3],
      ( "N",   "CA",  "CB",  "CG"  ) : [ -178.3,   10.5, 1],
      ( "CA",  "CB",  "CG",  "CD1" ) : [   75.8,   16.7, 1],
      # population : 15992
    },
  },
  "VAL" : {
    "default" : {
      ( "N",   "CA",  "CB"  ) : [  111.5,    1.7],
      ( "N",   "CA",  "C"   ) : [  111.0,    2.8],
      ( "CA",  "CB",  "CG1" ) : [  110.4,    1.7],
      ( "CA",  "CB",  "CG2" ) : [  110.4,    1.7],
      ( "CA",  "C",   "O"   ) : [  120.8,    1.7],
      ( "CB",  "CA",  "C"   ) : [  111.4,    1.9],
      ( "CG1", "CB",  "CG2" ) : [  110.8,    2.2],
      ( "N",   "CA",  "CB",  "CG1" ) : [  180.0,   15.0, 3],
    },
    "p" : {
      ( "N",   "CA",  "CB"  ) : [  111.6,    1.3],
      ( "N",   "CA",  "C"   ) : [  110.3,    2.5],
      ( "CA",  "CB",  "CG1" ) : [  111.5,    1.1],
      ( "CA",  "CB",  "CG2" ) : [  110.8,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.6,    0.8],
      ( "CB",  "CA",  "C"   ) : [  111.4,    1.6],
      ( "CG1", "CB",  "CG2" ) : [  111.0,    1.2],
      ( "N",   "CA",  "CB",  "CG1" ) : [   64.9,    7.2, 1],
      # population : 5892
    },
    "m" : {
      ( "N",   "CA",  "CB"  ) : [  112.3,    1.2],
      ( "N",   "CA",  "C"   ) : [  111.1,    2.7],
      ( "CA",  "CB",  "CG1" ) : [  110.4,    0.9],
      ( "CA",  "CB",  "CG2" ) : [  111.3,    1.0],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.9],
      ( "CB",  "CA",  "C"   ) : [  109.8,    1.6],
      ( "CG1", "CB",  "CG2" ) : [  110.9,    1.2],
      ( "N",   "CA",  "CB",  "CG1" ) : [  -61.9,    5.7, 1],
      # population : 17054
    },
    "t" : {
      ( "N",   "CA",  "CB"  ) : [  111.3,    1.1],
      ( "N",   "CA",  "C"   ) : [  109.4,    2.4],
      ( "CA",  "CB",  "CG1" ) : [  110.7,    0.9],
      ( "CA",  "CB",  "CG2" ) : [  110.2,    0.9],
      ( "CA",  "C",   "O"   ) : [  120.5,    0.8],
      ( "CB",  "CA",  "C"   ) : [  110.2,    1.5],
      ( "CG1", "CB",  "CG2" ) : [  110.5,    1.1],
      ( "N",   "CA",  "CB",  "CG1" ) : [  175.7,    6.3, 1],
      # population : 71985
    },
  },
}

def get_rdl_database(truncate_restaints_to_gamma=False, # chi1 angles & torsions
                     apply_unrestrained_dihedrals=False,
                     verbose=False):
  from mmtbx.conformation_dependent_library.investigate_rotamer_space import results
  pdbs = []
  if apply_unrestrained_dihedrals:
    for resname, rotamers in results.items():
      rdl_d = rdl_database.get(resname, None)
      if type(rotamers)==type(1): continue
      for rotamer, action in rotamers.items():
        rdl_d_r = rdl_d.get(rotamer, None)
        if action is None: continue
        for dihedral, restraint in action.items():
          rdl_d_r[dihedral] = restraint
          if verbose: print("RDL update",resname, rotamer, dihedral, restraint)
          pdbs.append("%s_%s.pdb" % (resname.lower(), rotamer))
    #print 'tar cvf rdls.tar ' + ' '.join(pdbs)
  # needed because rotalyze does not use atom names to get rotamer name so
  # restraints have to have a periodicity of 2
  for resname, rotamers in rdl_database.items():
    if resname not in ['ASP', 'GLU', 'PHE', 'TYR']: continue
    for rotamer_name, restraints in rotamers.items():
      if rotamer_name=='default': continue
      for key, values in restraints.items():
        if len(key)!=4: continue
        values[-1]=2
  if truncate_restaints_to_gamma:
    for resname, rotamers in rdl_database.items():
      for rotamer_name, restraints in rotamers.items():
        if rotamer_name=='default': continue
        remove=[]
        for key, values in restraints.items():
          if not (key[0]=='CA' and key[1]=='CB'):
            remove.append(key)
        if remove:
          for key in remove:
            del restraints[key]
  return rdl_database

def run(args):
  assert len(args) == 0
  rdl_database = get_rdl_database()
  print('='*80)
  print(rdl_database["ARG"]["mtp85"][("N", "CA", "C")])
  for rotamer, item in rdl_database['TRP'].items():
    print(rotamer)
    #print item
    print(item[ ('CB', 'CG', 'CD1')], item[('CA', 'CB', 'CG', 'CD1')])
  for resname, rotamer, key, period in [
    #["ASP", 'p0',   ("CA", "CB", "CG", "OD1"), 36],
    ["TYR", 'm-10', ("CA", "CB", "CG", "CD1"), 2],
    ["TYR", 'm-80', ("CA", "CB", "CG", "CD1"), 1],
    ["GLN", 'mp10', ("CB", "CG", "CD", "OE1"), 1],
    ]:
    print(resname, rotamer, key, rdl_database[resname][rotamer][key])
    assert rdl_database[resname][rotamer][key][-1]==period, "%s != %s" % (
      rdl_database[resname][rotamer][key],
      period,
      )
  for res_type in sorted(rdl_database):
    print(res_type, len(rdl_database[res_type]))

if (__name__ == "__main__"):
  import sys
  run(args=sys.argv[1:])
