{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
{$ifndef CASTLE_SLIM_NODES}
    function GetCrossOrigin: String;
    procedure SetCrossOrigin(const Value: String);
{$endif not CASTLE_SLIM_NODES}
    function GetAlphaChannel: TAutoAlphaChannel;
    procedure SetAlphaChannel(const Value: TAutoAlphaChannel);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdEffects: TMFNode;
    { Internal wrapper for property @code(Effects). This wrapper API may change, we advise to access simpler @code(Effects) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEffects: TMFNode read FFdEffects;
    {  }
    procedure SetEffects(const Value: array of TEffectNode);

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdCrossOrigin: TSFString;
    { Internal wrapper for property @code(CrossOrigin). This wrapper API may change, we advise to access simpler @code(CrossOrigin) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCrossOrigin: TSFString read FFdCrossOrigin;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    { X3DOM extension, not implemented in CGE. }
    property CrossOrigin: String read GetCrossOrigin write SetCrossOrigin;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdAlphaChannel: TSFStringEnum;
    { Internal wrapper for property @code(AlphaChannel). This wrapper API may change, we advise to access simpler @code(AlphaChannel) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaChannel: TSFStringEnum read FFdAlphaChannel;
    {  }
    property AlphaChannel: TAutoAlphaChannel read GetAlphaChannel write SetAlphaChannel;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractSingleTextureNode ----------------------------------------------- }

function TAbstractSingleTextureNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TAbstractSingleTextureNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

procedure TAbstractSingleTextureNode.SetEffects(const Value: array of TEffectNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TEffectNode));
  FdEffects.Send(A);
end;

{$ifndef CASTLE_SLIM_NODES}
function TAbstractSingleTextureNode.GetCrossOrigin: String;
begin
  Result := FdCrossOrigin.Value;
end;

procedure TAbstractSingleTextureNode.SetCrossOrigin(const Value: String);
begin
  FdCrossOrigin.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
function TAbstractSingleTextureNode.GetAlphaChannel: TAutoAlphaChannel;
begin
  Result := TAutoAlphaChannel(FdAlphaChannel.EnumValue);
end;

procedure TAbstractSingleTextureNode.SetAlphaChannel(const Value: TAutoAlphaChannel);
begin
  FdAlphaChannel.SendEnumValue(Ord(Value));
end;

class function TAbstractSingleTextureNode.ClassX3DType: String;
begin
  Result := 'X3DSingleTextureNode';
end;

procedure TAbstractSingleTextureNode.CreateNode;
begin
  inherited;

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chNone;
  AddField(FFdDescription);

  FFdEffects := TMFNode.Create(Self, False, 'effects', [TEffectNode]);
   FdEffects.ChangeAlways := chEverything;
  AddField(FFdEffects);

{$ifndef CASTLE_SLIM_NODES}
  FFdCrossOrigin := TSFString.Create(Self, False, 'crossOrigin', '');
   FdCrossOrigin.ChangeAlways := chNone;
  AddField(FFdCrossOrigin);
{$endif not CASTLE_SLIM_NODES}

  FFdAlphaChannel := TSFStringEnum.Create(Self, False, 'alphaChannel', @AlphaToString, Ord(High(AlphaToString)) + 1, Ord(acAuto));
   FdAlphaChannel.ChangeAlways := chVisibleVRML1State;
  AddField(FFdAlphaChannel);
end;

{$endif read_implementation}
