{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAmbientIntensity: Single;
    procedure SetAmbientIntensity(const Value: Single);
    function GetBackAmbientIntensity: Single;
    procedure SetBackAmbientIntensity(const Value: Single);
    function GetBackDiffuseColor: TCastleColorRGB;
    procedure SetBackDiffuseColor(const Value: TCastleColorRGB);
    function GetBackEmissiveColor: TCastleColorRGB;
    procedure SetBackEmissiveColor(const Value: TCastleColorRGB);
    function GetBackShininess: Single;
    procedure SetBackShininess(const Value: Single);
    function GetBackSpecularColor: TCastleColorRGB;
    procedure SetBackSpecularColor(const Value: TCastleColorRGB);
    function GetBackTransparency: Single;
    procedure SetBackTransparency(const Value: Single);
    function GetDiffuseColor: TCastleColorRGB;
    procedure SetDiffuseColor(const Value: TCastleColorRGB);
    function GetEmissiveColor: TCastleColorRGB;
    procedure SetEmissiveColor(const Value: TCastleColorRGB);
    function GetShininess: Single;
    procedure SetShininess(const Value: Single);
    function GetSeparateBackColor: Boolean;
    procedure SetSeparateBackColor(const Value: Boolean);
    function GetSpecularColor: TCastleColorRGB;
    procedure SetSpecularColor(const Value: TCastleColorRGB);
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAmbientIntensity: TSFFloat;
    { X3D field "ambientIntensity". } { }
    public property FdAmbientIntensity: TSFFloat read FFdAmbientIntensity;
    { X3D field "ambientIntensity". } { }
    property AmbientIntensity: Single read GetAmbientIntensity write SetAmbientIntensity;

    strict private FFdBackAmbientIntensity: TSFFloat;
    { X3D field "backAmbientIntensity". } { }
    public property FdBackAmbientIntensity: TSFFloat read FFdBackAmbientIntensity;
    { X3D field "backAmbientIntensity". } { }
    property BackAmbientIntensity: Single read GetBackAmbientIntensity write SetBackAmbientIntensity;

    strict private FFdBackDiffuseColor: TSFColor;
    { X3D field "backDiffuseColor". } { }
    public property FdBackDiffuseColor: TSFColor read FFdBackDiffuseColor;
    { X3D field "backDiffuseColor". } { }
    property BackDiffuseColor: TCastleColorRGB read GetBackDiffuseColor write SetBackDiffuseColor;

    strict private FFdBackEmissiveColor: TSFColor;
    { X3D field "backEmissiveColor". } { }
    public property FdBackEmissiveColor: TSFColor read FFdBackEmissiveColor;
    { X3D field "backEmissiveColor". } { }
    property BackEmissiveColor: TCastleColorRGB read GetBackEmissiveColor write SetBackEmissiveColor;

    strict private FFdBackShininess: TSFFloat;
    { X3D field "backShininess". } { }
    public property FdBackShininess: TSFFloat read FFdBackShininess;
    { X3D field "backShininess". } { }
    property BackShininess: Single read GetBackShininess write SetBackShininess;

    strict private FFdBackSpecularColor: TSFColor;
    { X3D field "backSpecularColor". } { }
    public property FdBackSpecularColor: TSFColor read FFdBackSpecularColor;
    { X3D field "backSpecularColor". } { }
    property BackSpecularColor: TCastleColorRGB read GetBackSpecularColor write SetBackSpecularColor;

    strict private FFdBackTransparency: TSFFloat;
    { X3D field "backTransparency". } { }
    public property FdBackTransparency: TSFFloat read FFdBackTransparency;
    { X3D field "backTransparency". } { }
    property BackTransparency: Single read GetBackTransparency write SetBackTransparency;

    strict private FFdDiffuseColor: TSFColor;
    { X3D field "diffuseColor". } { }
    public property FdDiffuseColor: TSFColor read FFdDiffuseColor;
    { X3D field "diffuseColor". } { }
    property DiffuseColor: TCastleColorRGB read GetDiffuseColor write SetDiffuseColor;

    strict private FFdEmissiveColor: TSFColor;
    { X3D field "emissiveColor". } { }
    public property FdEmissiveColor: TSFColor read FFdEmissiveColor;
    { X3D field "emissiveColor". } { }
    property EmissiveColor: TCastleColorRGB read GetEmissiveColor write SetEmissiveColor;

    strict private FFdShininess: TSFFloat;
    { X3D field "shininess". } { }
    public property FdShininess: TSFFloat read FFdShininess;
    { X3D field "shininess". } { }
    property Shininess: Single read GetShininess write SetShininess;

    strict private FFdSeparateBackColor: TSFBool;
    { X3D field "separateBackColor". } { }
    public property FdSeparateBackColor: TSFBool read FFdSeparateBackColor;
    { X3D field "separateBackColor". } { }
    property SeparateBackColor: Boolean read GetSeparateBackColor write SetSeparateBackColor;

    strict private FFdSpecularColor: TSFColor;
    { X3D field "specularColor". } { }
    public property FdSpecularColor: TSFColor read FFdSpecularColor;
    { X3D field "specularColor". } { }
    property SpecularColor: TCastleColorRGB read GetSpecularColor write SetSpecularColor;

    strict private FFdTransparency: TSFFloat;
    { X3D field "transparency". } { }
    public property FdTransparency: TSFFloat read FFdTransparency;
    { X3D field "transparency". } { }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TTwoSidedMaterialNode ----------------------------------------------- }

function TTwoSidedMaterialNode.GetAmbientIntensity: Single;
begin
  Result := FdAmbientIntensity.Value;
end;

procedure TTwoSidedMaterialNode.SetAmbientIntensity(const Value: Single);
begin
  FdAmbientIntensity.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackAmbientIntensity: Single;
begin
  Result := FdBackAmbientIntensity.Value;
end;

procedure TTwoSidedMaterialNode.SetBackAmbientIntensity(const Value: Single);
begin
  FdBackAmbientIntensity.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackDiffuseColor: TCastleColorRGB;
begin
  Result := FdBackDiffuseColor.Value;
end;

procedure TTwoSidedMaterialNode.SetBackDiffuseColor(const Value: TCastleColorRGB);
begin
  FdBackDiffuseColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackEmissiveColor: TCastleColorRGB;
begin
  Result := FdBackEmissiveColor.Value;
end;

procedure TTwoSidedMaterialNode.SetBackEmissiveColor(const Value: TCastleColorRGB);
begin
  FdBackEmissiveColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackShininess: Single;
begin
  Result := FdBackShininess.Value;
end;

procedure TTwoSidedMaterialNode.SetBackShininess(const Value: Single);
begin
  FdBackShininess.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackSpecularColor: TCastleColorRGB;
begin
  Result := FdBackSpecularColor.Value;
end;

procedure TTwoSidedMaterialNode.SetBackSpecularColor(const Value: TCastleColorRGB);
begin
  FdBackSpecularColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackTransparency: Single;
begin
  Result := FdBackTransparency.Value;
end;

procedure TTwoSidedMaterialNode.SetBackTransparency(const Value: Single);
begin
  FdBackTransparency.Send(Value);
end;

function TTwoSidedMaterialNode.GetDiffuseColor: TCastleColorRGB;
begin
  Result := FdDiffuseColor.Value;
end;

procedure TTwoSidedMaterialNode.SetDiffuseColor(const Value: TCastleColorRGB);
begin
  FdDiffuseColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetEmissiveColor: TCastleColorRGB;
begin
  Result := FdEmissiveColor.Value;
end;

procedure TTwoSidedMaterialNode.SetEmissiveColor(const Value: TCastleColorRGB);
begin
  FdEmissiveColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetShininess: Single;
begin
  Result := FdShininess.Value;
end;

procedure TTwoSidedMaterialNode.SetShininess(const Value: Single);
begin
  FdShininess.Send(Value);
end;

function TTwoSidedMaterialNode.GetSeparateBackColor: Boolean;
begin
  Result := FdSeparateBackColor.Value;
end;

procedure TTwoSidedMaterialNode.SetSeparateBackColor(const Value: Boolean);
begin
  FdSeparateBackColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetSpecularColor: TCastleColorRGB;
begin
  Result := FdSpecularColor.Value;
end;

procedure TTwoSidedMaterialNode.SetSpecularColor(const Value: TCastleColorRGB);
begin
  FdSpecularColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TTwoSidedMaterialNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

class function TTwoSidedMaterialNode.ClassX3DType: String;
begin
  Result := 'TwoSidedMaterial';
end;

procedure TTwoSidedMaterialNode.CreateNode;
begin
  inherited;

  FFdAmbientIntensity := TSFFloat.Create(Self, True, 'ambientIntensity', 0.2);
   FdAmbientIntensity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientIntensity);
  { X3D specification comment: [0,1] }

  FFdBackAmbientIntensity := TSFFloat.Create(Self, True, 'backAmbientIntensity', 0.2);
   FdBackAmbientIntensity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackAmbientIntensity);
  { X3D specification comment: [0,1] }

  FFdBackDiffuseColor := TSFColor.Create(Self, True, 'backDiffuseColor', Vector3(0.8, 0.8, 0.8));
   FdBackDiffuseColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackDiffuseColor);
  { X3D specification comment: [0,1] }

  FFdBackEmissiveColor := TSFColor.Create(Self, True, 'backEmissiveColor', Vector3(0, 0, 0));
   FdBackEmissiveColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackEmissiveColor);
  { X3D specification comment: [0,1] }

  FFdBackShininess := TSFFloat.Create(Self, True, 'backShininess', 0.2);
   FdBackShininess.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackShininess);
  { X3D specification comment: [0,1] }

  FFdBackSpecularColor := TSFColor.Create(Self, True, 'backSpecularColor', Vector3(0, 0, 0));
   FdBackSpecularColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackSpecularColor);
  { X3D specification comment: [0,1] }

  FFdBackTransparency := TSFFloat.Create(Self, True, 'backTransparency', 0);
   FdBackTransparency.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackTransparency);
  { X3D specification comment: [0,1] }

  FFdDiffuseColor := TSFColor.Create(Self, True, 'diffuseColor', Vector3(0.8, 0.8, 0.8));
   FdDiffuseColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseColor);
  { X3D specification comment: [0,1] }

  FFdEmissiveColor := TSFColor.Create(Self, True, 'emissiveColor', Vector3(0, 0, 0));
   FdEmissiveColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveColor);
  { X3D specification comment: [0,1] }

  FFdShininess := TSFFloat.Create(Self, True, 'shininess', 0.2);
   FdShininess.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininess);
  { X3D specification comment: [0,1] }

  FFdSeparateBackColor := TSFBool.Create(Self, True, 'separateBackColor', false);
   FdSeparateBackColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSeparateBackColor);

  FFdSpecularColor := TSFColor.Create(Self, True, 'specularColor', Vector3(0, 0, 0));
   FdSpecularColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularColor);
  { X3D specification comment: [0,1] }

  FFdTransparency := TSFFloat.Create(Self, True, 'transparency', 0);
   FdTransparency.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransparency);
  { X3D specification comment: [0,1] }
end;

{$endif read_implementation}
