/* libmutter.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Meta", gir_namespace = "Meta", gir_version = "3.0", lower_case_cprefix = "meta_")]
namespace Meta {
	namespace Prefs {
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void add_listener (Meta.PrefsChangedFunc func);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool bell_is_audible ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void change_workspace_name (int i, string name);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.TitlebarAction get_action_double_click_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.TitlebarAction get_action_middle_click_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.TitlebarAction get_action_right_click_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_attach_modal_dialogs ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_auto_maximize ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_auto_raise ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_auto_raise_delay ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static Meta.ButtonLayout get_button_layout ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_center_new_windows ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_compositing_manager ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_cursor_size ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static unowned string get_cursor_theme ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_disable_workarounds ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_drag_threshold ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_draggable_border_width ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_dynamic_workspaces ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_edge_tiling ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_focus_change_on_pointer_rest ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.FocusMode get_focus_mode ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.FocusNewWindows get_focus_new_windows ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_force_fullscreen ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_gnome_accessibility ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_gnome_animations ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_ignore_request_hide_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static Meta.KeyBindingAction get_keybinding_action (string name);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_mouse_button_menu ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static Meta.VirtualModifier get_mouse_button_mods ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_mouse_button_resize ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_num_workspaces ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_raise_on_click ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_show_fallback_app_menu ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static unowned Pango.FontDescription get_titlebar_font ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_visual_bell ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.VisualBellType get_visual_bell_type ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static unowned string get_workspace_name (int i);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_workspaces_only_on_primary ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void init ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void override_preference_schema (string key, string schema);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void remove_listener (Meta.PrefsChangedFunc func);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void set_force_fullscreen (bool whether);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void set_ignore_request_hide_titlebar (bool whether);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void set_num_workspaces (int n_workspaces);
	}
	namespace Util {
		[CCode (cheader_filename = "meta/main.h", cname = "meta_add_verbose_topic")]
		public static void add_verbose_topic (Meta.DebugTopic topic);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_bug")]
		public static void bug (string format, ...);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_debug_spew_real")]
		public static void debug_spew_real (string format, ...);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_disable_unredirect_for_screen")]
		public static void disable_unredirect_for_screen (Meta.Screen screen);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_empty_stage_input_region")]
		public static void empty_stage_input_region (Meta.Screen screen);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_enable_unredirect_for_screen")]
		public static void enable_unredirect_for_screen (Meta.Screen screen);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_error_trap_pop")]
		public static void error_trap_pop (Meta.Display display);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_error_trap_push")]
		public static void error_trap_push (Meta.Display display);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_error_trap_push_with_return")]
		public static void error_trap_push_with_return (Meta.Display display);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_external_binding_name_for_action")]
		public static string external_binding_name_for_action (uint keybinding_action);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_fatal")]
		public static void fatal (string format, ...);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_free_gslist_and_elements")]
		public static void free_gslist_and_elements (GLib.SList<void*> list_to_deep_free);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_g_utf8_strndup")]
		public static string g_utf8_strndup (string src, size_t n);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_get_locale_direction")]
		public static Meta.LocaleDirection get_locale_direction ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_get_overlay_window")]
		public static X.Window get_overlay_window (Meta.Screen screen);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_gravity_to_string")]
		public static unowned string gravity_to_string (int gravity);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_is_debugging")]
		public static bool is_debugging ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_is_syncing")]
		public static bool is_syncing ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_is_verbose")]
		public static bool is_verbose ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_is_wayland_compositor")]
		public static bool is_wayland_compositor ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_later_add")]
		public static uint later_add (Meta.LaterType when, owned GLib.SourceFunc func);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_later_remove")]
		public static void later_remove (uint later_id);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_pop_no_msg_prefix")]
		public static void pop_no_msg_prefix ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_push_no_msg_prefix")]
		public static void push_no_msg_prefix ();
		[CCode (cheader_filename = "meta/main.h", cname = "meta_rect")]
		public static Meta.Rectangle? rect (int x, int y, int width, int height);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_remove_verbose_topic")]
		public static void remove_verbose_topic (Meta.DebugTopic topic);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_set_stage_input_region")]
		public static void set_stage_input_region (Meta.Screen screen, X.XserverRegion region);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_show_dialog")]
		public static GLib.Pid show_dialog (string type, string message, string? timeout = null, string? display = null, string? ok_text = null, string? cancel_text = null, string? icon_name = null, int transient_for = 0, GLib.SList<string>? columns = null, GLib.SList<string>? entries = null);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_topic_real")]
		public static void topic_real (Meta.DebugTopic topic, string format, ...);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_unsigned_long_equal")]
		public static int unsigned_long_equal (void* v1, void* v2);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_unsigned_long_hash")]
		public static uint unsigned_long_hash (void* v);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_verbose_real")]
		public static void verbose_real (string format, ...);
		[CCode (cheader_filename = "meta/main.h", cname = "meta_warning")]
		public static void warning (string format, ...);
	}
	[CCode (cheader_filename = "meta/main.h", type_id = "meta_backend_get_type ()")]
	public abstract class Backend : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Backend ();
		[CCode (cheader_filename = "meta/meta-backend.h", cname = "meta_get_backend")]
		public static unowned Meta.Backend get_backend ();
		public unowned Clutter.Actor get_stage ();
		public void lock_layout_group (uint idx);
		public void set_keymap (string layouts, string variants, string options);
		public signal void keymap_changed ();
		public signal void keymap_layout_group_changed (uint object);
		public signal void last_device_changed (int object);
	}
	[CCode (cheader_filename = "meta/meta-background.h", type_id = "meta_background_get_type ()")]
	public class Background : GLib.Object {
		[CCode (has_construct_function = false)]
		public Background (Meta.Screen screen);
		public static void refresh_all ();
		public void set_blend (GLib.File file1, GLib.File file2, double blend_factor, GDesktop.BackgroundStyle style);
		public void set_color (Clutter.Color color);
		public void set_file (GLib.File file, GDesktop.BackgroundStyle style);
		public void set_gradient (GDesktop.BackgroundShading shading_direction, Clutter.Color color, Clutter.Color second_color);
		[NoAccessorMethod]
		public Meta.Screen meta_screen { owned get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "meta/meta-background-actor.h", type_id = "meta_background_actor_get_type ()")]
	public class BackgroundActor : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public BackgroundActor (Meta.Screen screen, int monitor);
		public void set_background (Meta.Background background);
		public void set_vignette (bool enabled, double brightness, double sharpness);
		[NoAccessorMethod]
		public Meta.Background background { owned get; set; }
		[NoAccessorMethod]
		public double brightness { get; set; }
		[NoAccessorMethod]
		public Meta.Screen meta_screen { owned get; construct; }
		[NoAccessorMethod]
		public int monitor { get; construct; }
		[NoAccessorMethod]
		public bool vignette { get; set; }
		[NoAccessorMethod]
		public double vignette_sharpness { get; set; }
	}
	[CCode (cheader_filename = "meta/meta-background-group.h", type_id = "meta_background_group_get_type ()")]
	public class BackgroundGroup : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public BackgroundGroup ();
	}
	[CCode (cheader_filename = "meta/meta-background-image.h", type_id = "meta_background_image_get_type ()")]
	public class BackgroundImage : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BackgroundImage ();
		public bool get_success ();
		public unowned Cogl.Texture get_texture ();
		public bool is_loaded ();
		public signal void loaded ();
	}
	[CCode (cheader_filename = "meta/meta-background-image.h", type_id = "meta_background_image_cache_get_type ()")]
	public class BackgroundImageCache : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BackgroundImageCache ();
		public static unowned Meta.BackgroundImageCache get_default ();
		public Meta.BackgroundImage load (GLib.File file);
		public void purge (GLib.File file);
	}
	[CCode (cheader_filename = "meta/barrier.h", type_id = "meta_barrier_get_type ()")]
	public class Barrier : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Barrier ();
		public void destroy ();
		public bool is_active ();
		public void release (Meta.BarrierEvent event);
		[NoAccessorMethod]
		public Meta.BarrierDirection directions { get; construct; }
		[NoAccessorMethod]
		public Meta.Display display { owned get; construct; }
		[NoAccessorMethod]
		public int x1 { get; construct; }
		[NoAccessorMethod]
		public int x2 { get; construct; }
		[NoAccessorMethod]
		public int y1 { get; construct; }
		[NoAccessorMethod]
		public int y2 { get; construct; }
		public signal void hit (Meta.BarrierEvent event);
		public signal void left (Meta.BarrierEvent event);
	}
	[CCode (cheader_filename = "meta/main.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "meta_barrier_event_get_type ()")]
	[Compact]
	public class BarrierEvent {
		public int dt;
		public double dx;
		public double dy;
		public int event_id;
		public bool grabbed;
		public bool released;
		public uint32 time;
		public double x;
		public double y;
	}
	[CCode (cheader_filename = "meta/compositor.h")]
	[Compact]
	public class Compositor {
		public void add_window (Meta.Window window);
		public void destroy ();
		public bool filter_keybinding (Meta.KeyBinding binding);
		public void flash_screen (Meta.Screen screen);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_focus_stage_window")]
		public static void focus_stage_window (Meta.Screen screen, uint32 timestamp);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_feedback_group_for_screen")]
		public static unowned Clutter.Actor get_feedback_group_for_screen (Meta.Screen screen);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_stage_for_screen")]
		public static unowned Clutter.Actor? get_stage_for_screen (Meta.Screen screen);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_top_window_group_for_screen")]
		public static unowned Clutter.Actor? get_top_window_group_for_screen (Meta.Screen screen);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_window_actors")]
		public static unowned GLib.List<weak Meta.WindowActor>? get_window_actors (Meta.Screen screen);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_window_group_for_screen")]
		public static unowned Clutter.Actor? get_window_group_for_screen (Meta.Screen screen);
		public void hide_tile_preview ();
		public void hide_window (Meta.Window window, Meta.CompEffect effect);
		public void manage ();
		[CCode (cheader_filename = "meta/main.h")]
		public static unowned Meta.Compositor @new (Meta.Display display);
		public void queue_frame_drawn (Meta.Window window, bool no_delay_frame);
		public void remove_window (Meta.Window window);
		public void show_tile_preview (Meta.Window window, Meta.Rectangle tile_rect, int tile_monitor_number);
		public void show_window (Meta.Window window, Meta.CompEffect effect);
		public void show_window_menu (Meta.Window window, Meta.WindowMenuType menu, int x, int y);
		public void show_window_menu_for_rect (Meta.Window window, Meta.WindowMenuType menu, Meta.Rectangle rect);
		public void size_change_window (Meta.Window window, Meta.SizeChange which_change, Meta.Rectangle old_frame_rect, Meta.Rectangle old_buffer_rect);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_stage_is_focused")]
		public static bool stage_is_focused (Meta.Screen screen);
		public void switch_workspace (Meta.Workspace from, Meta.Workspace to, Meta.MotionDirection direction);
		public void sync_stack (GLib.List<Meta.WindowActor> stack);
		public void sync_updates_frozen (Meta.Window window);
		public void sync_window_geometry (Meta.Window window, bool did_placement);
		public void unmanage ();
		public void window_opacity_changed (Meta.Window window);
		public void window_shape_changed (Meta.Window window);
		public void window_surface_changed (Meta.Window window);
	}
	[CCode (cheader_filename = "meta/meta-cursor-tracker.h", type_id = "meta_cursor_tracker_get_type ()")]
	public class CursorTracker : GLib.Object {
		[CCode (has_construct_function = false)]
		protected CursorTracker ();
		public static unowned Meta.CursorTracker get_for_screen (Meta.Screen screen);
		public void get_hot (out int x, out int y);
		public void get_pointer (int x, int y, Clutter.ModifierType mods);
		public unowned Cogl.Texture get_sprite ();
		public void set_pointer_visible (bool visible);
		public signal void cursor_changed ();
	}
	[CCode (cheader_filename = "meta/display.h", type_id = "meta_display_get_type ()")]
	public class Display : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Display ();
		public void add_ignored_crossing_serial (ulong serial);
		public uint add_keybinding (string name, GLib.Settings settings, Meta.KeyBindingFlags flags, owned Meta.KeyHandlerFunc handler);
		public bool begin_grab_op (Meta.Screen screen, Meta.Window window, Meta.GrabOp op, bool pointer_already_grabbed, bool frame_action, int button, ulong modmask, uint32 timestamp, int root_x, int root_y);
		public void clear_mouse_mode ();
		public void end_grab_op (uint32 timestamp);
		public void focus_the_no_focus_window (Meta.Screen screen, uint32 timestamp);
		public void freeze_keyboard (uint32 timestamp);
		public unowned Meta.Compositor get_compositor ();
		public uint32 get_current_time ();
		public uint32 get_current_time_roundtrip ();
		public int get_damage_event_base ();
		public unowned Meta.Window get_focus_window ();
		public Meta.GrabOp get_grab_op ();
		public uint get_keybinding_action (uint keycode, ulong mask);
		public uint32 get_last_user_time ();
		public int get_shape_event_base ();
		public unowned Meta.Window get_tab_current (Meta.TabList type, Meta.Workspace workspace);
		public GLib.List<weak Meta.Window> get_tab_list (Meta.TabList type, Meta.Workspace? workspace);
		public unowned Meta.Window get_tab_next (Meta.TabList type, Meta.Workspace workspace, Meta.Window? window, bool backward);
		public unowned X.Display get_xdisplay ();
		public int get_xinput_opcode ();
		public uint grab_accelerator (string accelerator);
		public bool has_shape ();
		public bool is_pointer_emulating_sequence (Clutter.EventSequence? sequence);
		public unowned Meta.Group lookup_group (X.Window group_leader);
		public bool remove_keybinding (string name);
		public void set_input_focus_window (Meta.Window window, bool focus_frame, uint32 timestamp);
		public GLib.SList<weak Meta.Window> sort_windows_by_stacking (GLib.SList<Meta.Window> windows);
		public bool supports_extended_barriers ();
		public void unfreeze_keyboard (uint32 timestamp);
		public bool ungrab_accelerator (uint action_id);
		public void ungrab_keyboard (uint32 timestamp);
		public void unmanage_screen (Meta.Screen screen, uint32 timestamp);
		public bool xserver_time_is_before (uint32 time1, uint32 time2);
		public bool xwindow_is_a_no_focus_window (X.Window xwindow);
		public signal void accelerator_activated (uint object, uint p0, uint p1);
		public signal void grab_op_begin (Meta.Screen object, Meta.Window p0, Meta.GrabOp p1);
		public signal void grab_op_end (Meta.Screen object, Meta.Window p0, Meta.GrabOp p1);
		public signal bool modifiers_accelerator_activated ();
		public signal void overlay_key ();
		public signal bool restart ();
		public signal bool show_resize_popup (bool object, Meta.Rectangle p0, int p1, int p2);
		public signal bool show_restart_message (string? message);
		public signal void window_created (Meta.Window object);
		public signal void window_demands_attention (Meta.Window object);
		public signal void window_marked_urgent (Meta.Window object);
	}
	[CCode (cheader_filename = "meta/common.h")]
	[Compact]
	public class Frame {
	}
	[CCode (cheader_filename = "meta/group.h")]
	[Compact]
	public class Group {
		public int get_size ();
		public unowned string get_startup_id ();
		public GLib.SList<weak Meta.Window> list_windows ();
		public bool property_notify (X.Event event);
		public void update_layers ();
	}
	[CCode (cheader_filename = "meta/meta-idle-monitor.h", type_id = "meta_idle_monitor_get_type ()")]
	public class IdleMonitor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected IdleMonitor ();
		public uint add_idle_watch (uint64 interval_msec, owned Meta.IdleMonitorWatchFunc? callback);
		public uint add_user_active_watch (owned Meta.IdleMonitorWatchFunc? callback);
		public static unowned Meta.IdleMonitor get_core ();
		public static unowned Meta.IdleMonitor get_for_device (int device_id);
		public int64 get_idletime ();
		public void remove_watch (uint id);
		[NoAccessorMethod]
		public int device_id { get; construct; }
	}
	[CCode (cheader_filename = "meta/keybindings.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "meta_key_binding_get_type ()")]
	[Compact]
	public class KeyBinding {
		public uint get_mask ();
		public Meta.VirtualModifier get_modifiers ();
		public unowned string get_name ();
		public bool is_builtin ();
		public bool is_reversed ();
		[CCode (cheader_filename = "meta/keybindings.h", cname = "meta_keybindings_set_custom_handler")]
		public static bool set_custom_handler (string name, owned Meta.KeyHandlerFunc? handler);
	}
	[CCode (cheader_filename = "meta/meta-monitor-manager.h", type_id = "meta_monitor_manager_get_type ()")]
	public abstract class MonitorManager : GLib.DBusInterfaceSkeleton, GLib.DBusInterface {
		[CCode (has_construct_function = false)]
		protected MonitorManager ();
		public static unowned Meta.MonitorManager @get ();
		public int get_monitor_for_output (uint id);
		public signal void confirm_display_change ();
	}
	[CCode (cheader_filename = "meta/meta-plugin.h", type_id = "meta_plugin_get_type ()")]
	public abstract class Plugin : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Plugin ();
		public bool begin_modal (Meta.ModalOptions options, uint32 timestamp);
		public void complete_display_change (bool ok);
		[NoWrapper]
		public virtual void confirm_display_change ();
		[NoWrapper]
		public virtual void destroy (Meta.WindowActor actor);
		public void destroy_completed (Meta.WindowActor actor);
		public void end_modal (uint32 timestamp);
		public unowned Meta.PluginInfo? get_info ();
		public unowned Meta.Screen get_screen ();
		[NoWrapper]
		public virtual void hide_tile_preview ();
		[NoWrapper]
		public virtual bool keybinding_filter (Meta.KeyBinding binding);
		[NoWrapper]
		public virtual void kill_switch_workspace ();
		[NoWrapper]
		public virtual void kill_window_effects (Meta.WindowActor actor);
		public static void manager_set_plugin_type (GLib.Type gtype);
		[NoWrapper]
		public virtual void map (Meta.WindowActor actor);
		public void map_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual void minimize (Meta.WindowActor actor);
		public void minimize_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual unowned Meta.PluginInfo? plugin_info ();
		[NoWrapper]
		public virtual void show_tile_preview (Meta.Window window, Meta.Rectangle tile_rect, int tile_monitor_number);
		[NoWrapper]
		public virtual void show_window_menu (Meta.Window window, Meta.WindowMenuType menu, int x, int y);
		[NoWrapper]
		public virtual void show_window_menu_for_rect (Meta.Window window, Meta.WindowMenuType menu, Meta.Rectangle rect);
		[NoWrapper]
		public virtual void size_change (Meta.WindowActor actor, Meta.SizeChange which_change, Meta.Rectangle old_frame_rect, Meta.Rectangle old_buffer_rect);
		public void size_change_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual void start ();
		[NoWrapper]
		public virtual void switch_workspace (int from, int to, Meta.MotionDirection direction);
		public void switch_workspace_completed ();
 		[NoWrapper]
		public virtual void unminimize (Meta.WindowActor actor);
		public void unminimize_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual bool xevent_filter (X.Event event);
	}
	[CCode (cheader_filename = "meta/screen.h", type_id = "meta_screen_get_type ()")]
	public class Screen : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Screen ();
		public unowned Meta.Workspace? append_new_workspace (bool activate, uint32 timestamp);
		public void focus_default_window (uint32 timestamp);
		public unowned Meta.Workspace get_active_workspace ();
		public int get_active_workspace_index ();
		public int get_current_monitor ();
		public int get_current_monitor_for_pos (int x, int y);
		public unowned Meta.Display get_display ();
		public Meta.Rectangle get_monitor_geometry (int monitor);
		public bool get_monitor_in_fullscreen (int monitor);
		public int get_monitor_index_for_rect (Meta.Rectangle rect);
		public int get_monitor_neighbor_index (int which_monitor, Meta.ScreenDirection dir);
		public int get_n_monitors ();
		public int get_n_workspaces ();
		public int get_primary_monitor ();
		public int get_screen_number ();
		public void get_size (out int width, out int height);
		public unowned Meta.Workspace? get_workspace_by_index (int index);
		public unowned GLib.List<Meta.Workspace> get_workspaces ();
		public X.Window get_xroot ();
		public void override_workspace_layout (Meta.ScreenCorner starting_corner, bool vertical_layout, int n_rows, int n_columns);
		public void remove_workspace (Meta.Workspace workspace, uint32 timestamp);
		public void set_cm_selection ();
		public void set_cursor (Meta.Cursor cursor);
		public int n_workspaces { get; }
		public signal void in_fullscreen_changed ();
		public signal void monitors_changed ();
		public signal void restacked ();
		public signal void startup_sequence_changed (void* object);
		public signal void window_entered_monitor (int object, Meta.Window p0);
		public signal void window_left_monitor (int object, Meta.Window p0);
		public signal void workareas_changed ();
		public signal void workspace_added (int object);
		public signal void workspace_removed (int object);
		public signal void workspace_switched (int object, int p0, Meta.MotionDirection p1);
	}
	[CCode (cheader_filename = "meta/meta-shadow-factory.h", ref_function = "meta_shadow_ref", type_id = "meta_shadow_get_type ()", unref_function = "meta_shadow_unref")]
	[Compact]
	public class Shadow {
		public void get_bounds (int window_x, int window_y, int window_width, int window_height, Cairo.RectangleInt bounds);
		public void paint (int window_x, int window_y, int window_width, int window_height, uint8 opacity, Cairo.Region? clip, bool clip_strictly);
		public Meta.Shadow @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "meta/meta-shadow-factory.h", type_id = "meta_shadow_factory_get_type ()")]
	public class ShadowFactory : GLib.Object {
		[CCode (has_construct_function = false)]
		public ShadowFactory ();
		public static unowned Meta.ShadowFactory get_default ();
		public Meta.ShadowParams get_params (string class_name, bool focused);
		public Meta.Shadow get_shadow (Meta.WindowShape shape, int width, int height, string class_name, bool focused);
		public void set_params (string class_name, bool focused, Meta.ShadowParams @params);
		public signal void changed ();
	}
	[CCode (cheader_filename = "meta/meta-shaped-texture.h", type_id = "meta_shaped_texture_get_type ()")]
	public class ShapedTexture : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		protected ShapedTexture ();
		public Cairo.Surface get_image (Cairo.RectangleInt clip);
		public unowned Cogl.Texture get_texture ();
		public void set_create_mipmaps (bool create_mipmaps);
		public void set_mask_texture (Cogl.Texture mask_texture);
		public void set_opaque_region (owned Cairo.Region opaque_region);
		public bool update_area (int x, int y, int width, int height);
		public signal void size_changed ();
	}
	[CCode (cheader_filename = "meta/theme.h")]
	[Compact]
	public class Theme {
		public void free ();
		[CCode (cheader_filename = "meta/main.h")]
		public static unowned Meta.Theme get_default ();
		[CCode (cheader_filename = "meta/main.h")]
		public static unowned Meta.Theme @new ();
	}
	[CCode (cheader_filename = "meta/window.h", type_id = "meta_window_get_type ()")]
	public abstract class Window : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Window ();
		public void activate (uint32 current_time);
		public void activate_with_workspace (uint32 current_time, Meta.Workspace workspace);
		public bool allows_move ();
		public bool allows_resize ();
		public void begin_grab_op (Meta.GrabOp op, bool frame_action, uint32 timestamp);
		public bool can_close ();
		public bool can_maximize ();
		public bool can_minimize ();
		public bool can_shade ();
		public void change_workspace (Meta.Workspace workspace);
		public void change_workspace_by_index (int space_index, bool append);
		public void check_alive (uint32 timestamp);
		public Meta.Rectangle client_rect_to_frame_rect (Meta.Rectangle client_rect);
		public void compute_group ();
		public void @delete (uint32 timestamp);
		public unowned Meta.Window find_root_ancestor ();
		public void focus (uint32 timestamp);
		public void foreach_ancestor (Meta.WindowForeachFunc func);
		public void foreach_transient (Meta.WindowForeachFunc func);
		public Meta.Rectangle frame_rect_to_client_rect (Meta.Rectangle frame_rect);
		[CCode (array_length_pos = 0.1, array_length_type = "gsize")]
		public int[] get_all_monitors ();
		public Meta.Rectangle get_buffer_rect ();
		public unowned string get_client_machine ();
		public unowned GLib.Object get_compositor_private ();
		public unowned string get_description ();
		public unowned Meta.Display get_display ();
		public unowned Meta.Frame get_frame ();
		public unowned Cairo.Region? get_frame_bounds ();
		public Meta.Rectangle get_frame_rect ();
		public Meta.FrameType get_frame_type ();
		public unowned Meta.Group get_group ();
		public unowned string get_gtk_app_menu_object_path ();
		public unowned string get_gtk_application_id ();
		public unowned string get_gtk_application_object_path ();
		public unowned string get_gtk_menubar_object_path ();
		public unowned string get_gtk_theme_variant ();
		public unowned string get_gtk_unique_bus_name ();
		public unowned string get_gtk_window_object_path ();
		public bool get_icon_geometry (out Meta.Rectangle rect);
		public Meta.StackLayer get_layer ();
		public Meta.MaximizeFlags get_maximized ();
		public int get_monitor ();
		public unowned string get_mutter_hints ();
		public int get_pid ();
		public unowned string get_role ();
		public unowned Meta.Screen get_screen ();
		public uint get_stable_sequence ();
		public unowned string get_startup_id ();
		public unowned Meta.Window? get_tile_match ();
		public unowned string get_title ();
		public unowned Meta.Window get_transient_for ();
		public uint32 get_user_time ();
		public Meta.WindowType get_window_type ();
		public unowned string get_wm_class ();
		public unowned string get_wm_class_instance ();
		public Meta.Rectangle get_work_area_all_monitors ();
		public Meta.Rectangle get_work_area_current_monitor ();
		public Meta.Rectangle get_work_area_for_monitor (int which_monitor);
		public unowned Meta.Workspace get_workspace ();
		public X.Window get_xwindow ();
		public void group_leader_changed ();
		public bool has_focus ();
		public bool is_above ();
		public bool is_always_on_all_workspaces ();
		public bool is_ancestor_of_transient (Meta.Window transient);
		public bool is_attached_dialog ();
		public bool is_fullscreen ();
		public bool is_hidden ();
		public bool is_monitor_sized ();
		public bool is_on_all_workspaces ();
		public bool is_on_primary_monitor ();
		public bool is_override_redirect ();
		public bool is_remote ();
		public bool is_screen_sized ();
		public bool is_shaded ();
		public bool is_skip_taskbar ();
		public void kill ();
		public bool located_on_workspace (Meta.Workspace workspace);
		public void lower ();
		public void make_above ();
		public void make_fullscreen ();
		public void maximize (Meta.MaximizeFlags directions);
		public void minimize ();
		public void move_frame (bool user_op, int root_x_nw, int root_y_nw);
		public void move_resize_frame (bool user_op, int root_x_nw, int root_y_nw, int w, int h);
		public void move_to_monitor (int monitor);
		public void raise ();
		public bool requested_bypass_compositor ();
		public bool requested_dont_bypass_compositor ();
		public void set_compositor_private (GLib.Object priv);
		public void set_demands_attention ();
		public void set_icon_geometry (Meta.Rectangle? rect);
		public void shade (uint32 timestamp);
		public void shove_titlebar_onscreen ();
		public bool showing_on_its_workspace ();
		public void shutdown_group ();
		public void stick ();
		public bool titlebar_is_onscreen ();
		public void unmake_above ();
		public void unmake_fullscreen ();
		public void unmaximize (Meta.MaximizeFlags directions);
		public void unminimize ();
		public void unset_demands_attention ();
		public void unshade (uint32 timestamp);
		public void unstick ();
		[NoAccessorMethod]
		public bool above { get; }
		[NoAccessorMethod]
		public bool appears_focused { get; }
		[NoAccessorMethod]
		public bool decorated { get; }
		[NoAccessorMethod]
		public bool demands_attention { get; }
		[NoAccessorMethod]
		public bool fullscreen { get; }
		public string gtk_app_menu_object_path { get; }
		public string gtk_application_id { get; }
		public string gtk_application_object_path { get; }
		public string gtk_menubar_object_path { get; }
		public string gtk_unique_bus_name { get; }
		public string gtk_window_object_path { get; }
		[NoAccessorMethod]
		public Cairo.Surface icon { owned get; }
		[NoAccessorMethod]
		public bool maximized_horizontally { get; }
		[NoAccessorMethod]
		public bool maximized_vertically { get; }
		[NoAccessorMethod]
		public Cairo.Surface mini_icon { owned get; }
		[NoAccessorMethod]
		public bool minimized { get; }
		public string mutter_hints { get; }
		[NoAccessorMethod]
		public bool on_all_workspaces { get; }
		[NoAccessorMethod]
		public bool resizeable { get; }
		[NoAccessorMethod]
		public bool skip_taskbar { get; }
		public string title { get; }
		[NoAccessorMethod]
		public bool urgent { get; }
		public uint user_time { get; }
		public Meta.WindowType window_type { get; }
		public string wm_class { get; }
		[CCode (cname = "focus")]
		public signal void focused ();
		public signal void position_changed ();
		public signal void raised ();
		public signal void size_changed ();
		public signal void unmanaged ();
		public signal void workspace_changed ();
	}
	[CCode (cheader_filename = "meta/meta-window-actor.h", type_id = "meta_window_actor_get_type ()")]
	public class WindowActor : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		protected WindowActor ();
		public unowned Meta.Window get_meta_window ();
		public unowned Clutter.Actor get_texture ();
		public X.Window get_x_window ();
		public bool is_destroyed ();
		[NoAccessorMethod]
		public string shadow_class { owned get; set; }
		[NoAccessorMethod]
		public Meta.ShadowMode shadow_mode { get; set; }
		public signal void first_frame ();
	}
	[CCode (cheader_filename = "meta/meta_window_shape.h", ref_function = "meta_window_shape_ref", type_id = "meta_window_shape_get_type ()", unref_function = "meta_window_shape_unref")]
	[Compact]
	public class WindowShape {
		[CCode (has_construct_function = false)]
		public WindowShape (Cairo.Region region);
		public bool equal (Meta.WindowShape shape_b);
		public void get_borders (int border_top, int border_right, int border_bottom, int border_left);
		public uint hash ();
		public Meta.WindowShape @ref ();
		public Cairo.Region to_region (int center_width, int center_height);
		public void unref ();
	}
	[CCode (cheader_filename = "meta/workspace.h", type_id = "meta_workspace_get_type ()")]
	public class Workspace : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Workspace ();
		public void activate (uint32 timestamp);
		public void activate_with_focus (Meta.Window focus_this, uint32 timestamp);
		public unowned Meta.Workspace get_neighbor (Meta.MotionDirection direction);
		public unowned Meta.Screen get_screen ();
		public Meta.Rectangle get_work_area_all_monitors ();
		public Meta.Rectangle get_work_area_for_monitor (int which_monitor);
		public int index ();
		public GLib.List<weak Meta.Window> list_windows ();
		public void set_builtin_struts (GLib.SList<Meta.Strut> struts);
		[NoAccessorMethod]
		public uint n_windows { get; }
		[NoAccessorMethod]
		public uint workspace_index { get; }
		public signal void window_added (Meta.Window object);
		public signal void window_removed (Meta.Window object);
	}
	[CCode (cheader_filename = "meta/common.h", has_type_id = false)]
	public struct ButtonLayout {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Meta.ButtonFunction[] left_buttons;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak bool[] left_buttons_has_spacer;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Meta.ButtonFunction[] right_buttons;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak bool[] right_buttons_has_spacer;
	}
	[CCode (cheader_filename = "meta/boxes.h", has_type_id = false)]
	public struct Edge {
		public Meta.Rectangle rect;
		public Meta.Side side_type;
		public Meta.EdgeType edge_type;
	}
	[CCode (cheader_filename = "meta/common.h", has_type_id = false)]
	public struct FrameBorders {
		public Gtk.Border visible;
		public Gtk.Border invisible;
		public Gtk.Border total;
		public void clear ();
	}
	[CCode (cheader_filename = "meta/meta-plugin.h", has_type_id = false)]
	public struct PluginInfo {
		public weak string name;
		public weak string version;
		public weak string author;
		public weak string license;
		public weak string description;
	}
	[CCode (cheader_filename = "meta/meta-plugin.h", has_type_id = false)]
	public struct PluginVersion {
		public uint version_major;
		public uint version_minor;
		public uint version_micro;
		public uint version_api;
	}
	[CCode (cheader_filename = "meta/boxes.h", has_type_id = false)]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
		public int area ();
		public bool contains_rect (Meta.Rectangle inner_rect);
		public bool could_fit_rect (Meta.Rectangle inner_rect);
		public bool equal (Meta.Rectangle src2);
		public bool horiz_overlap (Meta.Rectangle rect2);
		public bool intersect (Meta.Rectangle src2, out Meta.Rectangle dest);
		public bool overlap (Meta.Rectangle rect2);
		public Meta.Rectangle union (Meta.Rectangle rect2);
		public bool vert_overlap (Meta.Rectangle rect2);
	}
	[CCode (cheader_filename = "meta/meta-shadow-factory.h", has_type_id = false)]
	public struct ShadowParams {
		public int radius;
		public int top_fade;
		public int x_offset;
		public int y_offset;
		public uint8 opacity;
	}
	[CCode (cheader_filename = "meta/boxes.h", has_type_id = false)]
	public struct Strut {
		public Meta.Rectangle rect;
		public Meta.Side side;
	}
	[CCode (cheader_filename = "meta/barrier.h", cprefix = "META_BARRIER_DIRECTION_", type_id = "meta_barrier_direction_get_type ()")]
	[Flags]
	public enum BarrierDirection {
		POSITIVE_X,
		POSITIVE_Y,
		NEGATIVE_X,
		NEGATIVE_Y
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_BUTTON_FUNCTION_", type_id = "meta_button_function_get_type ()")]
	public enum ButtonFunction {
		MENU,
		MINIMIZE,
		MAXIMIZE,
		CLOSE,
		SHADE,
		ABOVE,
		STICK,
		UNSHADE,
		UNABOVE,
		UNSTICK,
		APPMENU,
		LAST
	}
	[CCode (cheader_filename = "meta/compositor.h", cprefix = "META_COMP_EFFECT_", type_id = "meta_comp_effect_get_type ()")]
	public enum CompEffect {
		CREATE,
		UNMINIMIZE,
		DESTROY,
		MINIMIZE,
		NONE
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_CURSOR_", type_id = "meta_cursor_get_type ()")]
	public enum Cursor {
		NONE,
		DEFAULT,
		NORTH_RESIZE,
		SOUTH_RESIZE,
		WEST_RESIZE,
		EAST_RESIZE,
		SE_RESIZE,
		SW_RESIZE,
		NE_RESIZE,
		NW_RESIZE,
		MOVE_OR_RESIZE_WINDOW,
		BUSY,
		DND_IN_DRAG,
		DND_MOVE,
		DND_COPY,
		DND_UNSUPPORTED_TARGET,
		POINTING_HAND,
		CROSSHAIR,
		IBEAM,
		LAST
	}
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_DEBUG_", type_id = "meta_debug_topic_get_type ()")]
	[Flags]
	public enum DebugTopic {
		VERBOSE,
		FOCUS,
		WORKAREA,
		STACK,
		THEMES,
		SM,
		EVENTS,
		WINDOW_STATE,
		WINDOW_OPS,
		GEOMETRY,
		PLACEMENT,
		PING,
		XINERAMA,
		KEYBINDINGS,
		SYNC,
		ERRORS,
		STARTUP,
		PREFS,
		GROUPS,
		RESIZING,
		SHAPES,
		COMPOSITOR,
		EDGE_RESISTANCE,
		DBUS
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_DIRECTION_", type_id = "meta_direction_get_type ()")]
	[Flags]
	public enum Direction {
		LEFT,
		RIGHT,
		TOP,
		BOTTOM,
		UP,
		DOWN,
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "meta/boxes.h", cprefix = "META_EDGE_", type_id = "meta_edge_type_get_type ()")]
	public enum EdgeType {
		WINDOW,
		MONITOR,
		SCREEN
	}
	[CCode (cheader_filename = "meta/main.h", cprefix = "META_EXIT_", type_id = "meta_exit_code_get_type ()")]
	public enum ExitCode {
		SUCCESS,
		ERROR
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_FRAME_", type_id = "meta_frame_flags_get_type ()")]
	[Flags]
	public enum FrameFlags {
		ALLOWS_DELETE,
		ALLOWS_MENU,
		ALLOWS_APPMENU,
		ALLOWS_MINIMIZE,
		ALLOWS_MAXIMIZE,
		ALLOWS_VERTICAL_RESIZE,
		ALLOWS_HORIZONTAL_RESIZE,
		HAS_FOCUS,
		SHADED,
		STUCK,
		MAXIMIZED,
		ALLOWS_SHADE,
		ALLOWS_MOVE,
		FULLSCREEN,
		IS_FLASHING,
		ABOVE,
		TILED_LEFT,
		TILED_RIGHT
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_FRAME_TYPE_", type_id = "meta_frame_type_get_type ()")]
	public enum FrameType {
		NORMAL,
		DIALOG,
		MODAL_DIALOG,
		UTILITY,
		MENU,
		BORDER,
		ATTACHED,
		LAST;
		[CCode (cheader_filename = "meta/main.h")]
		public static unowned string to_string (Meta.FrameType type);
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_GRAB_OP_", type_id = "meta_grab_op_get_type ()")]
	public enum GrabOp {
		NONE,
		COMPOSITOR,
		WAYLAND_POPUP,
		WINDOW_BASE,
		FRAME_BUTTON,
		MOVING,
		RESIZING_NW,
		RESIZING_N,
		RESIZING_NE,
		RESIZING_E,
		RESIZING_SW,
		RESIZING_S,
		RESIZING_SE,
		RESIZING_W,
		KEYBOARD_MOVING,
		KEYBOARD_RESIZING_UNKNOWN,
		KEYBOARD_RESIZING_NW,
		KEYBOARD_RESIZING_N,
		KEYBOARD_RESIZING_NE,
		KEYBOARD_RESIZING_E,
		KEYBOARD_RESIZING_SW,
		KEYBOARD_RESIZING_S,
		KEYBOARD_RESIZING_SE,
		KEYBOARD_RESIZING_W
	}
	[CCode (cheader_filename = "meta/prefs.h", cprefix = "META_KEYBINDING_ACTION_", type_id = "meta_key_binding_action_get_type ()")]
	public enum KeyBindingAction {
		NONE,
		WORKSPACE_1,
		WORKSPACE_2,
		WORKSPACE_3,
		WORKSPACE_4,
		WORKSPACE_5,
		WORKSPACE_6,
		WORKSPACE_7,
		WORKSPACE_8,
		WORKSPACE_9,
		WORKSPACE_10,
		WORKSPACE_11,
		WORKSPACE_12,
		WORKSPACE_LEFT,
		WORKSPACE_RIGHT,
		WORKSPACE_UP,
		WORKSPACE_DOWN,
		WORKSPACE_LAST,
		SWITCH_APPLICATIONS,
		SWITCH_APPLICATIONS_BACKWARD,
		SWITCH_GROUP,
		SWITCH_GROUP_BACKWARD,
		SWITCH_WINDOWS,
		SWITCH_WINDOWS_BACKWARD,
		SWITCH_PANELS,
		SWITCH_PANELS_BACKWARD,
		CYCLE_GROUP,
		CYCLE_GROUP_BACKWARD,
		CYCLE_WINDOWS,
		CYCLE_WINDOWS_BACKWARD,
		CYCLE_PANELS,
		CYCLE_PANELS_BACKWARD,
		SHOW_DESKTOP,
		PANEL_MAIN_MENU,
		PANEL_RUN_DIALOG,
		TOGGLE_RECORDING,
		SET_SPEW_MARK,
		ACTIVATE_WINDOW_MENU,
		TOGGLE_FULLSCREEN,
		TOGGLE_MAXIMIZED,
		TOGGLE_TILED_LEFT,
		TOGGLE_TILED_RIGHT,
		TOGGLE_ABOVE,
		MAXIMIZE,
		UNMAXIMIZE,
		TOGGLE_SHADED,
		MINIMIZE,
		CLOSE,
		BEGIN_MOVE,
		BEGIN_RESIZE,
		TOGGLE_ON_ALL_WORKSPACES,
		MOVE_TO_WORKSPACE_1,
		MOVE_TO_WORKSPACE_2,
		MOVE_TO_WORKSPACE_3,
		MOVE_TO_WORKSPACE_4,
		MOVE_TO_WORKSPACE_5,
		MOVE_TO_WORKSPACE_6,
		MOVE_TO_WORKSPACE_7,
		MOVE_TO_WORKSPACE_8,
		MOVE_TO_WORKSPACE_9,
		MOVE_TO_WORKSPACE_10,
		MOVE_TO_WORKSPACE_11,
		MOVE_TO_WORKSPACE_12,
		MOVE_TO_WORKSPACE_LEFT,
		MOVE_TO_WORKSPACE_RIGHT,
		MOVE_TO_WORKSPACE_UP,
		MOVE_TO_WORKSPACE_DOWN,
		MOVE_TO_WORKSPACE_LAST,
		MOVE_TO_MONITOR_LEFT,
		MOVE_TO_MONITOR_RIGHT,
		MOVE_TO_MONITOR_UP,
		MOVE_TO_MONITOR_DOWN,
		RAISE_OR_LOWER,
		RAISE,
		LOWER,
		MAXIMIZE_VERTICALLY,
		MAXIMIZE_HORIZONTALLY,
		MOVE_TO_CORNER_NW,
		MOVE_TO_CORNER_NE,
		MOVE_TO_CORNER_SW,
		MOVE_TO_CORNER_SE,
		MOVE_TO_SIDE_N,
		MOVE_TO_SIDE_S,
		MOVE_TO_SIDE_E,
		MOVE_TO_SIDE_W,
		MOVE_TO_CENTER,
		OVERLAY_KEY,
		ISO_NEXT_GROUP,
		ALWAYS_ON_TOP,
		LAST
	}
	[CCode (cheader_filename = "meta/prefs.h", cprefix = "META_KEY_BINDING_", type_id = "meta_key_binding_flags_get_type ()")]
	[Flags]
	public enum KeyBindingFlags {
		NONE,
		PER_WINDOW,
		BUILTIN,
		IS_REVERSED
	}
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_LATER_", type_id = "meta_later_type_get_type ()")]
	public enum LaterType {
		RESIZE,
		CALC_SHOWING,
		CHECK_FULLSCREEN,
		SYNC_STACK,
		BEFORE_REDRAW,
		IDLE
	}
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_LOCALE_DIRECTION_", type_id = "meta_locale_direction_get_type ()")]
	public enum LocaleDirection {
		LTR,
		RTL
	}
	[CCode (cheader_filename = "meta/window.h", cprefix = "META_MAXIMIZE_", type_id = "meta_maximize_flags_get_type ()")]
	[Flags]
	public enum MaximizeFlags {
		HORIZONTAL,
		VERTICAL,
		BOTH
	}
	[CCode (cheader_filename = "meta/meta-plugin.h", cprefix = "META_MODAL_", type_id = "meta_modal_options_get_type ()")]
	[Flags]
	public enum ModalOptions {
		POINTER_ALREADY_GRABBED,
		KEYBOARD_ALREADY_GRABBED
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_MOTION_", type_id = "meta_motion_direction_get_type ()")]
	public enum MotionDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT,
		UP_LEFT,
		UP_RIGHT,
		DOWN_LEFT,
		DOWN_RIGHT
	}
	[CCode (cheader_filename = "meta/prefs.h", cprefix = "META_PREF_", type_id = "meta_preference_get_type ()")]
	public enum Preference {
		MOUSE_BUTTON_MODS,
		FOCUS_MODE,
		FOCUS_NEW_WINDOWS,
		ATTACH_MODAL_DIALOGS,
		RAISE_ON_CLICK,
		ACTION_DOUBLE_CLICK_TITLEBAR,
		ACTION_MIDDLE_CLICK_TITLEBAR,
		ACTION_RIGHT_CLICK_TITLEBAR,
		AUTO_RAISE,
		AUTO_RAISE_DELAY,
		FOCUS_CHANGE_ON_POINTER_REST,
		TITLEBAR_FONT,
		NUM_WORKSPACES,
		DYNAMIC_WORKSPACES,
		KEYBINDINGS,
		DISABLE_WORKAROUNDS,
		BUTTON_LAYOUT,
		WORKSPACE_NAMES,
		VISUAL_BELL,
		AUDIBLE_BELL,
		VISUAL_BELL_TYPE,
		GNOME_ACCESSIBILITY,
		GNOME_ANIMATIONS,
		CURSOR_THEME,
		CURSOR_SIZE,
		RESIZE_WITH_RIGHT_BUTTON,
		EDGE_TILING,
		FORCE_FULLSCREEN,
		WORKSPACES_ONLY_ON_PRIMARY,
		DRAGGABLE_BORDER_WIDTH,
		AUTO_MAXIMIZE,
		CENTER_NEW_WINDOWS,
		DRAG_THRESHOLD;
		[CCode (cheader_filename = "meta/main.h")]
		public static unowned string to_string (Meta.Preference pref);
	}
	[CCode (cheader_filename = "meta/screen.h", cprefix = "META_SCREEN_", type_id = "meta_screen_corner_get_type ()")]
	public enum ScreenCorner {
		TOPLEFT,
		TOPRIGHT,
		BOTTOMLEFT,
		BOTTOMRIGHT
	}
	[CCode (cheader_filename = "meta/meta-enum-types.h", cprefix = "META_SCREEN_", type_id = "meta_screen_direction_get_type ()")]
	public enum ScreenDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "meta/meta-enum-types.h", cprefix = "META_SHADOW_MODE_", type_id = "meta_shadow_mode_get_type ()")]
	public enum ShadowMode {
		AUTO,
		FORCED_OFF,
		FORCED_ON
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_SIDE_", type_id = "meta_side_get_type ()")]
	public enum Side {
		LEFT,
		RIGHT,
		TOP,
		BOTTOM
	}
	[CCode (cheader_filename = "meta/meta-enum-types.h", cprefix = "META_SIZE_CHANGE_", type_id = "meta_size_change_get_type ()")]
	public enum SizeChange {
		MAXIMIZE,
		UNMAXIMIZE,
		FULLSCREEN,
		UNFULLSCREEN
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_LAYER_", type_id = "meta_stack_layer_get_type ()")]
	public enum StackLayer {
		DESKTOP,
		BOTTOM,
		NORMAL,
		TOP,
		DOCK,
		FULLSCREEN,
		FOCUSED_WINDOW,
		OVERRIDE_REDIRECT,
		LAST
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_TAB_LIST_", type_id = "meta_tab_list_get_type ()")]
	public enum TabList {
		NORMAL,
		DOCKS,
		GROUP,
		NORMAL_ALL
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_TAB_SHOW_", type_id = "meta_tab_show_type_get_type ()")]
	public enum TabShowType {
		ICON,
		INSTANTLY
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_VIRTUAL_", type_id = "meta_virtual_modifier_get_type ()")]
	[Flags]
	public enum VirtualModifier {
		SHIFT_MASK,
		CONTROL_MASK,
		ALT_MASK,
		META_MASK,
		SUPER_MASK,
		HYPER_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK
	}
	[CCode (cheader_filename = "meta/window.h", cprefix = "META_WINDOW_CLIENT_TYPE_", type_id = "meta_window_client_type_get_type ()")]
	public enum WindowClientType {
		WAYLAND,
		X11
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_WINDOW_MENU_", type_id = "meta_window_menu_type_get_type ()")]
	public enum WindowMenuType {
		WM,
		APP
	}
	[CCode (cheader_filename = "meta/window.h", cprefix = "META_WINDOW_", type_id = "meta_window_type_get_type ()")]
	public enum WindowType {
		NORMAL,
		DESKTOP,
		DOCK,
		DIALOG,
		MODAL_DIALOG,
		TOOLBAR,
		MENU,
		UTILITY,
		SPLASHSCREEN,
		DROPDOWN_MENU,
		POPUP_MENU,
		TOOLTIP,
		NOTIFICATION,
		COMBO,
		DND,
		OVERRIDE_OTHER
	}
	[CCode (cheader_filename = "meta/meta-idle-monitor.h", instance_pos = 2.9)]
	public delegate void IdleMonitorWatchFunc (Meta.IdleMonitor monitor, uint watch_id);
	[CCode (cheader_filename = "meta/prefs.h", instance_pos = 5.9)]
	public delegate void KeyHandlerFunc (Meta.Display display, Meta.Screen screen, Meta.Window? window, Clutter.KeyEvent? event, Meta.KeyBinding binding);
	[CCode (cheader_filename = "meta/prefs.h", instance_pos = 1.9)]
	public delegate void PrefsChangedFunc (Meta.Preference pref);
	[CCode (cheader_filename = "meta/window.h", instance_pos = 1.9)]
	public delegate bool WindowForeachFunc (Meta.Window window);
	[CCode (cheader_filename = "meta/main.h", cname = "META_DEFAULT_ICON_NAME")]
	public const string DEFAULT_ICON_NAME;
	[CCode (cheader_filename = "meta/main.h", cname = "META_ICON_HEIGHT")]
	public const int ICON_HEIGHT;
	[CCode (cheader_filename = "meta/main.h", cname = "META_ICON_WIDTH")]
	public const int ICON_WIDTH;
	[CCode (cheader_filename = "meta/main.h", cname = "META_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "meta/main.h", cname = "META_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "meta/main.h", cname = "META_MINI_ICON_HEIGHT")]
	public const int MINI_ICON_HEIGHT;
	[CCode (cheader_filename = "meta/main.h", cname = "META_MINI_ICON_WIDTH")]
	public const int MINI_ICON_WIDTH;
	[CCode (cheader_filename = "meta/main.h", cname = "META_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "meta/main.h", cname = "META_PLUGIN_API_VERSION")]
	public const int PLUGIN_API_VERSION;
	[CCode (cheader_filename = "meta/main.h", cname = "META_PRIORITY_BEFORE_REDRAW")]
	public const int PRIORITY_BEFORE_REDRAW;
	[CCode (cheader_filename = "meta/main.h", cname = "META_PRIORITY_PREFS_NOTIFY")]
	public const int PRIORITY_PREFS_NOTIFY;
	[CCode (cheader_filename = "meta/main.h", cname = "META_PRIORITY_REDRAW")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "meta/main.h", cname = "META_PRIORITY_RESIZE")]
	public const int PRIORITY_RESIZE;
	[CCode (cheader_filename = "meta/main.h", cname = "META_VIRTUAL_CORE_KEYBOARD_ID")]
	public const int VIRTUAL_CORE_KEYBOARD_ID;
	[CCode (cheader_filename = "meta/main.h", cname = "META_VIRTUAL_CORE_POINTER_ID")]
	public const int VIRTUAL_CORE_POINTER_ID;
	[CCode (cheader_filename = "meta/main.h")]
	public static bool activate_session ();
 	[CCode (cheader_filename = "meta/main.h")]
	public static void clutter_init ();
	[CCode (cheader_filename = "meta/main.h")]
	public static void exit (Meta.ExitCode code);
	[CCode (cheader_filename = "meta/main.h")]
	public static unowned GLib.OptionContext get_option_context ();
	[CCode (cheader_filename = "meta/main.h")]
	public static bool get_replace_current_wm ();
	[CCode (cheader_filename = "meta/main.h")]
	public static void init ();
	[CCode (cheader_filename = "meta/main.h")]
	public static bool is_restart ();
	[CCode (cheader_filename = "meta/main.h")]
	public static void quit (Meta.ExitCode code);
	[CCode (cheader_filename = "meta/main.h")]
	public static void register_with_session ();
 	[CCode (cheader_filename = "meta/main.h")]
	public static void restart (string message);
	[CCode (cheader_filename = "meta/main.h")]
	public static int run ();
	[CCode (cheader_filename = "meta/main.h")]
	public static void set_gnome_wm_keybindings (string wm_keybindings);
	[CCode (cheader_filename = "meta/main.h")]
	public static void set_wm_name (string wm_name);
}
