+++
title = "Cross-correlation"
weight = 13
+++

# Inter-interface correlation

The correlation between different interfaces
is an optional argument of the `Roughness` constructor.

It can be specified through one of

```python
ba.SpatialFrequencyCrosscorrelation(base_crosscorr_depth, base_frequency, power)
ba.CommonDepthCrosscorrelation(cross_corr_depth)
```

Cross-correlation models determine interaction of the current interface with
_underlying_ ones.

If the interface is already using [linear growth model](../interface), the other
cross-correlation settings are not needed.

### "Spatial frequency" model 

```python
ba.SpatialFrequencyCrosscorrelation(base_crosscorr_depth, base_frequency, power)
```

- `base_crosscorr_depth`, $\xi\_{\perp base}$, is the vertical distance over
which the correlation of rougness spectrum at base spatial frequency
$\nu_{base}$ between interfaces is damped by a factor $1/e$,
- `base_frequency`, $\nu_{base}$, is a spatial frequency, for which the
correlation of rougness spectrum between interfaces is damped by a factor
$1/e$ at vertical distance $\xi\_{\perp base}$,
- `power`, $p$, is a degree that determines the dependence of cross-correlation
on spatial frequency.

Cross-correlation spectrum between interfaces $i$ and $j$ is

$$
S_{ij}(\nu)=\sqrt{S_i(\nu)S_j(\nu)} exp[-\dfrac{t}{\xi\_{\perp base}}
\Big(\dfrac{\nu}{\nu_{base}}\Big)^p]
$$

where
$t$ - distance between interfaces,
$S_i(\nu),S_j(\nu)$ - autocorrelation spectra.

### "Common depth" model

```python
ba.CommonDepthCrosscorrelation(cross_corr_depth)
```

- `cross_corr_depth`, $\xi\_{\perp}$, is the vertical distance over
which the correlation is damped by a factor $1/e$

Subcase of "Spatial frequency" model without dependence on spatial frequency.

Cross-correlation spectrum between interfaces $i$ and $j$ is

$$
S_{ij}(\nu)=\sqrt{S_i(\nu)S_j(\nu)} exp[-\dfrac{t}{\xi\_{\perp}}]
$$
where
$t$ - distance between interfaces,
$S_i(\nu),S_j(\nu)$ - autocorrelation spectra.

[Example](../xcorr/scatter) of script using this model.

