+++
title = "Detector2D"
weight = 10
+++

## Detector2D

For SAS and GISAS simulations,
the two-dimensional area detector is modelled by
the {{% ref-class "Device/Detector" "Detector2D" %}} class.

### Geometry

A `Detector2D` is a flat rectangular detector.
All pixels have equal size.

{{< figscg src="/img/draw/detector1.svg" width="100%" >}}

In BornAgain, detector images are shown as seen from the back of the detector.
In this way we ensure that the $\varphi$ or $q_y$ axis has the same
orientation as the real-space $y$ axis.

For plotting and data import and export,
BornAgain pretends that the detector bins correspond to
bins of constant width in $\varphi$ or $q_y$ and  $\alpha$ or $q_z$,
even though this is only true in first approximation.

For the actual scattering computation, BornAgain uses true scattering angles,
computed as nonlinear functions of the pixel coordinates.

Further distortions arise
if the detector is not perpendicular to the `x` axis.
This is not unlikely in GISAS
where it makes sense to position the detector perpendicular
to the reflected or transmitted beam.
Corrections for these and other distortions will be implemented
when requested by users.

### Constructor

The constructor has the signature
```
detector = ba.Detector2D(phi_span, alpha_span, n_phi, n_alpha, phi_center, alpha_center)
```

The arguments `phi_span, alpha_span` are the full width of the detector in
directions $\varphi_\text{f},\alpha_\text{f}$.

The arguments `n_phi, n_alpha` are the number of bins per direction;
their product is the number of pixels of the detector.

The arguments `phi_center, alpha_center` are the scattering angles
$\varphi_\text{f},\alpha_\text{f}$ at the center of the detector.

### Masks

When fitting theoretical models to measured diffraction images,
it can be helpful to mask part of the detector area.
See

* [Fit with masks](/ex/fit/fit-with-masks)

### Resolution

For modeling the detector resolution, see [Detector resolution](/ref/instr/det/resolution).

### History

Until BornAgain 21, we had a `RectangularDetector` and a `SphericalDetector`.
In BornAgain 22, they were merged into a new `Detector2D` class.
